package jp.gr.java_conf.abagames.narihira.relaxer;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>Position</b> is generated by Relaxer based on narihira.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule role="position">
 *   <sequence occurs="*">
 *     <ref label="p"/>
 *   </sequence>
 * </elementRule>
 * 
 * <tag name="position"/>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule role="position"&gt;
 *   &lt;sequence occurs="*"&gt;
 *     &lt;ref label="p"/&gt;
 *   &lt;/sequence&gt;
 * &lt;/elementRule&gt;
 * &lt;tag name="position"/&gt;
 * </pre>
 *
 * @version narihira.rlx 0.01 (Fri Feb 08 22:06:20 JST 2002)
 * @author  Relaxer 0.16 (http://www.relaxer.org)
 */
public class Position implements java.io.Serializable {
    // List<Sequence4>
    private java.util.List sequence4_ = new java.util.ArrayList();

    /**
     * Creates a <code>Position</code>.
     *
     */
    public Position() {
    }

    /**
     * Creates a <code>Position</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public Position(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>Position</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public Position(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>Position</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public Position(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>Position</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Position(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>Position</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Position(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>Position</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Position(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>Position</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Position(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>Position</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Position(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>Position</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Position(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>Position</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>Position</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>Position</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        sequence4_.clear();
        while (!stack.isEmptyElement()) {
            Sequence4 node = new Sequence4(stack);
            if (node == null) {
                break;
            }
            addSequence4(node);
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("position");
        int size;
        size = this.sequence4_.size();
        for (int i = 0;i < size;i++) {
            Sequence4 value = (Sequence4)this.sequence4_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>Position</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>Position</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Position</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Position</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Position</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Position</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the Sequence4 property <b>sequence4</b>.
     *
     * @return Sequence4[]
     */
    public final Sequence4[] getSequence4() {
        Sequence4[] array = new Sequence4[sequence4_.size()];
        return ((Sequence4[])sequence4_.toArray(array));
    }

    /**
     * Sets the Sequence4 property <b>sequence4</b>.
     *
     * @param sequence4
     */
    public final void setSequence4(Sequence4[] sequence4) {
        this.sequence4_.clear();
        this.sequence4_.addAll(java.util.Arrays.asList(sequence4));
    }

    /**
     * Sets the Sequence4 property <b>sequence4</b>.
     *
     * @param sequence4
     */
    public final void setSequence4(Sequence4 sequence4) {
        this.sequence4_.clear();
        this.sequence4_.add(sequence4);
    }

    /**
     * Adds the Sequence4 property <b>sequence4</b>.
     *
     * @param sequence4
     */
    public final void addSequence4(Sequence4 sequence4) {
        this.sequence4_.add(sequence4);
    }

    /**
     * Gets number of the Sequence4 property <b>sequence4</b>.
     *
     * @return int
     */
    public final int getSequence4Count() {
        return (sequence4_.size());
    }

    /**
     * Gets the Sequence4 property <b>sequence4</b> by index.
     *
     * @param index
     * @return Sequence4
     */
    public final Sequence4 getSequence4(int index) {
        return ((Sequence4)sequence4_.get(index));
    }

    /**
     * Sets the Sequence4 property <b>sequence4</b> by index.
     *
     * @param index
     * @param sequence4
     */
    public final void setSequence4(int index, Sequence4 sequence4) {
        this.sequence4_.set(index, sequence4);
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<position");
        buffer.append(">");
        size = this.sequence4_.size();
        for (int i = 0;i < size;i++) {
            Sequence4 value = (Sequence4)this.sequence4_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</position>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<position");
        buffer.print(">");
        size = this.sequence4_.size();
        for (int i = 0;i < size;i++) {
            Sequence4 value = (Sequence4)this.sequence4_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</position>");
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>Position</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "position")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        while (!target.isEmptyElement()) {
            if (!Sequence4.isMatchHungry(target)) {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Position</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Position</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
