package jp.gr.java_conf.abagames.narihira.relaxer;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>Obstacle</b> is generated by Relaxer based on narihira.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule role="obstacle">
 *   <sequence occurs="*">
 *     <ref label="o"/>
 *   </sequence>
 * </elementRule>
 * 
 * <tag name="obstacle"/>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule role="obstacle"&gt;
 *   &lt;sequence occurs="*"&gt;
 *     &lt;ref label="o"/&gt;
 *   &lt;/sequence&gt;
 * &lt;/elementRule&gt;
 * &lt;tag name="obstacle"/&gt;
 * </pre>
 *
 * @version narihira.rlx 0.01 (Fri Feb 08 22:06:20 JST 2002)
 * @author  Relaxer 0.16 (http://www.relaxer.org)
 */
public class Obstacle implements java.io.Serializable {
    // List<Sequence3>
    private java.util.List sequence3_ = new java.util.ArrayList();

    /**
     * Creates a <code>Obstacle</code>.
     *
     */
    public Obstacle() {
    }

    /**
     * Creates a <code>Obstacle</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public Obstacle(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>Obstacle</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public Obstacle(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>Obstacle</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public Obstacle(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>Obstacle</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Obstacle(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>Obstacle</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Obstacle(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>Obstacle</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Obstacle(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>Obstacle</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Obstacle(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>Obstacle</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Obstacle(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>Obstacle</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Obstacle(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>Obstacle</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>Obstacle</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>Obstacle</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        sequence3_.clear();
        while (!stack.isEmptyElement()) {
            Sequence3 node = new Sequence3(stack);
            if (node == null) {
                break;
            }
            addSequence3(node);
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("obstacle");
        int size;
        size = this.sequence3_.size();
        for (int i = 0;i < size;i++) {
            Sequence3 value = (Sequence3)this.sequence3_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>Obstacle</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>Obstacle</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Obstacle</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Obstacle</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Obstacle</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Obstacle</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the Sequence3 property <b>sequence3</b>.
     *
     * @return Sequence3[]
     */
    public final Sequence3[] getSequence3() {
        Sequence3[] array = new Sequence3[sequence3_.size()];
        return ((Sequence3[])sequence3_.toArray(array));
    }

    /**
     * Sets the Sequence3 property <b>sequence3</b>.
     *
     * @param sequence3
     */
    public final void setSequence3(Sequence3[] sequence3) {
        this.sequence3_.clear();
        this.sequence3_.addAll(java.util.Arrays.asList(sequence3));
    }

    /**
     * Sets the Sequence3 property <b>sequence3</b>.
     *
     * @param sequence3
     */
    public final void setSequence3(Sequence3 sequence3) {
        this.sequence3_.clear();
        this.sequence3_.add(sequence3);
    }

    /**
     * Adds the Sequence3 property <b>sequence3</b>.
     *
     * @param sequence3
     */
    public final void addSequence3(Sequence3 sequence3) {
        this.sequence3_.add(sequence3);
    }

    /**
     * Gets number of the Sequence3 property <b>sequence3</b>.
     *
     * @return int
     */
    public final int getSequence3Count() {
        return (sequence3_.size());
    }

    /**
     * Gets the Sequence3 property <b>sequence3</b> by index.
     *
     * @param index
     * @return Sequence3
     */
    public final Sequence3 getSequence3(int index) {
        return ((Sequence3)sequence3_.get(index));
    }

    /**
     * Sets the Sequence3 property <b>sequence3</b> by index.
     *
     * @param index
     * @param sequence3
     */
    public final void setSequence3(int index, Sequence3 sequence3) {
        this.sequence3_.set(index, sequence3);
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<obstacle");
        buffer.append(">");
        size = this.sequence3_.size();
        for (int i = 0;i < size;i++) {
            Sequence3 value = (Sequence3)this.sequence3_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</obstacle>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<obstacle");
        buffer.print(">");
        size = this.sequence3_.size();
        for (int i = 0;i < size;i++) {
            Sequence3 value = (Sequence3)this.sequence3_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</obstacle>");
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>Obstacle</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "obstacle")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        while (!target.isEmptyElement()) {
            if (!Sequence3.isMatchHungry(target)) {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Obstacle</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Obstacle</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
