package jp.gr.java_conf.abagames.narihira.relaxer;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>O</b> is generated by Relaxer based on narihira.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule role="o" type="string"/>
 * 
 * <tag name="o">
 *   <attribute name="x" required="true" type="string"/>
 *   <attribute name="y" required="true" type="string"/>
 *   <attribute name="w" required="true" type="string"/>
 *   <attribute name="h" required="true" type="string"/>
 *   <attribute name="scroll" type="string"/>
 * </tag>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule role="o" type="string"/&gt;
 * &lt;tag name="o"&gt;
 *   &lt;attribute name="x" required="true" type="string"/&gt;
 *   &lt;attribute name="y" required="true" type="string"/&gt;
 *   &lt;attribute name="w" required="true" type="string"/&gt;
 *   &lt;attribute name="h" required="true" type="string"/&gt;
 *   &lt;attribute name="scroll" type="string"/&gt;
 * &lt;/tag&gt;
 * </pre>
 *
 * @version narihira.rlx 0.01 (Fri Feb 08 22:06:20 JST 2002)
 * @author  Relaxer 0.16 (http://www.relaxer.org)
 */
public class O implements java.io.Serializable {
    private String content_;
    private String x_;
    private String y_;
    private String w_;
    private String h_;
    private String scroll_;

    /**
     * Creates a <code>O</code>.
     *
     */
    public O() {
    }

    /**
     * Creates a <code>O</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public O(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>O</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public O(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>O</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public O(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>O</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public O(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>O</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public O(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>O</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public O(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>O</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public O(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>O</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public O(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>O</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public O(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>O</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>O</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>O</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        content_ = URelaxer.getElementPropertyAsString(element);
        x_ = URelaxer.getAttributePropertyAsString(element, "x");
        y_ = URelaxer.getAttributePropertyAsString(element, "y");
        w_ = URelaxer.getAttributePropertyAsString(element, "w");
        h_ = URelaxer.getAttributePropertyAsString(element, "h");
        scroll_ = URelaxer.getAttributePropertyAsString(element, "scroll");
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("o");
        URelaxer.setElementPropertyByString(element, this.content_);
        int size;
        URelaxer.setAttributePropertyByString(element, "x", this.x_);
        URelaxer.setAttributePropertyByString(element, "y", this.y_);
        URelaxer.setAttributePropertyByString(element, "w", this.w_);
        URelaxer.setAttributePropertyByString(element, "h", this.h_);
        if (this.scroll_ != null) {
            URelaxer.setAttributePropertyByString(element, "scroll", this.scroll_);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>O</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>O</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>O</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>O</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>O</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>O</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>content</b>.
     *
     * @return String
     */
    public final String getContent() {
        return (content_);
    }

    /**
     * Sets the String property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(String content) {
        this.content_ = content;
    }

    /**
     * Gets the String property <b>x</b>.
     *
     * @return String
     */
    public final String getX() {
        return (x_);
    }

    /**
     * Sets the String property <b>x</b>.
     *
     * @param x
     */
    public final void setX(String x) {
        this.x_ = x;
    }

    /**
     * Gets the String property <b>y</b>.
     *
     * @return String
     */
    public final String getY() {
        return (y_);
    }

    /**
     * Sets the String property <b>y</b>.
     *
     * @param y
     */
    public final void setY(String y) {
        this.y_ = y;
    }

    /**
     * Gets the String property <b>w</b>.
     *
     * @return String
     */
    public final String getW() {
        return (w_);
    }

    /**
     * Sets the String property <b>w</b>.
     *
     * @param w
     */
    public final void setW(String w) {
        this.w_ = w;
    }

    /**
     * Gets the String property <b>h</b>.
     *
     * @return String
     */
    public final String getH() {
        return (h_);
    }

    /**
     * Sets the String property <b>h</b>.
     *
     * @param h
     */
    public final void setH(String h) {
        this.h_ = h;
    }

    /**
     * Gets the String property <b>scroll</b>.
     *
     * @return String
     */
    public final String getScroll() {
        return (scroll_);
    }

    /**
     * Sets the String property <b>scroll</b>.
     *
     * @param scroll
     */
    public final void setScroll(String scroll) {
        this.scroll_ = scroll;
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<o");
        buffer.append(" x=\"");
        buffer.append(URelaxer.escapeAttrQuot(getX()));
        buffer.append("\"");
        buffer.append(" y=\"");
        buffer.append(URelaxer.escapeAttrQuot(getY()));
        buffer.append("\"");
        buffer.append(" w=\"");
        buffer.append(URelaxer.escapeAttrQuot(getW()));
        buffer.append("\"");
        buffer.append(" h=\"");
        buffer.append(URelaxer.escapeAttrQuot(getH()));
        buffer.append("\"");
        if (scroll_ != null) {
            buffer.append(" scroll=\"");
            buffer.append(URelaxer.escapeAttrQuot(getScroll()));
            buffer.append("\"");
        }
        buffer.append(">");
        buffer.append(URelaxer.escapeCharData(getContent()));
        buffer.append("</o>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<o");
        buffer.print(" x=\"");
        buffer.print(URelaxer.escapeAttrQuot(getX()));
        buffer.print("\"");
        buffer.print(" y=\"");
        buffer.print(URelaxer.escapeAttrQuot(getY()));
        buffer.print("\"");
        buffer.print(" w=\"");
        buffer.print(URelaxer.escapeAttrQuot(getW()));
        buffer.print("\"");
        buffer.print(" h=\"");
        buffer.print(URelaxer.escapeAttrQuot(getH()));
        buffer.print("\"");
        if (scroll_ != null) {
            buffer.print(" scroll=\"");
            buffer.print(URelaxer.escapeAttrQuot(getScroll()));
            buffer.print("\"");
        }
        buffer.print(">");
        buffer.print(URelaxer.escapeCharData(getContent()));
        buffer.print("</o>");
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getXAsString() {
        return (URelaxer.getString(getX()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getYAsString() {
        return (URelaxer.getString(getY()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getWAsString() {
        return (URelaxer.getString(getW()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getHAsString() {
        return (URelaxer.getString(getH()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getScrollAsString() {
        return (URelaxer.getString(getScroll()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setXByString(String string) {
        setX(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setYByString(String string) {
        setY(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setWByString(String string) {
        setW(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setHByString(String string) {
        setH(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setScrollByString(String string) {
        setScroll(string);
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>O</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "o")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>O</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>O</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
