package jp.gr.java_conf.abagames.narihira.relaxer;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>Narihira</b> is generated by Relaxer based on narihira.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule role="narihira">
 *   <sequence>
 *     <ref label="scroll" occurs="?"/>
 *     <ref label="obstacle" occurs="?"/>
 *     <ref label="battery" occurs="?"/>
 *   </sequence>
 * </elementRule>
 * 
 * <tag name="narihira">
 *   <attribute name="xmlns" type="string"/>
 * </tag>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule role="narihira"&gt;
 *   &lt;sequence&gt;
 *     &lt;ref label="scroll" occurs="?"/&gt;
 *     &lt;ref label="obstacle" occurs="?"/&gt;
 *     &lt;ref label="battery" occurs="?"/&gt;
 *   &lt;/sequence&gt;
 * &lt;/elementRule&gt;
 * &lt;tag name="narihira"&gt;
 *   &lt;attribute name="xmlns" type="string"/&gt;
 * &lt;/tag&gt;
 * </pre>
 *
 * @version narihira.rlx 0.01 (Fri Feb 08 22:06:20 JST 2002)
 * @author  Relaxer 0.16 (http://www.relaxer.org)
 */
public class Narihira implements java.io.Serializable {
    private String xmlns_;
    private Scroll scroll_;
    private Obstacle obstacle_;
    private Battery battery_;

    /**
     * Creates a <code>Narihira</code>.
     *
     */
    public Narihira() {
    }

    /**
     * Creates a <code>Narihira</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public Narihira(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>Narihira</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public Narihira(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>Narihira</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public Narihira(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>Narihira</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Narihira(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>Narihira</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Narihira(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>Narihira</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Narihira(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>Narihira</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Narihira(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>Narihira</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Narihira(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>Narihira</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Narihira(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>Narihira</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>Narihira</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>Narihira</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        xmlns_ = URelaxer.getAttributePropertyAsString(element, "xmlns");
        if (Scroll.isMatch(stack)) {
            setScroll(new Scroll(stack));
        }
        if (Obstacle.isMatch(stack)) {
            setObstacle(new Obstacle(stack));
        }
        if (Battery.isMatch(stack)) {
            setBattery(new Battery(stack));
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("narihira");
        int size;
        if (this.xmlns_ != null) {
            URelaxer.setAttributePropertyByString(element, "xmlns", this.xmlns_);
        }
        if (this.scroll_ != null) {
            this.scroll_.makeElement(element);
        }
        if (this.obstacle_ != null) {
            this.obstacle_.makeElement(element);
        }
        if (this.battery_ != null) {
            this.battery_.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>Narihira</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>Narihira</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Narihira</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Narihira</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Narihira</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Narihira</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>xmlns</b>.
     *
     * @return String
     */
    public final String getXmlns() {
        return (xmlns_);
    }

    /**
     * Sets the String property <b>xmlns</b>.
     *
     * @param xmlns
     */
    public final void setXmlns(String xmlns) {
        this.xmlns_ = xmlns;
    }

    /**
     * Gets the Scroll property <b>scroll</b>.
     *
     * @return Scroll
     */
    public final Scroll getScroll() {
        return (scroll_);
    }

    /**
     * Sets the Scroll property <b>scroll</b>.
     *
     * @param scroll
     */
    public final void setScroll(Scroll scroll) {
        this.scroll_ = scroll;
    }

    /**
     * Gets the Obstacle property <b>obstacle</b>.
     *
     * @return Obstacle
     */
    public final Obstacle getObstacle() {
        return (obstacle_);
    }

    /**
     * Sets the Obstacle property <b>obstacle</b>.
     *
     * @param obstacle
     */
    public final void setObstacle(Obstacle obstacle) {
        this.obstacle_ = obstacle;
    }

    /**
     * Gets the Battery property <b>battery</b>.
     *
     * @return Battery
     */
    public final Battery getBattery() {
        return (battery_);
    }

    /**
     * Sets the Battery property <b>battery</b>.
     *
     * @param battery
     */
    public final void setBattery(Battery battery) {
        this.battery_ = battery;
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<narihira");
        if (xmlns_ != null) {
            buffer.append(" xmlns=\"");
            buffer.append(URelaxer.escapeAttrQuot(getXmlns()));
            buffer.append("\"");
        }
        buffer.append(">");
        if (scroll_ != null) {
            scroll_.makeTextElement(buffer);
        }
        if (obstacle_ != null) {
            obstacle_.makeTextElement(buffer);
        }
        if (battery_ != null) {
            battery_.makeTextElement(buffer);
        }
        buffer.append("</narihira>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<narihira");
        if (xmlns_ != null) {
            buffer.print(" xmlns=\"");
            buffer.print(URelaxer.escapeAttrQuot(getXmlns()));
            buffer.print("\"");
        }
        buffer.print(">");
        if (scroll_ != null) {
            scroll_.makeTextElement(buffer);
        }
        if (obstacle_ != null) {
            obstacle_.makeTextElement(buffer);
        }
        if (battery_ != null) {
            battery_.makeTextElement(buffer);
        }
        buffer.print("</narihira>");
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getXmlnsAsString() {
        return (URelaxer.getString(getXmlns()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setXmlnsByString(String string) {
        setXmlns(string);
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>Narihira</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "narihira")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        if (Scroll.isMatchHungry(target)) {
        }
        if (Obstacle.isMatchHungry(target)) {
        }
        if (Battery.isMatchHungry(target)) {
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Narihira</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Narihira</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
