package jp.gr.java_conf.abagames.narihira.relaxer;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>Battery</b> is generated by Relaxer based on narihira.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule role="battery">
 *   <sequence occurs="*">
 *     <ref label="b"/>
 *   </sequence>
 * </elementRule>
 * 
 * <tag name="battery"/>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule role="battery"&gt;
 *   &lt;sequence occurs="*"&gt;
 *     &lt;ref label="b"/&gt;
 *   &lt;/sequence&gt;
 * &lt;/elementRule&gt;
 * &lt;tag name="battery"/&gt;
 * </pre>
 *
 * @version narihira.rlx 0.01 (Fri Feb 08 22:06:20 JST 2002)
 * @author  Relaxer 0.16 (http://www.relaxer.org)
 */
public class Battery implements java.io.Serializable {
    // List<Sequence1>
    private java.util.List sequence1_ = new java.util.ArrayList();

    /**
     * Creates a <code>Battery</code>.
     *
     */
    public Battery() {
    }

    /**
     * Creates a <code>Battery</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public Battery(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>Battery</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public Battery(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>Battery</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public Battery(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>Battery</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Battery(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>Battery</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Battery(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>Battery</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Battery(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>Battery</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Battery(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>Battery</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Battery(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>Battery</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Battery(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>Battery</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>Battery</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>Battery</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        sequence1_.clear();
        while (!stack.isEmptyElement()) {
            Sequence1 node = new Sequence1(stack);
            if (node == null) {
                break;
            }
            addSequence1(node);
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("battery");
        int size;
        size = this.sequence1_.size();
        for (int i = 0;i < size;i++) {
            Sequence1 value = (Sequence1)this.sequence1_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>Battery</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>Battery</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Battery</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Battery</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Battery</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Battery</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the Sequence1 property <b>sequence1</b>.
     *
     * @return Sequence1[]
     */
    public final Sequence1[] getSequence1() {
        Sequence1[] array = new Sequence1[sequence1_.size()];
        return ((Sequence1[])sequence1_.toArray(array));
    }

    /**
     * Sets the Sequence1 property <b>sequence1</b>.
     *
     * @param sequence1
     */
    public final void setSequence1(Sequence1[] sequence1) {
        this.sequence1_.clear();
        this.sequence1_.addAll(java.util.Arrays.asList(sequence1));
    }

    /**
     * Sets the Sequence1 property <b>sequence1</b>.
     *
     * @param sequence1
     */
    public final void setSequence1(Sequence1 sequence1) {
        this.sequence1_.clear();
        this.sequence1_.add(sequence1);
    }

    /**
     * Adds the Sequence1 property <b>sequence1</b>.
     *
     * @param sequence1
     */
    public final void addSequence1(Sequence1 sequence1) {
        this.sequence1_.add(sequence1);
    }

    /**
     * Gets number of the Sequence1 property <b>sequence1</b>.
     *
     * @return int
     */
    public final int getSequence1Count() {
        return (sequence1_.size());
    }

    /**
     * Gets the Sequence1 property <b>sequence1</b> by index.
     *
     * @param index
     * @return Sequence1
     */
    public final Sequence1 getSequence1(int index) {
        return ((Sequence1)sequence1_.get(index));
    }

    /**
     * Sets the Sequence1 property <b>sequence1</b> by index.
     *
     * @param index
     * @param sequence1
     */
    public final void setSequence1(int index, Sequence1 sequence1) {
        this.sequence1_.set(index, sequence1);
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<battery");
        buffer.append(">");
        size = this.sequence1_.size();
        for (int i = 0;i < size;i++) {
            Sequence1 value = (Sequence1)this.sequence1_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</battery>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<battery");
        buffer.print(">");
        size = this.sequence1_.size();
        for (int i = 0;i < size;i++) {
            Sequence1 value = (Sequence1)this.sequence1_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</battery>");
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>Battery</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "battery")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        while (!target.isEmptyElement()) {
            if (!Sequence1.isMatchHungry(target)) {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Battery</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Battery</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
