package jp.gr.java_conf.abagames.narihira.relaxer;

import java.io.*;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>B</b> is generated by Relaxer based on narihira.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule role="b" type="string"/>
 * 
 * <tag name="b">
 *   <attribute name="x" required="true" type="string"/>
 *   <attribute name="y" required="true" type="string"/>
 *   <attribute name="d" type="string"/>
 *   <attribute name="t" type="string"/>
 *   <attribute name="name" required="true" type="string"/>
 *   <attribute name="color" type="string"/>
 *   <attribute name="rank" type="string"/>
 *   <attribute name="laser" type="string"/>
 *   <attribute name="scroll" type="string"/>
 *   <attribute name="width" type="string"/>
 * </tag>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule role="b" type="string"/&gt;
 * &lt;tag name="b"&gt;
 *   &lt;attribute name="x" required="true" type="string"/&gt;
 *   &lt;attribute name="y" required="true" type="string"/&gt;
 *   &lt;attribute name="d" type="string"/&gt;
 *   &lt;attribute name="t" type="string"/&gt;
 *   &lt;attribute name="name" required="true" type="string"/&gt;
 *   &lt;attribute name="color" type="string"/&gt;
 *   &lt;attribute name="rank" type="string"/&gt;
 *   &lt;attribute name="laser" type="string"/&gt;
 *   &lt;attribute name="scroll" type="string"/&gt;
 *   &lt;attribute name="width" type="string"/&gt;
 * &lt;/tag&gt;
 * </pre>
 *
 * @version narihira.rlx 0.01 (Fri Feb 08 22:06:20 JST 2002)
 * @author  Relaxer 0.16 (http://www.relaxer.org)
 */
public class B implements java.io.Serializable {
    private String content_;
    private String x_;
    private String y_;
    private String d_;
    private String t_;
    private String name_;
    private String color_;
    private String rank_;
    private String laser_;
    private String scroll_;
    private String width_;

    /**
     * Creates a <code>B</code>.
     *
     */
    public B() {
    }

    /**
     * Creates a <code>B</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public B(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>B</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public B(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>B</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public B(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>B</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public B(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>B</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public B(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>B</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public B(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>B</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public B(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>B</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public B(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>B</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public B(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>B</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>B</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>B</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        content_ = URelaxer.getElementPropertyAsString(element);
        x_ = URelaxer.getAttributePropertyAsString(element, "x");
        y_ = URelaxer.getAttributePropertyAsString(element, "y");
        d_ = URelaxer.getAttributePropertyAsString(element, "d");
        t_ = URelaxer.getAttributePropertyAsString(element, "t");
        name_ = URelaxer.getAttributePropertyAsString(element, "name");
        color_ = URelaxer.getAttributePropertyAsString(element, "color");
        rank_ = URelaxer.getAttributePropertyAsString(element, "rank");
        laser_ = URelaxer.getAttributePropertyAsString(element, "laser");
        scroll_ = URelaxer.getAttributePropertyAsString(element, "scroll");
        width_ = URelaxer.getAttributePropertyAsString(element, "width");
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("b");
        URelaxer.setElementPropertyByString(element, this.content_);
        int size;
        URelaxer.setAttributePropertyByString(element, "x", this.x_);
        URelaxer.setAttributePropertyByString(element, "y", this.y_);
        if (this.d_ != null) {
            URelaxer.setAttributePropertyByString(element, "d", this.d_);
        }
        if (this.t_ != null) {
            URelaxer.setAttributePropertyByString(element, "t", this.t_);
        }
        URelaxer.setAttributePropertyByString(element, "name", this.name_);
        if (this.color_ != null) {
            URelaxer.setAttributePropertyByString(element, "color", this.color_);
        }
        if (this.rank_ != null) {
            URelaxer.setAttributePropertyByString(element, "rank", this.rank_);
        }
        if (this.laser_ != null) {
            URelaxer.setAttributePropertyByString(element, "laser", this.laser_);
        }
        if (this.scroll_ != null) {
            URelaxer.setAttributePropertyByString(element, "scroll", this.scroll_);
        }
        if (this.width_ != null) {
            URelaxer.setAttributePropertyByString(element, "width", this.width_);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>B</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>B</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>B</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>B</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>B</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>B</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>content</b>.
     *
     * @return String
     */
    public final String getContent() {
        return (content_);
    }

    /**
     * Sets the String property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(String content) {
        this.content_ = content;
    }

    /**
     * Gets the String property <b>x</b>.
     *
     * @return String
     */
    public final String getX() {
        return (x_);
    }

    /**
     * Sets the String property <b>x</b>.
     *
     * @param x
     */
    public final void setX(String x) {
        this.x_ = x;
    }

    /**
     * Gets the String property <b>y</b>.
     *
     * @return String
     */
    public final String getY() {
        return (y_);
    }

    /**
     * Sets the String property <b>y</b>.
     *
     * @param y
     */
    public final void setY(String y) {
        this.y_ = y;
    }

    /**
     * Gets the String property <b>d</b>.
     *
     * @return String
     */
    public final String getD() {
        return (d_);
    }

    /**
     * Sets the String property <b>d</b>.
     *
     * @param d
     */
    public final void setD(String d) {
        this.d_ = d;
    }

    /**
     * Gets the String property <b>t</b>.
     *
     * @return String
     */
    public final String getT() {
        return (t_);
    }

    /**
     * Sets the String property <b>t</b>.
     *
     * @param t
     */
    public final void setT(String t) {
        this.t_ = t;
    }

    /**
     * Gets the String property <b>name</b>.
     *
     * @return String
     */
    public final String getName() {
        return (name_);
    }

    /**
     * Sets the String property <b>name</b>.
     *
     * @param name
     */
    public final void setName(String name) {
        this.name_ = name;
    }

    /**
     * Gets the String property <b>color</b>.
     *
     * @return String
     */
    public final String getColor() {
        return (color_);
    }

    /**
     * Sets the String property <b>color</b>.
     *
     * @param color
     */
    public final void setColor(String color) {
        this.color_ = color;
    }

    /**
     * Gets the String property <b>rank</b>.
     *
     * @return String
     */
    public final String getRank() {
        return (rank_);
    }

    /**
     * Sets the String property <b>rank</b>.
     *
     * @param rank
     */
    public final void setRank(String rank) {
        this.rank_ = rank;
    }

    /**
     * Gets the String property <b>laser</b>.
     *
     * @return String
     */
    public final String getLaser() {
        return (laser_);
    }

    /**
     * Sets the String property <b>laser</b>.
     *
     * @param laser
     */
    public final void setLaser(String laser) {
        this.laser_ = laser;
    }

    /**
     * Gets the String property <b>scroll</b>.
     *
     * @return String
     */
    public final String getScroll() {
        return (scroll_);
    }

    /**
     * Sets the String property <b>scroll</b>.
     *
     * @param scroll
     */
    public final void setScroll(String scroll) {
        this.scroll_ = scroll;
    }

    /**
     * Gets the String property <b>width</b>.
     *
     * @return String
     */
    public final String getWidth() {
        return (width_);
    }

    /**
     * Sets the String property <b>width</b>.
     *
     * @param width
     */
    public final void setWidth(String width) {
        this.width_ = width;
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<b");
        buffer.append(" x=\"");
        buffer.append(URelaxer.escapeAttrQuot(getX()));
        buffer.append("\"");
        buffer.append(" y=\"");
        buffer.append(URelaxer.escapeAttrQuot(getY()));
        buffer.append("\"");
        if (d_ != null) {
            buffer.append(" d=\"");
            buffer.append(URelaxer.escapeAttrQuot(getD()));
            buffer.append("\"");
        }
        if (t_ != null) {
            buffer.append(" t=\"");
            buffer.append(URelaxer.escapeAttrQuot(getT()));
            buffer.append("\"");
        }
        buffer.append(" name=\"");
        buffer.append(URelaxer.escapeAttrQuot(getName()));
        buffer.append("\"");
        if (color_ != null) {
            buffer.append(" color=\"");
            buffer.append(URelaxer.escapeAttrQuot(getColor()));
            buffer.append("\"");
        }
        if (rank_ != null) {
            buffer.append(" rank=\"");
            buffer.append(URelaxer.escapeAttrQuot(getRank()));
            buffer.append("\"");
        }
        if (laser_ != null) {
            buffer.append(" laser=\"");
            buffer.append(URelaxer.escapeAttrQuot(getLaser()));
            buffer.append("\"");
        }
        if (scroll_ != null) {
            buffer.append(" scroll=\"");
            buffer.append(URelaxer.escapeAttrQuot(getScroll()));
            buffer.append("\"");
        }
        if (width_ != null) {
            buffer.append(" width=\"");
            buffer.append(URelaxer.escapeAttrQuot(getWidth()));
            buffer.append("\"");
        }
        buffer.append(">");
        buffer.append(URelaxer.escapeCharData(getContent()));
        buffer.append("</b>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<b");
        buffer.print(" x=\"");
        buffer.print(URelaxer.escapeAttrQuot(getX()));
        buffer.print("\"");
        buffer.print(" y=\"");
        buffer.print(URelaxer.escapeAttrQuot(getY()));
        buffer.print("\"");
        if (d_ != null) {
            buffer.print(" d=\"");
            buffer.print(URelaxer.escapeAttrQuot(getD()));
            buffer.print("\"");
        }
        if (t_ != null) {
            buffer.print(" t=\"");
            buffer.print(URelaxer.escapeAttrQuot(getT()));
            buffer.print("\"");
        }
        buffer.print(" name=\"");
        buffer.print(URelaxer.escapeAttrQuot(getName()));
        buffer.print("\"");
        if (color_ != null) {
            buffer.print(" color=\"");
            buffer.print(URelaxer.escapeAttrQuot(getColor()));
            buffer.print("\"");
        }
        if (rank_ != null) {
            buffer.print(" rank=\"");
            buffer.print(URelaxer.escapeAttrQuot(getRank()));
            buffer.print("\"");
        }
        if (laser_ != null) {
            buffer.print(" laser=\"");
            buffer.print(URelaxer.escapeAttrQuot(getLaser()));
            buffer.print("\"");
        }
        if (scroll_ != null) {
            buffer.print(" scroll=\"");
            buffer.print(URelaxer.escapeAttrQuot(getScroll()));
            buffer.print("\"");
        }
        if (width_ != null) {
            buffer.print(" width=\"");
            buffer.print(URelaxer.escapeAttrQuot(getWidth()));
            buffer.print("\"");
        }
        buffer.print(">");
        buffer.print(URelaxer.escapeCharData(getContent()));
        buffer.print("</b>");
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getXAsString() {
        return (URelaxer.getString(getX()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getYAsString() {
        return (URelaxer.getString(getY()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getDAsString() {
        return (URelaxer.getString(getD()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getTAsString() {
        return (URelaxer.getString(getT()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getNameAsString() {
        return (URelaxer.getString(getName()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getColorAsString() {
        return (URelaxer.getString(getColor()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getRankAsString() {
        return (URelaxer.getString(getRank()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getLaserAsString() {
        return (URelaxer.getString(getLaser()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getScrollAsString() {
        return (URelaxer.getString(getScroll()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getWidthAsString() {
        return (URelaxer.getString(getWidth()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setXByString(String string) {
        setX(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setYByString(String string) {
        setY(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setDByString(String string) {
        setD(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setTByString(String string) {
        setT(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setNameByString(String string) {
        setName(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setColorByString(String string) {
        setColor(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setRankByString(String string) {
        setRank(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setLaserByString(String string) {
        setLaser(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setScrollByString(String string) {
        setScroll(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setWidthByString(String string) {
        setWidth(string);
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>B</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "b")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>B</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>B</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
