/*
 * $Id: Ship.java,v 1.2 2002/02/08 16:32:42 kenta Exp $
 *
 * Copyright 2002 Kenta Cho. All rights reserved.
 */
package jp.gr.java_conf.abagames.narihira;

import jp.gr.java_conf.abagames.util.*;

/**
 * Handle my ship.
 *
 * @version $Revision: 1.2 $
 */
public class Ship {
  private final int SCREEN_WIDTH_256 = Screen.SCREEN_WIDTH<<8;
  private final int SCREEN_HEIGHT_256 = Screen.SCREEN_HEIGHT<<8;

  private GameManager gameManager;
  private Screen screen;

  public int x, y, d;
  public int color;
  private int colorChangeCnt, nextColor;

  public int[] eatCount = new int[2];
  public int missCount;
  private int ivcCnt;

  private int mouseX, mouseY;

  public Ship(GameManager gameManager) {
    this.gameManager = gameManager;
    screen = gameManager.screen;
  }

  private final int NO_MOVE_INVCNT = 180;

  private void nextShip() {
    x = mouseX = (Screen.SCREEN_WIDTH/2)<<8;
    y = mouseY = Screen.SCREEN_HEIGHT<<8;
  }

  public void init() {
    color = nextColor = 0;
    colorChangeCnt = 0;
    d = 0;
    eatCount[0] = eatCount[1] = 0;
    missCount = 0;
    nextShip();
    ivcCnt = 180;
  }

  public void eatDot() {
    eatCount[color]++;
  }

  public void destroied() {
    if ( ivcCnt > 0 ) return;
    missCount++;
    for ( int i=0 ; i<16 ; i++ ) {
      gameManager.addFrag(x, y);
    }
    gameManager.clearAllBullets();
    nextShip();
    ivcCnt = 220;
  }

  public final void setMousePos(int x, int y) {
    mouseX = x<<8; mouseY = y<<8;
  }

  private final int COLOR_CHANGE_NO_GUARD_TIME = 15;

  public final void mousePressed() {
    nextColor ^= 1;
    colorChangeCnt = COLOR_CHANGE_NO_GUARD_TIME;
    color = 2;
  }

  private final int SPEED = 3<<8;
  private static final int WIDTH = 8;
  private static final int WIDTH_DIV_2 = 4;
  private static final int FORCE_WIDTH = 20;
  private static final int FORCE_LINE_WIDTH = 4;
  /*private final int SPEED = 1<<8;
  private static final int WIDTH = 2;
  private static final int WIDTH_DIV_2 = 1;
  private static final int FORCE_WIDTH = 4;
  private static final int FORCE_LINE_WIDTH = 3;*/

  public static final int WIDTH_256 = WIDTH<<8;
  public static final int FORCE_WIDTH_256 = FORCE_WIDTH<<8;

  public void move() {
    if ( ivcCnt > 0 ) ivcCnt--;
    if ( ivcCnt > NO_MOVE_INVCNT ) return;
    int ox = mouseX-x, oy = mouseY-y;
    int r = DegUtil.getDistance(ox, oy);
    if ( r < SPEED ) {
      x = mouseX; y = mouseY;
    } else {
      x += ox*SPEED/r; y += oy*SPEED/r;
    }
    if ( x < 0 ) x = 0;
    else if ( x > SCREEN_WIDTH_256 ) x = SCREEN_WIDTH_256-1;
    if ( y < 0 ) y = 0;
    else if ( y > SCREEN_HEIGHT_256 ) y = SCREEN_HEIGHT_256-1;
    d = (d+13)&255;
    if ( colorChangeCnt > 0 ) {
      colorChangeCnt--;
      if ( colorChangeCnt <= 0 ) {
        color = nextColor;
      }
    }
  }

  public void draw() {
    if ( ivcCnt > NO_MOVE_INVCNT ) return;
    int sx = x>>8, sy = y>>8;
    if ( (ivcCnt&31) < 16 ) {
      screen.drawLine(sx, sy-WIDTH_DIV_2, sx, sy+WIDTH_DIV_2, WIDTH,
       BulletImpl.BULLET_COLOR[color][0], BulletImpl.BULLET_COLOR[color][1]);
    }
    int fd1 = d, fd2 = d;
    if ( colorChangeCnt > 0 ) {
      for ( int i=8 ; i>0 ; i-- ) {
        fd2 = (fd2+32)&255;
        screen.drawLine(sx+(SCTable.sintbl[fd1]*FORCE_WIDTH>>9),
                        sy+(SCTable.costbl[fd1]*FORCE_WIDTH>>9),
                        sx+(SCTable.sintbl[fd2]*FORCE_WIDTH>>9),
                        sy+(SCTable.costbl[fd2]*FORCE_WIDTH>>9),
                        FORCE_LINE_WIDTH,
                        BulletImpl.BULLET_COLOR[color][0],
                        BulletImpl.BULLET_COLOR[color][1]);
        fd1 = (fd1+32)&255;
      }
    } else {
      for ( int i=8 ; i>0 ; i-- ) {
        fd2 = (fd2+32)&255;
        screen.drawLine(sx+(SCTable.sintbl[fd1]*FORCE_WIDTH>>8),
                        sy+(SCTable.costbl[fd1]*FORCE_WIDTH>>8),
                        sx+(SCTable.sintbl[fd2]*FORCE_WIDTH>>8),
                        sy+(SCTable.costbl[fd2]*FORCE_WIDTH>>8),
                        FORCE_LINE_WIDTH,
                        BulletImpl.BULLET_COLOR[color][0],
                        BulletImpl.BULLET_COLOR[color][1]);
        fd1 = (fd1+32)&255;
      }
    }
  }
}
