/*
 * $Id: Screen.java,v 1.1.1.1 2002/02/07 15:20:13 kenta Exp $
 *
 * Copyright 2002 Kenta Cho. All rights reserved.
 */
package jp.gr.java_conf.abagames.narihira;

import java.awt.*;
import java.awt.image.*;
import java.applet.Applet;
//import java.util.Random;

/**
 * Draw applet screen.
 *
 * @version $Revision: 1.1.1.1 $
 */
public class Screen {
  private int pbuf[], bpbuf[];
  private int pbuf1[], pbuf2[];
  private int bufBldIdx[];
  private MemoryImageSource imageSource;
  private Image bufImage;

  private LetterRender letterRender;

  public static final int SCREEN_WIDTH = Narihira.SCREEN_WIDTH;
  public static final int SCREEN_HEIGHT = Narihira.SCREEN_HEIGHT;

  //private Random rnd = new Random();

  public Screen() {
    pbuf1 = new int[SCREEN_WIDTH * SCREEN_HEIGHT+1];
    pbuf2 = new int[SCREEN_WIDTH * SCREEN_HEIGHT+1];
    pbuf = pbuf1; bpbuf = pbuf2;

    pbuf1[pbuf1.length-1] = pbuf2[pbuf2.length-1] = 0;
    bufBldIdx = new int[SCREEN_WIDTH*SCREEN_HEIGHT];
    for ( int i = SCREEN_WIDTH*SCREEN_HEIGHT-1 ; i>=0 ; i-- ){
      int y = i/SCREEN_WIDTH;
      int x = i-y*SCREEN_WIDTH;
      x -= SCREEN_WIDTH/2; y -= SCREEN_HEIGHT/2;
      //x *= 0.95f; y *= 0.95f;
      //x *= 1.05f; y *= 1.05f;
      //x += (rnd.nextInt()%3);
      //y += (rnd.nextInt()%3);
      x += Math.sin(3.14*0.05*x)/150;
      y += Math.sin(3.14*0.05*y)/150;
      x += SCREEN_WIDTH/2; y += SCREEN_HEIGHT/2;
      if ( x>=0 && x<SCREEN_WIDTH && y>=0 && y<SCREEN_HEIGHT ) {
        bufBldIdx[i] = x+y*SCREEN_WIDTH;
      } else {
        bufBldIdx[i] = pbuf1.length-1;
      }
    }

    letterRender = new LetterRender(pbuf);
  }

  /**
   * make screen buffer(off screen image)
   */
  public void makeBuffer(Component cmp) {
    imageSource = new MemoryImageSource
      (SCREEN_WIDTH, SCREEN_HEIGHT, pbuf, 0, SCREEN_WIDTH);
    imageSource.setAnimated(true);
    bufImage = cmp.createImage(imageSource);
    grp = cmp.getGraphics();
  }

  /**
   * clear screen.
   */
  public final void clearNoSmoke() {
    for ( int i=pbuf.length-2 ; i>=0 ; i-- ){
      pbuf[i] = 0xff907070;
    }
  }

  /**
   * clear screen and make smoke effect
   */
  public final void clear() {
    System.arraycopy(pbuf, 0, bpbuf, 0, bufBldIdx.length);
    for ( int i=bufBldIdx.length-1 ; i>=0 ; i-- ){
      int px = bpbuf[bufBldIdx[i]];
      int r = ((((px&0xff0000) - 0x900000)>>8 ) * 150 + 0x900000)&0xff0000;
      int g = ((((px&0x00ff00) - 0x7000)>>8 ) * 100 + 0x7000)&0x00ff00;
      int b = ((((px&0x0000ff) - 0x70)    ) * 160 >> 8) + 0x70;
      pbuf[i] = 0xff000000 | r | g | b;
    }
  }

  private ColorModel colorModel = ColorModel.getRGBdefault();
  private Graphics grp;

  public final void swap() {
    imageSource.newPixels();
    grp.drawImage(bufImage, 0, 0, null);
  }

  private final int alphaBlend(int a, int b, int rate) {
    int tmp;
    tmp = (b & 0xff0000)>>16;
    int red = ((((a & 0xff0000)>>16) - tmp) * rate >>16) + tmp;
    tmp = (b & 0x00ff00)>>8;
    int green = ((((a & 0x00ff00)>>8 ) - tmp) * rate >>16) + tmp;
    tmp = (b & 0x0000ff);
    int blue = ((((a & 0x0000ff)    ) - tmp) * rate >>16) + tmp;
    return (red<<16) | (green<<8) | blue | 0xff000000;
  }

  /**
   * draw alpha blended line
   */
  //public final void drawLine(int x1, int y1, int x2, int y2, int color) {
  public final void drawLine(int x1, int y1, int x2, int y2, int width, int color1, int color2) {
    if ( x1 < 0 ) {
      if ( x2 < 0 ) return;
      y1 = (y1-y2)*x2/(x2-x1)+y2;
      x1 = 0;
    } else if ( x2 < 0 ) {
      y2 = (y2-y1)*x1/(x1-x2)+y1;
      x2 = 0;
    }
    if ( x1 > SCREEN_WIDTH-1 ) {
      if ( x2 > SCREEN_WIDTH-1 ) return;
      y1 = (y1-y2)*(x2-(SCREEN_WIDTH-1))/(x2-x1)+y2;
      x1 = SCREEN_WIDTH-1;
    } else if ( x2 > SCREEN_WIDTH-1 ) {
      y2 = (y2-y1)*(x1-(SCREEN_WIDTH-1))/(x1-x2)+y1;
      x2 = SCREEN_WIDTH-1;
    }
    /*if ( x1 < width ) {
      if ( x2 < width ) return;
      y1 = (y1-y2)*(x2-width)/(x2-x1)+y2;
      x1 = width;
    } else if ( x2 < width ) {
      y2 = (y2-y1)*(x1-width)/(x1-x2)+y1;
      x2 = width;
    }
    if ( x1 > SCREEN_WIDTH-1-width ) {
      if ( x2 > SCREEN_WIDTH-1-width ) return;
      y1 = (y1-y2)*(x2-(SCREEN_WIDTH-1-width))/(x2-x1)+y2;
      x1 = SCREEN_WIDTH-1-width;
    } else if ( x2 > SCREEN_WIDTH-1-width ) {
      y2 = (y2-y1)*(x1-(SCREEN_WIDTH-1-width))/(x1-x2)+y1;
      x2 = SCREEN_WIDTH-1-width;
    }*/
    /*if ( y1 < 1 ) {
      if ( y2 < 1 ) return;
      x1 = (x1-x2)*(y2-1)/(y2-y1)+x2;
      y1 = 1;
    } else if ( y2 < 1 ) {
      x2 = (x2-x1)*(y1-1)/(y1-y2)+x1;
      y2 = 1;
    }
    if ( y1 > SCREEN_HEIGHT-2 ) {
      if ( y2 > SCREEN_HEIGHT-2 ) return;
      x1 = (x1-x2)*(y2-(SCREEN_HEIGHT-2))/(y2-y1)+x2;
      y1 = SCREEN_HEIGHT-2;
    } else if ( y2 > SCREEN_HEIGHT-2 ) {
      x2 = (x2-x1)*(y1-(SCREEN_HEIGHT-2))/(y1-y2)+x1;
      y2 = SCREEN_HEIGHT-2;
    }*/
    if ( y1 < width ) {
      if ( y2 < width ) return;
      x1 = (x1-x2)*(y2-width)/(y2-y1)+x2;
      y1 = width;
    } else if ( y2 < width ) {
      x2 = (x2-x1)*(y1-width)/(y1-y2)+x1;
      y2 = width;
    }
    if ( y1 > SCREEN_HEIGHT-1-width ) {
      if ( y2 > SCREEN_HEIGHT-1-width ) return;
      x1 = (x1-x2)*(y2-(SCREEN_HEIGHT-1-width))/(y2-y1)+x2;
      y1 = SCREEN_HEIGHT-1-width;
    } else if ( y2 > SCREEN_HEIGHT-1-width ) {
      x2 = (x2-x1)*(y1-(SCREEN_HEIGHT-1-width))/(y1-y2)+x1;
      y2 = SCREEN_HEIGHT-1-width;
    }

    int lx = Math.abs(x2 - x1);
    int ly = Math.abs(y2 - y1);

    if ( lx < ly ) {
      if ( ly == 0 ) ly++;
      int ax = ((x2 - x1)<<16) / ly;
      int ay = ((y2 - y1)>>16) | 1;
      int x  = x1<<16;
      int y  = y1;
      for ( int i=ly-1 ; i>=0 ; i--, x+=ax, y+=ay ){
        int px = x>>16;
        int p1 = y * SCREEN_WIDTH + px;
        //pbuf[p1] = color;

        /*int p2 = p1 + 1;
        int rx = x & 0xffff;
        pbuf[p1] = alphaBlend(pbuf[p1],color,       rx);
        pbuf[p2] = alphaBlend(pbuf[p2],color,0xffff-rx);*/

        p1 -= width>>1;
        int rx = x & 0xffff;
        pbuf[p1] = alphaBlend(pbuf[p1],color2,       rx); p1++;
        for ( int j=width-2 ; j>=0 ; j-- ) {
          pbuf[p1] = color1; p1++;
        }
        pbuf[p1] = alphaBlend(pbuf[p1],color2,0xffff-rx);
      }
    } else {
      if ( lx == 0 ) lx++;
      int ay = ((y2 - y1)<<16) / lx;
      int ax = ((x2 - x1)>>16) | 1;
      int x  = x1;
      int y  = y1<<16;
      for ( int i=lx-1 ; i>0 ; i--, x+=ax, y+=ay ) {
        int py = y>>16;
        int p1 = py * SCREEN_WIDTH + x;
        //pbuf[p1] = color;

        /*int p2 = p1 + SCREEN_WIDTH;
        int ry = y & 0xffff;
        pbuf[p1] = alphaBlend(pbuf[p1],color1,       ry);
        pbuf[p2] = alphaBlend(pbuf[p2],color1,0xffff-ry);*/

        p1 -= SCREEN_WIDTH*(width>>1);
        int ry = y & 0xffff;
        pbuf[p1] = alphaBlend(pbuf[p1],color2,       ry); p1 += SCREEN_WIDTH;
        for ( int j=width-2 ; j>=0 ; j-- ) {
          pbuf[p1] = color1; p1 += SCREEN_WIDTH;
        }
        pbuf[p1] = alphaBlend(pbuf[p1],color2,0xffff-ry);
      }
    }
  }

  public void drawLetter(int idx, int lx, int ly, int ltSize, int color) {
    letterRender.drawLetter(idx, lx, ly, ltSize, color);
  }

  public void drawString(String str, int lx, int ly, int ltSize, int color) {
    int x = lx+ltSize, y = (int)(ly+ltSize*1.25f);
    for ( int i=0 ; i<str.length() ; i++ ) {
      int c = (int)str.charAt(i), idx;
      if ( c >= '0' && c <='9' ) {
        idx = c-'0';
      } else if ( c >= 'A' && c <= 'Z' ) {
        idx = c-'A'+10;
      } else if ( c >= 'a' && c <= 'z' ) {
        idx = c-'a'+10;
      } else if ( c == '.' ) {
        idx = 36;
      } else if ( c == '-' ) {
        idx = 38;
      } else {
        idx = 37;
      }
      letterRender.drawLetter(idx, x, y, ltSize, color);
      x += ltSize*2;
    }
  }
}
