/*
 * $Id: ObstacleImpl.java,v 1.1.1.1 2002/02/07 15:20:13 kenta Exp $
 *
 * Copyright 2002 Kenta Cho. All rights reserved.
 */
package jp.gr.java_conf.abagames.narihira;

import jp.gr.java_conf.abagames.narihira.relaxer.*;
import jp.gr.java_conf.abagames.util.*;

/**
 * Obstacle implementation.
 *
 * @version $Revision: 1.1.1.1 $
 */
public class ObstacleImpl {
  public final static int NOT_EXIST = -99999;

  private final int SCREEN_WIDTH_256 = Screen.SCREEN_WIDTH<<8;
  private final int SCREEN_HEIGHT_256 = Screen.SCREEN_HEIGHT<<8;

  public int x, y, w, h;
  private boolean noScroll;
  private boolean shown;
  private int d, r;

  private GameManager gameManager;
  private Screen screen;
  private Ship ship;

  public ObstacleImpl(GameManager gameManager, Ship ship) {
    this.gameManager = gameManager;
    this.ship = ship;
    screen = gameManager.screen;
    x = NOT_EXIST;
  }

  public void set(O o) {
    double ox = new Double(o.getX()).doubleValue()*Screen.SCREEN_WIDTH*GameManager.SCREEN_ML_RATE,
           oy = new Double(o.getY()).doubleValue()*Screen.SCREEN_HEIGHT*GameManager.SCREEN_ML_RATE;
    x = (int)((ox + Screen.SCREEN_WIDTH/2)*256);
    y = (int)((-oy + Screen.SCREEN_HEIGHT/2)*256);
    w = (int)(new Double(o.getW()).doubleValue()*Screen.SCREEN_WIDTH*GameManager.SCREEN_ML_RATE/2);
    h = (int)(new Double(o.getH()).doubleValue()*Screen.SCREEN_HEIGHT*GameManager.SCREEN_ML_RATE/2);
    String scrStr = o.getScroll();
    if ( scrStr != null && scrStr.equals("no") ) {
      noScroll = true;
    } else {
      noScroll = false;
      d = DegUtil.getDeg((int)ox, (int)oy)*256;
      r = (int)(Math.sqrt(ox*ox + oy*oy));
    }
    shown = false;
  }

  public void move(int mx, int my, int md) {
    if ( !noScroll ) {
      x += mx; y += my;
      if ( md != 0 ) {
        int pd = d;
        d += md; d &= ((256<<8)-1);
        x += (SCTable.sintbl[(d>>8)] - SCTable.sintbl[(pd>>8)])*r;
        y += (SCTable.costbl[(d>>8)] - SCTable.costbl[(pd>>8)])*r;
      }
    }
    int sx = x>>8, sy = y>>8;
    if ( sx+w>=0 && sy+h>=0 &&
     sx-w<Screen.SCREEN_WIDTH && sy-h<Screen.SCREEN_HEIGHT ) {
      shown = true;
      int shx = ship.x>>8, shy = ship.y>>8;
      if ( shx>sx-w && shx<sx+w && shy>sy-h && shy<sy+h ) {
        ship.destroied();
      }
    } else {
      shown = false;
    }
  }

  private final int COLOR1 = 0xffffaa44, COLOR2 = 0xffaaff44;

  public void draw() {
    if ( !shown ) return;
    int sx = x>>8, sy = y>>8;
    screen.drawLine(sx-w, sy-h, sx+w, sy-h, 5, COLOR1, COLOR2);
    screen.drawLine(sx+w, sy-h, sx+w, sy+h, 5, COLOR1, COLOR2);
    screen.drawLine(sx+w, sy+h, sx-w, sy+h, 5, COLOR1, COLOR2);
    screen.drawLine(sx-w, sy+h, sx-w, sy-h, 5, COLOR1, COLOR2);
  }
}
