/*
 * $Id: NarihiraData.java,v 1.2 2002/02/08 16:32:42 kenta Exp $
 *
 * Copyright 2002 Kenta Cho. All rights reserved.
 */
package jp.gr.java_conf.abagames.narihira;

import java.util.Hashtable;

/**
 * Narihira stage datas.
 *
 * @version $Revision: 1.2 $
 */
public class NarihiraData {

public static String[] stageName = {
  "twin_radial", "rollings", "chase", "front_back_rapid",
  "rafflesia", "rafflesia_another",
  "concentrated",
  "wb_winder", "claw", "wb_laser",
};

public static final NarihiraData[] data = {
new NarihiraData(
"twin_radial",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE narihira SYSTEM \"narihira.dtd\">\n\n<narihira xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml/narihira\">\n\n<scroll>\n <position>\n  <p x=\"0\" y=\"0\" t=\"0\"/>\n  <p x=\"0\" y=\"5\" t=\"2000\"/>\n </position>\n</scroll>\n\n<obstacle>\n <o x=\"-0.6\" y=\"0.9\" w=\"0.5\" h=\"0.5\" scroll=\"no\"/>\n <o x=\"0.6\" y=\"0.9\" w=\"0.5\" h=\"0.5\" scroll=\"no\"/>\n</obstacle>\n\n<battery>\n <b x=\"-0.6\" y=\"1\" color=\"white\" rank=\"0\" scroll=\"no\" width=\"5\" name=\"r1_mdl.xml\"/>\n <b x=\"0.6\" y=\"1\" color=\"black\" rank=\"0\" scroll=\"no\" width=\"5\" name=\"r1_mdl.xml\"/>\n <b x=\"-0.6\" y=\"1.9\" color=\"white\" rank=\"0.4\" scroll=\"no\" width=\"5\" name=\"r1_mdl.xml\"/>\n <b x=\"0.6\" y=\"2.3\" color=\"black\" rank=\"0.4\" scroll=\"no\" width=\"5\" name=\"r1_mdl.xml\"/>\n <b x=\"-0.6\" y=\"2.8\" color=\"white\" rank=\"0.7\" scroll=\"no\" width=\"5\" name=\"r1_mdl.xml\"/>\n <b x=\"0.6\" y=\"3.4\" color=\"black\" rank=\"0.7\" scroll=\"no\" width=\"5\" name=\"r1_mdl.xml\"/>\n <b x=\"-0.6\" y=\"3.7\" color=\"white\" rank=\"1\" scroll=\"no\" width=\"5\" name=\"r1_mdl.xml\"/>\n <b x=\"0.6\" y=\"4.5\" color=\"black\" rank=\"1\" scroll=\"no\" width=\"5\" name=\"r1_mdl.xml\"/>\n <b x=\"-0.6\" y=\"4.6\" color=\"white\" rank=\"1\" scroll=\"no\" width=\"5\" name=\"r1_mdl.xml\"/>\n</battery>\n\n</narihira>\n"
),
new NarihiraData(
"rollings",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE narihira SYSTEM \"narihira.dtd\">\n\n<narihira xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml/narihira\">\n\n<scroll>\n <position>\n  <p x=\"0\" y=\"0\" t=\"0\"/>\n  <p x=\"0\" y=\"9\" t=\"3600\"/>\n </position>\n</scroll>\n\n<obstacle>\n <o x=\"-0.8\" y=\"1\" w=\"0.4\" h=\"0.4\"/>\n <o x=\"0.8\" y=\"1\" w=\"0.4\" h=\"0.4\"/>\n <o x=\"-0.8\" y=\"2\" w=\"0.4\" h=\"0.4\"/>\n <o x=\"0.8\" y=\"2\" w=\"0.4\" h=\"0.4\"/>\n <o x=\"-0.8\" y=\"3\" w=\"0.4\" h=\"0.4\"/>\n <o x=\"0.8\" y=\"3\" w=\"0.4\" h=\"0.4\"/>\n\n <o x=\"-0.8\" y=\"4.5\" w=\"0.4\" h=\"0.4\"/>\n <o x=\"0.8\" y=\"4.5\" w=\"0.4\" h=\"0.4\"/>\n\n <o x=\"-0.8\" y=\"6\" w=\"0.4\" h=\"0.4\"/>\n <o x=\"0.8\" y=\"6\" w=\"0.4\" h=\"0.4\"/>\n <o x=\"-0.8\" y=\"7\" w=\"0.4\" h=\"0.4\"/>\n <o x=\"0.8\" y=\"7\" w=\"0.4\" h=\"0.4\"/>\n <o x=\"-0.8\" y=\"8\" w=\"0.4\" h=\"0.4\"/>\n <o x=\"0.8\" y=\"8\" w=\"0.4\" h=\"0.4\"/>\n</obstacle>\n\n<battery>\n <b x=\"-0.8\" y=\"1\" color=\"white\" rank=\"0\" name=\"rf_l.xml\"/>\n <b x=\"0.8\" y=\"1\" color=\"white\" rank=\"0\" name=\"rf_r.xml\"/>\n <b x=\"-0.8\" y=\"2\" d=\"30\" color=\"black\" rank=\"0\" name=\"rf_l.xml\"/>\n <b x=\"0.8\" y=\"2\" d=\"-30\" color=\"black\" rank=\"0\" name=\"rf_r.xml\"/>\n <b x=\"-0.8\" y=\"3\" d=\"60\" color=\"white\" rank=\"0\" name=\"rf_l.xml\"/>\n <b x=\"0.8\" y=\"3\" d=\"-60\" color=\"white\" rank=\"0\" name=\"rf_r.xml\"/>\n\n <b x=\"-0.8\" y=\"4.5\" color=\"white\" rank=\"0\" name=\"rf_l.xml\"/>\n <b x=\"0.8\" y=\"4.5\" d=\"45\" color=\"black\" rank=\"0\" name=\"rf_r.xml\"/>\n\n <b x=\"-0.8\" y=\"6\" color=\"white\" rank=\"1\" name=\"rf_l.xml\"/>\n <b x=\"0.8\" y=\"6\" color=\"white\" rank=\"1\" name=\"rf_r.xml\"/>\n <b x=\"-0.8\" y=\"7\" d=\"30\" color=\"black\" rank=\"1\" name=\"rf_l.xml\"/>\n <b x=\"0.8\" y=\"7\" d=\"-30\" color=\"black\" rank=\"1\" name=\"rf_r.xml\"/>\n <b x=\"-0.8\" y=\"8\" color=\"black\" rank=\"1\" name=\"rf_l.xml\"/>\n <b x=\"0.8\" y=\"8\" d=\"45\" color=\"white\" rank=\"1\" name=\"rf_r.xml\"/>\n\n <b x=\"-0.8\" y=\"3\" color=\"-1\" width=\"12\" scroll=\"no\" laser=\"yes\" name=\"vl_r.xml\"/>\n <b x=\"0.8\" y=\"4\" color=\"-2\" width=\"12\" scroll=\"no\" laser=\"yes\" name=\"vl_l.xml\"/>\n <b x=\"-1\" y=\"4.5\" color=\"-1\" width=\"12\" scroll=\"no\" laser=\"yes\" name=\"vl_r.xml\"/>\n <b x=\"-1\" y=\"4.75\" color=\"-2\" width=\"12\" scroll=\"no\" laser=\"yes\" name=\"vl_r.xml\"/>\n <b x=\"-1\" y=\"5\" color=\"-1\" width=\"12\" scroll=\"no\" laser=\"yes\" name=\"vl_r.xml\"/>\n <b x=\"-0.8\" y=\"6\" color=\"-2\" width=\"12\" scroll=\"no\" laser=\"yes\" name=\"vl_r.xml\"/>\n <b x=\"0.8\" y=\"7\" color=\"-1\" width=\"12\" scroll=\"no\" laser=\"yes\" name=\"vl_l.xml\"/>\n <b x=\"0.8\" y=\"8\" color=\"-2\" width=\"12\" scroll=\"no\" laser=\"yes\" name=\"vl_l.xml\"/>\n</battery>\n\n</narihira>\n"
),
new NarihiraData(
"chase",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE narihira SYSTEM \"narihira.dtd\">\n\n<narihira xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml/narihira\">\n\n<scroll>\n <position>\n  <p x=\"0\" y=\"0\" t=\"0\"/>\n  <p x=\"0\" y=\"80\" t=\"3600\"/>\n </position>\n</scroll>\n\n<obstacle>\n <o x=\"0\" y=\"0.6\" w=\"0.7\" h=\"0.9\" scroll=\"no\"/>\n <o x=\"-0.75\" y=\"8\" w=\"0.6\" h=\"2\"/>\n <o x=\"0.75\" y=\"16\" w=\"0.6\" h=\"2\"/>\n <o x=\"-0.75\" y=\"24\" w=\"0.6\" h=\"4\"/>\n <o x=\"0.75\" y=\"32\" w=\"0.6\" h=\"4\"/>\n <o x=\"-0.75\" y=\"64\" w=\"0.6\" h=\"12\"/>\n <o x=\"0.75\" y=\"70\" w=\"0.6\" h=\"8\"/>\n</obstacle>\n\n<battery>\n <b x=\"0\" y=\"1\" color=\"-6\" scroll=\"no\" width=\"5\" name=\"r3_mdl_1.xml\"/>\n <b x=\"0\" y=\"1\" color=\"-5\" scroll=\"no\" width=\"5\" name=\"r3_mdl_2.xml\"/>\n <b x=\"0\" y=\"1\" color=\"-2\" scroll=\"no\" width=\"4\" rank=\"0.4\" name=\"r3_mdl_3.xml\"/>\n <b x=\"0\" y=\"1\" color=\"-1\" scroll=\"no\" width=\"4\" rank=\"0.4\" name=\"r3_mdl_4.xml\"/>\n\n <b x=\"0\" y=\"20\" color=\"-6\" scroll=\"no\" width=\"5\" name=\"r3_mdl_1.xml\"/>\n <b x=\"0\" y=\"20\" color=\"-5\" scroll=\"no\" width=\"5\" name=\"r3_mdl_2.xml\"/>\n <b x=\"0\" y=\"20\" color=\"-2\" scroll=\"no\" width=\"4\" rank=\"0.8\" name=\"r3_mdl_3.xml\"/>\n <b x=\"0\" y=\"20\" color=\"-1\" scroll=\"no\" width=\"4\" rank=\"0.8\" name=\"r3_mdl_4.xml\"/>\n\n <b x=\"0\" y=\"40\" color=\"-6\" scroll=\"no\" width=\"5\" name=\"r3_mdl_1.xml\"/>\n <b x=\"0\" y=\"40\" color=\"-5\" scroll=\"no\" width=\"5\" name=\"r3_mdl_2.xml\"/>\n <b x=\"0\" y=\"40\" color=\"-2\" scroll=\"no\" width=\"4\" rank=\"0\" name=\"r3_mdl_3.xml\"/>\n <b x=\"0\" y=\"40\" color=\"-1\" scroll=\"no\" width=\"4\" rank=\"0\" name=\"r3_mdl_4.xml\"/>\n\n <b x=\"0\" y=\"60\" color=\"-6\" scroll=\"no\" width=\"5\" name=\"r3_mdl_1.xml\"/>\n <b x=\"0\" y=\"60\" color=\"-5\" scroll=\"no\" width=\"5\" name=\"r3_mdl_2.xml\"/>\n <b x=\"0\" y=\"60\" color=\"-2\" scroll=\"no\" width=\"4\" rank=\"1\" name=\"r3_mdl_3.xml\"/>\n <b x=\"0\" y=\"60\" color=\"-1\" scroll=\"no\" width=\"4\" rank=\"1\" name=\"r3_mdl_4.xml\"/>\n\n <b x=\"1\" y=\"41\" color=\"white\" width=\"12\" laser=\"yes\" name=\"wl_l.xml\"/>\n <b x=\"1\" y=\"41.3\" color=\"white\" width=\"12\" laser=\"yes\" name=\"wl_l.xml\"/>\n <b x=\"1\" y=\"41.6\" color=\"white\" width=\"12\" laser=\"yes\" name=\"wl_l.xml\"/>\n <b x=\"1\" y=\"41.9\" color=\"white\" width=\"12\" laser=\"yes\" name=\"wl_l.xml\"/>\n\n <b x=\"-1\" y=\"51\" color=\"black\" width=\"12\" laser=\"yes\" name=\"wl_r.xml\"/>\n <b x=\"-1\" y=\"51.3\" color=\"black\" width=\"12\" laser=\"yes\" name=\"wl_r.xml\"/>\n <b x=\"-1\" y=\"51.6\" color=\"black\" width=\"12\" laser=\"yes\" name=\"wl_r.xml\"/>\n <b x=\"-1\" y=\"51.9\" color=\"black\" width=\"12\" laser=\"yes\" name=\"wl_r.xml\"/>\n\n <b x=\"-1\" y=\"60\" color=\"white\" width=\"12\" laser=\"yes\" name=\"wl_r.xml\"/>\n <b x=\"1\" y=\"64\" color=\"black\" width=\"12\" laser=\"yes\" name=\"wl_l.xml\"/>\n <b x=\"-1\" y=\"68\" color=\"white\" width=\"12\" laser=\"yes\" name=\"wl_r.xml\"/>\n <b x=\"1\" y=\"72\" color=\"black\" width=\"12\" laser=\"yes\" name=\"wl_l.xml\"/>\n <b x=\"-1\" y=\"74\" color=\"white\" width=\"12\" laser=\"yes\" name=\"wl_r.xml\"/>\n <b x=\"1\" y=\"76\" color=\"black\" width=\"12\" laser=\"yes\" name=\"wl_l.xml\"/>\n\n</battery>\n\n</narihira>\n"
),
new NarihiraData(
"front_back_rapid",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE narihira SYSTEM \"narihira.dtd\">\n\n<narihira xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml/narihira\">\n\n<scroll>\n <position>\n  <p x=\"0\" y=\"0\" t=\"0\"/>\n  <p x=\"0\" y=\"1.9\" t=\"1800\"/>\n </position>\n</scroll>\n\n<battery>\n <b x=\"-1\" y=\"1\" color=\"-2\" scroll=\"no\" name=\"vrp_rd.xml\"/>\n <b x=\"-1\" y=\"1.1\" color=\"-2\" scroll=\"no\" name=\"vrp_rd.xml\"/>\n <b x=\"-0.9\" y=\"1.2\" width=\"12\" color=\"white\" scroll=\"no\" name=\"hrm_d.xml\"/>\n <b x=\"-0.7\" y=\"1.25\" width=\"12\" color=\"white\" scroll=\"no\" name=\"hrm_d.xml\"/>\n <b x=\"-0.8\" y=\"1.3\" width=\"12\" color=\"white\" scroll=\"no\" name=\"hrm_d.xml\"/>\n <b x=\"-0.6\" y=\"1.35\" width=\"12\" color=\"white\" scroll=\"no\" name=\"hrm_d.xml\"/>\n\n <b x=\"1\" y=\"1.3\" color=\"-5\" scroll=\"no\" name=\"vrp_lu.xml\"/>\n <b x=\"1\" y=\"1.4\" color=\"-5\" scroll=\"no\" name=\"vrp_lu.xml\"/>\n <b x=\"0.9\" y=\"1.5\" width=\"12\" color=\"-3\" scroll=\"no\" name=\"hrm_u.xml\"/>\n <b x=\"0.7\" y=\"1.55\" width=\"12\" color=\"-3\" scroll=\"no\" name=\"hrm_u.xml\"/>\n <b x=\"0.8\" y=\"1.6\" width=\"12\" color=\"-3\" scroll=\"no\" name=\"hrm_u.xml\"/>\n <b x=\"0.6\" y=\"1.65\" width=\"12\" color=\"-3\" scroll=\"no\" name=\"hrm_u.xml\"/>\n\n <b x=\"-1\" y=\"1.6\" color=\"-1\" scroll=\"no\" name=\"vrp_rd.xml\"/>\n <b x=\"1\" y=\"1.6\" color=\"-2\" scroll=\"no\" name=\"vrp_ld.xml\"/>\n <b x=\"-1\" y=\"1.7\" color=\"-1\" scroll=\"no\" name=\"vrp_rd.xml\"/>\n <b x=\"1\" y=\"1.7\" color=\"-2\" scroll=\"no\" name=\"vrp_ld.xml\"/>\n\n <b x=\"-1\" y=\"1.8\" color=\"-1\" scroll=\"no\" name=\"vrp_rd.xml\"/>\n <b x=\"1\" y=\"1.85\" color=\"-6\" scroll=\"no\" name=\"vrp_lu.xml\"/>\n <b x=\"-1\" y=\"1.9\" color=\"-1\" scroll=\"no\" name=\"vrp_rd.xml\"/>\n <b x=\"1\" y=\"1.95\" color=\"-6\" scroll=\"no\" name=\"vrp_lu.xml\"/>\n\n <b x=\"-1\" y=\"2\" color=\"-1\" scroll=\"no\" name=\"vrp_rd.xml\"/>\n <b x=\"-1\" y=\"2.1\" color=\"-2\" scroll=\"no\" name=\"vrp_rd.xml\"/>\n <b x=\"-1\" y=\"2.2\" color=\"-1\" scroll=\"no\" name=\"vrp_rd.xml\"/>\n <b x=\"-1\" y=\"2.3\" color=\"-2\" scroll=\"no\" name=\"vrp_rd.xml\"/>\n\n <b x=\"-0.8\" y=\"2.15\" width=\"12\" color=\"white\" scroll=\"no\" name=\"hrm_d.xml\"/>\n <b x=\"0.6\" y=\"2.2\" width=\"12\" color=\"white\" scroll=\"no\" name=\"hrm_d.xml\"/>\n <b x=\"-0.2\" y=\"2.25\" width=\"12\" color=\"white\" scroll=\"no\" name=\"hrm_d.xml\"/>\n <b x=\"0.4\" y=\"2.3\" width=\"12\" color=\"white\" scroll=\"no\" name=\"hrm_d.xml\"/>\n <b x=\"0.8\" y=\"2.15\" width=\"12\" color=\"white\" scroll=\"no\" name=\"hrm_d.xml\"/>\n <b x=\"-0.6\" y=\"2.2\" width=\"12\" color=\"white\" scroll=\"no\" name=\"hrm_d.xml\"/>\n <b x=\"0.2\" y=\"2.25\" width=\"12\" color=\"white\" scroll=\"no\" name=\"hrm_d.xml\"/>\n <b x=\"-0.4\" y=\"2.3\" width=\"12\" color=\"white\" scroll=\"no\" name=\"hrm_d.xml\"/>\n <b x=\"0.85\" y=\"2.15\" width=\"12\" color=\"black\" scroll=\"no\" name=\"hrm_u.xml\"/>\n <b x=\"-0.95\" y=\"2.2\" width=\"12\" color=\"black\" scroll=\"no\" name=\"hrm_u.xml\"/>\n <b x=\"0.15\" y=\"2.25\" width=\"12\" color=\"black\" scroll=\"no\" name=\"hrm_u.xml\"/>\n <b x=\"-0.45\" y=\"2.3\" width=\"12\" color=\"black\" scroll=\"no\" name=\"hrm_u.xml\"/>\n <b x=\"-0.85\" y=\"2.15\" width=\"12\" color=\"black\" scroll=\"no\" name=\"hrm_u.xml\"/>\n <b x=\"0.95\" y=\"2.2\" width=\"12\" color=\"black\" scroll=\"no\" name=\"hrm_u.xml\"/>\n <b x=\"-0.15\" y=\"2.25\" width=\"12\" color=\"black\" scroll=\"no\" name=\"hrm_u.xml\"/>\n <b x=\"0.45\" y=\"2.3\" width=\"12\" color=\"black\" scroll=\"no\" name=\"hrm_u.xml\"/>\n\n <b x=\"1\" y=\"2.4\" color=\"-1\" scroll=\"no\" name=\"vrp_ld.xml\"/>\n <b x=\"1\" y=\"2.45\" color=\"-2\" scroll=\"no\" name=\"vrp_ld.xml\"/>\n <b x=\"1\" y=\"2.5\" color=\"-1\" scroll=\"no\" name=\"vrp_ld.xml\"/>\n <b x=\"1\" y=\"2.55\" color=\"-2\" scroll=\"no\" name=\"vrp_ld.xml\"/>\n <b x=\"1\" y=\"2.6\" color=\"-1\" scroll=\"no\" name=\"vrp_ld.xml\"/>\n <b x=\"1\" y=\"2.65\" color=\"-2\" scroll=\"no\" name=\"vrp_ld.xml\"/>\n\n <b x=\"-1\" y=\"2.4\" color=\"-6\" scroll=\"no\" name=\"vrp_ru.xml\"/>\n <b x=\"-1\" y=\"2.5\" color=\"-5\" scroll=\"no\" name=\"vrp_ru.xml\"/>\n <b x=\"-1\" y=\"2.6\" color=\"-6\" scroll=\"no\" name=\"vrp_ru.xml\"/>\n</battery>\n\n</narihira>\n"
),
new NarihiraData(
"rafflesia",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE narihira SYSTEM \"narihira.dtd\">\n\n<narihira xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml/narihira\">\n\n<scroll>\n <position>\n  <p x=\"0\" y=\"-0.5\" t=\"0\"/>\n  <p x=\"0.5\" y=\"0.5\" t=\"3400\"/>\n  <p x=\"-0.5\" y=\"0.3\" t=\"5400\"/>\n </position>\n <roll>\n  <r d=\"0\" t=\"0\"/>\n  <r d=\"1080\" t=\"3400\"/>\n  <r d=\"1560\" t=\"5400\"/>\n </roll>\n</scroll>\n\n<obstacle>\n <o x=\"0\" y=\"0\" w=\"0.3\" h=\"0.3\"/>\n <o x=\"0\" y=\"-0.2625\" w=\"0.3\" h=\"0.3\"/>\n <o x=\"0.245\" y=\"-0.18375\" w=\"0.3\" h=\"0.3\"/>\n <o x=\"0.35\" y=\"0\" w=\"0.3\" h=\"0.3\"/>\n <o x=\"0.245\" y=\"0.18375\" w=\"0.3\" h=\"0.3\"/>\n <o x=\"0\" y=\"0.2625\" w=\"0.3\" h=\"0.3\"/>\n <o x=\"-0.245\" y=\"0.18375\" w=\"0.3\" h=\"0.3\"/>\n <o x=\"-0.35\" y=\"0\" w=\"0.3\" h=\"0.3\"/>\n <o x=\"-0.245\" y=\"-0.18375\" w=\"0.3\" h=\"0.3\"/>\n</obstacle>\n\n<battery>\n <b x=\"0\" y=\"-0.375\" d=\"180\" color=\"white\" name=\"raf_w.xml\"/>\n <b x=\"0.35\" y=\"-0.2625\" d=\"135\" color=\"white\" name=\"raf_w.xml\"/>\n <b x=\"0.5\" y=\"0\" d=\"90\" color=\"white\" name=\"raf_w.xml\"/>\n <b x=\"0.35\" y=\"0.2625\" d=\"45\" color=\"white\" name=\"raf_w.xml\"/>\n <b x=\"0\" y=\"0.375\" d=\"0\" color=\"white\" name=\"raf_w.xml\"/>\n <b x=\"-0.35\" y=\"0.2625\" d=\"315\" color=\"white\" name=\"raf_w.xml\"/>\n <b x=\"-0.5\" y=\"0\" d=\"270\" color=\"white\" name=\"raf_w.xml\"/>\n <b x=\"-0.35\" y=\"-0.2625\" d=\"225\" color=\"white\" name=\"raf_w.xml\"/>\n\n <b x=\"0.19\" y=\"-0.346\" d=\"157.5\" color=\"black\" name=\"raf_b.xml\"/>\n <b x=\"0.46\" y=\"-0.144\" d=\"112.5\" color=\"black\" name=\"raf_b.xml\"/>\n <b x=\"0.46\" y=\"0.144\" d=\"67.5\" color=\"black\" name=\"raf_b.xml\"/>\n <b x=\"0.19\" y=\"0.346\" d=\"22.5\" color=\"black\" name=\"raf_b.xml\"/>\n <b x=\"-0.19\" y=\"0.346\" d=\"337.5\" color=\"black\" name=\"raf_b.xml\"/>\n <b x=\"-0.46\" y=\"0.144\" d=\"292.5\" color=\"black\" name=\"raf_b.xml\"/>\n <b x=\"-0.46\" y=\"-0.144\" d=\"247.5\" color=\"black\" name=\"raf_b.xml\"/>\n <b x=\"-0.19\" y=\"-0.346\" d=\"202.5\" color=\"black\" name=\"raf_b.xml\"/>\n</battery>\n\n</narihira>\n"
),
new NarihiraData(
"rafflesia_another",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE narihira SYSTEM \"narihira.dtd\">\n\n<narihira xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml/narihira\">\n\n<scroll>\n <position>\n  <p x=\"0\" y=\"-0.5\" t=\"0\"/>\n  <p x=\"0.5\" y=\"0.5\" t=\"3000\"/>\n  <p x=\"0.5\" y=\"1.5\" t=\"3400\"/>\n </position>\n <roll>\n  <r d=\"0\" t=\"0\"/>\n  <r d=\"1080\" t=\"3400\"/>\n </roll>\n</scroll>\n\n<obstacle>\n <o x=\"0\" y=\"0\" w=\"0.3\" h=\"0.3\"/>\n <o x=\"0\" y=\"-0.2625\" w=\"0.3\" h=\"0.3\"/>\n <o x=\"0.245\" y=\"-0.18375\" w=\"0.3\" h=\"0.3\"/>\n <o x=\"0.35\" y=\"0\" w=\"0.3\" h=\"0.3\"/>\n <o x=\"0.245\" y=\"0.18375\" w=\"0.3\" h=\"0.3\"/>\n <o x=\"0\" y=\"0.2625\" w=\"0.3\" h=\"0.3\"/>\n <o x=\"-0.245\" y=\"0.18375\" w=\"0.3\" h=\"0.3\"/>\n <o x=\"-0.35\" y=\"0\" w=\"0.3\" h=\"0.3\"/>\n <o x=\"-0.245\" y=\"-0.18375\" w=\"0.3\" h=\"0.3\"/>\n</obstacle>\n\n<battery>\n<!--\n <b x=\"0\" y=\"-0.375\" rank=\"0\" color=\"white\" name=\"rf_l.xml\"/>\n <b x=\"0.35\" y=\"-0.2625\" rank=\"0\" d=\"45\" color=\"black\" name=\"rf_l.xml\"/>\n <b x=\"0.5\" y=\"0\" rank=\"0\" color=\"white\" name=\"rf_l.xml\"/>\n <b x=\"0.35\" y=\"0.2625\" rank=\"0\" d=\"45\" color=\"black\" name=\"rf_l.xml\"/>\n <b x=\"0\" y=\"0.375\" rank=\"0\" color=\"white\" name=\"rf_l.xml\"/>\n <b x=\"-0.35\" y=\"0.2625\" rank=\"0\" d=\"45\" color=\"black\" name=\"rf_l.xml\"/>\n <b x=\"-0.5\" y=\"0\" rank=\"0\" color=\"white\" name=\"rf_l.xml\"/>\n <b x=\"-0.35\" y=\"-0.2625\" rank=\"0\" d=\"45\" color=\"black\" name=\"rf_l.xml\"/>\n-->\n <b x=\"0\" y=\"-0.375\" rank=\"1\" color=\"white\" name=\"rf_l.xml\"/>\n <b x=\"0.5\" y=\"0\" rank=\"1\" color=\"black\" name=\"rf_r.xml\"/>\n <b x=\"0\" y=\"0.375\" rank=\"1\" color=\"white\" name=\"rf_l.xml\"/>\n <b x=\"-0.5\" y=\"0\" rank=\"1\" color=\"black\" name=\"rf_r.xml\"/>\n</battery>\n\n</narihira>\n"
),
new NarihiraData(
"concentrated",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE narihira SYSTEM \"narihira.dtd\">\n\n<narihira xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml/narihira\">\n\n<scroll>\n <position>\n  <p x=\"0\" y=\"0\" t=\"0\"/>\n  <p x=\"0\" y=\"8.5\" t=\"1400\"/>\n </position>\n</scroll>\n\n<battery>\n <b x=\"-0.5\" y=\"1\" color=\"-2\" scroll=\"no\" name=\"r5_vrp.xml\"/>\n <b x=\"0.4\" y=\"1.1\" color=\"-2\" scroll=\"no\" name=\"r5_vrp.xml\"/>\n <b x=\"-0.3\" y=\"1.2\" color=\"-2\" scroll=\"no\" name=\"r5_vrp.xml\"/>\n <b x=\"0.2\" y=\"1.3\" color=\"-2\" scroll=\"no\" name=\"r5_vrp.xml\"/>\n\n <b x=\"0\" y=\"2\" color=\"-6\" scroll=\"no\" name=\"r5_rc.xml\"/>\n <b x=\"0\" y=\"3\" color=\"-5\" scroll=\"no\" name=\"r5_rc.xml\"/>\n\n <b x=\"0\" y=\"3.8\" color=\"-6\" scroll=\"no\" name=\"r5_rc.xml\"/>\n <b x=\"-0.5\" y=\"3.9\" color=\"-1\" scroll=\"no\" name=\"r5_vrp.xml\"/>\n <b x=\"0\" y=\"4\" color=\"-1\" scroll=\"no\" name=\"r5_vrp.xml\"/>\n <b x=\"-0.5\" y=\"4.1\" color=\"-1\" scroll=\"no\" name=\"r5_vrp.xml\"/>\n <b x=\"0\" y=\"4.7\" color=\"-5\" scroll=\"no\" name=\"r5_rc.xml\"/>\n <b x=\"-0.5\" y=\"4.8\" color=\"-2\" scroll=\"no\" name=\"r5_vrp.xml\"/>\n <b x=\"0\" y=\"4.9\" color=\"-2\" scroll=\"no\" name=\"r5_vrp.xml\"/>\n <b x=\"-0.5\" y=\"5\" color=\"-2\" scroll=\"no\" name=\"r5_vrp.xml\"/>\n\n <b x=\"0\" y=\"5.5\" color=\"-6\" scroll=\"no\" name=\"r5_rc.xml\"/>\n <b x=\"0\" y=\"6\" color=\"-5\" scroll=\"no\" name=\"r5_rc.xml\"/>\n <b x=\"0\" y=\"6.5\" color=\"-6\" scroll=\"no\" name=\"r5_rc.xml\"/>\n <b x=\"0\" y=\"7\" color=\"-5\" scroll=\"no\" name=\"r5_rc.xml\"/>\n <b x=\"0\" y=\"7.4\" color=\"-6\" scroll=\"no\" name=\"r5_rc.xml\"/>\n <b x=\"0\" y=\"7.8\" color=\"-5\" scroll=\"no\" name=\"r5_rc.xml\"/>\n <b x=\"0\" y=\"8.2\" color=\"-6\" scroll=\"no\" name=\"r5_rc.xml\"/>\n <b x=\"0\" y=\"8.6\" color=\"-5\" scroll=\"no\" name=\"r5_rc.xml\"/>\n<!--\n <b x=\"0\" y=\"8.1\" color=\"-6\" scroll=\"no\" name=\"r5_rc.xml\"/>\n <b x=\"0\" y=\"8.3\" color=\"-5\" scroll=\"no\" name=\"r5_rc.xml\"/>\n <b x=\"0\" y=\"8.4\" color=\"-6\" scroll=\"no\" name=\"r5_rc.xml\"/>\n <b x=\"0\" y=\"8.5\" color=\"-5\" scroll=\"no\" name=\"r5_rc.xml\"/>\n-->\n\n</battery>\n\n</narihira>\n"
),
new NarihiraData(
"wb_winder",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE narihira SYSTEM \"narihira.dtd\">\n\n<narihira xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml/narihira\">\n\n<scroll>\n <position>\n  <p x=\"0\" y=\"0\" t=\"0\"/>\n  <p x=\"0\" y=\"0\" t=\"2450\"/>\n </position>\n</scroll>\n\n<obstacle>\n <o x=\"0\" y=\"0.8\" w=\"1.5\" h=\"0.6\"/>\n</obstacle>\n\n<battery>\n <b x=\"-0.6\" y=\"0.6\" color=\"black\" width=\"3\" name=\"wnd_r.xml\"/>\n <b x=\"-0.3\" y=\"0.6\" color=\"white\" width=\"3\" name=\"wnd_r.xml\"/>\n <b x=\"0.3\" y=\"0.6\" color=\"white\" width=\"3\" name=\"wnd_l.xml\"/>\n <b x=\"0.6\" y=\"0.6\" color=\"black\" width=\"3\" name=\"wnd_l.xml\"/>\n\n <b x=\"-0.8\" y=\"0.6\" color=\"black\" width=\"8\" name=\"drc.xml\"/>\n <b x=\"0.8\" y=\"0.6\" color=\"white\" width=\"8\" name=\"drc.xml\"/>\n\n <b x=\"-0.6\" y=\"0.6\" t=\"240\" color=\"black\" width=\"15\" name=\"hrm_d2.xml\"/>\n <b x=\"-0.3\" y=\"0.6\" t=\"480\" color=\"white\" width=\"15\" name=\"hrm_d2.xml\"/>\n <b x=\"0.3\" y=\"0.6\" t=\"720\" color=\"white\" width=\"15\" name=\"hrm_d2.xml\"/>\n <b x=\"0.6\" y=\"0.6\" t=\"960\" color=\"black\" width=\"15\" name=\"hrm_d2.xml\"/>\n <b x=\"-0.6\" y=\"0.6\" t=\"1200\" color=\"black\" width=\"15\" name=\"hrm_d2.xml\"/>\n <b x=\"-0.3\" y=\"0.6\" t=\"1440\" color=\"white\" width=\"15\" name=\"hrm_d2.xml\"/>\n <b x=\"0.3\" y=\"0.6\" t=\"1680\" color=\"white\" width=\"15\" name=\"hrm_d2.xml\"/>\n <b x=\"0.6\" y=\"0.6\" t=\"1920\" color=\"black\" width=\"15\" name=\"hrm_d2.xml\"/>\n\n</battery>\n\n</narihira>\n"
),
new NarihiraData(
"claw",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE narihira SYSTEM \"narihira.dtd\">\n\n<narihira xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml/narihira\">\n\n<scroll>\n <position>\n  <p x=\"0\" y=\"0\" t=\"0\"/>\n  <p x=\"0\" y=\"0\" t=\"2900\"/>\n </position>\n</scroll>\n\n<obstacle>\n <o x=\"0\" y=\"0.8\" w=\"1.5\" h=\"0.6\"/>\n</obstacle>\n\n<battery>\n <b x=\"-0.6\" y=\"0.6\" t=\"0\" rank=\"0\" color=\"99\" width=\"6\" name=\"clw.xml\"/>\n <b x=\"0.6\" y=\"0.6\" t=\"600\" rank=\"0.2\" color=\"98\" width=\"6\" name=\"clw.xml\"/>\n <b x=\"-0.6\" y=\"0.6\" t=\"1000\" rank=\"0.4\" color=\"99\" width=\"6\" name=\"clw.xml\"/>\n <b x=\"0.6\" y=\"0.6\" t=\"1200\" rank=\"0.6\" color=\"98\" width=\"6\" name=\"clw.xml\"/>\n <b x=\"-0.6\" y=\"0.6\" t=\"2000\" rank=\"0.8\" color=\"99\" width=\"6\" name=\"clw.xml\"/>\n <b x=\"0.6\" y=\"0.6\" t=\"1800\" rank=\"1\" color=\"98\" width=\"6\" name=\"clw.xml\"/>\n\n <b x=\"-0.8\" y=\"0.6\" t=\"0\" rank=\"0\" color=\"black\" width=\"6\" name=\"drc2.xml\"/>\n <b x=\"0.8\" y=\"0.6\" t=\"90\" rank=\"0\" color=\"white\" width=\"6\" name=\"drc2.xml\"/>\n</battery>\n\n</narihira>\n"
),
new NarihiraData(
"wb_laser",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE narihira SYSTEM \"narihira.dtd\">\n\n<narihira xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml/narihira\">\n\n<scroll>\n <position>\n  <p x=\"0\" y=\"0\" t=\"0\"/>\n  <p x=\"0\" y=\"0\" t=\"3600\"/>\n </position>\n</scroll>\n\n<obstacle>\n <o x=\"0\" y=\"0.8\" w=\"1.0\" h=\"0.6\"/>\n</obstacle>\n\n<battery>\n <b x=\"0\" y=\"0.8\" t=\"0\" rank=\"0\" color=\"white\" width=\"8\" name=\"lsr.xml\"/>\n <b x=\"0\" y=\"0.8\" t=\"180\" rank=\"0\" color=\"black\" width=\"8\" name=\"lsr.xml\"/>\n <b x=\"0\" y=\"0.8\" t=\"720\" rank=\"0.2\" color=\"white\" width=\"8\" name=\"lsr.xml\"/>\n <b x=\"0\" y=\"0.8\" t=\"875\" rank=\"0.2\" color=\"black\" width=\"8\" name=\"lsr.xml\"/>\n <b x=\"0\" y=\"0.8\" t=\"1340\" rank=\"0.4\" color=\"white\" width=\"8\" name=\"lsr.xml\"/>\n <b x=\"0\" y=\"0.8\" t=\"1468\" rank=\"0.4\" color=\"black\" width=\"8\" name=\"lsr.xml\"/>\n <b x=\"0\" y=\"0.8\" t=\"1852\" rank=\"0.6\" color=\"white\" width=\"8\" name=\"lsr.xml\"/>\n <b x=\"0\" y=\"0.8\" t=\"1954\" rank=\"0.6\" color=\"black\" width=\"8\" name=\"lsr.xml\"/>\n <b x=\"0\" y=\"0.8\" t=\"2260\" rank=\"0.8\" color=\"white\" width=\"8\" name=\"lsr.xml\"/>\n <b x=\"0\" y=\"0.8\" t=\"2336\" rank=\"0.8\" color=\"black\" width=\"8\" name=\"lsr.xml\"/>\n <b x=\"0\" y=\"0.8\" t=\"2564\" rank=\"0.9\" color=\"white\" width=\"8\" name=\"lsr.xml\"/>\n <b x=\"0\" y=\"0.8\" t=\"2627\" rank=\"0.9\" color=\"black\" width=\"8\" name=\"lsr.xml\"/>\n <b x=\"0\" y=\"0.8\" t=\"2816\" rank=\"1\" color=\"white\" width=\"8\" name=\"lsr.xml\"/>\n <b x=\"0\" y=\"0.8\" t=\"2866\" rank=\"1\" color=\"black\" width=\"8\" name=\"lsr.xml\"/>\n <b x=\"0\" y=\"0.8\" t=\"3016\" rank=\"1\" color=\"white\" width=\"8\" name=\"lsr.xml\"/>\n <b x=\"0\" y=\"0.8\" t=\"3066\" rank=\"1\" color=\"black\" width=\"8\" name=\"lsr.xml\"/>\n\n <b x=\"-0.2\" y=\"1\" t=\"0\" rank=\"0\" color=\"black\" width=\"8\" name=\"drc3.xml\"/>\n <b x=\"0.2\" y=\"1\" t=\"0\" rank=\"0\" color=\"white\" width=\"8\" name=\"drc3.xml\"/>\n <b x=\"-0.2\" y=\"1\" t=\"800\" rank=\"0.4\" color=\"black\" width=\"8\" name=\"drc3.xml\"/>\n <b x=\"0.2\" y=\"1\" t=\"800\" rank=\"0.4\" color=\"white\" width=\"8\" name=\"drc3.xml\"/>\n <b x=\"-0.2\" y=\"1\" t=\"1600\" rank=\"0.8\" color=\"black\" width=\"8\" name=\"drc3.xml\"/>\n <b x=\"0.2\" y=\"1\" t=\"1600\" rank=\"0.8\" color=\"white\" width=\"8\" name=\"drc3.xml\"/>\n <b x=\"-0.2\" y=\"1\" t=\"2400\" rank=\"1\" color=\"black\" width=\"8\" name=\"drc3.xml\"/>\n <b x=\"0.2\" y=\"1\" t=\"2400\" rank=\"1\" color=\"white\" width=\"8\" name=\"drc3.xml\"/>\n</battery>\n\n</narihira>\n"
),
};

  public static Hashtable narihiraDatas;

  static {
    narihiraDatas = new Hashtable();
    for ( int i=0 ; i<data.length ; i++ ) {
      narihiraDatas.put(data[i].name, data[i].context);
    }
  }

  private static final String DTD_NAME
   = "narihira.dtd";
  private static final String DTD_WEB_URL
   = "http://www.asahi-net.or.jp/~cs8k-cyu/bulletml/narihira/narihira.dtd";
  private static final String DTD_FILE_URL
   = "file:///e:\\usr\\narihira\\narihira.dtd";

  public String name;
  public String context;

  public NarihiraData(String name, String context) {
    this.name = name;
    int dtdIdx = context.indexOf(DTD_NAME);
    if ( dtdIdx != -1 ) {
      StringBuffer cnt = new StringBuffer();
      cnt.append(context.substring(0, dtdIdx));
      cnt.append(DTD_WEB_URL);
      //cnt.append(DTD_FILE_URL);
      cnt.append(context.substring(dtdIdx+DTD_NAME.length()));
      this.context = cnt.toString();
    } else {
      this.context = context;
    }
  }
}
