/*
 * $Id: Narihira.java,v 1.1.1.1 2002/02/07 15:20:13 kenta Exp $
 *
 * Copyright 2002 Kenta Cho. All rights reserved.
 */
package jp.gr.java_conf.abagames.narihira;

import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.io.*;

/**
 * Narihira applet main routine.
 *
 * @version $Revision: 1.1.1.1 $
 */
public class Narihira extends Applet {

  private Screen screen;
  private GameManager gameManager;

  public void init() {
    //BulletmlUtil.setConsole(consoleArea);
    startBullets();
  }

  public static final int SCREEN_WIDTH = 360;
  public static final int SCREEN_HEIGHT = 480;
  //public static final int SCREEN_WIDTH = 45;
  //public static final int SCREEN_HEIGHT = 60;

  private boolean startReady = false;

  private void restartGame() {
    if ( gameManager != null ) {
      gameManager.restart();
      gameManager = null;
      screen = null;
    }
  }

  private boolean firstRepaint = false;

  private void startBullets() {
    restartGame();
    screen = new Screen();
    gameManager = new GameManager();
    gameManager.init(this, screen);
    gameManager.initAll();

    firstRepaint = true;
    repaint();
  }

  public void stop() {
    restartGame();
  }

  public void destroy() {
    restartGame();
  }

  /*public void exceptionOccured(Exception e) {
    try {
      StringWriter strWriter = new StringWriter();
      PrintWriter writer = new PrintWriter(strWriter);
      e.printStackTrace(writer);
      consoleArea.append(strWriter.toString());
      writer.close();
      strWriter.close();
    } catch ( IOException ioe ) {}
    restartGame();
  }*/

  public void paint(Graphics g) {
    if ( screen != null ) {
      screen.makeBuffer(this);
      if ( gameManager != null && firstRepaint ) {
        firstRepaint = false;
        gameManager.startTitle();
        gameManager.start();
      }
    }
  }

  public void update(Graphics g) {
    paint(g);
  }

  public boolean handleEvent(Event event) {
    if ( gameManager != null && event.target == this ) {
      switch ( event.id ) {
      case Event.MOUSE_MOVE:
        gameManager.setMousePos(event.x, event.y);
        return true;
      case Event.MOUSE_DOWN:
        gameManager.mousePressed();
        return true;
      }
    }
    return false;
  }

  public static void main(String[] args) {
    Narihira nrhr = new Narihira();
    Frame frame;
    frame = new Frame() {
      protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == WindowEvent.WINDOW_CLOSING) {
          System.exit(0);
        }
      }
      //**
      /*protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        if (e.getKeyCode() == KeyEvent.VK_ESCAPE) {
          System.exit(0);
        }
      }*/
      public synchronized void setTitle(String title) {
        super.setTitle(title);
        enableEvents(AWTEvent.WINDOW_EVENT_MASK);
        //enableEvents(AWTEvent.KEY_EVENT_MASK);
      }
    };
    frame.setTitle("Narihira");
    frame.add(nrhr, BorderLayout.CENTER);
    nrhr.init();
    nrhr.start();
    frame.setSize(SCREEN_WIDTH, SCREEN_HEIGHT);
    //frame.setSize(45, 90);
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    frame.setLocation((d.width - frame.getSize().width) / 2, (d.height - frame.getSize().height) / 2);
    frame.setVisible(true);
  }
}
