/*
 * $Id: LetterRender.java,v 1.1.1.1 2002/02/07 15:20:13 kenta Exp $
 *
 * Copyright 2002 Kenta Cho. All rights reserved.
 */
package jp.gr.java_conf.abagames.narihira;

import jp.gr.java_conf.abagames.util.SCTable;
/**
 * Render letters.
 *
 * @version $Revision: 1.1.1.1 $
 */
public class LetterRender {

  private int[] texture;
  private static final int TEXTURE_WIDTH = Screen.SCREEN_WIDTH;
  private static final int TEXTURE_HEIGHT = Screen.SCREEN_HEIGHT;

  public LetterRender(int[] texture) {
    this.texture = texture;
  }

  public void drawBox(int x1, int y1, int x2, int y2, int color) {
    for ( int y=y1 ; y<=y2 ; y++ ) {
      for ( int x=x1 ; x<=x2 ; x++ ) {
        texture[x+y*TEXTURE_WIDTH] = color | 0xff000000;
      }
    }
  }

  private int[] min = new int[TEXTURE_HEIGHT];
  private int[] max = new int[TEXTURE_HEIGHT];

  private void scanEdge(int[] v1, int[] v2) {
    int l = Math.abs((int)(v2[1] -v1[1])) + 1;

    int addx = (int)((v2[0] - v1[0]) * 0xffff) / l;
    int addy = (int)((v2[1] - v1[1]) * 0xffff) / l;

    int x = (int)(v1[0] * 0xffff);
    int y = (int)(v1[1] * 0xffff);

    for ( int i=0 ; i<l ; i++, x+=addx, y+=addy ) {
      int py = y>>16;
      int px = x>>16;
      if (py < 0 || py >= TEXTURE_HEIGHT ) continue;
      if ( min [py] > px ) {
        min [py] = px;
      }
      if ( max [py] < px ){
        max [py] = px;
      }
    }
  }

  public final void drawLetter(int idx, int lx, int ly, int ltSize, int color) {
    int[][] vtxs = new int[6][2];
    for ( int i=0 ; i<spData[idx].length ; i++ ) {
      float[][] indices = new float[6][2];
      float x = spData[idx][i][0], y = -spData[idx][i][1],
       length = spData[idx][i][2]/2, size = spData[idx][i][3]/2;
      int deg = (int)spData[idx][i][4]*256/360;
      indices[0][0] = -length-size;
      indices[1][0] = -length; indices[1][1] = size;
      indices[2][0] =  length; indices[2][1] = size;
      indices[3][0] =  length+size;
      indices[4][0] =  length; indices[4][1] = -size;
      indices[5][0] = -length; indices[5][1] = -size;
      int minY = TEXTURE_HEIGHT-1, maxY = 0;
      for ( int j=0 ; j<6 ; j++ ) {
        float
         rx = ((indices[j][0]*SCTable.costbl[deg]
         - indices[j][1]*SCTable.sintbl[deg])/256) + x,
         ry = ((indices[j][0]*SCTable.sintbl[deg]
         + indices[j][1]*SCTable.costbl[deg])/256) + y;
        vtxs[j][0]= (int)(rx*ltSize + lx);
        int vy = vtxs[j][1] = (int)(ry*ltSize + ly);
        if ( vy > maxY ) maxY = vy;
        if ( vy < minY ) minY = vy;
      }
      if ( minY < 0 ) minY = 0;
      if ( maxY >= TEXTURE_HEIGHT ) maxY = TEXTURE_HEIGHT-1;
      for ( int j=minY ; j<=maxY ; j++ ) {
        min[j] = TEXTURE_WIDTH-1; max[j] = 0;
      }
      for ( int j=0 ; j<5 ; j++ ) {
        scanEdge(vtxs[j], vtxs[j+1]);
      }
      for ( int j=minY ; j<=maxY ; j++ ) {
        int minX = min[j], maxX = max[j];
        if ( minX < 0 ) minX = 0;
        if ( maxX >= TEXTURE_WIDTH ) maxX = TEXTURE_WIDTH-1;
        for ( int vx=minX ; vx<=maxX ; vx++ ) {
          texture[vx+j*TEXTURE_WIDTH] = color | 0xff000000;
        }
      }
    }
  }

    float[][][] spData = {{
     {0, 1.15f, 0.65f, 0.3f, 0},
     {-0.6f, 0.55f, 0.65f, 0.3f, 90}, {0.6f, 0.55f, 0.65f, 0.3f, 90},
     {-0.6f, -0.55f, 0.65f, 0.3f, 90}, {0.6f, -0.55f, 0.65f, 0.3f, 90},
     {0, -1.15f, 0.65f, 0.3f, 0},
    },{
     {0, 0.55f, 0.65f, 0.3f, 90},
     {0, -0.55f, 0.65f, 0.3f, 90},
    },{
     {0, 1.15f, 0.65f, 0.3f, 0},
     {0.65f, 0.55f, 0.65f, 0.3f, 90},
     {0, 0, 0.65f, 0.3f, 0},
     {-0.65f, -0.55f, 0.65f, 0.3f, 90},
     {0, -1.15f, 0.65f, 0.3f, 0},
    },{
     {0, 1.15f, 0.65f, 0.3f, 0},
     {0.65f, 0.55f, 0.65f, 0.3f, 90},
     {0, 0, 0.65f, 0.3f, 0},
     {0.65f, -0.55f, 0.65f, 0.3f, 90},
     {0, -1.15f, 0.65f, 0.3f, 0},
    },{
     {-0.65f, 0.55f, 0.65f, 0.3f, 90}, {0.65f, 0.55f, 0.65f, 0.3f, 90},
     {0, 0, 0.65f, 0.3f, 0},
     {0.65f, -0.55f, 0.65f, 0.3f, 90},
    },{
     {0, 1.15f, 0.65f, 0.3f, 0},
     {-0.65f, 0.55f, 0.65f, 0.3f, 90},
     {0, 0, 0.65f, 0.3f, 0},
     {0.65f, -0.55f, 0.65f, 0.3f, 90},
     {0, -1.15f, 0.65f, 0.3f, 0},
    },{
     {0, 1.15f, 0.65f, 0.3f, 0},
     {-0.65f, 0.55f, 0.65f, 0.3f, 90},
     {0, 0, 0.65f, 0.3f, 0},
     {-0.65f, -0.55f, 0.65f, 0.3f, 90}, {0.65f, -0.55f, 0.65f, 0.3f, 90},
     {0, -1.15f, 0.65f, 0.3f, 0},
    },{
     {0, 1.15f, 0.65f, 0.3f, 0},
     {0.65f, 0.55f, 0.65f, 0.3f, 90},
     {0.65f, -0.55f, 0.65f, 0.3f, 90},
    },{
     {0, 1.15f, 0.65f, 0.3f, 0},
     {-0.65f, 0.55f, 0.65f, 0.3f, 90}, {0.65f, 0.55f, 0.65f, 0.3f, 90},
     {0, 0, 0.65f, 0.3f, 0},
     {-0.65f, -0.55f, 0.65f, 0.3f, 90}, {0.65f, -0.55f, 0.65f, 0.3f, 90},
     {0, -1.15f, 0.65f, 0.3f, 0},
    },{
     {0, 1.15f, 0.65f, 0.3f, 0},
     {-0.65f, 0.55f, 0.65f, 0.3f, 90}, {0.65f, 0.55f, 0.65f, 0.3f, 90},
     {0, 0, 0.65f, 0.3f, 0},
     {0.65f, -0.55f, 0.65f, 0.3f, 90},
     {0, -1.15f, 0.65f, 0.3f, 0},
    },{
     //A
     {0, 1.15f, 0.65f, 0.3f, 0},
     {-0.65f, 0.55f, 0.65f, 0.3f, 90}, {0.65f, 0.55f, 0.65f, 0.3f, 90},
     {0, 0, 0.65f, 0.3f, 0},
     {-0.65f, -0.55f, 0.65f, 0.3f, 90}, {0.65f, -0.55f, 0.65f, 0.3f, 90},
    },{
     {-0.1f, 1.15f, 0.45f, 0.3f, 0},
     {-0.65f, 0.55f, 0.65f, 0.3f, 90}, {0.45f, 0.55f, 0.65f, 0.3f, 90},
     {-0.1f, 0, 0.45f, 0.3f, 0},
     {-0.65f, -0.55f, 0.65f, 0.3f, 90}, {0.65f, -0.55f, 0.65f, 0.3f, 90},
     {0, -1.15f, 0.65f, 0.3f, 0},
    },{
     {0, 1.15f, 0.65f, 0.3f, 0},
     {-0.65f, 0.55f, 0.65f, 0.3f, 90},
     {-0.65f, -0.55f, 0.65f, 0.3f, 90},
     {0, -1.15f, 0.65f, 0.3f, 0},
    },{
     {-0.1f, 1.15f, 0.45f, 0.3f, 0},
     {-0.65f, 0.55f, 0.65f, 0.3f, 90}, {0.45f, 0.4f, 0.65f, 0.3f, 90},
     {-0.65f, -0.55f, 0.65f, 0.3f, 90}, {0.65f, -0.55f, 0.65f, 0.3f, 90},
     {0, -1.15f, 0.65f, 0.3f, 0},
    },{
     {0, 1.15f, 0.65f, 0.3f, 0},
     {-0.65f, 0.55f, 0.65f, 0.3f, 90},
     {0, 0, 0.65f, 0.3f, 0},
     {-0.65f, -0.55f, 0.65f, 0.3f, 90},
     {0, -1.15f, 0.65f, 0.3f, 0},
    },{// F
     {0, 1.15f, 0.65f, 0.3f, 0},
     {-0.65f, 0.55f, 0.65f, 0.3f, 90},
     {0, 0, 0.65f, 0.3f, 0},
     {-0.65f, -0.55f, 0.65f, 0.3f, 90},
    },{
     {0, 1.15f, 0.65f, 0.3f, 0},
     {-0.65f, 0.55f, 0.65f, 0.3f, 90},
     {0.25f, 0, 0.25f, 0.3f, 0},
     {-0.65f, -0.55f, 0.65f, 0.3f, 90}, {0.65f, -0.55f, 0.65f, 0.3f, 90},
     {0, -1.15f, 0.65f, 0.3f, 0},
    },{
     {-0.65f, 0.55f, 0.65f, 0.3f, 90}, {0.65f, 0.55f, 0.65f, 0.3f, 90},
     {0, 0, 0.65f, 0.3f, 0},
     {-0.65f, -0.55f, 0.65f, 0.3f, 90}, {0.65f, -0.55f, 0.65f, 0.3f, 90},
    },{
     {0, 0.55f, 0.65f, 0.3f, 90},
     {0, -0.55f, 0.65f, 0.3f, 90},
    },{
     {-0.65f, 0.55f, 0.65f, 0.3f, 90},
     {-0.65f, -0.55f, 0.65f, 0.3f, 90}, {0.65f, -0.75f, 0.25f, 0.3f, 90},
     {0, -1.15f, 0.65f, 0.3f, 0},
    },{//K
     {-0.65f, 0.55f, 0.65f, 0.3f, 90}, {0.45f, 0.55f, 0.65f, 0.3f, 90},
     {-0.1f, 0, 0.45f, 0.3f, 0},
     {-0.65f, -0.55f, 0.65f, 0.3f, 90}, {0.65f, -0.55f, 0.65f, 0.3f, 90},
    },{
     {-0.65f, 0.55f, 0.65f, 0.3f, 90},
     {-0.65f, -0.55f, 0.65f, 0.3f, 90},
     {0, -1.15f, 0.65f, 0.3f, 0},
    },{
     {-0.3f, 1.15f, 0.25f, 0.3f, 0}, {0.3f, 1.15f, 0.25f, 0.3f, 0},
     {-0.65f, 0.55f, 0.65f, 0.3f, 90}, {0.65f, 0.55f, 0.65f, 0.3f, 90},
     {-0.65f, -0.55f, 0.65f, 0.3f, 90}, {0.65f, -0.55f, 0.65f, 0.3f, 90},
     {0, 0.55f, 0.65f, 0.3f, 90},
     {0, -0.55f, 0.65f, 0.3f, 90},
    },{
     {0, 1.15f, 0.65f, 0.3f, 0},
     {-0.65f, 0.55f, 0.65f, 0.3f, 90}, {0.65f, 0.55f, 0.65f, 0.3f, 90},
     {-0.65f, -0.55f, 0.65f, 0.3f, 90}, {0.65f, -0.55f, 0.65f, 0.3f, 90},
    },{
     {0, 1.15f, 0.65f, 0.3f, 0},
     {-0.65f, 0.55f, 0.65f, 0.3f, 90}, {0.65f, 0.55f, 0.65f, 0.3f, 90},
     {-0.65f, -0.55f, 0.65f, 0.3f, 90}, {0.65f, -0.55f, 0.65f, 0.3f, 90},
     {0, -1.15f, 0.65f, 0.3f, 0},
    },{//P
     {0, 1.15f, 0.65f, 0.3f, 0},
     {-0.65f, 0.55f, 0.65f, 0.3f, 90}, {0.65f, 0.55f, 0.65f, 0.3f, 90},
     {0, 0, 0.65f, 0.3f, 0},
     {-0.65f, -0.55f, 0.65f, 0.3f, 90},
    },{
     {0, 1.15f, 0.65f, 0.3f, 0},
     {-0.65f, 0.55f, 0.65f, 0.3f, 90}, {0.65f, 0.55f, 0.65f, 0.3f, 90},
     {-0.65f, -0.55f, 0.65f, 0.3f, 90}, {0.65f, -0.55f, 0.65f, 0.3f, 90},
     {0, -1.15f, 0.65f, 0.3f, 0},
     {0.2f, -0.6f, 0.45f, 0.3f, 360-300},
    },{
     {0, 1.15f, 0.65f, 0.3f, 0},
     {-0.65f, 0.55f, 0.65f, 0.3f, 90}, {0.65f, 0.55f, 0.65f, 0.3f, 90},
     {-0.1f, 0, 0.45f, 0.3f, 0},
     {-0.65f, -0.55f, 0.65f, 0.3f, 90}, {0.45f, -0.55f, 0.65f, 0.3f, 90},
    },{
     {0, 1.15f, 0.65f, 0.3f, 0},
     {-0.65f, 0.55f, 0.65f, 0.3f, 90},
     {0, 0, 0.65f, 0.3f, 0},
     {0.65f, -0.55f, 0.65f, 0.3f, 90},
     {0, -1.15f, 0.65f, 0.3f, 0},
    },{
     {-0.4f, 1.15f, 0.45f, 0.3f, 0}, {0.4f, 1.15f, 0.45f, 0.3f, 0},
     {0, 0.55f, 0.65f, 0.3f, 90},
     {0, -0.55f, 0.65f, 0.3f, 90},
    },{//U
     {-0.65f, 0.55f, 0.65f, 0.3f, 90}, {0.65f, 0.55f, 0.65f, 0.3f, 90},
     {-0.65f, -0.55f, 0.65f, 0.3f, 90}, {0.65f, -0.55f, 0.65f, 0.3f, 90},
     {0, -1.15f, 0.65f, 0.3f, 0},
    },{
     {-0.65f, 0.55f, 0.65f, 0.3f, 90}, {0.65f, 0.55f, 0.65f, 0.3f, 90},
     {-0.5f, -0.55f, 0.65f, 0.3f, 90}, {0.5f, -0.55f, 0.65f, 0.3f, 90},
     {0, -1.15f, 0.45f, 0.3f, 0},
    },{
     {-0.65f, 0.55f, 0.65f, 0.3f, 90}, {0.65f, 0.55f, 0.65f, 0.3f, 90},
     {-0.65f, -0.55f, 0.65f, 0.3f, 90}, {0.65f, -0.55f, 0.65f, 0.3f, 90},
     {-0.3f, -1.15f, 0.25f, 0.3f, 0}, {0.3f, -1.15f, 0.25f, 0.3f, 0},
     {0, 0.55f, 0.65f, 0.3f, 90},
     {0, -0.55f, 0.65f, 0.3f, 90},
    },{
     {-0.4f, 0.6f, 0.85f, 0.3f, 360-120},
     {0.4f, 0.6f, 0.85f, 0.3f, 360-60},
     {-0.4f, -0.6f, 0.85f, 0.3f, 360-240},
     {0.4f, -0.6f, 0.85f, 0.3f, 360-300},
    },{
     {-0.4f, 0.6f, 0.85f, 0.3f, 360-120},
     {0.4f, 0.6f, 0.85f, 0.3f, 360-60},
     {0, -0.55f, 0.65f, 0.3f, 90},
    },{
     {0, 1.15f, 0.65f, 0.3f, 0},
     {0.35f, 0.5f, 0.65f, 0.3f, 360-60},
     {-0.35f, -0.5f, 0.65f, 0.3f, 360-240},
     {0, -1.15f, 0.65f, 0.3f, 0},
    },{// .
     {0, -1.15f, 0.05f, 0.3f, 0},
    },{// _
     {0, -1.15f, 0.65f, 0.3f, 0},
    },{// -
     {0, 0, 0.65f, 0.3f, 0},
    }};
}