/*
 * $Id: Frag.java,v 1.1.1.1 2002/02/07 15:20:13 kenta Exp $
 *
 * Copyright 2002 Kenta Cho. All rights reserved.
 */
package jp.gr.java_conf.abagames.narihira;

import jp.gr.java_conf.abagames.bulletml.*;
import jp.gr.java_conf.abagames.util.*;
import java.util.Random;

/**
 * Hit frag fireworks.
 *
 * @version $Revision: 1.1.1.1 $
 */
public class Frag {
  public final static int NOT_EXIST = -1;

  private int x, y, mx, my, px, py;
  public int cnt;

  private static Random rnd = new Random();

  private GameManager gameManager;

  public Frag(GameManager gameManager) {
    this.gameManager = gameManager;
    cnt = NOT_EXIST;
  }

  public void set(int x, int y) {
    this.x = x; this.y = y;
    mx = rnd.nextInt()%2048;
    my = rnd.nextInt()%2048;
    cnt = 64 + Math.abs(rnd.nextInt())%32;
  }

  private final int COLOR = 0xffdd6622;

  public void move() {
    px = x; py = y;
    x += mx; y += my;
    mx -= (mx>>6); my -= (my>>6);
    cnt--;
  }

  public void draw() {
    gameManager.screen.drawLine(x>>8, y>>8, px>>8, py>>8, 8, COLOR, COLOR);
  }
}
