/*
 * $Id: BulletMLData.java,v 1.2 2002/02/08 16:32:42 kenta Exp $
 *
 * Copyright 2002 Kenta Cho. All rights reserved.
 */
package jp.gr.java_conf.abagames.narihira;

import java.util.Hashtable;

/**
 * BulletML datas.
 *
 * @version $Revision: 1.2 $
 */
public class BulletMLData {

public static final BulletMLData[] data = {
new BulletMLData(
"r1_mdl.xml",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE bulletml SYSTEM \"bulletml.dtd\">\n\n<bulletml type=\"vertical\"\n          xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml\">\n\n<action label=\"top\">\n <repeat> <times>2</times>\n <action>\n  <fire>\n   <direction type=\"aim\">-60</direction>\n   <bulletRef label=\"arc\"/>\n  </fire>\n  <repeat> <times>4</times>\n  <action>\n   <fire>\n    <direction type=\"sequence\">30</direction>\n    <bulletRef label=\"arc\"/>\n   </fire>\n  </action>\n  </repeat> \n  <wait>120</wait>\n </action>\n </repeat>\n\n <fire>\n  <direction type=\"aim\">-60</direction>\n  <speed type=\"absolute\">0.3</speed>\n  <bullet/>\n </fire>\n <repeat> <times>4</times>\n <action>\n  <fire>\n   <direction type=\"sequence\">30</direction>\n   <speed type=\"relative\">0</speed>\n   <bullet/>\n  </fire>\n </action>\n </repeat>\n <wait>4</wait>\n <repeat> <times>3+$rank*6</times>\n  <action>\n  <fire>\n   <direction type=\"aim\">-60</direction>\n   <speed type=\"relative\">0.1</speed>\n   <bullet/>\n  </fire>\n  <repeat> <times>4</times>\n  <action>\n   <fire>\n    <direction type=\"sequence\">30</direction>\n    <speed type=\"relative\">0</speed>\n    <bullet/>\n   </fire>\n  </action>\n  </repeat>\n  <wait>4</wait>\n </action>\n </repeat>\n <wait>120</wait>\n <vanish/>\n</action>\n\n<bullet label=\"arc\">\n <action>\n  <fire>\n   <direction type=\"relative\">-5-$rank*10</direction>\n   <bulletRef label=\"nml\"/>\n  </fire>\n  <repeat> <times>4+$rank*8</times>\n  <action>\n   <fire>\n    <direction type=\"sequence\">2.5</direction>\n    <bulletRef label=\"nml\"/>\n   </fire>\n  </action>\n  </repeat>\n <vanish/>\n </action>\n</bullet>\n\n<bullet label=\"nml\">\n <speed>0.3</speed>\n</bullet>\n\n</bulletml>\n"
),
new BulletMLData(
"rf_l.xml",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE bulletml SYSTEM \"bulletml.dtd\">\n\n<bulletml type=\"vertical\"\n          xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml\">\n\n<action label=\"top\">\n<fire>\n <direction type=\"relative\">0</direction>\n <bulletRef label=\"round\"/>\n</fire>\n<repeat> <times>99999</times>\n<action>\n <fire>\n  <direction type=\"sequence\">90+2+4*$rank</direction>\n  <bulletRef label=\"round\"/>\n </fire>\n <repeat> <times>3</times>\n <action>\n  <fire>\n   <direction type=\"sequence\">90</direction>\n  <bulletRef label=\"round\"/>\n  </fire>\n </action>\n </repeat> \n <wait>8</wait>\n</action>\n</repeat>\n</action>\n\n<bullet label=\"round\">\n <speed>0.3</speed>\n</bullet>\n\n</bulletml>\n"
),
new BulletMLData(
"rf_r.xml",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE bulletml SYSTEM \"bulletml.dtd\">\n\n<bulletml type=\"vertical\"\n          xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml\">\n\n<action label=\"top\">\n<fire>\n <direction type=\"relative\">0</direction>\n <bulletRef label=\"round\"/>\n</fire>\n<repeat> <times>99999</times>\n<action>\n <fire>\n  <direction type=\"sequence\">90-2-4*$rank</direction>\n  <bulletRef label=\"round\"/>\n </fire>\n <repeat> <times>3</times>\n <action>\n  <fire>\n   <direction type=\"sequence\">90</direction>\n  <bulletRef label=\"round\"/>\n  </fire>\n </action>\n </repeat> \n <wait>8</wait>\n</action>\n</repeat>\n</action>\n\n<bullet label=\"round\">\n <speed>0.3</speed>\n</bullet>\n\n</bulletml>\n"
),
new BulletMLData(
"vl_l.xml",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE bulletml SYSTEM \"bulletml.dtd\">\n\n<bulletml type=\"vertical\"\n          xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml\">\n\n<action label=\"top\">\n <fire>\n  <direction type=\"absolute\">-90</direction>\n  <speed>0.1</speed>\n  <bulletRef label=\"body\"/>\n </fire>\n <vanish/>\n</action>\n\n<bullet label=\"body\">\n <action>\n  <wait>10</wait>\n  <repeat> <times>56</times>\n  <action>\n   <fire>\n    <direction type=\"absolute\">180</direction>\n    <speed>1</speed>\n    <bullet/>\n   </fire>\n   <wait>4</wait>\n  </action>\n  </repeat>\n </action>\n</bullet>\n\n</bulletml>\n"
),
new BulletMLData(
"vl_r.xml",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE bulletml SYSTEM \"bulletml.dtd\">\n\n<bulletml type=\"vertical\"\n          xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml\">\n\n<action label=\"top\">\n <fire>\n  <direction type=\"absolute\">90</direction>\n  <speed>0.1</speed>\n  <bulletRef label=\"body\"/>\n </fire>\n <vanish/>\n</action>\n\n<bullet label=\"body\">\n <action>\n  <wait>10</wait>\n  <repeat> <times>56</times>\n  <action>\n   <fire>\n    <direction type=\"absolute\">180</direction>\n    <speed>1</speed>\n    <bullet/>\n   </fire>\n   <wait>4</wait>\n  </action>\n  </repeat>\n </action>\n</bullet>\n\n</bulletml>\n"
),
new BulletMLData(
"r3_mdl_1.xml",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE bulletml SYSTEM \"bulletml.dtd\">\n\n<bulletml type=\"vertical\"\n          xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml\">\n\n<action label=\"top\">\n <fire>\n  <direction type=\"absolute\">180</direction>\n  <speed>6</speed>\n  <bulletRef label=\"seed1_1\"/>\n </fire>\n <vanish/>\n</action>\n\n<bullet label=\"seed1_1\">\n <action>\n  <wait>1</wait>\n  <fire>\n   <direction type=\"relative\">0</direction>\n   <bulletRef label=\"seed2\"/>\n  </fire>\n  <fire>\n   <direction type=\"relative\">180</direction>\n   <bulletRef label=\"seed2\"/>\n  </fire>\n  <vanish/>\n </action>\n</bullet>\n\n<bullet label=\"seed2\">\n <speed>6</speed>\n <action>\n  <wait>1</wait>\n  <fire>\n   <direction type=\"relative\">90</direction>\n   <bulletRef label=\"laserSeed\"/>\n  </fire>\n  <vanish/>\n </action>\n</bullet>\n\n<bullet label=\"laserSeed\">\n <speed>0.1</speed>\n <action>\n  <changeDirection>\n   <direction type=\"sequence\">0.5</direction>\n   <term>9999</term>\n  </changeDirection>\n  <repeat> <times>110</times>\n  <action>\n   <fire>\n    <bulletRef label=\"laser\"/>\n   </fire>\n   <wait>6</wait> \n  </action>\n  </repeat>\n  <vanish/>\n </action>\n</bullet>\n\n<bullet label=\"laser\">\n <direction type=\"absolute\">180</direction>\n <speed>0.5</speed>\n</bullet>\n\n</bulletml>\n"
),
new BulletMLData(
"r3_mdl_2.xml",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE bulletml SYSTEM \"bulletml.dtd\">\n\n<bulletml type=\"vertical\"\n          xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml\">\n\n<action label=\"top\">\n <fire>\n  <direction type=\"absolute\">180</direction>\n  <speed>6</speed>\n  <bulletRef label=\"seed1_2\"/>\n </fire>\n <vanish/>\n</action>\n\n<bullet label=\"seed1_2\">\n <action>\n  <wait>1</wait>\n  <fire>\n   <direction type=\"relative\">90</direction>\n   <bulletRef label=\"seed2\"/>\n  </fire>\n  <fire>\n   <direction type=\"relative\">270</direction>\n   <bulletRef label=\"seed2\"/>\n  </fire>\n  <vanish/>\n </action>\n</bullet>\n\n<bullet label=\"seed2\">\n <speed>6</speed>\n <action>\n  <wait>1</wait>\n  <fire>\n   <direction type=\"relative\">90</direction>\n   <bulletRef label=\"laserSeed\"/>\n  </fire>\n  <vanish/>\n </action>\n</bullet>\n\n<bullet label=\"laserSeed\">\n <speed>0.1</speed>\n <action>\n  <changeDirection>\n   <direction type=\"sequence\">0.5</direction>\n   <term>9999</term>\n  </changeDirection>\n  <repeat> <times>110</times>\n  <action>\n   <fire>\n    <bulletRef label=\"laser\"/>\n   </fire>\n   <wait>6</wait> \n  </action>\n  </repeat>\n  <vanish/>\n </action>\n</bullet>\n\n<bullet label=\"laser\">\n <direction type=\"absolute\">180</direction>\n <speed>0.5</speed>\n</bullet>\n\n</bulletml>\n"
),
new BulletMLData(
"r3_mdl_3.xml",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE bulletml SYSTEM \"bulletml.dtd\">\n\n<bulletml type=\"vertical\"\n          xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml\">\n\n<action label=\"top\">\n <fire>\n  <direction type=\"absolute\">180</direction>\n  <speed>2</speed>\n  <bulletRef label=\"center_1\"/>\n </fire>\n <vanish/>\n</action>\n\n<bullet label=\"center_1\">\n<action>\n <wait>1</wait>\n <changeSpeed>\n  <speed>0</speed>\n  <term>1</term>\n </changeSpeed>\n <repeat> <times>10</times>\n <action>\n  <repeat> <times>1+$rank*4</times>\n  <action>\n   <fire>\n    <speed>0.3</speed>\n    <bullet/>\n   </fire>\n   <wait>7</wait>\n  </action>\n  </repeat>\n  <wait>70-7-$rank*28</wait>\n </action>\n </repeat>\n <vanish/>\n</action>\n</bullet>\n\n</bulletml>\n"
),
new BulletMLData(
"r3_mdl_4.xml",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE bulletml SYSTEM \"bulletml.dtd\">\n\n<bulletml type=\"vertical\"\n          xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml\">\n\n<action label=\"top\">\n <fire>\n  <direction type=\"absolute\">180</direction>\n  <speed>2</speed>\n  <bulletRef label=\"center_2\"/>\n </fire>\n <vanish/>\n</action>\n\n<bullet label=\"center_2\">\n<action>\n <wait>1</wait>\n <changeSpeed>\n  <speed>0</speed>\n  <term>1</term>\n </changeSpeed>\n <wait>35</wait>\n <repeat> <times>10</times>\n <action>\n  <repeat> <times>1+$rank*4</times>\n  <action>\n   <fire>\n    <speed>0.3</speed>\n    <bullet/>\n   </fire>\n   <wait>7</wait>\n  </action>\n  </repeat>\n  <wait>70-7-$rank*28</wait>\n </action>\n </repeat>\n <vanish/>\n</action>\n</bullet>\n\n</bulletml>\n"
),
new BulletMLData(
"wl_l.xml",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE bulletml SYSTEM \"bulletml.dtd\">\n\n<bulletml type=\"vertical\"\n          xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml\">\n\n<action label=\"top\">\n <repeat> <times>48</times>\n <action>\n  <fire>\n   <direction type=\"absolute\">-90</direction>\n   <speed>1</speed>\n   <bullet/>\n  </fire>\n  <wait>4</wait>\n </action>\n </repeat>\n <vanish/>\n</action>\n\n</bulletml>\n"
),
new BulletMLData(
"wl_r.xml",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE bulletml SYSTEM \"bulletml.dtd\">\n\n<bulletml type=\"vertical\"\n          xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml\">\n\n<action label=\"top\">\n <repeat> <times>48</times>\n <action>\n  <fire>\n   <direction type=\"absolute\">90</direction>\n   <speed>1</speed>\n   <bullet/>\n  </fire>\n  <wait>4</wait>\n </action>\n </repeat>\n <vanish/>\n</action>\n\n</bulletml>\n"
),
new BulletMLData(
"hrm_d.xml",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE bulletml SYSTEM \"bulletml.dtd\">\n\n<bulletml type=\"vertical\"\n          xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml\">\n\n<action label=\"top\">\n <fire>\n  <direction type=\"absolute\">180</direction>\n  <speed>0.4</speed>\n  <bulletRef label=\"hrm_lsr\"/>\n </fire>\n</action>\n\n<bullet label=\"hrm_lsr\">\n<action>\n <repeat><times>20</times>\n <action>\n  <changeDirection>\n   <direction type=\"aim\">0</direction>\n   <term>40-$rank*20</term>\n  </changeDirection>\n  <wait>5</wait>\n </action>\n </repeat>\n</action>\n</bullet>\n\n</bulletml>\n"
),
new BulletMLData(
"hrm_u.xml",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE bulletml SYSTEM \"bulletml.dtd\">\n\n<bulletml type=\"vertical\"\n          xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml\">\n\n<action label=\"top\">\n <fire>\n  <direction type=\"absolute\">180</direction>\n  <speed>28</speed>\n  <bullet>\n   <action>\n    <wait>1</wait>\n    <fire>\n     <bullet>\n      <speed>0</speed>\n      <actionRef label=\"top_hu\"/>\n     </bullet>\n    </fire>\n    <vanish/>\n   </action>\n  </bullet>\n </fire>\n <vanish/>\n</action>\n\n<action label=\"top_hu\">\n <fire>\n  <direction type=\"absolute\">0</direction>\n  <speed>0.4</speed>\n  <bulletRef label=\"hrm_lsr\"/>\n </fire>\n</action>\n\n<bullet label=\"hrm_lsr\">\n<action>\n <repeat><times>20</times>\n <action>\n  <changeDirection>\n   <direction type=\"aim\">0</direction>\n   <term>40-$rank*20</term>\n  </changeDirection>\n  <wait>5</wait>\n </action>\n </repeat>\n</action>\n</bullet>\n\n</bulletml>\n"
),
new BulletMLData(
"vrp_ld.xml",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE bulletml SYSTEM \"bulletml.dtd\">\n\n<bulletml type=\"vertical\"\n          xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml\">\n\n<action label=\"top\">\n <fire>\n  <direction type=\"absolute\">-90</direction>\n  <speed>0.2</speed>\n  <bulletRef label=\"body\"/>\n </fire>\n <wait>9</wait>\n <fire>\n  <direction type=\"absolute\">-90</direction>\n  <speed>0.2</speed>\n  <bulletRef label=\"body\"/>\n </fire>\n <vanish/>\n</action>\n\n<bullet label=\"body\">\n <action>\n  <repeat> <times>99999</times>\n  <action>\n   <fire>\n    <direction type=\"absolute\">180</direction>\n    <speed>0.8</speed>\n    <bullet/>\n   </fire>\n   <wait>4</wait>\n  </action>\n  </repeat>\n  <vanish/>\n </action>\n</bullet>\n\n</bulletml>\n"
),
new BulletMLData(
"vrp_lu.xml",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE bulletml SYSTEM \"bulletml.dtd\">\n\n<bulletml type=\"vertical\"\n          xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml\">\n\n<action label=\"top\">\n <fire>\n  <direction type=\"absolute\">180</direction>\n  <speed>28</speed>\n  <bullet>\n   <action>\n    <wait>1</wait>\n    <fire>\n     <bullet>\n      <speed>0</speed>\n      <actionRef label=\"top_lu\"/>\n     </bullet>\n    </fire>\n    <vanish/>\n   </action>\n  </bullet>\n </fire>\n <vanish/>\n</action>\n\n<action label=\"top_lu\">\n <fire>\n  <direction type=\"absolute\">-90</direction>\n  <speed>0.2</speed>\n  <bulletRef label=\"body_up\"/>\n </fire>\n <wait>9</wait>\n <fire>\n  <direction type=\"absolute\">-90</direction>\n  <speed>0.2</speed>\n  <bulletRef label=\"body_up\"/>\n </fire>\n <vanish/>\n</action>\n\n<bullet label=\"body_up\">\n <action>\n  <repeat> <times>99999</times>\n  <action>\n   <fire>\n    <direction type=\"absolute\">0</direction>\n    <speed>0.8</speed>\n    <bullet/>\n   </fire>\n   <wait>4</wait>\n  </action>\n  </repeat>\n  <vanish/>\n </action>\n</bullet>\n\n</bulletml>\n"
),
new BulletMLData(
"vrp_rd.xml",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE bulletml SYSTEM \"bulletml.dtd\">\n\n<bulletml type=\"vertical\"\n          xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml\">\n\n<action label=\"top\">\n <fire>\n  <direction type=\"absolute\">90</direction>\n  <speed>0.2</speed>\n  <bulletRef label=\"body\"/>\n </fire>\n <wait>9</wait>\n <fire>\n  <direction type=\"absolute\">90</direction>\n  <speed>0.2</speed>\n  <bulletRef label=\"body\"/>\n </fire>\n <vanish/>\n</action>\n\n<bullet label=\"body\">\n <action>\n  <repeat> <times>99999</times>\n  <action>\n   <fire>\n    <direction type=\"absolute\">180</direction>\n    <speed>0.8</speed>\n    <bullet/>\n   </fire>\n   <wait>4</wait>\n  </action>\n  </repeat>\n  <vanish/>\n </action>\n</bullet>\n\n</bulletml>\n"
),
new BulletMLData(
"vrp_ru.xml",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE bulletml SYSTEM \"bulletml.dtd\">\n\n<bulletml type=\"vertical\"\n          xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml\">\n\n<action label=\"top\">\n <fire>\n  <direction type=\"absolute\">180</direction>\n  <speed>28</speed>\n  <bullet>\n   <action>\n    <wait>1</wait>\n    <fire>\n     <bullet>\n      <speed>0</speed>\n      <actionRef label=\"top_ru\"/>\n     </bullet>\n    </fire>\n    <vanish/>\n   </action>\n  </bullet>\n </fire>\n <vanish/>\n</action>\n\n<action label=\"top_ru\">\n <fire>\n  <direction type=\"absolute\">90</direction>\n  <speed>0.2</speed>\n  <bulletRef label=\"body_up\"/>\n </fire>\n <wait>9</wait>\n <fire>\n  <direction type=\"absolute\">90</direction>\n  <speed>0.2</speed>\n  <bulletRef label=\"body_up\"/>\n </fire>\n <vanish/>\n</action>\n\n<bullet label=\"body_up\">\n <action>\n  <repeat> <times>99999</times>\n  <action>\n   <fire>\n    <direction type=\"absolute\">0</direction>\n    <speed>0.8</speed>\n    <bullet/>\n   </fire>\n   <wait>4</wait>\n  </action>\n  </repeat>\n  <vanish/>\n </action>\n</bullet>\n\n</bulletml>\n"
),
new BulletMLData(
"raf_b.xml",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE bulletml SYSTEM \"bulletml.dtd\">\n\n<bulletml type=\"vertical\"\n          xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml\">\n\n<action label=\"top\">\n<fire>\n <direction type=\"relative\">0</direction>\n <bulletRef label=\"round\"/>\n</fire>\n<repeat> <times>256</times>\n<action>\n <fire>\n  <direction type=\"sequence\">2+6*$rank</direction>\n  <bulletRef label=\"round\"/>\n </fire>\n <wait>12</wait>\n</action>\n</repeat>\n\n<wait>150</wait>\n\n<fire>\n <direction type=\"relative\">0</direction>\n <bulletRef label=\"round2\"/>\n</fire>\n<repeat> <times>192</times>\n<action>\n <fire>\n  <direction type=\"sequence\">2+6*$rank</direction>\n  <bulletRef label=\"round2\"/>\n </fire>\n <wait>8</wait>\n</action>\n</repeat>\n</action>\n\n<bullet label=\"round\">\n <speed>0.2</speed>\n</bullet>\n\n<bullet label=\"round2\">\n <speed>0.35</speed>\n</bullet>\n\n</bulletml>\n\n"
),
new BulletMLData(
"raf_w.xml",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE bulletml SYSTEM \"bulletml.dtd\">\n\n<bulletml type=\"vertical\"\n          xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml\">\n\n<action label=\"top\">\n<repeat> <times>256</times>\n<action>\n <fire>\n  <direction type=\"relative\">0</direction>\n  <bulletRef label=\"round\"/>\n </fire>\n <wait>12</wait>\n</action>\n</repeat>\n\n<wait>150</wait>\n\n<repeat> <times>192</times>\n<action>\n <fire>\n  <direction type=\"relative\">0</direction>\n  <bulletRef label=\"round2\"/>\n </fire>\n <wait>8</wait>\n</action>\n</repeat>\n</action>\n\n<bullet label=\"round\">\n <speed>0.2</speed>\n</bullet>\n\n<bullet label=\"round2\">\n <speed>0.35</speed>\n</bullet>\n\n</bulletml>\n"
),
new BulletMLData(
"r5_rc.xml",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE bulletml SYSTEM \"bulletml.dtd\">\n\n<bulletml type=\"vertical\"\n          xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml\">\n\n<action label=\"top\">\n<fire>\n <direction type=\"absolute\">180</direction>\n <speed>14</speed>\n <bullet>\n  <action>\n   <wait>1</wait>\n   <fire>\n    <bullet>\n     <speed>0</speed>\n     <actionRef label=\"top_cnt\"/>\n    </bullet>\n   </fire>\n  </action>\n </bullet>\n</fire>\n<vanish/>\n</action>\n\n<action label=\"top_cnt\">\n<repeat> <times>36</times>\n<action>\n <fire>\n  <direction type=\"sequence\">10</direction>\n  <bulletRef label=\"cnt_shot\"/>\n </fire>\n</action>\n</repeat>\n<vanish/>\n</action>\n\n<bullet label=\"cnt_shot\">\n<speed>12</speed>\n<action>\n <wait>1</wait>\n <changeSpeed>\n  <speed>0</speed>\n  <term>1</term>\n </changeSpeed>\n <repeat> <times>5</times>\n <action>\n  <fire>\n   <bullet> \n    <speed>0.3</speed>\n   </bullet>\n  </fire>\n  <wait>8</wait>\n </action>\n </repeat>\n <vanish/>\n</action>\n</bullet>\n\n</bulletml>\n"
),
new BulletMLData(
"r5_vrp.xml",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE bulletml SYSTEM \"bulletml.dtd\">\n\n<bulletml type=\"vertical\"\n          xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml\">\n\n<action label=\"top\">\n <fire>\n  <bulletRef label=\"body\"/>\n </fire>\n <vanish/>\n</action>\n\n<bullet label=\"body\">\n <speed>0</speed>\n <action>\n  <accel>\n   <horizontal>$rand*0.02-0.01</horizontal>\n   <vertical>0.5</vertical>\n   <term>1</term>\n  </accel>\n  <wait>1</wait>\n  <accel>\n   <vertical>-0.5</vertical>\n   <term>60</term>\n  </accel>\n  <repeat> <times>16</times>\n  <action>\n   <fire>\n    <direction type=\"absolute\">180</direction>\n    <speed>0.5</speed>\n    <bullet/>\n   </fire>\n   <wait>6</wait>\n  </action>\n  </repeat>\n  <vanish/>\n </action>\n</bullet>\n\n</bulletml>\n"
),
new BulletMLData(
"drc.xml",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE bulletml SYSTEM \"bulletml.dtd\">\n\n<bulletml type=\"vertical\"\n          xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml\">\n\n<action label=\"top\">\n<repeat> <times>32</times>\n<action>\n <fire>\n  <direction type=\"aim\">$rand*60-30</direction>\n  <speed>0.2</speed>\n  <bullet/>\n </fire>\n <wait>80-$rank*32</wait>\n</action>\n</repeat>\n</action>\n\n</bulletml>\n"
),
new BulletMLData(
"hrm_d2.xml",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE bulletml SYSTEM \"bulletml.dtd\">\n\n<bulletml type=\"vertical\"\n          xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml\">\n\n<action label=\"top\">\n <fire>\n  <direction type=\"absolute\">180</direction>\n  <speed>0.3</speed>\n  <bulletRef label=\"hrm_lsr\"/>\n </fire>\n</action>\n\n<bullet label=\"hrm_lsr\">\n<action>\n <repeat><times>40</times>\n <action>\n  <changeDirection>\n   <direction type=\"aim\">0</direction>\n   <term>30-$rank*20</term>\n  </changeDirection>\n  <wait>5</wait>\n </action>\n </repeat>\n</action>\n</bullet>\n\n</bulletml>\n"
),
new BulletMLData(
"wnd_l.xml",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE bulletml SYSTEM \"bulletml.dtd\">\n\n<bulletml type=\"vertical\"\n          xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml\">\n\n<action label=\"top\">\n<fire>\n <direction type=\"relative\">0</direction>\n <bulletRef label=\"winder\"/>\n</fire>\n<repeat> <times>220</times>\n<action>\n <fire>\n  <direction type=\"sequence\">22.5+0.2+0.4*$rank</direction>\n  <bulletRef label=\"winder\"/>\n </fire>\n <repeat> <times>15</times>\n <action>\n  <fire>\n   <direction type=\"sequence\">22.5</direction>\n  <bulletRef label=\"winder\"/>\n  </fire>\n </action>\n </repeat> \n <wait>8</wait>\n</action>\n</repeat>\n</action>\n\n<bullet label=\"winder\">\n <speed>1</speed>\n</bullet>\n\n</bulletml>\n"
),
new BulletMLData(
"wnd_r.xml",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE bulletml SYSTEM \"bulletml.dtd\">\n\n<bulletml type=\"vertical\"\n          xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml\">\n\n<action label=\"top\">\n<fire>\n <direction type=\"relative\">0</direction>\n <bulletRef label=\"winder\"/>\n</fire>\n<repeat> <times>220</times>\n<action>\n <fire>\n  <direction type=\"sequence\">22.5-0.2-0.4*$rank</direction>\n  <bulletRef label=\"winder\"/>\n </fire>\n <repeat> <times>15</times>\n <action>\n  <fire>\n   <direction type=\"sequence\">22.5</direction>\n  <bulletRef label=\"winder\"/>\n  </fire>\n </action>\n </repeat> \n <wait>8</wait>\n</action>\n</repeat>\n</action>\n\n<bullet label=\"winder\">\n <speed>1</speed>\n</bullet>\n\n</bulletml>\n"
),
new BulletMLData(
"clw.xml",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE bulletml SYSTEM \"bulletml.dtd\">\n\n<bulletml type=\"vertical\"\n          xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml\">\n\n<action label=\"top\">\n <fire>\n  <direction type=\"absolute\">180</direction>\n  <speed>0.2+$rank*0.1</speed>\n  <bulletRef label=\"clw_lsr\"/>\n </fire>\n <vanish/>\n</action>\n\n<bullet label=\"clw_lsr\">\n<action>\n <repeat><times>60</times>\n <action>\n  <changeDirection>\n   <direction type=\"aim\">0</direction>\n   <term>30</term>\n  </changeDirection>\n  <fireRef label=\"wake\"/>\n  <wait>10</wait>\n </action>\n </repeat>\n <repeat><times>60</times>\n <action>\n  <fireRef label=\"wake\"/>\n  <wait>10</wait>\n </action>\n </repeat>\n</action>\n</bullet>\n\n<fire label=\"wake\">\n <direction type=\"relative\">0</direction>\n <speed>0</speed>\n <bullet/>\n</fire>\n\n</bulletml>\n"
),
new BulletMLData(
"drc2.xml",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE bulletml SYSTEM \"bulletml.dtd\">\n\n<bulletml type=\"vertical\"\n          xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml\">\n\n<action label=\"top\">\n<repeat> <times>32</times>\n<action>\n <repeat> <times>8</times>\n <action>\n  <fire>\n   <direction type=\"aim\">$rand*20-10</direction>\n   <speed>0.2+$rand*0.02</speed>\n   <bullet/>\n  </fire>\n </action>\n </repeat> \n <wait>200-$rank*40</wait>\n</action>\n</repeat>\n</action>\n\n</bulletml>\n"
),
new BulletMLData(
"drc3.xml",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE bulletml SYSTEM \"bulletml.dtd\">\n\n<bulletml type=\"vertical\"\n          xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml\">\n\n<action label=\"top\">\n<repeat> <times>16+$rank*64</times>\n<action>\n <fire>\n  <direction type=\"aim\">$rand*90-45</direction>\n  <speed>0.2</speed>\n  <bullet/>\n </fire>\n <wait>50-$rank*40</wait>\n</action>\n</repeat>\n</action>\n\n</bulletml>\n"
),
new BulletMLData(
"lsr.xml",
"<?xml version=\"1.0\" ?>\n<!DOCTYPE bulletml SYSTEM \"bulletml.dtd\">\n\n<bulletml type=\"vertical\"\n          xmlns=\"http://www.asahi-net.or.jp/~cs8k-cyu/bulletml\">\n\n<action label=\"top\">\n<repeat> <times>2</times>\n<action>\n <fire>\n  <direction type=\"absolute\">30</direction>\n  <bulletRef label=\"lsr\"/>\n </fire>\n <repeat> <times>3</times>\n <action>\n  <fire>\n   <direction type=\"sequence\">40</direction>\n   <bulletRef label=\"lsr\"/>\n  </fire>\n </action>\n </repeat>\n <fire>\n  <direction type=\"absolute\">-30</direction>\n  <bulletRef label=\"lsr\"/>\n </fire>\n <repeat> <times>3</times>\n <action>\n  <fire>\n   <direction type=\"sequence\">-40</direction>\n   <bulletRef label=\"lsr\"/>\n  </fire>\n </action>\n </repeat>\n <wait>360-$rank*260</wait>\n</action>\n</repeat>\n<vanish/>\n</action>\n\n<bullet label=\"lsr\">\n<speed>0</speed>\n<action>\n <repeat> <times>3</times>\n <action>\n  <fire>\n   <direction type=\"relative\">0</direction>\n   <bulletRef label=\"hrm_lsr\"/>\n  </fire>\n  <wait>2</wait>\n </action>\n </repeat>\n <vanish/>\n</action>\n</bullet>\n\n<bullet label=\"hrm_lsr\">\n<speed>1.5</speed>\n<action>\n <changeDirection>\n  <direction type=\"aim\">0</direction>\n  <term>16</term>\n </changeDirection>\n <wait>16</wait>\n <repeat> <times>99999</times>\n <action>\n  <changeDirection>\n   <direction type=\"aim\">0</direction>\n   <term>1</term>\n  </changeDirection>\n  <wait>1</wait>\n </action>\n </repeat>\n</action>\n</bullet>\n\n</bulletml>\n"
),
};

  public static Hashtable bulletMLDatas;

  static {
    bulletMLDatas = new Hashtable();
    for ( int i=0 ; i<data.length ; i++ ) {
      bulletMLDatas.put(data[i].name, data[i].context);
    }
  }

  private static final String DTD_NAME
   = "bulletml.dtd";
  private static final String DTD_WEB_URL
   = "http://www.asahi-net.or.jp/~cs8k-cyu/bulletml/bulletml.dtd";
  private static final String DTD_FILE_URL
   = "file:///e:\\usr\\narihira\\bulletml.dtd";

  public String name;
  public String context;

  public BulletMLData(String name, String context) {
    this.name = name;
    int dtdIdx = context.indexOf(DTD_NAME);
    if ( dtdIdx != -1 ) {
      StringBuffer cnt = new StringBuffer();
      cnt.append(context.substring(0, dtdIdx));
      cnt.append(DTD_WEB_URL);
      //cnt.append(DTD_FILE_URL);
      cnt.append(context.substring(dtdIdx+DTD_NAME.length()));
      this.context = cnt.toString();
    } else {
      this.context = context;
    }
  }
}