/*
 * $Id: BulletImpl.java,v 1.2 2002/02/08 16:32:42 kenta Exp $
 *
 * Copyright 2002 Kenta Cho. All rights reserved.
 */
package jp.gr.java_conf.abagames.narihira;

import jp.gr.java_conf.abagames.bulletml.*;
import jp.gr.java_conf.abagames.util.*;

/**
 * Bullet implementation.
 *
 * @version $Revision: 1.2 $
 */
public class BulletImpl {
  public static final int NOT_EXIST = Integer.MIN_VALUE;

  private final int SCREEN_WIDTH_256 = Screen.SCREEN_WIDTH<<8;
  private final int SCREEN_HEIGHT_256 = Screen.SCREEN_HEIGHT<<8;
  public static final int[][] BULLET_COLOR = {
     {0xffffffff, 0xff4444ff},
     {0xff000000, 0xffff4444},
     {0xffaaaaaa, 0xff444444},
  };
  private final int NO_COLOR_IDX_FROM = 50, NO_COLOR_IDX_TO = 99;

  private final int ACTION_MAX = 8;

  private ActionImpl[] action = new ActionImpl[ACTION_MAX];
  private int acIdx;

  public int x, y, px, py, width;

  public Direction drcElm;
  public Speed spdElm;
  public float direction, speed;

  public float mx, my;

  public int clrIdx;

  private int cnt;

  private GameManager gameManager;
  private Ship ship;

  private float[] prms;

  public boolean noScroll, laser;
  private int tmx, tmy;
  private BulletImpl parent;
  public float rank;

  private int scrD, scrR;

  public BulletImpl(GameManager gm, Ship ship) {
    gameManager = gm;
    this.ship = ship;
    x = NOT_EXIST;
  }

  public void changeAction(ActionImpl bfr, ActionImpl aft) {
    for ( int i=0 ; i<acIdx ; i++ ) {
      if ( action[i].equals(bfr) ) {
        action[i] = aft;
        return;
      }
    }
  }

  public void set(IActionElmChoice[] aec, int x, int y, int d, int width, int ci,
   boolean noScroll, boolean laser, float rank, double ox, double oy) {
    set(aec, x, y, d, width, ci, noScroll, laser, rank);
    if ( !noScroll ) {
      scrD = DegUtil.getDeg((int)ox, (int)oy)*256;
      scrR = (int)(Math.sqrt(ox*ox + oy*oy));
    }
  }

  public void set(IActionElmChoice[] aec, int x, int y, int d, int width, int ci,
   boolean noScroll, boolean laser, float rank) {
    this.x = px = x; this.y = py = y;
    mx = my = 0; tmx = tmy = 0;
    clrIdx = ci;
    cnt = 0;
    acIdx = 0;
    for ( int i=0 ; i<aec.length ; i++ ) {
      action[acIdx] = gameManager.getActionImplInstance();
      if ( action[acIdx] == null ) break;
      action[acIdx].set(BulletmlUtil.getActionElm(aec[i]), this);
      float[] actPrms = BulletmlUtil.getActionParams(aec[i], prms);
      if ( actPrms == null ) {
        action[acIdx].setParams(prms);
      } else {
        action[acIdx].setParams(actPrms);
      }
      acIdx++;
      if ( acIdx >= ACTION_MAX ) break;
    }
    direction = d;
    speed = 0;
    this.width = width;
    this.noScroll = noScroll;
    this.laser = laser;
    this.rank = rank;
    parent = null;
  }

  public void set(Bullet bullet, int x, int y, int width, int ci, BulletImpl bImpl) {
    drcElm = bullet.getDirection();
    spdElm = bullet.getSpeed();
    IActionElmChoice[] aec = bullet.getActionElm();
    set(aec, x, y, 0, width, ci, bImpl.noScroll, bImpl.laser, bImpl.rank);
    parent = bImpl;
  }

  public void setParams(float[] prms) {
    this.prms = prms;
  }

  public float getAimDeg() {
    return (float)DegUtil.getDeg(ship.x - x, ship.y - y)
     * 360 / SCTable.TABLE_SIZE;
  }

  public void vanish() {
    for ( int i=0 ; i<acIdx ; i++ ) {
      action[i].vanish();
    }
    x = NOT_EXIST;
  }

  public void vanishShown() {
    if ( (clrIdx >= 0 && clrIdx < NO_COLOR_IDX_FROM) || clrIdx > NO_COLOR_IDX_TO ) {
      vanish();
    }
  }

  public boolean isAllActionFinished() {
    for ( int i=0 ; i<acIdx ; i++ ) {
      if ( action[i].pc != ActionImpl.NOT_EXIST ) {
        return false;
      }
    }
    return true;
  }

  public final void move(int scrMvX, int scrMvY, int scrMd) {
    BulletmlUtil.setRank(rank);
    for ( int i=0 ; i<acIdx ; i++ ) {
      action[i].move();
    }

    cnt++;

    int d = (int)(direction*SCTable.TABLE_SIZE/360);
    d &= (SCTable.TABLE_SIZE-1);

    int mvx = ((int)(speed*SCTable.sintbl[d])<<3) + (int)(mx*4096);
    int mvy = ((int)(-speed*SCTable.costbl[d])<<3) + (int)(my*4096);
    //int mvx = ((int)(speed*SCTable.sintbl[d])<<1) + (int)(mx*512);
    //int mvy = ((int)(-speed*SCTable.costbl[d])<<1) + (int)(my*512);
    int pmvx = mvx, pmvy = mvy;
    if ( laser && parent != null && clrIdx >= 0  ) {
      mvx += parent.tmx; mvy += parent.tmy;
    }
    x += mvx; tmx = mvx;
    y += mvy; tmy = mvy;
    if ( pmvx == 0 && pmvy == 0 ) {
      pmvx = SCTable.sintbl[d]<<2;
      pmvy = -SCTable.costbl[d]<<2;
    }
    if ( cnt < 4 ) {
      px = x - pmvx;
      py = y - pmvy;
    } else if ( cnt < 8 ) {
      px = x - (pmvx<<1);
      py = y - (pmvy<<1);
    } else {
      px = x - (pmvx<<2);
      py = y - (pmvy<<2);
    }
    if ( !noScroll && clrIdx < 0 ) {
      int smx = scrMvX, smy = scrMvY;
      if ( scrMd != 0 ) {
        int pd = scrD;
        scrD += scrMd; scrD &= ((256<<8)-1);
        smx += (SCTable.sintbl[(scrD>>8)] - SCTable.sintbl[(pd>>8)])*scrR;
        smy += (SCTable.costbl[(scrD>>8)] - SCTable.costbl[(pd>>8)])*scrR;
        direction -= (((float)scrMd)*360/(256<<8));
      }
      x += smx; y += smy;
      px += smx; py += smy;
      tmx += smx; tmy += smy;
    }

    if ( clrIdx < NO_COLOR_IDX_FROM || clrIdx > NO_COLOR_IDX_TO ) {
      if ( px < 0 || px >= SCREEN_WIDTH_256 || py < 0 || py >= SCREEN_HEIGHT_256 ) {
        vanish();
      }
    } else {
      if ( px < -(SCREEN_WIDTH_256>>2) || px >= SCREEN_WIDTH_256+(SCREEN_WIDTH_256>>2) ||
           py < -(SCREEN_HEIGHT_256>>2) || py >= SCREEN_HEIGHT_256+(SCREEN_HEIGHT_256>>2) ) {
        vanish();
      }
    }

    int cx = (x+px)>>1, cy = (y+py)>>1;
    int r = DegUtil.getDistance(cx-ship.x, cy-ship.y);
    if ( clrIdx >= 0 ) {
      if ( (clrIdx&1) == ship.color &&
       (clrIdx < NO_COLOR_IDX_FROM || clrIdx > NO_COLOR_IDX_TO) ) {
        if ( r < Ship.FORCE_WIDTH_256+(width<<7) ) {
          if ( laser ) {
            ship.x += (mvx<<1); ship.y += (mvy<<1);
          }
          ship.eatDot();
          vanish();
        }
      } else {
        if ( r < Ship.WIDTH_256+(width<<7) ) {
          ship.destroied();
        }
      }
    }
  }

  public final void draw() {
    if ( clrIdx >= 0 ) {
      if ( clrIdx < NO_COLOR_IDX_FROM || clrIdx > NO_COLOR_IDX_TO ) {
        gameManager.screen.drawLine((x>>8), (y>>8), (px>>8), (py>>8), width,
                                    BULLET_COLOR[clrIdx&1][0], BULLET_COLOR[clrIdx&1][1]);
      } else {
        gameManager.screen.drawLine((x>>8), (y>>8), (px>>8), (py>>8), width,
                                    BULLET_COLOR[2][0], BULLET_COLOR[2][1]);
      }
    }
  }
}
