/*
 * $Id: BatteryImpl.java,v 1.2 2002/02/08 16:32:42 kenta Exp $
 *
 * Copyright 2002 Kenta Cho. All rights reserved.
 */
package jp.gr.java_conf.abagames.narihira;

import jp.gr.java_conf.abagames.narihira.relaxer.*;
import jp.gr.java_conf.abagames.bulletml.*;
import jp.gr.java_conf.abagames.util.*;
import java.util.*;
import java.io.*;
import java.awt.TextArea;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.w3c.dom.Document;

/**
 * Battery implementation.
 *
 * @version $Revision: 1.2 $
 */
public class BatteryImpl {
  public final static int NOT_EXIST = Integer.MIN_VALUE;

  private final int SCREEN_WIDTH_256 = Screen.SCREEN_WIDTH<<8;
  private final int SCREEN_HEIGHT_256 = Screen.SCREEN_HEIGHT<<8;

  private static Hashtable bulletmls = new Hashtable();

  private int x, y, d, width;
  private int t;
  private double ox, oy;
  private IActionElmChoice[] topAction;
  public int color;
  private boolean noScroll, laser;
  private float rank;
  private int scrD, scrR;

  private GameManager gameManager;

  public static void init() {
    BulletmlUtil.clear();
    bulletmls.clear();
  }

  public BatteryImpl(GameManager gameManager) {
    this.gameManager = gameManager;
    color = NOT_EXIST;
  }

  private final int BULLET_WIDTH_DEFAULT = 5;

  public void set(B b, final TextArea console, String directory) {
    ox = new Double(b.getX()).doubleValue()*Screen.SCREEN_WIDTH*GameManager.SCREEN_ML_RATE;
    oy = new Double(b.getY()).doubleValue()*Screen.SCREEN_HEIGHT*GameManager.SCREEN_ML_RATE;
    x = (int)((ox + Screen.SCREEN_WIDTH/2)*256);
    y = (int)((-oy + Screen.SCREEN_HEIGHT/2)*256);
    String degStr = b.getD();
    if ( degStr == null ) {
      d = 0;
    } else {
      d = new Double(degStr).intValue();
    }
    String wdtStr = b.getWidth();
    if ( wdtStr == null ) {
      width = BULLET_WIDTH_DEFAULT;
    } else {
      width = (int)(Integer.parseInt(wdtStr));
    }

    String bulletmlFile = b.getName();
    if ( bulletmls.containsKey(bulletmlFile) ) {
      topAction = (IActionElmChoice[])bulletmls.get(bulletmlFile);
    } else {
      try {
        //topAction = loadBulletML(".\\data\\" + directory + File.separator + bulletmlFile, console);
        topAction = loadBulletML(bulletmlFile, console);
        bulletmls.put(bulletmlFile, topAction);
      } catch ( Exception e ) {
        if ( console != null ) {
          console.append(e.getMessage());
          console.append("\n");
        } else {
          e.printStackTrace();
        }
        topAction = null;
      }
    }
    String clrStr = b.getColor();
    if ( clrStr == null ) color = 0;
    else if ( clrStr.equals("white") || clrStr.equals("w") ) color = 0;
    else if ( clrStr.equals("black") || clrStr.equals("b") ) color = 1;
    else color = Integer.parseInt(clrStr);
    color -= 2;
    String scrStr = b.getScroll();
    if ( scrStr != null && scrStr.equals("no") ) {
      noScroll = true;
    } else {
      noScroll = false;
      scrD = DegUtil.getDeg((int)ox, (int)oy)*256;
      scrR = (int)(Math.sqrt(ox*ox + oy*oy));
    }
    String lsrStr = b.getLaser();
    if ( lsrStr != null && lsrStr.equals("yes") ) laser = true;
    else laser = false;
    String rnkStr = b.getRank();
    if ( rnkStr != null ) {
      rank = new Double(rnkStr).floatValue();
    } else {
      rank = 0.5f;
    }
    String tStr = b.getT();
    if ( tStr != null ) {
      t = Integer.parseInt(tStr);
    } else {
      t = -1;
    }
  }

  private IActionElmChoice[] loadBulletML(String fileName, final TextArea console)
   throws Exception {
    //try {
      ErrorHandler errorHandler = new ErrorHandler() {
        public void error(SAXParseException e) {
          if ( console != null ) {
            console.append("error : ");
            console.append(e.getMessage());
            console.append("\n");
          } else {
            e.printStackTrace();
          }
        }
        public void fatalError(SAXParseException e) {
          if ( console != null ) {
            console.append("fatal error : ");
            console.append(e.getMessage());
            console.append("\n");
          } else {
            e.printStackTrace();
          }
        }
        public void warning(SAXParseException e) {
          if ( console != null ) {
            console.append("warning : ");
            console.append(e.getMessage());
            console.append("\n");
          } else {
            e.printStackTrace();
          }
        }
      };

      Document doc = null;
      try {
        /*BufferedReader rdr = new BufferedReader(new FileReader(fileName));
        StringBuffer bml = new StringBuffer();
        for ( ; ; ) {
          String str = rdr.readLine();
          if ( str == null ) break;
          bml.append(str);
        }
        doc = jp.gr.java_conf.abagames.narihira.relaxer.UJAXP.getValidDocument(
         new StringReader(bml.toString()), errorHandler);*/
        doc = jp.gr.java_conf.abagames.narihira.relaxer.UJAXP.getValidDocument(
         new StringReader((String)BulletMLData.bulletMLDatas.get(fileName)),
         errorHandler);
      } catch ( Exception e ) {
        e.printStackTrace();
      }

      Bulletml bulletML = new Bulletml(doc);
      IBulletmlChoice[] bmc = bulletML.getContent();
      Vector aecVct = new Vector();
      for ( int i=0 ; i<bmc.length ; i++ ) {
        IBulletmlChoice be = bmc[i];
        if ( be instanceof Action ) {
          Action act = (Action)be;
          if ( act.getLabel().startsWith("top") ) {
            aecVct.addElement(act);
          }
          BulletmlUtil.addAction(act);
        } else if ( be instanceof Bullet ) {
          BulletmlUtil.addBullet((Bullet)be);
        } else if ( be instanceof Fire ) {
          BulletmlUtil.addFire((Fire)be);
        }
      }
      IActionElmChoice[] topAction = new IActionElmChoice[aecVct.size()];
      aecVct.copyInto(topAction);
      return topAction;
    /*} catch ( Exception e ) {
      e.printStackTrace();
    }*/
  }

  public final void move(int scrMvX, int scrMvY, int scrMd) {
    x += scrMvX; y += scrMvY;
    if ( scrMd != 0 ) {
      int pd = scrD;
      scrD += scrMd; scrD &= ((256<<8)-1);
      x += (SCTable.sintbl[(scrD>>8)] - SCTable.sintbl[(pd>>8)])*scrR;
      y += (SCTable.costbl[(scrD>>8)] - SCTable.costbl[(pd>>8)])*scrR;
      d -= (((float)scrMd)*360/(256<<8));
    }
    if ( x >= 0 && x < SCREEN_WIDTH_256 && y >= 0 && y < SCREEN_HEIGHT_256 && gameManager.cnt >= t ) {
      BulletImpl bullet = gameManager.getBulletImplInstance();
      if ( bullet != null ) {
        bullet.set(topAction, x, y, d, width, color, noScroll, laser, rank, ox, oy);
        color = NOT_EXIST;
      }
    }
  }
}
