/*
 * $Id: AttractManager.java,v 1.2 2002/02/08 16:32:42 kenta Exp $
 *
 * Copyright 2002 Kenta Cho. All rights reserved.
 */
package jp.gr.java_conf.abagames.narihira;

/**
 * Handle title/gameover.
 *
 * @version $Revision: 1.2 $
 */
public class AttractManager {
  private GameManager gameManager;
  private Screen screen;
  private Ship ship;

  public static final String SEPARATOR = "-----";

  private final int STAGE_NAME_HEIGHT = 28;
  private int selectedStage;

  public AttractManager(GameManager gameManager, Ship ship) {
    this.gameManager = gameManager;
    screen = gameManager.screen;
    this.ship = ship;
  }

  public void initTitle() {
    selectedStage = -1;
  }

  public final void setMousePos(int x, int y) {
    switch ( gameManager.status ) {
    case GameManager.TITLE:
      int ss = y / STAGE_NAME_HEIGHT;
      if ( ss >= 0 && ss < NarihiraData.stageName.length ) {
        selectedStage = ss;
      } else {
        selectedStage = -1;
      }
      break;
    }
  }

  public final void mousePressed() {
    switch ( gameManager.status ) {
    case GameManager.TITLE:
      if ( selectedStage == -1 ) break;
      if ( NarihiraData.stageName[selectedStage].equals(SEPARATOR) ) break;
      gameManager.status = GameManager.NONE;
      screen.clearNoSmoke();
      screen.drawString("NOW LOADING...", 0, 0, 5, 0xffffaa44);
      screen.swap();
      gameManager.resetAll();
      //gameManager.loadNarihiraML(
      // stageName[selectedStage] + ".xml", null, stageName[selectedStage]);
      gameManager.loadNarihiraML(
       NarihiraData.stageName[selectedStage], null,
       NarihiraData.stageName[selectedStage]);
      gameManager.initStage();
      gameManager.startGame();
      break;
    case GameManager.GAME_OVER:
      if ( gameManager.cnt < 150 ) {
        gameManager.cnt = ((int)(gameManager.cnt/30))*30+30;
      } else {
        gameManager.cnt = 1200;
      }
      break;
    }
  }

  //public void titleMove() {
  //}

  public void titleDraw() {
    for ( int i=0 ; i<NarihiraData.stageName.length ; i++ ) {
      int color;
      if ( i == selectedStage ) {
        color = 0xaabbff;
      } else {
        color = 0xffaa44;
      }
      screen.drawString(NarihiraData.stageName[i],
       0, i*STAGE_NAME_HEIGHT, STAGE_NAME_HEIGHT/3, color);
    }
    screen.drawString("NARIHIRA", 90, 410, 16, 0xffffaa44);
  }

  //public void gameoverMove() {
  //}

  public void gameoverDraw() {
    screen.drawString("GAME OVER", 0, 410, 16, 0xffffaa44);
    if ( gameManager.cnt < 30 ) return;
    screen.drawString("YOU EAT", 220, 10, 9, 0xffffaa44);
    if ( gameManager.cnt < 60 ) return;
    screen.drawString(ship.eatCount[0]+" DOTS", 0, 50, 9, 0xffffffff);
    if ( gameManager.cnt < 90 ) return;
    screen.drawString(ship.eatCount[1]+" DOTS", 0, 90, 9, 0xff000000);
    if ( gameManager.cnt < 120 ) return;
    screen.drawString("YOU LOST", 200, 150, 9, 0xffffaa44);
    if ( gameManager.cnt < 150 ) return;
    screen.drawString(ship.missCount+" SHIPS", 0, 190, 9, 0xffffaa44);
    if ( gameManager.cnt > 1200 ) gameManager.startTitle();
  }
}
