;--------------------------------------------------------------------------------
;	PIC16F887EԑvEdv Programmed by GRANADA
;	Ver 1.0		2010/08/13 ` 2010/08/16	PIC16F690 3F\Xs[h[^[x[Xɉ
;								F\
;	Ver 2.0		2010/08/17 `	FΉ
;	Ver 3.0		2010/08/25 `	VvJɕύX
;	Ver 3.1		2010/09/27 `	^C}l 0 `FbNoOC
;	LF http://www.asahi-net.or.jp/~SE1M-NITU/html/Speed_Meter2.htm
;--------------------------------------------------------------------------------

	LIST		P=16F887
	INCLUDE		P16F887.INC

	ERRORLEVEL	-205
	ERRORLEVEL	-302

    __CONFIG    _CONFIG1, _DEBUG_OFF & _LVP_OFF & _FCMEN_ON & _IESO_OFF & _BOR_ON & _CPD_OFF & _CP_OFF & _MCLRE_OFF & _PWRTE_ON & _WDT_OFF & _INTRC_OSC_NOCLKOUT
    __CONFIG    _CONFIG2, _WRT_OFF & _BOR40V

;--------------------------------------------------------------------------------
;	ϐAhX`
;--------------------------------------------------------------------------------

CBLOCK	H'20'			; [U[pt@CWX^iϐ̈j擪AhX

	VOLTAGE				; drdiǒl x 10j

	TMR1_CNT_H			; Lv` TMR1 JEgl
	TMR1_CNT_L

	SPEED				; Xs[hi10iǒl Km/hj
	PREV_SPEED			; ÕXs[h

	LED					; _ LED 

	VALUE				; 7ZO\p[N

ENDC

CBLOCK	H'70'			; SoNʃt@CWX^擪AhX

	W_WORK				; 荞ݎ W WX^ޔp
	ST_WORK				; 荞ݎ̃Xe[^XWX^ޔp

	COUNTER1			; ԑ҂p
	COUNTER2			; ԑ҂p
	COUNTER3			; ԑ҂p

	DISP_LOOP			; _Ci~bN_

	ILLEGULAR			; CM[lJE^

	USER_FLAG			; etO

ENDC

;--------------------------------------------------------------------------------
;	萔`, DEFINE g MPLAB SIM ̃t@CWX^_vɕ֗
;	it@CWX^ɒ萔ꍞ܂Ȃj
;--------------------------------------------------------------------------------

#DEFINE		AD_FACTOR		D'5'	; A/Dϊl  10iǒlx10ւ̕ϊt@N^[
									; drd 1/4 ē͂ 20V = 1000JEgB
									;  5 ŊΒǒl x 10 (=200) 
#DEFINE		LED_MAX			D'25'	; Ă LED ̍ő
#DEFINE		CYCLE			D'25'	; _Ci~bN_̃[v񐔊

#DEFINE		SPEED_QUALITY	D'15'	; (Km/h) 1pXłȏ̕ωꍇ̓f[^𖳎

#DEFINE		ILLEGULAR_TH	D'10'	; ̘ACM[lf[^XV邩

;--------------------------------------------------------------------------------
;	|[g`
;--------------------------------------------------------------------------------

#DEFINE		SW_PORT		PORTE,3			; d\XCb`|[g`
#DEFINE		PULSE		2
#DEFINE		PULSE_PORT	PORTC,PULSE		; pX̓|[g`

#DEFINE		CLR_PATTERN	B'00001111'		; 7 ZO LED S bit p^[

#DEFINE		dp			4				; _ZOg̃|[gԍ
#DEFINE		C1			5				; 7 ZO LED 1 ڐ|[gԍ
#DEFINE		C2			6				; 7 ZO LED 2 ڐ|[gԍ
#DEFINE		C3			7				; 7 ZO LED 3 ڐ|[gԍ

#DEFINE		V_MODE		USER_FLAG,0		; 1 = d\[h
#DEFINE		TMR1_OF		USER_FLAG,1		; 1 = TMR1 I[o[t[
#DEFINE		ZERO_FLAG	USER_FLAG,2		; 1 = l\̍ŏʂ 0

#DEFINE		dp_PORT		PORTB,dp		; _o̓|[g`
#DEFINE		C1_PORT		PORTB,C1		; 7 ZO LED 1 ڐ|[g`
#DEFINE		C2_PORT		PORTB,C2		; 7 ZO LED 2 ڐ|[g`
#DEFINE		C3_PORT		PORTB,C3		; 7 ZO LED 3 ڐ|[g`

#DEFINE		LED01_PORT	PORTD,2
#DEFINE		LED02_PORT	PORTD,3
#DEFINE		LED03_PORT	PORTC,4
#DEFINE		LED04_PORT	PORTC,5
#DEFINE		LED05_PORT	PORTC,6
#DEFINE		LED06_PORT	PORTC,7
#DEFINE		LED07_PORT	PORTD,4
#DEFINE		LED08_PORT	PORTD,5
#DEFINE		LED09_PORT	PORTD,6
#DEFINE		LED10_PORT	PORTD,7
#DEFINE		LED11_PORT	PORTD,1
#DEFINE		LED12_PORT	PORTD,0
#DEFINE		LED13_PORT	PORTC,3
#DEFINE		LED14_PORT	PORTC,1
#DEFINE		LED15_PORT	PORTC,0
#DEFINE		LED16_PORT	PORTA,6
#DEFINE		LED17_PORT	PORTA,7
#DEFINE		LED18_PORT	PORTE,2
#DEFINE		LED19_PORT	PORTE,1
#DEFINE		LED20_PORT	PORTE,0
#DEFINE		LED21_PORT	PORTA,5
#DEFINE		LED22_PORT	PORTA,4
#DEFINE		LED23_PORT	PORTA,3
#DEFINE		LED24_PORT	PORTA,2
#DEFINE		LED25_PORT	PORTA,1

#DEFINE		HOLD_LED	WAIT_500us
#DEFINE		HOLD_LED2	WAIT_5us
#DEFINE		HOLD_LED3	WAIT_5us
#DEFINE		HOLD_LED4	WAIT_1ms
#DEFINE		HOLD_LED5	WAIT_10ms
#DEFINE		HOLD_LED6	WAIT_1ms

;--------------------------------------------------------------------------------
;	}N`
;--------------------------------------------------------------------------------

BANK0	macro
		BCF		STATUS,RP1
		NOP
		BCF		STATUS,RP0
		endm

BANK1	macro
		BCF		STATUS,RP1
		NOP
		BSF		STATUS,RP0
		endm

BANK2	macro
		BSF		STATUS,RP1
		NOP
		BCF		STATUS,RP0
		endm

BANK3	macro
		BSF		STATUS,RP1
		NOP
		BSF		STATUS,RP0
		endm

;--------------------------------------------------------------------------------
;	vO擪
;--------------------------------------------------------------------------------

	ORG		H'0'
	GOTO	INITIALIZE

;--------------------------------------------------------------------------------
;	荞ݏ
;--------------------------------------------------------------------------------

	ORG		H'4'			; 荞ݏ擪AhX

	MOVWF	W_WORK			; WX^Ҕ
	SWAPF	STATUS,W		; Z tOeȂ悤AMOVF ł͂Ȃ SWAPF gp
	MOVWF	ST_WORK			; STATUS WX^ۑ Bank A\

;
;	Lv` ?
;

	BANKSEL	PORTA			; m Bank 0 ɂĂiK{j

CHK_CAPTURE:

	BTFSS	PIR1,CCP1IF		; Bank0
	GOTO	CHK_TMR1_OVERF	; TMR1 over flow `FbN

	CLRF	TMR1L			; Bank0, TMR1 NAĎ̑ɔ
	CLRF	TMR1H			; Bank0

	BCF		PIR1,CCP1IF		; ݌tONA

	BTFSC	TMR1_OF			; 0 = TMR1 Over Flow ̃pXł͂ȂƂmF
	GOTO	CAPTURE2		; TMR1 Over Flow ̃pXł͎gvZłȂ̂Œl͕ۑȂ

	MOVF	CCPR1H,W		; Bank0, TMR1 JE^lۑ
	MOVWF	TMR1_CNT_H
	MOVF	CCPR1L,W		; Bank0
	MOVWF	TMR1_CNT_L

CAPTURE2:

	BCF		TMR1_OF			; Over Flow tONA

	GOTO	POP_REG			; Lv`݂ TMR1 I[o[t[͓ɂ͂蓾Ȃ̂Ŋ荞݂I

;
;	TMR1 I[o[t[ ?
;

CHK_TMR1_OVERF:				; iTMR1 ͎I 0 ăJEgAbvJnj

	BTFSS	PIR1,TMR1IF		; TMR1 over flow ?
	GOTO	POP_REG			; No

	BCF		PIR1,TMR1IF		; ݌tONA

	CLRF	TMR1_CNT_H		; K莞ԓɃpX̂ŃJE^lNA
	CLRF	TMR1_CNT_L

	BSF		TMR1_OF			; Over Flow tO𗧂ĂĂi̒̃pX̎gvZh߁j

;
;	ݏI
;

POP_REG:					; WX^A`荞ݏI

	SWAPF	ST_WORK,W
	MOVWF	STATUS
	SWAPF	W_WORK,F
	SWAPF	W_WORK,W

	RETFIE					; 荞ݏI

;--------------------------------------------------------------------------------
;	vOX^[g
;--------------------------------------------------------------------------------

INITIALIZE:

	BANK0

	CALL	CLR_BAR_LED
	CALL	CLR_7SEG

	CLRF	INTCON			; Bank 0, 荞݂͋Ȃ

	BANK1

	CLRF	PIE1			; Bank 1, 荞݂͂ЂƂ܂Sĕs

	MOVLW	B'01110001'		; NbN 8MHz ɐݒ
	MOVWF	OSCCON			; Bank 1

	CLRF	TRISA			; Bank 1, ЂƂ܂S|[go͂Ɏw
	BSF		TRISA,0			; AN0 = IN ɍĐݒ

	CLRF	TRISB			; Bank 1

	CLRF	TRISC			; Bank 1
	BSF		TRISC,PULSE		; pX́iLv`j|[g͂

	CLRF	TRISD			; Bank 1
	CLRF	TRISE			; Bank 1

	BANK3

	CLRF	ANSEL			; Bank 3, US|[gfW^ɐݒ
	BSF		ANSEL,0			; Bank 3, AN0 = Analog input
	CLRF	ANSELH			; Bank 3

;--------------------------------------------------------------------------------
;	A/D ϊݒ
;--------------------------------------------------------------------------------

	BANK0

	MOVLW	B'10000001'		; FOSC/32, AN0, ADON
	MOVWF	ADCON0			; Bank 0

	BANK1

	MOVLW	B'10000000'		; El 10bit A/D ϊAVREF = VDD & VSS
	MOVWF	ADCON1			; Bank 1

;--------------------------------------------------------------------------------
;	TMR1 ݒ, Lv`@\ݒ
;--------------------------------------------------------------------------------

	BANK0

	MOVLW	B'00000101'		; Capture mode with rising edge
	MOVWF	CCP1CON			; Bank0

	CLRF	TMR1H			; Bank0, TMR1 NA
	CLRF	TMR1L			; Bank0

	MOVLW	B'00110100'		; vXP[ 1:8 -> 65536 x 8 x 0.5(us) = ő 262ms ܂ŃgKpX҂
	MOVWF	T1CON			; Bank0

;--------------------------------------------------------------------------------
;	̑ݒ (Bank0)
;--------------------------------------------------------------------------------

	CALL	CLR_ILLE_CNT

	CLRF	TMR1_CNT_H
	CLRF	TMR1_CNT_L

	CLRF	SPEED

	CLRF	PREV_SPEED
	INCF	PREV_SPEED,F	; NɃf[^\邽߂̍׍H

	CLRF	LED

	CLRF	USER_FLAG		; etO
	BSF		TMR1_OF			; Over Flow tONAiŏ̃pX̎̓AeɂȂȂj

;--------------------------------------------------------------------------------
;	ݏJn
;--------------------------------------------------------------------------------

	BSF		INTCON,GIE		; Bank0, S̊荞݋
	NOP
	BSF		INTCON,PEIE		; Bank0, ӊ (e.g. TMR1) 
	NOP

	BANK1

	BSF		PIE1,TMR1IE		; Bank1, TMR1 over flow ݋
	BSF		PIE1,CCP1IE		; Bank1, Lv`݋

	BANK0

	BSF		T1CON, TMR1ON	; Bank 0, TMR1 X^[g

;--------------------------------------------------------------------------------
;	C[vJn
;--------------------------------------------------------------------------------

	CALL	WAIT_1sec
	CALL	START_UP

MAIN_LOOP:

;
;	L[̓`FbN
;

	BTFSC	SW_PORT			; L = Ă
	GOTO	MAIN2

	CALL	WAIT_25ms		; `^Oh~

	BTFSC	SW_PORT			; ܂Ă邩
	GOTO	MAIN2

	CALL	WAIT_100ms		; `^Oh~
	CALL	WAIT_100ms		; `^Oh~

	MOVLW	B'00000001'		; V_MODE tÕrbgʒu 1 ɂ
	XORWF	USER_FLAG,F		; XOR  V_MODE rbĝ݃tO]

MAIN2:

	BTFSS	V_MODE			; 1 = d\[h
	GOTO	SPEED_CALC		; 0 = ԑ\[h

	CALL	VOLTAGE_DISPLAY	; 1 = d\[h

	MOVF	VOLTAGE,W
	MOVWF	VALUE			; d\f[^

	GOTO	NUMERIC_DISPLAY

;
;	x\
;

SPEED_CALC:

	CALL	CONV_DATA		; g  x (SPEED)

;
;	xωʃ`FbN
;

	MOVF	PREV_SPEED,W
	SUBWF	SPEED,W			; SPEED - PREV_SPEED(W) -> Wiωʁj
	BTFSC	STATUS,Z
	GOTO	UPDATE			; Z-1, xω[hؑ֎lĕ\͍XVACM[JE^̓Zbg

	BTFSC	STATUS,C		; if SPEED < PREV_SPEED, C=0 Ŏ؂ꔭ
	GOTO	SPEED_UP		; ؂ꂪȂ  W = ̒lł̂܂

;
;	
;

SPEED_DOWN:

	MOVF	SPEED,W			; ωʂɂȂ悤ZȂ
	SUBWF	PREV_SPEED,W	; PREV_SPEED - SPEED -> Wiωʁj

;
;	
;

SPEED_UP:

	SUBLW	SPEED_QUALITY	; Mۏl - Wiωʁj-> W
	BTFSC	STATUS,C		; if Mۏl < W, C=0
	GOTO	UPDATE			; Xs[hωMۏlȓȂ̂Ńf[^𐳏XV

	DECFSZ	ILLEGULAR,F		; ACM[l`FbN
	GOTO	ILLEGULAR_SPEED

;
;	񐔘AăCM[l
;

	GOTO	UPDATE			; \XV

;
;	񐔈ȉ̃CM[l̏ꍇ
;

ILLEGULAR_SPEED:

	MOVF	PREV_SPEED,W
	MOVWF	SPEED			; xÕf[^ɏC

	GOTO	EXEC_DISPLAY2	; \l̕ῶȂ̓JE^̓ZbgȂ

;
;	f[^Abvf[g
;

UPDATE:

	MOVF	SPEED,W
	MOVWF	PREV_SPEED		; ̕ω`FbN̂ߌ݂̃Xs[hlۑ

	CALL	SET_PARAMETERS	; \

EXEC_DISPLAY:

	CALL	CLR_ILLE_CNT

EXEC_DISPLAY2:

	CALL	CALC_LOOP		; [v񐔌vZ

EXEC_DISPLAY3:

	CALL	SPEED_DISPLAY	; LED _Ci~bN_

	DECFSZ	DISP_LOOP,F
	GOTO	EXEC_DISPLAY3	; 񐔃[v

	MOVF	SPEED,W
	MOVWF	VALUE			; Xs[h\f[^

NUMERIC_DISPLAY:

	CALL	NUM_DISPLAY		; l\s

	GOTO	MAIN_LOOP

;--------------------------------------------------------------------------------
;	ȉTu[`Q
;--------------------------------------------------------------------------------

;--------------------------------------------------------------------------------
;	_Ci~bN_̕\񐔂肷i_ɂ鎞ԍxj
;	IN:			LEDi_j
;	RETURN:		DISP_LOOP
;--------------------------------------------------------------------------------

CALC_LOOP:

	CLRF	A1					; for safety

	MOVF	LED,W
	BTFSS	STATUS,Z			; _ 0  ?
	GOTO	CALC2				; Ⴄ

	MOVLW	CYCLE				; 0 ł_Ń[v񐔉
	MOVWF	DISP_LOOP
	RETURN

CALC2:

	MOVWF	B1					; 

	MOVLW	CYCLE
	MOVWF	A1					; q

	CALL	DIV8				; in Math24_v2.lib, _񐔌vZ

SET_VALUE:

	MOVF	A1,W				; A1 = 
	BTFSC	STATUS,Z
	MOVLW	D'1'				; \ 0 Ȃ 1 ɕ␳

	MOVWF	DISP_LOOP			; \񐔂XgA

	RETURN

;--------------------------------------------------------------------------------
;	LED \
;	IN		SPEED			xi10iǒl, Km/hj
;	RETURN	LED				_
;--------------------------------------------------------------------------------

SET_PARAMETERS:

	MOVF	SPEED,W
	MOVWF	A1				; q

	MOVLW	D'5'			; 5Km/h 
	MOVWF	B1				; 

	CALL	DIV8			; in Math24_v2.lib, returns A1ij, B1i]j
;
;	34
;
;	MOVLW	D'4'
;	SUBWF	B1,W			; B1i]j - 4 -> W
;	BTFSC	STATUS,C		; if ] < 4, C=0
;	INCF	A1,F			; ]肪4ȏȂ_悹

	MOVF	A1,W			; ǂݏo
	MOVWF	LED				; _ LED ̌֕ۑ
;
;	NbsO
;
	MOVLW	LED_MAX
	SUBWF	LED,W			; LED - LED  -> W
	BTFSS	STATUS,C		; if LED >= LED , C=1
	RETURN

	MOVLW	LED_MAX
	MOVWF	LED				;  LED ȏȂ␳

	RETURN

;--------------------------------------------------------------------------------
;	x_Ci~bN_
;	IN:		LED ij
;--------------------------------------------------------------------------------

SPEED_DISPLAY:

	CALL	CLR_BAR_LED			; S

LED1:

	MOVLW	D'1'
	SUBWF	LED,W				; LED_IN - 1 -> W
	BTFSS	STATUS,C			; if LED_IN >= 1, C = 1
	RETURN

	BCF		LED01_PORT			; _i L = _j
	CALL	HOLD_LED			; LED _΂炭z[h
	BSF		LED01_PORT			; 
	CALL	HOLD_LED2

LED2:

	MOVLW	D'2'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED02_PORT			; _i L = _j
	CALL	HOLD_LED			; LED _΂炭z[h
	BSF		LED02_PORT			; 
	CALL	HOLD_LED2

LED3:

	MOVLW	D'3'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED03_PORT			; _i L = _j
	CALL	HOLD_LED			; LED _΂炭z[h
	BSF		LED03_PORT			; 
	CALL	HOLD_LED2

LED4:

	MOVLW	D'4'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED04_PORT			; _i L = _j
	CALL	HOLD_LED			; LED _΂炭z[h
	BSF		LED04_PORT			; 
	CALL	HOLD_LED2

LED5:

	MOVLW	D'5'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED05_PORT			; _i L = _j
	CALL	HOLD_LED			; LED _΂炭z[h
	BSF		LED05_PORT			; 
	CALL	HOLD_LED2

LED6:

	MOVLW	D'6'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED06_PORT			; _i L = _j
	CALL	HOLD_LED			; LED _΂炭z[h
	BSF		LED06_PORT			; 
	CALL	HOLD_LED2

LED7:

	MOVLW	D'7'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED07_PORT			; _i L = _j
	CALL	HOLD_LED			; LED _΂炭z[h
	BSF		LED07_PORT			; 
	CALL	HOLD_LED2

LED8:

	MOVLW	D'8'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED08_PORT			; _i L = _j
	CALL	HOLD_LED			; LED _΂炭z[h
	BSF		LED08_PORT			; 
	CALL	HOLD_LED2

LED9:

	MOVLW	D'9'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED09_PORT			; _i L = _j
	CALL	HOLD_LED			; LED _΂炭z[h
	BSF		LED09_PORT			; 
	CALL	HOLD_LED2

LED10:

	MOVLW	D'10'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED10_PORT			; _i L = _j
	CALL	HOLD_LED			; LED _΂炭z[h
	BSF		LED10_PORT			; 
	CALL	HOLD_LED2

LED11:

	MOVLW	D'11'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED11_PORT			; _i L = _j
	CALL	HOLD_LED			; LED _΂炭z[h
	BSF		LED11_PORT			; 
	CALL	HOLD_LED2

LED12:

	MOVLW	D'12'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED12_PORT			; _i L = _j
	CALL	HOLD_LED			; LED _΂炭z[h
	BSF		LED12_PORT			; 
	CALL	HOLD_LED2

LED13:

	MOVLW	D'13'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED13_PORT			; _i L = _j
	CALL	HOLD_LED			; LED _΂炭z[h
	BSF		LED13_PORT			; 
	CALL	HOLD_LED2

LED14:							; F

	MOVLW	D'14'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED14_PORT			; _i L = _j
	CALL	HOLD_LED6			; LED _΂炭z[h
	BSF		LED14_PORT			; 
	CALL	HOLD_LED2

LED15:							; F

	MOVLW	D'15'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED15_PORT			; _i L = _j
	CALL	HOLD_LED6			; LED _΂炭z[h
	BSF		LED15_PORT			; 
	CALL	HOLD_LED2

LED16:							; F

	MOVLW	D'16'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED16_PORT			; _i L = _j
	CALL	HOLD_LED6			; LED _΂炭z[h
	BSF		LED16_PORT			; 
	CALL	HOLD_LED2

LED17:							; F

	MOVLW	D'17'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED17_PORT			; _i L = _j
	CALL	HOLD_LED			; LED _΂炭z[h
	BSF		LED17_PORT			; 
	CALL	HOLD_LED2

LED18:							; F

	MOVLW	D'18'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED18_PORT			; _i L = _j
	CALL	HOLD_LED			; LED _΂炭z[h
	BSF		LED18_PORT			; 
	CALL	HOLD_LED2

LED19:							; F

	MOVLW	D'19'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED19_PORT			; _i L = _j
	CALL	HOLD_LED			; LED _΂炭z[h
	BSF		LED19_PORT			; 
	CALL	HOLD_LED2

LED20:							; sN

	MOVLW	D'20'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED20_PORT			; _i L = _j
	CALL	HOLD_LED6			; LED _΂炭z[h
	BSF		LED20_PORT			; 
	CALL	HOLD_LED2

LED21:							; sN

	MOVLW	D'21'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED21_PORT			; _i L = _j
	CALL	HOLD_LED6			; LED _΂炭z[h
	BSF		LED21_PORT			; 
	CALL	HOLD_LED2

LED22:							; sN

	MOVLW	D'22'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED22_PORT			; _i L = _j
	CALL	HOLD_LED6			; LED _΂炭z[h
	BSF		LED22_PORT			; 
	CALL	HOLD_LED2

LED23:							; sN

	MOVLW	D'23'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED23_PORT			; _i L = _j
	CALL	HOLD_LED6			; LED _΂炭z[h
	BSF		LED23_PORT			; 
	CALL	HOLD_LED2

LED24:

	MOVLW	D'24'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED24_PORT			; _i L = _j
	CALL	HOLD_LED			; LED _΂炭z[h
	BSF		LED24_PORT			; 
	CALL	HOLD_LED2

LED25:

	MOVLW	D'25'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED25_PORT			; _i L = _j
	CALL	HOLD_LED			; LED _΂炭z[h
	BSF		LED25_PORT			; 
	CALL	HOLD_LED2

	RETURN

;--------------------------------------------------------------------------------
;	d_Ci~bN_\
;--------------------------------------------------------------------------------

VOLTAGE_DISPLAY

;--------------------------------------------------------------------------------
;	10 bit A/D ϊs
;--------------------------------------------------------------------------------

	BSF		ADCON0,GO		; GO (start) bit 𗧂Ă A/D ϊJn

WAIT_AD:

	BTFSC	ADCON0,GO		; A/D ϊI? 0 Ȃ玟XLbv
	GOTO	WAIT_AD			; ܂ A/D ϊ

	MOVF	ADRESH,W		; Bank 0, A/D ϊliʁjǂݏo
	MOVWF	A2				; ɃXgA

	BANKSEL	ADRESL			; Bank 1
	MOVF	ADRESL,W		; Bank 1, A/D ϊliʁjǂݏo

	BANKSEL	ADRESH			; Bank 0 ɖ߂
	MOVWF	A3				; ɃXgA (BANK0ɂ_ɒӁj

	CLRF	A1

	CLRF	B1
	CLRF	B2
	MOVLW	AD_FACTOR		; AD_FACTOR ŊƒǓdl x 10 
	MOVWF	B3

	CALL	DIV24			; A1A2A3 = 

	MOVF	A3,W
	MOVWF	VOLTAGE			; ǒl x10 ۑĂ

	INCF	A3,F			; 10V _悤Q^͂
	INCF	A3,F

	MOVLW	D'100'
	SUBWF	A3,W			; A2 - 100 -> W, _Jnd 10V Ԃ
	BTFSS	STATUS,C		; if A3 >= 100, C=1
	CLRW					; 100 ȉȂ 0 ɕ␳

	MOVWF	LED
	BCF		STATUS,C
	RRF		LED,F			; LED / 2 -> LED, 2 Ŋ邱Ƃ 0.2V Xebv LED _܂

	MOVLW	LED_MAX
	SUBWF	LED,W			; LED - LED  -> W
	BTFSS	STATUS,C		; if  LED >= LED , C=1
	GOTO	VOLTAGE_DISPLAY2

	MOVLW	LED_MAX
	MOVWF	LED				; NbsO

VOLTAGE_DISPLAY2:			; d\͋t_Ă

	CALL	CLR_BAR_LED			; S

	MOVLW	D'1'
	SUBWF	LED,W			; LED_IN - 1 -> W
	BTFSS	STATUS,C		; if LED_IN >= 1, C = 1
	RETURN

	BCF		LED25_PORT		; 10.0V _i L = _j
	CALL	HOLD_LED		; LED _΂炭z[h
	BSF		LED25_PORT		; 
	CALL	HOLD_LED2

	MOVLW	D'2'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED24_PORT		; 10.2V
	CALL	HOLD_LED
	BSF		LED24_PORT
	CALL	HOLD_LED2

	MOVLW	D'3'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED23_PORT		; 10.4V
	CALL	HOLD_LED6
	BSF		LED23_PORT
	CALL	HOLD_LED2

	MOVLW	D'4'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED22_PORT		; 10.6V
	CALL	HOLD_LED6
	BSF		LED22_PORT
	CALL	HOLD_LED2

	MOVLW	D'5'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED21_PORT		; 10.8V
	CALL	HOLD_LED6
	BSF		LED21_PORT
	CALL	HOLD_LED2

	MOVLW	D'6'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED20_PORT		; 11.0V
	CALL	HOLD_LED6
	BSF		LED20_PORT
	CALL	HOLD_LED2

	MOVLW	D'7'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED19_PORT		; 11.2V
	CALL	HOLD_LED
	BSF		LED19_PORT
	CALL	HOLD_LED2

	MOVLW	D'8'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED18_PORT		; 11.4V
	CALL	HOLD_LED
	BSF		LED18_PORT
	CALL	HOLD_LED2

	MOVLW	D'9'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED17_PORT		; 11.6V
	CALL	HOLD_LED
	BSF		LED17_PORT
	CALL	HOLD_LED2

	MOVLW	D'10'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED16_PORT		; 11.8V
	CALL	HOLD_LED6
	BSF		LED16_PORT
	CALL	HOLD_LED2

	MOVLW	D'11'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED15_PORT		; 12.0V
	CALL	HOLD_LED6
	BSF		LED15_PORT
	CALL	HOLD_LED2

	MOVLW	D'12'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED14_PORT		; 12.2V
	CALL	HOLD_LED6
	BSF		LED14_PORT
	CALL	HOLD_LED2

	MOVLW	D'13'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED13_PORT		; 12.4V
	CALL	HOLD_LED
	BSF		LED13_PORT
	CALL	HOLD_LED2

	MOVLW	D'14'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED12_PORT		; 12.6V
	CALL	HOLD_LED
	BSF		LED12_PORT
	CALL	HOLD_LED2

	MOVLW	D'15'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED11_PORT		; 12.8V
	CALL	HOLD_LED
	BSF		LED11_PORT
	CALL	HOLD_LED2

	MOVLW	D'16'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED10_PORT		; 13.0V
	CALL	HOLD_LED
	BSF		LED10_PORT
	CALL	HOLD_LED2

	MOVLW	D'17'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED09_PORT		; 13.2V
	CALL	HOLD_LED
	BSF		LED09_PORT
	CALL	HOLD_LED2

	MOVLW	D'18'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED08_PORT		; 13.4V
	CALL	HOLD_LED
	BSF		LED08_PORT
	CALL	HOLD_LED2

	MOVLW	D'19'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED07_PORT		; 13.6V
	CALL	HOLD_LED
	BSF		LED07_PORT
	CALL	HOLD_LED2

	MOVLW	D'20'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED06_PORT		; 13.8V
	CALL	HOLD_LED
	BSF		LED06_PORT
	CALL	HOLD_LED2

	MOVLW	D'21'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED05_PORT		; 14.0V
	CALL	HOLD_LED
	BSF		LED05_PORT
	CALL	HOLD_LED2

	MOVLW	D'22'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED04_PORT		; 14.2V
	CALL	HOLD_LED
	BSF		LED04_PORT
	CALL	HOLD_LED2

	MOVLW	D'23'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED03_PORT		; 14.4V
	CALL	HOLD_LED
	BSF		LED03_PORT
	CALL	HOLD_LED2

	MOVLW	D'24'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED02_PORT		; 14.6V
	CALL	HOLD_LED
	BSF		LED02_PORT
	CALL	HOLD_LED2

	MOVLW	D'25'
	SUBWF	LED,W
	BTFSS	STATUS,C
	RETURN

	BCF		LED01_PORT		; 14.8V
	CALL	HOLD_LED
	BSF		LED01_PORT
	CALL	HOLD_LED2

	RETURN

;--------------------------------------------------------------------------------
;	7 ZO LED \
;	\Ԃɂ邽 0 TvXԂŕ\
;	IN:		VALUE					8bit lix͒ǒlAdl10{lj
;			USER_FLAG V_MODE bit	1 = _Kv
;--------------------------------------------------------------------------------

NUM_DISPLAY:

	BCF		ZERO_FLAG		; [TvXptOZbg

	CLRF	prm1b			; ʃNA
	MOVF	VALUE,W
	MOVWF	prm1a			; l 8bit ɃZbg

	CALL	HEX2DEC16		; 16bitl -> 5 BCD ϊAel̏ 4bit  0 m

	CALL	CLR_7SEG		; 7 ZOS

COL1:

	MOVF	prm3c,W			; H
	BTFSS	STATUS,Z		; Hڂ̓[ ?
	GOTO	DISP_COL1

	BSF		ZERO_FLAG		; [TvXptO𗧂Ă
	MOVLW	CLR_PATTERN		; 74LS247 ł 15 = S
	MOVWF	prm3c

DISP_COL1:

	BSF		prm3c,C1
	MOVF	prm3c,W
	MOVWF	PORTB			; 7 ZO_

	CALL	HOLD_LED4
	CALL	CLR_7SEG		; 7 ZOS
	CALL	HOLD_LED3

COL2:

	BTFSS	ZERO_FLAG		; Hڂ 0 ?
	GOTO	DISP_COL2		; No

	MOVF	prm3b,W
	BTFSS	STATUS,Z		; Mڂ 0 ?
	GOTO	DISP_COL2		; No

	MOVLW	CLR_PATTERN		; 74LS247 ł 15 = S
	MOVWF	prm3b

DISP_COL2:

	BSF		prm3b,C2
	MOVF	prm3b,W			; M
	MOVWF	PORTB			; 7 ZO_

	BTFSC	V_MODE
	BSF		dp_PORT			; d\[hȂ珬__

	CALL	HOLD_LED4
	CALL	CLR_7SEG		; 7 ZOS
	CALL	HOLD_LED3

COL3:

	BSF		prm3a,C3
	MOVF	prm3a,W			; L
	MOVWF	PORTB			; 7 ZO_

	CALL	HOLD_LED4
	CALL	CLR_7SEG		; 7 ZOS
	CALL	HOLD_LED3

	RETURN

;--------------------------------------------------------------------------------
;	o[ LED S OFFi H = LED OFF )
;--------------------------------------------------------------------------------

CLR_BAR_LED:

	MOVLW	H'FF'
	MOVWF	PORTA
	MOVWF	PORTC
	MOVWF	PORTD
	MOVWF	PORTE

	RETURN

;--------------------------------------------------------------------------------
;	7ZO LED S OFF
;--------------------------------------------------------------------------------

CLR_7SEG:

	MOVLW	CLR_PATTERN		; S OFF, 74LS247  15 𑗂A_ OFF
	MOVWF	PORTB

	RETURN

;--------------------------------------------------------------------------------
;	TMR1 JEgl  g  xϊ
;	IN:		TMR1_CNT_H, TMR1_CNT_L
;	RETURN:	SPEEDi10iǒl Km/hj
;	NbN 8MHz, TMR1 vXP[ 8 ̏ꍇA
;	g = 250000(24bit) / TMR1 JEgl(16bit) xmۂ̂ߎg10{ČvZ
;	x   = gx10(16bit) x 1500(16bit) / 10000(16bit)  24bit ZɎ߂xグ
;--------------------------------------------------------------------------------

CONV_DATA:

	CLRF	SPEED

	CLRF	B1
	MOVF	TMR1_CNT_H,W	; vZɊݏŏȂ悤lޔĂ
	MOVWF	B2				; B1B2B3 = 鐔
	MOVF	TMR1_CNT_L,W
	MOVWF	B3

	MOVF	B2,W			; JEg 0 (16bit) `FbN
	BTFSS	STATUS,Z
	GOTO	CONV_DATA2

	MOVF	B3,W
	BTFSC	STATUS,Z
	RETURN					; 鐔 = 0 Ȃ SPEED = 0 mȂ̂Ŗ߂

CONV_DATA2:

	MOVLW	H'26'			; &H2625A0 = 2500000
	MOVWF	A1				; A1A2A3 = 鐔
	MOVLW	H'25'
	MOVWF	A2
	MOVLW	H'A0'
	MOVWF	A3

	CALL	DIV24			; in Math24_v2.lib,  A1A2A3
							; ig x 10j 16bit ȓm A2A3

	CLRF	A1				; ŏ 8bit ͔Ô߃NA

	CLRF	B1
	MOVLW	H'05'			; &H05DC = 1500 (16bit)
	MOVWF	B2
	MOVLW	H'DC'
	MOVWF	B3

	CALL	MUL24			; in Math24_v2.lib,  A1A2A3B1B2B3 (48bit)
							; 16bit x 16bit Ȃ̂ŌIɂ͓ 32bit ɂȂ邪A
							;  200Km/h łg 133Hz ɉ߂Ȃ̂ŁA
							; 133 x 10 x 1500 = 1995000 ŉ 24bit ɏ\܂
	CLRF	A1
	MOVLW	H'07'			; &H07D0 = 2000
	MOVWF	A2
	MOVLW	H'D0'
	MOVWF	A3

	CALL	ADD24			; in Math24_v2.lib, 2000 𑫂 78ʁA A1A2A3

	CLRF	B1
	MOVLW	H'27'			; &H2710 = 10000
	MOVWF	B2
	MOVLW	H'10'
	MOVWF	B3

	CALL	DIV24			; in Math24_v2.lib,  A1A2A3

	MOVF	A3,W			; A3 = ǑxB 8 bit ȓm
	MOVWF	SPEED

	RETURN

;--------------------------------------------------------------------------------
;	CM[lJE^NA
;--------------------------------------------------------------------------------

CLR_ILLE_CNT:

	MOVLW	ILLEGULAR_TH	; ̘ACM[lf[^XV邩
	MOVWF	ILLEGULAR

	RETURN

;--------------------------------------------------------------------------------
;	X^[gAbvf
;--------------------------------------------------------------------------------

START_UP:

	BCF		LED01_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED01_PORT			; 
	CALL	HOLD_LED6

	BCF		LED02_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED02_PORT			; 
	CALL	HOLD_LED6

	BCF		LED03_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED03_PORT			; 
	CALL	HOLD_LED6

	BCF		LED04_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED04_PORT			; 
	CALL	HOLD_LED6

	BCF		LED05_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED05_PORT			; 
	CALL	HOLD_LED6

	BCF		LED06_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED06_PORT			; 
	CALL	HOLD_LED6

	BCF		LED07_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED07_PORT			; 
	CALL	HOLD_LED6

	BCF		LED08_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED08_PORT			; 
	CALL	HOLD_LED6

	BCF		LED09_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED09_PORT			; 
	CALL	HOLD_LED6

	BCF		LED10_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED10_PORT			; 
	CALL	HOLD_LED6

	BCF		LED11_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED11_PORT			; 
	CALL	HOLD_LED6

	BCF		LED12_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED12_PORT			; 
	CALL	HOLD_LED6

	BCF		LED13_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED13_PORT			; 
	CALL	HOLD_LED6

	BCF		LED14_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED14_PORT			; 
	CALL	HOLD_LED6

	BCF		LED15_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED15_PORT			; 
	CALL	HOLD_LED6

	BCF		LED16_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED16_PORT			; 
	CALL	HOLD_LED6

	BCF		LED17_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED17_PORT			; 
	CALL	HOLD_LED6

	BCF		LED18_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED18_PORT			; 
	CALL	HOLD_LED6

	BCF		LED19_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED19_PORT			; 
	CALL	HOLD_LED6

	BCF		LED20_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED20_PORT			; 
	CALL	HOLD_LED6

	BCF		LED21_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED21_PORT			; 
	CALL	HOLD_LED6

	BCF		LED22_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED22_PORT			; 
	CALL	HOLD_LED6

	BCF		LED23_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED23_PORT			; 
	CALL	HOLD_LED6

	BCF		LED24_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED24_PORT			; 
	CALL	HOLD_LED6

	BCF		LED25_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED25_PORT			; 
	CALL	HOLD_LED6

	BCF		LED24_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED24_PORT			; 
	CALL	HOLD_LED6

	BCF		LED23_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED23_PORT			; 
	CALL	HOLD_LED6

	BCF		LED22_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED22_PORT			; 
	CALL	HOLD_LED6

	BCF		LED21_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED21_PORT			; 
	CALL	HOLD_LED6

	BCF		LED20_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED20_PORT			; 
	CALL	HOLD_LED6

	BCF		LED19_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED19_PORT			; 
	CALL	HOLD_LED6

	BCF		LED18_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED18_PORT			; 
	CALL	HOLD_LED6

	BCF		LED17_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED17_PORT			; 
	CALL	HOLD_LED6

	BCF		LED16_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED16_PORT			; 
	CALL	HOLD_LED6

	BCF		LED15_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED15_PORT			; 
	CALL	HOLD_LED6

	BCF		LED14_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED14_PORT			; 
	CALL	HOLD_LED6

	BCF		LED13_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED13_PORT			; 
	CALL	HOLD_LED6

	BCF		LED12_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED12_PORT			; 
	CALL	HOLD_LED6

	BCF		LED11_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED11_PORT			; 
	CALL	HOLD_LED6

	BCF		LED10_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED10_PORT			; 
	CALL	HOLD_LED6

	BCF		LED09_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED09_PORT			; 
	CALL	HOLD_LED6

	BCF		LED08_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED08_PORT			; 
	CALL	HOLD_LED6

	BCF		LED07_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED07_PORT			; 
	CALL	HOLD_LED6

	BCF		LED06_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED06_PORT			; 
	CALL	HOLD_LED6

	BCF		LED05_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED05_PORT			; 
	CALL	HOLD_LED6

	BCF		LED04_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED04_PORT			; 
	CALL	HOLD_LED6

	BCF		LED03_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED03_PORT			; 
	CALL	HOLD_LED6

	BCF		LED02_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED02_PORT			; 
	CALL	HOLD_LED6

	BCF		LED01_PORT			; _i L = _j
	CALL	HOLD_LED5			; LED _΂炭z[h
	BSF		LED01_PORT			; 
	CALL	HOLD_LED6

	CALL	CLR_BAR_LED

	RETURN

;--------------------------------------------------------------------------------
;	Cuǂݍ
;--------------------------------------------------------------------------------

	INCLUDE		Time-8MHz.lib	; NbN8MHzpԑ҂[vCu
	INCLUDE		Math24-v2.lib	; 24bit lZCu

;--------------------------------------------------------------------------------
;	vOI
;--------------------------------------------------------------------------------

	END
