;--------------------------------------------------------------------------------
;	PIC16F88E3F\n_Se^C}[ Programmed by GRANADA
;
;	Ver 1.0 	TMR1 ŁiJj	2009/07/01 `
;	Ver 1.5		TMR0 ŁiJj	2009/07/03 `	i Ver 1.0 n[hύXȂj
;	Ver 2.0		TMR0 ŁiJj		2009/07/03 `	i Ver 1.5 n[hύXjhbg_ŋ@\AuU[o͋@\t
;	Ver 2.1		@@@V@@@		2009/08/16		ÑXCb`쁨G[ǉiS΍j
;	Ver 3.0		TMR1 + RyA	2010/12/06		NbN 4MHzɕύX TMR1 + RyAŊ݊Ԋu 500ms ɕύX
;													^C}[l 90ɕύX
;	Ver 3.1		J				2011/03/02		TMR1 RyAlC
;
;	XCb`F
;		n_Seʓd  c莞ԂΕ\Ȃn_SedA\Aԕ\Ȃ^C}[Zbg
;		n_Sed  ^C}[ZbgAn_Seʓd
;	S΍F
;		d ON ɃXCb`ĂG[\Œ~
;
;	i{\[XvO̓^u4ɐݒ肷Yɐ`܂j
;	LF http://www.asahi-net.or.jp/~SE1M-NITU/html/Soldering_Timer.htm
;--------------------------------------------------------------------------------

	LIST		P=16F88
	INCLUDE		P16F88.INC

	ERRORLEVEL	-205
	ERRORLEVEL	-302

	__CONFIG  _CONFIG1, _CP_OFF & _CCP1_RB0 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_ON & _MCLR_OFF & _PWRTE_OFF & _WDT_OFF & _INTRC_IO
	__CONFIG  _CONFIG2, _IESO_OFF & _FCMEN_OFF

;--------------------------------------------------------------------------------
;	ϐAhX`
;--------------------------------------------------------------------------------

CBLOCK	H'20'		; [U[pt@CWX^iϐ̈j擪AhX

MINUTE				; c莞ԁij

SECOND_COUNTER		; bvpJE^[
MINUTE_COUNTER		; vpJE^[
ALARM_COUNTER		; A[pJE^[

PATTERN_H			; Hrbgp^[E}X^[p^[
PATTERN_L			; Lrbgp^[E}X^[p^[
LED_PATTERN_H		; Hrbgp^[
LED_PATTERN_L		; Lrbgp^[
SEGMENT				; \rbgp^[
COLOR_FLAG			; F̐ptO, bit = 1  _

PORTA_TMP			; |[gp[N
DP_TMP				; DP ZOgp[N

BUNSHI				; Z̕qXgAp
BUNBO				; Z̕XgAp
DIV_ANS				; Z̓p
DIV_MOD				; Z̗]p
BCD_H				; BCD ϊliʁjp
BCD_L				; BCD ϊliʁjp

W_WORK				; 荞ݎ W WX^ޔp
ST_WORK				; 荞ݎ̃Xe[^XWX^ޔp

COUNTER1			; ԑ҂p
COUNTER2			; ԑ҂p
COUNTER3			; ԑ҂p

USER_FLAG			; etO

ENDC

;--------------------------------------------------------------------------------
;	|[g蓖
;--------------------------------------------------------------------------------
;
;RA0	CONTROL	DIGITAL OUT		TCX^LbgpBH = TCX^ ON
;RA1	BUZZER	DIGITAL OUT		vU[o
;RA2	HG	DIGITAL OUT
;RA3	LG	DIGITAL OUT
;RA4	SETTING	DIGITAL IN		JUMPER OPEN(H) = 90min, SHORT(L) = 30min
;RA5	RESET	DIGITAL IN		͐pAZbgL[
;RA6	HR	DIGITAL OUT
;RA7	LR	DIGITAL OUT
;
;RB0	LED a	DIGITAL OUT
;RB1	LED b	DIGITAL OUT
;RB2	LED c	DIGITAL OUT
;RB3	LED d	DIGITAL OUT
;RB4	LED e	DIGITAL OUT
;RB5	LED f	DIGITAL OUT
;RB6	LED g	DIGITAL OUT
;RB7	LED dp	DIGITAL OUT

;--------------------------------------------------------------------------------
;	萔`, DEFINE g MPLAB SIM ̃t@CWX^_vɕ֗
;	it@CWX^ɒ萔ꍞ܂Ȃj
;--------------------------------------------------------------------------------

#DEFINE		CONTROL		D'0'	; d|[gԍ & tOł̃rbgʒuBH = c ON
#DEFINE		BUZZER		D'1'	; uU[o̓|[gԍ & tOł̃sbgʒuBH = uU[ ON
#DEFINE		DP			D'2'	; DP ZOgԊǗp̃rbgʒu

#DEFINE		SETTING		D'4'	; Ԑݒ|[gԍ
#DEFINE		KEY			D'5'	; L[|[gԍ

#DEFINE		HG			D'2'	; HGREEN  PORTA |[gԍ
#DEFINE		LG			D'3'	; LGREEN  PORTA |[gԍ
#DEFINE		HR			D'6'	; HRED    PORTA |[gԍ
#DEFINE		LR			D'7'	; LRED    PORTA |[gԍ

								; Fi10iǂ̎c莞ԁj
#DEFINE		RED_V		D'5'	; 5ȉ	-> 
#DEFINE		ORANGE_V	D'20'	; 5-20	-> 
								; ȏ	-> 

								; ^C}[ԁijݒiMAX 99j
#DEFINE		MINUTE1		D'90'	; WpI[v̐ݒij
#DEFINE		MINUTE2		D'30'	; WpV[g̐ݒij

#DEFINE		E_PATTERN	B'01111001'	; E \̃rbgp^[
#DEFINE		R_PATTERN	B'01010000'	; R \̃rbgp^[
#DEFINE		S_PATTERN	B'01000000'	; - \̃rbgp^[

;--------------------------------------------------------------------------------
;	|[g`
;--------------------------------------------------------------------------------

#DEFINE		POWER_STATUS	USER_FLAG,CONTROL	; dԁA1 = ON
#DEFINE		ALARM_STATUS	USER_FLAG,BUZZER	; A[ԁA1=uU[炷
#DEFINE		DP_STATUS		USER_FLAG,DP		; DP ZOg̏ԁA1=_
#DEFINE		KEY_STATUS		USER_FLAG,KEY		; L[ԁA1 = ꂽ

#DEFINE		CONTROL_PORT	PORTA,CONTROL		; d|[g
#DEFINE		SETTING_PORT	PORTA,SETTING		; Ԑݒ|[g
#DEFINE		KEY_PORT		PORTA,KEY			; ZbgL[|[g
#DEFINE		BUZZER_PORT		PORTA,BUZZER		; uU[o̓|[g

#DEFINE		GREEN_BIT	COLOR_FLAG,0			; FtÕrbgԍ
#DEFINE		RED_BIT		COLOR_FLAG,1			; FtÕrbgԍ

#DEFINE		HG_PORT		PORTA,HG		; HGREEN ̐|[g RA2, L = ON
#DEFINE		LG_PORT		PORTA,LG		; LGREEN ̐|[g RA3, L = ON
#DEFINE		HR_PORT		PORTA,HR		; HRED   ̐|[g RA6, L = ON
#DEFINE		LR_PORT		PORTA,LR		; LRED   ̐|[g RA7, L = ON

#DEFINE		A_SEG	PORTB,0				; LED a ZOg̃|[gԍ
#DEFINE		B_SEG	PORTB,1				; LED b ZOg̃|[gԍ
#DEFINE		C_SEG	PORTB,2				; LED c ZOg̃|[gԍ
#DEFINE		D_SEG	PORTB,3				; LED d ZOg̃|[gԍ
#DEFINE		E_SEG	PORTB,4				; LED e ZOg̃|[gԍ
#DEFINE		F_SEG	PORTB,5				; LED f ZOg̃|[gԍ
#DEFINE		G_SEG	PORTB,6				; LED g ZOg̃|[gԍ
#DEFINE		DP_SEG	PORTB,7				; LED DP ZOg̃|[gԍ

;--------------------------------------------------------------------------------
;	vO擪
;--------------------------------------------------------------------------------

	ORG		H'0'
	GOTO	INITIALIZE

;--------------------------------------------------------------------------------
;	荞ݏ (500ms ɔłj
;--------------------------------------------------------------------------------

	ORG		H'4'				; 荞ݏ擪AhX

	MOVWF	W_WORK				; WX^Ҕ
	SWAPF	STATUS,W			; Z tOeȂ悤AMOVF ł͂Ȃ SWAPF gp
	MOVWF	ST_WORK

	BTFSS	PIR1,CCP1IF			; Bank 0, TMR1 compare  ?
	GOTO	POP_REG				; RyA荞݂ł͂Ȃ̂ŉȂŖ߂

	BCF		PIR1,CCP1IF			; Bank 0, TMR1 compare ݃tONA

	BTFSS	POWER_STATUS		; dtONA
	GOTO	CHK_SEC				; dfȂRsȂ

	CLRF	DP_TMP
	BSF		DP_TMP,DP			; DP STATUS rbgʒu 1 ɂ
	MOVF	DP_TMP,W
	XORWF	USER_FLAG,F			; XOR  DP STATUS rbĝ݃tO]

CHK_SEC:
								; 500ms̔
	DECFSZ	SECOND_COUNTER,F	; JE^`FbN
	GOTO	CHECK_ALARM			; 1b̊荞݂̏ꍇ̓A[ԂmF

	CALL	RESET_1st_COUNTER	; bJE^̃Zbg

								; 1b̔
	DECFSZ	MINUTE_COUNTER,F	; JE^`FbN
	GOTO	POP_REG				; ꕪȂ犄荞ݏI

	CALL	CLEAR_EVENT		; JE^

	MOVF	MINUTE,F		; c莞ԃ`FbNBuU[~܂悤ɂ̈ʒuŃ`FbN
	BTFSC	STATUS,Z		; c莞Ԃ͂łɃ[?
	GOTO	POP_REG			; Ƀ[̂ŉȂŖ߂

	DECF	MINUTE,F		; c莞ԃJEg_E

	MOVF	MINUTE,W		; c莞ԃ`FbNA5
	SUBLW	RED_V			; RED_V - MINUTE -> W
	BTFSS	STATUS,C		; MINUTE <= RED_V  ؂ꔭ  C=1  ̖߃XLbv
	GOTO	POP_REG			; A[svȂ̂Ŋ荞ݏI

	BTFSS	ALARM_STATUS	; A[Ԃ`FbN
	CALL	ALARM_ON		; A[ĂȂȂuU[xJn

	GOTO	POP_REG			; 荞ݏI

CHECK_ALARM

	BTFSS	ALARM_STATUS
	GOTO	POP_REG			; A[~ԂȂ̂ŉȂŊ荞ݏI

	DECFSZ	ALARM_COUNTER,F
	GOTO	POP_REG			; ̊݉񐔂܂Ŗ炵

	CALL	ALARM_OFF		; A[~

POP_REG:					; WX^A`荞ݏI

	SWAPF	ST_WORK,W
	MOVWF	STATUS
	SWAPF	W_WORK,F
	SWAPF	W_WORK,W

	RETFIE					; 荞ݏI

;--------------------------------------------------------------------------------
;	1̐7ZOgrbgp^[Ԃ
;--------------------------------------------------------------------------------

GET_7SEG_PATTERN:

	ADDWF	PCL,F

	RETLW	B'00111111'	;	0
	RETLW	B'00000110'	;	1
	RETLW	B'01011011'	;	2
	RETLW	B'01001111'	;	3
	RETLW	B'01100110'	;	4
	RETLW	B'01101101'	;	5
	RETLW	B'01111101'	;	6
	RETLW	B'00100111'	;	7
	RETLW	B'01111111'	;	8
	RETLW	B'01101111'	;	9

;--------------------------------------------------------------------------------
; Lϊe[u̓AZuAhX100ԒnɎ߂邱ƁI
;--------------------------------------------------------------------------------

;--------------------------------------------------------------------------------
;	
;--------------------------------------------------------------------------------

INITIALIZE:

	CLRF	PORTA			; uU[ OFF
	CLRF	PORTB			; LED SZOg OFF

	BANKSEL	OSCCON			; Bank 1
	MOVLW	B'01101100'		; NbN 4MHz ɐݒ
	MOVWF	OSCCON

	CLRF	PIE1			; Bank 1, 荞݂͂ЂƂ܂Sĕs

	BANKSEL	ANSEL			; Bank 1, ANSEL ݒ TRISA/B ݒOłȂ_ƂET
	CLRF	ANSEL			; ЂƂ܂S|[gfW^ɐݒ

	CLRF	TRISA			; Bank 1, ЂƂ܂S|[go͂Ɏw
	CLRF	TRISB			; Bank 1
	BSF		TRISA,SETTING	; ^C}lݒ|[g͂ɍĎw

	BANKSEL	CMCON			; Bank 0
	MOVLW	B'00000111'		; Rp[^gp
	MOVWF	CMCON

	BANKSEL	OPTION_REG		; Bank 1
	MOVLW	B'10000101'		; Weak pull up disable, TMR0 interanal clock, PSA = TMR0, PS = 1:64
	MOVWF	OPTION_REG		; ̈ʒu OPTION_REG NAĂȂƍŏ̃L[XLɎs

	BANKSEL	PORTA			; Bank 0
	CLRF	USER_FLAG		; etO

;--------------------------------------------------------------------------------
;	ÑL[`FbNiS΍j
;--------------------------------------------------------------------------------

	CALL	KEY_CHECK		; ÑL[`FbN
	BTFSC	KEY_STATUS		; L[ꂽ ?
	GOTO	KEY_ERROR		; ĂG[\̂܂܂Ŗ[v

;--------------------------------------------------------------------------------
;	TMR1 ݒ, RyA@\g 500ms 荞݂ɐݒ
;--------------------------------------------------------------------------------

	CLRF	INTCON			; Bank 0A܂荞݂͋Ȃ

	CLRF	TMR1H			; Bank 0, TMR1 NA
	CLRF	TMR1L			; Bank 0

	MOVLW	B'00001011'		; Campare mode with Special event triger enable
	MOVWF	CCP1CON			; Bank 0

	MOVLW	H'F4'			; &HF423 = 62500 - 1A1us x 62500 = 62.5ms
	MOVWF	CCPR1H			; Bank 0
	MOVLW	H'23'
	MOVWF	CCPR1L			; Bank 0

	MOVLW	B'00110100'		; TMR1 ͓NbNAvXP[ 1:8  62.5ms x 8 = 500ms Ɋݔ
	MOVWF	T1CON			; Bank 0

	BANKSEL	PIE1
	BCF		PIE1,TMR1IE		; Bank 1, TMR1 I[o[t[荞݂͎gpȂ̂ŕs
	NOP
	BSF		PIE1,CCP1IE		; Bank 1, RyA݋

	BANKSEL	INTCON
	BSF		INTCON,GIE		; Bank 0, S̊荞݋
	NOP
	BSF		INTCON,PEIE		; Bank 0, ӊ荞݋

	BSF		T1CON, TMR1ON	; Bank 0, TMR1 X^[g

;--------------------------------------------------------------------------------
;	C[vJn
;--------------------------------------------------------------------------------

	CALL	POWER_OFF		; c OFF X^[g

MAIN_LOOP:

	MOVF	MINUTE,F
	BTFSS	STATUS,Z		; c莞 = 0 ?
	GOTO	MAIN_LOOP2		; c莞

	CALL	POWER_OFF		; ݒ莞ԃI[o[An_Sef

MAIN_LOOP2:

	CALL	SET_LED_DATA	; \p^[ݒ
	CALL	DISPLAY			; LED _Ci~bN\

	CALL	KEY_CHECK
	BTFSS	KEY_STATUS		; L[ꂽ ?
	GOTO	MAIN_LOOP		; NO
;
;							; L[[ꂽ
;
	BTFSS	POWER_STATUS	; dON ?
	GOTO	RESET_TIMER		; No, ^C}[ZbgēdON
;
;							; d
;
	MOVF	MINUTE,W		; c莞Ԃǂݏo
	SUBLW	ORANGE_V		; ORANGE_V - MINUTE(W) -> W
	BTFSC	STATUS,C		; MINUTE > ORANGE_V  ؂ꔭ  C=0  ̖߃XLbv
	GOTO	RESET_TIMER		; c莞ԂȂ̂Ń^C}[Zbg
;
;							; c莞ԂΕ\ŃL[ƃn_Sef
;
	BSF		BUZZER_PORT		; BUZZER ON
	CALL	WAIT_25ms		; L[Ah~A4MHz Ȃ̂ 50ms
	CALL	WAIT_25ms		; L[Ah~A4MHz Ȃ̂ 50ms

	BCF		BUZZER_PORT		; BUZZER OFF
	CALL	WAIT_25ms		; L[Ah~A4MHz Ȃ̂ 50ms
	CALL	WAIT_25ms		; L[Ah~A4MHz Ȃ̂ 50ms

	CALL	POWER_OFF		; dOFF

	GOTO	MAIN_LOOP
;
;							; c莞Ԃ򂩐ԂŃL[ƃ^C}[Zbg
;

RESET_TIMER:

	BSF		BUZZER_PORT		; BUZZER ON
	CALL	WAIT_25ms		; L[Ah~A4MHz Ȃ̂ 50ms
	CALL	WAIT_25ms		; L[Ah~A4MHz Ȃ̂ 50ms

	BCF		BUZZER_PORT		; BUZZER OFF
	CALL	WAIT_25ms		; L[Ah~A4MHz Ȃ̂ 50ms
	CALL	WAIT_25ms		; L[Ah~A4MHz Ȃ̂ 50ms

	CALL	POWER_ON		; ^C}[Zbg & cēd ON

	GOTO	MAIN_LOOP

;--------------------------------------------------------------------------------
;	NɃL[ĂG[iS΍j
;--------------------------------------------------------------------------------

KEY_ERROR:

	CALL	POWER_OFF		; Ƃɂc OFF
	CALL	SET_ERROR		; G[\p^[Zbg

KEY_ERROR2:

	CALL	DISPLAY			; LED \
	GOTO	KEY_ERROR2		; ̂܂ܖ[vid؂邵Ȃj

;--------------------------------------------------------------------------------
;	ȉTu[`Q
;--------------------------------------------------------------------------------

;--------------------------------------------------------------------------------
;	x LED \p^[A\F̌
;	 COLOR_FLAG  GREEN_BIT, RED_BIT ̂ŐF܂
;	 PATTERN_H, PATTERN_L Ƀrbgp^[ZbgĖ߂
;--------------------------------------------------------------------------------

SET_LED_DATA:

	MOVF	MINUTE,W		; ǎc莞Ԃǂݏo

	BTFSC	STATUS,Z		; c莞 0 ?
	GOTO	SET_STOP		; 0 Ȃ[\

	MOVWF	BUNSHI			; ǎc莞Ԃ𕪎qɃZbg
	MOVLW	D'10'			; c莞Ԃ͕K2ȉȂ̂ 10  1񊄂 BCD ϊI
	MOVWF	BUNBO
	CALL	DIV8			; BCD ϊ
	MOVF	DIV_ANS,W
	MOVWF	BCD_H			;  = BCDʌ
	MOVF	DIV_MOD,W
	MOVWF	BCD_L			; ] = BCDʌ

	CLRF	COLOR_FLAG		; Frbg
	CLRF	PATTERN_H		; \p^[
	CLRF	PATTERN_L		; \p^[

							; BCD ϊl`FbN

	MOVF	BCD_H,W			; 10̈ʂÔ߃`FbN
	SUBLW	D'9'			; 9 - ϊl -> W (10̈ʂ9ȏɂ͂ȂȂ)
	BTFSS	STATUS,C		; ϊl < 9  ؂ꔭȂ  C=1  ̖߃XLbv
	GOTO	SET_ERROR		; ER \ݒ

	MOVF	BCD_L,W			; 1̈ʂÔ߃`FbN
	SUBLW	D'9'			; 9 - ϊl -> W (1̈ʂ9ȏɂ͂ȂȂ)
	BTFSS	STATUS,C		; ϊl < 9  ؂ꔭȂ  C=1  ̖߃XLbv
	GOTO	SET_ERROR		; ER \ݒ

							; Fݒ菈

	MOVF	MINUTE,W		; ǎc莞ԁi10ijǂݏo
	SUBLW	RED_V			; RED_V - MINUTE -> W
	BTFSC	STATUS,C		; MINUTE > RED_V  ؂ꔭ  C=0  ̖߃XLbv
	GOTO	RED				; ԐF\

	MOVF	MINUTE,W		; ǎc莞ԁi10ijǂݏo
	SUBLW	ORANGE_V		; ORANGE_V - MINUTE -> W
	BTFSC	STATUS,C		; MINUTE > ORANGE_V  ؂ꔭ  C=0  ̖߃XLbv
	GOTO	ORANGE			; F\

	GOTO	GREEN			; ȏȂΐF\

;--------------------------------------------------------------------------------
;	F̃tO
;--------------------------------------------------------------------------------

RED:						; 

	CALL	SET_RED
	GOTO	GET_LED_PATTERN

GREEN:						; 

	CALL	SET_GREEN
	GOTO	GET_LED_PATTERN

ORANGE:						; 

	CALL	SET_ORANGE

	GOTO	GET_LED_PATTERN

SET_ERROR:

	CALL	SET_RED			; G[͐ԐF\

	MOVLW	E_PATTERN
	MOVWF	PATTERN_H		; ㌅ɒ 'E' p^[Zbg
	MOVLW	R_PATTERN
	MOVWF	PATTERN_L		; ɒ 'R' p^[Zbg

	MOVLW	D'1'
	MOVWF	BCD_H			; ʌ\悤_~[lZbg

	RETURN

SET_STOP:

	CALL	SET_GREEN		; OFF ΐF\

	MOVLW	S_PATTERN
	MOVWF	PATTERN_H		; ㌅ɒ '-' p^[Zbg
	MOVLW	S_PATTERN
	MOVWF	PATTERN_L		; ɒ '-' p^[Zbg

	MOVLW	D'1'
	MOVWF	BCD_H			; ʌ\悤_~[lZbg

	BCF		USER_FLAG,DP	; DP 

	RETURN

;--------------------------------------------------------------------------------
;	Frbg̃Zbg
;--------------------------------------------------------------------------------

SET_RED:

	BSF		RED_BIT
	BCF		GREEN_BIT
	RETURN

SET_GREEN:

	BCF		RED_BIT
	BSF		GREEN_BIT
	RETURN

SET_ORANGE:

	BSF		RED_BIT
	BSF		GREEN_BIT
	RETURN

;--------------------------------------------------------------------------------
;	BCD lɊÂ LED \p^[ɃZbg
;--------------------------------------------------------------------------------

GET_LED_PATTERN:

	MOVF	BCD_H,W				; 10̈ʂ𓾂
	CALL	GET_7SEG_PATTERN	; ϊ
	MOVWF	PATTERN_H			; p^[ۑ

	MOVF	BCD_L,W				; 1̈ʂ𓾂
	CALL	GET_7SEG_PATTERN	; ϊ
	MOVWF	PATTERN_L			; p^[ۑ

	RETURN

;--------------------------------------------------------------------------------
;	_Ci~bN_
;--------------------------------------------------------------------------------

DISPLAY:
								; \Ɋ荞݂Ă悤ɕ\p^[[NGAɓǂݏoĂ

	MOVF	PATTERN_H,W			; ʌ\p^[ǂݏo
	MOVWF	LED_PATTERN_H

	MOVF	PATTERN_L,W			; ʌ\p^[ǂݏo
	MOVWF	LED_PATTERN_L

	CALL	ALL_LED_OFF			; S

	MOVF	BCD_H,W				; H̒l 0 ? iZtOݒj
	BTFSC	STATUS,Z			; H 0 ȊO  Z=0  ̖߃XLbv
	GOTO	L_COLUMN			; H 0 Ȃ̂ H\XLbv

;--------------------------------------------------------------------------------
;	H \
;--------------------------------------------------------------------------------

H_COLUMN:

	BTFSC	GREEN_BIT			; ΃rbg 0 Ȃ玟XLbv
	BCF		HG_PORT				; H  ON (L=_)

	BTFSC	RED_BIT				; ԃrbg 0 Ȃ玟XLbv
	BCF		HR_PORT				; H  ON (L=_)

	MOVF	LED_PATTERN_H,W		; ʌp^[ǂݏo
	CALL	SEG_A				; ZOgJn

	CALL	ALL_LED_OFF			; S

;--------------------------------------------------------------------------------
;	L \
;--------------------------------------------------------------------------------

L_COLUMN:

	BTFSC	GREEN_BIT			; ΃rbg 0 Ȃ玟XLbv
	BCF		LG_PORT				; L  ON (L=_)

	BTFSC	RED_BIT				; ԃrbg 0 Ȃ玟XLbv
	BCF		LR_PORT				; L  ON (L=_)

	MOVF	LED_PATTERN_L,W		; ʌp^[ǂݏo
	CALL	SEG_A				; ZOgJn

	BTFSS	DP_STATUS			; DP ԊǗtOQƂ
	GOTO	L_COLUMN2			; DP ȂI

	BSF		DP_SEG				; DP ZOg_
	CALL	HOLD_LED
	BCF		DP_SEG				; DP ZOg
	CALL	HOLD_LED_SHORT

L_COLUMN2:

	CALL	ALL_LED_OFF			; S

	RETURN

;--------------------------------------------------------------------------------
;	ZOg
;	IN: W = rbgp^[
;--------------------------------------------------------------------------------

SEG_A:

	MOVWF	SEGMENT				; rbgp^[ۑ

	BTFSS	SEGMENT,0			; a ZOgrbg 1 Ȃ玟̖߂XLbv
	GOTO	SEG_B				; ̃ZOg

	BSF		A_SEG				; a ZOg_
	CALL	HOLD_LED
	BCF		A_SEG				; a ZOg
	CALL	HOLD_LED_SHORT

SEG_B:

	BTFSS	SEGMENT,1			; b ZOgrbg 1 Ȃ玟̖߂XLbv
	GOTO	SEG_C				; ̃ZOg

	BSF		B_SEG				; b ZOg_
	CALL	HOLD_LED
	BCF		B_SEG				; b ZOg
	CALL	HOLD_LED_SHORT

SEG_C:

	BTFSS	SEGMENT,2			; c ZOgrbg 1 Ȃ玟̖߂XLbv
	GOTO	SEG_D				; ̃ZOg

	BSF		C_SEG				; c ZOg_
	CALL	HOLD_LED
	BCF		C_SEG				; c ZOg
	CALL	HOLD_LED_SHORT

SEG_D:

	BTFSS	SEGMENT,3			; d ZOgrbg 1 Ȃ玟̖߂XLbv
	GOTO	SEG_E				; ̃ZOg

	BSF		D_SEG				; d ZOg_
	CALL	HOLD_LED
	BCF		D_SEG				; d ZOg
	CALL	HOLD_LED_SHORT

SEG_E:

	BTFSS	SEGMENT,4			; e ZOgrbg 1 Ȃ玟̖߂XLbv
	GOTO	SEG_F				; ̃ZOg

	BSF		E_SEG				; e ZOg_
	CALL	HOLD_LED
	BCF		E_SEG				; e ZOg
	CALL	HOLD_LED_SHORT

SEG_F:

	BTFSS	SEGMENT,5			; f ZOgrbg 1 Ȃ玟̖߂XLbv
	GOTO	SEG_G				; ̃ZOg

	BSF		F_SEG				; f ZOg_
	CALL	HOLD_LED
	BCF		F_SEG				; f ZOg
	CALL	HOLD_LED_SHORT

SEG_G:

	BTFSS	SEGMENT,6			; g ZOgrbg 1 Ȃ玟̖߂XLbv
	RETURN						; g ZOg_ȂȂ߂

	BSF		G_SEG				; g ZOg_
	CALL	HOLD_LED
	BCF		G_SEG				; g ZOg

	RETURN

;--------------------------------------------------------------------------------
;	LED S
;--------------------------------------------------------------------------------

ALL_LED_OFF:

	CLRF	PORTB				; LED SZOg

	MOVF	USER_FLAG,W			; BUZZER Ɠd|[gԂǂݏo
	MOVWF	PORTA_TMP

	BSF		PORTA_TMP,LG		; H=OFF
	BSF		PORTA_TMP,HG
	BSF		PORTA_TMP,LR
	BSF		PORTA_TMP,HR

	MOVF	PORTA_TMP,W
	MOVWF	PORTA				; |[g֏

	RETURN

;--------------------------------------------------------------------------------
;	LED \莞ԕێi߁j
;--------------------------------------------------------------------------------

HOLD_LED:

	CALL	WAIT_500us			; 4MHZ Ȃ̂ 1ms

	RETURN

;--------------------------------------------------------------------------------
;	LED \莞ԕێiZ߁j
;--------------------------------------------------------------------------------

HOLD_LED_SHORT:

	CALL	WAIT_50us			; 4MHz Ȃ̂ 100us

	RETURN

;--------------------------------------------------------------------------------
;	d ON 
;--------------------------------------------------------------------------------

POWER_ON:

	CALL	SET_MINUTE		; c莞ԏ
	CALL	CLEAR_EVENT		; xpJE^

	BSF		CONTROL_PORT	; d ON
	BSF		POWER_STATUS	; tO𗧂Ă

	RETURN

;--------------------------------------------------------------------------------
;	d OFF 
;--------------------------------------------------------------------------------

POWER_OFF:

	CLRF	MINUTE			; c莞Ԃ 0 ɂĂ
	CALL	CLEAR_EVENT		; Ô߃JE^ނZbgĂ

	BCF		CONTROL_PORT	; d OFF
	BCF		POWER_STATUS	; tONA

	RETURN

;--------------------------------------------------------------------------------
;	c莞Ԃ̏
;--------------------------------------------------------------------------------

SET_MINUTE:

	MOVLW	MINUTE1			; WpI[v̐ݒ

	BTFSS	SETTING_PORT	; ɏ邩ݒǂݏo
	MOVLW	MINUTE2			; WpV[g̐ݒ

	MOVWF	MINUTE			; c莞ԃZbg

	BSF		CONTROL_PORT	; d ON

	RETURN

;--------------------------------------------------------------------------------
;	ԃJE^̏
;--------------------------------------------------------------------------------

CLEAR_EVENT:

	MOVLW	D'60'			; 1min = 60 sec
	MOVWF	MINUTE_COUNTER

RESET_1st_COUNTER:

	MOVLW	D'2'			; ̊荞݂1bɂȂ邩
	MOVWF	SECOND_COUNTER

	RETURN

;--------------------------------------------------------------------------------
;	duU[炷
;	Ă鎞Ԃ͊݉񐔂Ő
;--------------------------------------------------------------------------------

ALARM_ON:

	MOVLW	D'1'			; 荞 500ms x 1 = 500ms 炷
	MOVWF	ALARM_COUNTER	; uU[pJE^

	BSF		ALARM_STATUS	; tO𗧂Ă
	BSF		BUZZER_PORT		; BUZZER ON

	RETURN

;--------------------------------------------------------------------------------
;	duU[~߂
;--------------------------------------------------------------------------------

ALARM_OFF:

	BCF		ALARM_STATUS	; tOZbg
	BCF		BUZZER_PORT		; BUZZER OFF

	RETURN

;--------------------------------------------------------------------------------
;	L[`FbN
;	RETURN: KEYS_STATUS = 0  L[͉ĂȂA1  L[ꂽ
;--------------------------------------------------------------------------------

KEY_CHECK:

	BCF		KEY_STATUS		; tOZbgĂ

	BTFSC	KEY_PORT		; XCb`ꂽ? L = ꂽ
	RETURN					; H = ĂȂ

	CALL	WAIT_25ms		; ꂽ炵΂炭҂i`^Oh~jA4MHz Ȃ̂ 50ms
	BTFSC	KEY_PORT		; ܂XCb`Ă邩?
	RETURN					; H = ĂȂ

	BSF		KEY_STATUS		; L[Ă̂ŃtO𗧂Ă

	RETURN

;--------------------------------------------------------------------------------
;	8bit Z[`Av͕qŉ邩JEg΂悢
;	IN:     BUNSHIi鐔j,	BUNBOi鐔j
;	RETURN: DIV_ANSij, 			DIV_MODi]j
;--------------------------------------------------------------------------------

DIV8:

	CLRF	DIV_ANS			; pNA
	CLRF	DIV_MOD			; ]pNA

	MOVF	BUNBO,W
	BTFSC	STATUS,Z
	GOTO	ANS_ZERO		;  = 0 ̓G[AbI 0 Ԃ

	MOVF	BUNSHI,W
	BTFSC	STATUS,Z
	GOTO	ANS_ZERO		; q = 0 Ȃ瓚 0 m

DIV_LOOP:

	MOVF	BUNSHI,W		; _̊鐔ǂݏo
	MOVWF	DIV_MOD			; ȏȂꍇ͂̒l̂܂ܗ]ɂȂ

	MOVF	BUNBO,W
	SUBWF	BUNSHI,F		; BUNSHI - W(BUNBO) -> BUNSHI

	BTFSS	STATUS,C		; ܂ȂL[Ȃ̂ C=1 ƂȂ莟̍sXLbv
	RETURN					; Ȃ̂ŏI

	BTFSC	STATUS,Z		; ؂Ȃꍇ Z=0 ƂȂ莟̍sXLbv
	GOTO	CLEAR_MOD		; ؂ꂽꍇ͗]NAKv

	INCF	DIV_ANS,F		; JEgAbv
	GOTO	DIV_LOOP		; Z𑱂

CLEAR_MOD:

	INCF	DIV_ANS,F		; JEgAbv
	CLRF	DIV_MOD			; ]NA

	RETURN

ANS_ZERO:

	CLRF	DIV_ANS
	CLRF	DIV_MOD

	RETURN

;--------------------------------------------------------------------------------
;	Cuǂݍ
;--------------------------------------------------------------------------------

	INCLUDE		Time.lib	; NbN8MHzpԑ҂[vCu

;--------------------------------------------------------------------------------
;	vOI
;--------------------------------------------------------------------------------

	END
