;--------------------------------------------------------------------------------
;	v[e[V^C}[ 2 Programmed by GRANADA
;
;	Ver 1.0		2010/12/15`2010/12/17 	v[e[V^C}[ij
;										7 ZO LED X^eBbN_֕ύXAOtBbN\Ή
;	Ver 1.1		2011/03/02				TMR1 RyAlC
;
;	i{\[XvO̓^u4ɐݒ肷Yɐ`܂j
;	LF http://www.asahi-net.or.jp/~SE1M-NITU/html/Presentation_Timer2.htm
;--------------------------------------------------------------------------------

	LIST		P=16F690
	INCLUDE		P16F690.INC

	ERRORLEVEL	-205
	ERRORLEVEL	-302

;	ONbN 4MHz

	__CONFIG _FCMEN_OFF & _CP_OFF & _CPD_OFF & _BOR_ON & _PWRTE_ON & _MCLRE_ON & _HS_OSC & _IESO_OFF & _WDT_OFF

;--------------------------------------------------------------------------------
;	AZuݒ
;--------------------------------------------------------------------------------

LED_TYPE = 1			; 7ZO LED J\[hRȂ 1AAm[hRȂ 0

;--------------------------------------------------------------------------------
;	ϐAhX`
;--------------------------------------------------------------------------------

CBLOCK	H'20'			; [U[pt@CWX^iϐ̈j擪AhX

	USER_FLAG			; etO

	BCD_H				; BCD ϊliʁjp
	BCD_M				; BCD ϊliʁjp
	BCD_L				; BCD ϊliʁjp

	PATTERN_H			; 1rbgp^[
	PATTERN_M			; 2rbgp^[
	PATTERN_L			; 3rbgp^[

	SEGMENT				; \rbgp^[

	UP_SW				; XLp[N
	DW_SW
	ST_SW

	KEY_FLAG			; L[XLptO

	MIN_H				; [N
	MIN_L				; [N

	SEC_H_TMP			; [N
	SEC_L_TMP			; [N

	COUNTER1			; ԑ҂p
	COUNTER2			; ԑ҂p
	COUNTER3			; ԑ҂p

	MES_CNT				; bZ[W\pJE^

	BEEP_CNT_H			; r[vpJE^
	BEEP_CNT_L

	KEY_SCAN_C			; L[XLo

ENDC

CBLOCK	H'70'			; SoNʃt@CWX^擪AhX

	W_WORK				; 荞ݎ W WX^ޔp
	ST_WORK				; 荞ݎ̃Xe[^XWX^ޔp

	MINUTE				; c莞ԁij

	SEC_COUNTER			; bvpJE^[

	SEC_H				; cbi 8bitj
	SEC_L				; cbi 8bitj

	EEPROM_DATA			; EEPROM ݒlASoNʃAhXK{

	DISP_MODE			; \[hۑp

	G_FACTOR_H			; Ot\ 1ڐԂ񂪉biʁj
	G_FACTOR_L			; Ot\ 1ڐԂ񂪉biʁj

ENDC

;--------------------------------------------------------------------------------
;	|[g蓖
;--------------------------------------------------------------------------------
;
;RA0	DW_SP	DIGITAL IN		ݒ莞 UP XCb`
;RA1	UP_SW	DIGITAL IN		ݒ莞 DW XCb`
;RA2	ST_SW	DIGITAL IN		X^[gXCb`
;
;RA3			DIGITAL IN		MCLR
;RA4(OSC2)		DIGITAL IN		ONbNp
;RA5(OSC1)		DIGITAL IN		ONbNp
;
;RB4	C1		DIGITAL OUT		1ڐ
;RB5	C2		DIGITAL OUT		2ڐ
;RB6	C3		DIGITAL OUT		3ڐ
;RB7	BUZZER	DIGITAL OUT		duU[
;
;RC0	LED a	DIGITAL OUT
;RC1	LED b	DIGITAL OUT
;RC2	LED c	DIGITAL OUT
;RC3	LED d	DIGITAL OUT
;RC4	LED e	DIGITAL OUT
;RC5	LED f	DIGITAL OUT
;RC6	LED g	DIGITAL OUT
;RC7	LED dp	DIGITAL OUT
;
;--------------------------------------------------------------------------------
;	萔`, EQU ł͂Ȃ DEFINE g MPLAB SIM ̃t@CWX^_vɕ֗
;	it@CWX^ɒ萔ꍞ܂Ȃj
;--------------------------------------------------------------------------------

#DEFINE		KEY_SCAN1		D'5'		; L[XLiZ߁j񐔁Aݒ胂[hł̃L[XLɎgp
										; 24ms x  5 = 120ms ԉƃXCb`Ɣ肳
#DEFINE		KEY_SCAN2		D'15'		; L[XLi߁j񐔁AJEg̃L[XLɎgp
										; 24ms x 15 = 360ms ԉƃXCb`Ɣ肳

#DEFINE		S_PATTERN	B'01101101'		; S \̃rbgp^[
#DEFINE		e_PATTERN	B'01111011'		; e \̃rbgp^[
#DEFINE		t_PATTERN	B'01111000'		; t \̃rbgp^[

#DEFINE		g_PATTERN	B'01101111'		; g \̃rbgp^[
#DEFINE		o_PATTERN	B'01011100'		; o \̃rbgp^[
#DEFINE		ex_PATTERN	B'10000010'		; ! \̃rbgp^[

;--------------------------------------------------------------------------------
;	|[g`
;--------------------------------------------------------------------------------

#DEFINE		TIME_OVER_FLAG	USER_FLAG,0	; 1 = ݒ莞Ԃ߂
#DEFINE		ZERO_SUP1		USER_FLAG,1	; 1 = 1ڃ[TvX
#DEFINE		ZERO_SUP2		USER_FLAG,2	; 1 = 2ڃ[TvX
#DEFINE		SETTING_MODE	USER_FLAG,3	; 1 = ԃZbg[h
#DEFINE		STOP_FLAG		USER_FLAG,4	; 1 = JEg~
#DEFINE		FLASH_FLAG		USER_FLAG,5	; 1 = LED _A0 = BLED _ŐpgO
#DEFINE		SEC_MODE		USER_FLAG,6	; 1 = b\

#DEFINE		DISP_FLAG		DISP_MODE,0	; 1 = OtBbN\A0 = l\

#DEFINE		UP_SW_FLAG		KEY_FLAG,0	; 1 = UP SW 莞ԉꑱ
#DEFINE		DW_SW_FLAG		KEY_FLAG,1	; 1 = DW SW 莞ԉꑱ
#DEFINE		ST_SW_FLAG		KEY_FLAG,2	; 1 = ST SW 莞ԉꑱ

#DEFINE		C1_PORT			PORTB,4		; 1ڐ|[g
#DEFINE		C2_PORT			PORTB,5		; 2ڐ|[g
#DEFINE		C3_PORT			PORTB,6		; 3ڐ|[g
#DEFINE		BZ_PORT			PORTB,7		; duU[|[g

#DEFINE		DW_SW_PORT		PORTA,0		; DW XCb`|[g
#DEFINE		UP_SW_PORT		PORTA,1		; UP XCb`|[g
#DEFINE		ST_SW_PORT		PORTA,2		; ST XCb`|[g

#DEFINE		A_SEG	PORTC,0				; LED a ZOg̃|[gԍ
#DEFINE		B_SEG	PORTC,1				; LED b ZOg̃|[gԍ
#DEFINE		C_SEG	PORTC,2				; LED c ZOg̃|[gԍ
#DEFINE		D_SEG	PORTC,3				; LED d ZOg̃|[gԍ
#DEFINE		E_SEG	PORTC,4				; LED e ZOg̃|[gԍ
#DEFINE		F_SEG	PORTC,5				; LED f ZOg̃|[gԍ
#DEFINE		G_SEG	PORTC,6				; LED g ZOg̃|[gԍ
#DEFINE		DP_SEG	PORTC,7				; LED dp ZOg̃|[gԍ

;--------------------------------------------------------------------------------
;	}N`
;--------------------------------------------------------------------------------

BANK0	macro
		BCF		STATUS,RP1
		NOP
		BCF		STATUS,RP0
		endm

BANK1	macro
		BCF		STATUS,RP1
		NOP
		BSF		STATUS,RP0
		endm

BANK2	macro
		BSF		STATUS,RP1
		NOP
		BCF		STATUS,RP0
		endm

BANK3	macro
		BSF		STATUS,RP1
		NOP
		BSF		STATUS,RP0
		endm

;--------------------------------------------------------------------------------
;	vO擪
;--------------------------------------------------------------------------------

	ORG		H'0'
	GOTO	INITIALIZE

;--------------------------------------------------------------------------------
;	荞ݏ (500ms ɔłj
;--------------------------------------------------------------------------------

	ORG		H'4'				; 荞ݏ擪AhX

	MOVWF	W_WORK				; WX^Ҕ
	SWAPF	STATUS,W			; Z tOeȂ悤AMOVF ł͂Ȃ SWAPF gp
	MOVWF	ST_WORK

	BANK0						; I Bank 0 ɐݒB荞ݕAɃoN͎Iɖ߂

;
;	݌`FbN
;

	BTFSS	PIR1,CCP1IF			; Bank 0, TMR1 compare special event triger  ?
	GOTO	POP_REG				; Ⴄ̂ŊݏI

;
;	TMR1 RyAݏ
;

	BCF		PIR1,CCP1IF			; Bank 0, Special event triger ݃tONA

;
;	JEgf ?
;
;	BTFSC	STOP_FLAG
;	GOTO	POP_REG				; fȂ̂ŉȂŖ߂

;
;	500ms ̏i_ŕ\tOj
;

	BTFSS	FLASH_FLAG			; LED tO`FbN
	GOTO	ST_LED_ON

	BCF		FLASH_FLAG			; tO𔽓] LED OFF
	GOTO	CHK_SEC

ST_LED_ON:

	BSF		FLASH_FLAG			; tO𔽓] LED ON

;
;	1bo߃`FbN
;

CHK_SEC:

	DECFSZ	SEC_COUNTER,F		; JE^`FbN
	GOTO	POP_REG				; 1b̏ꍇ͊ݏI

;
;	ȍ~ 1b̏
;

	CALL	RESET_SEC_CNTR		; bJE^̃Zbg

;
;	JEg[h up  down 
;

	BTFSC	TIME_OVER_FLAG		; 0 = count down
	GOTO	COUNT_UP			; 1 = count up

;
;	JEg_E[h
;

COUNT_DOWN:
								; 16bit fNg
	DECF	SEC_L,F				;  - 1
	DECF	SEC_H,F				;  - 1
	INCFSZ	SEC_L,W				;  + 1  0  ?i؂ꂪj
	INCF	SEC_H,F				; ؂ꂪȂ̂ŏ + 1 ŏC

	MOVF	SEC_H,W
	BTFSS	STATUS,Z
	GOTO	POP_REG				; ʂ 0 ł͂Ȃ
	MOVF	SEC_L,W
	BTFSS	STATUS,Z
	GOTO	POP_REG				; ʂ 0 ł͂Ȃ

;
;	Ԃg؂i b 0A^CI[o[ j
;

	BSF		TIME_OVER_FLAG		; Ԑ؂AȌ̓JEgAbv̂ŃtO𗧂Ă

	GOTO	POP_REG

;
;	JEgAbv[hiݒ莞Ԍoߌj
;

COUNT_UP:

	BCF		SEC_MODE			; b\

	INCFSZ	SEC_L,F				; b 8bit JEgAbvČJオ肪`FbN
	GOTO	POP_REG				; Jオ肪Ȃ̂ŏI

	INCF	SEC_H,F				; Jオi255->0j 8bit JEgAbv

;
;	ݏI
;

POP_REG:						; WX^A`荞ݏI

	SWAPF	ST_WORK,W
	MOVWF	STATUS
	SWAPF	W_WORK,F
	SWAPF	W_WORK,W

	RETFIE					; 荞ݏI

;--------------------------------------------------------------------------------
;	1̐7ZOgrbgp^[Ԃ
;--------------------------------------------------------------------------------

GET_7SEG_PATTERN:

	ADDWF	PCL,F
;			   gfedcba
	RETLW	B'00111111'	;	0
	RETLW	B'00000110'	;	1
	RETLW	B'01011011'	;	2
	RETLW	B'01001111'	;	3
	RETLW	B'01100110'	;	4
	RETLW	B'01101101'	;	5
	RETLW	B'01111101'	;	6
	RETLW	B'00100111'	;	7
	RETLW	B'01111111'	;	8
	RETLW	B'01101111'	;	9

;--------------------------------------------------------------------------------
; Lϊe[u̓AZuAhX100ԒnɎ߂邱ƁI
;--------------------------------------------------------------------------------

;--------------------------------------------------------------------------------
;	
;--------------------------------------------------------------------------------

INITIALIZE:

	CLRF	PORTA
	CLRF	PORTB
	CLRF	PORTC			; LED SZOg OFF

	BANK2

	CLRF	ANSEL			; Bank 2, S|[gfW^ݒ
	CLRF	ANSELH			; Bank 2

	BANK1

	CLRF	PIE1			; Bank 1, 荞݂͂ЂƂ܂Sĕs

	MOVLW	B'00111111'		; ̓|[gݒiONbNj
	MOVWF	TRISA			; Bank 1
	CLRF	TRISB			; Bank 1
	CLRF	TRISC			; Bank 1

	MOVLW	B'00000101'		; Weak pull up enable, TMR0 interanal clock, PSA = TMR0, PS = 1:64
	MOVWF	OPTION_REG		; Bank 1

	MOVLW	B'00001111'		; L[̓|[g RA0-2  Weak pull up enableAMCLR (RA3) ͎I enable
	MOVWF	WPUA			; Bank 1

	BANK2

	CLRF	WPUB			; Bank 2, LED |[g Weak pull up disable

	BANK0

;--------------------------------------------------------------------------------
;	TMR1 ݒ, RyA@\g 500ms 荞݂ɐݒ
;--------------------------------------------------------------------------------

	CLRF	INTCON			; Bank 0A܂荞݂͋Ȃ

	CLRF	TMR1H			; Bank 0, TMR1 NA
	CLRF	TMR1L			; Bank 0

	MOVLW	B'00001011'		; Campare mode with Special event triger enable
	MOVWF	CCP1CON			; Bank 0

	MOVLW	H'F4'			; &HF423 = 62500 - 1
	MOVWF	CCPR1H			; Bank 0
	MOVLW	H'23'
	MOVWF	CCPR1L			; Bank 0

	MOVLW	B'00110100'		; vXP[ 1:8 ɐݒB62.5ms x 8 = 500ms Ɋ݂
	MOVWF	T1CON			; Bank 0

	BANK1

	BCF		PIE1,TMR1IE		; Bank 1, TMR1 I[o[t[荞݂͎gpȂ̂ŕs
	NOP
	BSF		PIE1,CCP1IE		; Bank 1, RyA݋

	BANK0

	BSF		INTCON,GIE		; Bank 0, S̊荞݋
	NOP
	BSF		INTCON,PEIE		; Bank 0, ӊ荞݋

	BCF		T1CON, TMR1ON	; Bank 0, ܂ TMR1 ̓X^[gȂ

;--------------------------------------------------------------------------------
;	O\[h̓ǂݏo
;--------------------------------------------------------------------------------

	MOVLW	D'61'			; EEPROM AhXw
	CALL	READ_EEPROM		; \[h W WX^Ɏ擾
	MOVWF	DISP_MODE		; lɓ]A DISP_FLAG Iɐݒ肳

;--------------------------------------------------------------------------------
;	^C}[Ԑݒ
;--------------------------------------------------------------------------------

RESTART:

	CLRF	USER_FLAG		; etO

	CALL	SET_TIMER		; Ԑݒ

;--------------------------------------------------------------------------------
;	C[vJn
;--------------------------------------------------------------------------------

MAIN_LOOP:

	CALL	SET_LED_DATA	; \p^[ݒ

	CALL	EXEC_DISPLAY	; LED \

;--------------------------------------------------------------------------------
;	JEgfEĊJXCb``FbN
;--------------------------------------------------------------------------------

	CALL	SCAN_SW			; XCb`͊Ď

	BTFSS	ST_SW_FLAG		; 1 = ST XCb`ꂽ
	GOTO	CHK_TMR_RESET	; ĂȂ΃Zbg`FbN

	BTFSS	STOP_FLAG		; ݃JEgf ?
	GOTO	STOP_CNT		; NoAJEgf

;--------------------------------------------------------------------------------
;	JEgĊJ
;--------------------------------------------------------------------------------

	BSF		T1CON, TMR1ON	; Bank 0, TMR1 ĊJ

	BCF		STOP_FLAG		; JEgĊJ
	NOP
	BSF		FLASH_FLAG		; LED _ŗptO𗧂Ă

	GOTO	SUPRESS_KEY

;--------------------------------------------------------------------------------
;	JEgf
;--------------------------------------------------------------------------------

STOP_CNT:

	BCF		T1CON, TMR1ON	; Bank 0, ܂ TMR1 ~

	BSF		STOP_FLAG		; ftO𗧂Ă
	NOP
	BSF		FLASH_FLAG		; LED _ŗptONA

;--------------------------------------------------------------------------------
;	mFƃL[Ah~
;--------------------------------------------------------------------------------

SUPRESS_KEY:

	CALL	BEEP			; fEĊJ͊mF炷
	CALL	WAIT_400ms_4MHz	; Ah~

	GOTO	MAIN_LOOP

;--------------------------------------------------------------------------------
;	JEgf UP/DW L[`FbN
;--------------------------------------------------------------------------------

CHK_TMR_RESET:

	BTFSS	STOP_FLAG		; ݃JEgf ?
	GOTO	MODE_CHANGE_CHK	; JEg_EȂ烂[hύX`FbN

	BTFSS	UP_SW_FLAG		; 1 = UP XCb`ꂽ
	GOTO	MAIN_LOOP		; ĂȂΕA

	BTFSS	DW_SW_FLAG		; 1 = DW XCb`ꂽ
	GOTO	MAIN_LOOP		; ĂȂΕA

	CALL	WAIT_400ms_4MHz	; L[Ah~

	GOTO	RESTART			; JEg_EIă^C}Ԑݒɖ߂

;--------------------------------------------------------------------------------
;	\[hύX`FbN
;--------------------------------------------------------------------------------

MODE_CHANGE_CHK:

	BTFSS	UP_SW_FLAG			; 1 = UP XCb`ꂽ
	GOTO	MODE_CHANGE_CHK2	; ĂȂΎ̃L[`FbN

	BCF		UP_SW_FLAG			; L[̓tONA
	GOTO	SET_DISP_MODE		; [hύX

MODE_CHANGE_CHK2:

	BTFSS	DW_SW_FLAG			; 1 = DW XCb`ꂽ
	GOTO	MAIN_LOOP			; ĂȂΕA

	BCF		DW_SW_FLAG			; L[̓tONA

;--------------------------------------------------------------------------------
;	\[hύX
;	 DISP_MODE  0 bit ̓tO (DISP_FLAG) ˂Ă̂ŁA
;	DISP_FLAG 𑀍삷ƎIɃ DISP_MODE ̒l̂~\
;--------------------------------------------------------------------------------

SET_DISP_MODE:

	CALL	WAIT_200ms_4MHz	; L[Ah~

	BTFSS	DISP_FLAG		; ݂̕\[h`FbN
	GOTO	SET_DISP_MODE2

	BCF		DISP_FLAG		; \[h𔽓]Đl\
	GOTO	SAVE_DISP_MODE

SET_DISP_MODE2:

	BSF		DISP_FLAG		; \[h𔽓]ăOt\

;
;	l EEPROM ɕۑ
;

SAVE_DISP_MODE:

	MOVF	DISP_MODE,W		; EEPROM ɕۑl
	MOVWF	EEPROM_DATA
	MOVLW	D'61'			; EEPROM AhX
	CALL	SAVE_EEPROM		; f[^ۑ

	GOTO	MAIN_LOOP

;--------------------------------------------------------------------------------
;	ȉTu[`Q
;--------------------------------------------------------------------------------

;--------------------------------------------------------------------------------
;	LED \p^[̌
;	 PATTERN_H, PATTERN_M, PATTERN_L Ƀrbgp^[ZbgĖ߂
;--------------------------------------------------------------------------------

SET_LED_DATA:

	MOVF	SEC_H,W			; Ɋ荞݂Ă悢悤ɑbޔĂ
	MOVWF	SEC_H_TMP
	MOVF	SEC_L,W
	MOVWF	SEC_L_TMP

;
;	b -> ϊ
;

	CLRF	A1
	MOVF	SEC_H_TMP,W
	MOVWF	A2
	MOVF	SEC_L_TMP,W
	MOVWF	A3

	CLRF	B1
	CLRF	B2
	MOVLW	D'60'			; 1min = 60sec
	MOVWF	B3

	CALL	DIV24			; in Math24-v2.lib

	MOVF	A2,W
	MOVWF	MIN_H			;  8bit  256opɕۑ
	MOVF	A3,W			;  8bit m
	MOVWF	MIN_L			; c蕪

	BTFSC	SETTING_MODE	; ԃZbg[h ?
	GOTO	MIN2BCD			; ԃZbg[hȂ番\

	BTFSC	TIME_OVER_FLAG	; Ԓ ?
	GOTO	MIN2BCD			; Ԓ߂Ȃ番\

	MOVF	MIN_L,W
	BTFSS	STATUS,Z		; c 0?
	GOTO	MIN2BCD			; c 1ȏ゠̂ŕ\

;
;	b\[hi0-999܂ł\łȂƂɒӁj
;

SEC2BCD:

	BSF		SEC_MODE		; b\tO𗧂Ă

	MOVF	SEC_H_TMP,W		; bǂݏo
	MOVWF	prm1b			; ʂ̓NA
	MOVF	SEC_L_TMP,W		; bǂݏo
	MOVWF	prm1a			; ʃZbg

	GOTO	EXEC_BCD_CONV

;
;	\
;

MIN2BCD:

	MOVF	MIN_H,W			; ̏ 8bit  0  ?
	BTFSS	STATUS,Z
	GOTO	STOP_TIMER		; 255ȏȂ̂ŃX[vŒ~

	BTFSC	TIME_OVER_FLAG
	GOTO	MIN2BCD2		; ^CI[o[ȂOt\͍sȂ
	BTFSC	DISP_FLAG
	GOTO	GRAPH_DISPLAY	; tOĂȂOt\

MIN2BCD2:

	CLRF	prm1b			; ʂ̓NA
	MOVF	MIN_L,W
	MOVWF	prm1a			; ʃZbg

;
;	5 BCD ϊ
;	Ԑݒ莞͂Gg[
;

EXEC_BCD_CONV:

	CALL	HEX2DEC16		; in Math24-v2.lib, 510ilɕϊ

;
;	3\
;

DIGIT3:

	BCF		ZERO_SUP1		; 1ڃ[TvXtONA
	NOP
	BCF		ZERO_SUP2		; 2ڃ[TvXtONA

	MOVF	prm3c,W			; 1
	BTFSC	STATUS,Z		; 1 = 0 ȂɃ[TvX
	GOTO	COL2_CHK		; ̌

	MOVWF	BCD_H			; 1ڒʏ\

COL2:

	MOVF	prm3b,W			; 2
	MOVWF	BCD_M			; 0 łʏ\

	GOTO	COL3

COL2_CHK:					; 1ڂ̓[TvX

	BSF		ZERO_SUP1		; 1ڃ[TvXtO𗧂Ă
	CLRF	BCD_H

	MOVF	prm3b,W	
	BTFSS	STATUS,Z
	GOTO	COL2			; 0 ȊOȂ̂Ő\

	BSF		ZERO_SUP2		; 2ڂ[TvXtO𗧂Ă
	CLRF	BCD_M

COL3:

	MOVF	prm3a,W			; 3
	MOVWF	BCD_L			; 3ڂ͏ɕ\

;--------------------------------------------------------------------------------
;	BCD lɊÂ LED \p^[ɃZbg
;--------------------------------------------------------------------------------

GET_LED_PATTERN:

	CLRF	PATTERN_H			; [TvX
	CLRF	PATTERN_M
	CLRF	PATTERN_L

COLUMN1:

	BTFSC	ZERO_SUP1
	GOTO	COLUMN2				; [TvXԂ2ڂ

	MOVF	BCD_H,W				; 1
	CALL	GET_7SEG_PATTERN	; ϊ
	MOVWF	PATTERN_H			; p^[ۑ

COLUMN2:

	BTFSC	ZERO_SUP2
	GOTO	COLUMN3				; [TvXԂ2ڂ

	MOVF	BCD_M,W				; 2
	CALL	GET_7SEG_PATTERN	; ϊ
	MOVWF	PATTERN_M			; p^[ۑ

COLUMN3:

	MOVF	BCD_L,W				; 3
	CALL	GET_7SEG_PATTERN	; ϊ
	MOVWF	PATTERN_L			; p^[ۑ

	RETURN

;--------------------------------------------------------------------------------
;	255ȏ̓X[vŎE
;--------------------------------------------------------------------------------

STOP_TIMER:

	CALL	BEEP

	CLRF	PORTA				; S|[g L 
	CLRF	PORTB
	CLRF	PORTC

	BCF		T1CON, TMR1ON		; Bank 0, TMR1 ~
	CLRF	INTCON				; Bank 0, 荞݋֎~

	BANK1

	CLRF	PIE1				; Bank 1, 荞݋֎~

STOP2:

	SLEEP
	NOP
	GOTO	STOP2				; Ô

;--------------------------------------------------------------------------------
;	LED _`FbNi_ŁAdp Ȃǁj` X^eBbN LED _Ci~bN\
;	3\ɂ悻 24ms Kv
;--------------------------------------------------------------------------------

EXEC_DISPLAY:

	CALL	ALL_LED_OFF			; S

	BTFSS	SETTING_MODE
	GOTO	EXEC_DISPLAY2		; ݒ胂[hł͂Ȃ

	BSF		PATTERN_H,7			; Ԑݒ胂[hȂ dp  3 Ƃ_
	BSF		PATTERN_M,7
	BSF		PATTERN_L,7

	GOTO	H_COLUMN			; Ԑݒ胂[h͔_łȂ̂ő\

EXEC_DISPLAY2:

	BTFSS	STOP_FLAG			; JEg~
	GOTO	EXEC_DISPLAY3		; JEg\

	BSF		PATTERN_H,7			; ~Ȃ 1ڂ dp _

	GOTO	H_COLUMN			; ~Ȃ^CI[o[ł\

EXEC_DISPLAY3:					; JEg̕\

	BTFSS	TIME_OVER_FLAG		; ݒ莞Ԃ߂
	GOTO	EXEC_DISPLAY4		; ܂߂ĂȂ̂Œʏ폈

								; ݒ莞Ԃ߂̂œ_ŕ\
	BTFSS	FLASH_FLAG			; LED tO`FbN
	RETURN						; LED ^C~OȂ̂ŉȂŖ߂

	GOTO	H_COLUMN			; ^CI[o[͐_ŏԂȂ̂ dp \͕sv

EXEC_DISPLAY4:

	BTFSS	DISP_FLAG
	GOTO	EXEC_DISPLAY5		; ʏ\Ȃ dp `FbN

	BTFSS	SEC_MODE
	GOTO	H_COLUMN			; OtBbN[hŕb\łȂ dp \͕sv

EXEC_DISPLAY5:

	BTFSC	FLASH_FLAG			; \tOĂ
	BSF		PATTERN_L,7			; dp \

;--------------------------------------------------------------------------------
;	H \
;--------------------------------------------------------------------------------

H_COLUMN:						; 𒼐ڕ\Ȃ炱Gg[

	if LED_TYPE == 1
		BCF		C1_PORT
	else
		BSF		C1_PORT
	endif

	MOVF	PATTERN_H,W			; ʌp^[ǂݏo
	CALL	DISP_SEGMENT		; ZOgJn
	CALL	ALL_LED_OFF			; S

;--------------------------------------------------------------------------------
;	M \
;--------------------------------------------------------------------------------

M_COLUMN:

	if LED_TYPE == 1
		BCF		C2_PORT
	else
		BSF		C2_PORT
	endif

	MOVF	PATTERN_M,W			; ʌp^[ǂݏo
	CALL	DISP_SEGMENT		; ZOgJn
	CALL	ALL_LED_OFF			; S

;--------------------------------------------------------------------------------
;	L \
;--------------------------------------------------------------------------------

L_COLUMN:

	if LED_TYPE == 1
		BCF		C3_PORT
	else
		BSF		C3_PORT
	endif

	MOVF	PATTERN_L,W			; ʌp^[ǂݏo
	CALL	DISP_SEGMENT		; ZOgJn
	CALL	ALL_LED_OFF			; S

	RETURN

;--------------------------------------------------------------------------------
;	ZOgi̓X^eBbN_jA 8ms 
;	IN:		W = rbgp^[
;
;	ėp߂邽߃|[gˑŋLqĂ
;--------------------------------------------------------------------------------

DISP_SEGMENT:

	MOVWF	SEGMENT				; rbgp^[ۑ

SEG_A:

	BTFSC	SEGMENT,0			; a ZOgrbg 0 Ȃ玟̖߂XLbv

	if LED_TYPE == 1
		BSF		A_SEG			; a ZOg_
	else
		BCF		A_SEG			; a ZOg_
	endif

SEG_B:

	BTFSC	SEGMENT,1			; b ZOgrbg 0 Ȃ玟̖߂XLbv

	if LED_TYPE == 1
		BSF		B_SEG			; b ZOg_
	else
		BCF		B_SEG			; b ZOg_
	endif

SEG_C:

	BTFSC	SEGMENT,2			; c ZOgrbg 0 Ȃ玟̖߂XLbv
	if LED_TYPE == 1
		BSF		C_SEG			; c ZOg_
	else
		BCF		C_SEG			; c ZOg_
	endif

SEG_D:

	BTFSC	SEGMENT,3			; d ZOgrbg 0 Ȃ玟̖߂XLbv
	if LED_TYPE == 1
		BSF		D_SEG			; d ZOg_
	else
		BCF		D_SEG			; d ZOg_
	endif

SEG_E:

	BTFSC	SEGMENT,4			; e ZOgrbg 0 Ȃ玟̖߂XLbv
	if LED_TYPE == 1
		BSF		E_SEG			; e ZOg_
	else
		BCF		E_SEG			; e ZOg_
	endif

SEG_F:

	BTFSC	SEGMENT,5			; f ZOgrbg 0 Ȃ玟̖߂XLbv
	if LED_TYPE == 1
		BSF		F_SEG			; f ZOg_
	else
		BCF		F_SEG			; f ZOg_
	endif

SEG_G:

	BTFSC	SEGMENT,6			; g ZOgrbg 0 Ȃ玟̖߂XLbv
	if LED_TYPE == 1
		BSF		G_SEG			; g ZOg_
	else
		BCF		G_SEG			; g ZOg_
	endif

SEG_DP:

	BTFSC	SEGMENT,7			; dp ZOgrbg 0 Ȃ玟̖߂XLbv
	if LED_TYPE == 1
		BSF		DP_SEG			; dp ZOg_
	else
		BCF		DP_SEG			; dp ZOg_
	endif

	CALL	WAIT_2ms_4MHz
	CALL	WAIT_2ms_4MHz
	CALL	WAIT_2ms_4MHz
	CALL	WAIT_2ms_4MHz		; 莞ԘA_
	CALL	ALL_LED_OFF			; LED 
	CALL	WAIT_10us_4MHz

	RETURN

;--------------------------------------------------------------------------------
;	LED SAJ\[hR LED Ȃ̂ŃZOg L = OFFA H = OFF
;	Xe[^X LED _ŏ
;--------------------------------------------------------------------------------

ALL_LED_OFF:

	if LED_TYPE == 1				; J\[hR LED ̏ꍇ

		CLRF	PORTC				; LED SZOg

		BSF		C1_PORT				; 1 OFF
		NOP
		BSF		C2_PORT				; 2 OFF
		NOP
		BSF		C3_PORT				; 3 OFF

	else							; Am[hR LED ̏ꍇ

		MOVLW	B'11111111'			; LED SZOg
		MOVWF	PORTC

		BCF		C1_PORT				; 1 OFF
		NOP
		BCF		C2_PORT				; 2 OFF
		NOP
		BCF		C3_PORT				; 3 OFF

	endif

	RETURN

;--------------------------------------------------------------------------------
;	c莞ԃOt\
;--------------------------------------------------------------------------------

GRAPH_DISPLAY:

;
;	ݒ莞Ԃ 10lŊāAc̖ڐ萔߂
;

	CLRF	A1
	MOVF	SEC_H_TMP,W					; ݂̎cb
	MOVWF	A2
	MOVF	SEC_L_TMP,W
	MOVWF	A3

	CLRF	B1
	MOVF	G_FACTOR_H,W			; l
	MOVWF	B2
	MOVF	G_FACTOR_L,W
	MOVWF	B3

	CALL	DIV24					; in Math24-v2.lib,  8 bit m A3 (0-10)

	MOVLW	D'10'
	SUBWF	A3,W					; A3 - 10 (W) -> W
	BTFSS	STATUS,C				; if A3 >= 10, C=1
	GOTO	G_DISP2					; in case A3 < 10 (Normal)

	MOVLW	D'9'
	MOVWF	A3						; 10 ȏȂ 9 ɕ␳

;
;	_ŕ\prbgf[^ EEPROM AhX߂
;

G_DISP2:

	CLRF	B3						; EEPROM f[^AhX擪

	MOVF	A3,W
	BTFSC	STATUS,Z
	GOTO	GET_PATTERN				; A3 = 0 Ȃ B3 ̂܂

CALC_ADDRESS:

	MOVLW	D'6'					; A3 ̉񐔂 6 𑫂
	ADDWF	B3,F					; B3 = EEPROM AhX
	DECFSZ	A3,F
	GOTO	CALC_ADDRESS

;
;	ǂ̃p^[\邩tOŌ
;

GET_PATTERN:

	BTFSC	FLASH_FLAG
	GOTO	GET_PATTERN2			; _p^[

;
;	\p^[ɃAhXC
;

	INCF	B3,F
	INCF	B3,F
	INCF	B3,F
;
;	EEPROM rbgf[^擾
;

GET_PATTERN2:

	MOVF	B3,W					; EEPROM AhXw
	CALL	READ_EEPROM				; l W ɓĖ߂Ă
	MOVWF	PATTERN_H

	INCF	B3,F
	MOVF	B3,W
	CALL	READ_EEPROM
	MOVWF	PATTERN_M

	INCF	B3,F
	MOVF	B3,W
	CALL	READ_EEPROM
	MOVWF	PATTERN_L

	RETURN

;--------------------------------------------------------------------------------
;	^C}[Ԑݒ
;	̃[h͑S DP _
;--------------------------------------------------------------------------------

SET_TIMER:

	BCF		T1CON, TMR1ON	; Bank 0, TMR1 ~
;
;							; ^C}[[hڍsbZ[W\
;

	MOVLW	S_PATTERN		; S
	MOVWF	PATTERN_H
	MOVLW	e_PATTERN		; e
	MOVWF	PATTERN_M
	MOVLW	t_PATTERN		; t
	MOVWF	PATTERN_L
	CALL	DISP_CHAR		; \

;
;							; 
;

	CLRF	MIN_H			;  8bit NA

	MOVLW	D'60'			; W = EEPROM AhX擪
	CALL	READ_EEPROM		; W = ߂l
	MOVWF	MINUTE			; ǂݏolۑ

	BSF		SETTING_MODE	; Ԑݒ胂[htO𗧂Ă

	MOVLW	KEY_SCAN1		; XLԒZ
	MOVWF	KEY_SCAN_C		; XLԒlݒ

	CALL	INIT_KEY_CNT	; L[̓`FbNpJE^ƃtONA

;
;							; L[ɂ鎞ԐݒJn
;

SET_TIMER_LOOP:

	CLRF	prm1b			; ʂ̓NA
	MOVF	MINUTE,W
	MOVWF	prm1a			; ʃZbg

	CALL	EXEC_BCD_CONV	;  -> BCD ϊ
	CALL	EXEC_DISPLAY	; LED _Ci~bN\, 24ms

	CALL	SCAN_SW			; L[XL

SCAN1:

	BTFSS	UP_SW_FLAG		; UP XCb`ꂽ
	GOTO	SCAN2			; ĂȂ̂Ŏ̃L[XL͂

	BCF		UP_SW_FLAG		; tONA

	INCFSZ	MINUTE,F
	GOTO	SET_TIMER_LOOP	; 0 ȊOȂ\ɔf

	INCF	MINUTE,F		; 0 ɂȂ狭I 1 ɐݒ
	GOTO	SET_TIMER_LOOP	; \

SCAN2:

	BTFSS	DW_SW_FLAG		; DW XCb`ꂽ
	GOTO	SCAN3			; ĂȂ̂Ŏ̃L[XL͂

	BCF		DW_SW_FLAG		; tONA

	DECFSZ	MINUTE,F
	GOTO	SET_TIMER_LOOP	; 0 ȊOȂ\ɔf

	MOVLW	D'255'			; 0 Ȃ 255 ɋݒ
	MOVWF	MINUTE

	GOTO	SET_TIMER_LOOP	; \

SCAN3:

	BTFSS	ST_SW_FLAG		; ST XCb`ꂽ
	GOTO	SET_TIMER_LOOP	; ĂȂȂ烋[vp

;
;	^C}[X^[g
;

	MOVF	MINUTE,W
	MOVWF	EEPROM_DATA		; ރf[^
	MOVLW	D'60'			; EEPROM AhX
	CALL	SAVE_EEPROM		; ݒ莞Ԃ EEPROM ɕۑ

;
;	bvZ
;

	CLRF	A1
	CLRF	A2
	MOVF	MINUTE,W		; i 1 ` 255 j
	MOVWF	A3

	CLRF	B1
	CLRF	B2
	MOVLW	D'60'			; x 60 = b
	MOVWF	B3

	CALL	MUL24			; in Math24-v2.libA 16bit ȓm

	MOVF	B2,W
	MOVWF	SEC_H			; b H XgA
	MOVWF	A2

	MOVF	B3,W
	MOVWF	SEC_L			; b L XgA
	MOVWF	A3

;
;	Ot\ 1ڐԂ̕bvZ
;

	CLRF	A1

	CLRF	B1
	CLRF	B2
	MOVLW	D'10'			; ڐ萔 10
	MOVWF	B3

	CALL	DIV24			; in Math24v-v2.libA 16bit ȓm

	MOVF	A2,W
	MOVWF	G_FACTOR_H		; 1ڐԂ̕bۑ
	MOVF	A3,W
	MOVWF	G_FACTOR_L

;
;	̑̏ݒ
;

	BCF		SETTING_MODE	; Ԑݒ胂[htONA
	NOP
	BSF		FLASH_FLAG		; LED _ŗptOZbgĕ\

	MOVLW	KEY_SCAN2		; fL[̂߂ɃXLԒ߂ɍĐݒ
	MOVWF	KEY_SCAN_C		; XLԒlݒ

	CALL	INIT_KEY_CNT	; L[͊֘AϐƃtOď

	CALL	RESET_SEC_CNTR	; TMR1 ݊֘Aϐ

	BSF		T1CON, TMR1ON	; Bank 0, TMR1 X^[g

;
;	X^[g\
;

	MOVLW	g_PATTERN		; g
	MOVWF	PATTERN_H
	MOVLW	o_PATTERN		; o
	MOVWF	PATTERN_M
	MOVLW	ex_PATTERN		; !
	MOVWF	PATTERN_L
	CALL	DISP_CHAR		; \

	RETURN

;--------------------------------------------------------------------------------
;	XCb`XL
;	w񐔘AăL[ĂtO𗧂ĂiΉj
;	RETURN:		UP_SW_FLAG, DW_SW_FLAG, ST_SW_FLAG (1 = ꂽ)
;--------------------------------------------------------------------------------

SCAN_SW:

CHK_UP_SW:

	BTFSS	UP_SW_PORT			; UP XCb`Ă邩
	GOTO	PUSH_UP_SW			; L = ꂽ

	MOVF	KEY_SCAN_C,W		; ĂȂ̂
	MOVWF	UP_SW				; JE^
	BCF		UP_SW_FLAG			; tONA
	GOTO	CHK_DW_SW			; ̃L[͂

PUSH_UP_SW:

	DECFSZ	UP_SW,F
	GOTO	CHK_DW_SW			; 񐔖Ȃ玟̃L[͏

	BSF		UP_SW_FLAG			; tO𗧂Ă
	MOVF	KEY_SCAN_C,W
	MOVWF	UP_SW				; JE^

CHK_DW_SW:

	BTFSS	DW_SW_PORT			; DW XCb`Ă邩
	GOTO	PUSH_DW_SW			; L = ꂽ

	MOVF	KEY_SCAN_C,W		; ĂȂ̂
	MOVWF	DW_SW				; JE^
	BCF		DW_SW_FLAG			; tONA
	GOTO	CHK_ST_SW			; ̃L[͂

PUSH_DW_SW:

	DECFSZ	DW_SW,F
	GOTO	CHK_ST_SW			; 񐔖Ȃ玟̃L[͏

	BSF		DW_SW_FLAG			; tO𗧂Ă
	MOVF	KEY_SCAN_C,W
	MOVWF	DW_SW				; JE^

CHK_ST_SW:

	BTFSS	ST_SW_PORT			; ST XCb`Ă邩
	GOTO	PUSH_ST_SW			; L = ꂽ

	MOVF	KEY_SCAN_C,W		; ĂȂ̂
	MOVWF	ST_SW				; JE^
	BCF		ST_SW_FLAG			; tONA
	RETURN						; ߂

PUSH_ST_SW:

	DECFSZ	ST_SW,F
	RETURN						; 񐔖Ȃ߂

	BSF		ST_SW_FLAG			; tO𗧂Ă
	MOVF	KEY_SCAN_C,W
	MOVWF	ST_SW				; JE^

	RETURN

;--------------------------------------------------------------------------------
; L[̓`FbNpJE^ƃtÕNA
;--------------------------------------------------------------------------------

INIT_KEY_CNT:

	MOVF	KEY_SCAN_C,W	; lǂݏo
	MOVWF	UP_SW
	MOVWF	DW_SW
	MOVWF	ST_SW

	CLRF	KEY_FLAG		; L[̓tO

	RETURN

;--------------------------------------------------------------------------------
;	ԃJE^̏
;--------------------------------------------------------------------------------

RESET_SEC_CNTR:

	MOVLW	D'2'				; 500ms ̊荞ݏ 1bɂȂ邩
	MOVWF	SEC_COUNTER

	RETURN

;--------------------------------------------------------------------------------
;	f[^ EEPROM ǂݏo
;	IN		: W = EEPROM AhX
;	RETURN	: W = ǂݏol
;--------------------------------------------------------------------------------

READ_EEPROM:

	BANK2

	MOVWF		EEADR			; ǂݏo EEPROM AhXw

	BANK3

	BCF			EECON1,EEPGD	; Bank 3, Point to data memory
	BSF			EECON1,RD		; Bank 3, EE READ

	BANK2

	MOVF		EEDATA,W		; Bank2, W = EEDATAi߂lj

	BANK0

	RETURN

;--------------------------------------------------------------------------------
;	EEPROM փf[^
;	IN		: W = EEPROM AhX
;	IN		: EEPROM_DATA = ޒl
;--------------------------------------------------------------------------------

SAVE_EEPROM:

	BANK3

	BTFSC		EECON1,WR		; Bank 3, ÔߊɏݏԂłȂ`FbN
	GOTO		$-1				; ݒȂ`FbNp

	BANK2

	MOVWF		EEADR			; Bank 2,  EEPROM AhXw
	MOVF		EEPROM_DATA,W	; ޒlAEEPROM_DATA ͑SoNʗ̈
	MOVWF		EEDATA			; Bank 2

	BANK3

	BCF			EECON1,EEPGD	; Bank 3, Point to DATA memory
	BSF			EECON1,WREN		; Bank 3, Enable write

	MOVLW		H'55'
	MOVWF		EECON2			; Bank 3, Write 55h
	MOVLW		H'AA'
	MOVWF		EECON2			; Bank 3, Write AAh
	BSF			EECON1, WR		; WR bit Zbgď݊Jn

	BCF			EECON1, WREN	; Bank 3, ݒ~ԂցBݎ̂͏IĂȂB
								; ݏIoKvȂ
								; WR rbg = 0  EEIF rbg = 1 Ōo

	BTFSC		EECON1,WR		; Bank 3, ݏI܂ő҂
	GOTO		$-1

	BANK0

	RETURN

;--------------------------------------------------------------------------------
;	4.1KHz duty 50%  0.1bԈduU[炷
;--------------------------------------------------------------------------------

BEEP:

	MOVLW	D'2'				; 61.25ms x 2 = 122.5ms
	MOVWF	BEEP_CNT_H

BEEP2:

	MOVLW	D'255'				; 240us x 255 = 61.25ms
	MOVWF	BEEP_CNT_L

BEEP3:

	CALL	EXEC_BEEP

	DECFSZ	BEEP_CNT_L,F
	GOTO	BEEP3

	DECFSZ	BEEP_CNT_H,F
	GOTO	BEEP2

	RETURN
;
; duU[ɃpX𑗂B 4.1KHz duty 50% = ON 120us, OFF 120us
;

EXEC_BEEP:

	BSF		BZ_PORT				; ON
	CALL	WAIT_100us_4MHz
	CALL	WAIT_20us_4MHz		; v 120us

	BCF		BZ_PORT				; OFF
	CALL	WAIT_100us_4MHz
	CALL	WAIT_20us_4MHz		; v 120us

	RETURN

;--------------------------------------------------------------------------------
;	w蕶\
;	IN:		PATTERN_H,M,L
;--------------------------------------------------------------------------------

DISP_CHAR:

	MOVLW	D'42'			; 24ms x 42 =  1b
	MOVWF	MES_CNT

DISP_CHR2:

	CALL	H_COLUMN		; w蕶\, 24ms cycle

	DECFSZ	MES_CNT,F
	GOTO	DISP_CHR2		; 莞ԕ\

	CALL	WAIT_200ms_4MHz	; \NA˂

	RETURN

;--------------------------------------------------------------------------------
;	Cuǂݍ
;--------------------------------------------------------------------------------

	INCLUDE		Wait.lib		; ԑ҂[vCu
	INCLUDE		Math24-v3.lib	; 24bit ZCu

;--------------------------------------------------------------------------------
;	EEPROM f[^`
;--------------------------------------------------------------------------------

	ORG		H'2100'		; EEPROM JnԒnw

;		OtBbN\_Ńrbgp^[AEEPROM AhX &H00 `
;		_ H     _ M     _ L      H      M      L
	DE	B'00000001', B'00000000', B'00000000', B'00000000', B'00000000', B'00000000'	; c 1ڐ
	DE	B'00100001', B'00000000', B'00000000', B'00000001', B'00000000', B'00000000'	; c 2ڐ
	DE	B'00110001', B'00000000', B'00000000', B'00100001', B'00000000', B'00000000'	; c 3ڐ
	DE	B'00111001', B'00000000', B'00000000', B'00110001', B'00000000', B'00000000'	; c 4ڐ
	DE	B'00111001', B'00001000', B'00000000', B'00111001', B'00000000', B'00000000'	; c 5ڐ
	DE	B'00111001', B'00001000', B'00001000', B'00111001', B'00001000', B'00000000'	; c 6ڐ
	DE	B'00111001', B'00001000', B'00001100', B'00111001', B'00001000', B'00001000'	; c 7ڐ
	DE	B'00111001', B'00001000', B'00001110', B'00111001', B'00001000', B'00001100'	; c 8ڐ
	DE	B'00111001', B'00001000', B'00001111', B'00111001', B'00001000', B'00001110'	; c 9ڐ
	DE	B'00111001', B'00001001', B'00001111', B'00111001', B'00001000', B'00001111'	; c10ڐ

	DE	D'30'	; EEPROM AhX D'60', ݒ莞ԕۑ̈Fl 30
				; ȍ~͎gpԂIɕۑ
	DE	D'0'	; EEPROM AhX D'61', \[hli0=Wl\A1=v^\j
				; ȍ~͎gp\[hlIɕۑ

;--------------------------------------------------------------------------------
;	vOI
;--------------------------------------------------------------------------------

	END
