;------------------------------------------------------------------------
;	PIC12F683 PWM FAN controler
;
;	Programmed by GRANADA since 2013/07/04-2013/08/18
;
;	v1.0	2013/07/04 - 2013/08/18		PWM LED controler QlɊJJn
;	v1.1	2013/08/20					Hǉɂ MAX DUTY  200 ɕύX
;	v1.2	2015/07/30					Xɉ]グē˓d
;	v1.3	2015/07/31					v1.2 C̃oOCi萔CALED uN\p~j
;										ᑬ̉]N̂ݓǂݎ悤dlύX
;
;	LF http://www.asahi-net.or.jp/~SE1M-NITU/html/PWM_Fan_Controler.htm
;
;	{\[X̓^u 4ɐݒ肷Yɐ`܂
;
;------------------------------------------------------------------------

	LIST		P=12F683
	INCLUDE		P12F683.INC

	ERRORLEVEL	-205
	ERRORLEVEL	-302

CB  = _CP_OFF
CB &= _CPD_OFF
CB &= _WDT_OFF
;CB &= _BOD_NSLEEP
CB &= _BOD_OFF
CB &= _PWRTE_OFF
CB &= _INTOSCIO
CB &= _MCLRE_OFF
;CB &= _FCMEN_ON

	__CONFIG	CB
	__IDLOCS	H'0100'

;---------------------------------------------------------------------------
;	ėp}N`
;---------------------------------------------------------------------------

MOVLF	MACRO	L,FILE
		MOVLW	L
		MOVWF	FILE
		ENDM

MOVFF	MACRO	SRC,DST
		MOVF	SRC,W
		MOVWF	DST
		ENDM

;---------------------------------------------------------------------------
; ϐ̈`
;---------------------------------------------------------------------------

CBLOCK	H'20'

	DUTY				; PWM f[eB[l

	AD_VALUE			; A/D ϊlilj

	START_CNT			; N PWM 100% ԃJEgp
	LOW_BAT_CNT			; dቺopJE^
	RESUME_CNT			; dApJE^

	DUTY_LOW			; ᑬ DUTY ݒliNɈxݒ肳j

	COUNTER1			; ԊǗp
	COUNTER2
	COUNTER3

ENDC


CBLOCK	H'70'			; SoNʃGA擪AhX

	W_WORK				; 荞ݎޔp
	ST_WORK				; 荞ݎޔp
	FSR_WORK			; 荞ݎޔp

;	EEPROM_ADDRESS		; EEPROM AhXwpASoNʃGAmەK{
;	EEPROM_DATA			; EEPROM ݒlASoNʃGAmەK{

	USER_FLAG			; e탆[U[tO

	WORK				; ėp[N

ENDC

;---------------------------------------------------------------------------
;	|[g`
;---------------------------------------------------------------------------

#DEFINE		BAT_PORT			GPIO,0			; AN0, dd̓|[g`
#DEFINE		SET_PORT			GPIO,1			; AN1, ]ݒ|[g`
#DEFINE		PWM_PORT			GPIO,2			; PWM o̓|[g`
#DEFINE		SHUTDOWN_SET_PORT	GPIO,3			; Shutdown ݒ|[g`, L = SHUTDOWN 
#DEFINE		RED_LED_PORT		GPIO,4			;  LED |[g`
#DEFINE		GREEN_LED_PORT		GPIO,5			;  LED |[g`

;---------------------------------------------------------------------------
;	萔`
;---------------------------------------------------------------------------

#DEFINE		CYCLE			D'249'			; PWM iPR2WX^lj
											; NbN 1MHzAPrescale 1:4 Ȃ PR2 = 249  250Hz PWM
#DEFINE		DUTY_MAX		CYCLE			; DUTY ̃WX^őli=CYCLEj
#DEFINE		DUTY_NORMAL		D'245'			; ʏ^] DUTY l
#DEFINE		DUTY_STEP		D'20'			; X^[g̒ᑬ] DUTY l
#DEFINE		DUTY_MIN		D'5'			; DUTY ̃WX^ŏli=CYCLEj
#DEFINE		STEP_C			( DUTY_NORMAL - DUTY_MIN ) / DUTY_STEP	; SETP l MAX t߂ɒB邩
											; drd 1/5 ɕēǂݍނƂ
#DEFINE		BAT_HIGH		D'122'			; 12.0V -> 2.40V, 5V -> 255 Ȃ 2.40V -> AD l 122
#DEFINE		BAT_MID			D'112'			; 11.0V -> 2.20V -> AD l 112
#DEFINE		BAT_LOW			D'102'			; 10.0V -> 2.00V -> AD l 102
#DEFINE		BAT_RESUME		D'112'			; 11.0V -> 2.20V -> AD l 112	Amd

#DEFINE		LOW_BAT_C		D'10'			; dm肷܂ł̉񐔁A  800ms x 10 = 8b
#DEFINE		RESUME_C		D'10'			; dAm肷܂ł̉񐔁A1.08s x 10 = 10.8b
#DEFINE		R_FLAG			USER_FLAG,0		;  LED _tO
#DEFINE		G_FLAG			USER_FLAG,1		;  LED _tO
#DEFINE		STOP_FLAG		USER_FLAG,2		; ~d̃tO
#DEFINE		SHUTDOWN_FLAG	USER_FLAG,3		; 1 = Vbg_Es

;---------------------------------------------------------------------------
;	dxN^
;---------------------------------------------------------------------------

	ORG		0x00

	GOTO	INITIALIZE		; 

;---------------------------------------------------------------------------
; ݃xN^
;---------------------------------------------------------------------------

	ORG		H'4'

;---------------------------------------------------------------------------
;	ݏ
;---------------------------------------------------------------------------

	MOVWF	W_WORK			; WWX^Ҕ
	SWAPF	STATUS,W		; STATUSo
	MOVWF	ST_WORK			; STATUSҔ 
	MOVF	FSR,W
	MOVWF	FSR_WORK		; FSR ޔ

	BANKSEL GPIO			; oNύXiK{j

CHK_INT:

	BTFSC	INTCON,T0IF		; Bank 0/1, TMR0  ?
	GOTO	TMR0_INT		; Yes

	BTFSS	PIR1,TMR2IF		; Bank 0, TMR2 荞 ?
	GOTO	POP_REGISTER	; No

;---------------------------------------------------------------------------
;	TMR2 = PE2 荞ݏ ( 4ms  )
;---------------------------------------------------------------------------

TMR2_INT:

	BCF		PIR1,TMR2IF			; 荞݌NA

	GOTO	CHK_INT				; ̊荞݌ă`FbN

;---------------------------------------------------------------------------
;	TMR0 荞ݏ ( 65.5ms )
;---------------------------------------------------------------------------

TMR0_INT:

	BCF		INTCON,T0IF		; ݌NA

	GOTO	CHK_INT			; ēx̊荞݌`FbN

;---------------------------------------------------------------------------
;	ݏI
;---------------------------------------------------------------------------

POP_REGISTER:

	MOVF	FSR_WORK,W
	MOVWF	FSR				; FSR A
	SWAPF	ST_WORK,W		; STATUS߂
	MOVWF	STATUS
	SWAPF	W_WORK,F		; WWX^߂
	SWAPF	W_WORK,W

	RETFIE					; 荞ݏI

;---------------------------------------------------------------------------
;	vOX^[g|Cg
;	WX^ނ̏iPWM ݒ̓^C}[X^[gݒj
;---------------------------------------------------------------------------

INITIALIZE:

	BANKSEL	GPIO			; Bank 0

	CLRF	GPIO			; Bank 0AƂ肠S|[gNA

	MOVLW	B'00000111'
	MOVWF	CMCON0 			; Bank 0, CMCON = CM0/CM1/CM2 ON (Rp[^gpȂ)

	BANKSEL	TRISIO			; Bank 1

	MOVLW	B'00001011'		; 0 = OUT, 1 = IN, GPIO 0,1,3 = IN, GPIO 2,4,5 = OUT
	MOVWF	TRISIO			; Bank 1, e|[go͐ݒ

	MOVLW	B'01100011'		; Frc, AN0,AN1 = AiO
	MOVWF	ANSEL			; Bank 1

	MOVLW	B'10000101'		; Bank 1, TMR0 = NbNATMR0 PS 64 = NbN 1MHz Ȃ 65.5ms  TMR0 荞
	MOVWF	OPTION_REG		; Bank 1, GPIO weak pull up ֎~

	MOVLW	CYCLE			; PWM Cycle l
	MOVWF	PR2				; Bank 1, PWM Zbg

	MOVLW	B'01000000'		; NbN 1MHz
	MOVWF	OSCCON			; Bank 1, gݒ

	CLRF	OSCTUNE			; Bank 1, NbN

	BANKSEL	ADCON0			; Bank 0

	MOVLW	B'00000001'		; AN0 (3,4bitŎw), l (8bit), AD ON, Vref = VDD
	MOVWF	ADCON0			; Bank 0

;---------------------------------------------------------------------------
;	ϐ̏
;---------------------------------------------------------------------------

INIT_PARAM:

	CLRF	USER_FLAG

	MOVLF	DUTY_MIN, DUTY		; DUTY ̃WX^ŏli=CYCLEjZbg

	CALL	TIMER_START			; PWM WX^ݒA^C}[X^[g

	CALL	CLR_LOW_BAT_CNT		; doJE^

	CALL	LED_OFF				; LED 

;---------------------------------------------------------------------------
;	ŏ DUTY  ő DUTY  ݒ DUTY
;	˓d΍Aђᑬݒłmɉ]Jn邽
;---------------------------------------------------------------------------

	MOVLF	STEP_C,START_CNT	; DUTY [v񐔂Zbg

INC_DUTY:

	MOVLW	DUTY_STEP			; l
	ADDWF	DUTY				; DUTY 

	CALL	WAIT_20ms_1MHz		; DUTY ێĉ]
	CALL	WAIT_20ms_1MHz		; DUTY ێĉ]

	DECFSZ	START_CNT,F			; ő DUTY t߂܂ňU㏸
	GOTO	INC_DUTY

	CALL	READ_AD1			; ]ݒǂݍ
	MOVFF	AD_VALUE, DUTY_LOW	; ᑬ DUTY ۑ

;---------------------------------------------------------------------------
;	C[v
;---------------------------------------------------------------------------

MAIN_LOOP:

	CALL	READ_AD1			; ]ݒǂݍ
	CALL	SET_FAN				; t@]ɔf

	CALL	READ_AD0			; dǂݍ
	CALL	LED_DISP			; 2F LED \

;
;	Vbg_E Enable Ԃ ?
;

	BTFSC	SHUTDOWN_SET_PORT	; L = 
	GOTO	MAIN_END			; H = Vbg_E삵Ȃ

;
;	Vbg_Eo ?
;

	BTFSC	SHUTDOWN_FLAG
	GOTO	SHUTDOWN			; Yes

;
;	I
;

MAIN_END:

	CALL	WAIT_800ms_1MHz		; 莞ԉȂ

	GOTO	MAIN_LOOP

;---------------------------------------------------------------------------
;	Vbg_E
;---------------------------------------------------------------------------

SHUTDOWN:

	CALL	TIMER_STOP			; ^C}[~

	CLRF	GPIO				; S|[g LALED 

;---------------------------------------------------------------------------
;	dŒ~Ad񕜂܂œdĎȂ҂
;---------------------------------------------------------------------------

	CALL	CLR_RESUME_CNT		; AĎJE^

WAIT_RESUME:

	CALL	READ_AD0			; dǂݍ

	MOVLW	BAT_RESUME			; AdƔr
	SUBWF	AD_VALUE,W
	BTFSS	STATUS,C			; if AD_VALUE >= Ad, C=1, skip next line
	GOTO	CONT_LOW_BAT		; dp

	DECFSZ	RESUME_CNT,F
	GOTO	FLASH_RED_LED		; 񐔂܂ł͒dp̏Ȃ

;
;	dAmAAƊJn
;

	GOTO	INIT_PARAM			; X^[g

;
;	dȂ̂ŃJE^Zbg
;

CONT_LOW_BAT:

	CALL	CLR_RESUME_CNT		; AĎJE^

;
;	Vbg_E  LED ̓_Łiv 1.08bj
;

FLASH_RED_LED:

	BSF		RED_LED_PORT		; _
	CALL	WAIT_200ms_1MHz

	BCF		RED_LED_PORT		; 
	CALL	WAIT_80ms_1MHz

	BSF		RED_LED_PORT		; _
	CALL	WAIT_200ms_1MHz

	BCF		RED_LED_PORT		; 
	CALL	WAIT_200ms_1MHz

	CALL	WAIT_400ms_1MHz

	GOTO	WAIT_RESUME			; dĎp

;---------------------------------------------------------------------------
;
;	ȍ~ATu[`
;
;---------------------------------------------------------------------------

;---------------------------------------------------------------------------
;	d 2F LED ŕ\
;---------------------------------------------------------------------------

LED_DISP:

	BCF		R_FLAG				; ЂƂ܂tONA
	NOP
	BCF		G_FLAG

	BCF		STOP_FLAG			; ~d̃tO

;
;	d
;

	MOVLW	BAT_HIGH
	SUBWF	AD_VALUE,W			; BAT_HIGH - AD_VALUE -> W
	BTFSC	STATUS,C			; if AD_VALUE < BAT_HIGH, C=0, skip next line
	GOTO	LED_GREEN

	MOVLW	BAT_MID
	SUBWF	AD_VALUE,W
	BTFSC	STATUS,C			; if AD_VALUE < BAT_MID, C=0, skip next line
	GOTO	LED_ORANGE			; \

	MOVLW	BAT_LOW				; ԕ\m
	SUBWF	AD_VALUE,W
	BTFSS	STATUS,C			; if AD_VALUE >= LOW, C=1, skip next line
	BSF		STOP_FLAG			; ~tO𗧂Ă

;
;	FtO̐ݒ
;

LED_RED:

	BSF		R_FLAG
	GOTO	CHK_STOP

LED_ORANGE:

	BSF		R_FLAG

LED_GREEN:

	BSF		G_FLAG

;
;	d~
;

CHK_STOP:

	BTFSS	STOP_FLAG			; 1 = Œd
	GOTO	BAT_OK				; 0 = Œd̓NAAd֘A͂Ȃ

	DECFSZ	LOW_BAT_CNT,F
	GOTO	SET_LED				; 񐔂܂ł͌AJE^̓NAĂ͂Ȃ

	BSF		SHUTDOWN_FLAG		; CɃVbg_Eʒm

	GOTO	SET_LED	

;---------------------------------------------------------------------------
;	dNA
;---------------------------------------------------------------------------

BAT_OK:

	CALL	CLR_LOW_BAT_CNT		; dĎJE^

;
;	2F LED \
;

SET_LED:

	CALL	LED_OFF				; ЂƂ܂ LED 

	BTFSC	R_FLAG
	BSF		RED_LED_PORT		; ԓ_

	BTFSC	G_FLAG
	BSF		GREEN_LED_PORT		; Γ_

	RETURN

;---------------------------------------------------------------------------
;	LED S
;---------------------------------------------------------------------------

LED_OFF:

	BCF		RED_LED_PORT		; ЂƂ܂ LED 
	NOP
	BCF		GREEN_LED_PORT

	RETURN

;---------------------------------------------------------------------------
;	 LED _iv 800msj
;---------------------------------------------------------------------------

FLASH_GREEN_LED:

	BSF		GREEN_LED_PORT

	CALL	WAIT_400ms_1MHz

;	BCF		GREEN_LED_PORT

	CALL	WAIT_400ms_1MHz

	RETURN

;---------------------------------------------------------------------------
;	t@̉]ݒ
;	IN:	AD_VALUE
;---------------------------------------------------------------------------

SET_FAN:

	MOVFF	AD_VALUE,DUTY		; ̒lZbg

	MOVLW	DUTY_NORMAL
	SUBWF	AD_VALUE,W
	BTFSS	STATUS,C			; if AD_VALUE >= DUTY_NORMAL, C=1, skip next line
	GOTO	UNDER_DUTY_NORMAL

	MOVLF	DUTY_NORMAL,DUTY	; DUTY NORMAL ɕ␳

	GOTO	SET_DUTY

UNDER_DUTY_NORMAL:			; A^CɕωȂȉ𕜊A
							; MOVFF sRgAEg
;	MOVLW	DUTY_MIN
;	SUBWF	AD_VALUE,W
;	BTFSC	STATUS,C		; if AD_VALUE < DUTY_MIN, C=0, skip next line
;	GOTO	SET_DUTY
;
;	MOVLF	DUTY_MIN, DUTY	; DUTY MIN ɕ␳

	MOVFF	DUTY_LOW, DUTY	; LOW ɕ␳

;---------------------------------------------------------------------------
;	PWM DUTY lݒ
;	IN:		DUTY	= TCNl
;---------------------------------------------------------------------------

SET_DUTY:

	MOVF	DUTY,W			; TCNlǂݏo
	MOVWF	CCPR1L			; Bank 0, DUTY f

	RETURN

;--------------------------------------------------------------------------------
;	AD0 ǂݍ
;--------------------------------------------------------------------------------

READ_AD0:

	MOVLW	B'00000001'		; AN0 (3,4bitŎw), l (8bit), AD ON, Vref = VDD
	MOVWF	ADCON0			; Bank 0

	GOTO	EXEC_AD_READ

;--------------------------------------------------------------------------------
;	AD1 ǂݍ
;--------------------------------------------------------------------------------

READ_AD1:

	MOVLW	B'00000101'		; AN1 (3,4bitŎw), l (8bit), AD ON, Vref = VDD
	MOVWF	ADCON0			; Bank 0

;--------------------------------------------------------------------------------
;	AD ϊ
;	AD `l͎OɎw肵Ă
;--------------------------------------------------------------------------------

EXEC_AD_READ:

	CALL	WAIT_800us_1MHz	; v`[W҂

	BSF		ADCON0,GO		; Bank 0, AD ϊJn

	BTFSC	ADCON0,GO		; ϊI ?
	GOTO	$-1				; No

	MOVFF	ADRESH,AD_VALUE	; Bank 0 -> Bank 0

	RETURN

;---------------------------------------------------------------------------
;	^C} START
;---------------------------------------------------------------------------

TIMER_START:

	BANKSEL	GPIO			; Bank 0

	MOVLW	B'00001100'		; Set PWM mode active high
	MOVWF	CCP1CON			; Bank 0

	BSF		INTCON,GIE		; Bank 0, O[o荞݋
	NOP
	BSF		INTCON,PEIE		; Bank 0, ӊ荞݋
	NOP
	BSF		INTCON,T0IE		; Bank 0, TIMER0 START

	MOVLW	B'00000101'		; TIMER2 ON, Prescale = 1:4, Postscale = 1:1
	MOVWF	T2CON			; Bank 0, TIMER2 START

	BANKSEL	PIE1			; Bank 1

	BSF		PIE1,TMR2IE		; Bank 1, TMR2 荞݋APWM X^[g

	BANKSEL	GPIO			; Bank 0

	RETURN

;---------------------------------------------------------------------------
; ^C} STOP
;---------------------------------------------------------------------------

TIMER_STOP:

	BANKSEL	PIE1			; Bank 1

	BCF		PIE1,TMR2IE		; Bank 1, TMR2 荞݋֎~

	BANKSEL	T2CON			; Bank 0

	BCF		T2CON,TMR2ON	; Bank 0, TIMER2 STOP

	BCF		INTCON,T0IE		; Bank 0, TIMER0 STOP

	CLRF	CCP1CON			; Bank 0, PWM [h~

	CALL	WAIT_20ms_1MHz	; PWM S~܂ŏ҂

	BCF		PWM_PORT		; Bank 0
	BTFSC	PWM_PORT		; PWM o = L mF
	GOTO	$-2

	RETURN

;---------------------------------------------------------------------------
;	dJE^NA
;---------------------------------------------------------------------------

CLR_LOW_BAT_CNT:

	MOVLF	LOW_BAT_C, LOW_BAT_CNT

	RETURN

;---------------------------------------------------------------------------
;	dAJE^NA
;---------------------------------------------------------------------------

CLR_RESUME_CNT:

	MOVLF	RESUME_C, RESUME_CNT

	RETURN

;---------------------------------------------------------------------------
;	Cuǉ
;---------------------------------------------------------------------------

	INCLUDE		Wait.asm_lib

;---------------------------------------------------------------------------
;	EEPROM ̈
;---------------------------------------------------------------------------

;	ORG		H'2100'				; EEPROM JnԒnw
;
;	DE		D'0'				; &H00, 

	END

