;------------------------------------------------------------------------
;
;	Head Up Display dgv for PIC16F886/887
;
;	Programmed by GRANADA since 2011/01/24 -
;	Ver 0.1		2011/01/26 ` 2011/01/27 	12F683 JJY Decoder  16F690 ŊJJn
;	Ver 0.9		2011/01/27 ` 2011/01/30	16F886 ɕύXAfobO LCD tƂ肠
;	Ver 1.0		2011/01/31 ` 2011/02/12	1st [X
;	Ver 1.1		2011/02/21					\[XhCugWX^ACRd΍
;	Ver 1.2		2011/03/02					TMR1 RyAlC
;
;	i{\[XvO̓^u4ɐݒ肷Yɐ`܂j
;	LF http://www.asahi-net.or.jp/~SE1M-NITU/html/HUD_Wave_Clock.htm
;--------------------------------------------------------------------------------

	LIST		P=16F886
	INCLUDE		P16F886.INC
	INCLUDE		Original_Macro.lib

	ERRORLEVEL	-205
	ERRORLEVEL	-302

    __CONFIG    _CONFIG1, _DEBUG_OFF & _LVP_OFF & _FCMEN_ON & _IESO_OFF & _BOR_ON & _CPD_OFF & _CP_OFF & _MCLRE_OFF & _PWRTE_ON & _WDT_OFF & _HS_OSC
    __CONFIG    _CONFIG2, _WRT_OFF & _BOR21V

;--------------------------------------------------------------------------------
;	ϐAhX`
;--------------------------------------------------------------------------------

CBLOCK	H'20'

	TMR0_CNT			; 悻 1bvpJE^
	TMR1_CNT			; vAR_ŗpbǗJE^
	TMR1_MIN_CNT		; ǗpJE^

	PW_CNT				; v̊݉񐔃JE^
	PD_CNT				; ṽpX̗
	VALUE				; ͂ʁA0=G[, 1=0, 2=1, 3=}[J[
	R_DATA				; obt@NAȍ~Mf[^

	SYNC_ERROR			; 񓯊Ɏs
	DECODE_ERROR		; fR[h̃G[, 0 = G[
	CALIB_FAIL_MIN		; Ẑ܂܌o߂ԁij
	ERROR_PULSE			; 1ԂɎMG[pXAdgԊĎp

	HOUR_H				; fR[h
	HOUR_L				; fR[h
	MIN_H				; fR[h
	MIN_L				; fR[h

	PIC_HOUR			; vE
	PIC_MIN				; vE
	PIC_SEC				; vEb

	PIC_HOUR_TMP		; ꎞޔp
	PIC_MIN_TMP			; ꎞޔp
	PIC_SEC_TMP			; ꎞޔp

	BCD_L				; 7 ZO BCD ϊl
	BCD_H				; 7 ZO BCD ϊl

	PATTERN_C1			; \prbgp^[i}X^[p^[j
	PATTERN_C2			; \prbgp^[i}X^[p^[j
	PATTERN_C3			; \prbgp^[i}X^[p^[j
	PATTERN_C4			; \prbgp^[i}X^[p^[j

	SEGMENT				; \rbgp^[

	WORK				; ėp[N
	MK_WORK				; }[J[op[N
	SHIFT_CNT			; obt@f[^VtgpJE^
	SYNC_CNT			; t[`FbNpJE^
	PC_CNT				; peB`FbNp[N

	SOFT_PWM_CNT		; \tgEGA PWM Pxp

	COUNTER1			; ԑ҂p[N
	COUNTER2
	COUNTER3

	UP_SW				; XCb`XLp
	DW_SW				; XCb`XLp
	SEC_SW				; XCb`XLp
	KEY_FLAG			; XCb`XLp

	ACC_CNG_CNT			; ANZTdωop

	M1					; f[^
	M2
	M3
	M4
	M5
	M6
	M7
	H1					; f[^
	H2
	H3
	H4
	H5
	H6
	PA1					; peB
	PA2					; peB

	BLIGHTNESS			; 邳 A/D ϊl

	USER_FLAG			; etO
	USER_FLAG2
						; BCD ϊp
	prm1b				; ϊli16rbgBϊ͉j
	prm1a				; `

	prm3e				; 10ii[ꏊi5oCgAŊmۂ邱Ɓj
	prm3d
	prm3c
	prm3b
	prm3a
	srlc1				; JE^iTu[`Ŏgpj
	srwk1				; ꎞ]i[ꏊiTu[`Ŏgpj

	BEEP_CNT_H
	BEEP_CNT_L

ENDC

CBLOCK	H'70'			; SoNʃGA擪AhX

	W_WORK				; 荞ݎޔp
	ST_WORK				; 荞ݎޔp
	FSR_WORK			; 荞ݎޔp

	EEPROM_DATA			; EEPROM ݒlASoNʃGAmەK{

ENDC

;---------------------------------------------------------------------------
;	|[g`
;---------------------------------------------------------------------------
;

;									{

;	RE3		DIGITAL	IN		IN ̂		UP	SW

;	RA0		DIGITAL	IN					DW SW
;	RA1		DIGITAL	IN					SEC SW
;	RA2		ANALOG	IN		AN2			邳o
;	RA3		DIGITAL	IN					ACC dʓd, L = ACC ON
;	RA4		DIGIAL	OUT					gݒ
;	RA5		DIGITAL	OUT					duU[
;	RA6		DIGITAL	(IN)	OSC2		NbN
;	RA7		DIGITAL	(IN)	OSC1		NbN
;
;	RB0		DIGITAL	OUT					LED a
;	RB1		DIGITAL	OUT					LED b
;	RB2		DIGITAL	OUT					LED c
;	RB3		DIGITAL	OUT					LED d
;	RB4		DIGITAL	OUT					LED e
;	RB5		DIGITAL	OUT					LED f
;	RB6		DIGITAL	OUT					LED g
;	RB7		DIGITAL	IN		ԕω	TCO
;
;	RC0		DIGITAL	OUT					LED dp
;	RC1		DIGITAL	OUT		CCP2		PWM o
;	RC2		DIGIAL	OUT					Zς݊mF LED
;	RC3		DIGITAL	OUT					f[^MmF	DR_LED

;	RC4		DIGITAL	OUT					C1
;	RC5		DIGITAL	OUT					C2
;	RC6		DIGITAL	OUT		TX			C3
;	RC7		DIGITAL	OUT		RX			C4
;

#DEFINE		BZ_PORT			PORTA,5			; duU[|[g`
#DEFINE		DR_LED_PORT		PORTC,3			; f[^MmF LED |[g`
#DEFINE		CALIB_LED_PORT	PORTC,2			; dgZς݊mF LED |[g`
#DEFINE		FREQ_CTRL_PORT	PORTA,4			; g؂ւ|[g`
#DEFINE		TCO_PORT		PORTB,7			; TCO |[g`
#DEFINE		ACC_ST_PORT		PORTA,3			; ANZTd󋵊mF|[g`AL = ACC ON
#DEFINE		UP_SW_PORT		PORTE,3			; 킹 UP   XCb`|[g`AL = ON
#DEFINE		DW_SW_PORT		PORTA,0			; 킹 DWON XCb`|[g`AL = ON
#DEFINE		SEC_SW_PORT		PORTA,1			; b킹XCb`|[g`AL = ON

#DEFINE		C1_PORT		PORTC,4				; 7 ZO LED 1ڐ|[g`
#DEFINE		C2_PORT		PORTC,5				; 7 ZO LED 2ڐ|[g`
#DEFINE		C3_PORT		PORTC,6				; 7 ZO LED 3ڐ|[g`
#DEFINE		C4_PORT		PORTC,7				; 7 ZO LED 4ڐ|[g`

#DEFINE		A_SEG		PORTB,0				; LED  a ZOg̃|[g`
#DEFINE		B_SEG		PORTB,1				; LED  b ZOg̃|[g`
#DEFINE		C_SEG		PORTB,2				; LED  c ZOg̃|[g`
#DEFINE		D_SEG		PORTB,3				; LED  d ZOg̃|[g`
#DEFINE		E_SEG		PORTB,4				; LED  e ZOg̃|[g`
#DEFINE		F_SEG		PORTB,5				; LED  f ZOg̃|[g`
#DEFINE		G_SEG		PORTB,6				; LED  g ZOg̃|[g`
#DEFINE		DP_SEG		PORTC,0				; LED dp ZOg̃|[g`

;---------------------------------------------------------------------------
;	萔`
;---------------------------------------------------------------------------

#DEFINE		KEY_SCAN_C		D'20'			; L[ꂽƔf鎞
											;  3msi1\ԁj x 4 x 20 = 240ms ԉ
											; ƃXCb` ON 
#DEFINE		ACC_RESPONSE	D'100'			; ANZTd̏ԂωƔf鎞
											;  3msi1\ԁj x 4 x 100 = 1.2 bԂŕωƔ

#DEFINE		BUFFER_SIZE		D'61'					; Mobt@TCY
#DEFINE		BUFFER_END		H'A0' + BUFFER_SIZE -1	; Mobt@ŏIAhX

#DEFINE		DISP_MODE		USER_FLAG,0		; 1 = HUD
#DEFINE		SEG_OK_FLAG		USER_FLAG,1		; 1 = ZOg̃f[^͖Ȃ
#DEFINE		SYNC_FLAG		USER_FLAG,2		; 1 = t[
#DEFINE		WAVE_CALIB_FLAG	USER_FLAG,3		; 1 = 1łdgZł
#DEFINE		MAN_CALIB_FLAG	USER_FLAG,4		; 1 = 1ł蓮Zꂽ
#DEFINE		R_CALIB_FLAG	USER_FLAG,5		; 1 = ߏ莞ԓɍZł
#DEFINE		SAMPLING_FLAG	USER_FLAG,6		; 1 = TvOԒ
#DEFINE		DR_FLAG			USER_FLAG,7		; 1 = f[^M

;							USER_FLAG2 ̓rbg]̂ŃrbgʒuՂɕύXȂ

#DEFINE		DP_ON			USER_FLAG2,0	; 1 = R LED _
#DEFINE		FREQUENCY		USER_FLAG2,1	; 1 = 60KHzi{j
#DEFINE		ACC_FLAG		USER_FLAG2,2	; 1 = ACC ON

#DEFINE		UP_SW_FLAG		KEY_FLAG,0		; 1 = UP  SW 莞ԉꑱ
#DEFINE		DW_SW_FLAG		KEY_FLAG,1		; 1 = DW  SW 莞ԉꑱ
#DEFINE		SEC_SW_FLAG		KEY_FLAG,2		; 1 = SEC SW 莞ԉꑱ

#DEFINE		RECENT_CALIB	D'240'			; ߉ȓɍZł臒l
											; ZԂȏɂȂƒߍZ LED 

#DEFINE		CHK_Err			D'25'			; pXZ`FbN	4.1ms x  25 = 102.5ms
#DEFINE		CHK_200ms		D'65'			; }[J[`FbN		4.1ms x  65 = 266.5ms
#DEFINE		CHK_500ms		D'140'			; 1 `FbN			4.1ms x 140 = 574.0ms
#DEFINE		CHK_800ms		D'210'			; 0 `FbN			4.1ms x 210 = 861.0ms
#DEFINE		SAMP_POINT		D'220'			; TvO|Cg	4.1ms x 220 = 902.0ms

#DEFINE		PWM_CYCLE		D'250'			; PE2 WX^ݒl12.5KHzA
											; Ȃׂg 40KHz, 60KHz ƏdȂȂ悤ɒ
#DEFINE		DUTY100			D'251'			; DUTY ől
#DEFINE		DUTY0			D'1'			; DUTY ŏl
											; DUTY l傫 PIC  H o͊ԂȂ
											; \[XhCuȂ_]邱Ƃɒ

;---------------------------------------------------------------------------
;	dxN^
;---------------------------------------------------------------------------

	ORG		H'0'
	GOTO	INITIALIZE

;---------------------------------------------------------------------------
;	ݏ
;---------------------------------------------------------------------------

	INCLUDE		HUD_Wave_Clock_INT.lib

;---------------------------------------------------------------------------
;	vO
;---------------------------------------------------------------------------

INITIALIZE:

	BANK0

	CLRF	PORTA
	CLRF	PORTB
	CLRF	PORTC
	CLRF	PORTE

	BANK3

	MOVLW	B'00000100'
	MOVWF	ANSEL			; Bank 3, AN2 gp
	CLRF	ANSELH			; Bank 3

	BANK1

	MOVLW	B'11001111'		; RA0,1,2,3,6,7 ͓
	MOVWF	TRISA			; Bank 1
	MOVLW	B'10000000'
	MOVWF	TRISB			; Bank 1, RB7 ͓
	CLRF	TRISC			; Bank 1, RCS|[go͂
	CLRF	TRISE			; Bank 1

	MOVLW	B'10000000'
	MOVWF	IOCB			; Bank 1, RB7 ԕωݎgp

	CLRF	WPUB			; Bank 1, PORTB Weak pull up disable

;--------------------------------------------------------------------------------
;	10bit A/D Ro[^[ݒ
;--------------------------------------------------------------------------------

	CLRF	ADCON1			; Bank 1, l(8bit A/Dϊ), Vref+ = VDD, Vref- = VSS

	BANK0

	MOVLW	B'10001001'		; Fosc/32, AN2 gp, AD Ro[^d ON
	MOVWF	ADCON0			; Bank 0

;---------------------------------------------------------------------------
;	̑
;---------------------------------------------------------------------------

	CLRF	PORTA			; Bank 0
	CLRF	PORTB
	CLRF	PORTC

	CALL	CLR_7SEG		; LED 

	CLRF	USER_FLAG
	BSF		DISP_MODE		; HUD [hAʏ\Ȃ炱̍s폜
	CLRF	USER_FLAG2

	CLRF	HOUR_H			; fR[hf[^GANA
	CLRF	HOUR_L
	CLRF	MIN_H
	CLRF	MIN_L

	CLRF	PIC_HOUR		; v
	CLRF	PIC_MIN
	CLRF	PIC_SEC

	CLRF	CALIB_FAIL_MIN	; ZoߕNA

	CALL	INIT_KEY_CNT	; L[͊֘ANA
	CALL	RESET_ACC_CNT	; ANZTd֘ANA

;---------------------------------------------------------------------------
;	EEPROM 珉gǂݏoăZbg
;---------------------------------------------------------------------------

	CLRW					; EEMPROM 擪AhX
	CALL	READ_EEPROM		; in EEPROM.lib
	MOVWF	WORK

	MOVF	WORK,W
	BTFSS	STATUS,Z		; ߂l`FbN
	BSF		FREQUENCY		; ߂l 0 ȊOȂ 60KHz MX^[g

	CALL	SET_FREQUENCY	; Mgݒ

;--------------------------------------------------------------------------------
;	TMR0 ݒ
;	NbN 8MHz Ȃ ( 256 x 4clk ) / 8000000 = 128us ɃI[o[t[
;	PS  32 { 4096us Ɋ݂A244ł悻 1b
;--------------------------------------------------------------------------------

	BANK1

	MOVLW	B'10000100'		; Weak pull up disable, TMR0 interanal clock, PSA=TMR0, PS=1:32
	MOVWF	OPTION_REG		; Bank 1

;--------------------------------------------------------------------------------
;	TMR1 ݒ, RyA@\gĐm 1bŊ
;--------------------------------------------------------------------------------

	BANK0

	CLRF	TMR1H			; Bank 0, TMR1 NA
	CLRF	TMR1L			; Bank 0

	MOVLW	B'00001011'		; Campare mode with Special event triger enable
	MOVWF	CCP1CON			; Bank0

	MOVLW	H'F4'			; &HF423 = 62500 - 1A0.5us x 62500 = 31.25ms
	MOVWF	CCPR1H			; Bank0
	MOVLW	H'23'
	MOVWF	CCPR1L			; Bank0, vXP[ƕ 31.25 x 8 = 250ms Ŋ荞ݔ

	MOVLW	B'00110100'		; vXP[ 1:8
	MOVWF	T1CON			; Bank0

;---------------------------------------------------------------------------
;	PWM ݒ ` TMR2 X^[g
;---------------------------------------------------------------------------

	BANK1

	MOVLW	PWM_CYCLE		; PWM 
	MOVWF	PR2				; Bank 1, PWM Zbg

	BANK0

	MOVLW	DUTY100			; DUTY 100% ŃX^[g
	MOVWF	CCPR2L			; Bank 0, DUTY ͂̃WX^̒lύXĒ

	MOVLW	B'11001100'		; PWM mode, P1A single output
	MOVWF	CCP2CON			; Bank 0

	MOVLW	B'00000100'		; Postscale = 1:1, Prescale = 1, TMR2 ON
	MOVWF	T2CON			; Bank 0, TMR2 X^[g

;---------------------------------------------------------------------------
;	e튄݃X^[gAMobt@AM֘AϐNAA
;---------------------------------------------------------------------------

	CALL	START_INTERUPT

;---------------------------------------------------------------------------
;	C[v
;---------------------------------------------------------------------------

MAIN_LOOP:

	CALL	READ_VOLTAGE	; 邳ǂݍ݁A邳͏Ƀ`FbNifor software PWMj
	CALL	DIMMER			; PWM fB}[

	CALL	DISP_STATUS_LED	; Zς LED

	CALL	SCAN_ACC		; ANZTd̏Ԃ`FbN

	BTFSS	ACC_FLAG
	GOTO	MAIN_LOOP		; ANZTd OFF ȂI

;
;	ACC ON ̏
;

	CALL	SCAN_SW			; L[XL

	CALL	EXEC_OPERATION	; XLʂɉ

	CALL	SET_PARAMETERS	; 7ZOp^[Zbg
	CALL	DISPLAY			; 7ZO\

	GOTO	MAIN_LOOP

;--------------------------------------------------------------------------------
;	ȉTu[`
;--------------------------------------------------------------------------------
;--------------------------------------------------------------------------------
;	LED \ZOgp^[𓾂
;	IN		PIC_MIN, PIC_HOUR ( BCDj
;	RETURN	PATTERN_C1		ʂ̃ZOgp^[
;			PATTERN_C2		ʂ̃ZOgp^[
;			PATTERN_C3		ʂ̃ZOgp^[
;			PATTERN_C4		ʂ̃ZOgp^[
;--------------------------------------------------------------------------------

SET_PARAMETERS:

	MOVF	PIC_MIN,W			; ɊݑŒlĂ悢悤ɑޔĂ
	MOVWF	PIC_MIN_TMP
	MOVF	PIC_HOUR,W
	MOVWF	PIC_HOUR_TMP

;--------------------------------------------------------------------------------
;	̃rbgp^[𓾂
;--------------------------------------------------------------------------------

	CLRF	prm1b				;  8bit ̓NA
	MOVF	PIC_HOUR_TMP,W		; 
	MOVWF	prm1a				;  8bit Zbg

	CALL	HEX2DEC16			; 16bitl -> 5 BCD ϊ

	MOVF	prm3a,W				; BCD 
	MOVWF	BCD_L				; XgA
	MOVF	prm3b,W				; BCD 
	MOVWF	BCD_H				; XgA

;--------------------------------------------------------------------------------
;	̃[TvX
;--------------------------------------------------------------------------------

GET_C2_PATTERN:

	MOVF	BCD_L,W				; ŏɉʂϊ
	CALL	GET_PATTERN			; ϊ
	MOVWF	PATTERN_C2			; 2ڂ̃p^[ۑ

	CLRF	PATTERN_C1			; uNɐݒ肵Ă

	MOVF	BCD_H,W
	BTFSC	STATUS,Z			; ʂ 0 ?
	GOTO	GET_MIN_PATTERN		; Yes, 1 ڂ̓uN̂܂ܕ

	CALL	GET_PATTERN			; 0 łȂ΃p^[擾
	MOVWF	PATTERN_C1			; 1ڂ̃p^[ۑ

;--------------------------------------------------------------------------------
;	̃rbgp^[𓾂
;	̓[TvXsv
;--------------------------------------------------------------------------------

GET_MIN_PATTERN:

	CLRF	prm1b				;  8bit ̓NA
	MOVF	PIC_MIN_TMP,W		; 
	MOVWF	prm1a				;  8bit Zbg

	CALL	HEX2DEC16			; 16bitl -> 5 BCD ϊ

	MOVF	prm3a,W				; BCD 
	MOVWF	BCD_L				; XgA
	MOVF	prm3b,W				; BCD 
	MOVWF	BCD_H				; XgA

	MOVF	BCD_H,W
	CALL	GET_PATTERN	
	MOVWF	PATTERN_C3			; 3ڂ̃p^[ۑ

	MOVF	BCD_L,W
	CALL	GET_PATTERN
	MOVWF	PATTERN_C4			; 4ڂ̃p^[ۑ

	RETURN

;--------------------------------------------------------------------------------
;	7ZO\p^[𓾂iHUD\Am[}\Ήj
;	IN:		WiBCDlj
;	IN:		DISP_MODE tO
;	RETURN:	W (ZOgp^[j
;--------------------------------------------------------------------------------

GET_PATTERN:

	BTFSC	DISP_MODE			; ݒ`FbNA1 = HUD [h
	GOTO	GET_HUD_DATA

	CALL	GET_7SEG_PATTERN
	RETURN

GET_HUD_DATA:

	CALL	GET_7SEG_PATTERN_HUD
	RETURN

;--------------------------------------------------------------------------------
;	VZO LED \
;	IN:		PATTERN_C1,2,3,4 irbgp^[j
;--------------------------------------------------------------------------------

DISPLAY:

;
;	Zς݂
;

	BTFSC	MAN_CALIB_FLAG
	GOTO	EXEC_DISPLAY		; 1ł蓮Zꂽ

	BTFSC	WAVE_CALIB_FLAG
	GOTO	EXEC_DISPLAY		; 1łdgZꂽ

	BTFSC	DP_ON
	GOTO	EXEC_DISPLAY		; ZԂȂ̂ DP ɍ킹ē_ŕ\

;
;	\ɎԂ
;

PEND_7SEG_DISPLAY:

	CALL	HOLD_7SEG
	CALL	HOLD_7SEG
	CALL	HOLD_7SEG
	CALL	HOLD_7SEG			; L[XLԂɉeoȂ悤ɎԂ͏

	RETURN

;
;	7 ZO LED _
;

EXEC_DISPLAY:

;	1ڕ\

	CALL	CLR_7SEG			; LED S

	MOVF	PATTERN_C1,W
	BTFSS	STATUS,Z			; [TvX`FbN
	BSF		C1_PORT				; uN\ȊOȂ猅 ON

	MOVWF	SEGMENT

DISPLAY1:

	CALL	DYNAMIC				; ZOgJn

;	2ڕ\

	MOVF	PATTERN_C2,W
	MOVWF	SEGMENT

	BTFSC	DISP_MODE			; HUD ȂR 3 
	GOTO	DISPLAY2

	BTFSC	DP_ON
	BSF		SEGMENT,7			; bR\

DISPLAY2:

	BSF		C2_PORT				;  ON
	CALL	DYNAMIC				; ZOgJn

;	3ڕ\

	MOVF	PATTERN_C3,W
	MOVWF	SEGMENT

	BTFSS	DISP_MODE			; ʏ\ ȂR 3 
	GOTO	DISPLAY3

	BTFSC	DP_ON
	BSF		SEGMENT,7			; bR\

DISPLAY3:

	BSF		C3_PORT				;  ON
	CALL	DYNAMIC				; ZOgJn

;	4ڕ\

	MOVF	PATTERN_C4,W
	MOVWF	SEGMENT

	BSF		C4_PORT				;  ON
	CALL	DYNAMIC				; ZOgJn

	RETURN

;--------------------------------------------------------------------------------
;	ʏ_Ci~bN_iX^eBbN_j
;	IN:		SEGMENT = rbgp^[
;--------------------------------------------------------------------------------

DYNAMIC:

	MOVF	SEGMENT,W			; ZOgp^[ '00000000'iuN\j 
	BTFSC	STATUS,Z
	GOTO	DISP_BLANK			; \uNȂ玞Ԃ

	BTFSC	SEGMENT,0
	BSF		A_SEG				; a ZOg_

SEG_B:

	BTFSC	SEGMENT,1
	BSF		B_SEG				; b ZOg_

SEG_C:

	BTFSC	SEGMENT,2
	BSF		C_SEG				; c ZOg_

SEG_D:

	BTFSC	SEGMENT,3
	BSF		D_SEG				; d ZOg_

SEG_E:

	BTFSC	SEGMENT,4
	BSF		E_SEG				; e ZOg_

SEG_F:

	BTFSC	SEGMENT,5
	BSF		F_SEG				; f ZOg_

SEG_G:

	BTFSC	SEGMENT,6
	BSF		G_SEG				; g ZOg_

SEG_DP:

	BTFSC	SEGMENT,7
	BSF		DP_SEG				; dp ZOg_

DISP_BLANK:						; uN\̏ꍇł莞Ԃ͏

	CALL	HOLD_7SEG			; \ێ

	CALL	CLR_7SEG

	CALL	HOLD_7SEG2			; ێ

	RETURN

;--------------------------------------------------------------------------------
;	7 ZO\莞ԕێ
;	n[hEGA PWM ɉAPxŒ̏ꍇ͕\Ԃ𒲐߂ĂɋPx
;	IN:		DUTY_MIN
;--------------------------------------------------------------------------------

HOLD_7SEG:

	CALL	WAIT_1ms_8MHz

	MOVLW	DUTY0				; ŒPx AD l
	SUBWF	BLIGHTNESS,W
	BTFSS	STATUS,C			; if ADl >= ŒPx, C=1, skip next line
	RETURN

	GOTO	HOLD2

HOLD_7SEG2:

	CALL	WAIT_10us_8MHz
	CALL	WAIT_10us_8MHz
	CALL	WAIT_10us_8MHz
	CALL	WAIT_10us_8MHz

	MOVLW	DUTY0				; ŒPx AD l
	SUBWF	BLIGHTNESS,W
	BTFSC	STATUS,C			; if ADl < ŒPx, C=0, skip next line
	RETURN

HOLD2:

	CALL	WAIT_1ms_8MHz
	CALL	WAIT_1ms_8MHz

	RETURN

;--------------------------------------------------------------------------------
;	7 ZO\
;--------------------------------------------------------------------------------

CLR_7SEG:

	CLRF	PORTB			; L = OFF
	BCF		DP_SEG			; L = OFF

	BCF		C1_PORT			; L =  OFF
	NOP
	BCF		C2_PORT
	NOP
	BCF		C3_PORT
	NOP
	BCF		C4_PORT

	RETURN

;--------------------------------------------------------------------------------
;	Zς LEDAf[^M LED _a
;	IN:		BLIGHTNESS (0-255)
;--------------------------------------------------------------------------------

DISP_STATUS_LED:

	BCF		DR_LED_PORT
	BTFSC	DR_FLAG
	BSF		DR_LED_PORT		; f[^M LED _

	BCF		CALIB_LED_PORT
	BTFSC	R_CALIB_FLAG
	BSF		CALIB_LED_PORT	; dgZς LED _

;
;	\tgEGA PWM ŋPx𗎂Ƃ
;

;
;	_[v
;

	MOVLW	D'15'
	SUBWF	BLIGHTNESS,W
	BTFSC	STATUS,C		; if BLIGHTNESS < 50, C=0, skip next line
	GOTO	DST2

	MOVLW	D'15'			; ŏPxm
	MOVWF	BLIGHTNESS

DST2:

	MOVF	BLIGHTNESS,W
	MOVWF	SOFT_PWM_CNT	; H ̉

	BTFSC	STATUS,Z
	INCF	SOFT_PWM_CNT,F	; Œ͕ۏ

	CALL	SOFT_PWM		; 莞ԓ_

	BCF		DR_LED_PORT		; 
	NOP
	BCF		CALIB_LED_PORT

;
;	[v
;

	MOVF	BLIGHTNESS,W
	MOVWF	SOFT_PWM_CNT

	BTFSC	STATUS,Z
	INCF	SOFT_PWM_CNT,F	; Œ 1 ɃNbsO

	MOVF	SOFT_PWM_CNT,W
	SUBLW	D'255'			; 255 - SOFT_PWM_CNT -> W

	MOVWF	SOFT_PWM_CNT	; L ̉
	BTFSC	STATUS,Z
	INCF	SOFT_PWM_CNT,F	; Œ͕ۏ

	CALL	SOFT_PWM		; 莞ԏ

	RETURN
;
;	\tgEGA PWM
;

SOFT_PWM:

	CALL	WAIT_10us_8MHz
	CALL	WAIT_10us_8MHz

	DECFSZ	SOFT_PWM_CNT,F
	GOTO	SOFT_PWM

	RETURN

;--------------------------------------------------------------------------------
;	8bit A/D ϊ
;	RETURN:		BLIGHTNESS	(0-255)A0 = ÂA255 = 邢
;--------------------------------------------------------------------------------

READ_VOLTAGE:

	BSF		ADCON0,GO		; GO (start) bit 𗧂Ă A/D ϊJn

WAIT_AD:

	BTFSC	ADCON0,GO		; A/D ϊI? 0 Ȃ玟XLbv
	GOTO	WAIT_AD			; ܂ A/D ϊ

	MOVF	ADRESH,W		; Bank 0, A/D ϊliʁjǂݏo
	MOVWF	BLIGHTNESS		; ɃXgA

	RETURN

;--------------------------------------------------------------------------------
;	fB}[ PWM 
;	IN:		BLIGHTNESS (0-255)A0 = ÂA255 = 邢
;--------------------------------------------------------------------------------

DIMMER:

	MOVLW	DUTY0
	SUBWF	BLIGHTNESS,W
	BTFSS	STATUS,C		; if BLIGHTNESS >= DUTY0, C=1, skip next line
	GOTO	MIN_DUTY

	MOVLW	DUTY100
	SUBWF	BLIGHTNESS,W
	BTFSC	STATUS,C		; if BLIGHTNESS < DUTY100, C=0, skip next line
	GOTO	MAX_DUTY

	MOVF	BLIGHTNESS,W	; DUTY_MAX Ȃ A/D ϊl̂܂ DUTY lƂ

SET_DUTY:

	MOVWF	CCPR2L			; DUTY ύX
	RETURN

MIN_DUTY:					; DUTY ŏiÊj

	MOVLW	DUTY0			; Œ̋Px
	GOTO	SET_DUTY

MAX_DUTY:					; DUTY őij

	MOVLW	DUTY100
	GOTO	SET_DUTY

;--------------------------------------------------------------------------------
;	ANZTd̏ԕω`FbN
;	RETURN		ACC_FLAG ( 1= ACC ON )
;--------------------------------------------------------------------------------
;	ACC FLAG = 1 (ACC  ON) & ACC_ST_PORT = L (ACC  ON) -> ԕωȂAJE^NA
;	ACC FLAG = 0 (ACC OFF) & ACC_ST_PORT = H (ACC OFF) -> ԕωȂAJE^NA
;	LȊO͏ԕωAJE^fNg
;--------------------------------------------------------------------------------

SCAN_ACC:

;
;	݂̃tOԂ`FbN
;

	BTFSS	ACC_FLAG		; 1 = ACC ON
	GOTO	SCAN_ACC2		; 0 = ACC OFF

;
;	݂ ACC tO ON
;
	BTFSC	ACC_ST_PORT		; L = ACC ON
	GOTO	ACC_CHANGED		; ω

	GOTO	RESET_ACC_CNT	; ω

;
;	݂ ACC tO OFF
;

SCAN_ACC2:

	BTFSS	ACC_ST_PORT		; H = ACC OFF
	GOTO	ACC_CHANGED		; ω

	GOTO	RESET_ACC_CNT	; ω

;
;	݂̃tOƂ͏ԂωĂ
;

ACC_CHANGED:

	DECFSZ	ACC_CNG_CNT,F	; 񐔃JE^fNg
	RETURN					; 񐔖͂̂܂ܖ߂

;
;	ACC tO𔽓]ĎM~AĊJ𐧌
;

	MOVLW	B'00000100'		; ACC ԃrbg 1 ɂ
	XORWF	USER_FLAG2,F	; ACC ԃrbg𔽓]

	BTFSS	ACC_FLAG
	GOTO	ACC_CHG2		; ACC_= OFF

;	M~

	CALL	STOP_RECIEVE	; M~

	GOTO	RESET_ACC_CNT

;	MĊJ

ACC_CHG2:

	CALL	RESUME_RECIEVE	; MĊJ

;
;	ACC ֘AI
;

RESET_ACC_CNT:

	MOVLW	ACC_RESPONSE
	MOVWF	ACC_CNG_CNT		; JE^Zbg

	RETURN

;--------------------------------------------------------------------------------
;	XCb`XL
;	w񐔘AăL[ĂtO𗧂ĂiΉj
;	RETURN:		UP_SW_FLAG, DW_SW_FLAG, SEC_SW_FLAG (1 = ꂽ)
;--------------------------------------------------------------------------------

SCAN_SW:

	BTFSS	UP_SW_PORT			; UP XCb`Ă邩
	GOTO	PUSH_UP_SW			; L = ꂽ

	MOVLW	KEY_SCAN_C			; ĂȂ̂
	MOVWF	UP_SW				; JE^
	BCF		UP_SW_FLAG			; tONA
	GOTO	CHK_DW_SW			; ̃L[͂

PUSH_UP_SW:

	DECFSZ	UP_SW,F
	GOTO	CHK_DW_SW			; 񐔖Ȃ玟̃L[͏

	BSF		UP_SW_FLAG			; tO𗧂Ă
	MOVLW	KEY_SCAN_C
	MOVWF	UP_SW				; JE^

CHK_DW_SW:

	BTFSS	DW_SW_PORT			; DW XCb`Ă邩
	GOTO	PUSH_DW_SW			; L = ꂽ

	MOVLW	KEY_SCAN_C			; ĂȂ̂
	MOVWF	DW_SW				; JE^
	BCF		DW_SW_FLAG			; tONA
	GOTO	CHK_SEC_SW			; ̃L[͂

PUSH_DW_SW:

	DECFSZ	DW_SW,F
	GOTO	CHK_SEC_SW			; 񐔖Ȃ玟̃L[͏

	BSF		DW_SW_FLAG			; tO𗧂Ă
	MOVLW	KEY_SCAN_C
	MOVWF	DW_SW				; JE^

CHK_SEC_SW:

	BTFSS	SEC_SW_PORT			; ST XCb`Ă邩
	GOTO	PUSH_SEC_SW			; L = ꂽ

	MOVLW	KEY_SCAN_C			; ĂȂ̂
	MOVWF	SEC_SW				; JE^
	BCF		SEC_SW_FLAG			; tONA
	GOTO	KEY_SCAN_END		; ̃L[͂

PUSH_SEC_SW:

	DECFSZ	SEC_SW,F
	GOTO	KEY_SCAN_END

	BSF		SEC_SW_FLAG			; tO𗧂Ă
	MOVLW	KEY_SCAN_C
	MOVWF	SEC_SW				; JE^

KEY_SCAN_END:

	RETURN

;--------------------------------------------------------------------------------
;	L[͂ɉ
;	IN:		L[̓tO
;--------------------------------------------------------------------------------

EXEC_OPERATION:

;
;	 UP & DW  g؂ւ
;

	BTFSC	UP_SW_PORT		; UP XCb`ꂽi|[g𒼐ڃXLj
	GOTO	CHK_ALL_SW		; ĂȂ̂Ŏ̃L[XL͂

	BTFSC	DW_SW_PORT		; DW XCb`ꂽi|[g𒼐ڃXLj
	GOTO	CHK_ALL_SW

	CALL	WAIT_100ms_8MHz	; Ah~
	CALL	WAIT_100ms_8MHz	; Ah~

	BTFSC	UP_SW_PORT		; ܂ UP XCb`Ă邩i|[g𒼐ڃXLj
	GOTO	CHK_ALL_SW		; ĂȂ̂Ŏ̃L[XL͂

	BTFSC	DW_SW_PORT		;  DW XCb`Ă邩i|[g𒼐ڃXLj
	GOTO	CHK_ALL_SW

	CALL	CHANGE_FREQ2		; Ȃ狭IɎgύX

	GOTO	END_WITH_BEEP

;
;	 DW & SEC  MJnE~؂ւ
;

CHK_ALL_SW:


	BTFSC	DW_SW_PORT		; DW XCb`ꂽi|[g𒼐ڃXLj
	GOTO	SCAN1

	BTFSC	SEC_SW_PORT		; SEC XCb`ꂽi|[g𒼐ڃXLj
	GOTO	SCAN1

	CALL	WAIT_100ms_8MHz	; Ah~
	CALL	WAIT_100ms_8MHz	; Ah~

	BTFSC	DW_SW_PORT		;  DW XCb`Ă邩i|[g𒼐ڃXLj
	GOTO	SCAN1

	BTFSC	SEC_SW_PORT		; SEC XCb`ꂽi|[g𒼐ڃXLj
	GOTO	SCAN1

;
;	fR[hJnE~؂ւ
;	TMR1 RyA荞݂͎~߂Ă͂Ȃ
;

	BTFSS	INTCON,RBIE		; Bank 0,  PORTB ԕω݋ ?
	GOTO	RESTART_DECODE	; NO, ݍĊJ

	CALL	STOP_RECIEVE	; M~

	GOTO	END_WITH_BEEP

RESTART_DECODE:

	CALL	RESUME_RECIEVE	; MĊJ

END_WITH_BEEP:

	CALL	BEEP			; mF炷

	RETURN

;
;	X̃XCb`ꂽꍇ̏
;

SCAN1:

	BTFSS	UP_SW_FLAG		; UP XCb`ꂽ
	GOTO	SCAN2			; ĂȂ

	BCF		UP_SW_FLAG		; tONA

	CALL	STOP_INTERUPT	; S݋֎~

	CALL	INC_MINUTE		; CNgA荞݂֎~ĕϐޔsv

	GOTO	RESUME_INTERUPT	; ݍĊJ

SCAN2:

	BTFSS	DW_SW_FLAG		; DW XCb`ꂽ
	GOTO	SCAN3			; ĂȂ

	BCF		DW_SW_FLAG		; tONA

	CALL	STOP_INTERUPT	; S݋֎~

	CALL	DEC_MINUTE		; fNgA݂֎~ĕϐޔsv

	GOTO	RESUME_INTERUPT	; ݍĊJ

SCAN3:

	BTFSS	SEC_SW_FLAG		; bZbgXCb`ꂽ
	RETURN					; ĂȂ

	BCF		SEC_SW_FLAG		; tONA

	CALL	STOP_INTERUPT	; S݋֎~

	CLRF	PIC_SEC			; bZbgA݂֎~ĊmɕbZbg

RESUME_INTERUPT:

	BSF		MAN_CALIB_FLAG	; 蓮ZtO𗧂Ă
	BCF		R_CALIB_FLAG	; dgZł͂Ȃ

	GOTO	START_INTERUPT	; ݍĊJ

;--------------------------------------------------------------------------------
;	M~
;--------------------------------------------------------------------------------

STOP_RECIEVE:

	BCF		INTCON,RBIE		; PORTB ԕω݋֎~
	NOP
	BCF		INTCON,T0IE		; TMR0 ~

	BCF		DR_FLAG			; f[^MtONA

	RETURN

;--------------------------------------------------------------------------------
;	MĊJ
;--------------------------------------------------------------------------------

RESUME_RECIEVE:

	CALL	START_RBC_INT	; ݍĊJA֘AϐZbg

	CALL	RESET_TMR0		; TMR0 ֘ANA

	BSF		INTCON,T0IE		; TMR0 ݍĊJ

	RETURN


;--------------------------------------------------------------------------------
;	ݒ~
;--------------------------------------------------------------------------------

STOP_INTERUPT:

	BANK1

	BCF		PIE1,CCP1IE		; Bank1, RyAݒ~

	BANK0

	CLRF	INTCON			; Bank 0, Sݒ~

	BCF		DR_FLAG			; f[^MtONA

	RETURN

;--------------------------------------------------------------------------------
;	݃X^[g & Mobt@NA
;--------------------------------------------------------------------------------

START_INTERUPT:

	BANK1

	BSF		PIE1,CCP1IE		; Bank1, RyA݋

	BANK0

	BSF		INTCON,T0IE		; Bank 0, TMR0 ݋
	NOP
	BSF		INTCON,GIE		; Bank 0, O[o݋
	NOP
	BSF		INTCON,PEIE		; Bank 0, ӊ݋
	NOP
	BSF		T1CON,TMR1ON	; Bank 0, TMR1 X^[g

	CALL	RESET_TMR0		; TMR0 ֘ANA

	CALL	RESET_INTCLK_TMR	; vp^C}[ƃJE^NA

	CALL	START_RBC_INT	; ԕω݊Jn

	RETURN

;
;	ԕω݊Jn
;

START_RBC_INT:

	CLRF	VALUE			; Mf[^l
	CLRF	SYNC_ERROR		; As
	CLRF	R_DATA			; Mf[^NA

	CALL	CLR_BUFFER		; obt@jĎMȂ

	BCF		SAMPLING_FLAG	; ̗オ肩pXvJn

	BSF		INTCON,RBIE		; Bank 0, PORTB ԕω݋

	BCF		DR_FLAG			; f[^MtONA

	RETURN

;--------------------------------------------------------------------------------
;	L[̓`FbNpJE^ƃtÕNA
;--------------------------------------------------------------------------------

INIT_KEY_CNT:

	MOVLW	KEY_SCAN_C			; l
	MOVWF	UP_SW
	MOVWF	DW_SW
	MOVWF	SEC_SW

	CLRF	KEY_FLAG			; L[̓tO

	RETURN

;*********************************************************************
;	HEX2DEC16
;	Developed by http://orange.zero.jp/electronics/pic/pic.html
;	16rbgl10i5BCDlɕϊBFSR ͉
;	 prm1b(),prm1a() ̂QoCg
;	ʂ prm3e,prm3d,prm3c,prm3b,prm3a ɓAE prm3a ʂ̐ɂȂB
;*********************************************************************

HEX2DEC16:

	movlw	srlc1	; i[ꏊl
	movwf	FSR

	call	devide	; ŉʕϊ
	call	devide
	call	devide
	call	devide
	call	devide	;ŏʕϊ

	return

devide:					; 10Tu[`i10ŏZj

	movlw	d'16'	; 16rbgԂ
	movwf	srlc1
	clrf	srwk1

devide0:

	bcf		3h,0	; LtÕNA
	rlf		prm1a,1
	rlf		prm1b,1
	rlf		srwk1,1
	movlw	b'11110110'
	addwf	srwk1,0
	btfsc	3h,0
	movwf	srwk1
	btfsc	3h,0
	incf	prm1a,1
	decfsz	srlc1,1
	goto	devide0
	decf	FSR,1	; 4h=fsr
	movf	srwk1,0
	movwf	0h		; ] (0h=indirect)

	return

;--------------------------------------------------------------------------------
;	Mobt@̃NA
;--------------------------------------------------------------------------------

;
;	Bank 1 ̈̃obt@
;

CLR_BUFFER:

	MOVLW	BUFFER			; Bank 1 Mobt@擪AhX
	MOVWF	FSR

	MOVLW	BUFFER_SIZE
	MOVWF	WORK

CLR_BUFFER2:

	CLRF	INDF			; Mobt@G[R[h (0) Ŗ߂Ă
	INCF	FSR,F

	DECFSZ	WORK,F
	GOTO	CLR_BUFFER2

;
;	Bank 0 ̈̃obt@
;

	MOVLW	M1				; Bank 0 Mobt@擪AhX
	MOVWF	FSR

	MOVLW	D'15'			; 15 oCgNA
	MOVWF	WORK

CLR_BUFFER3:

	CLRF	INDF			; Mobt@G[R[h (0) Ŗ߂Ă
	INCF	FSR,F

	DECFSZ	WORK,F
	GOTO	CLR_BUFFER3

	RETURN

;--------------------------------------------------------------------------------
;	4.1KHz duty 50%  0.1bԈduU[炷
;--------------------------------------------------------------------------------

BEEP:

	MOVLW	D'2'				; 61.25ms x 2 = 122.5ms
	MOVWF	BEEP_CNT_H

BEEP2:

	MOVLW	D'255'				; 240us x 255 = 61.25ms
	MOVWF	BEEP_CNT_L

BEEP3:

	CALL	EXEC_BEEP

	DECFSZ	BEEP_CNT_L,F
	GOTO	BEEP3

	DECFSZ	BEEP_CNT_H,F
	GOTO	BEEP2

	CALL	WAIT_500ms_8MHz		; L[Ah~

	RETURN
;
;	duU[ɃpX𑗂B 4.1KHz duty 50% = ON 120us, OFF 120us
;

EXEC_BEEP:

	BSF		BZ_PORT				; ON
	CALL	WAIT_100us_8MHz		; 120us
	CALL	WAIT_10us_8MHz
	CALL	WAIT_10us_8MHz

	BCF		BZ_PORT				; OFF
	CALL	WAIT_100us_8MHz		; 120us
	CALL	WAIT_10us_8MHz
	CALL	WAIT_10us_8MHz

	RETURN

;--------------------------------------------------------------------------------
;	Cuǂݍ
;--------------------------------------------------------------------------------

	INCLUDE		EEPROM_16F88x.lib
	INCLUDE		Wait.lib

;---------------------------------------------------------------------------
;	EEPROM
;---------------------------------------------------------------------------
	ORG		H'2100'				; EEPROM JnԒnw

	DE		D'0'				; gݒlAl: { 40KHz
								; dgZɐgZ[uANɔf

;---------------------------------------------------------------------------
;	vOI
;---------------------------------------------------------------------------

	END
