const canvas = document.getElementById("cv");
const ctx = canvas.getContext("2d");

let width = canvas.width;
let height = canvas.height;

let v = 0;
let av = 1;//let dv=av;
let f = 1;
let r = 4;
let l = 180;
let m = 3;
let op = 77;
let c = 1;
let e = 1;
let a = 1000;
let b = 1000;

let running = false;

/* === 描画 === */
function draw() {

  ctx.clearRect(0, 0, width, height);

  // 基準線
  ctx.strokeStyle = "black";
  ctx.beginPath();
  ctx.moveTo(0, height/2);
  ctx.lineTo(width-30, height/2);
  ctx.stroke();

  let limit = op + (2*m+c)*l/4;
  // 壁
  ctx.fillStyle = "lightGray";
  ctx.fillRect(limit,0,30,height);
  // 入射波（緑）
  for (let x = 0; x <= limit; x += r) {
    let y = (height/6)*e*Math.sin((v+x-op)*Math.PI*2/l)
            + height/2 + a;
    ctx.fillStyle = "green";
    ctx.beginPath();
    ctx.arc(x, y, r/2, 0, Math.PI*2);
    ctx.fill();
  }

  // 反射波（青）
  for (let x = 0; x <= limit; x += r) {
    let y = (height/6)*Math.sin((v-x+op)*Math.PI*2/l)
            + height/2;
    ctx.fillStyle = "blue";
    ctx.beginPath();
    ctx.arc(x, y, r/2, 0, Math.PI*2);
    ctx.fill();
  }

  // 合成波（赤）
  for (let x = 0; x <= limit; x += r) {
    let y = b
      + e*(height/6)*Math.sin((v+x-op)*Math.PI*2/l)
      + (height/6)*Math.sin((v-x+op)*Math.PI*2/l)
      + height/2;
    ctx.fillStyle = "red";
    ctx.beginPath();
    ctx.arc(x, y, r/2, 0, Math.PI*2);
    ctx.fill();
  }
}

/* === アニメーション === */
function animate() {
  if (!running) return;
  /*dv=f*av;
  v=v+dv;*/
   v += f * av;
  
  
  draw();

  requestAnimationFrame(animate);
}

/* === ボタン制御 === */
document.getElementById("start").onclick = () => {
	if (!running) {       
    running = true;
    av = 1;
    requestAnimationFrame(animate);
  }
};

 

document.getElementById("stop").onclick = () => {
  av = 0;
  running = false;
};

/* === 固定端 / 自由端 === */
document.getElementsByName("end").forEach(radio => {
  radio.onchange = () => {
    if (radio.value === "fixed" && radio.checked) {
      e = 1;
    }
    if (radio.value === "free" && radio.checked) {
      e = -1;
    }
  };
});

/* === 波の種類 === */
document.getElementsByName("wave").forEach(radio => {
  radio.onchange = () => {
    if (!radio.checked) return;

    if (radio.value === "incident") {
      a = 1000;
      b = 1000;
    }
    if (radio.value === "reflection") {
      a = 0;
      b = 1000;
    }
    if (radio.value === "sum") {
      a = 0;
      b = 0;
    }
  };
});

/* 初期描画 */
draw();
