/*refract.java
 *2009/2/11 
 *refract.js
 *2025/12/25
 *Suzuki,Tetsuo
 */
const canvas = document.getElementById("cv");
const ctx = canvas.getContext("2d");

const h1 = document.getElementById("h1");
const h2 = document.getElementById("h2");

function draw() {
  const apwidth = canvas.width;
  const apheight = canvas.height;

  const an = h1.value / 10;        // 入射角
  const n = h2.value;
  const n1 = n / 1000;

  const pai = Math.PI;
  const a1 = an * pai / 180;
  const a2 = Math.asin(Math.sin(a1) / n1);

  const x2 = apheight - 20;
  const y2 = apheight - 20;
  const x1 = x2 / 2;
  const y1 = y2 / 2;
  const r = 1.41421356 * x1;

  const x0 = x1 - r * Math.sin(a1);
  const y0 = y1 - r * Math.cos(a1);

  const x3 = x1 + r * Math.sin(a1) / n1;
  const y3 = y1 + r * Math.sqrt(n1*n1 - Math.sin(a1)**2) / n1;

  const x4 = x1 + r * Math.sin(a1);
  const y4 = y1 - r * Math.cos(a1);

  ctx.clearRect(0,0,apwidth,apheight);

  /* 媒質 */
  ctx.fillStyle = "rgb(230,230,230)";
  ctx.fillRect(0,0,x2,y1);

  const c1 = 263 - n/30;
  ctx.fillStyle = `rgb(${c1},${c1},${c1})`;
  ctx.fillRect(0,y1,x2,y2);

  /* 境界線 */
  ctx.strokeStyle = "lightgray";
  ctx.beginPath();
  ctx.moveTo(x1,0);
  ctx.lineTo(x1,2*y1);
  ctx.stroke();

  /* 入射光 */
  ctx.strokeStyle = "red";
  ctx.beginPath();
  ctx.moveTo(x0,y0);
  ctx.lineTo(x1,y1);
  ctx.stroke();

  /* 屈折 or 全反射 */
  ctx.beginPath();
  if (Math.sin(a1)/n1 < 1) {
    ctx.moveTo(x1,y1);
    ctx.lineTo(x3,y3);
  } else {
    ctx.moveTo(x1,y1);
    ctx.lineTo(x4,y4);
  }
  ctx.stroke();

  /* 反射光 */
  if (n1 !== 1) {
    ctx.strokeStyle = "white";
    ctx.beginPath();
    ctx.moveTo(x1,y1);
    ctx.lineTo(x4,y4);
    ctx.stroke();
  }

  /* 文字 */
  ctx.fillStyle = "black";
  ctx.font = "14px Arial";
  ctx.fillText(`Incidence θ° = ${an}`, 2*x1+10, 30);
  ctx.fillText(`Relative Ref. index n =n2/n1= ${n1.toFixed(3)}`, 2*x1+10, 90);
  ctx.fillText(`sinθ/sinφ = ${Math.sin(a1)/Math.sin(a2)}`, 2*x1+10, 110);
  ctx.fillText(`θ/φ = ${a1/a2}`, 2*x1+10, 130);
  ctx.fillText(`tanθ/tanφ = ${Math.tan(a1)/Math.tan(a2)}`, 2*x1+10, 150);
  ctx.fillText(`cosθ/cosφ = ${Math.cos(a1)/Math.cos(a2)}`, 2*x1+10, 170);
  ctx.fillText(`Medium1`, 10, y1-60);
  ctx.fillText(`n1`, 10,y1-40);
  ctx.fillText(`Medium2`, 10, y1+50);
  ctx.fillText(`n2`, 10,y1+70);
  
  ctx.fillStyle = "red";
  ctx.font = "14px Arial";
  ctx.fillText(`Incidence`, x1-x1*Math.sin(a1)/4-15,3*y1/4-x1*Math.cos(a1)/4-15);
  ctx.fillText(`θ`, x1-x1*Math.sin(a1)/4,3*y1/4-x1*Math.cos(a1)/4);
  ctx.fillText(`φ`, x1+x1*Math.sin(a2)/4,5*y1/4+x1*Math.cos(a2)/4);
  ctx.fillText(`Refraction`, x1+x1*Math.sin(a2)/4-15,5*y1/4+x1*Math.cos(a2)/4+17);
  
  if (n1 < 1) {	  
  ctx.fillStyle = "red";
  ctx.font = "14px Arial";
    ctx.fillText(`Critical Angle θc = ${180*Math.asin(n1)/pai}`, 2*x1+10, 50);
  } 
  else {
    ctx.fillStyle = "red";
    ctx.fillText("Critical Angle θc =None", 2*x1+10, 50);
  }

  
  
  

  if (Math.sin(a1)/n1 < 1) {
    ctx.fillText(`Refraction φ° = ${(a2*180/pai).toFixed(2)}`, 2*x1+10, 70);
  } else {
    ctx.fillStyle = "red";
    ctx.fillText("Total Reflection", 2*x1+10, 70);
  }
}

h1.addEventListener("input", draw);
h2.addEventListener("input", draw);

draw();




