/*grating.java
 *2006/5/27
 *grating.js
 *2025/11/26
 *Suzuki,Tetsuo 鈴木徹夫
 */

const canvas = document.getElementById("myCanvas");
const ctx = canvas.getContext("2d");

let n=300;
let c = "red"	
let i,j,r,h,h1,s,p,q,wl,fl1,fl2;
let ah,aw,ang1,ang2;
let x1,x2,x3,x4,x5,x6,x7,x8,x9,px,py,gd,sn,m;
let ys;//2スリット
	
let d = { width: canvas.width, height: canvas.height };

function init() {
	
        aw=d.width;
        ah=d.height;
        px=aw/4;
        py=ah/2;
		r=0;
		p=0;
		s=0.5;//1
		h=8;
		wl=5;
		q=0;
        fl1=1;fl2=0;
        ang1=-90;
        ang2=180;
        gd=14;
        sn=2;//スリット数2 means 5(default)
        m=2;//表示倍率1
        ys=0;
	buffer = createBuffer(d.width, d.height);
    drawToBuffer();
	
}

function createBuffer(width, height) {
    const offscreenCanvas = document.createElement('canvas');
    offscreenCanvas.width = width;
    offscreenCanvas.height = height;
    return offscreenCanvas;
}

function drawToBuffer() {
	const g = buffer.getContext("2d");
   
		g.fillStyle = "white";
		g.fillRect(0,0,d.width,d.height)
		for(i=px-(px/m*wl)*m*wl;i<px-r;i=i+m*wl){
		g.strokeStyle = c;//平面波
		g.beginPath();
        g.moveTo(0+i+r,py-m*h/2-sn*m*h);
        g.lineTo(0+i+r,py+m*h/2+(sn-ys)*m*h);			
		g.stroke();
        }
        g.fillStyle = "darkGray";  
          	    g.fillRect(px-4,py-m*h+2,4,m*h-4);
                g.fillRect(px-4,py-2*m*h+2,4,m*h-4);
                g.fillRect(px-4,py-3*m*h+2,4,m*h-4);
                g.fillRect(px-4,py-4*m*h+2,4,m*h-4);
                g.fillRect(px-4,py-5*m*h+2,4,m*h-4);
                g.fillRect(px-4,py-6*m*h+2,4,m*h-4);
                g.fillRect(px-4,py+2,4,m*h-4);
                g.fillRect(px-4,py+2+m*h,4,m*h-4);
                g.fillRect(px-4,py+2+2*m*h,4,m*h-4);
                g.fillRect(px-4,py+2+3*m*h,4,m*h-4);
                g.fillRect(px-4,py+2+4*m*h,4,m*h-4);
                g.fillRect(px-4,py+2+5*m*h,4,m*h-4);
		
          	for(i=0;i<(aw);i=i+m*wl){
				g.strokeStyle = c;
                g.beginPath();
		        g.arc(px,py,i+r, ang1 * Math.PI/180,(ang1 + ang2) * Math.PI/180);
		        g.stroke();	
                if(sn==1||sn==2||sn==3){
					g.strokeStyle = c;
                    g.beginPath();
		            g.arc(px,py-m*h,i+r, ang1 * Math.PI/180,(ang1 + ang2) * Math.PI/180);
		            g.stroke();	
                    }
                if(sn==2||sn==3){
					g.strokeStyle = c;
                    g.beginPath();
					g.arc(px,py-2*m*h,i+r, ang1 * Math.PI/180,(ang1 + ang2) * Math.PI/180);
		            g.stroke();	
                  	}
                if(sn==3){
					g.strokeStyle = c;
                    g.beginPath();
					g.arc(px,py-3*m*h,i+r, ang1 * Math.PI/180,(ang1 + ang2) * Math.PI/180);
                    g.stroke();	
                    }
                if((sn==1||sn==2||sn==3)&&ys==0){
				    g.strokeStyle = c;
                    g.beginPath();
		            g.arc(px,py+m*h,i+r, ang1 * Math.PI/180,(ang1 + ang2) * Math.PI/180);
		            g.stroke();
                    }
                if(sn==2||sn==3){
					g.strokeStyle = c;
                    g.beginPath();
		            g.arc(px,py+2*m*h,i+r, ang1 * Math.PI/180,(ang1 + ang2) * Math.PI/180);
		            g.stroke();
                  	}
                if(sn==3){
					g.strokeStyle = c;
                    g.beginPath();
		            g.arc(px,py+3*m*h,i+r, ang1 * Math.PI/180,(ang1 + ang2) * Math.PI/180);
		            g.stroke();                       
                    }                                        
                }
		g.fillStyle = "white";
		g.fillRect(aw,0,aw/6,ah);
          	    if(fl2==1&&sn!=0&&ys==0){
					for(i=0;i<=sn;i++){
					g.strokeStyle ="black";
		            g.beginPath();
                    g.moveTo(0,py-i*m*h);//入射線
                    g.lineTo(px,py-i*m*h);			
		            g.stroke();                   	
                    for(j=0;j<=(h/wl);j++){
					g.strokeStyle ="black";
		            g.beginPath();
                    g.moveTo(px,py-i*m*h);
                    g.lineTo(aw,py-i*m*h-(aw-px)*j*wl/Math.sqrt(h*h-j*j*wl*wl));			
		            g.stroke();
                   }
                   }
                   for(i=1;i<=sn;i++){
					g.strokeStyle ="black";
		            g.beginPath();
                    g.moveTo(0,py+i*m*h);
                    g.lineTo(px,py+i*m*h);			
		            g.stroke();
                   for(j=0;j<=(h/wl);j++){
					g.strokeStyle ="black";
		            g.beginPath();
                    g.moveTo(px,py+i*m*h);
                    g.lineTo(aw,py+i*m*h-(aw-px)*j*wl/Math.sqrt(h*h-j*j*wl*wl));			
		            g.stroke();
                       
                   }
                   }                        
                 }
				 
				if(fl2==1&&sn==0){
					g.strokeStyle ="black";
		            g.beginPath();
                    g.moveTo(0,py);
                    g.lineTo(px,py);			
		            g.stroke();
                    }
                if(fl2==1&&ys==1&&sn==1){
                for(i=0;i<=sn;i++){
					g.strokeStyle ="black";
		            g.beginPath();
                    g.moveTo(0,py-i*m*h);
                    g.lineTo(px,py-i*m*h);			
		            g.stroke();
				for(j=0;j<=(h/wl);j++){
					g.strokeStyle ="black";
		            g.beginPath();
                    g.moveTo(px,py-i*m*h);
                    g.lineTo(aw,py-i*m*h-(aw-px)*j*wl/Math.sqrt(h*h-j*j*wl*wl));			
		            g.stroke();
                   }
                   }
                   /*for(i=1;i<=sn;i++){
                //        g.drawLine(0,py+i*m*h,px,py+i*m*h);
                      for(j=0;j<=(int)(h/wl);j++){
                  //     g.drawLine(px,py+i*m*h,aw,py+i*m*h-(int)((aw-px)*j*wl/Math.sqrt(h*h-j*j*wl*wl)));
                 //      g.drawLine(px,py+i*m*h,aw,py+i*m*h+(int)((aw-px)*j*wl/Math.sqrt(h*h-j*j*wl*wl)));
                   }
                   }*/
            } 
        if(sn!=0){ 
            g.fillStyle ="black";
		    g.font = "12px Arial"; 
		    g.fillText("0th:sinθ=0λ/d=0",0,py+70);
            g.fillText("       θ=0°",0,py+85);
            g.fillText("1st:sinθ=1λ/d=1×"+1.5*wl+"/"+1.5*h+"="+(Math.round(((wl)/h)*100))/100,0,py+100);
            g.fillText("       θ="+(Math.round(((180*Math.asin((wl)/h)/3.14))*100))/100+"°",0,py+115);//(Math.round((e1/k)*10))/10
            if((h/wl)>=1&&2*(wl)/h<=1.0){
            g.fillText("2nd:sinθ=2λ/d=2×"+1.5*wl+"/"+1.5*h+"="+(Math.round(((2*wl)/h)*100))/100,0,py+130);
            g.fillText("       θ="+(Math.round((180*Math.asin((2*wl)/h)/3.141592653589)*100))/100+"°",0,py+145);
            }
            if((h/wl)>=2&&3*(wl)/h<=1.0){
             g.fillText("3rd:sinθ=3λ/d=3×"+1.5*wl+"/"+1.5*h+"="+(Math.round(((3*wl)/h)*100))/100,0,py+160);
            g.fillText("       θ="+(Math.round((180*Math.asin((3*wl)/h)/3.141592653589)*100))/100+"°",0,py+175);
            }
            if((h/wl)>=3&&4*(wl)/h<=1.0){
            g.fillText("4th:sinθ=4λ/d=4×"+1.5*wl+"/"+1.5*h+"="+(Math.round(((4*wl)/h)*100))/100,0,py+190);
            g.fillText("       θ="+(Math.round((180*Math.asin((4*wl)/h)/3.141592653589)*100))/100+"°",0,py+205);
            }
          }			  
 }
		
		
function move() {
	    r=r+fl1*s;
		if (r>=m*wl) r=0;
}

function start() {
    setInterval(function() {
        move();
        drawToBuffer();
        ctx.clearRect(0, 0, canvas.width, canvas.height);
        ctx.drawImage(buffer, 0, 0);
    }, 30);
}

document.getElementById('red').addEventListener('click', red);
document.getElementById('blue').addEventListener('click', blue);
document.getElementById('wide').addEventListener('click', wide);
document.getElementById('narrow').addEventListener('click', narrow);
document.getElementById('s1').addEventListener('click', s1);
document.getElementById('s2').addEventListener('click', s2);
document.getElementById('s3').addEventListener('click', s3);
document.getElementById('s5').addEventListener('click', s5);
document.getElementById('r05').addEventListener('click', r05);
document.getElementById('r1').addEventListener('click', r1);
document.getElementById('r5').addEventListener('click', r5);
document.getElementById('exp').addEventListener('click', exp);
document.getElementById('hid').addEventListener('click', hid);
document.getElementById('Run').addEventListener('click', Run);
document.getElementById('Stop').addEventListener('click', Stop);



function red() {
	    wl=5;c="red";			 
}
function blue() {
	    wl=3;c="blue";
}
function wide() {
        h=12;
}

function narrow() {
        h=8;
}
function s1() {
        sn=0;ys=0;			 
}
function s2() {
        sn=1;ys=1;
}
function s3() {
        sn=1;ys=0;			 
}
function s5() {
        sn=2;ys=0;
}
function r05() {
        m=1;
}
function r1() {
        m=2;			 
}
function r5() {
        m=10;
}
function exp() {
        fl2=1;
}

function hid() {
        fl2=0;
}
function Run() {
	    fl1=1;		
}

function Stop() {
	    fl1=0;	
}
init();
start();




