/*
 * Decompiled with CFR 0.152.
 */
package jp.or.utmc.nasb.chp.carpe;

import java.util.Map;
import java.util.TreeMap;

public class VsDataImage {
    public static final int OK = 0;
    public static final int ERROR_BAD_SIZE = -1;
    public static final int ERROR_BAD_CHECKSUM = -2;
    public static final int SIZE = 253082;
    public static final int NPALLETES = 16;
    public static final int NOKES = 32;
    public static final int NTEAMS = 16;
    public static final int EMBLEM_WIDTH = 32;
    public static final int EMBLEM_HEIGHT = 32;
    private static final int CHECKSUM_OFFSET = 253078;
    private static final int FIRST_EMBLEM_OFFSET = 54;
    private static final int FIRST_TEAM_EMBLEM_OFFSET = 239366;
    private static final int OKE_SIZE = 6672;
    private static final int TEAM_SIZE = 832;
    private static final int EMBLEM_IMAGE_SIZE = 512;
    private static final int PALLETE_OFFSET = 566;
    private byte[] _data = new byte[253082];
    private Map _colorMap = new TreeMap();
    private int[] _colorTable = new int[16];
    private int _ncolors = 1;

    public VsDataImage() {
        int i = 0;
        while (i < this._colorTable.length) {
            this._colorTable[i] = 0x1C1C1C;
            ++i;
        }
    }

    public int setData(byte[] data) {
        if (data.length < this._data.length) {
            return -1;
        }
        if (!this.checkChecksum(data)) {
            return -2;
        }
        System.arraycopy(data, 0, this._data, 0, 253082);
        return 0;
    }

    private void setPalletes() {
        int p = 566;
        int i = 0;
        while (i < 16) {
            if (i < this._ncolors) {
                this._data[p + 0] = (byte)(this._colorTable[i] >> 16 & 0xFF);
                this._data[p + 1] = (byte)(this._colorTable[i] >> 8 & 0xFF);
                this._data[p + 2] = (byte)(this._colorTable[i] >> 0 & 0xFF);
                this._data[p + 3] = (byte)(this._colorTable[i] >> 24 & 0xFF);
            } else {
                this._data[p + 0] = 0;
                this._data[p + 1] = 28;
                this._data[p + 2] = 28;
                this._data[p + 3] = 28;
            }
            p += 4;
            ++i;
        }
    }

    public byte[] getData() {
        this.setPalletes();
        this.copyEmblem(0, 32);
        this.setChecksum();
        byte[] data = new byte[253082];
        System.arraycopy(this._data, 0, data, 0, 253082);
        return data;
    }

    private int calcChecksum(byte[] data) {
        int sum = 0;
        int i = 0;
        while (i < 253078) {
            sum += data[i] & 0xFF;
            ++i;
        }
        return sum;
    }

    private boolean checkChecksum(byte[] data) {
        if (data == null) {
            return false;
        }
        if (data.length != 253082) {
            return false;
        }
        int checksum = (data[253081] & 0xFF) << 24 | (data[253080] & 0xFF) << 16 | (data[253079] & 0xFF) << 8 | data[253078] & 0xFF;
        int sum = this.calcChecksum(data);
        return checksum == sum;
    }

    private void setChecksum() {
        int checksum = this.calcChecksum(this._data);
        this._data[253078] = (byte)(checksum >> 0 & 0xFF);
        this._data[253079] = (byte)(checksum >> 8 & 0xFF);
        this._data[253080] = (byte)(checksum >> 16 & 0xFF);
        this._data[253081] = (byte)(checksum >> 24 & 0xFF);
    }

    public int getPixel(int x, int y) {
        if (x < 0 || x >= 32) {
            return 0;
        }
        if (y < 0 || y >= 32) {
            return 0;
        }
        int p = 54 + x / 2 + y * 32 / 2;
        int c = x % 2 == 1 ? (this._data[p] & 0xF0) >> 4 : this._data[p] & 0xF;
        return this._colorTable[c];
    }

    private static int cook(int raw) {
        int x = (int)Math.floor((double)raw * 101.0 / 256.0);
        if (x < 0) {
            x = 0;
        }
        if (x > 100) {
            x = 100;
        }
        return x * 2 + 28;
    }

    private static int cooka(int rawAlpha) {
        int x = (int)Math.floor((double)rawAlpha * 101.0 / 256.0);
        if (x < 0) {
            x = 0;
        }
        if (x > 100) {
            x = 100;
        }
        return (int)Math.floor((double)x / 100.0 * 255.0 + 0.5);
    }

    private void copyEmblem(int fromIndex, int toIndex) {
        if (fromIndex < 0 || fromIndex >= 48) {
            return;
        }
        if (toIndex < 0 || toIndex >= 48) {
            return;
        }
        int fromOffset = fromIndex < 32 ? 54 + fromIndex * 6672 : 239366 + (fromIndex - 32) * 832;
        int toOffset = toIndex < 32 ? 54 + toIndex * 6672 : 239366 + (toIndex - 32) * 832;
        System.arraycopy(this._data, fromOffset, this._data, toOffset, 576);
    }

    public boolean setPixel(int x, int y, int r, int g, int b, int a) {
        boolean rc = true;
        if (x < 0 || x >= 32) {
            return false;
        }
        if (y < 0 || y >= 32) {
            return false;
        }
        r = VsDataImage.cook(r);
        g = VsDataImage.cook(g);
        b = VsDataImage.cook(b);
        a = VsDataImage.cooka(a);
        int c = (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0 | (a & 0xFF) << 24;
        int index = 0;
        if (a != 0) {
            Integer co = new Integer(c);
            if (this._colorMap.containsKey(co)) {
                index = (Integer)this._colorMap.get(co);
            } else if (this._ncolors < 16) {
                this._colorMap.put(co, new Integer(this._ncolors));
                index = this._ncolors++;
                this._colorTable[index] = c;
            } else {
                rc = false;
                index = 0;
            }
        }
        int p = 54 + x / 2 + y * 32 / 2;
        this._data[p] = x % 2 == 1 ? (byte)(this._data[p] & 0xF | index << 4) : (byte)(this._data[p] & 0xF0 | index);
        return rc;
    }
}

