/*
 * Decompiled with CFR 0.152.
 */
package jp.or.utmc.nasb.chp.carpe;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.TransferHandler;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import jp.or.utmc.nasb.ExtFileFilter;
import jp.or.utmc.nasb.Util;
import jp.or.utmc.nasb.chp.carpe.CarPE;

public class MainWindow
extends JFrame
implements ActionListener,
ItemListener {
    private static final String _ICON_IMAGE_FILE = "chp_icon16.png";
    private static final String _NO_IMAGE_FILE = "no_image.png";
    private static final String _BG_IMAGE_FILE = "carpe_bg.png";
    private static final String _LOAD_DIR_KEY = "loadDir";
    private static final String _SAVE_DIR_KEY = "saveDir";
    private static final String _OVERWRITE_CONFIRM_KEY = "overwriteConfirm";
    private static final long serialVersionUID = 0L;
    private JMenu _fileMenu;
    private JMenu _optionMenu;
    private JMenu _helpMenu;
    private JMenuItem _loadMI;
    private JMenuItem _saveMI;
    private JMenuItem _exitMI;
    private JRadioButtonMenuItem _transNoneMI;
    private JRadioButtonMenuItem _transTLMI;
    private JRadioButtonMenuItem _transTRMI;
    private JRadioButtonMenuItem _transBLMI;
    private JRadioButtonMenuItem _transBRMI;
    private JRadioButtonMenuItem _transBlackMI;
    private JRadioButtonMenuItem _transPurpleMI;
    private JCheckBoxMenuItem _overwriteMI;
    private JMenuItem _aboutMI;
    private JButton _loadB = this.createJButton("\u753b\u50cf\u8aad\u8fbc", null);
    private JButton _saveB = this.createJButton("\u30a8\u30f3\u30d6\u30ec\u30e0\u66f8\u51fa", null);
    private CarPE _app;
    private BufferedImage _image;
    private BufferedImage _convertedImage = new BufferedImage(32, 32, 2);
    private BufferedImage _noImage;
    private BufferedImage _bgImage;
    private JFileChooser _loadFC;
    private JFileChooser _saveFC;
    private Font _myFont;
    private Preferences _pref;
    private JPanel _mainPanel;
    static /* synthetic */ Class class$0;

    public MainWindow(CarPE app, String title) {
        super(title);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.or.utmc.nasb.chp.carpe.CarPE");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._noImage = Util.readBufferedImage(clazz, _NO_IMAGE_FILE);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("jp.or.utmc.nasb.chp.carpe.CarPE");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._bgImage = Util.readBufferedImage(clazz2, _BG_IMAGE_FILE);
        this._loadFC = new JFileChooser();
        this._saveFC = new JFileChooser();
        this._mainPanel = new JPanel(new BorderLayout()){
            private static final long serialVersionUID = 0L;

            public void paintComponent(Graphics g) {
                BufferedImage img = MainWindow.this._image == null ? MainWindow.this._noImage : MainWindow.this._convertedImage;
                int bw = this.getWidth();
                int iw = img.getWidth();
                int bh = this.getHeight() - 55;
                int ih = img.getHeight();
                g.drawImage(MainWindow.this._bgImage, 0, 0, null);
                g.drawImage(img, (bw - iw) / 2, (bh - ih) / 2 + 55, null);
            }
        };
        this._app = app;
        this.init();
    }

    private void init() {
        this.setSize(this._bgImage.getWidth(), this._bgImage.getHeight() + 50);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.or.utmc.nasb.chp.carpe.CarPE");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setIconImage(Util.readBufferedImage(clazz, _ICON_IMAGE_FILE));
        this._myFont = new Font(Util.getPreferedFontName(new String[]{"MS UI Gothic", "sansserif"}), 0, 14);
        this._loadB.setFont(this._myFont);
        this._saveB.setFont(this._myFont);
        this.setFont(this._myFont);
        this._mainPanel.setTransferHandler(new TransferHandler(){
            private static final long serialVersionUID = 0L;

            public boolean importData(JComponent c, Transferable t) {
                DataFlavor[] fs;
                List l;
                block6: {
                    l = null;
                    fs = t.getTransferDataFlavors();
                    if (fs != null) break block6;
                    return false;
                }
                try {
                    int i = 0;
                    while (i < fs.length) {
                        if (fs[i].isFlavorJavaFileListType()) {
                            l = (List)t.getTransferData(fs[i]);
                            break;
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    return false;
                }
                if (l != null && !l.isEmpty() && l.get(0) instanceof File) {
                    MainWindow.this.loadFile((File)l.get(0));
                    return true;
                }
                return false;
            }

            public boolean canImport(JComponent c, DataFlavor[] flavors) {
                if (flavors == null) {
                    return false;
                }
                int i = 0;
                while (i < flavors.length) {
                    if (flavors[i].isFlavorJavaFileListType()) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        });
        this._mainPanel.setToolTipText("\u3053\u3053\u306b\u753b\u50cf\u30d5\u30a1\u30a4\u30eb\u3092\u30c9\u30ed\u30c3\u30d7\u3067\u304d\u307e\u3059\u3002");
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("jp.or.utmc.nasb.chp.carpe.CarPE");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._pref = Preferences.userNodeForPackage(clazz2);
        this.createMenuBar();
        this.setDefaultCloseOperation(3);
        JPanel p = new JPanel(new GridLayout(1, 2));
        this.getContentPane().add((Component)p, "South");
        this.getContentPane().add((Component)this._mainPanel, "Center");
        p.add(this._loadB);
        p.add(this._saveB);
        this.setImage(null);
        String loadDir = Util.getCWD();
        String saveDir = Util.getCWD();
        loadDir = this._pref.get(_LOAD_DIR_KEY, loadDir);
        saveDir = this._pref.get(_SAVE_DIR_KEY, saveDir);
        this._loadFC.setCurrentDirectory(new File(loadDir));
        this._loadFC.addChoosableFileFilter(new ExtFileFilter(new String[]{"png", "gif", "jpg", "bmp"}));
        this._saveFC.setCurrentDirectory(new File(saveDir));
        this._saveFC.addChoosableFileFilter(new ExtFileFilter(new String[]{"chp"}));
    }

    public void setImage(BufferedImage image) {
        this._image = image;
        this._saveB.setEnabled(image != null);
        this._saveMI.setEnabled(image != null);
        if (this._image == null) {
            this.setOptionEnabled(false);
        } else {
            int h;
            int w = this._image.getWidth();
            if (w > 32) {
                w = 32;
            }
            if ((h = this._image.getHeight()) > 32) {
                h = 32;
            }
            int y = 0;
            while (y < h) {
                int x = 0;
                while (x < w) {
                    int color = this._image.getRGB(x, y);
                    if ((color & 0xFF000000) == 0) {
                        this.setOptionEnabled(false);
                        return;
                    }
                    ++x;
                }
                ++y;
            }
            this.setOptionEnabled(true);
        }
    }

    private void createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu m = this._fileMenu = new JMenu("File");
        menuBar.add(this._fileMenu);
        this._loadMI = new JMenuItem("Load", 76);
        m.add(this._loadMI);
        this._saveMI = new JMenuItem("Save", 83);
        m.add(this._saveMI);
        m.addSeparator();
        this._exitMI = new JMenuItem("Exit", 88);
        m.add(this._exitMI);
        m = this._optionMenu = new JMenu("Option");
        menuBar.add(this._optionMenu);
        this._transNoneMI = new JRadioButtonMenuItem("\u900f\u660e\u8272\u3078\u306e\u7f6e\u63db\uff1a\u7121\u3057", true);
        m.add(this._transNoneMI);
        this._transTLMI = new JRadioButtonMenuItem("\u900f\u660e\u8272\u3078\u306e\u7f6e\u63db\uff1a\u5de6\u4e0a");
        m.add(this._transTLMI);
        this._transTRMI = new JRadioButtonMenuItem("\u900f\u660e\u8272\u3078\u306e\u7f6e\u63db\uff1a\u53f3\u4e0a");
        m.add(this._transTRMI);
        this._transBLMI = new JRadioButtonMenuItem("\u900f\u660e\u8272\u3078\u306e\u7f6e\u63db\uff1a\u5de6\u4e0b");
        m.add(this._transBLMI);
        this._transBRMI = new JRadioButtonMenuItem("\u900f\u660e\u8272\u3078\u306e\u7f6e\u63db\uff1a\u53f3\u4e0b");
        m.add(this._transBRMI);
        this._transBlackMI = new JRadioButtonMenuItem("\u900f\u660e\u8272\u3078\u306e\u7f6e\u63db\uff1a\u9ed2");
        m.add(this._transBlackMI);
        this._transPurpleMI = new JRadioButtonMenuItem("\u900f\u660e\u8272\u3078\u306e\u7f6e\u63db\uff1a\u7d2b");
        m.add(this._transPurpleMI);
        m.addSeparator();
        boolean f = this._pref.getBoolean(_OVERWRITE_CONFIRM_KEY, true);
        this._overwriteMI = new JCheckBoxMenuItem("\u4e0a\u66f8\u304d\u306e\u78ba\u8a8d", f);
        m.add(this._overwriteMI);
        ButtonGroup g = new ButtonGroup();
        g.add(this._transNoneMI);
        g.add(this._transTLMI);
        g.add(this._transTRMI);
        g.add(this._transBLMI);
        g.add(this._transBRMI);
        g.add(this._transBlackMI);
        g.add(this._transPurpleMI);
        m = this._helpMenu = new JMenu("Help");
        menuBar.add(this._helpMenu);
        this._aboutMI = new JMenuItem("About", 65);
        m.add(this._aboutMI);
        MenuListener ml = new MenuListener(){

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
            }

            public void menuSelected(MenuEvent e) {
                if (e.getSource() != MainWindow.this._fileMenu && e.getSource() != MainWindow.this._optionMenu) {
                    e.getSource();
                }
            }
        };
        int i = 0;
        while (i < menuBar.getMenuCount()) {
            JMenu menu = menuBar.getMenu(i);
            menu.addMenuListener(ml);
            menu.setMnemonic(menu.getText().charAt(0));
            int j = 0;
            while (j < menu.getItemCount()) {
                JMenuItem mi = menu.getItem(j);
                if (mi != null) {
                    if (mi.getMnemonic() == 0) {
                        mi.setMnemonic(mi.getText().charAt(0));
                    }
                    if (mi instanceof JRadioButtonMenuItem || mi instanceof JCheckBoxMenuItem) {
                        mi.addItemListener(this);
                    } else {
                        mi.addActionListener(this);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private JButton createJButton(String text, Icon icon) {
        JButton b;
        if (icon == null) {
            b = new JButton(text);
        } else {
            b = new JButton(icon);
            b.setActionCommand(text);
            b.setToolTipText(text);
            b.setMargin(new Insets(0, 0, 0, 0));
        }
        b.addActionListener(this);
        return b;
    }

    public void showLoadFileDialog() {
        int selected = this._loadFC.showOpenDialog(this);
        if (selected == 0) {
            this._pref.put(_LOAD_DIR_KEY, this._loadFC.getCurrentDirectory().getPath());
            final File file = this._loadFC.getSelectedFile();
            this.repaint();
            Graphics g = this.getGraphics();
            this.update(g);
            g.dispose();
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    MainWindow.this.loadFile(file);
                }
            });
        }
    }

    public void showSaveFileDialog() {
        File dir = this._saveFC.getCurrentDirectory();
        this._saveFC.setSelectedFile(new File(dir, "EMBLEM.CHP"));
        int selected = this._saveFC.showSaveDialog(this);
        if (selected == 0) {
            this._pref.put(_SAVE_DIR_KEY, this._saveFC.getCurrentDirectory().getPath());
            final File file = this._saveFC.getSelectedFile();
            if (this._overwriteMI.isSelected() && file.exists() && JOptionPane.showConfirmDialog(this, "\u30d5\u30a1\u30a4\u30eb " + file.getName() + " \u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059\u3002\u4e0a\u66f8\u304d\u3057\u307e\u3059\u304b?", "\u4e0a\u66f8\u304d\u306e\u78ba\u8a8d", 2) != 0) {
                return;
            }
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    MainWindow.this.saveFile(file);
                }
            });
        }
    }

    private void setOptionEnabled(boolean enabled) {
        this._transNoneMI.setEnabled(enabled);
        this._transTRMI.setEnabled(enabled);
        this._transTLMI.setEnabled(enabled);
        this._transBRMI.setEnabled(enabled);
        this._transBLMI.setEnabled(enabled);
        this._transBlackMI.setEnabled(enabled);
        this._transPurpleMI.setEnabled(enabled);
        if (!enabled) {
            this._transNoneMI.setSelected(true);
        }
    }

    private void updateImage() {
        int mode = this.getTransparentMode();
        this._app.setTransparentReplaceMode(mode);
        if (this._image != null) {
            if (!this._app.setImage(this._image)) {
                Util.showError(this._app.getErrorMessage(), this);
                this._image = null;
            }
            int w = this._convertedImage.getWidth();
            int h = this._convertedImage.getHeight();
            int y = 0;
            while (y < h) {
                int x = 0;
                while (x < w) {
                    this._convertedImage.setRGB(x, y, this._app.getPixel(x, y));
                    ++x;
                }
                ++y;
            }
        }
        this.repaint();
        Graphics g = this.getGraphics();
        if (g != null) {
            this.update(g);
            g.dispose();
        }
    }

    public void loadFile(File file) {
        Util.showBusy(this, true);
        this.setImage(this._app.readImageFile(file));
        if (this._image == null) {
            Util.showError(this._app.getErrorMessage(), this);
        } else if (this._app.getWarningMessage() != null) {
            Util.showWarning(this._app.getWarningMessage(), this);
            if (!this._app.setImage(this._image)) {
                Util.showError(this._app.getErrorMessage(), this);
                this._image = null;
            } else if (this._app.getWarningMessage() != null) {
                Util.showWarning(this._app.getWarningMessage(), this);
            }
        }
        this.updateImage();
        Util.showBusy(this, false);
    }

    public void saveFile(File file) {
        Util.showBusy(this, true);
        if (this._app.writeEmblemFile(file)) {
            Util.showInfo("\u30a8\u30f3\u30d6\u30ec\u30e0\u304c\u5bfe\u6226\u7528\u30bb\u30fc\u30d6\u30c7\u30fc\u30bf " + file.getName() + " \u306b\u51fa\u529b\u3055\u308c\u307e\u3057\u305f\u3002", this);
        } else {
            Util.showError(this._app.getErrorMessage(), this);
        }
        Util.showBusy(this, false);
    }

    private int getTransparentMode() {
        int mode = 0;
        if (this._transTLMI.isSelected()) {
            mode = 1;
        } else if (this._transTRMI.isSelected()) {
            mode = 2;
        } else if (this._transBLMI.isSelected()) {
            mode = 3;
        } else if (this._transBRMI.isSelected()) {
            mode = 4;
        } else if (this._transBlackMI.isSelected()) {
            mode = 5;
        } else if (this._transPurpleMI.isSelected()) {
            mode = 6;
        }
        return mode;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._loadMI || e.getSource() == this._loadB) {
            this.showLoadFileDialog();
            return;
        }
        if (e.getSource() == this._saveMI || e.getSource() == this._saveB) {
            this.showSaveFileDialog();
            return;
        }
        if (e.getSource() == this._exitMI) {
            this.dispose();
            System.exit(0);
            return;
        }
        if (e.getSource() == this._aboutMI) {
            String[] msg = new String[]{"CarPE", " ver. 0.2.0", " Copyright (C) 2006 KOBAYASHI Kenichi (nas_B)", "", "MIT\u30e9\u30a4\u30bb\u30f3\u30b9\u306b\u57fa\u3065\u304d\u3001\u7121\u4fdd\u8a3c\u3001\u914d\u5e03\u81ea\u7531"};
            JOptionPane.showMessageDialog(this, msg, "About", 1, null);
            return;
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getItemSelectable() == this._overwriteMI) {
            this._pref.putBoolean(_OVERWRITE_CONFIRM_KEY, this._overwriteMI.isSelected());
        } else {
            if (e.getStateChange() != 1) {
                return;
            }
            this.updateImage();
        }
    }

    static /* synthetic */ JMenu access$6(MainWindow mainWindow) {
        return mainWindow._helpMenu;
    }
}

