/*
 * Decompiled with CFR 0.152.
 */
package jp.or.utmc.nasb;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;

public class Util {
    public static String getCWD() {
        String cwd;
        try {
            cwd = System.getProperty("user.dir");
        }
        catch (SecurityException e) {
            cwd = null;
        }
        catch (IllegalArgumentException e) {
            cwd = null;
        }
        return cwd;
    }

    public static Component getAncestor(Component c) {
        Container parent;
        while ((parent = c.getParent()) != null) {
            c = parent;
        }
        return c;
    }

    public static void changeCursor(Component c, int type) {
        Cursor cursor = Cursor.getPredefinedCursor(type);
        Util.getAncestor(c).setCursor(cursor);
    }

    public static String toHtml(String str) {
        return Util.toHtml(str, "");
    }

    public static String toHtml(String str, String pre) {
        return Util.toHtml(str, pre, false);
    }

    public static String toHtml(String str, String pre, boolean br) {
        StringBuffer buf = new StringBuffer("<html>" + pre);
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (ch == '<') {
                buf.append("&lt;");
            } else if (ch == '>') {
                buf.append("&gt;");
            } else if (ch == '&') {
                buf.append("&amp;");
            } else if (br) {
                int skip = -1;
                if (ch == '\n') {
                    skip = 0;
                } else if (str.startsWith("\r\n", i)) {
                    skip = 1;
                } else if (ch == '\r') {
                    skip = 0;
                } else if (str.startsWith("\\n", i)) {
                    skip = 1;
                }
                if (skip >= 0) {
                    buf.append("<br>");
                    i += skip;
                } else {
                    buf.append(ch);
                }
            } else {
                buf.append(ch);
            }
            ++i;
        }
        return buf.toString();
    }

    public static boolean find(Object[] array, Object obj) {
        int i = 0;
        while (i < array.length) {
            if (array[i] == obj) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String stripDir(String fileNameWithDir) {
        int idx = fileNameWithDir.lastIndexOf(System.getProperty("file.separator"));
        try {
            return fileNameWithDir.substring(idx + 1);
        }
        catch (IndexOutOfBoundsException e) {
            return fileNameWithDir;
        }
    }

    public static String fontToString(Font font) {
        return String.valueOf(font.getName()) + "-" + (font.isBold() ? "bold" : "") + (font.isItalic() ? "italic" : "") + "-" + font.getSize();
    }

    public static Font stringToFont(String str) {
        if (str == null) {
            return null;
        }
        int idx2 = -1;
        int type = 0;
        int size = 12;
        int idx3 = str.lastIndexOf(45);
        if (idx3 > 0) {
            idx2 = str.lastIndexOf(45, idx3 - 1);
        }
        if (idx3 >= 0) {
            try {
                size = Integer.parseInt(str.substring(idx3 + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (idx2 >= 0) {
            String typeStr = str.substring(idx2 + 1, idx3);
            if (typeStr.equals("bold")) {
                type = 1;
            } else if (typeStr.equals("italic")) {
                type = 2;
            } else if (typeStr.equals("bolditalic")) {
                type = 3;
            }
        }
        if (idx2 < 0) {
            idx2 = idx3 >= 0 ? idx3 : str.length();
        }
        return new Font(str.substring(0, idx2), type, size);
    }

    public static int atoi(String str) {
        int n = 0;
        try {
            str = str.trim().toLowerCase();
            n = str.startsWith("0x") ? Integer.parseInt(str.substring(2), 16) : Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public static double atof(String str) {
        double n = 0.0;
        try {
            n = Double.parseDouble(str);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public static double reminder(double a, double b) {
        double n = Math.floor(a / b);
        return a - n * b;
    }

    public static String escapeForXML(String src) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < src.length()) {
            char ch = src.charAt(i);
            if (ch == '&') {
                buf.append("&amp;");
            } else if (ch == '<') {
                buf.append("&lt;");
            } else if (ch == '>') {
                buf.append("&gt;");
            } else if (ch == '\'') {
                buf.append("&apos;");
            } else if (ch == '\"') {
                buf.append("&quot;");
            } else {
                buf.append(ch);
            }
            ++i;
        }
        return buf.toString();
    }

    public static int[] toIntArray(Collection collectionOfInteger) {
        int[] array = new int[collectionOfInteger.size()];
        int idx = 0;
        Iterator it = collectionOfInteger.iterator();
        while (it.hasNext()) {
            array[idx++] = (Integer)it.next();
        }
        return array;
    }

    public static ArrayList toIntegerArrayList(int[] array) {
        ArrayList<Integer> list = new ArrayList<Integer>(array.length);
        int i = 0;
        while (i < array.length) {
            list.add(new Integer(array[i]));
            ++i;
        }
        return list;
    }

    public static void uniq(Collection c) {
        if (c.size() > 1) {
            Iterator it = c.iterator();
            Object prev = it.next();
            while (it.hasNext()) {
                Object cur = it.next();
                if (prev.equals(cur)) {
                    it.remove();
                    continue;
                }
                prev = cur;
            }
        }
    }

    private static Object splitMessage(String message) {
        String[] ms = message.split("\n");
        if (ms.length == 1) {
            return message;
        }
        return ms;
    }

    public static void showInfo(String message) {
        Util.showInfo(message, null);
    }

    public static void showInfo(String message, Component parent) {
        JOptionPane.showMessageDialog(parent, Util.splitMessage(message), "Information", 1);
    }

    public static void showWarning(String message) {
        Util.showWarning(message, null);
    }

    public static void showWarning(String message, Component parent) {
        JOptionPane.showMessageDialog(parent, Util.splitMessage(message), "Warning", 2);
    }

    public static void showError(String message) {
        Util.showError(message, null);
    }

    public static void showError(String message, Component parent) {
        JOptionPane.showMessageDialog(parent, Util.splitMessage(message), "Error", 0);
    }

    public static void showBusy(Component component, boolean busy) {
        if (busy) {
            Util.changeCursor(component, 3);
        } else {
            Util.changeCursor(component, 0);
        }
    }

    public static BufferedImage readBufferedImage(Class aClass, String resourceName) {
        try {
            BufferedImage image = ImageIO.read(aClass.getResource(resourceName));
            return image;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getPreferedFontName(String[] candidates) {
        if (candidates == null) {
            return "SansSerif";
        }
        String[] fs = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        int i = 0;
        while (i < candidates.length) {
            int j = 0;
            while (j < fs.length) {
                if (candidates[i].compareToIgnoreCase(fs[j]) == 0) {
                    return candidates[i];
                }
                ++j;
            }
            ++i;
        }
        return "SansSerif";
    }

    public static void main(String[] args) {
        System.out.println(new Font("SanSerif", 0, 10));
        System.out.println(new Font("SanSerif", 1, 10));
        System.out.println(new Font("SanSerif", 2, 10));
        System.out.println(new Font("SanSerif", 3, 10));
    }
}

