/*
 * Decompiled with CFR 0.152.
 */
package jp.or.utmc.nasb;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.filechooser.FileFilter;

public class ExtFileFilter
extends FileFilter {
    private String desc = null;
    private HashSet set = new HashSet();
    private boolean acceptsDir = true;

    public ExtFileFilter(String[] exts, String desc) {
        int i = 0;
        while (i < exts.length) {
            this.addExt(exts[i]);
            ++i;
        }
        this.setDescription(desc);
    }

    public ExtFileFilter(String[] exts) {
        this(exts, null);
    }

    public ExtFileFilter(String ext, String desc) {
        this.addExt(ext);
        this.setDescription(desc);
    }

    public ExtFileFilter(String ext) {
        this(ext, null);
    }

    public ExtFileFilter() {
    }

    public String getDescription() {
        if (this.desc != null) {
            return this.desc;
        }
        if (this.set.size() == 0) {
            return "Nothing";
        }
        StringBuffer buf = new StringBuffer();
        int n = 0;
        Iterator i = this.set.iterator();
        while (i.hasNext()) {
            String ext = ((String)i.next()).toUpperCase();
            if (n > 0) {
                if (i.hasNext()) {
                    buf.append(", ");
                } else {
                    buf.append(" & ");
                }
            }
            buf.append(ext);
            ++n;
        }
        buf.append(" files");
        return buf.toString();
    }

    public void setDescription(String desc) {
        this.desc = desc;
    }

    public void addExt(String ext) {
        this.set.add(ext.toLowerCase());
    }

    public void setAcceptsDir(boolean acceptsDir) {
        this.acceptsDir = acceptsDir;
    }

    public boolean accept(File f) {
        if (this.acceptsDir && f.isDirectory()) {
            return true;
        }
        String ext = f.getName().toLowerCase();
        Iterator i = this.set.iterator();
        while (i.hasNext()) {
            if (!ext.endsWith("." + (String)i.next())) continue;
            return true;
        }
        return false;
    }
}

