/** ݒ_CAO
 */
/*
 * Copyright (c) 2000-2005, 2007 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#include <vcl.h>
#include <Registry.hpp>
#include <memory>
#pragma hdrstop

#include "PlayerUnit.h"
#include "OptionUnit.h"
#include "ifmmedia.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

//---------------------------------------------------------------------------
#ifdef SetDlgH
__fastcall TDialogForm::TDialogForm(HWND ParentWindow)
    : TSetDlgForm(ParentWindow)
#else
__fastcall TDialogForm::TDialogForm(TComponent* Owner)
    : TForm(Owner)
#endif
{
  // Jɑ̃^uANeBuɂĂ邩Ȃ
  OptionPageControl->ActivePage = PlayerTabSheet ;
}
//---------------------------------------------------------------------------
void __fastcall TDialogForm::FormInit(void)
{
/** _CAȌs
 */
  AnsiString user_ext ;
  g_var.get( &Var, user_ext ) ;
	PlayerFormPosX = Var.option[ OPTION_WindowPosX ] ;
  PlayerFormPosY = Var.option[ OPTION_WindowPosY ] ;

  MemoryPlayCheckBox->Checked = Var.option[ OPTION_MemoryPlay ] ;
	ReturnErrCheckBox->Checked  = Var.option[ OPTION_ReturnErr ] ;
	StayOnTopCheckBox->Checked  = Var.option[ OPTION_StayOnTop ] ;
	NoActiveCheckBox->Checked   = Var.option[ OPTION_NoActive ] ;
  PlayerPosCheckBox->Checked  = Var.option[ OPTION_WindowPos ] ;

	PreviewCheckBox->Checked    = Var.option[ OPTION_PreviewMovie ] ;
	PreviewPos1Edit->Text       = Var.option[ OPTION_PreviewPos1 ] ;
	PreviewPos2Edit->Text       = Var.option[ OPTION_PreviewPos2 ] ;
  MinimizedCheckBox->Checked  = Var.option[ OPTION_Minimized ] ;
	MovieSizeRadioGroup->ItemIndex = Var.option[ OPTION_MovieSize ] ;
	CenterCheckBox->Checked     = Var.option[ OPTION_MovieCenter ] ;

	SusieOnlyCheckBox->Checked  = Var.option[ OPTION_SusieOnly ] ;
	PlayByViXCheckBox->Checked  = Var.option[ OPTION_PlayByViX ] ;
	PlayByViXCheckBox->Enabled  = Var.option[ OPTION_IsViX ] ; //ĂяoViXłȂ΃O[AEg
  DebugCheckBox->Checked      = Var.option[ OPTION_DebugMode ] ;

  for (int i=0; i < FILETYPE_COUNT; i++)
  {
    SupportCheckListBox->Checked[i] = Var.playable[i] ;
  }

  std::auto_ptr<TStringList> sl( new TStringList() ) ;
  ::getSusieCompatiAppName( sl.get() ) ;
  AppListBox->Items->AddStrings( sl.get() ) ;

  UserDefExtEdit->Text = user_ext ;
}
//---------------------------------------------------------------------------
void __fastcall TDialogForm::CancelButtonClick(TObject *Sender)
{
/** ݒύXȂ
 */
  Close() ;
}
//---------------------------------------------------------------------------
void __fastcall TDialogForm::OKButtonClick(TObject *Sender)
{
/** ݒύXĕۑ
 */
	Var.option[ OPTION_MemoryPlay ] = MemoryPlayCheckBox->Checked ;
	Var.option[ OPTION_ReturnErr ]  = ReturnErrCheckBox->Checked ;
	Var.option[ OPTION_StayOnTop ]  = StayOnTopCheckBox->Checked ;
	Var.option[ OPTION_NoActive ]   = NoActiveCheckBox->Checked ;
	Var.option[ OPTION_WindowPos ]  = PlayerPosCheckBox->Checked ;
	Var.option[ OPTION_WindowPosX ] = PlayerFormPosX ;
  Var.option[ OPTION_WindowPosY ] = PlayerFormPosY ;

  if ( (MovieFormHeight != 0) && (MovieFormWidth != 0) )
  {
		Var.option[ OPTION_MoviePosX ]   = MoviewFormPosX ;
		Var.option[ OPTION_MoviePosY ]   = MoviewFormPosY ;
		Var.option[ OPTION_MovieHeight ] = MovieFormHeight ;
		Var.option[ OPTION_MovieWidth ]  = MovieFormWidth ;
	}

	Var.option[ OPTION_PreviewMovie ] = PreviewCheckBox->Checked ;
	Var.option[ OPTION_PreviewPos1 ]  = PreviewPos1Edit->Text.ToIntDef(0) ;
	Var.option[ OPTION_PreviewPos2 ]  = PreviewPos2Edit->Text.ToIntDef(5) ;
	Var.option[ OPTION_Minimized ]    = MinimizedCheckBox->Checked ;
	Var.option[ OPTION_MovieSize ]    = MovieSizeRadioGroup->ItemIndex ;
	Var.option[ OPTION_MovieCenter ]  = CenterCheckBox->Checked ;

	Var.option[ OPTION_SusieOnly ] = SusieOnlyCheckBox->Checked ;
	Var.option[ OPTION_PlayByViX ] = PlayByViXCheckBox->Checked ;
	Var.option[ OPTION_DebugMode ] = DebugCheckBox->Checked ;

	for (int i=0; i < FILETYPE_COUNT; i++)
	{
    Var.playable[i] = SupportCheckListBox->Checked[i] ;
  }

  g_var.set( &Var, UserDefExtEdit->Text ) ;


  /* WXgɕۑ */
	std::auto_ptr<TRegistry> reg( new TRegistry ) ;
	//reg->RootKey = HKEY_CURRENT_USER ;
	bool opened = reg->OpenKey( "\\Software\\shimitei\\ifmm", true ) ;
  if ( ! opened )
  {
    ::ShowMessage( "WXgG[!\nݒۑł܂B" ) ;
    return ;
  }

	reg->WriteBool( "Memory",    Var.option[ OPTION_MemoryPlay ] ) ;
	reg->WriteBool( "Error",     Var.option[ OPTION_ReturnErr ] ) ;
  reg->WriteBool( "StayOnTop", Var.option[ OPTION_StayOnTop ] ) ;
	reg->WriteBool( "NoActive",  Var.option[ OPTION_NoActive ] ) ;
	reg->WriteBool( "WindowPos", Var.option[ OPTION_WindowPos ] ) ;
	reg->WriteInteger( "WindowPosX", Var.option[ OPTION_WindowPosX ] ) ;
  reg->WriteInteger( "WindowPosY", Var.option[ OPTION_WindowPosY ] ) ;

  if ( (MovieFormHeight != 0) && (MovieFormWidth != 0) )
  {
		reg->WriteInteger( "MoviePosX",   Var.option[ OPTION_MoviePosX ] ) ;
		reg->WriteInteger( "MoviePosY",   Var.option[ OPTION_MoviePosY ] ) ;
		reg->WriteInteger( "MovieHeight", Var.option[ OPTION_MovieHeight ] ) ;
    reg->WriteInteger( "MovieWidth",  Var.option[ OPTION_MovieWidth ] ) ;
  }

	reg->WriteBool( "PreviewMovieFrame", Var.option[ OPTION_PreviewMovie ] ) ;
	reg->WriteInteger( "PreviewPos1", Var.option[ OPTION_PreviewPos1 ] ) ;
  reg->WriteInteger( "PreviewPos2", Var.option[ OPTION_PreviewPos2 ] ) ;
	reg->WriteBool( "Minimized", Var.option[ OPTION_Minimized ] ) ;
	reg->WriteInteger( "MovieSize", Var.option[ OPTION_MovieSize ] ) ;
	reg->WriteBool( "MovieCenter", Var.option[ OPTION_MovieCenter ] ) ;

	reg->WriteBool( "SusieOnly", Var.option[ OPTION_SusieOnly ] ) ;
	reg->WriteBool( "PlayByViX", Var.option[ OPTION_PlayByViX ] ) ;
	reg->WriteBool( "Debug", Var.option[ OPTION_DebugMode ] ) ;

	reg->WriteBool( "WAVE", Var.playable[ WAVEPLAY ] ) ;
	reg->WriteBool( "MIDI", Var.playable[ MIDIPLAY ] ) ;
	reg->WriteBool( "AVI",  Var.playable[ AVIPLAY ] ) ;
	reg->WriteBool( "AIFF", Var.playable[ AIFFPLAY ] ) ;
	reg->WriteBool( "MOV",  Var.playable[ MOVPLAY ] ) ;
	reg->WriteBool( "MPEG", Var.playable[ MPEGPLAY ] ) ;
	reg->WriteBool( "MPA",  Var.playable[ MPAPLAY ] ) ;
  reg->WriteBool( "AU",   Var.playable[ AUPLAY ] ) ;
	reg->WriteBool( "OGG",  Var.playable[ OGGPLAY ] ) ;
	reg->WriteBool( "RM",   Var.playable[ RMPLAY ] ) ;
  reg->WriteBool( "USER", Var.playable[ USERPLAY ] ) ;

  reg->WriteString( "UserDefExt", UserDefExtEdit->Text ) ;

  Close() ;
}
//---------------------------------------------------------------------------
void __fastcall TDialogForm::PlayerPosButtonClick(TObject *Sender)
{
/** v[[̃EBhEʒu̐ݒ
 * v[[EBhEJāAƂ̈ʒuݒ肷
 */
  std::auto_ptr<TPlayForm> form( new TPlayForm(this) ) ;

  form->Left = 0 ;
  form->Top  = 0 ;

  form->ShowModal() ;

	PlayerFormPosX = form->Left ;
  PlayerFormPosY = form->Top ;
}
//---------------------------------------------------------------------------
void __fastcall TDialogForm::CustomButtonClick(TObject *Sender)
{
/** v[[̃EBhEʒuƃTCY̐ݒ
 * v[[EBhEJāAƂ̈ʒuƃTCYݒ肷
 */
  std::auto_ptr<TPlayForm> form( new TPlayForm(this) ) ;

  form->PopupMenu = NULL ;
  form->ScrollBox->OnClick = NULL ;
  form->OnResize = form->FormResizeEx ;
	form->BorderStyle = bsSizeable ;

#define DEFAULT_WIDTH 260
	form->ClientHeight += Screen->WorkAreaHeight * 2 / 3 +2 ;
	form->ClientWidth  += Screen->WorkAreaWidth  * 2 / 3 +2 - DEFAULT_WIDTH ;
	form->Top  = (Screen->WorkAreaHeight - form->Height) /2 ;
	form->Left = (Screen->WorkAreaWidth - form->Width) /2 ;

	form->ShowModal() ;

	MoviewFormPosX = form->Left ;
	MoviewFormPosY = form->Top ;
	MovieFormHeight = form->MoviePanel->Height -2 ;
	MovieFormWidth  = form->MoviePanel->Width  -2 ;
}
//---------------------------------------------------------------------------
void __fastcall TDialogForm::SupportLabelDblClick(TObject *Sender)
{
// BIvVôP
	this->Tag++ ;
	if ( this->Tag > 5 )
	{
		DebugCheckBox->Visible = true ;
	}
}
//---------------------------------------------------------------------------
void __fastcall TDialogForm::SupportLabelMouseDown(TObject *Sender,
			TMouseButton Button, TShiftState Shift, int X, int Y)
{
// BIvVôQ
  if ( Shift.Contains( ssShift ) && Shift.Contains( ssRight ) )
  {
    DebugCheckBox->Enabled = true ;
	}
}
//---------------------------------------------------------------------------
void __fastcall TDialogForm::AppAddButtonClick(TObject *Sender)
{
/** Susie݊AvWXgɓo^
 */
  std::auto_ptr<TRegistry> reg( new TRegistry ) ;
  //reg->RootKey = HKEY_CURRENT_USER ;
  bool opened = reg->OpenKey( "\\Software\\shimitei\\ifmm\\SusieCompati", true ) ;

  if ( opened )
  {
		AnsiString dataname = AppEdit->Text ;
		if ( ! dataname.IsEmpty() )
		{
			reg->WriteInteger( dataname, 0 ) ;
			AppListBox->Items->Add( dataname ) ;
			AppEdit->Text = "" ;
		}
	}
	else
	{
		::ShowMessage( "WXgI[vG[I" ) ;
	}
}
//---------------------------------------------------------------------------
void __fastcall TDialogForm::AppDelButtonClick(TObject *Sender)
{
/** Susie݊o^AvWXg폜
 */
  int index = AppListBox->ItemIndex ;
  if ( index == -1 ) return ;

  std::auto_ptr<TRegistry> reg( new TRegistry ) ;
  //reg->RootKey = HKEY_CURRENT_USER ;
  bool opened = reg->OpenKey( "\\Software\\shimitei\\ifmm\\SusieCompati", false ) ;
  if ( opened )
	{
		if ( reg->DeleteValue( AppListBox->Items->Strings[index] ) )
		{
			AppListBox->Items->Delete( index ) ;
		}
		else
		{
			::ShowMessage( "폜Ɏs܂B" ) ;
		}
	}
	else
	{
		::ShowMessage( "WXgI[vG[I" ) ;
	}
}
//---------------------------------------------------------------------------


