/*
 * This source herein may be modified and/or distributed by anybody who
 * so desires, with the following restrictions:
 *    1.)  No portion of this notice shall be removed.
 *    2.)  Credit shall not be taken for the creation of this source.
 *    3.)  This code is not to be traded, sold, or used for personal
 *         gain or profit.
 */

#define VER_MAJOR 0
#define VER_MINOR 4
#define VER_PATCH 9
#define VER_BUILD 0

#define VERSION ( (VER_MAJOR << 24) + (VER_MINOR << 16) + (VER_PATCH << 8) + VER_BUILD )

#ifdef DEBUG
#define ENABLE_DEBUG_PRINT
#define ENABLE_ASSERT_PRINT
#define EXCEPTION_GUARD
#else
#define EXCEPTION_DIALOG
#endif

#ifdef EXCEPTION_GUARD
//	#define DISPLAY_FUNCTION_CALL
	#define FUNCTION_CALLED(str) String functionName=(str);try{
	#define FUNCTION_RETURN() }catch(Exception e){System.out.println(functionName);System.out.println(e.toString());}
#else
	#ifdef EXCEPTION_DIALOG
		private static String functionName;
		#define FUNCTION_CALLED(str) functionName=(str)
		#define FUNCTION_RETURN() 
	#else
		#define FUNCTION_CALLED(str) 
		#define FUNCTION_RETURN() 
	#endif
#endif

#ifdef DISPLAY_FUNCTION_CALL
#define FUNCTION_PRINT(str) System.out.println(str)
#else
#define FUNCTION_PRINT(str)
#endif

#ifdef ENABLE_DEBUG_PRINT
#define DEBUG_PRINT(str) System.out.println(str)
#define DEBUG_FLOOR_PRINT() debugPrintFloor()
#else
#define DEBUG_PRINT(str)
#define DEBUG_FLOOR_PRINT() 
#endif

#ifdef ENABLE_ASSERT_PRINT
#define ASSERT_PRINT(b,str) {if (b) System.out.println(str);}
#else
#define ASSERT_PRINT(b,str)
#endif

#ifdef WIZARD
#define ENABLE_WIZARD_PRINT
#define WIZARD_PRINT(str) System.out.println(str)
#else
#define WIZARD_PRINT(str)
#endif

#if defined(DEBUG) || defined(WIZARD)
#define DEBUG_OBJECT_PRINT(x,y,obj) debugPrintObject(x,y,obj)
#else
#define DEBUG_OBJECT_PRINT(x,y,obj) 
#endif


#define IS_TRUE(i) ( (i) != 0 )
#define IS_FALSE(i) ( (i) == 0 )
#define ABSINT(i) ( ((i) < 0) ? -(i) : (i) )


/* MIDP and DoJa function wrap */
#ifdef MIDP
#define DRAWSTRING(str, x, y) drawString(str, x, y, Graphics.BASELINE | Graphics.LEFT)
#define DRAWCHAR(c, x, y) drawChar(c, x, y, Graphics.BASELINE | Graphics.LEFT)
#define DRAWCHARS(data, offset, length, x, y) drawChars(data, offset, length, x, y, Graphics.BASELINE | Graphics.LEFT)
#define DRAWIMAGE(img, x, y) drawImage(img, x, y, Graphics.LEFT | Graphics.TOP)
#define QUIT() midlet.quit()
#endif
#ifdef DOJA
#define DRAWSTRING(str, x, y) drawString(str, x, y)
#define DRAWCHARS(data, offset, length, x, y) drawChars(data, x, y, offset, length)
#define DRAWIMAGE(img, x, y) drawImage(img, x, y)
#define QUIT() IApplication.getCurrentApp().terminate()
#endif

/* random */
	private static Random random;

/* Graphics */
#ifdef MIDP
#define REPAINT()	repaint()
#endif
#ifdef DOJA
#define REPAINT()	paint(getGraphics())
#endif
#define REDRAW()	{viewRedraw();REPAINT();}

//ColorCode
#ifdef MIDP			//0x00RRGGBB
#define COLOR_BLACK		0
#define COLOR_BLUE		0x0000ff
#define COLOR_CYAN		0x00ffff
#define COLOR_DARKGRAY	0x404040
#define COLOR_GRAY		0x808080
#define COLOR_GREEN		0x00ff00
#define COLOR_LIGHTGRAY	0xc0c0c0
#define COLOR_MAGENTA	0xff00ff
#define COLOR_ORANGE	0xffc800
#define COLOR_PINK		0xffafaf
#define COLOR_RED		0xff0000
#define COLOR_WHITE		0xffffff
#define COLOR_YELLOW	0xffff00
#endif
#ifdef DOJA
#define COLOR_BLACK		Graphics.getColorOfName(Graphics.BLACK)
#define COLOR_BLUE		Graphics.getColorOfName(Graphics.BLUE)
#define COLOR_CYAN		Graphics.getColorOfRGB(0x00, 0xff, 0xff)
#define COLOR_DARKGRAY	Graphics.getColorOfRGB(0x40, 0x40, 0x40)
#define COLOR_GRAY		Graphics.getColorOfName(Graphics.GRAY)
#define COLOR_GREEN		Graphics.getColorOfName(Graphics.GREEN)
#define COLOR_LIGHTGRAY	Graphics.getColorOfRGB(0xc0, 0xc0, 0xc0)
#define COLOR_MAGENTA	Graphics.getColorOfRGB(0xff, 0x00, 0xff)
#define COLOR_ORANGE	Graphics.getColorOfRGB(0xff, 0xc8, 0x00)
#define COLOR_PINK		Graphics.getColorOfRGB(0xff, 0xaf, 0xaf)
#define COLOR_RED		Graphics.getColorOfName(Graphics.RED)
#define COLOR_WHITE		Graphics.getColorOfName(Graphics.WHITE)
#define COLOR_YELLOW	Graphics.getColorOfName(Graphics.YELLOW)
#endif

//#define COLOR_VER
#define COLOR_ITEM		COLOR_CYAN
#define COLOR_MONSTER	COLOR_RED

	private static int command;
//#define COMMAND_RESET()	{Sleep();command=0;}
	private static boolean moreWait;
	private static boolean moreAuto;
	private static int showMessage;
#define MESSAGE_REMOVE()	{showMessage=0;messageLine=0;}
#define MESSAGE_IGNORE()	{showMessage=0;}
#define SHOW_MESSAGE_NONE	0
#define SHOW_MESSAGE_MES	1
#define SHOW_MESSAGE_STATE	2
#define SHOW_MESSAGE_MORE	3
	private static int messageLine;
	private static String[] strMessage;
#define MESSAGE_LINE	3
	private static Image offImage;
	private static Graphics offGraphics;
	private static Image viewImage;
	private static Graphics viewGraphics;
	private static char drawBuf[][];
	private static int drawColor[][];
	private static char charMap[];
	private static char charMapHide[];
	private static char charMapFound[];
	private static char charItem[];

	private static String[] strHide;
	private static String[] strMonster;
	private static String[] strRing;
	private static String[] strRingTrue;
	private static String[] strWand;
	private static String[] strWandTrue;
	private static String[] strPotion;
	private static String[] strPotionTrue;
	private static String[] strScroll;
	private static String[] strScrollTrue;

	private static String[] strStateEnd;
#define MAX_SCORE_COUNT 5
	private static int score[];
	private static int death[];

	private static int fontWidth;
	private static int fontHeight;

	private static int viewCols;
	private static int viewRows;
	//key input mode
	private static int mode;
#define MODE_TITLE		0
#define MODE_GAME		1
#define MODE_MAP		2
#define MODE_ITEM1		3
#define MODE_ITEM2		4
#define MODE_ITEM_USE	5
#define MODE_GAMEOVER	6
#define MODE_WIZARD		100

	private static int turnCount;
#define TURN_PLAYER			0
#define TURN_MONSTERS_HASTE	1
#define TURN_PLAYER_HASTE	2
#define TURN_MONSTERS		3
#define TURN_END			4


/* dungeon */
	private static boolean detectMonsters;
	private static boolean movedPlayer;
	private static boolean movedMonster;
	private static int dungeon[][];
	private static char screenBuf[][];
	private static int mazeTemp[][];
	private static int room[][];
	private static int roomTemp[];
	private static int tempCol;
	private static int tempRow;
	private static int stairsCol;
	private static int stairsRow;
	private static int monsterCatalog[][];
	private static int monsterList[][];
	private static int ringCatalog[];
	private static int wandCatalog[];
	private static int potionCatalog[];
	private static int scrollCatalog[];
	private static int itemList[];

	private static int curFloor=0;
	private static int maxFloor;
	private static boolean trapDoor;
#define FLOOR_AMULET	27
#define FLOOR_LAST		99

#define DUNGEON_COLS	(16*3+2)
#define DUNGEON_ROWS	(12*3+2)

	//room
#define MAX_ROOM_COUNT 9
#define ROOM_FLAG	0
#define ROOM_RECT	1 //̍W BYTE-BYTE-BYTE-BYTE:leftCol-topRow-rightCol-bottomRow
						//\H̍W  WORD-BYTE-BYTE:none-col-row
#define ROOM_DOOR1	2 //hA1 WORD-BYTE-BYTE:ڑ敔ԍ-hA̍Wx-hA̍Wy
#define ROOM_DOOR2	3 //hA2
#define ROOM_DOOR3	4 //hA3
#define ROOM_DOOR4	5 //hA4
#define ROOM_ARRAY_COUNT	6

#define GET_RECT_LEFT_COL(rn)	(room[(rn)][ROOM_RECT] >>> 24)
#define GET_RECT_TOP_ROW(rn)	((room[(rn)][ROOM_RECT] & 0xff0000)>>>16)
#define GET_RECT_RIGHT_COL(rn)	((room[(rn)][ROOM_RECT] & 0xff00)>>>8)
#define GET_RECT_BOTTOM_ROW(rn)	(room[(rn)][ROOM_RECT] & 0xff)
#define SET_RECT(rm, leftCol, topRow, rightCol, bottomRow)	(room[rm][ROOM_RECT] = (((leftCol)<<24)|((topRow)<<16)|((rightCol)<<8)|(bottomRow)) )
#define SET_CROSSPOINT(rm, col, row)	(room[rm][ROOM_RECT] = (((col)<<8)|(row)) )

#define GET_DOOR_TONO(rn, dn)	((room[(rn)][(dn)] & 0xff0000)>>>16)
#define GET_DOOR_COL(rn, dn)	((room[(rn)][(dn)] & 0xff00)>>>8)
#define GET_DOOR_ROW(rn, dn)	(room[(rn)][(dn)] & 0xff)
#define SET_DOOR(rn, dn, torn, col, row)	( room[(rn)][(dn)] = ((torn)<<16)|((col)<<8)|(row) )
#define GET_CROSS_COL(rn)	((room[(rn)][ROOM_RECT] & 0xff00)>>>8)
#define GET_CROSS_ROW(rn)	(room[(rn)][ROOM_RECT] & 0xff)

#define ROOM_NODOOR	-1
#define ROOM_NOTHING	0
#define ROOM_ROOM		1
#define ROOM_MAZE		2
#define ROOM_MONSTER	0x100
#define ROOM_PASSAGE	0x10000
#define ROOM_DARKNESS	0x20000

	//zero is a missing number
#define MAX_MONSTER_COUNT 26
	//zero is a missing number
#define MAX_ITEM_COUNT 127


/* MAP */
//BYTE(terrainFlag)-BYTE(terrain)-BYTE(itemList index)-BYTE(monsterList index)

	// flag
#define MAP_FLAG_TRAP		0x01000000
#define MAP_FLAG_FOUND		0x10000000
#define MAP_FLAG_KNOWN		0x20000000

#define MAP_OBJECT		0x00ff0000
#define MAP_OBJECT_FLAG	0x000f0000
#define MAP_NOTHING		0
#define MAP_HORWALL		0x00010000
#define MAP_VERTWALL	0x00020000
#define MAP_FLOOR		0x00030000
#define MAP_TUNNEL		0x00040000
#define MAP_DOOR		0x00050000
#define MAP_STAIRS		0x00060000
#define MAP_OBJECT_COUNT	7
#define MAP_OBJECT_ENUM(num)	( (((num) & MAP_OBJECT_FLAG)) >>> 16 )
#define CHARMAP(flag) charMap[MAP_OBJECT_ENUM(flag)]

#define MAP_HIDE_FLAG		0x00f00000
#define MAP_TRAP_NON		0
#define MAP_TRAP_DOOR		0x00100000
#define MAP_TRAP_BEAR		0x00200000
#define MAP_TRAP_TELEPORT	0x00300000
#define MAP_TRAP_DART		0x00400000
#define MAP_TRAP_SLEEPGAS	0x00500000
#define MAP_TRAP_RUST		0x00600000
#define MAP_HIDE_TUNNEL		0x00700000
#define MAP_HIDE_DOOR_H		0x00800000
#define MAP_HIDE_DOOR_V		0x00900000
#define MAP_TRAP_OBJECT_COUNT	6
#define MAP_HIDE_OBJECT_COUNT	10
#define MAP_HIDE_OBJECT_ENUM(flag)	( ((flag) & MAP_HIDE_FLAG) >>> 20 )
#define CHARMAPHIDE(flag) charMapHide[MAP_HIDE_OBJECT_ENUM(flag)]
#define CHARMAPFOUND(flag) charMapFound[MAP_HIDE_OBJECT_ENUM(flag)]
#define HIDE_DOOR_PERMIL	60
#define HIDE_TUNNEL_PERMIL	1

#ifdef JP
#define NAME_TRAP_NONE		""
#define NAME_TRAP_DOOR		"Ƃ"
#define NAME_TRAP_BEAR		"N}"
#define NAME_TRAP_TELEPORT	"e|[g"
#define NAME_TRAP_DART		"Ŗ"
#define NAME_TRAP_SLEEPGAS	"ÖKX"
#define NAME_TRAP_RUST		"_"
#define NAME_HIDE_DOOR_H	"BhA"
#define NAME_HIDE_DOOR_V	"BhA"
#define NAME_HIDE_TUNNEL	"BʘH"
#else
#define NAME_TRAP_NONE		"strange trap"
#define NAME_TRAP_DOOR		"trap door"
#define NAME_TRAP_BEAR		"bear trap"
#define NAME_TRAP_TELEPORT	"teleport trap"
#define NAME_TRAP_DART		"poison dart trap"
#define NAME_TRAP_SLEEPGAS	"sleeping gas trap"
#define NAME_TRAP_RUST		"rust trap"
#define NAME_HIDE_DOOR_H	"hidden door"
#define NAME_HIDE_DOOR_V	"hidden door"
#define NAME_HIDE_TUNNEL	"hidden tunnel"
#endif
#define STRMAPHIDE(flag) strHide[MAP_HIDE_OBJECT_ENUM(flag)]

#if defined(USE_HANKAKU) || !defined(JP)
	#define CHAR_NOTHING	' '
	#define CHAR_HORWALL	'-'
	#define CHAR_VERTWALL	'|'
	#define CHAR_FLOOR		'.'
	#define CHAR_TUNNEL		'#'
	#define CHAR_DOOR		'+'
	#define CHAR_STAIRS		'%'
	#define CHAR_TRAP_DOOR		'd'
	#define CHAR_TRAP_BEAR		'b'
	#define CHAR_TRAP_TELEPORT	't'
	#define CHAR_TRAP_DART		'p'
	#define CHAR_TRAP_SLEEPGAS	's'
	#define CHAR_TRAP_RUST		'r'
	#define CHAR_ROGUE		'@'
	#define CHAR_GOLD		'*'
	#define CHAR_FOOD		':'
	#define CHAR_ARMOR		'['
	#define CHAR_WEAPON		')'
	#define CHAR_SUBWEAPON	'\\'
	#define CHAR_SCROLL		'?'
	#define CHAR_POTION		'!'
	#define CHAR_WAND		'/'
	#define CHAR_RING		'='
	#define CHAR_AMULET		','
#else
	#define CHAR_NOTHING	'@'
	#define CHAR_HORWALL	''
	#define CHAR_VERTWALL	''
	#define CHAR_FLOOR		'E'
	#define CHAR_TUNNEL		''
	#define CHAR_DOOR		''
	#define CHAR_STAIRS		''
	#define CHAR_TRAP_DOOR		''
	#define CHAR_TRAP_BEAR		''
	#define CHAR_TRAP_TELEPORT	''
	#define CHAR_TRAP_DART		''
	#define CHAR_TRAP_SLEEPGAS	''
	#define CHAR_TRAP_RUST		''
	#define CHAR_GOLD		''
	#define CHAR_FOOD		't'
	#define CHAR_WEAPON		'j'
	#define CHAR_ARMOR		'm'
	#define CHAR_SUBWEAPON	''
	#define CHAR_RING		''
	#define CHAR_POTION		'I'
	#define CHAR_SCROLL		'H'
	#define CHAR_WAND		'Y'
	#define CHAR_AMULET		''
	#define CHAR_ROGUE		''
#endif


/* monsters */
#define MAP_MONSTER_FLAG	0x000000ff
#define MONSTER_KIND_COUNT 26 //A-Z

#ifdef JP
#define NAME_MONSTER_UK	"҂"
#define NAME_MONSTER_A	"̉"
#define NAME_MONSTER_B	"傱"
#define NAME_MONSTER_C	"P^EX"
#define NAME_MONSTER_D	"hS"
#define NAME_MONSTER_E	"傤"
#define NAME_MONSTER_F	"͂Ƃ肮"
#define NAME_MONSTER_G	"CI"
#define NAME_MONSTER_H	"S"
#define NAME_MONSTER_I	"X̉"
#define NAME_MONSTER_J	"gJQ"
#define NAME_MONSTER_K	"͂Ԃ"
#define NAME_MONSTER_L	"d"
#define NAME_MONSTER_M	"f[T"
#define NAME_MONSTER_N	"jt"
#define NAME_MONSTER_O	"~΂S"
#define NAME_MONSTER_P	"H"
#define NAME_MONSTER_Q	"̂"
#define NAME_MONSTER_R	"炪ւ"
#define NAME_MONSTER_S	"ւ"
#define NAME_MONSTER_T	"l"
#define NAME_MONSTER_U	"pb"
#define NAME_MONSTER_V	"opCA"
#define NAME_MONSTER_W	""
#define NAME_MONSTER_X	"܂˂̉"
#define NAME_MONSTER_Y	"j"
#define NAME_MONSTER_Z	"]r"
#else
#define NAME_MONSTER_UK	"Monster"
#define NAME_MONSTER_A	"Aquator"
#define NAME_MONSTER_B	"Bat"
#define NAME_MONSTER_C	"Centaur"
#define NAME_MONSTER_D	"Dragon"
#define NAME_MONSTER_E	"Emu"
#define NAME_MONSTER_F	"Fly-trap"
#define NAME_MONSTER_G	"Griffin"
#define NAME_MONSTER_H	"Hobgoblin"
#define NAME_MONSTER_I	"Ice monster"
#define NAME_MONSTER_J	"Jabberwock"
#define NAME_MONSTER_K	"Kestrel"
#define NAME_MONSTER_L	"Leprechaun"
#define NAME_MONSTER_M	"Medusa"
#define NAME_MONSTER_N	"Nymph"
#define NAME_MONSTER_O	"Orc"
#define NAME_MONSTER_P	"Phantom"
#define NAME_MONSTER_Q	"Quagga"
#define NAME_MONSTER_R	"Rattlesnake"
#define NAME_MONSTER_S	"Snake"
#define NAME_MONSTER_T	"Troll"
#define NAME_MONSTER_U	"dark Unicorn"
#define NAME_MONSTER_V	"Vampire"
#define NAME_MONSTER_W	"Wraith"
#define NAME_MONSTER_X	"Xeroc"
#define NAME_MONSTER_Y	"Yeti"
#define NAME_MONSTER_Z	"Zombie"
#endif
	//killed by
#ifdef JP
#define DEATH26_DRAGONBREATH	"hS̉"
#define DEATH27_TRAPDOOR		"Ƃ"
#define DEATH28_TRAPDART		"ł"
#define DEATH29_HUNGER			""
#define DEATH30_BEINGHELD		"܂"
#define DEATH31_FREEZING		""
#define DEATH32_BLINDNESS		"Ӗڂ̏"
#define DEATH33_HALLUCINATION	"ȍ"
#define DEATH34_CONFUSED		"̏"
#define DEATH35_BEARTRAP		"F㩂ɂ"
#else
#define DEATH26_DRAGONBREATH	"dragon breath"
#define DEATH27_TRAPDOOR		"trap door"
#define DEATH28_TRAPDART		"poison"
#define DEATH29_HUNGER			"hungry"
#define DEATH30_BEINGHELD		"being held"
#define DEATH31_FREEZING		"freezing"
#define DEATH32_BLINDNESS		"blindness"
#define DEATH33_HALLUCINATION	"hallucination"
#define DEATH34_CONFUSED		"confused"
#define DEATH35_BEARTRAP		"bear trap"
#endif
#define MAX_DEATH_COUNT 36
	//catalog
#define MCATALOG_FLAG			0
#define MCATALOG_DAMAGE			1 //LOWORD:Attack1(0x0106=1D6,0x0206=2d6) HIWORD:attack2
#define MCATALOG_HP				2
#define MCATALOG_EXP			3
#define MCATALOG_START_FLOOR	4
#define MCATALOG_END_FLOOR		5
#define MCATALOG_CHANCE			6 //attack chance
#define MCATALOG_DROP			7 //item drop percent
#define MCATALOG_QUIVER			8
#define MCATALOG_CHAR			9 //display char
#define MCATALOG_ARRAY_COUNT	10
	//list
#define MLIST_IS_MONSTER	0 //catalog no.
#define MLIST_FLAG			1
#define MLIST_HP			2
#define MLIST_CHAR			3
#define MLIST_CARRY			4
#define MLIST_ROW			5
#define MLIST_COL			6
#define MLIST_QUIVER		7
#define MLIST_PICKED_UP		8 //sleeping turns
#define MLIST_TARGET_ROW	9 //@
#define MLIST_TARGET_COL	10
#define MLIST_PRE_ROW		11
#define MLIST_PRE_COL		12
#define MLIST_PRE_DIR		13
#define MLIST_STUCK			14
#define MLIST_ARRAY_COUNT	15

#define MFLAG_HASTED			0x0000001
#define MFLAG_SLOWED			0x0000002
#define MFLAG_SLOWED_TOGGLE		0x0000004
#define MFLAG_INVISIBLE			0x0000008
#define MFLAG_ASLEEP			0x0000010
#define MFLAG_WAKENS			0x0000020
#define MFLAG_WANDERS			0x0000040
#define MFLAG_FLIES				0x0000080
#define MFLAG_FLITS				0x0000100
#define MFLAG_CONFUSED	 		0x0000200
#define MFLAG_RUSTS				0x0000400
#define MFLAG_HOLDS				0x0000800
#define MFLAG_FREEZES			0x0001000
#define MFLAG_STEALS_GOLD		0x0002000
#define MFLAG_STEALS_ITEM		0x0004000
#define MFLAG_STINGS			0x0008000 //poison
#define MFLAG_DRAINS_LIFE		0x0010000 //maxSTR, maxHP down
#define MFLAG_DROPS_LEVEL		0x0020000
#define MFLAG_SEEKS_GOLD		0x0040000
#define MFLAG_CONFUSES			0x0080000
#define MFLAG_MIMIC				0x0100000
#define MFLAG_FLAMES			0x0200000
#define MFLAG_STATIONARY		0x0400000
#define MFLAG_NAPPING			0x0800000
#define MFLAG_WAKEUP			0x1000000
#define MFLAG_GETAWAY			0x2000000
#define MFLAG_SPECIAL_HIT		(MFLAG_RUSTS|MFLAG_HOLDS|MFLAG_FREEZES|MFLAG_STEALS_GOLD|MFLAG_STEALS_ITEM|MFLAG_STINGS|MFLAG_DRAINS_LIFE|MFLAG_DROPS_LEVEL)

#define WAKEUPMONSTER(mon) {monsterList[mon][MLIST_FLAG] &= (~(MFLAG_ASLEEP));}
#define WARLIKEMONSTER(mon) {monsterList[mon][MLIST_FLAG] &= (~(MFLAG_SEEKS_GOLD|MFLAG_WAKEUP));WAKEUPMONSTER(mon);}
#define MONSTER_NAME(mon) (strMonster[monsterList[mon][MLIST_IS_MONSTER]])

#define CHARMOB_DD(dd) ((char)monsterList[(dd) & MAP_MONSTER_FLAG][MLIST_CHAR])
#define GET_MONSTER_NAME(mi) ( strMonster[monsterList[(mi)][MLIST_IS_MONSTER]] )

#define WAKE_PERCENT 45
#define FLIT_PERCENT 33
#define PARTY_WAKE_PERCENT 75


/* items */
#define MAP_ITEM_FLAG	0x0000ff00
	//BYTE-BYTE-BYTE-BYTE : flag - type - subtype - extention
#define ITEM_UNKNOWN	0x00000000
#define ITEM_KNOWN		0x01000000
#define ITEM_IDENTIFY	0x02000000
#define ITEM_EQUIP		0x04000000
#define ITEM_EQUIP_LEFT	0x08000000 //left hand
#define ITEM_PROTECT	0x10000000
#define ITEM_CURSED		0x20000000
#define ITEM_MIMIC		0x40000000
#define ITEM_CALLED		0x80000000

	//type
#define ITEM_TYPE_FLAG		0xff0000
#define ITEM_SUBTYPE_FLAG	0x00ff00
#define ITEM_NONE		0
#define ITEM_GOLD		0x010000
#define ITEM_FOOD		0x020000
#define ITEM_ARMOR		0x030000
#define ITEM_WEAPON		0x040000
#define ITEM_SUBWEAPON	0x050000
#define ITEM_RING		0x060000
#define ITEM_SCROLL		0x070000
#define ITEM_POTION		0x080000
#define ITEM_WAND		0x090000
#define ITEM_AMULET		0x0a0000
#define ITEM_OBJECT_COUNT	11
#define ITEM_OBJECT_ENUM(num)	( ((num) & ITEM_TYPE_FLAG) >>> 16 )
#define CHARITEM_DD(dd) (charItem[ITEM_OBJECT_ENUM(itemList[((dd) & MAP_ITEM_FLAG)>>>8])])
#define CHARITEM_F(flag) charItem[ITEM_OBJECT_ENUM(flag)]

#ifdef JP
#define NAME_OF_MONEY_UNIT	"S[h"
#define NAME_OF_AMULET		"悯"
#define NAME_OF_AMULET_TRUE	"CF_[̖悯"
#else
#define NAME_OF_MONEY_UNIT	" gold"
#define NAME_OF_AMULET		"amuret"
#define NAME_OF_AMULET_TRUE	"the Amulet of Yendor"
#endif

#ifdef JP
#define MAKE_OF_NAME(object, type) (object + type)
#else
#define MAKE_OF_NAME(object, type) (type +" of "+ object)
#endif

	//food sub
#define FOOD_RATION	0x100
#define FOOD_LEMBAS	0x200
#ifdef JP
#define NAME_FOOD_RATION	"H"
#define NAME_FOOD_LEMBAS	""
#else
#define NAME_FOOD_RATION	"ration"
#define NAME_FOOD_LEMBAS	"slime-mold"
#endif

	//aromor sub
#define ARMOR_LEATHER		0
#define ARMOR_RINGMAIL		1
#define ARMOR_SCALE			2
#define ARMOR_CHAIN			3
#define ARMOR_BANDED 		4
#define ARMOR_SPLINT 		5
#define ARMOR_PLATE			6
#define ARMOR_OBJECT_COUNT	7
	//extention:enchanted+3
#ifdef JP
#define NAME_ARMOR_LEATHER		"̂낢"
#define NAME_ARMOR_RINGMAIL		"т"
#define NAME_ARMOR_SCALE		"낱̂낢"
#define NAME_ARMOR_CHAIN		"т"
#define NAME_ARMOR_BANDED 		"ы̂낢"
#define NAME_ARMOR_SPLINT 		"̂낢"
#define NAME_ARMOR_PLATE		"|Ŝ낢"
#else
#define NAME_ARMOR_LEATHER		"leather armor"
#define NAME_ARMOR_RINGMAIL		"ring mail"
#define NAME_ARMOR_SCALE		"scale mail"
#define NAME_ARMOR_CHAIN		"chain mail"
#define NAME_ARMOR_BANDED 		"banded armor"
#define NAME_ARMOR_SPLINT 		"splint mail"
#define NAME_ARMOR_PLATE		"plate armor"
#endif
#define GET_AC(obj) ( ((obj & ITEM_SUBTYPE_FLAG) >>> 8) +2 +(obj & 0xff) -3 )

	//subweapon subtype
#define SUBWEAPON_DART			0
#define SUBWEAPON_DAGGER		1
#define SUBWEAPON_SHURIKEN		2
	//extention:count

	//wepon subtype
#define WEAPON_MACE				3
#define WEAPON_LONG_SWORD		4
#define WEAPON_TWO_HANDED_SWORD	5
#define WEAPON_OBJECT_COUNT		6
	//extention:enchanted+3
#ifdef JP
#define NAME_SUBWEAPON_DART				""
#define NAME_SUBWEAPON_DAGGER			"iCt"
#define NAME_SUBWEAPON_SHURIKEN			"肯"
#define NAME_WEAPON_MACE				"ق"
#define NAME_WEAPON_LONG_SWORD			""
#define NAME_WEAPON_TWO_HANDED_SWORD	"傫Ȍ"
#else
#define NAME_SUBWEAPON_DART				"dart"
#define NAME_SUBWEAPON_DAGGER			"dagger"
#define NAME_SUBWEAPON_SHURIKEN			"shuriken"
#define NAME_WEAPON_MACE				"mace"
#define NAME_WEAPON_LONG_SWORD			"long sword"
#define NAME_WEAPON_TWO_HANDED_SWORD	"two handed sword"
#endif

	//scroll sub
#define SCROLL_PROTECT_ARMOR		0
#define SCROLL_HOLD_MONSTER			1
#define SCROLL_ENCH_WEAPON			2
#define SCROLL_ENCH_ARMOR			3
#define SCROLL_IDENTIFY				4
#define SCROLL_TELEPORT				5
#define SCROLL_SLEEP				6
#define SCROLL_SCARE_MONSTER		7
#define SCROLL_REMOVE_CURSE			8
#define SCROLL_CREATE_MONSTER		9
#define SCROLL_AGGRAVATE_MONSTER	10
#define SCROLL_MAGIC_MAPPING		11
#define SCROLL_OBJECT_COUNT			12
#define DUST_SCROLL	(ITEM_SCROLL | (SCROLL_SCARE_MONSTER << 8))
#define MAGIC_WORD	"Elbereth"
	//extention:1 when drop
#ifdef JP
#define NAME_SCROLL_PROTECT_ARMOR		"h"
#define NAME_SCROLL_HOLD_MONSTER		"𕕂"
#define NAME_SCROLL_ENCH_WEAPON			"틭"
#define NAME_SCROLL_ENCH_ARMOR			"h"
#define NAME_SCROLL_IDENTIFY			"ʂ"
#define NAME_SCROLL_TELEPORT			"e|[g"
#define NAME_SCROLL_SLEEP				"ɂ"
#define NAME_SCROLL_SCARE_MONSTER		"悯"
#define NAME_SCROLL_REMOVE_CURSE		"яj"
#define NAME_SCROLL_CREATE_MONSTER		""
#define NAME_SCROLL_AGGRAVATE_MONSTER	"{点"
#define NAME_SCROLL_MAGIC_MAPPING		"@̒n}"
#define NAME_OF_SCROLL	""
#else
#define NAME_SCROLL_PROTECT_ARMOR		"protect armor"
#define NAME_SCROLL_HOLD_MONSTER		"hold monster"
#define NAME_SCROLL_ENCH_WEAPON			"enchant weapon"
#define NAME_SCROLL_ENCH_ARMOR			"enchant armor"
#define NAME_SCROLL_IDENTIFY			"identify"
#define NAME_SCROLL_TELEPORT			"teleport"
#define NAME_SCROLL_SLEEP				"sleep"
#define NAME_SCROLL_SCARE_MONSTER		"scare monster"
#define NAME_SCROLL_REMOVE_CURSE		"remove curse"
#define NAME_SCROLL_CREATE_MONSTER		"create monster"
#define NAME_SCROLL_AGGRAVATE_MONSTER	"aggravate monster"
#define NAME_SCROLL_MAGIC_MAPPING		"magic mapping"
#define NAME_OF_SCROLL	"scroll"
#endif
#define STR_NAME_SCROLL(type) strScroll[(type)]

	//potion sub
#define POTION_INCREASE_STRENGTH	0
#define POTION_RESTORE_STRENGTH		1
#define POTION_HEALING				2
#define POTION_EXTRA_HEALING		3
#define POTION_POISON				4
#define POTION_RAISE_LEVEL			5
#define POTION_BLINDNESS			6
#define POTION_HALLUCINATION		7
#define POTION_DETECT_MONSTER		8
#define POTION_DETECT_OBJECTS		9
#define POTION_CONFUSION			10
#define POTION_LEVITATION			11
#define POTION_HASTE_SELF			12
#define POTION_SEE_INVISIBLE		13
#define POTION_OBJECT_COUNT			14
	//extention:none
#ifdef JP
#define NAME_POTION_INCREASE_STRENGTH	"炪"
#define NAME_POTION_RESTORE_STRENGTH	"񕜂"
#define NAME_POTION_HEALING				"̗͉񕜂"
#define NAME_POTION_EXTRA_HEALING		"ƂĂ񕜂"
#define NAME_POTION_POISON				"ł"
#define NAME_POTION_RAISE_LEVEL			"o"
#define NAME_POTION_BLINDNESS			"ڂԂ"
#define NAME_POTION_HALLUCINATION		"o"
#define NAME_POTION_DETECT_MONSTER		"m"
#define NAME_POTION_DETECT_OBJECTS		"ACem"
#define NAME_POTION_CONFUSION			""
#define NAME_POTION_LEVITATION			"󒆂ɕ"
#define NAME_POTION_HASTE_SELF			"fȂ"
#define NAME_POTION_SEE_INVISIBLE		"@̊"
#define NAME_OF_POTION	""
#else
#define NAME_POTION_INCREASE_STRENGTH	"increase strength"
#define NAME_POTION_RESTORE_STRENGTH	"restore strength"
#define NAME_POTION_HEALING				"healing"
#define NAME_POTION_EXTRA_HEALING		"extra healing"
#define NAME_POTION_POISON				"poison"
#define NAME_POTION_RAISE_LEVEL			"raise level"
#define NAME_POTION_BLINDNESS			"blindness"
#define NAME_POTION_HALLUCINATION		"hallucination"
#define NAME_POTION_DETECT_MONSTER		"detect monster"
#define NAME_POTION_DETECT_OBJECTS		"detect objects"
#define NAME_POTION_CONFUSION			"confusion"
#define NAME_POTION_LEVITATION			"levitation"
#define NAME_POTION_HASTE_SELF			"haste self"
#define NAME_POTION_SEE_INVISIBLE		"see invisible"
#define NAME_OF_POTION	"potion"
#endif
#define STR_NAME_POTION(type) strPotion[(type)]

	//wand sub
#define WAND_TELE_AWAY			0
#define WAND_SLOW_MONSTER		1
#define WAND_CONFUSE_MONSTER	2
#define WAND_INVISIBILITY		3
#define WAND_POLYMORPH			4
#define WAND_HASTE_MONSTER		5
#define WAND_PUT_TO_SLEEP		6
#define WAND_MAGIC_MISSILE		7
#define WAND_CANCELLATION		8
#define WAND_DO_NOTHING			9
#define WAND_OBJECT_COUNT		10
	//extention:number of times. empty:0x80
#ifdef JP
#define NAME_WAND_TELE_AWAY			"ɔ΂"
#define NAME_WAND_SLOW_MONSTER		""
#define NAME_WAND_CONFUSE_MONSTER	""
#define NAME_WAND_INVISIBILITY		"Ȃ"
#define NAME_WAND_POLYMORPH			"ϐg"
#define NAME_WAND_HASTE_MONSTER		"f"
#define NAME_WAND_PUT_TO_SLEEP		"点"
#define NAME_WAND_MAGIC_MISSILE		"@̖"
#define NAME_WAND_CANCELLATION		"͂𕕂"
#define NAME_WAND_DO_NOTHING		"ɗȂ"
#define NAME_OF_WAND	""
#else
#define NAME_WAND_TELE_AWAY			"teleport away"
#define NAME_WAND_SLOW_MONSTER		"slow monster"
#define NAME_WAND_CONFUSE_MONSTER	"confuse monster"
#define NAME_WAND_INVISIBILITY		"invisibility"
#define NAME_WAND_POLYMORPH			"polymorph"
#define NAME_WAND_HASTE_MONSTER		"haste monster"
#define NAME_WAND_PUT_TO_SLEEP		"sleep"
#define NAME_WAND_MAGIC_MISSILE		"magic missile"
#define NAME_WAND_CANCELLATION		"cancellation"
#define NAME_WAND_DO_NOTHING		"do nothing"
#define NAME_OF_WAND	"wand"
#endif
#define STR_NAME_WAND(type) strWand[(type)]

	//ring sub
#define RING_STEALTH			0
#define RING_TELEPORT			1
#define RING_REGENERATION		2
#define RING_SLOW_DIGEST		3
#define RING_STRENGTH			4
#define RING_SUSTAIN_STRENGTH	5
#define RING_DEXTERITY			6
#define RING_ADORNMENT			7
#define RING_SEE_INVISIBLE		8
#define RING_MAINTAIN_ITEM		9
#define RING_SEARCHING			10
#define RING_OBJECT_COUNT		11
	//extention:enchanted+3
#ifdef JP
#define NAME_RING_STEALTH			"gB"
#define NAME_RING_TELEPORT			"e|[g"
#define NAME_RING_REGENERATION		"̗͉񕜂"
#define NAME_RING_SLOW_DIGEST		""
#define NAME_RING_STRENGTH			""
#define NAME_RING_SUSTAIN_STRENGTH	"炸"
#define NAME_RING_DEXTERITY			"q[["
#define NAME_RING_ADORNMENT			"̂"
#define NAME_RING_SEE_INVISIBLE		"@̊"
#define NAME_RING_MAINTAIN_ITEM		""
#define NAME_RING_SEARCHING			"T"
#define NAME_OF_RING	"w"
#else
#define NAME_RING_STEALTH			"stealth"
#define NAME_RING_TELEPORT			"teleport"
#define NAME_RING_REGENERATION		"regeneration"
#define NAME_RING_SLOW_DIGEST		"slow digest"
#define NAME_RING_STRENGTH			"strength"
#define NAME_RING_SUSTAIN_STRENGTH	"sustain strength"
#define NAME_RING_DEXTERITY			"dexterity"
#define NAME_RING_ADORNMENT			"adornment"
#define NAME_RING_SEE_INVISIBLE		"see invisible"
#define NAME_RING_MAINTAIN_ITEM		"maintain items"
#define NAME_RING_SEARCHING			"searching"
#define NAME_OF_RING	"ring"
#endif
#define STR_NAME_RING(type) strRing[(type)]

/* player */
#define MAX_NAME_LENGTH 6
	private static String pcName = "";
#define INIT_HP		18
#define INIT_STR	16

#define MAX_PC_EXP		9999999
#define MAX_PC_GOLD		99999999
#define MAX_PC_AC		99
#define MAX_PC_HP		999
#define MAX_PC_STR		99

	private static int pcCol;
	private static int pcRow;
	private static int pcRoomNum;

	private static int pcPack[];
	private static int pcPackCount;
#define MAX_PACK_COUNT 20
	//itemInt put into equipment slot
	private static int pcWeapon;
	private static int pcArmor;
	private static int pcSubweapon;
	private static int pcRing[];
#define PC_RING_RIGHT	0
#define PC_RING_LEFT	1

	private static int pcMaxHP;
	private static int pcCurHP;
	private static int pcMaxSTR;
	private static int pcCurSTR;
	private static int pcGold;
	private static int pcLevel;
	private static int pcExp;

#define STATE_BEING_HELD	0
#define STATE_FREEZING		1
#define STATE_BLINDNESS		2
#define STATE_HALLUCINATION	3
#define STATE_CONFUSED		4
#define STATE_LEVITATE		5
#define STATE_HASTE			6
#define STATE_SEE_INVISIBLE	7
#define STATE_BEAR_TRAP		8
#define STATE_COUNT			9
	private static int pcState[];
	private static boolean moveStop;
	private static int healInterval;
	private static int pcKilledBy;
	private static int pcEnergy;
#define ENERGY_FULL		6000 //8000
#define ENERGY_ENOUGH	3200
#define ENERGY_HUNGRY	1200
#define ENERGY_WEAK		600
#define ENERGY_FAINT	80
#define ENERGY_STARVE	0
	private static int pcPreEnergy=ENERGY_FULL;

