/*
 * This source herein may be modified and/or distributed by anybody who
 * so desires, with the following restrictions:
 *    1.)  No portion of this notice shall be removed.
 *    2.)  Credit shall not be taken for the creation of this source.
 *    3.)  This code is not to be traded, sold, or used for personal
 *         gain or profit.
 */

#ifdef MIDP
import javax.microedition.lcdui.*;
import javax.microedition.rms.*;
#endif
#ifdef DOJA
import com.nttdocomo.ui.*;
import javax.microedition.io.Connector;
import java.io.*;
#endif
import java.util.Random;

#ifdef MIDP
final class View extends Canvas implements CommandListener, Runnable {
	public Wander midlet;
#endif
#ifdef DOJA
final class View extends Canvas implements Runnable {
#endif

#include "wander.h"

	View() {
#ifdef MIDP
		addCommand( new Command("MAP", Command.SCREEN, 1) );
		addCommand( new Command("MESSAGE", Command.SCREEN, 2) );
		setCommandListener(this);
#endif
#ifdef DOJA
		setSoftLabel(Frame.SOFT_KEY_1, "MAP");
		setSoftLabel(Frame.SOFT_KEY_2, "MESSAGE");
		PhoneSystem.setAttribute(PhoneSystem.DEV_BACKLIGHT, PhoneSystem.ATTR_BACKLIGHT_ON);
#endif

		random = new Random();

		moreWait = false;
		moreAuto = false;
		showMessage = 0;
		strMessage = new String[MESSAGE_LINE+1];
		strMessage[0]="";
		strMessage[1]="";
		strMessage[2]="";
		strMessage[3]="";

		offImage = Image.createImage(getWidth(), getHeight());
		offGraphics = offImage.getGraphics();
		viewImage = Image.createImage(getWidth(), getHeight());
		viewGraphics = viewImage.getGraphics();
#ifdef MIDP
		Font font = Font.getFont(Font.FACE_MONOSPACE, Font.STYLE_PLAIN, Font.SIZE_MEDIUM);
#endif
#ifdef DOJA
		Font font = Font.getFont(Font.FACE_MONOSPACE | Font.SIZE_SMALL);
#endif
		offGraphics.setFont(font);
		viewGraphics.setFont(font);
#ifdef MIDP
		fontWidth = font.charWidth(CHAR_ROGUE);
#endif
#ifdef DOJA
#if defined(HANKAKU) || !defined(JP)
		fontWidth = font.stringWidth("@");
#else
		fontWidth = font.stringWidth("");
#endif
#endif
#if 0 //descent closely
		fontHeight = font.getBaselinePosition();
		int descent = font.getHeight() - fontHeight;
#else
		fontHeight = font.getHeight() -1;
		int descent = 0;
#endif
		viewCols = getWidth() / fontWidth;
		viewRows = ((getHeight() - descent) / fontHeight) -1;
		drawBuf = new char[viewRows][viewCols];
		drawColor = new int[viewRows][viewCols];
		charMap = new char[MAP_OBJECT_COUNT];
		charMapHide = new char[MAP_HIDE_OBJECT_COUNT];
		charMapFound = new char[MAP_HIDE_OBJECT_COUNT];
		charItem = new char[ITEM_OBJECT_COUNT];
		strHide = new String[MAP_HIDE_OBJECT_COUNT];
		strStateEnd = new String[STATE_COUNT];
		messageInit();

		dungeon = new int[DUNGEON_ROWS][DUNGEON_COLS];
		screenBuf = new char[DUNGEON_ROWS][DUNGEON_COLS];
		mazeTemp = new int[DUNGEON_ROWS][DUNGEON_COLS];
		room = new int[MAX_ROOM_COUNT][ROOM_ARRAY_COUNT];
		roomTemp = new int[MAX_ROOM_COUNT];
		monsterList = new int[MAX_MONSTER_COUNT][MLIST_ARRAY_COUNT];
		ringCatalog = new int[RING_OBJECT_COUNT];
		wandCatalog = new int[WAND_OBJECT_COUNT];
		potionCatalog = new int[POTION_OBJECT_COUNT];
		scrollCatalog = new int[SCROLL_OBJECT_COUNT];
		itemList = new int[MAX_ITEM_COUNT];

		strMonster = new String[MONSTER_KIND_COUNT];
		strRing = new String[RING_OBJECT_COUNT];
		strRingTrue = new String[RING_OBJECT_COUNT];
		strWand = new String[WAND_OBJECT_COUNT];
		strWandTrue = new String[WAND_OBJECT_COUNT];
		strPotion = new String[POTION_OBJECT_COUNT];
		strPotionTrue = new String[POTION_OBJECT_COUNT];
		strScroll = new String[SCROLL_OBJECT_COUNT];
		strScrollTrue = new String[SCROLL_OBJECT_COUNT];

		monsterCatalog = new int[MONSTER_KIND_COUNT][MCATALOG_ARRAY_COUNT];
		monserInit();

		pcPack = new int[MAX_PACK_COUNT];
		pcRing = new int[2];
		pcState = new int[STATE_COUNT];

		score = new int[MAX_SCORE_COUNT];
		death = new int[MAX_DEATH_COUNT];
		loadScore();

		FUNCTION_PRINT("View construct out.");
	}

#include "init.java"
#include "keyevent.java"
#include "random.java"
#include "util.java"
#include "floor.java"
#include "room.java"
#include "monster.java"
#include "object.java"
#include "move.java"
#include "fight.java"
#include "player.java"
#include "name.java"
#include "message.java"
#include "turn.java"
#include "effect.java"
#include "loadsave.java"

	public synchronized void paint(Graphics g) {
		g.DRAWIMAGE(offImage, 0, 0);
	}

	public static void stateDraw() {
		viewGraphics.setColor(COLOR_BLACK);
		viewGraphics.fillRect(0, 0, offImage.getWidth(), fontHeight);
		if ( (pcCurHP *100 / pcMaxHP) <= 25 ) {
			viewGraphics.setColor(COLOR_RED);
		} else {
			viewGraphics.setColor(COLOR_WHITE);
		}
		viewGraphics.DRAWSTRING(Integer.toString(curFloor) +"F Lv:" +pcLevel +" HP:" +pcCurHP +"/" +pcMaxHP, 0, fontHeight);

	}

	private static void viewDraw() {
FUNCTION_CALLED("viwDraw()");

		viewGraphics.setColor(COLOR_BLACK);
		viewGraphics.fillRect(0, fontHeight+1, offImage.getWidth(), fontHeight*viewRows);
		viewGraphics.setColor(COLOR_WHITE);

		char c;
		int cd;
		int i, j, x, y;
		int dd;
		//@ position
		int pcX = viewCols/2;
		int pcY = viewRows/2;
		//draw range
		x = pcCol - pcX;
		y = pcRow - pcY;
		//monster > item > terrain
		//terrain and item
		int startX,endX,startY,endY;
		for (i=0; i < viewRows; i++) {
			for (j=0; j < viewCols; j++) {
				cd = COLOR_GRAY;
				c = CHAR_NOTHING;
				if ( (x+j >= 0) && (y+i >= 0) && (x+j < DUNGEON_COLS) && (y+i < DUNGEON_ROWS) ) {
					c = screenBuf[y+i][x+j];
					if (c == CHAR_STAIRS) cd = COLOR_YELLOW;
					dd = dungeon[y+i][x+j];
					if (pcState[STATE_BLINDNESS] > 0) {
						if (c == CHAR_FLOOR) {
							c = CHAR_NOTHING;
						}
					} else {
						//item
						if (IS_TRUE(dd & MAP_ITEM_FLAG)) {
							if (IS_TRUE(dd & MAP_FLAG_KNOWN)) {
								c = CHARITEM_DD(dd);
								cd = COLOR_ITEM;
							}
						}
						if ( (c == CHAR_STAIRS) || IS_TRUE(dd & (MAP_ITEM_FLAG | MAP_MONSTER_FLAG)) ) {
							if (IS_TRUE(dd & MAP_FLAG_KNOWN)) {
								if (pcState[STATE_HALLUCINATION] > 0) {
									c = randChar();
									cd = COLOR_PINK;
								}
							}
						}
					}
					if (IS_TRUE(dd & MAP_MONSTER_FLAG)) {
						if (detectMonsters) {
							c = CHARMOB_DD(dd);
							cd = COLOR_MONSTER;
						}
					}
				}
				drawBuf[i][j] = c;
				drawColor[i][j] = cd;
			}
		}
		//sight
#ifdef COLOR_VER
		if (pcState[STATE_BLINDNESS] <= 0) {
#else
		if ( (pcState[STATE_BLINDNESS] <= 0) && !detectMonsters) {
#endif
			boolean see = (IS_TRUE(pcState[STATE_SEE_INVISIBLE]) || (getRingPower(RING_SEE_INVISIBLE) != 0));
			if (pcRoomNum != MAX_ROOM_COUNT) {
				startX	= GET_RECT_LEFT_COL(pcRoomNum) -x;
				if (startX < 0) startX = 0;
				endX	= GET_RECT_RIGHT_COL(pcRoomNum) -x;
				if (endX >= viewCols) endX = viewCols -1;
				startY	= GET_RECT_TOP_ROW(pcRoomNum) -y;
				if (startY < 0) startY = 0;
				endY	= GET_RECT_BOTTOM_ROW(pcRoomNum) -y;
				if (endY >= viewRows) endY = viewRows -1;
				for (i=startY; i <= endY; i++) {
					for (j=startX; j <= endX; j++) {
						dd = dungeon[y+i][x+j] & MAP_MONSTER_FLAG;
						if (dd != 0) {
							if (pcState[STATE_HALLUCINATION] > 0) {
								drawBuf[i][j] = randChar();
								drawColor[i][j] = COLOR_PINK;
							} else if (see || IS_FALSE(monsterList[dd][MLIST_FLAG] & MFLAG_INVISIBLE)) {
								drawBuf[i][j] = CHARMOB_DD(dd);
								drawColor[i][j] = COLOR_MONSTER;
							}
						}
						if (drawColor[i][j] == COLOR_GRAY) drawColor[i][j] = COLOR_WHITE;
					}
				}
			}
			//8dir
			for (i=pcY-1; i<=pcY+1; i++) {
				for (j=pcX-1; j<=pcX+1; j++) {
					dd = dungeon[y+i][x+j] & MAP_MONSTER_FLAG;
					if (dd != 0) {
						if (pcState[STATE_HALLUCINATION] > 0) {
							drawBuf[i][j] = randChar();
							drawColor[i][j] = COLOR_PINK;
						} else if (see || IS_FALSE(monsterList[dd][MLIST_FLAG] & MFLAG_INVISIBLE)) {
							drawBuf[i][j] = CHARMOB_DD(dd);
							drawColor[i][j] = COLOR_MONSTER;
						}
					}
					if (drawColor[i][j] == COLOR_GRAY) drawColor[i][j] = COLOR_WHITE;
				}
			}
		}
		//@
		drawBuf[pcY][pcX] = CHAR_ROGUE;
		drawColor[pcY][pcX] = COLOR_YELLOW;

		//draw
#ifdef FORCE_NONPROPORTIONAL_DRAW
		for (i=0; i < viewRows; i++) {
			for (j=0; j<viewCols; j++) {
#ifdef COLOR_VER
				viewGraphics.setColor(drawColor[i][j]);
#endif
				viewGraphics.DRAWCHAR(drawBuf[i][j], fontWidth*j, fontHeight*(i+2));
			}
		}
#else //FORCE_NONPROPORTIONAL_DRAW
#ifdef COLOR_VER
		for (i=0; i < viewRows; i++) {
			for (j=0; j<viewCols; ) {
				int k;
				int prec = drawColor[i][j];
				for (k=j; k<viewCols; k++) {
					if (drawColor[i][k] != prec) break;
				}
				viewGraphics.setColor(prec);
				viewGraphics.DRAWCHARS(drawBuf[i], j, k-j, fontWidth*j, fontHeight*(i+2));
				j = k;
			}
		}
#else
		for (i=0; i < viewRows; i++) {
			viewGraphics.DRAWCHARS(drawBuf[i], 0, viewCols, 0, fontHeight*(i+2));
		}
#endif
#endif //FORCE_NONPROPORTIONAL_DRAW

FUNCTION_RETURN();
	}

	private static void roomLine(int flag) {
FUNCTION_CALLED("roomLine()");

	int c = COLOR_BLACK;
	if (pcState[STATE_BLINDNESS] <= 0) {
		if (IS_TRUE(flag & MAP_MONSTER_FLAG)) {
			c = COLOR_MONSTER;
		} else if (IS_TRUE(flag & MAP_ITEM_FLAG)) {
			c = COLOR_ITEM;
#if 0
		} else if (IS_TRUE(flag & 0xff0000)) {
			c = COLOR_BLUE;
#endif
		}
	}
	if ( (pcState[STATE_HALLUCINATION] > 0) && (c != COLOR_BLACK) ) {
		c = COLOR_PINK;
	}

	viewGraphics.setColor(c);
	viewGraphics.drawLine(0, fontHeight, offImage.getWidth(), fontHeight);

FUNCTION_RETURN();
	}

	private static void viewRedraw() {

		offGraphics.DRAWIMAGE(viewImage, 0, 0);
		if (IS_TRUE(showMessage)) {
			offGraphics.setColor(COLOR_BLACK);
			offGraphics.fillRect(0, (viewRows+1-messageLine) * fontHeight, offImage.getWidth(), fontHeight*messageLine);
			offGraphics.setColor(COLOR_WHITE);
			int j=0;
			int i;
			for (i=viewRows -messageLine; i < viewRows; i++) {
				offGraphics.DRAWSTRING(strMessage[j++], 0, fontHeight*(i+2));
			}
			if (showMessage == SHOW_MESSAGE_MORE) {
#ifdef JP
				offGraphics.DRAWSTRING("", fontWidth*(viewCols-1), fontHeight*(viewRows+1));
#else
				offGraphics.DRAWSTRING("!", fontWidth*(viewCols-1), fontHeight*(viewRows+1));
#endif
			}
		}

	}

	private static void mapDraw() {
FUNCTION_CALLED("mapDraw()");
		offGraphics.setColor(COLOR_BLACK);
		offGraphics.fillRect(0, 0, offImage.getWidth(), offImage.getHeight());

		char ch;
		int c;
		int i, j;
		int px, py, sx, sy;
		int dd;
		boolean b=false;
		px = offImage.getWidth() / DUNGEON_COLS;
		py = offImage.getHeight() / DUNGEON_ROWS;
		if (px > py) px = py;
		sx = (offImage.getWidth() - px*DUNGEON_COLS)/2;
		sy = (offImage.getHeight() - px*DUNGEON_ROWS)/2;
		//terrain
		offGraphics.setColor(COLOR_LIGHTGRAY);
		for (i=0; i < DUNGEON_ROWS; i++) {
			for (j=0; j < DUNGEON_COLS; j++) {
				ch = screenBuf[i][j];
				if ( (ch == CHAR_FLOOR) || (ch == CHAR_TUNNEL) || (ch == CHAR_DOOR) ) {
					offGraphics.fillRect(sx+j*px, sy+i*px, px, px);
				}
			}
		}
		//item
		if (pcState[STATE_HALLUCINATION] > 0) {
			offGraphics.setColor(COLOR_PINK);
		} else {
			offGraphics.setColor(COLOR_ITEM);
		}
		for (i=0; i < DUNGEON_ROWS; i++) {
			for (j=0; j < DUNGEON_COLS; j++) {
				dd = dungeon[i][j];
				if (IS_TRUE(dd & MAP_ITEM_FLAG)) {
					if (IS_TRUE(dd & MAP_FLAG_KNOWN)) {
						offGraphics.fillRect(sx+j*px-1, sy+i*px-1, px+2, px+2);
					}
				}
			}
		}
		//stairs
		if (IS_TRUE(dungeon[stairsRow][stairsCol] & MAP_FLAG_KNOWN)) {
			if (pcState[STATE_HALLUCINATION] > 0) {
				offGraphics.setColor(COLOR_PINK);
			} else {
				offGraphics.setColor(COLOR_BLUE);
			}
			offGraphics.fillRect(sx+stairsCol*px-1, sy+stairsRow*px-1, px+2, px+2);
		}
		//sight
		if (pcState[STATE_HALLUCINATION] > 0) {
			offGraphics.setColor(COLOR_PINK);
		} else {
			offGraphics.setColor(COLOR_MONSTER);
		}
		if (detectMonsters) {
			for (i=0; i < DUNGEON_ROWS; i++) {
				for (j=0; j < DUNGEON_COLS; j++) {
					dd = (dungeon[i][j] & MAP_MONSTER_FLAG);
					if (dd != 0) {
						offGraphics.fillRect(sx+j*px-1, sy+i*px-1, px+2, px+2);
					}
				}
			}
		} else if (pcState[STATE_BLINDNESS] > 0) {
			;
		} else {
			boolean see = (IS_TRUE(pcState[STATE_SEE_INVISIBLE]) || (getRingPower(RING_SEE_INVISIBLE) != 0));
			if (pcRoomNum != MAX_ROOM_COUNT) {
				int startX	= GET_RECT_LEFT_COL(pcRoomNum);
				int endX	= GET_RECT_RIGHT_COL(pcRoomNum);
				int startY	= GET_RECT_TOP_ROW(pcRoomNum);
				int endY	= GET_RECT_BOTTOM_ROW(pcRoomNum);
				int rflag = 0;
				for (i=startY; i < endY; i++) {
					for (j=startX; j < endX; j++) {
						dd = dungeon[i][j];
						rflag |= dd;
						dd = (dd & MAP_MONSTER_FLAG);
						if (dd != 0) {
							if (see || IS_FALSE(monsterList[dd][MLIST_FLAG] & MFLAG_INVISIBLE)) {
								offGraphics.fillRect(sx+j*px-1, sy+i*px-1, px+2, px+2);
							}
						}
					}
				}
				roomLine(rflag);
			}
			//8dir
			for (i=pcRow-1; i<=pcRow+1; i++) {
				for (j=pcCol-1; j<=pcCol+1; j++) {
					dd = (dungeon[i][j] & MAP_MONSTER_FLAG);
					if (dd != 0) {
						if (see || IS_FALSE(monsterList[dd][MLIST_FLAG] & MFLAG_INVISIBLE)) {
							offGraphics.fillRect(sx+j*px-1, sy+i*px-1, px+2, px+2);
						}
					}
				}
			}
		}
		//@
		offGraphics.setColor(COLOR_YELLOW);
		offGraphics.fillRect(sx+pcCol*px-1, sy+pcRow*px-1, px+2, px+2);
FUNCTION_RETURN();
	}

}
