/*
 * This source herein may be modified and/or distributed by anybody who
 * so desires, with the following restrictions:
 *    1.)  No portion of this notice shall be removed.
 *    2.)  Credit shall not be taken for the creation of this source.
 *    3.)  This code is not to be traded, sold, or used for personal
 *         gain or profit.
 */

private void nextTurn() {
FUNCTION_CALLED("nextTurn()");
FUNCTION_PRINT("call " +functionName);

	while (true) {
		turnCount++;
		if (turnCount >= TURN_END) {
			turnEnd();
			turnCount = 0;
		}
		if (IS_FALSE(turnCount & 1)) {
			if (playersTurn()) break;
		} else {
			monstersTurn();
		}
	}
	REDRAW();
	mode = MODE_GAME;
	command = 0;

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private boolean playersTurn() {
	boolean ret = false;
FUNCTION_CALLED("playersTurn()");
FUNCTION_PRINT("call " +functionName);

	if (turnCount == TURN_PLAYER) {
		ret = true;
	} else /*if (turn == TURN_PLAYER_HASTE)*/ {
		if (pcState[STATE_HASTE] > 0) {
			ret = true;
		}
	}

	if (ret) {
		checkHungry();
		turnHeal();
		if (getRingPower(RING_TELEPORT) != 0) {
			if (randPercent(8)) pcTeleport();
		}
		if (pcState[STATE_FREEZING] > 0) {
			ret = false;
		}
		if (ret && movedPlayer) {
			int object = (dungeon[pcRow][pcCol] & MAP_ITEM_FLAG) >> 8;
			if (object != 0) {
				if ( (pcState[STATE_LEVITATE] <= 0) ) {
					pick(pcCol, pcRow);
				} else {
					object = itemList[object];
#ifdef JP
					message(getObjectName(object,true)+"B");
#else
					message("there is " +getObjectName(object,true)+".");
#endif
				}
			} else {
				object = dungeon[pcRow][pcCol] & MAP_OBJECT;
				if (object == MAP_STAIRS) {
#ifdef JP
					message("KiB");
#else
					message("there is staircase.");
#endif
				} else if ( ((object & MAP_OBJECT_FLAG) == MAP_DOOR) || (object >= MAP_HIDE_DOOR_H) ) {
					moveStop = true;
				}
			}
		}
		movedPlayer = false;
	}

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

private void checkHungry() {
FUNCTION_CALLED("checkHungry()");
FUNCTION_PRINT("call " +functionName);

	if (pcEnergy < 0) {
		moveStop = true;
		if (randBool()) {
			pcKilledBy = 29;
			gameover(true);
		}
	} else if (pcEnergy <= ENERGY_FAINT) {
		if (pcPreEnergy > ENERGY_FAINT) {
#ifdef JP
			message("󕠂ŁAڂ炭炷B");
#else
			message("hungry and feels dizzy.");
#endif
		}
	} else if (pcEnergy <= ENERGY_WEAK) {
		if (pcPreEnergy > ENERGY_WEAK) {
#ifdef JP
			message("󕠂ŁAɂB");
#else
			message("dying of hunger.");
#endif
		}
	} else if (pcEnergy <= ENERGY_HUNGRY) {
		if (pcPreEnergy > ENERGY_HUNGRY) {
#ifdef JP
			message("󕠂ŗ͂ȂȂĂB");
#else
			message("really hungry.");
#endif
		}
	} else if (pcEnergy <= ENERGY_ENOUGH) {
		if (pcPreEnergy > ENERGY_ENOUGH) {
#ifdef JP
			message("ȂĂB");
#else
			message("feel hungry.");
#endif
		}
	}
	pcPreEnergy = pcEnergy;
	int en = 4;
	int enr = 0;
	if (((pcRing[PC_RING_RIGHT] & ITEM_SUBTYPE_FLAG) >> 8) == RING_SLOW_DIGEST) {
		enr -= 2;
	} else if (pcRing[PC_RING_RIGHT] != 0) {
		enr += 1;
	}
	if (((pcRing[PC_RING_LEFT] & ITEM_SUBTYPE_FLAG) >> 8) == RING_SLOW_DIGEST) {
		enr -= 2;
	} else if (pcRing[PC_RING_LEFT] != 0) {
		enr += 1;
	}
	en = en +enr;
	if (en < 1) en = 1;
	pcEnergy -= en;

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private static void turnHeal() {
FUNCTION_CALLED("turnHeal()");
FUNCTION_PRINT("call " +functionName);

	int healCount;
	if (pcLevel < 11) {
		healCount = (11 - pcLevel)*2;
	} else {
		healCount = 2;
	}

	healInterval++;
	int rr = getRingPower(RING_REGENERATION);
	if (rr != 0) {
		healInterval = 0;
		pcCurHP += 2;
	} else if ( (healInterval >= healCount) && (pcEnergy >= ENERGY_HUNGRY) ) {
		healInterval = 0;
		pcCurHP++;
		if (pcEnergy >= ENERGY_ENOUGH) {
			pcCurHP++;
		}
	}
	if (pcCurHP > pcMaxHP) {
		pcCurHP = pcMaxHP;
	}
	stateDraw();

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void turnEnd() {
FUNCTION_CALLED("turnEnd()");
FUNCTION_PRINT("call " +functionName);

	int i;
	int state;
	for (i=0; i<STATE_COUNT; i++) {
		state = pcState[i];
		if (state > 0) {
			state--;
			if (state <= 0) {
				message(strStateEnd[i]);
			}
			pcState[i] = state;
		}
	}
	if (randPercent(1)) {
		putMonster(pcRoomNum);
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void monstersTurn() {
FUNCTION_CALLED("monstersTurn()");
FUNCTION_PRINT("call " +functionName);

	boolean hasteTurn = false;
	if (turnCount == TURN_MONSTERS_HASTE) {
		hasteTurn = true;
	}

	movedMonster = false;
	int mflag;
	int i;
	for (i=1; i<MAX_MONSTER_COUNT; i++) {
		if (monsterList[i][MLIST_IS_MONSTER] >= MONSTER_KIND_COUNT) continue;
		mflag = monsterList[i][MLIST_FLAG];
		if (hasteTurn && IS_FALSE(mflag & MFLAG_HASTED)) {
			continue;
		}
		if (IS_TRUE(mflag & MFLAG_SLOWED)) {
			if (IS_FALSE(mflag & MFLAG_SLOWED_TOGGLE)) {
				monsterList[i][MLIST_FLAG] |= MFLAG_SLOWED_TOGGLE;
				continue;
			} else {
				monsterList[i][MLIST_FLAG] &= (~MFLAG_SLOWED_TOGGLE);
			}
		}
		moveMonster(i);
	}

	if (movedMonster || movedPlayer) {
		viewDraw();
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}
