/*
 * This source herein may be modified and/or distributed by anybody who
 * so desires, with the following restrictions:
 *    1.)  No portion of this notice shall be removed.
 *    2.)  Credit shall not be taken for the creation of this source.
 *    3.)  This code is not to be traded, sold, or used for personal
 *         gain or profit.
 */

private static void makeRoom(int roomNum, int leftCol, int topRow, int rightCol, int bottomRow) {
FUNCTION_CALLED("makeRoom(" +roomNum +", " +leftCol +", " +topRow +", " +rightCol +", " +bottomRow +")");
FUNCTION_PRINT("call " +functionName);

	SET_RECT(roomNum, leftCol, topRow, rightCol, bottomRow);
//DEBUG_PRINT("No:x1:y1:x2:y2="+roomNum+":"+leftCol+":"+topRow+":"+rightCol+":"+bottomRow);

	int x,y;
#if 1
	int m;
	for (y=topRow; y <= bottomRow; y++) {
		dungeon[y][leftCol] = MAP_VERTWALL;
		for (x=leftCol+1; x < rightCol; x++) {
			if (y == topRow || y == bottomRow) {
				m = MAP_HORWALL;
			} else {
				m = MAP_FLOOR;
			}
			dungeon[y][x] = m;
		}
		dungeon[y][rightCol] = MAP_VERTWALL;
	}
#else //Rogue Clone II Clone
	for (x=leftCol; x <= rightCol; x++) {
		dungeon[topRow][x] = MAP_HORWALL;
		dungeon[bottomRow][x] = MAP_HORWALL;
	}
	for (y=topRow+1; y < bottomRow; y++) {
		dungeon[y][leftCol] = MAP_VERTWALL;
		dungeon[y][rightCol] = MAP_VERTWALL;
	}
	for (y=topRow+1; y < bottomRow; y++) {
		for (x=leftCol+1; x < rightCol; x++) {
			dungeon[i][j] = MAP_FLOOR;
		}
	}
#endif

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void makeMonsterParty(int roomNum) {
FUNCTION_CALLED("makeMonsterParty(" +roomNum +")");
FUNCTION_PRINT("call " +functionName);

	room[roomNum][ROOM_FLAG] |= ROOM_MONSTER;
	int n = 11;
	if (randPercent(99)) {
		n = partyObjects(roomNum);
	}
	if (randPercent(99)) {
		partyMonsters(roomNum, n);
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private int partyObjects(int roomNum) {
	int ret = 0;
FUNCTION_CALLED("partyObjects(" +roomNum +")");
FUNCTION_PRINT("call " +functionName);

	int leftCol, topRow, rightCol, bottomRow;
	leftCol		= GET_RECT_LEFT_COL(roomNum);
	topRow		= GET_RECT_TOP_ROW(roomNum);
	rightCol	= GET_RECT_RIGHT_COL(roomNum);
	bottomRow	= GET_RECT_BOTTOM_ROW(roomNum);

	int nn = (bottomRow - topRow -1) * (rightCol - leftCol -1);
	int n =  randRandom(6) +5;
	if (n > nn) {
		n = nn - 2;
	}

	int width = rightCol - leftCol -1;
	int height = bottomRow - topRow -1;
	leftCol++;
	topRow++;
	boolean found;
	int row = 1;//for compile err
	int col = 1;
	int object;
	int dd;
	int i,j;
	for (i=0; i<n; i++) {
		found = false;
		for (j=0; j<250; j++) {
			col = randRandom(width) +leftCol;
			row = randRandom(height) +topRow;
			dd = (dungeon[row][col] & (MAP_OBJECT_FLAG | MAP_ITEM_FLAG));
			if ((dd == MAP_FLOOR) || (dd == MAP_TUNNEL)) {
				found = true;
				break;
			}
		}
		if (found) {
			object = randObject();
			dropObject(col, row, object);
			ret++;
		}
	}

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

private void partyMonsters(int roomNum, int count) {
FUNCTION_CALLED("partyMonsters(" +roomNum +")");
FUNCTION_PRINT("call " +functionName);

	count *= 2;

	int leftCol, topRow, rightCol, bottomRow;
	leftCol		= GET_RECT_LEFT_COL(roomNum);
	topRow		= GET_RECT_TOP_ROW(roomNum);
	int width = GET_RECT_RIGHT_COL(roomNum) - leftCol -1;
	int height = GET_RECT_BOTTOM_ROW(roomNum) - topRow -1;
	leftCol++;
	topRow++;

	int row = 1;//for compile err
	int col = 1;
	boolean found;
	int i,j;
	for (i=0; i < count; i++) {
		found = false;
		for (j=0; j<250; j++) {
			col = randRandom(width) +leftCol;
			row = randRandom(height) +topRow;
			if (IS_FALSE(dungeon[row][col] & MAP_MONSTER_FLAG)) {
				found = true;
				break;
			}
		}
		if (found) {
			createMonster(col, row, true);
		}
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private static int randRoom() {
	int no=0;
FUNCTION_CALLED("randRoom()");
FUNCTION_PRINT("call " +functionName);

	int rc=0;
	for (no=0; no<MAX_ROOM_COUNT; no++) {
		if (IS_TRUE(room[no][ROOM_FLAG] & ROOM_ROOM)) {
			roomTemp[rc++] = no;
		}
	}
	no = roomTemp[randRandom(rc)];

FUNCTION_PRINT(functionName +" return " +no);
FUNCTION_RETURN();
	return no;
}

//door:include door
private static int getRoomNum(int col, int row, boolean door) {
	int no=0;
FUNCTION_CALLED("getRoomNum(" +col +", " +row +", " +door +")");
FUNCTION_PRINT("call " +functionName);

	int leftCol, topRow, rightCol, bottomRow;
	int r = 1;
	if (door) {
		r = 0;
	}
	for (no=0; no<MAX_ROOM_COUNT; no++) {
		if (IS_FALSE(room[no][ROOM_FLAG] & ROOM_ROOM)) {
			continue;
		}
		leftCol		= GET_RECT_LEFT_COL(no) +r;
		topRow		= GET_RECT_TOP_ROW(no) +r;
		rightCol	= GET_RECT_RIGHT_COL(no) -r;
		bottomRow	= GET_RECT_BOTTOM_ROW(no) -r;
		if ( (col >= leftCol) && (row >= topRow) && (col <= rightCol) && (row <= bottomRow) ) {
			break;
		}
	}

FUNCTION_PRINT(functionName +" return " +no);
FUNCTION_RETURN();
	return no;
}

private void roomLightUp(int roomNum, boolean wakeup) {
FUNCTION_CALLED("roomLightUp(" +roomNum +")");
FUNCTION_PRINT("call " +functionName);

	int leftCol, topRow, rightCol, bottomRow;
	leftCol		= GET_RECT_LEFT_COL(roomNum);
	topRow		= GET_RECT_TOP_ROW(roomNum);
	rightCol	= GET_RECT_RIGHT_COL(roomNum);
	bottomRow	= GET_RECT_BOTTOM_ROW(roomNum);

	int dd;
	if (pcState[STATE_BLINDNESS] <= 0) {
		int rflag = 0;
		int addflag = MAP_FLAG_KNOWN;
		if (getRingPower(RING_SEARCHING) != 0) {
			addflag = MAP_FLAG_KNOWN | MAP_FLAG_FOUND;
		}
		room[roomNum][ROOM_FLAG] |= ROOM_PASSAGE;
		int x,y;
		int mon;
		for (y=topRow; y <= bottomRow; y++) {
			for (x=leftCol; x <= rightCol; x++) {
				dd = dungeon[y][x];
				dungeon[y][x] |= addflag;
				screenBuf[y][x] = mapFlag2char(dd);
				rflag |= dd;
				if (wakeup) {
					mon = (dd & MAP_MONSTER_FLAG);
					if (mon != 0) {
						randWakeUpMonster(mon);
					}
				}
			}
		}
		roomLine(rflag);//Ӗڂ̂Ƃ͈Ȃ̂ł̂܂
	}
	viewDraw();

	if (IS_TRUE(room[roomNum][ROOM_FLAG] & ROOM_MONSTER)) {
		room[roomNum][ROOM_FLAG] &= (~(ROOM_MONSTER));
#ifdef JP
		message("X^[nEXI");
#else
		message("monsters pit!");
#endif
		aggravate(true);
		detectMonsters = true;
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

//for room connect
//0 1 2
// * * 
//3 4 5
// * * 
//6 7 8
private static void makeMaze() {
FUNCTION_CALLED("makeMaze()");
FUNCTION_PRINT("call " +functionName);

	int x,y;
	for (y=0; y<5; y++) {
		for (x=0; x<5; x++) {
			mazeTemp[y][x] = 0;
		}
	}

	boolean set;
	int r;
	int col, row;
	for (y=0; y<2; y++) {
		for (x=0; x<2; x++) {
			set = false;
			do {
				col = x*2+1;
				row = y*2+1;
				r = randRandom(4);
				if (r == 0) {
					row--;
				} else if (r == 1) {
					row++;
				} else if (r == 2) {
					col--;
				} else if (r == 3) {
					col++;
				}
				if (mazeTemp[row][col] == 0) {
					mazeTemp[row][col] = 1;
					set = true;
				}
			} while (!set);
		}
	}

	//room exist?
	for (y=0; y<3; y++) {
		for (x=0; x<3; x++) {
			if (IS_FALSE(room[y*3+x][ROOM_FLAG] & ROOM_ROOM)) {
				mazeTemp[y*2][x*2] = 1;
			}
		}
	}
	if ((mazeTemp[2][2] == 0) && 
		( 
			   (mazeTemp[1][2] == 1)
			&& (mazeTemp[2][1] == 1)
			&& (mazeTemp[2][3] == 1)
			&& (mazeTemp[3][2] == 1)
		 )
	) {
		//bad case
		int bx,by;
		int rd = randRandom(4);
		if (rd == 0) {
			by = 1;
			bx = 2;
		} else if (rd == 1) {
			by = 2;
			bx = 1;
		} else if (rd == 2) {
			by = 2;
			bx = 3;
		} else {
			by = 3;
			bx = 2;
		}
		mazeTemp[by][bx] = 0;
	}

	//horizontal
	for (y=0; y<3; y++) {
		for (x=0; x<2; x++) {
			col = x*2+1;
			row = y*2;
			if ((mazeTemp[row][col] == 1) && (mazeTemp[row][col-1] == 0) && (mazeTemp[row][col+1] == 0)) {
				if (randPercent(66)) {
					mazeTemp[row][col] = 0;
				}
			}
		}
	}
	//vertical
	for (y=0; y<2; y++) {
		for (x=0; x<3; x++) {
			col = x*2;
			row = y*2+1;
			if ((mazeTemp[row][col] == 1) && (mazeTemp[row-1][col] == 0) && (mazeTemp[row+1][col] == 0)) {
				if (randPercent(66)) {
					mazeTemp[row][col] = 0;
				}
			}
		}
	}

	//remove dead end
	int c;
	for (y=0; y<3; y++) {
		for (x=0; x<3; x++) {
			col = x*2;
			row = y*2;
			if (mazeTemp[row][col] == 0) continue;
			c = 0;
			r = 0;
			if (y >= 1) {
				c++;
				if (mazeTemp[row-1][col] == 1) r++;
			}
			if (y <= 1) {
				c++;
				if (mazeTemp[row+1][col] == 1) r++;
			}
			if (x >= 1) {
				c++;
				if (mazeTemp[row][col-1] == 1) r++;
			}
			if (x <= 1) {
				c++;
				if (mazeTemp[row][col+1] == 1) r++;
			}
			if (c-1 == r) {
				if (randPercent(90)) {
					if (y >= 1) mazeTemp[row-1][col] = 1;
					if (y <= 1) mazeTemp[row+1][col] = 1;
					if (x >= 1) mazeTemp[row][col-1] = 1;
					if (x <= 1) mazeTemp[row][col+1] = 1;
				}
			}
		}
	}

//#ifdef DEBUG
#if 0
{
	mazeTemp[1][1] = 1;
	mazeTemp[1][3] = 1;
	mazeTemp[3][1] = 1;
	mazeTemp[3][3] = 1;
	System.out.println("DEBUG makeMaze in.");
	String d;
	for (y=0; y<5; y++) {
		d = "";
		for (x=0; x<5; x++) {
			if (mazeTemp[y][x] == 0) {
				d += "";
			} else {
				d += "";
			}
		}
		System.out.println(d);
	}
	System.out.println("DEBUG makeMaze out.");
}
#endif

	//horizontal tunnel
	for (y=0; y<3; y++) {
		for (x=0; x<2; x++) {
			col = x*2+1;
			row = y*2;
			if (mazeTemp[row][col] == 0) {
				r = y*3+x;
				roomConnect(r, r+1);
			}
		}
	}
	//vertical tunnel
	for (y=0; y<2; y++) {
		for (x=0; x<3; x++) {
			col = x*2;
			row = y*2+1;
			if (mazeTemp[row][col] == 0) {
				r = y*3+x;
				roomConnect(r, r+3);
			}
		}
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

//fromNum -> toNum : left to right, or up to down
//door No.
// 1 
//4 2
// 3 
private static void roomConnect(int fromNum, int toNum) {
FUNCTION_CALLED("roomConnect(" +fromNum +", " +toNum +")");
FUNCTION_PRINT("call " +functionName);
//WIZARD_PRINT("connect:"+fromNum+"->"+toNum);

	int fromCol, fromRow, toCol, toRow;
	int width;
	//make door
	if (toNum - fromNum <= 2) { //to right
		if (IS_TRUE(room[fromNum][ROOM_FLAG] & ROOM_ROOM)) {
			fromCol = GET_RECT_RIGHT_COL(fromNum);
			fromRow = GET_RECT_TOP_ROW(fromNum);
			width = GET_RECT_BOTTOM_ROW(fromNum) - fromRow;
			fromRow += randRandom(width-1)+1;
			SET_DOOR(fromNum, ROOM_DOOR2, toNum, fromCol, fromRow);
			if ((curFloor > 2) && randPermil(HIDE_DOOR_PERMIL)) dungeon[fromRow][fromCol] = MAP_HIDE_DOOR_V;
			else dungeon[fromRow][fromCol] = MAP_DOOR;
			fromCol++;
		} else {
			setCrossPoint(fromNum);
			fromCol = GET_CROSS_COL(fromNum);
			fromRow = GET_CROSS_ROW(fromNum);
		}
		if (IS_TRUE(room[toNum][ROOM_FLAG] & ROOM_ROOM)) {
			toCol = GET_RECT_LEFT_COL(toNum);
			toRow = GET_RECT_TOP_ROW(toNum);
			width = GET_RECT_BOTTOM_ROW(toNum) - toRow;
			toRow += randRandom(width-1)+1;
			SET_DOOR(toNum, ROOM_DOOR4, fromNum, toCol, toRow);
			if ((curFloor > 2) && randPermil(HIDE_DOOR_PERMIL)) dungeon[toRow][toCol] = MAP_HIDE_DOOR_V;
			else dungeon[toRow][toCol] = MAP_DOOR;
			toCol--;
		} else {
			setCrossPoint(toNum);
			toCol = GET_CROSS_COL(toNum);
			toRow = GET_CROSS_ROW(toNum);
		}
	} else { //to down
		if (IS_TRUE(room[fromNum][ROOM_FLAG] & ROOM_ROOM)) {
			fromRow = GET_RECT_BOTTOM_ROW(fromNum);
			fromCol = GET_RECT_LEFT_COL(fromNum);
			width = GET_RECT_RIGHT_COL(fromNum) - fromCol;
			fromCol += randRandom(width-1)+1;
			SET_DOOR(fromNum, ROOM_DOOR3, toNum, fromCol, fromRow);
			if ((curFloor > 2) && randPermil(HIDE_DOOR_PERMIL)) dungeon[fromRow][fromCol] = MAP_HIDE_DOOR_H;
			else dungeon[fromRow][fromCol] = MAP_DOOR;
			fromRow++;
		} else {
			setCrossPoint(fromNum);
			fromCol = GET_CROSS_COL(fromNum);
			fromRow = GET_CROSS_ROW(fromNum);
		}
		if (IS_TRUE(room[toNum][ROOM_FLAG] & ROOM_ROOM)) {
			toRow = GET_RECT_TOP_ROW(toNum);
			toCol = GET_RECT_LEFT_COL(toNum);
			width = GET_RECT_RIGHT_COL(toNum) - toCol;
			toCol += randRandom(width-1)+1;
			SET_DOOR(toNum, ROOM_DOOR1, fromNum, toCol, toRow);
			if ((curFloor > 2) && randPermil(HIDE_DOOR_PERMIL)) dungeon[toRow][toCol] = MAP_HIDE_DOOR_H;
			else dungeon[toRow][toCol] = MAP_DOOR;
			toRow--;
		} else {
			setCrossPoint(toNum);
			toCol = GET_CROSS_COL(toNum);
			toRow = GET_CROSS_ROW(toNum);
		}
	}

	//dig tunnel
	roomTemp[0] = fromCol;
	roomTemp[1] = fromRow;
	roomTemp[2] = toCol;
	roomTemp[3] = toRow;
	boolean digend = false;
	do {
		if (ABSINT(toCol - fromCol) >= ABSINT(toRow - fromRow)) {
			digTunnelH();
			digTunnelV();
		} else {
			digTunnelV();
			digTunnelH();
		}
		fromCol = roomTemp[0];
		fromRow = roomTemp[1];
		if ((toCol == fromCol) && (toRow == fromRow)) digend = true;
	} while (!digend);

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private static void digTunnelH() {
FUNCTION_CALLED("digTunnelH()");
FUNCTION_PRINT("call " +functionName);

	int fromCol = roomTemp[0];
	int fromRow = roomTemp[1];
	int toCol = roomTemp[2];
	int toRow = roomTemp[3];
	int width;

	width = ABSINT(toCol - fromCol);
	if ((width != 0) && (fromRow != toRow)) {
		width = randRandom(width)+1;
	}
	if (toCol >= fromCol) {
		toCol = fromCol +width;
		roomTemp[0] = toCol;
	} else {
		toCol = fromCol;
		fromCol = toCol -width;
		roomTemp[0] = fromCol;
	}
	//to right
	for (int i=fromCol; i<=toCol; i++) {
//DEBUG_PRINT("dig! col:row="+i+":"+fromRow);
		if ((curFloor > 2) && randPercent(HIDE_TUNNEL_PERMIL)) dungeon[fromRow][i] = MAP_HIDE_TUNNEL;
		else dungeon[fromRow][i] = MAP_TUNNEL;
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private static void digTunnelV() {
FUNCTION_CALLED("digTunnelV()");
FUNCTION_PRINT("call " +functionName);

	int fromCol = roomTemp[0];
	int fromRow = roomTemp[1];
	int toCol = roomTemp[2];
	int toRow = roomTemp[3];
	int width;

	width = ABSINT(toRow - fromRow);
	if ((width != 0) && (fromCol != toCol)) {
		width = randRandom(width)+1;
	}
	if (toRow >= fromRow) {
		toRow = fromRow +width;
		roomTemp[1] = toRow;
	} else {
		toRow = fromRow;
		fromRow = toRow -width;
		roomTemp[1] = fromRow;
	}
	//to down
	for (int i=fromRow; i<=toRow; i++) {
//DEBUG_PRINT("dig! col:row="+fromCol+":"+i);
		if ((curFloor > 2) && randPercent(HIDE_TUNNEL_PERMIL)) dungeon[i][fromCol] = MAP_HIDE_TUNNEL;
		else dungeon[i][fromCol] = MAP_TUNNEL;
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

//passage way point
private static void setCrossPoint(int roomNum) {
FUNCTION_CALLED("setCrossPoint(" +roomNum +")");
FUNCTION_PRINT("call " +functionName);

	if (room[roomNum][ROOM_RECT] == 0) {
		int dp3x=DUNGEON_COLS/3;
		int dp3y=DUNGEON_ROWS/3;
		int x = roomNum % 3;
		int y = roomNum / 3;
		int col = randRandom(dp3x-1)+1+dp3x*x;
		int row = randRandom(dp3y-1)+1+dp3y*y;
		SET_CROSSPOINT(roomNum, col, row);
	}
	//else {}//already

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

//flag:not permit
private static int randRoomPlace(int flag) {
	int ret = MAX_ROOM_COUNT;
FUNCTION_CALLED("randRoomPlace(0x" +Integer.toHexString(flag) +")");
FUNCTION_PRINT("call " +functionName);

	int roomNum;
	int leftCol, topRow;
	int width, height;
	int col,row;
	do {
		roomNum = randRoom();
		leftCol = GET_RECT_LEFT_COL(roomNum);
		topRow = GET_RECT_TOP_ROW(roomNum);
		width = GET_RECT_RIGHT_COL(roomNum) - leftCol -1;
		height = GET_RECT_BOTTOM_ROW(roomNum) - topRow -1;
		leftCol++;
		topRow++;
		col = randRandom(width) +leftCol;
		row = randRandom(height) +topRow;
		if (IS_FALSE(dungeon[row][col] & MAP_OBJECT)) continue;
		if ( (col == pcCol) && (row == pcRow) ) continue;
	} while ( IS_TRUE(dungeon[row][col] & flag) );

	tempCol = col;
	tempRow = row;
	ret = roomNum;

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

//flag:not permit
private static void randPlace(int flag, int roomNum) {
FUNCTION_CALLED("randPlace(" +flag +", " +roomNum +")");
FUNCTION_PRINT("call " +functionName);

	int leftCol, topRow;
	int width, height;
	int col,row;
	do {
		leftCol = GET_RECT_LEFT_COL(roomNum);
		topRow = GET_RECT_TOP_ROW(roomNum);
		width = GET_RECT_RIGHT_COL(roomNum) - leftCol -1;
		height = GET_RECT_BOTTOM_ROW(roomNum) - topRow -1;
		leftCol++;
		topRow++;
		col = randRandom(width) +leftCol;
		row = randRandom(height) +topRow;
		if (IS_FALSE(dungeon[row][col] & MAP_OBJECT)) continue;
	} while ( IS_TRUE(dungeon[row][col] & flag) );

	tempCol = col;
	tempRow = row;

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private static void setTraps() {
FUNCTION_CALLED("setTraps()");
FUNCTION_PRINT("call " +functionName);

	int n;
	if (curFloor <= 2) {
		n = 0;
	} else if (curFloor <= 7) {
		n = randRandom(3);
	} else if (curFloor <= 11) {
		n = randRandom(3)+1;
	} else if (curFloor <= 16) {
		n = randRandom(2)+2;
	} else if (curFloor <= 21) {
		n = randRandom(3)+2;
	} else if (curFloor <= (FLOOR_AMULET + 2)) {
		n = randRandom(3)+3;
	} else {
		n = randRandom(6)+5;
	}
#if 0
	n = 10;
#endif

	int type;
	int row,col;
	int i;
	for (i=0; i<n; i++) {
		type = randRandom(MAP_TRAP_OBJECT_COUNT)+1;
		randRoomPlace(MAP_FLAG_TRAP | MAP_ITEM_FLAG);
		col = tempCol;
		row = tempRow;
		dungeon[row][col] |= (MAP_FLAG_TRAP | (type<<20));
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

//BIT OR room's map data
private static int getRoomExistFlag(int roomNum) {
	int ret = 0;
FUNCTION_CALLED("getRoomExistFlag(" +roomNum +")");
FUNCTION_PRINT("call " +functionName);

	int leftCol		= GET_RECT_LEFT_COL(roomNum);
	int topRow		= GET_RECT_TOP_ROW(roomNum);
	int rightCol	= GET_RECT_RIGHT_COL(roomNum);
	int bottomRow	= GET_RECT_BOTTOM_ROW(roomNum);

	int x,y,dd;
	for (y=topRow; y <= bottomRow; y++) {
		for (x=leftCol; x <= rightCol; x++) {
			dd = dungeon[y][x];
			if (IS_TRUE(dd & MAP_FLAG_KNOWN)) {
				ret |= (dd & 0xffff);
			}
		}
	}

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}
