/*
 * This source herein may be modified and/or distributed by anybody who
 * so desires, with the following restrictions:
 *    1.)  No portion of this notice shall be removed.
 *    2.)  Credit shall not be taken for the creation of this source.
 *    3.)  This code is not to be traded, sold, or used for personal
 *         gain or profit.
 */

private void gainExp(int exp) {
FUNCTION_CALLED("gainExp(" +exp +")");
FUNCTION_PRINT("call " +functionName);

	if (pcExp >= MAX_PC_EXP) return;

	boolean ring = (getRingPower(RING_STRENGTH) != 0);
	pcExp += exp;
	if (ring) {
		pcExp += exp;
	}
	int newLevel = exp2level(pcExp);
	if (newLevel > pcLevel) {
		int hp;
		do {
			if (ring) {
				pcCurSTR++;
				if (pcCurSTR > pcMaxSTR) pcMaxSTR++;
			}
			pcLevel++;
			hp = hpRaise();
			pcCurHP += hp;
			pcMaxHP += hp;
			stateDraw();
#ifdef JP
			message("x" +pcLevel +"ւ悤B");
#else
			message("Welcome to level " +pcLevel +".");
#endif
		} while (pcLevel < newLevel);
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private static int levelExp[] = {
	0,
	8,//10
	18,//20
	40,
	80,
	160,
	320,
	640,
	1300,
	2600,
	5200,
	10000,
	20000,
	40000,
	80000,
	160000,
	320000,
	1000000,
	3333333,
	6666666,
	MAX_PC_EXP,
};

private static int exp2level(int exp) {
	int level=0;
FUNCTION_CALLED("exp2level(" +exp +")");
FUNCTION_PRINT("call " +functionName);

	int maxLevel = levelExp.length;
	for (level=0; level < maxLevel; level++) {
		if (levelExp[level] > exp) break;
	}

FUNCTION_PRINT(functionName +" return " +level);
FUNCTION_RETURN();
	return level;
}

private static int hpRaise() {
	int hp = 0;
FUNCTION_CALLED("hpRaise()");
FUNCTION_PRINT("call " +functionName);

	hp = randRandom(8)+3;

FUNCTION_PRINT(functionName +" return " +hp);
FUNCTION_RETURN();
	return hp;
}

private void pickUp() {
FUNCTION_CALLED("pickUp()");
FUNCTION_PRINT("call " +functionName);

	MESSAGE_REMOVE();
	if ((dungeon[pcRow][pcCol] & MAP_OBJECT_FLAG) == MAP_STAIRS) {
		if (pcState[STATE_BEING_HELD] > 0) {
#ifdef JP
			message("݂ĈړłȂB");
#else
			message("you are being held.");
#endif
		} else if ( (pcState[STATE_LEVITATE] > 0) && !hasObjectType(ITEM_AMULET)) {
#ifdef JP
			message("ɕ܂܂ł͍~ȂB");
#else
			message("you're floating in the air!");
#endif
		} else {
			if (hasObjectType(ITEM_AMULET)) {
#ifdef JP
				message("KîڂB");
#else
				message("Climb up a staircase.");
#endif
			} else {
#ifdef JP
				message("Ki肽B");
#else
				message("Climb down a staircase.");
#endif
			}
			saveScore();
			saveGame();
			newFloor();
		}
	} else {
		if (pick(pcCol, pcRow)) {
			nextTurn();
		}
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private boolean pick(int col, int row) {
	boolean ret = false;
FUNCTION_CALLED("pick(" +col +"," +row +")");
FUNCTION_PRINT("call " +functionName);

	int index = (dungeon[row][col] & MAP_ITEM_FLAG) >> 8;
	if (index != 0) {
		int object = itemList[index];
		if (object == (DUST_SCROLL | 1)) {
#ifdef JP
			message("" +MAGIC_WORD +"̕ĂĂB");
#else
			message("the character of " +MAGIC_WORD +" is printed on the floor.");
#endif
		} else if (packIn(object)) {
			dungeon[row][col] &= (~MAP_ITEM_FLAG);
			itemList[index] = 0;
			itemList[0]--;
			ret = true;
		}
	}

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

private static int hasSubwepon(int flag) {
	int ret = -1;
FUNCTION_CALLED("hasSubwepon(" +flag +")");
FUNCTION_PRINT("call " +functionName);

	int index;
	for (index=0; index<pcPackCount; index++) {
		if ((pcPack[index] & (ITEM_TYPE_FLAG | ITEM_SUBTYPE_FLAG)) == flag) {
			ret = index;
			break;
		}
	}

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

private boolean packIn(int object) {
	boolean ret = false;
FUNCTION_CALLED("packIn(0x" +Integer.toHexString(object) +")");
FUNCTION_PRINT("call " +functionName);

	int type = (object & ITEM_TYPE_FLAG);
	if (IS_TRUE(object & ITEM_MIMIC)) {
		object &= (~(ITEM_MIMIC));
		if (createMimic(object)) {
			ret = true;
#ifdef JP
			message(getObjectName(object,false) +"݂ĂI");
#else
			message("Oops, it's a mimic!");
#endif
		}
	}
	if (ret) {
		;
	} else if (type == ITEM_GOLD) {
		ret = true;
#ifdef JP
		message(getObjectName(object,true) +"ЂB");
#else
		message("picked up " +getObjectName(object,true) +".");
#endif
		pcGold += (object & 0xffff);
		if (pcGold > MAX_PC_GOLD) {
			pcGold = MAX_PC_GOLD;
		}
	} else {
		int subtype = (object & ITEM_SUBTYPE_FLAG);
		int index = -1;
		if (type == ITEM_SUBWEAPON) {
			index = hasSubwepon(ITEM_SUBWEAPON | subtype);
DEBUG_PRINT("index:" +index);
		}
		if (index >= 0) {
			ret = true;
			int count = (pcPack[index] & 0xff) +(object & 0xff);
			if (count > 0xff) {
				count = 0xff;
			}
			pcPack[index] = (pcPack[index] & 0xffffff00) +count;
			if (IS_TRUE(pcPack[index] & ITEM_EQUIP)) {
				pcSubweapon = pcPack[index];
			}
#ifdef JP
			message(getObjectName(object,true) +"ЂB");
#else
			message("picked up " +getObjectName(object,true) +".");
#endif
		} else if (pcPackCount < MAX_PACK_COUNT) {
			ret = true;
			pcPack[pcPackCount] = object;
			pcPackCount++;
#ifdef JP
			message(getObjectName(object,true) +"ЂB");
#else
			message("picked up " +getObjectName(object,true) +".");
#endif
		} else {
#ifdef JP
			message("ȏĂȂB"+getObjectName(object,true) +"B");
#else
			message("pack too full. there is "+getObjectName(object,true) +".");
#endif
		}
	}

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

private int packOut(int itemIndex, boolean steal) {
	int ret = 0;
FUNCTION_CALLED("packOut(" +itemIndex +", " +steal +")");
FUNCTION_PRINT("call " +functionName);

	ret = pcPack[itemIndex];
	if ( IS_TRUE(ret & ITEM_EQUIP) ){
		ret = takeOffObject(ret, steal);
	} else if ( ((ret & ITEM_TYPE_FLAG) == ITEM_SCROLL) && !steal) {
		ret |= 1;
	}
	if (ret != 0) {
		int i;
		for (i=itemIndex; i<pcPackCount-1; i++) {
			pcPack[i] = pcPack[i+1];
		}
		pcPack[i] = 0;
		pcPackCount--;
	}

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

private void packSort() {
FUNCTION_CALLED("packSort()");
FUNCTION_PRINT("call " +functionName);

	int object;
	int index;
	for (int i=0; i<pcPackCount-1; i++) {
		index = i;
		object = pcPack[index] & ITEM_TYPE_FLAG;
		for (int j=i+1; j<pcPackCount; j++) {
			if ((pcPack[j] & (ITEM_TYPE_FLAG | ITEM_SUBTYPE_FLAG)) < object) {
				index = j;
				object = pcPack[index] & ITEM_TYPE_FLAG;
			}
		}
		object = pcPack[i];
		pcPack[i] = pcPack[index];
		pcPack[index] = object;
	}

	for (int i=0; i<pcPackCount-1; i++) {
		index = i;
		object = pcPack[index];
		int type = object & ITEM_TYPE_FLAG;
		int sub = object & ITEM_SUBTYPE_FLAG;
		for (int j=i+2; j<pcPackCount; j++) {
			if ((pcPack[j] & ITEM_TYPE_FLAG) != type) break;
			if ((pcPack[j] & ITEM_SUBTYPE_FLAG) == sub) {
				object = pcPack[i+1];
				pcPack[i+1] = pcPack[j];
				pcPack[j] = object;
				break;
			}
		}
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private int selectItem() {
	int ret = 0;
FUNCTION_CALLED("selectItem()");
FUNCTION_PRINT("call " +functionName);

	MESSAGE_REMOVE();
	mode = MODE_ITEM1;
	drawInventory(0);

	command = 0;
	int key;
	while (true) {
		Sleep();
		key = command;
		if (key != 0) {
			if (key == COMMAND_KEY_POUND) {
				if (mode == MODE_ITEM1) {
					if (pcPackCount > 10) {
						mode = MODE_ITEM2;
						drawInventory(1);
					}
				} else {
					mode = MODE_ITEM1;
					drawInventory(0);
				}
			} else if (key == COMMAND_KEY_ASTERISK) {
				mode = MODE_ITEM1;
				packSort();
				drawInventory(0);
			} else if (IS_TRUE(key & COMMAND_NUMBER)) {
				break;
			} else {
				key = -1;
				break;
			}
			command = 0;
		}
	}

	ret = (key & 0xff) -1;
	if (mode == MODE_ITEM2) {
		ret += 10;
	}
	mode = MODE_GAME;
	command = 0;

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

private void inventory() {
FUNCTION_CALLED("inventory()");
FUNCTION_PRINT("call " +functionName);

	if (pcPackCount == 0) {
		MESSAGE_IGNORE();
#ifdef JP
		message("ACeĂȂB");
#else
		message("your pack is empty.");
#endif
		return;
	}

	int index = selectItem();
	if (pcPackCount > index) {
		drawItemMenu(pcPack[index]);
		mode = MODE_ITEM1;
		command = 0;
		while (true) {
			Sleep();
			int key = command;
			if (key != 0) {
				if (useItem(index, key)) {
					nextTurn();
				}
				break;
			}
		}
	}
	mode = MODE_GAME;
	command = 0;
	REDRAW();

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private int getItemUseFlag(int object) {
	int ret = 0;
FUNCTION_CALLED("getItemUseFlag(" +object +")");
FUNCTION_PRINT("call " +functionName);

#define USE_FLAG_EAT		0x01
#define USE_FLAG_EQUIP		0x02
#define USE_FLAG_READ		0x04
#define USE_FLAG_DRINK		0x08
#define USE_FLAG_ZAP		0x10
#define USE_FLAG_EQUIP_R	0x20
#define USE_FLAG_EQUIP_L	0x40
#define USE_FLAG_THROW		0x80
#define USE_FLAG_DROP		0x100
#define USE_FLAG_NAME		0x200

	ret = USE_FLAG_THROW | USE_FLAG_DROP;
	int type = (object & ITEM_TYPE_FLAG);
	if (type == ITEM_FOOD) {
		ret |= USE_FLAG_EAT;
	} else if (type == ITEM_ARMOR) {
		ret |= USE_FLAG_EQUIP;
	} else if (type == ITEM_WEAPON) {
		ret |= USE_FLAG_EQUIP;
	} else if (type == ITEM_SUBWEAPON) {
		ret |= USE_FLAG_EQUIP;
	} else if (type == ITEM_SCROLL) {
		ret |= USE_FLAG_READ;
		if (IS_FALSE(object & (ITEM_KNOWN | ITEM_IDENTIFY))) ret |= USE_FLAG_NAME;
	} else if (type == ITEM_POTION) {
		ret |= USE_FLAG_DRINK | USE_FLAG_NAME;
		if (IS_FALSE(object & (ITEM_KNOWN | ITEM_IDENTIFY))) ret |= USE_FLAG_NAME;
	} else if (type == ITEM_WAND) {
		ret |= USE_FLAG_ZAP | USE_FLAG_NAME;
		if (IS_FALSE(object & (ITEM_KNOWN | ITEM_IDENTIFY))) ret |= USE_FLAG_NAME;
	} else if (type == ITEM_RING) {
		ret |= USE_FLAG_EQUIP_R | USE_FLAG_EQUIP_L | USE_FLAG_NAME;
		if (IS_FALSE(object & (ITEM_KNOWN | ITEM_IDENTIFY))) ret |= USE_FLAG_NAME;
	} else if (type == ITEM_AMULET) {
		ret |= USE_FLAG_EQUIP;
	}

FUNCTION_PRINT(functionName +" return" +ret);
FUNCTION_RETURN();
	return ret;
}


private int command2useFlag(int key) {
	int ret = 0;
FUNCTION_CALLED("command2useFlag(" +key +")");
FUNCTION_PRINT("call " +functionName);

	if (key == COMMAND_KEY_1) {
		ret = USE_FLAG_EAT;
	} else if (key == COMMAND_KEY_2) {
		ret = USE_FLAG_EQUIP;
	} else if (key == COMMAND_KEY_3) {
		ret = USE_FLAG_READ;
	} else if (key == COMMAND_KEY_4) {
		ret = USE_FLAG_DRINK;
	} else if (key == COMMAND_KEY_6) {
		ret = USE_FLAG_ZAP;
	} else if (key == COMMAND_KEY_7) {
		ret = USE_FLAG_EQUIP_L;
	} else if (key == COMMAND_KEY_9) {
		ret = USE_FLAG_EQUIP_R;
	} else if (key == COMMAND_KEY_0) {
		ret = USE_FLAG_DROP;
	} else if (key == COMMAND_KEY_POUND) {
		ret = USE_FLAG_NAME;
	} else if (key == COMMAND_KEY_ASTERISK) {
		ret = USE_FLAG_THROW;
	}

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

private void eatObject(int object) {
FUNCTION_CALLED("eatObject(" +object +")");
FUNCTION_PRINT("call " +functionName);

	int subtype = (object & ITEM_SUBTYPE_FLAG);
	if (subtype == FOOD_RATION) {
		if ((getRingPower(RING_SLOW_DIGEST) != 0) || randPercent(60)) {
#ifdef JP
			message("AB");
#else
			message("yum, that tasted good.");
#endif
			pcEnergy += randRandom(801)+3600;
		} else {
#ifdef JP
			message("A܂I");
#else
			message("yuk, that food tasted awful!");
#endif
			pcEnergy += randRandom(801)+2800;
			gainExp(2);
		}
	} else if (subtype == FOOD_LEMBAS) {
#ifdef JP
		message("ȂĊÂ" +NAME_FOOD_LEMBAS +"B");
#else
		message("my, that was a yummy " +NAME_FOOD_LEMBAS +".");
#endif
		pcEnergy += randRandom(801)+3600;
	}
	if (pcEnergy > ENERGY_FULL) {
#ifdef JP
		message("B");
#else
		message("full stomach.");
#endif
		pcEnergy = ENERGY_FULL;
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private int object2index(int object) {
	int ret = -1;
FUNCTION_CALLED("object2index(0x" +Integer.toHexString(object) +")");
FUNCTION_PRINT("call " +functionName);

	for (int i=0; i<pcPackCount; i++) {
		if (pcPack[i] == object) {
			ret = i;
			break;
		}
	}

ASSERT_PRINT(ret==-1, "!!!!!!!!!!!!!!!!"+functionName);

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
	return ret;
}

private int takeOffObject(int object, boolean steal) {
	int ret = 0;
FUNCTION_CALLED("takeOffObject(0x" +Integer.toHexString(object) +", " +steal +")");
FUNCTION_PRINT("call " +functionName);

	if ( IS_TRUE(object & ITEM_CURSED) && !steal) {
#ifdef JP
		message(getObjectName(object,false) +"͎ĂĂ͂ȂB");
#else
		message(getObjectName(object,false) +" appears to be cursed.");
#endif
	} else {
		int i = object2index(object);
		if (IS_TRUE(object & ITEM_EQUIP_LEFT)) {
			pcRing[PC_RING_LEFT] = 0;
		} else {
			object = (object & ITEM_TYPE_FLAG);
			if (object == ITEM_ARMOR) {
				pcArmor = 0;
			} else if (object == ITEM_WEAPON) {
				pcWeapon = 0;
			} else if (object == ITEM_SUBWEAPON) {
				pcSubweapon = 0;
			} else if (object == ITEM_RING) {
				pcRing[PC_RING_RIGHT] = 0;
			}
		}
		pcPack[i] &= (~(ITEM_EQUIP | ITEM_EQUIP_LEFT));
		ret = pcPack[i];
	}

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

private boolean equipObject(int itemIndex) {
	boolean ret = false;
FUNCTION_CALLED("equipObject(" +itemIndex +")");
FUNCTION_PRINT("call " +functionName);

	MESSAGE_REMOVE();
	int slot = 0;
	boolean takeOff = true;
	int object = pcPack[itemIndex];
	int type = object & ITEM_TYPE_FLAG;
	if (type == ITEM_ARMOR) {
		slot = pcArmor;
	} else if (type == ITEM_WEAPON) {
		slot = pcWeapon;
	} else if (type == ITEM_SUBWEAPON) {
		slot = pcSubweapon;
	}

	if (slot != 0) {
		if (takeOffObject(slot, false) != 0) {
			ret = true;
#ifdef JP
			message(getObjectName(slot,false)+"͂B");
#else
			message("removed " +getObjectName(slot,false)+".");
#endif
		} else {
			takeOff = false;
		}
	}

	if (takeOff && (slot != object)) {
		pcPack[itemIndex] |= (ITEM_EQUIP | ITEM_KNOWN);
		slot = pcPack[itemIndex];
		ret = true;
		if (type == ITEM_ARMOR) {
			pcArmor = slot;
		} else if (type == ITEM_WEAPON) {
			pcWeapon = slot;
		} else if (type == ITEM_SUBWEAPON) {
			pcSubweapon = slot;
		}
		MESSAGE_REMOVE();
#ifdef JP
		message(getObjectName(slot,false)+"тB");
#else
		message("equiped " +getObjectName(slot,false)+".");
#endif
	}

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

private boolean equipRing(int itemIndex, boolean leftHand) {
	boolean ret = false;
FUNCTION_CALLED("equipRing(" +itemIndex +", " +leftHand +")");
FUNCTION_PRINT("call " +functionName);

//DEBUG_PRINT("L:0x" +Integer.toHexString(pcRing[PC_RING_LEFT]));
//DEBUG_PRINT("R:0x" +Integer.toHexString(pcRing[PC_RING_RIGHT]));
	MESSAGE_REMOVE();
	boolean takeOff = true;
	int object = pcPack[itemIndex];
	int slotL = pcRing[PC_RING_LEFT];
	int slotR = pcRing[PC_RING_RIGHT];
	int slot;
	if (leftHand) {
		slot = slotL;
	} else {
		slot = slotR;
	}

	String str = "";
	if (slot == object) {
		if (takeOffObject(slot, false) != 0) {
			ret = true;
#ifdef JP
			str = getObjectName(slot,false)+"͂B";
#else
			str = "removed " +getObjectName(slot,false)+".";
#endif
		}
	} else {
		if ((slotL == object) || (slotR == object)) {
			if ( IS_TRUE(slot & ITEM_CURSED) ) {
				takeOff = false;
			} else if ( IS_TRUE(slotL & ITEM_CURSED) ) {
				slot = slotL;
				takeOff = false;
			} else if ( IS_TRUE(slotR & ITEM_CURSED) ) {
				slot = slotR;
				takeOff = false;
			}
			if (takeOff) {
				if (slot != 0) {
					takeOffObject(slot, false);
#ifdef JP
					str = getObjectName(slot,false)+"͂āA";
#else
					str = "removed " +getObjectName(slot,false)+", ";
#endif
				}
				if (slot != slotL) takeOffObject(slotL, false);
				if (slot != slotR) takeOffObject(slotR, false);
				if (leftHand) {
					pcPack[itemIndex] |= (ITEM_EQUIP | ITEM_EQUIP_LEFT | ITEM_KNOWN);
					pcRing[PC_RING_LEFT] = pcPack[itemIndex];
					object = pcPack[itemIndex];
#ifdef JP
					str += ""+getObjectName(object,false)+"͂߂B";
#else
					str += "equiped "+getObjectName(object,false)+" to left hand.";
#endif
				} else {
					pcPack[itemIndex] |= (ITEM_EQUIP | ITEM_KNOWN);
					pcRing[PC_RING_RIGHT] = pcPack[itemIndex];
					object = pcPack[itemIndex];
#ifdef JP
					str += "E"+getObjectName(object,false)+"͂߂B";
#else
					str += "equiped "+getObjectName(object,false)+" to right hand.";
#endif
				}
				ret = true;
			} else {
#ifdef JP
				str = getObjectName(slot,false)+"͎ĂĂ͂ȂB";
#else
				str = getObjectName(slot,false)+" appears to be cursed.";
#endif
			}
		} else {
			if (slot != 0) {
				if (takeOffObject(slot, false) == 0) {
					takeOff = false;
				}
			}
			if (takeOff) {
				ret = true;
				if (leftHand) {
					pcPack[itemIndex] |= (ITEM_EQUIP | ITEM_EQUIP_LEFT | ITEM_KNOWN);
					pcRing[PC_RING_LEFT] = pcPack[itemIndex];
					object = pcPack[itemIndex];
#ifdef JP
					str = ""+getObjectName(object,false)+"͂߂B";
#else
					str = "equiped "+getObjectName(object,false)+" to left hand.";
#endif
				} else {
					pcPack[itemIndex] |= (ITEM_EQUIP | ITEM_KNOWN);
					pcRing[PC_RING_RIGHT] = pcPack[itemIndex];
					object = pcPack[itemIndex];
#ifdef JP
					str = "E"+getObjectName(object,false)+"͂߂B";
#else
					str = "equiped "+getObjectName(object,false)+" to right hand.";
#endif
				}
			}
		}
	}

//DEBUG_PRINT("L:0x" +Integer.toHexString(pcRing[PC_RING_LEFT]));
//DEBUG_PRINT("R:0x" +Integer.toHexString(pcRing[PC_RING_RIGHT]));
	if (str.length() != 0) {
		message(str);
	}

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

private void readObject(int object) {
FUNCTION_CALLED("readObject(" +object +")");
FUNCTION_PRINT("call " +functionName);

	int subtype = (object & ITEM_SUBTYPE_FLAG) >> 8;
#ifdef JP
	message(strScroll[subtype]+"񂾁B");
#else
	message("read " +strScroll[subtype]+".");
#endif
	boolean identify = IS_TRUE(scrollCatalog[subtype] & ITEM_KNOWN);
	if (!identify) {
		more();
		scrollCatalog[subtype] |= ITEM_KNOWN;
		strScroll[subtype] = strScrollTrue[subtype];
#ifdef JP
		message(strScrollTrue[subtype] +"I");
#else
		message("this is " +strScrollTrue[subtype] +"!");
#endif
	}
	int index;
	if (subtype == SCROLL_PROTECT_ARMOR) {
		if (pcArmor != 0) {
			more();
#ifdef JP
			message("낢PF̌ɎꂽB");
#else
			message("your armor is covered by a shimmering gold shield.");
#endif
			index = object2index(pcArmor);
			pcArmor |= ITEM_PROTECT;
			pcArmor &= (~(ITEM_CURSED));
			pcPack[index] = pcArmor;
		}
	} else if (subtype == SCROLL_HOLD_MONSTER) {
		holdMonster();
	} else if (subtype == SCROLL_ENCH_WEAPON) {
		object = pcWeapon;
		if (object != 0) {
			index = object2index(object);
			pcWeapon = enchantObject(object);
			pcPack[index] = pcWeapon;
		}
	} else if (subtype == SCROLL_ENCH_ARMOR) {
		object = pcArmor;
		if (object != 0) {
			index = object2index(object);
			pcArmor = enchantObject(object);
			pcPack[index] = pcArmor;
		}
	} else if (subtype == SCROLL_IDENTIFY) {
		if (pcPackCount > 0) {
#ifdef JP
			message("ʂACeIłB");
#else
			message("what would you like to identify?");
#endif
			more();
			index = selectItem();
			if (pcPackCount > index) {
				object = pcPack[index];
				pcPack[index] = identifyObject(object);
				if (pcWeapon == object) {
					pcWeapon = pcPack[index];
				} else if (pcArmor == object) {
					pcArmor = pcPack[index];
				} else if (pcSubweapon == object) {
					pcSubweapon = pcPack[index];
				} else if (pcRing[PC_RING_RIGHT] == object) {
					pcRing[PC_RING_RIGHT] = pcPack[index];
				} else if (pcRing[PC_RING_LEFT] == object) {
					pcRing[PC_RING_LEFT] = pcPack[index];
				}
#ifdef JP
				message("" +getObjectName(object,true) +"B");
#else
				message("this is " +getObjectName(object,true) +".");
#endif
			}
		}
	} else if (subtype == SCROLL_TELEPORT) {
		pcTeleport();
	} else if (subtype == SCROLL_SLEEP) {
		pcFreeze(false);
		more();
#ifdef JP
		message("mȂɖ荞ł܂B");
#else
		message("you fall asleep.");
#endif
		more();
	} else if (subtype == SCROLL_SCARE_MONSTER) {
		more();
#ifdef JP
		message("A悤ȏ΂ĂB");
#else
		message("you hear a maniacal laughter in the distance.");
#endif
	} else if (subtype == SCROLL_REMOVE_CURSE) {
		more();
		removeCurse();
#ifdef JP
		message("NɌ߂Ă悤ȋCB");
#else
		message("you feel as though someone is watching over you.");
#endif
	} else if (subtype == SCROLL_CREATE_MONSTER) {
		createMonster(pcCol, pcRow, false);
		viewDraw();
	} else if (subtype == SCROLL_AGGRAVATE_MONSTER) {
		more();
		aggravate(false);
#ifdef JP
		message("ǂ炩A񍂂Ȃ萺ĂB");
#else
		message("You hear a high pitched humming noise.");
#endif
	} else if (subtype == SCROLL_MAGIC_MAPPING) {
		more();
		magicMap();
#ifdef JP
		message("̊ɂ͒n}ĂI");
#else
		message("this scroll seems to have a map on it.");
#endif
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void drinkObject(int object) {
FUNCTION_CALLED("drinkObject(" +object +")");
FUNCTION_PRINT("call " +functionName);

	int subtype = (object & ITEM_SUBTYPE_FLAG) >> 8;
#ifdef JP
	message(strPotion[subtype]+"̂񂾁B");
#else
	message("drink " +strPotion[subtype]+".");
#endif
	pcEnergy += randRandom(40)+180;
	boolean identify = IS_TRUE(potionCatalog[subtype] & ITEM_KNOWN);
	if (!identify) {
		more();
		potionCatalog[subtype] |= ITEM_KNOWN;
		strPotion[subtype] = strPotionTrue[subtype];
#ifdef JP
		message("" +strPotionTrue[subtype] +"I");
#else
		message("This is " +strPotionTrue[subtype] +"!");
#endif
	}
	if (subtype == POTION_INCREASE_STRENGTH) {
		pcCurSTR++;
		if (pcCurSTR > pcMaxSTR) {
			pcMaxSTR = pcCurSTR;
		}
		stateDraw();
#ifdef JP
		message("͂킢Ă邼I");
#else
		message("you feel stronger now, what bulging muscles!");
#endif
	} else if (subtype == POTION_RESTORE_STRENGTH) {
		pcCurSTR = pcMaxSTR;
		stateDraw();
#ifdef JP
		message("炾|J|JĂB");
#else
		message("this tastes great, you feel warm all over.");
#endif
	} else if (subtype == POTION_HEALING) {
		potionHeal(false);
#ifdef JP
		message("C悭ȂI");
#else
		message("you begin to feel better.");
#endif
	} else if (subtype == POTION_EXTRA_HEALING) {
		potionHeal(true);
#ifdef JP
		message("ƂĂC悭ȂI");
#else
		message("you begin to feel much better.");
#endif
	} else if (subtype == POTION_POISON) {
		pcKilledBy = 28;
		pcPoison(false);
	} else if (subtype == POTION_RAISE_LEVEL) {
		if (pcLevel < levelExp.length) {
			pcExp = levelExp[pcLevel] -1;
			gainExp(1);
		}
	} else if (subtype == POTION_BLINDNESS) {
		if (pcState[STATE_BLINDNESS] <= 0) {
			pcState[STATE_BLINDNESS] = randRandom(30)+50;
			viewDraw();
#ifdef JP
			message("Èł̂Ƃ΂肪Ă䂭B");
#else
			message("a cloak of darkness falls around you.");
#endif
		} else {
			pcState[STATE_BLINDNESS] += randRandom(15)+25;
		}
	} else if (subtype == POTION_HALLUCINATION) {
		if (pcState[STATE_HALLUCINATION] <= 0) {
			pcState[STATE_HALLUCINATION] = randRandom(50)+80;
			viewDraw();
#ifdef JP
			message("Fɂ݂ȂH");
#else
			message("oh wow, everything seems so cosmic.");
#endif
		} else {
			pcState[STATE_HALLUCINATION] += randRandom(30)+50;
		}
	} else if (subtype == POTION_DETECT_MONSTER) {
		if (!detectMonsters) {
			detectMonsters = true;
			viewDraw();
#ifdef JP
			message("svcȋCB");
#else
			message("you have a strange feeling for a moment, then it passes.");
#endif
		}
	} else if (subtype == POTION_DETECT_OBJECTS) {
		detectObjects();
#ifdef JP
		message("svcȋCB");
#else
		message("you have a strange feeling for a moment, then it passes.");
#endif
	} else if (subtype == POTION_CONFUSION) {
		pcConfuse();
#ifdef JP
		message("ς炢݂ȋCI");
#else
		message("you feel confused.");
#endif
	} else if (subtype == POTION_LEVITATION) {
#ifdef JP
		message("̂ɕĂ܂I");
#else
		message("you start to float in the air.");
#endif
		pcState[STATE_BEING_HELD] = 0;
		pcState[STATE_BEAR_TRAP] = 0;
		pcState[STATE_LEVITATE] += randRandom(31)+30;
	} else if (subtype == POTION_HASTE_SELF) {
#ifdef JP
		message("̂f悤ɂȂI");
#else
		message("you feel yourself moving much faster.");
#endif
		pcState[STATE_HASTE] += randRandom(12)+11;
	} else if (subtype == POTION_SEE_INVISIBLE) {
		if (pcState[STATE_BLINDNESS] > 0) {
			unblind();
			viewDraw();
		}
#ifdef JP
		message(NAME_FOOD_LEMBAS+"W[X̂悤ȖB");
#else
		message("tastes like " +NAME_FOOD_LEMBAS+" juice.");
#endif
		pcState[STATE_SEE_INVISIBLE] += randRandom(300) +400;
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private int zapObject(int object) {
FUNCTION_CALLED("zapObject(" +object +")");
FUNCTION_PRINT("call " +functionName);

	int dir = inputDir();
	if (dir == 0) return 0;

	int subtype = (object & ITEM_SUBTYPE_FLAG) >> 8;
#ifdef JP
	message(strWand[subtype]+"ӂB");
#else
	message("zap with " +strWand[subtype]+".");
#endif
	if ((object & 0x7f) == 0) {
		object |= 0x80;
		more();
#ifdef JP
		message("ANȂB");
#else
		message("nothing happens.");
#endif
		return object;
	}
	object--;
	int monster = getZappedMonster(pcCol, pcRow, dir, DUNGEON_ROWS);
	if (monster == 0) {
		return object;
	}
	zappedMonster(monster, subtype);

FUNCTION_PRINT(functionName +" return " +object);
FUNCTION_RETURN();
	return object;
}

private void zappedMonster(int monster, int subtype) {
FUNCTION_CALLED("zappedMonster(" +monster +", " +subtype +")");
FUNCTION_PRINT("call " +functionName);

	WARLIKEMONSTER(monster);
	monsterList[monster][MLIST_TARGET_COL] = pcCol;
	monsterList[monster][MLIST_TARGET_ROW] = pcRow;
	int mcol = monsterList[monster][MLIST_COL];
	int mrow = monsterList[monster][MLIST_ROW];
	String mname = NAME_MONSTER_UK;
	if (pcCanSee(mcol, mrow)) {
		mname = strMonster[monsterList[monster][MLIST_IS_MONSTER]];
	}
	if (subtype == WAND_TELE_AWAY) {
		teleportAway(monster);
	} else if (subtype == WAND_SLOW_MONSTER) {
		monsterList[monster][MLIST_FLAG] |= MFLAG_SLOWED;
#ifdef JP
		message(mname +"͂ȂI");
#else
		message(mname +" slow down.");
#endif
	} else if (subtype == WAND_CONFUSE_MONSTER) {
		monsterList[monster][MLIST_FLAG] |= MFLAG_CONFUSED;
#ifdef JP
		message(mname +"͍I");
#else
		message(mname +" appears confused.");
#endif
	} else if (subtype == WAND_INVISIBILITY) {
		if (IS_TRUE(monsterCatalog[monsterList[monster][MLIST_IS_MONSTER]][MCATALOG_FLAG] & MFLAG_INVISIBLE)) {
			monsterList[monster][MLIST_FLAG] &= (~(MFLAG_INVISIBLE));
		} else {
			monsterList[monster][MLIST_FLAG] |= MFLAG_INVISIBLE;
		}
	} else if (subtype == WAND_POLYMORPH) {
		changeMonster(monster);
	} else if (subtype == WAND_HASTE_MONSTER) {
		if (IS_TRUE(monsterList[monster][MLIST_FLAG] & MFLAG_HASTED)) {
			monsterList[monster][MLIST_FLAG] |= MFLAG_FLIES;
		} else {
			monsterList[monster][MLIST_FLAG] |= MFLAG_HASTED;
		}
#ifdef JP
		message(mname +"͂΂₭ȂI");
#else
		message(mname +" hasten.");
#endif
	} else if (subtype == WAND_PUT_TO_SLEEP) {
		sleepMonster(monster);
#ifdef JP
		message(mname +"͖I");
#else
		message(mname +" appears slept.");
#endif
	} else if (subtype == WAND_MAGIC_MISSILE) {
		playersAttack(monster, true);
	} else if (subtype == WAND_CANCELLATION) {
		monsterList[monster][MLIST_FLAG] = 0;
	} else if (subtype == WAND_DO_NOTHING) {
		;
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void callObject(int object) {
FUNCTION_CALLED("callObject(" +object +")");
FUNCTION_PRINT("call " +functionName);

#ifdef JP
	String name = inputName("Ȃ܂", "");
#else
	String name = inputName("Call it:", "");
#endif
	if (name.length() == 0) return;
	int type = (object & ITEM_TYPE_FLAG);
	int enum = (object & ITEM_SUBTYPE_FLAG) >> 8;
	if (type == ITEM_RING) {
		strRing[enum] = NAME_OF_RING +"\"" +name +"\"";
		ringCatalog[enum] |= ITEM_CALLED;
	} else if (type == ITEM_SCROLL) {
		strScroll[enum] = NAME_OF_SCROLL +"\"" +name +"\"";
		scrollCatalog[enum] |= ITEM_CALLED;
	} else if (type == ITEM_POTION) {
		strPotion[enum] = NAME_OF_POTION +"\"" +name +"\"";
		potionCatalog[enum] |= ITEM_CALLED;
	} else if (type == ITEM_WAND) {
		strWand[enum] = NAME_OF_WAND +"\"" +name +"\"";
		wandCatalog[enum] |= ITEM_CALLED;
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void fireObject(int object, int col, int row, int dir) {
FUNCTION_CALLED("fireObject(" +object +", " +col +", " +row +", " +dir +")");
FUNCTION_PRINT("call " +functionName);

	MESSAGE_REMOVE();
#ifdef JP
	message(getObjectName(object, false) +"𓊂B");
#else
	message("threw " +getObjectName(object, false) +".");
#endif
	int monster = getZappedMonster(col, row, dir, 10);
	if (monster == 0) {
		dropObject(tempCol, tempRow, object);
		viewDraw();
	} else {
		fireAttack(monster, object);
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void fire() {
FUNCTION_CALLED("fire()");
FUNCTION_PRINT("call " +functionName);

	if (pcSubweapon == 0) {
#ifdef JP
		message("ѓ𑕔ĂȂB");
#else
		message("subweapon is not equipped.");
#endif
	} else {
		throwObject(object2index(pcSubweapon));
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void throwObject(int itemIndex) {
FUNCTION_CALLED("throwObject(" +itemIndex +")");
FUNCTION_PRINT("call " +functionName);
DEBUG_PRINT("throwObject(" +itemIndex +")");

	MESSAGE_REMOVE();
	int object = pcPack[itemIndex];
	if ( (object & (ITEM_EQUIP | ITEM_CURSED)) == (ITEM_EQUIP | ITEM_CURSED) ) {
#ifdef JP
		message(getObjectName(object, false) +"͎ĂĂ͂ȂB");
#else
		message(getObjectName(object,false) +" appears to be cursed.");
#endif
		return;
	}
DEBUG_PRINT("object:0x" +Integer.toHexString(object));
DEBUG_PRINT("pcSubweapon:0x" +Integer.toHexString(pcSubweapon));
	boolean equip = (pcSubweapon == object);
	int dir = inputDir();
	if (dir != 0) {
		if ( ((object & ITEM_TYPE_FLAG) != ITEM_SUBWEAPON) ) {
			packOut(itemIndex, false);
		} else {
			if ( (object & 0xff) == 1 ) {
				packOut(itemIndex, false);
			} else {
				object--;
				pcPack[itemIndex] = object;
				if (equip) {
					pcSubweapon = object;
				}
				object = (object & 0x00ffff00) +1;
			}
		}
		fireObject(object, pcCol, pcRow, dir);
		nextTurn();
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private int inputDir() {
	int ret = 0;
FUNCTION_CALLED("inputDir()");
FUNCTION_PRINT("call " +functionName);

#ifdef JP
	message("́H");
#else
	message("direction?");
#endif
	mode = MODE_ITEM1;
	command = 0;
	while (true) {
		Sleep();
		int key = command;
		if (key != 0) {
			if (IS_TRUE(key & COMMAND_NUMBER)) {
				if (key != COMMAND_KEY_0) {
					ret = (key & 0xff);
				}
			}
			break;
		}
	}
	MESSAGE_REMOVE();
	REDRAW();
	mode = MODE_GAME;
	command = 0;

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

private boolean useItem(int itemIndex, int commandKey) {
	boolean ret = true;
FUNCTION_CALLED("useItem(" +commandKey +")");
FUNCTION_PRINT("call " +functionName);

	int commandFlag = command2useFlag(commandKey);
	if (commandFlag == 0) {
		return false;
	}
	int object = pcPack[itemIndex];
	int useFlag = getItemUseFlag(object);
	int type;
	if (IS_TRUE(useFlag & commandFlag)) {
		if (commandFlag == USE_FLAG_EAT) {
			packOut(itemIndex, false);
			eatObject(object);
		} else if (commandFlag == USE_FLAG_EQUIP) {
			ret = equipObject(itemIndex);
		} else if (commandFlag == USE_FLAG_READ) {
			packOut(itemIndex, false);
			readObject(object);
		} else if (commandFlag == USE_FLAG_DRINK) {
			packOut(itemIndex, false);
			drinkObject(object);
		} else if (commandFlag == USE_FLAG_ZAP) {
			object = zapObject(object);
			if (object == 0) {
				ret = false;
			} else {
				pcPack[itemIndex] = object;
			}
		} else if (commandFlag == USE_FLAG_EQUIP_R) {
			ret = equipRing(itemIndex, false);
		} else if (commandFlag == USE_FLAG_EQUIP_L) {
			ret = equipRing(itemIndex, true);
		} else if (commandFlag == USE_FLAG_THROW) {
			ret = false;//nextTurn() is in throwObject()
			throwObject(itemIndex);
		} else if (commandFlag == USE_FLAG_DROP) {
			object = packOut(itemIndex, false);
			if (object != 0) {
				dropObject(pcCol, pcRow, object);
#ifdef JP
				message(getObjectName(object,true) +"𗎂ƂB");
#else
				message("dropped " +getObjectName(object,true) +".");
#endif
			}
		} else if (commandFlag == USE_FLAG_NAME) {
			callObject(object);
			ret = false;
		}
	} else {
		ret = false;
	}

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

private void drawItemMenu(int object) {
FUNCTION_CALLED("drawItemMenu(" +object +")");
FUNCTION_PRINT("call " +functionName);

	int flag = getItemUseFlag(object);
	offGraphics.setColor(COLOR_BLACK);
	offGraphics.fillRect(0, 0, offImage.getWidth(), offImage.getHeight());
	offGraphics.setColor(COLOR_WHITE);

	offGraphics.DRAWSTRING(getObjectName(object,true), 0, fontHeight);

	int n=2;
	if (IS_TRUE(flag & USE_FLAG_EAT)) {
#ifdef JP
		offGraphics.DRAWSTRING("1:ׂ", fontWidth, fontHeight*n);
#else
		offGraphics.DRAWSTRING("1:eat", fontWidth, fontHeight*n);
#endif
		n++;
	}
	if (IS_TRUE(flag & USE_FLAG_EQUIP)) {
		if (IS_TRUE(object & ITEM_EQUIP)) {
#ifdef JP
			offGraphics.DRAWSTRING("2:͂", fontWidth, fontHeight*n);
#else
			offGraphics.DRAWSTRING("2:remove", fontWidth, fontHeight*n);
#endif
		} else {
#ifdef JP
			offGraphics.DRAWSTRING("2:", fontWidth, fontHeight*n);
#else
			offGraphics.DRAWSTRING("2:equip", fontWidth, fontHeight*n);
#endif
		}
		n++;
	}
	if (IS_TRUE(flag & USE_FLAG_READ)) {
#ifdef JP
		offGraphics.DRAWSTRING("3:", fontWidth, fontHeight*n);
#else
		offGraphics.DRAWSTRING("3:read", fontWidth, fontHeight*n);
#endif
		n++;
	}
	if (IS_TRUE(flag & USE_FLAG_DRINK)) {
#ifdef JP
		offGraphics.DRAWSTRING("4:̂", fontWidth, fontHeight*n);
#else
		offGraphics.DRAWSTRING("4:drink", fontWidth, fontHeight*n);
#endif
		n++;
	}
	if (IS_TRUE(flag & USE_FLAG_ZAP)) {
#ifdef JP
		offGraphics.DRAWSTRING("6:ӂ", fontWidth, fontHeight*n);
#else
		offGraphics.DRAWSTRING("6:zap", fontWidth, fontHeight*n);
#endif
		n++;
	}
	if (IS_TRUE(flag & USE_FLAG_EQUIP_R)) {
		if (object == pcRing[PC_RING_RIGHT]) {
#ifdef JP
			offGraphics.DRAWSTRING("9:͂", fontWidth, fontHeight*n);
#else
			offGraphics.DRAWSTRING("9:remove", fontWidth, fontHeight*n);
#endif
		} else {
#ifdef JP
			offGraphics.DRAWSTRING("9:E", fontWidth, fontHeight*n);
#else
			offGraphics.DRAWSTRING("9:right hand", fontWidth, fontHeight*n);
#endif
		}
		n++;
	}
	if (IS_TRUE(flag & USE_FLAG_EQUIP_L)) {
		if (object == pcRing[PC_RING_LEFT]) {
#ifdef JP
			offGraphics.DRAWSTRING("7:͂", fontWidth, fontHeight*n);
#else
			offGraphics.DRAWSTRING("7:remove", fontWidth, fontHeight*n);
#endif
		} else {
#ifdef JP
			offGraphics.DRAWSTRING("7:", fontWidth, fontHeight*n);
#else
			offGraphics.DRAWSTRING("7:left hand", fontWidth, fontHeight*n);
#endif
		}
		n++;
	}
	if (IS_TRUE(flag & USE_FLAG_THROW)) {
#ifdef JP
		offGraphics.DRAWSTRING("*:Ȃ", fontWidth, fontHeight*n);
#else
		offGraphics.DRAWSTRING("*:throw", fontWidth, fontHeight*n);
#endif
		n++;
	}
	if (IS_TRUE(flag & USE_FLAG_NAME)) {
#ifdef JP
		offGraphics.DRAWSTRING("#:Ȃ܂", fontWidth, fontHeight*n);
#else
		offGraphics.DRAWSTRING("#:call", fontWidth, fontHeight*n);
#endif
		n++;
	}
	if (IS_TRUE(flag & USE_FLAG_DROP)) {
#ifdef JP
		offGraphics.DRAWSTRING("0:Ă", fontWidth, fontHeight*n);
#else
		offGraphics.DRAWSTRING("0:drop", fontWidth, fontHeight*n);
#endif
		n++;
	}
	REPAINT();

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void drawInventory(int pageNum) {
FUNCTION_CALLED("drawInventory(" +pageNum +")");
FUNCTION_PRINT("call " +functionName);

	offGraphics.setColor(COLOR_BLACK);
	offGraphics.fillRect(0, 0, offImage.getWidth(), offImage.getHeight());
	offGraphics.setColor(COLOR_WHITE);

	String str;
	int object;
	int baseIndex = pageNum * 10;
	int index;
	for (index=0; index < 10;) {
		object = pcPack[baseIndex +index];
		if (object == 0) break;
		str = "";
		if (IS_TRUE(object & ITEM_EQUIP)) {
			if ((object & ITEM_TYPE_FLAG) == ITEM_RING) {
				if (IS_TRUE(object & ITEM_EQUIP_LEFT)) {
					str = "L";
				} else {
					str = "R";
				}
			} else {
				str = "E";
			}
		} else {
			str = " ";
		}
		str += ((index+1) % 10);
		str += ".";
		str += getObjectName(object,true);
		index++;
		offGraphics.DRAWSTRING(str, 0, fontHeight*index);
	}
	REPAINT();

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private static boolean pcCanSee(int col, int row) {
	boolean ret = false;
FUNCTION_CALLED("pcCanSee(" +col +", " +row +")");
FUNCTION_PRINT("call " +functionName);

	if (pcState[STATE_BLINDNESS] > 0) {
		ret = false;
	} else if (pcState[STATE_HALLUCINATION] > 0) {
		ret = false;
	} else if (pcIsAround(col, row)) {
		ret = true;
	} else {
		int no = getRoomNum(col, row, true);
		if (no != MAX_ROOM_COUNT) {
			if (IS_FALSE(room[no][ROOM_FLAG] & ROOM_MAZE)) {
				if (no == pcRoomNum) ret = true;
			}
		}
	}

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

private static int getZappedMonster(int col, int row, int dir, int range) {
	int ret = 0;
FUNCTION_CALLED("getZappedMonster(" +col +", " +row +", " +dir +", " +range +")");
FUNCTION_PRINT("call " +functionName);

	int dx = ((dir-1) % 3) -1;
	int dy = ((dir-1) / 3) -1;
	int dd;
	for (int r=0; r<range; r++) {
		col += dx;
		row += dy;
		dd = dungeon[row][col];
		if (IS_TRUE(dd & MAP_MONSTER_FLAG)) {
			ret = (dd & MAP_MONSTER_FLAG);
			break;
		}
		if (IS_FALSE(dd & MAP_FLAG_FOUND)) {
			if ((dd & MAP_HIDE_FLAG) >= MAP_HIDE_TUNNEL) {
				break;
			}
		}
		if ((dd & MAP_OBJECT_FLAG) <= MAP_VERTWALL) {
			break;
		}
	}

	if (ret == 0) {
		col -= dx;
		row -= dy;
	}
	tempCol = col;
	tempRow = row;

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}
