/*
 * This source herein may be modified and/or distributed by anybody who
 * so desires, with the following restrictions:
 *    1.)  No portion of this notice shall be removed.
 *    2.)  Credit shall not be taken for the creation of this source.
 *    3.)  This code is not to be traded, sold, or used for personal
 *         gain or profit.
 */

private void setObjects(boolean amulet) {
FUNCTION_CALLED("setObjects(" +amulet +")");
FUNCTION_PRINT("call " +functionName);

	if (amulet) {
		return;
	}

	int n = randRandom(4) +2;
	while (randPercent(33)) {
		n++;
	}
	if (IS_TRUE(room[0][ROOM_FLAG] & ROOM_MONSTER)) {//big room
		makeMonsterParty(0);
	} else if (randPercent(10)) {//pit
		makeMonsterParty(randRoom());
	}
#if 1
	if (randPercent(10)) {//food chance
		putObject(ITEM_FOOD | FOOD_RATION);
	}
#endif
	int i;
	for (i=0; i<n; i++) {
		putObject(randObject());
	}
	putGold();

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private static String getEnchantString(int object) {
	String str = "";
FUNCTION_CALLED("getEnchantString(" +object +")");
FUNCTION_PRINT("call " +functionName);

	int n = (object & 0xff) -3;
	if (n >= 0) str += "+";
	str += Integer.toString(n);

FUNCTION_PRINT(functionName +" return " +str);
FUNCTION_RETURN();
	return str;
}

private static String getObjectName(int object, boolean count) {
	String str = "";
FUNCTION_CALLED("getObjectName(0x" +Integer.toHexString(object) +")");
FUNCTION_PRINT("call " +functionName);

	if (IS_TRUE(object & ITEM_CURSED) && IS_TRUE(object & (ITEM_KNOWN | ITEM_IDENTIFY))) {
#ifdef JP
		str += "";
#else
		str += "!";
#endif
	}
	if (IS_TRUE(object & ITEM_PROTECT)) {
#ifdef JP
		str += "";
#else
		str += "*";
#endif
	}
	int type = object & ITEM_TYPE_FLAG;
	int subtype = object & ITEM_SUBTYPE_FLAG;
	int subenum = subtype >> 8;
	if (type == ITEM_GOLD) {
		str += Integer.toString(object & 0xffff);
		str += NAME_OF_MONEY_UNIT;
	} else if (type == ITEM_FOOD) {
		if (subtype == FOOD_RATION) {
			str += NAME_FOOD_RATION;
		} else if (subtype == FOOD_LEMBAS) {
			str += NAME_FOOD_LEMBAS;
		} else {
			str += "bug food";
		}
	} else if (type == ITEM_ARMOR) {
		if (subenum == ARMOR_LEATHER) {
			str += NAME_ARMOR_LEATHER;
		} else if (subenum == ARMOR_RINGMAIL) {
			str += NAME_ARMOR_RINGMAIL;
		} else if (subenum == ARMOR_SCALE) {
			str += NAME_ARMOR_SCALE;
		} else if (subenum == ARMOR_CHAIN) {
			str += NAME_ARMOR_CHAIN;
		} else if (subenum == ARMOR_BANDED) {
			str += NAME_ARMOR_BANDED;
		} else if (subenum == ARMOR_SPLINT) {
			str += NAME_ARMOR_SPLINT;
		} else if (subenum == ARMOR_PLATE) {
			str += NAME_ARMOR_PLATE;
		} else {
			str += "bug armor";
		}
		if (IS_TRUE(object & (ITEM_KNOWN | ITEM_IDENTIFY))) {
			str += getEnchantString(object);
		}
	} else if ((type == ITEM_WEAPON) || (type == ITEM_SUBWEAPON)) {
		if (subenum == SUBWEAPON_DART) {
			str += NAME_SUBWEAPON_DART;
		} else if (subenum == SUBWEAPON_DAGGER) {
			str += NAME_SUBWEAPON_DAGGER;
		} else if (subenum == SUBWEAPON_SHURIKEN) {
			str += NAME_SUBWEAPON_SHURIKEN;
		} else if (subenum == WEAPON_MACE) {
			str += NAME_WEAPON_MACE;
		} else if (subenum == WEAPON_LONG_SWORD) {
			str += NAME_WEAPON_LONG_SWORD;
		} else if (subenum == WEAPON_TWO_HANDED_SWORD) {
			str += NAME_WEAPON_TWO_HANDED_SWORD;
		} else {
			str += "bug weapon";
		}
		if ((type == ITEM_WEAPON) && IS_TRUE(object & (ITEM_KNOWN | ITEM_IDENTIFY))) {
			str += getEnchantString(object);
		}
		if (count && (type == ITEM_SUBWEAPON)) {
			str += "(" +(object & 0xff) +")";
		}
	} else if (type == ITEM_SCROLL) {
		if (subenum < SCROLL_OBJECT_COUNT) {
			str += strScroll[subenum];
		} else {
			str += "scroll of bug";
		}
	} else if (type == ITEM_POTION) {
		if (subenum < POTION_OBJECT_COUNT) {
			str += strPotion[subenum];
		} else {
			str += "potion of bug";
		}
	} else if (type == ITEM_WAND) {
		if (subenum < WAND_OBJECT_COUNT) {
			str += strWand[subenum];
		} else {
			str += "wand of bug";
		}
		if (count) {
			if (IS_TRUE(object & ITEM_IDENTIFY)) {
				str += "[" +Integer.toString(object & 0x7f) +"]";
			} else if (IS_TRUE(object & 0x80)) {
#ifdef JP
				str += "()";
#else
				str += "(0)";
#endif
			}
		}
	} else if (type == ITEM_RING) {
		if (subenum < RING_OBJECT_COUNT) {
			str += strRing[subenum];
		} else {
			str += "ring of bug";
		}
	} else if (type == ITEM_AMULET) {
		if (IS_TRUE(object & ITEM_IDENTIFY)) {
			str += NAME_OF_AMULET_TRUE;
		} else {
			str += NAME_OF_AMULET;
		}
	} else {
		str += "bug item";
	}

FUNCTION_PRINT(functionName +" return " +str);
FUNCTION_RETURN();
	return str;
}

#if defined(DEBUG) || defined(WIZARD)
private static void debugPrintObject(int x, int y, int object) {
FUNCTION_CALLED("debugPrintObject(" +x +", " +y +", " +object +")");
FUNCTION_PRINT("call " +functionName);

	String str = "CreateObject("+x+","+y+"):";
	str += getObjectName(object, true);
	System.out.println(str);

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}
#endif

private void putObject(int object) {
FUNCTION_CALLED("putObject(" +object +")");
FUNCTION_PRINT("call " +functionName);

	randRoomPlace(MAP_FLAG_TRAP | MAP_ITEM_FLAG);
	int col = tempCol;
	int row = tempRow;
DEBUG_OBJECT_PRINT(col, row, object);
	dropObject(col, row, object);

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void putGold() {
FUNCTION_CALLED("putGold()");
FUNCTION_PRINT("call " +functionName);

#define PERCENT_GOLD 46
	int col, row;
	int rf;
	int object;
	int i;
	for (i=0; i<MAX_ROOM_COUNT; i++) {
		rf = room[i][ROOM_FLAG];
		if ( IS_FALSE(rf & (ROOM_ROOM | ROOM_MAZE)) ) continue;
		if ( IS_TRUE(rf & ROOM_MAZE) || randPercent(PERCENT_GOLD) ) {
			if (IS_TRUE(rf & ROOM_MAZE)) {
				object = randRandom(21 * curFloor) + curFloor*3;
			} else {
				object = randRandom(14 * curFloor) + curFloor*2;
			}
			object |= ITEM_GOLD;
			randPlace(MAP_FLAG_TRAP | MAP_ITEM_FLAG, i);
			col = tempCol;
			row = tempRow;
DEBUG_OBJECT_PRINT(col, row, object);
			dropObject(col, row, object);
		}
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void dropObject(int col, int row, int object) {
FUNCTION_CALLED("dropObject(" +col +", " +row +", 0x" +Integer.toHexString(object) +")");
FUNCTION_PRINT("call " +functionName);

	if (itemList[0] >= MAX_ITEM_COUNT) {
#ifdef JP
		message(getObjectName(object, true)+"͂ǂɏB");
#else
		message(getObjectName(object, true)+" disappear.");
#endif
		return;
	}

	//find place
	int dd;
	int x,y;
	if (IS_TRUE(dungeon[row][col] & MAP_ITEM_FLAG)) {
		x = -1;
		y = -1;
		do {
			dd = dungeon[row+y][col+x];
			if (   IS_FALSE(dd & MAP_ITEM_FLAG) 
				&& (((dd & MAP_OBJECT) == MAP_FLOOR) || ((dd & MAP_OBJECT) == MAP_TUNNEL)) 
			) {
				row = row+y;
				col = col+x;
				break;
			}
			x++;
			if (x>1) {
				y++;
				x = -1;
				if (y>1) {
#ifdef JP
					message(getObjectName(object, true)+"͂ǂɏB");
#else
					message(getObjectName(object, true)+" disappear.");
#endif
					return;
				}
			}
		} while (true);
	}

	//find index
	int index;
	//0 is a missing number
	for (index=1; index<MAX_ITEM_COUNT; index++) {
		if (itemList[index] == ITEM_NONE) {
			break;
		}
	}
#if 0
	if (index >= MAX_ITEM_COUNT) {
		return;
	}
#endif

	//drop
	object &= (~(ITEM_EQUIP | ITEM_EQUIP_LEFT));
	itemList[0]++;
	itemList[index] = object;
	dungeon[row][col] |= (index<<8);
	if (object == (DUST_SCROLL | 1)) {
		int monster = (dungeon[row][col] & MAP_MONSTER_FLAG);
		if (monster != 0) {
			monsterList[monster][MLIST_IS_MONSTER] = MONSTER_KIND_COUNT;
			monsterList[0][0]--;
			dungeon[row][col] &= (~(MAP_MONSTER_FLAG));
		}
		viewDraw();
#ifdef JP
		message(NAME_OF_SCROLL+"͔Rオ菰ɕcB");
#else
		message(NAME_OF_SCROLL+" blazed up and left the character to the floor.");
#endif
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private static int randObject() {
	int object = 0;
FUNCTION_CALLED("randObject()");
FUNCTION_PRINT("call " +functionName);

	object = randObjectType();
	if (object == ITEM_SCROLL) {
		object = randScroll();
	} else if (object == ITEM_POTION) {
		object = randPotion();
	} else if (object == ITEM_WEAPON) {
		object = randWepon();
	} else if (object == ITEM_ARMOR) {
		object = randArmor();
	} else if (object == ITEM_WAND) {
		object = randWand();
	} else if (object == ITEM_FOOD) {
		object = randFood();
	} else /*if (object == ITEM_RING)*/ {
		object = randRing();
	}
	if (hasObjectType(ITEM_AMULET)) {
		if (randPercent(25)) {
			object = randFood();
		}
	}

FUNCTION_PRINT(functionName +" return " +object);
FUNCTION_RETURN();
	return object;
}

private static int randObjectType() {
	int type=0;
FUNCTION_CALLED("randObjectType()");
FUNCTION_PRINT("call " +functionName);

#define PERCENT_SCROLL	300
#define PERCENT_POTION	600
#define PERCENT_WAND	640
#define PERCENT_WEAPON	740
#define PERCENT_ARMOR	830
#define PERCENT_FOOD	880
#define PERCENT_RING	910

	int per = randRandom(910);
	if (per <= PERCENT_SCROLL) {
		type = ITEM_SCROLL;
	} else if (per <= PERCENT_POTION) {
		type = ITEM_POTION;
	} else if (per <= PERCENT_WAND) {
		type = ITEM_WAND;
	} else if (per <= PERCENT_WEAPON) {
		type = ITEM_WEAPON;
	} else if (per <= PERCENT_ARMOR) {
		type = ITEM_ARMOR;
	} else if (per <= PERCENT_FOOD) {
		type = ITEM_FOOD;
	} else /*if (per <= PERCENT_RING)*/ {
		type = ITEM_RING;
	}

FUNCTION_PRINT(functionName +" return " +type);
FUNCTION_RETURN();
	return type;
}

private static int randScroll() {
	int ret = 0;
FUNCTION_CALLED("randScroll()");
FUNCTION_PRINT("call " +functionName);

#define PERCENT_SCROLL_PROTECT_ARMOR		50
#define PERCENT_SCROLL_HOLD_MONSTER			110
#define PERCENT_SCROLL_ENCH_WEAPON			160
#define PERCENT_SCROLL_ENCH_ARMOR			210
#define PERCENT_SCROLL_IDENTIFY				360
#define PERCENT_SCROLL_TELEPORT				440
#define PERCENT_SCROLL_SLEEP				510
#define PERCENT_SCROLL_SCARE_MONSTER		560
#define PERCENT_SCROLL_REMOVE_CURSE			650
#define PERCENT_SCROLL_CREATE_MONSTER		740
#define PERCENT_SCROLL_AGGRAVATE_MONSTER	800
#define PERCENT_SCROLL_MAGIC_MAPPING		850
	int per = randRandom(850);
	int type;
	if (per <= PERCENT_SCROLL_PROTECT_ARMOR) {
		type = SCROLL_PROTECT_ARMOR;
	} else if (per <= PERCENT_SCROLL_HOLD_MONSTER) {
		type = SCROLL_HOLD_MONSTER;
	} else if (per <= PERCENT_SCROLL_ENCH_WEAPON) {
		type = SCROLL_ENCH_WEAPON;
	} else if (per <= PERCENT_SCROLL_ENCH_ARMOR) {
		type = SCROLL_ENCH_ARMOR;
	} else if (per <= PERCENT_SCROLL_IDENTIFY) {
		type = SCROLL_IDENTIFY;
	} else if (per <= PERCENT_SCROLL_TELEPORT) {
		type = SCROLL_TELEPORT;
	} else if (per <= PERCENT_SCROLL_SLEEP) {
		type = SCROLL_SLEEP;
	} else if (per <= PERCENT_SCROLL_SCARE_MONSTER) {
		type = SCROLL_SCARE_MONSTER;
	} else if (per <= PERCENT_SCROLL_REMOVE_CURSE) {
		type = SCROLL_REMOVE_CURSE;
	} else if (per <= PERCENT_SCROLL_CREATE_MONSTER) {
		type = SCROLL_CREATE_MONSTER;
	} else if (per <= PERCENT_SCROLL_AGGRAVATE_MONSTER) {
		type = SCROLL_AGGRAVATE_MONSTER;
	} else /*if (per <= PERCENT_SCROLL_MAGIC_MAPPING)*/ {
		type = SCROLL_MAGIC_MAPPING;
	}

	ret = (ITEM_SCROLL | (type << 8));
FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

private static int randPotion() {
	int ret = 0;
FUNCTION_CALLED("randPotion()");
FUNCTION_PRINT("call " +functionName);

#define PERCENT_POTION_INCREASE_STRENGTH	100
#define PERCENT_POTION_RESTORE_STRENGTH		200
#define PERCENT_POTION_HEALING				300
#define PERCENT_POTION_EXTRA_HEALING		400
#define PERCENT_POTION_POISON				500
#define PERCENT_POTION_RAISE_LEVEL			550
#define PERCENT_POTION_BLINDNESS			650
#define PERCENT_POTION_HALLUCINATION		750
#define PERCENT_POTION_DETECT_MONSTER		850
#define PERCENT_POTION_DETECT_OBJECTS		950
#define PERCENT_POTION_CONFUSION			1050
#define PERCENT_POTION_LEVITATION			1100
#define PERCENT_POTION_HASTE_SELF			1140
#define PERCENT_POTION_SEE_INVISIBLE		1180
	int per = randRandom(1180);
	int type;
	if (per <= PERCENT_POTION_INCREASE_STRENGTH) {
		type = POTION_INCREASE_STRENGTH;
	} else if (per <= PERCENT_POTION_RESTORE_STRENGTH) {
		type = POTION_RESTORE_STRENGTH;
	} else if (per <= PERCENT_POTION_HEALING) {
		type = POTION_HEALING;
	} else if (per <= PERCENT_POTION_EXTRA_HEALING) {
		type = POTION_EXTRA_HEALING;
	} else if (per <= PERCENT_POTION_POISON) {
		type = POTION_POISON;
	} else if (per <= PERCENT_POTION_RAISE_LEVEL) {
		type = POTION_RAISE_LEVEL;
	} else if (per <= PERCENT_POTION_BLINDNESS) {
		type = POTION_BLINDNESS;
	} else if (per <= PERCENT_POTION_HALLUCINATION) {
		type = POTION_HALLUCINATION;
	} else if (per <= PERCENT_POTION_DETECT_MONSTER) {
		type = POTION_DETECT_MONSTER;
	} else if (per <= PERCENT_POTION_DETECT_OBJECTS) {
		type = POTION_DETECT_OBJECTS;
	} else if (per <= PERCENT_POTION_CONFUSION) {
		type = POTION_CONFUSION;
	} else if (per <= PERCENT_POTION_LEVITATION) {
		type = POTION_LEVITATION;
	} else if (per <= PERCENT_POTION_HASTE_SELF) {
		type = POTION_HASTE_SELF;
	} else /*if (per <= PERCENT_POTION_SEE_INVISIBLE)*/ {
		type = POTION_SEE_INVISIBLE;
	}

	ret = (ITEM_POTION | (type << 8));
FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

private static int randWepon() {
	int object=0;
FUNCTION_CALLED("randWepon()");
FUNCTION_PRINT("call " +functionName);

	int type = randRandom(WEAPON_OBJECT_COUNT);
	if (type <= SUBWEAPON_SHURIKEN) {
		object = ITEM_SUBWEAPON | (type<<8) | (randRandom(18)+5);
	} else {
		object = ITEM_WEAPON | (type<<8);
		object = randEnchant(object);
	}

FUNCTION_PRINT(functionName +" return " +object);
FUNCTION_RETURN();
	return object;
}

private static int randArmor() {
	int object = 0;
FUNCTION_CALLED("randArmor()");
FUNCTION_PRINT("call " +functionName);

	int type = randRandom(ARMOR_OBJECT_COUNT);
	object = ITEM_ARMOR | (type<<8);
	object = randEnchant(object);

FUNCTION_PRINT(functionName +" return " +object);
FUNCTION_RETURN();
	return object;
}

private static int randWand() {
	int ret = 0;
FUNCTION_CALLED("randWand()");
FUNCTION_PRINT("call " +functionName);

	int type = randRandom(WAND_OBJECT_COUNT);
	int count;
	if (type == WAND_MAGIC_MISSILE) {
		count = randRandom(7)+6;
	} else if (type == WAND_CANCELLATION) {
		count = randRandom(5)+5;
#if 0
	} else if (type == WAND_DO_NOTHING) {
		count = 0;
#endif
	} else {
		count = randRandom(4)+3;
	}

	ret = (ITEM_WAND | (type<<8) | count);
FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

private static int randFood() {
	int ret = 0;
FUNCTION_CALLED("randFood()");
FUNCTION_PRINT("call " +functionName);

	int type;
	if (randPercent(80)) {
		type = FOOD_RATION;
	} else {
		type = FOOD_LEMBAS;
	}

	ret = (ITEM_FOOD | type);
FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

private static int randRing() {
	int object = 0;
FUNCTION_CALLED("randRing()");
FUNCTION_PRINT("call " +functionName);

	int type = randRandom(RING_OBJECT_COUNT);
	object = ITEM_RING | (type<<8) | 4;
	if ((type == RING_STEALTH) || (type == RING_TELEPORT) ) {
		object |= ITEM_CURSED;
		object -= 2;
	} else if ( (type == RING_STRENGTH) || (type == RING_DEXTERITY) ) {
		object &= 0xffffff00;
		object = randEnchant(object);
		//+1or+3or-1
		object |= 1;
		object--;
	} else {
		if (randPercent(33)) {
			object |= ITEM_CURSED;
			object -= 2;
		}
	}

FUNCTION_PRINT(functionName +" return " +object);
FUNCTION_RETURN();
	return object;
}

private static int getRingPower(int ringType) {
	int ret = 0;
FUNCTION_CALLED("getRingPower(" +ringType +")");
FUNCTION_PRINT("call " +functionName);

	int object;
	for (int i=0; i<2; i++) {
		object = pcRing[i];
		if (object != 0) {
			if (((object & ITEM_SUBTYPE_FLAG) >> 8) == ringType) {
				ret += (object &= 0xff) -3;
			}
		}
	}

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

private static int randEnchant(int object) {
FUNCTION_CALLED("randEnchant(" +object +")");
FUNCTION_PRINT("call " +functionName);

	object += 3;
	int per = randRandom(96);
	if (per <= 32) {
		if (per <= 16) {
			object |= ITEM_CURSED;
			object--;
		} else {
			if (randBool()) object++;
			if (randBool()) object++;
			if (randBool()) object++;
		}
	}

FUNCTION_PRINT(functionName +" return " +object);
FUNCTION_RETURN();
	return object;
}

private static boolean hasObjectType(int type) {
	boolean ret = false;
FUNCTION_CALLED("hasObjectType(" +type +")");
FUNCTION_PRINT("call " +functionName);

	int index;
	for (index=0; index<pcPackCount; index++) {
		if ((pcPack[index] & ITEM_TYPE_FLAG) == type) {
			ret = true;
			break;
		}
	}

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}
