/*
 * This source herein may be modified and/or distributed by anybody who
 * so desires, with the following restrictions:
 *    1.)  No portion of this notice shall be removed.
 *    2.)  Credit shall not be taken for the creation of this source.
 *    3.)  This code is not to be traded, sold, or used for personal
 *         gain or profit.
 */

#if !defined(HANKAKU) && defined(JP)
#define MAX_KANA_TYPE	4
#define MAX_KANA_COL	10
#define MAX_KANA_ROW	5
#else
#define MAX_KANA_TYPE	1
#define MAX_KANA_COL	14
#define MAX_KANA_ROW	5
#endif
private static char[][][] kana = {
#ifdef JP
	{
		{'', '', '', '', ''},
		{'', '', '', '', ''},
		{'', '', '', '', ''},
		{'', '', '', '', ''},
		{'', '', '', '', ''},
		{'', '', '', '', ''},
		{'', '', '', '', ''},
		{'', '', '', '', ''},
		{'', '', '', '', ''},
		{'', 'J', 'K', '[', '@'},
	},
	{
		{'A', 'C', 'E', 'G', 'I'},
		{'J', 'L', 'N', 'P', 'R'},
		{'T', 'V', 'X', 'Z', '\'},
		{'^', '`', 'c', 'e', 'g'},
		{'i', 'j', 'k', 'l', 'm'},
		{'n', 'q', 't', 'w', 'z'},
		{'}', '~', '', '', ''},
		{'', '', '', '', ''},
		{'', '', '', '', ''},
		{'', 'J', 'K', '[', '@'},
	},
	{
		{'A', 'B', 'C', 'D', 'E'},
		{'F', 'G', 'H', 'I', 'J'},
		{'K', 'L', 'M', 'N', 'O'},
		{'P', 'Q', 'R', 'S', 'T'},
		{'U', 'V', 'W', 'X', 'Y'},
		{'Z', ' ', ' ', ' ', ' '},
		{'1', '2', '3', '4', '5'},
		{'6', '7', '8', '9', '0'},
		{CHAR_NOTHING, CHAR_HORWALL, CHAR_VERTWALL, CHAR_FLOOR, CHAR_TUNNEL},
		{CHAR_DOOR, CHAR_STAIRS, CHAR_TRAP_DOOR, CHAR_TRAP_BEAR, CHAR_TRAP_TELEPORT},
	},
	{
		{'a', 'b', 'c', 'd', 'e'},
		{'f', 'g', 'h', 'i', 'j'},
		{'k', 'l', 'm', 'n', 'o'},
		{'p', 'q', 'r', 's', 't'},
		{'u', 'v', 'w', 'x', 'y'},
		{'z', CHAR_SCROLL, CHAR_WAND, CHAR_AMULET, CHAR_ROGUE},
		{'1', '2', '3', '4', '5'},
		{'6', '7', '8', '9', '0'},
		{CHAR_TRAP_DART, CHAR_TRAP_SLEEPGAS, CHAR_TRAP_RUST, CHAR_GOLD, CHAR_FOOD},
		{CHAR_WEAPON, CHAR_ARMOR, CHAR_SUBWEAPON, CHAR_RING, CHAR_POTION},
	},
#else
	{
		{'N', ' ', 'n', ' ', ' '},
		{'M', ' ', 'm', ' ', ' '},
		{'L', 'Z', 'l', 'z', ' '},
		{'K', 'Y', 'k', 'y', ' '},
		{'J', 'X', 'j', 'x', '0'},
		{'I', 'W', 'i', 'w', '9'},
		{'H', 'V', 'h', 'v', '8'},
		{'G', 'U', 'g', 'u', '7'},
		{'F', 'T', 'f', 't', '6'},
		{'E', 'S', 'e', 's', '5'},
		{'D', 'R', 'd', 'r', '4'},
		{'C', 'Q', 'c', 'q', '3'},
		{'B', 'P', 'b', 'p', '2'},
		{'A', 'O', 'a', 'o', '1'},
	},
#endif
};

private static void drawKana(int type) {
FUNCTION_CALLED("drawKana(" +type +")");
FUNCTION_PRINT("call " +functionName);

	offGraphics.setColor(COLOR_BLACK);
	offGraphics.fillRect(0, fontHeight*2, offImage.getWidth(), fontHeight*MAX_KANA_ROW);
	offGraphics.setColor(COLOR_WHITE);

	int x,y;
	for (x=0; x<MAX_KANA_ROW; x++) {
		for (y=0; y<MAX_KANA_COL; y++) {
			offGraphics.DRAWCHARS(kana[type][y], x, 1, fontWidth*(MAX_KANA_COL-1-y), fontHeight*(x+3));
		}
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void drawCursor(int type, int col, int row, int color) {
FUNCTION_CALLED("drawCursor(" +type +", " +col +", " +row +", 0x" +Integer.toHexString(color) +")");
FUNCTION_PRINT("call " +functionName);

	int x = fontWidth*(MAX_KANA_COL-1-col);
	int y = fontHeight*(2+row);
	offGraphics.setColor(color);
	offGraphics.drawRect(x, y, fontWidth, fontHeight);

	offGraphics.setColor(COLOR_WHITE);
								//(col,row)not reverse
	offGraphics.DRAWCHARS(kana[type][col], row, 1, x, y+fontHeight);

	REPAINT();

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private static void drawInfo(String info) {
FUNCTION_CALLED("drawInfo(" +info +")");
FUNCTION_PRINT("call " +functionName);

	offGraphics.setColor(COLOR_BLACK);
	offGraphics.fillRect(0, 0, offImage.getWidth(), offImage.getHeight());
	offGraphics.setColor(COLOR_WHITE);

	offGraphics.DRAWSTRING(info, 0, fontHeight);
#ifdef JP
	offGraphics.DRAWSTRING("*: 0:DEL #:ؑ", 0, fontHeight*9);
#else
	offGraphics.DRAWSTRING("*:OK 0:delete", 0, fontHeight*9);
#endif

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void drawName(String name) {
FUNCTION_CALLED("drawName(" +name +")");
FUNCTION_PRINT("call " +functionName);

	offGraphics.setColor(COLOR_BLACK);
	offGraphics.fillRect(0, fontHeight*1, offImage.getWidth(), fontHeight);
	offGraphics.setColor(COLOR_WHITE);
	offGraphics.DRAWSTRING(name, 0, fontHeight*2);
	REPAINT();

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private String inputName(String info, String defaultName) {
	String ret = defaultName;
FUNCTION_CALLED("inputName(" +info +", " +defaultName +")");
FUNCTION_PRINT("call " +functionName);

	drawInfo(info);
	int type = 0;
	drawKana(type);
	drawName(ret);

#if !defined(HANKAKU) && defined(JP)
	int cCol = 0;
#else
	int cCol = MAX_KANA_COL -1;
#endif
	int cRow = 0;
	drawCursor(type, cCol, cRow, COLOR_YELLOW);
	mode = MODE_ITEM1;
	command = 0;
	while (true) {
		Sleep();
		int key = command;
		if (key != 0) {
			if (key == COMMAND_KEY_POUND) {
				type++;
				if (type >= MAX_KANA_TYPE) type = 0;
				drawKana(type);
				drawCursor(type, cCol, cRow, COLOR_YELLOW);
			} else if (key == COMMAND_KEY_ASTERISK) {
				break;
			} else if (key == COMMAND_KEY_0) {
				if (ret.length() > 0) {
					ret = ret.substring(0, ret.length() -1);
					drawName(ret);
				}
			} else if (IS_TRUE(key & COMMAND_NUMBER)) {
				drawCursor(type, cCol, cRow, COLOR_BLACK);
				int dir = key & 0xff;
				if (dir == 1) {
					cCol++;
					cRow--;
				} else if (dir == 2) {
					cRow--;
				} else if (dir == 3) {
					cCol--;
					cRow--;
				} else if (dir == 4) {
					cCol++;
				} else if (dir == 5) {
#ifdef JP
					if (ret.length() < MAX_NAME_LENGTH) {
#else
					if (ret.length() < MAX_NAME_LENGTH*2) {
#endif
						ret += kana[type][cCol][cRow];
						drawName(ret);
					}
				} else if (dir == 6) {
					cCol--;
				} else if (dir == 7) {
					cCol++;
					cRow++;
				} else if (dir == 8) {
					cRow++;
				} else if (dir == 9) {
					cCol--;
					cRow++;
				}
				if (cCol < 0) {
					cCol += MAX_KANA_COL;
				} else if (cCol >= MAX_KANA_COL) {
					cCol -= MAX_KANA_COL;
				}
				if (cRow < 0) {
					cRow += MAX_KANA_ROW;
				} else if (cRow >= MAX_KANA_ROW) {
					cRow -= MAX_KANA_ROW;
				}
				drawCursor(type, cCol, cRow, COLOR_YELLOW);
			}
			command = 0;
		}
	}
	mode = MODE_GAME;
	command = 0;

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}
