/*
 * This source herein may be modified and/or distributed by anybody who
 * so desires, with the following restrictions:
 *    1.)  No portion of this notice shall be removed.
 *    2.)  Credit shall not be taken for the creation of this source.
 *    3.)  This code is not to be traded, sold, or used for personal
 *         gain or profit.
 */

private boolean pcMove(int dir) {
FUNCTION_CALLED("pcMove(" +dir +")");
FUNCTION_PRINT("call " +functionName);

#if 0
	if (dir == 5) {
		search();
		return false;
	}
#endif

	if (pcState[STATE_CONFUSED] > 0) {
		dir = randMovableDir(pcCol, pcRow);
		moveStop = true;
	}
	//123
	//4@6
	//789
	int col = pcCol +((dir-1) % 3) -1;
	int row = pcRow +((dir-1) / 3) -1;
	boolean movable = false;
	do {
		if (!(mapMovable(pcCol, row, false) && mapMovable(col, pcRow, false))) break;
		if (!mapMovable(col, row, false)) break;
		movable = true;
	} while (false);
	if (!movable) {
		if (pcState[STATE_BLINDNESS] <= 0) return false;
	}

	int monster = dungeon[row][col] & MAP_MONSTER_FLAG;
	if (monster != 0) {
		playersAttack(monster, false);
	} else if (pcState[STATE_BEING_HELD] > 0) {
#ifdef JP
		message("݂ĈړłȂB");
#else
		message("you are being held.");
#endif
		return false;
	} else if (pcState[STATE_BEAR_TRAP] > 0) {
		pcState[STATE_BEAR_TRAP]--;
		if (pcState[STATE_BEAR_TRAP] <= 0) {
			message(strStateEnd[STATE_BEAR_TRAP]);
		} else {
#ifdef JP
			message("ȂȂF̂Ȃ͂ȂB");
#else
			message("you are still stuck in the bear trap.");
#endif
		}
	} else if (!movable) {
		dungeon[row][col] |= MAP_FLAG_KNOWN;
		screenBuf[row][col] = mapFlag2char(dungeon[row][col]);
#ifdef JP
		message("ɂ͕ǂ悤B");
#else
		message("feel a wall blocking your way.");
#endif
	} else {
		MESSAGE_REMOVE();
		pcMoved(col, row, true, false);
	}

	if (!trapDoor) nextTurn();

FUNCTION_PRINT(functionName +" return true");
FUNCTION_RETURN();
	return true;
}

//dir:check dir
private int getDirMask6(int dir) {
	int ret=0;
FUNCTION_CALLED("getDirMask6(" +dir +")");
FUNCTION_PRINT("call " +functionName);

#define MAKE_MASK_CHECK_DIR(i)	( (i<<18) | (i<<9) | (i) )
#define MASK_CHECK_CROSS	0x0aa
//010	0 1010 1010
//1@1
//010
#define MASK_CHECK_DIR5		0x010
//000	0 0001 0000
//010
//000
#define MASK6_CHECK_DIR2	MAKE_MASK_CHECK_DIR(0x1f8)
//111	1 1110 1000
//1@1
//000
#define MASK6_CHECK_DIR4	MAKE_MASK_CHECK_DIR(0x1a6)
//110	1 1010 0110
//1@0
//110
#define MASK6_CHECK_DIR6	MAKE_MASK_CHECK_DIR(0x1cb)
//011	0 1100 1011
//0@1
//011
#define MASK6_CHECK_DIR8	MAKE_MASK_CHECK_DIR(0x02f)
//000	0 0010 1111
//1@1
//111
	if (dir == 2) {
		ret = MASK6_CHECK_DIR2;
	} else if (dir == 4) {
		ret = MASK6_CHECK_DIR4;
	} else if (dir == 6) {
		ret = MASK6_CHECK_DIR6;
	} else if (dir == 8) {
		ret = MASK6_CHECK_DIR8;
	} else {
		ret = -1;
	}

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

//dir:check dir
private int getDirMask3(int dir) {
	int ret=0;
FUNCTION_CALLED("getDirMask3(" +dir +")");
FUNCTION_PRINT("call " +functionName);

#define MASK3_CHECK_DIR2	MAKE_MASK_CHECK_DIR(0x1c8)
//111	1 1100 1000
//0@0
//000
#define MASK3_CHECK_DIR4	MAKE_MASK_CHECK_DIR(0x124)
//100	1 0010 0100
//1@0
//100
#define MASK3_CHECK_DIR6	MAKE_MASK_CHECK_DIR(0x049)
//001	0 0100 1001
//0@1
//001
#define MASK3_CHECK_DIR8	MAKE_MASK_CHECK_DIR(0x007)
//000	0 0000 0111
//0@0
//111
	if (dir == 2) {
		ret = MASK3_CHECK_DIR2;
	} else if (dir == 4) {
		ret = MASK3_CHECK_DIR4;
	} else if (dir == 6) {
		ret = MASK3_CHECK_DIR6;
	} else if (dir == 8) {
		ret = MASK3_CHECK_DIR8;
	} else {
		ret = -1;
	}

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

private int check8move() {
	int ret = 0;
FUNCTION_CALLED("check8move()");
FUNCTION_PRINT("call " +functionName);

	int x,y;
	for (y=-1; y<=1; y++) {
		for (x=-1; x<=1; x++) {
			ret <<= 1;
			//movable terrain
			if (mapMovable(pcCol +x, pcRow +y, false)) {
				ret++;
			}
		}
	}

FUNCTION_PRINT(functionName +" return "+ ret);
FUNCTION_RETURN();
	return ret;
}

private int check8dir() {
	int ret = 0;
FUNCTION_CALLED("check8dir()");
FUNCTION_PRINT("call " +functionName);

	int dd;
	int n=0;
	int x,y;
	for (y=-1; y<=1; y++) {
		for (x=-1; x<=1; x++) {
			ret <<= 1;
			dd = dungeon[pcRow +y][pcCol +x];
			//monster
			if (IS_TRUE(dd & MAP_MONSTER_FLAG)) {
				ret |= (1<<18);
			}
			//item
			if (IS_TRUE(dd & MAP_ITEM_FLAG)) {
				ret |= (1<<9);
			}
			//trap(see)
			if (IS_TRUE(dd & MAP_HIDE_FLAG) && IS_TRUE(dd & MAP_FLAG_FOUND)) {
				if ((dd & MAP_HIDE_FLAG) >= MAP_HIDE_TUNNEL) {
					//door is only up down left right
					if ((n & 1) != 0) {
						if ((dd & MAP_HIDE_FLAG) >= MAP_HIDE_DOOR_H) {
							ret |= 1;
						}
					}
				} else {
					ret |= 1;
				}
			}
			//stairs
			if ((dd & MAP_OBJECT_FLAG) == MAP_STAIRS) {
				ret |= 1;
			}
			//door
			if ((dd & MAP_OBJECT_FLAG) == MAP_DOOR) {
				//door is only up down left right
				if ((n & 1) != 0) {
					ret |= 1;
				}
			}
			n++;
		}
	}

FUNCTION_PRINT(functionName +" return "+ ret);
FUNCTION_RETURN();
	return ret;
}

private void pcMoveShift(int dir) {
FUNCTION_CALLED("pcMoveShift(" +dir +")");
FUNCTION_PRINT("call " +functionName);

	int preCol = pcCol;
	int preRow = pcRow;

	int move = check8move();
	int mask = getDirMask6(dir);
	moveStop = false;
	boolean door = false;
	int dd = dungeon[pcRow][pcCol] & MAP_OBJECT;
	if (((dd & MAP_OBJECT_FLAG) == MAP_DOOR) || (dd >= MAP_HIDE_DOOR_H)) {
		door = true;
	}

	//one move
	if (!pcMove(dir)) {
		return;
	}
	if (pcState[STATE_BLINDNESS] > 0) {
		return;
	}
	if (door && ((dungeon[pcRow][pcCol] & MAP_OBJECT_FLAG) == MAP_FLOOR)) {
		moveStop = true;
	}

	//straight
	if ((dungeon[pcRow][pcCol] & MAP_OBJECT_FLAG) == MAP_FLOOR) {
		while (true) {
			if (moveStop) return;
			if ((check8dir() & mask) != 0) {
				return;
			}
			if (!pcMove(dir)) {
				break;
			}
		}
		if ((dungeon[pcRow][pcCol] & MAP_OBJECT_FLAG) == MAP_FLOOR) {
			return;
		}
	}

	//follow
	while (!moveStop) {
		if ((check8dir() & getDirMask6(dir)) != 0) {
			return;
		}
		//check dir
		move = bitCount(check8move() & getDirMask6(dir) & MASK_CHECK_CROSS);
		if (move != 1) {
			return;
		}
		if ((dir == 2) || (dir == 8)) {
			//4or6
			if (mapMovable(pcCol -1, pcRow, false)) {
				if (mapMovable(pcCol +1, pcRow, false)) {
					return;
				}
				dir = 4;
			} else {
				if (mapMovable(pcCol +1, pcRow, false)) {
					dir = 6;
				//} else {
					//dir = dir;
				}
			}
		} else if ((dir == 4) || (dir == 6)) {
			//2or8
			if (mapMovable(pcCol, pcRow -1, false)) {
				if (mapMovable(pcCol, pcRow +1, false)) {
					return;
				}
				dir = 2;
			} else {
				if (mapMovable(pcCol, pcRow +1, false)) {
					dir = 8;
				//} else {
					//dir = dir;
				}
			}
		} else {//
			return;
		}
		//go
		if (!pcMove(dir)) {
			break;
		}
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

//only terrain check
private static boolean mapMovable(int col, int row, boolean forceFound) {
FUNCTION_CALLED("mapMovable(" +col +", " +row +", " +forceFound +")");
FUNCTION_PRINT("call " +functionName);

#if 0
	if ((col < 0) || (row < 0) || (col >= DUNGEON_COLS) || (row >= DUNGEON_ROWS)) return false;
#endif

	int dd;
	dd = dungeon[row][col] & MAP_OBJECT;
	if (dd <= MAP_VERTWALL) {
		return false;
	}

	dd = dungeon[row][col];
	if (IS_TRUE(dd & MAP_HIDE_FLAG)) {
		if (!forceFound && IS_FALSE(dd & MAP_FLAG_FOUND)) {
			dd = dd & MAP_HIDE_FLAG;
			if (dd >= MAP_HIDE_TUNNEL) return false;
		}
	}

FUNCTION_PRINT(functionName +" return true");
FUNCTION_RETURN();
	return true;
}

private void pcMoved(int col, int row, boolean trapOn, boolean searchOn) {
FUNCTION_CALLED("pcMoved(" +col +", " +row +", " +trapOn +", " +searchOn +")");
FUNCTION_PRINT("call " +functionName);

	if ( (pcCol != col) || (pcRow != row) ) {
		movedPlayer = true;
	}
//DEBUG_PRINT("pcMoved() pcMoved("+col+","+row+")");

	int dd = dungeon[row][col];
	boolean trap = IS_TRUE(dd & MAP_FLAG_TRAP);
	dd = dd & MAP_OBJECT_FLAG;
	int newno = getRoomNum(col, row, true);
	if (newno != MAX_ROOM_COUNT) {
		if (newno != pcRoomNum) {
			roomLightUp(newno, true);
		} else if (IS_FALSE(room[newno][ROOM_FLAG] & ROOM_PASSAGE)) {
			roomLightUp(newno, false);
		}
	}
	pcRoomNum = newno;
	pcCol = col;
	pcRow = row;
	if (trapOn && trap) {
		pcTrap();
		if (trapDoor) {
			newFloor();
			return;
		}
	}

	if (pcState[STATE_BLINDNESS] > 0) {
		dungeon[pcRow][pcCol] |= MAP_FLAG_KNOWN;
		screenBuf[pcRow][pcCol] = mapFlag2char(dungeon[pcRow][pcCol]);
	} else {
		int hd;
		int findPer = 10;
		if (searchOn) {
			findPer = 33;
		}
		if ((pcState[STATE_SEE_INVISIBLE] > 0) || (getRingPower(RING_SEE_INVISIBLE) != 0) || (getRingPower(RING_SEARCHING) != 0)) {
			findPer = 100;
		}
		int x,y;
		for (y=-1; y<=1; y++) {
			for (x=-1; x<=1; x++) {
				dungeon[pcRow+y][pcCol+x] |= MAP_FLAG_KNOWN;
				screenBuf[pcRow+y][pcCol+x] = mapFlag2char(dungeon[pcRow+y][pcCol+x]);
				hd = dungeon[pcRow+y][pcCol+x];
				if (IS_TRUE(hd & MAP_HIDE_FLAG) && IS_FALSE(hd & MAP_FLAG_FOUND)) {
					if (randPercent(findPer)) {
						dungeon[pcRow+y][pcCol+x] |= MAP_FLAG_FOUND;
						screenBuf[pcRow+y][pcCol+x] = CHARMAPFOUND(dungeon[pcRow+y][pcCol+x]);
						viewDraw();
#ifdef JP
						message(STRMAPHIDE(hd) +"𔭌B");
#else
						message("found " +STRMAPHIDE(hd) +".");
#endif
					}
				}
			}
		}
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void search() {
FUNCTION_CALLED("search()");
FUNCTION_PRINT("call " +functionName);

	pcMoved(pcCol, pcRow, false, true);
	nextTurn();

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private static int randDir() {
	int ret=0;
FUNCTION_CALLED("randDir()");
FUNCTION_PRINT("call " +functionName);

	int i;
	for (i=0; i<MAX_ROOM_COUNT; i++) {
		roomTemp[i] = i+1;
	}
	int r,t;
	for (i=0; i<MAX_ROOM_COUNT; i++) {
		r = randRandom(MAX_ROOM_COUNT);
		t = roomTemp[r];
		roomTemp[r] = roomTemp[i];
		roomTemp[i] = t;
	}
	ret = roomTemp[randRandom(MAX_ROOM_COUNT)];

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

private static boolean monsterCanGo(int monster, int col, int row) {
	boolean ret = false;
FUNCTION_CALLED("monsterCanGo(" +monster +", " +col +", " +row +")");
FUNCTION_PRINT("call " +functionName);

	int mcol = monsterList[monster][MLIST_COL];
	int mrow = monsterList[monster][MLIST_ROW];

	if (!(
				(monsterCanGoSub(monster, mcol, row) != -1)
			 && (monsterCanGoSub(monster, col, mrow) != -1)
		)
	) {
		ret = false;
	} else if (monsterCanGoSub(monster, col, row) == 1) {
		ret = true;
	}

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

private static int monsterCanGoSub(int monster, int col, int row) {
	int ret = 1;
FUNCTION_CALLED("monsterCanGoSub(" +monster +", " +col +", " +row +")");
FUNCTION_PRINT("call " +functionName);

	int dd = dungeon[row][col];
	if ( (dd & MAP_OBJECT) <= MAP_VERTWALL ) {
		ret = -1;
	} else if ( IS_TRUE(dd & MAP_MONSTER_FLAG) ) {
		if ( (dd & MAP_MONSTER_FLAG) != monster ) {
			ret = 0;
		}
	} else if ( IS_TRUE(dd & MAP_ITEM_FLAG) ) {
		dd = (dd & MAP_ITEM_FLAG) >> 8;
		dd = itemList[dd] & (ITEM_TYPE_FLAG | ITEM_SUBTYPE_FLAG);
		if ( dd == (ITEM_SCROLL | (SCROLL_SCARE_MONSTER << 8)) ) {
			ret = 0;
		}
	}

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

private static int randMovableDir(int col, int row) {
	int ret=0;
FUNCTION_CALLED("randMovableDir()");
FUNCTION_PRINT("call " +functionName);

	int i;
	int n=0;
	for (i=0; i<9; i++) {
		int movecol = col +(i % 3) -1;
		int moverow = row +(i / 3) -1;
		if (!(mapMovable(col, moverow, true) && mapMovable(movecol, row, true))) continue;
		if (mapMovable(movecol, moverow, true)) {
			roomTemp[n] = i;
			n++;
		}
	}
	int r,t;
	for (i=0; i<n; i++) {
		r = randRandom(n);
		t = roomTemp[r];
		roomTemp[r] = roomTemp[i];
		roomTemp[i] = t;
	}
	ret = roomTemp[randRandom(n)] +1;

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

private void monsterMoveTo(int monster, int col, int row, boolean onceMore) {
FUNCTION_CALLED("monsterMoveTo(" +monster +", " +col +", " +row +", " +onceMore +")");
FUNCTION_PRINT("call " +functionName);

	boolean flies = IS_TRUE(monsterList[monster][MLIST_FLAG] & MFLAG_FLIES);
	if (IS_TRUE(monsterList[monster][MLIST_FLAG] & MFLAG_SLOWED)) {
		flies = false;
	}
	int dcol = col - monsterList[monster][MLIST_COL];
	int drow = row - monsterList[monster][MLIST_ROW];
	boolean rowPriority = true;
	if (ABSINT(dcol) < ABSINT(drow)) {
		rowPriority = false;
	}
	int dir = 5;
	if (dcol > 0) {
		dir++;
	} else if (dcol < 0) {
		dir--;
	}
	if (drow > 0) {
		dir += 3;
	} else if (drow < 0) {
		dir -= 3;
	}
	if (dir != 5) {
		monsterMoveDir(monster, dir, rowPriority, false);
	}

	if (onceMore && flies) monsterMoveTo(monster, col, row, false);

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void monsterMoveDir(int monster, int dir, boolean rowPriority, boolean onceMore) {
FUNCTION_CALLED("monsterMoveDir(" +monster +", " +dir +", " +rowPriority +", " +onceMore +")");
FUNCTION_PRINT("call " +functionName);

	boolean flies = IS_TRUE(monsterList[monster][MLIST_FLAG] & MFLAG_FLIES);
	if (IS_TRUE(monsterList[monster][MLIST_FLAG] & MFLAG_SLOWED)) {
		flies = false;
	}
	int mcol = monsterList[monster][MLIST_COL];
	int mrow = monsterList[monster][MLIST_ROW];
	if ((dir == 5) || (dir < 1) || (dir > 9)) {
		dir = randDir();
	}
	int dcol = ((dir-1) % 3) -1;
	int drow = ((dir-1) / 3) -1;

	if (!monsterCanGo(monster, mcol +dcol, mrow +drow)) {
		if (dcol == 0) {
//1*2  ...
//3@4  3@4
//...  1*2
			if (!monsterCanGo(monster, mcol, mrow +drow)) {
				if (monsterCanGo(monster, mcol -1, mrow +drow)) {
					dcol = -1;
				} else if (monsterCanGo(monster, mcol +1, mrow +drow)) {
					dcol = 1;
				} else {
					drow = 0;
					if (monsterCanGo(monster, mcol -1, mrow)) {
						dcol = -1;
					} else if (monsterCanGo(monster, mcol +1, mrow)) {
						dcol = 1;
					}
				}
			}
		} else if (drow == 0) {
//24.  .42
//*@.  .@*
//13.  .31
			if (!monsterCanGo(monster, mcol +dcol, mrow)) {
				if (monsterCanGo(monster, mcol +dcol, mrow -1)) {
					drow = -1;
				} else if (monsterCanGo(monster, mcol +dcol, mrow +1)) {
					drow = 1;
				} else {
					dcol = 0;
					if (monsterCanGo(monster, mcol, mrow -1)) {
						drow = -1;
					} else if (monsterCanGo(monster, mcol, mrow +1)) {
						drow = 1;
					}
				}
			}
		} else {
//*2.  .2*  ...  ...
//1@.  .@1  1@.  .@1
//...  ...  *2.  .2*
			if (!monsterCanGo(monster, mcol +dcol, mrow +drow)) {
				if (rowPriority) {
					if (monsterCanGo(monster, mcol, mrow +drow)) {
						dcol = 0;
					} else if (monsterCanGo(monster, mcol +dcol, mrow)) {
						drow = 0;
					} else {
						dcol = 0;
						drow = 0;
					}
				} else {
					if (monsterCanGo(monster, mcol +dcol, mrow)) {
						drow = 0;
					} else if (monsterCanGo(monster, mcol, mrow +drow)) {
						dcol = 0;
					} else {
						dcol = 0;
						drow = 0;
					}
				}
			}
		}
	}

	if ( !((dcol == 0) && (drow == 0)) ) {
		monsterMoved(monster, mcol +dcol, mrow +drow);
	}

	if (onceMore && flies) monsterMoveDir(monster, dir, rowPriority, false);

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void monsterMoved(int monster, int col, int row) {
FUNCTION_CALLED("monsterMoved(" +monster +", " +col +", " +row +")");
FUNCTION_PRINT("call " +functionName);

	movedMonster = true;
	if ( (col == pcCol) && (row == pcRow) ) {
		return;
	}

	int mcol = monsterList[monster][MLIST_COL];
	int mrow = monsterList[monster][MLIST_ROW];

	monsterList[monster][MLIST_PRE_COL] = mcol;
	monsterList[monster][MLIST_PRE_ROW] = mrow;
	dungeon[mrow][mcol] &= (~MAP_MONSTER_FLAG);

	int dcol = col -mcol;
	int drow = row -mrow;
	int dir = 5;
	if (dcol > 0) {
		dir++;
	} else if (dcol < 0) {
		dir--;
	}
	if (drow > 0) {
		dir += 3;
	} else if (drow < 0) {
		dir -= 3;
	}
	monsterList[monster][MLIST_PRE_DIR] = dir;

	monsterList[monster][MLIST_COL] = col;
	monsterList[monster][MLIST_ROW] = row;

	dungeon[row][col] |= monster;
	if ((dungeon[row][col] & MAP_HIDE_FLAG) >= MAP_HIDE_TUNNEL) {
		dungeon[row][col] |= MAP_FLAG_FOUND;
		if (IS_TRUE(dungeon[row][col] & MAP_FLAG_KNOWN)) {
			screenBuf[row][col] = CHARMAPFOUND(dungeon[row][col]);
		}
	}

	if (monsterCanSeePC(col, row) && IS_FALSE(monsterList[monster][MLIST_FLAG] & MFLAG_GETAWAY)) {
		monsterList[monster][MLIST_TARGET_COL] = pcCol;
		monsterList[monster][MLIST_TARGET_ROW] = pcRow;
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void pcTrap() {
FUNCTION_CALLED("pcTrap()");
FUNCTION_PRINT("call " +functionName);

	if (pcState[STATE_LEVITATE] > 0) return;
	int dd = dungeon[pcRow][pcCol];
	int type = (dd & MAP_HIDE_FLAG);
	if (type >= MAP_HIDE_TUNNEL) return;
	if (type == MAP_TRAP_NON) return;
	dungeon[pcRow][pcCol] |= MAP_FLAG_FOUND;
	screenBuf[pcRow][pcCol] = CHARMAPFOUND(dungeon[pcRow][pcCol]);

	if (randPercent(pcLevel + getRingPower(RING_DEXTERITY)*10)) {
#ifdef JP
		message("낤AȂɂ͂܂Ƃ낾B");
#else
		message("the trap failed.");
#endif
	} else 
	if (type == MAP_TRAP_DOOR) {
#ifdef JP
		message("}ɏꂽI");
#else
		message("You fell down a trap!");
#endif
		more();
		pcKilledBy = 27;
		pcDamage(randRandom(6)+1);
		trapDoor = true;
	} else if (type == MAP_TRAP_BEAR) {
		pcState[STATE_BEAR_TRAP] = randRandom(4)+4;
#ifdef JP
		message("F̂Ȃɂ܂I");
#else
		message("You are caught in a bear trap!");
#endif
	} else if (type == MAP_TRAP_TELEPORT) {
		pcTeleport();
	} else if (type == MAP_TRAP_DART) {
#ifdef JP
		message("łāAɂI");
#else
		message("a small dart just hit you in the shoulder!");
#endif
		pcKilledBy = 28;
		pcPoison(true);
	} else if (type == MAP_TRAP_SLEEPGAS) {
		pcFreeze(false);
#ifdef JP
		message("svcȂɂ܂A܂ЂĂ܂I");
#else
		message("a strange white mist envelops you and you fall asleep!");
#endif
	} else if (type == MAP_TRAP_RUST) {
#ifdef JP
		message("̏ォʂ̐~ĂI");
#else
		message("a gush of water hits you on the head!");
#endif
		pcRust();
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}
