/*
 * This source herein may be modified and/or distributed by anybody who
 * so desires, with the following restrictions:
 *    1.)  No portion of this notice shall be removed.
 *    2.)  Credit shall not be taken for the creation of this source.
 *    3.)  This code is not to be traded, sold, or used for personal
 *         gain or profit.
 */

private void setPlayerAndMonsters() {
FUNCTION_CALLED("setPlayerAndMonsters()");
FUNCTION_PRINT("call " +functionName);

	int n = randRandom(3)+4;
#if 0
	n=0;
#endif

	pcRoomNum = randRoomPlace(MAP_FLAG_TRAP | MAP_ITEM_FLAG | MAP_MONSTER_FLAG);
	pcCol = tempCol;
	pcRow = tempRow;

	int i;
	for (i=0; i<n; i++) {
		putMonster(MAX_ROOM_COUNT);
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void putMonster(int forbidden) {
FUNCTION_CALLED("putMonster(" +forbidden +")");
FUNCTION_PRINT("call " +functionName);

	int index = makeMonster();
	if (index <= 0) return;
	int no = randRoomPlace(MAP_MONSTER_FLAG);
	int col = tempCol;
	int row = tempRow;
	if ((no == forbidden) || ((col == pcCol) && (row == pcRow)) ) {
		monsterList[index][MLIST_IS_MONSTER] = MONSTER_KIND_COUNT;
		return;
	}

	//if (true) {
	if (IS_TRUE(monsterList[index][MLIST_FLAG] & MFLAG_MIMIC)) {
		if ((itemList[0] >= MAX_ITEM_COUNT) || IS_TRUE(dungeon[row][col] & (MAP_FLAG_TRAP | MAP_ITEM_FLAG)) || randPercent(30)) {
			//other monster
			monsterList[index][MLIST_CHAR] = monsterCatalog[randRandom(MONSTER_KIND_COUNT)][MCATALOG_CHAR];
		} else {
			//item
			monsterList[index][MLIST_IS_MONSTER] = MONSTER_KIND_COUNT;
			int object = randObject();
			object |= ITEM_MIMIC;
			dropObject(col, row, object);
			return;
		}
	}
#if 0
	if (true) {
		monsterList[index][MLIST_IS_MONSTER] = MONSTER_KIND_COUNT;
		return;
	}
#endif
	monsterList[0][0]++;
	monsterList[index][MLIST_COL] = col;
	monsterList[index][MLIST_ROW] = row;
	monsterList[index][MLIST_TARGET_COL] = col;
	monsterList[index][MLIST_TARGET_ROW] = row;
	monsterList[index][MLIST_PRE_COL] = col;
	monsterList[index][MLIST_PRE_ROW] = row;
	monsterList[index][MLIST_PRE_DIR] = 5;
	monsterList[index][MLIST_STUCK] = 0;
	dungeon[row][col] |= index;
	if (monsterCanSeePC(col, row)) {
		monsterList[index][MLIST_TARGET_COL] = pcCol;
		monsterList[index][MLIST_TARGET_ROW] = pcRow;
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

//flag:not permit
//don't select 5
private static int randAround(int flag, int col, int row) {
	int ret = 0;
FUNCTION_CALLED("randAround(0x" +Integer.toHexString(flag) +", " +col +", " +row +")");
FUNCTION_PRINT("call " +functionName);

	int i;
	int n=0;
	for (i=0; i<9; i++) {
		if (i==5-1) continue;
		int tcol = col +(i % 3) -1;
		int trow = row +(i / 3) -1;
		int dd = dungeon[trow][tcol];
		if (IS_FALSE(dd & flag) && ((dd & MAP_OBJECT) > MAP_VERTWALL)) {
			roomTemp[n] = i+1;
			n++;
		}
	}
	if (n != 0) {
#if 1
		ret = roomTemp[randRandom(n)];
#else
		int r,t;
		for (i=0; i<n; i++) {
			r = randRandom(n);
			t = roomTemp[r];
			roomTemp[r] = roomTemp[i];
			roomTemp[i] = t;
		}
		ret = roomTemp[randRandom(n)];
#endif
	}

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

private void createMonster(int col, int row, boolean sleep) {
FUNCTION_CALLED("createMonster(" +col +", " +row +", " +sleep +")");
FUNCTION_PRINT("call " +functionName);

	int index = makeMonster();
	if (index <= 0) return;

	int dir = randAround((MAP_MONSTER_FLAG | MAP_ITEM_FLAG), col, row);
	if (dir == 0) {
		//put other place
		monsterList[index][MLIST_IS_MONSTER] = MONSTER_KIND_COUNT;
		putMonster(MAX_ROOM_COUNT);
		return;
	}
	col += ((dir-1) % 3) -1;
	row += ((dir-1) / 3) -1;
	monsterList[0][0]++;
	monsterList[index][MLIST_COL] = col;
	monsterList[index][MLIST_ROW] = row;
	monsterList[index][MLIST_TARGET_COL] = col;
	monsterList[index][MLIST_TARGET_ROW] = row;
	monsterList[index][MLIST_PRE_COL] = col;
	monsterList[index][MLIST_PRE_ROW] = row;
	monsterList[index][MLIST_PRE_DIR] = 5;
	monsterList[index][MLIST_STUCK] = 0;
	dungeon[row][col] |= index;
	if (sleep) {
		monsterList[index][MLIST_FLAG] |= MFLAG_ASLEEP;
		monsterList[index][MLIST_FLAG] &= (~(MFLAG_WAKENS));
	} else {
		WAKEUPMONSTER(index);
		if (monsterCanSeePC(col, row)) {
			monsterList[index][MLIST_TARGET_COL] = pcCol;
			monsterList[index][MLIST_TARGET_ROW] = pcRow;
		}
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private boolean createMimic(int object) {
FUNCTION_CALLED("createMimic(0x" +Integer.toHexString(object) +")");
FUNCTION_PRINT("call " +functionName);

	if (monsterList[0][0] >= MAX_MONSTER_COUNT) {
		return false;
	}

	//0 is a missing number
	int index;
	for (index=1; index<MAX_MONSTER_COUNT; index++) {
		if (monsterList[index][MLIST_IS_MONSTER] == MONSTER_KIND_COUNT) {
			break;
		}
	}
	if (index >= MAX_MONSTER_COUNT) {
		return false;
	}

DEBUG_PRINT("col:"+pcCol);
DEBUG_PRINT("row:"+pcRow);
	int kind = 'X'-'A';
	monsterList[0][0]++;
	monsterList[index][MLIST_IS_MONSTER]	= kind;
	monsterList[index][MLIST_FLAG]			= monsterCatalog[kind][MCATALOG_FLAG];
	monsterList[index][MLIST_HP]			= monsterCatalog[kind][MCATALOG_HP];
	monsterList[index][MLIST_CHAR]			= monsterCatalog[kind][MCATALOG_CHAR];
	monsterList[index][MLIST_CARRY]			= object;
	monsterList[index][MLIST_ROW]			= pcRow;
	monsterList[index][MLIST_COL]			= pcCol;
	monsterList[index][MLIST_QUIVER]		= monsterCatalog[kind][MCATALOG_QUIVER];
	monsterList[index][MLIST_PICKED_UP]		= 0;
	monsterList[index][MLIST_TARGET_ROW]	= pcRow;
	monsterList[index][MLIST_TARGET_COL]	= pcCol;
	monsterList[index][MLIST_PRE_ROW]		= pcRow;
	monsterList[index][MLIST_PRE_COL]		= pcCol;
	monsterList[index][MLIST_PRE_DIR]		= 5;
	monsterList[index][MLIST_STUCK]			= 0;
	WAKEUPMONSTER(index);
	dungeon[pcRow][pcCol] |= index;

FUNCTION_PRINT(functionName +" return true");
FUNCTION_RETURN();
	return true;
}

//return monsterList index
private static int makeMonster() {
	int index=0;
FUNCTION_CALLED("makeMonster()");
FUNCTION_PRINT("call " +functionName);

	if (monsterList[0][0] >= MAX_MONSTER_COUNT) {
		return 0;
	}

	//0 is a missing number
	for (index=1; index<MAX_MONSTER_COUNT; index++) {
		if (monsterList[index][MLIST_IS_MONSTER] >= MONSTER_KIND_COUNT) {
			break;
		}
	}
	if (index >= MAX_MONSTER_COUNT) {
		return 0;
	}

	int kind;
	int r=0;
	while (true) {
		kind = randRandom(MONSTER_KIND_COUNT);
		if (   (monsterCatalog[kind][MCATALOG_START_FLOOR] <= curFloor)
			&& (monsterCatalog[kind][MCATALOG_END_FLOOR] >= curFloor)
		) {
			break;
		}
		r++;
		if (r > 100) return 0;
	}

	monsterList[index][MLIST_IS_MONSTER]	= kind;
	monsterList[index][MLIST_FLAG]			= monsterCatalog[kind][MCATALOG_FLAG];
	monsterList[index][MLIST_HP]			= monsterCatalog[kind][MCATALOG_HP];
	monsterList[index][MLIST_CHAR]			= monsterCatalog[kind][MCATALOG_CHAR];
	monsterList[index][MLIST_CARRY]			= 0;
	monsterList[index][MLIST_QUIVER]		= monsterCatalog[kind][MCATALOG_QUIVER];
	monsterList[index][MLIST_PICKED_UP]		= 0;

	if (curFloor > (FLOOR_AMULET + 2)) { //ALL haste
		monsterList[index][MLIST_FLAG] |= MFLAG_HASTED;
	}
	if (IS_TRUE(monsterList[index][MLIST_FLAG] & MFLAG_WANDERS) && randBool()) {
		//wakeup
		monsterList[index][MLIST_FLAG] &= (~MFLAG_ASLEEP);
	}

FUNCTION_PRINT(functionName +" return " +index);
FUNCTION_RETURN();
	return index;
}

private void randWakeUpMonster(int monster) {
FUNCTION_CALLED("randWakeUpMonster(" +monster +")");
FUNCTION_PRINT("call " +functionName);

	int per;
	if ( (monsterList[monster][MLIST_FLAG] & (MFLAG_WAKENS | MFLAG_ASLEEP)) == (MFLAG_WAKENS | MFLAG_ASLEEP) ) {
		if ( (getRingPower(RING_STEALTH) == 0) && randPercent(45) ) {
			WAKEUPMONSTER(monster);
			monsterList[monster][MLIST_FLAG] |= MFLAG_WAKEUP;
		}
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void moveMonster(int monster) {
FUNCTION_CALLED("moveMonster(" +monster +")");
FUNCTION_PRINT("call " +functionName);
FUNCTION_PRINT("monster:" +GET_MONSTER_NAME(monster));

	int mflag = monsterList[monster][MLIST_FLAG];
	int col = monsterList[monster][MLIST_COL];
	int row = monsterList[monster][MLIST_ROW];
	int i,j,k;

	if (IS_TRUE(mflag & MFLAG_WAKEUP)) {
		monsterList[monster][MLIST_FLAG] &= (~(MFLAG_WAKEUP));
		if (pcCanSee(col, row)) {
#ifdef JP
			message(MONSTER_NAME(monster) +"͖肩o߂B");
#else
			message(MONSTER_NAME(monster) +" awoke.");
#endif
			if (monsterCanSeePC(col, row)) {
				monsterList[monster][MLIST_TARGET_COL] = pcCol;
				monsterList[monster][MLIST_TARGET_ROW] = pcRow;
			}
		}
		return;
	}
	if (IS_TRUE(mflag & MFLAG_ASLEEP)) {
		if (IS_TRUE(mflag & MFLAG_NAPPING)) {
			i = monsterList[monster][MLIST_PICKED_UP];
			i--;
			if (i <= 0) {
				mflag &= (~(MFLAG_NAPPING | MFLAG_ASLEEP));
				monsterList[monster][MLIST_FLAG] = (mflag | MFLAG_WAKEUP);
			}
			monsterList[monster][MLIST_PICKED_UP] = i;
			return;
		}
		if (pcIsAround(col, row)) randWakeUpMonster(monster);
		return;
	}
	if (IS_TRUE(mflag & MFLAG_FLITS)) {
		if (flitMonster(monster)) {
			return;
		}
	}
	if (IS_TRUE(mflag & MFLAG_STATIONARY)) {
		if (!pcIsAround(col, row)) {
			return;
		}
	}
	if (IS_TRUE(mflag & MFLAG_CONFUSES)) {
		if (confuseAttack(monster)) {
			return;
		}
	}
	if (pcIsAround(col, row)) {
		if (monsterCanGo(monster, pcCol, pcRow)) {
			monstersAttack(monster, false);
			return;
		}
	}
	if (IS_TRUE(mflag & MFLAG_FLAMES)) {
		if (flameBroil(monster)) {
			return;
		}
	}
	if (IS_TRUE(mflag & MFLAG_SEEKS_GOLD)) {
		if (seekGold(monster)) {
			return;
		}
	}

	//move routing
	int tcol = monsterList[monster][MLIST_TARGET_COL];
	int trow = monsterList[monster][MLIST_TARGET_ROW];
	int pcol = monsterList[monster][MLIST_PRE_COL];
	int prow = monsterList[monster][MLIST_PRE_ROW];
	int dir = monsterList[monster][MLIST_PRE_DIR];
	int st = 0;
	if ( (pcol == col) && (prow == row) ) {
		st = monsterList[monster][MLIST_STUCK];
		st++;
		if (st >= 5) {
			tcol = DUNGEON_COLS;//missing
			trow = DUNGEON_ROWS;
			st = 0;
			dir = 10 - dir;//180 degree turn
		}
	}

	//Targeting
	if (IS_FALSE(mflag & MFLAG_GETAWAY) && monsterCanSeePC(col, row)) {
		tcol = pcCol;
		trow = pcRow;
	}
	if (tcol == DUNGEON_COLS) {
		int no = getRoomNum(col, row, true);
		if (no != MAX_ROOM_COUNT) {
			//target door
			j=0;
			for (i=ROOM_DOOR1; i<=ROOM_DOOR4; i++) {
				k = room[no][i];
				if (k != ROOM_NODOOR) {
					j++;
					if (randRandom(j) == 0) {
						tcol = (k & 0xff00) >> 8;
						trow = (k & 0xff);
					}
				}
			}
		}
	}
	if ( (tcol == col) && (trow == row) ) {
		tcol = DUNGEON_COLS;//missing
		trow = DUNGEON_ROWS;
	}
	if (IS_TRUE(mflag & MFLAG_GETAWAY)) {
		if (pcIsAround(col, row)) {
			tcol = DUNGEON_COLS;//missing
			trow = DUNGEON_ROWS;
			dir = 5 -(pcCol - col) -(pcRow - row)*3;//opposite dir
		}
	}
	monsterList[monster][MLIST_TARGET_COL] = tcol;
	monsterList[monster][MLIST_TARGET_ROW] = trow;

	//move
	if (tcol != DUNGEON_COLS) {
		monsterMoveTo(monster, tcol, trow, true);
	} else {
		monsterMoveDir(monster, dir, false, true);
	}
	monsterList[monster][MLIST_PRE_COL] = col;
	monsterList[monster][MLIST_PRE_ROW] = row;
	monsterList[monster][MLIST_STUCK] = st;

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private static boolean pcIsAround(int col, int row) {
	boolean ret = false;
FUNCTION_CALLED("pcIsAround(" +col +", " +row +")");
FUNCTION_PRINT("call " +functionName);

	int rdif = pcCol -col;
	int cdif = pcRow -row;
	if ((rdif >= -1) && (rdif <= 1) && (cdif >= -1) && (cdif <= 1)) {
		ret = true;
	}

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

private boolean flitMonster(int monster) {
	boolean ret = false;
FUNCTION_CALLED("flitMonster(" +monster +")");
FUNCTION_PRINT("call " +functionName);

	if (randPercent(33)) {
		ret = false;
	} else if (randPercent(10)) {
		ret = true;
	} else {
		int col = monsterList[monster][MLIST_COL];
		int row = monsterList[monster][MLIST_ROW];
		tryMoveMonster(monster, randMovableDir(col, row));
		ret = true;
	}

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

private boolean tryMoveMonster(int monster, int dir) {
	boolean ret = false;
FUNCTION_CALLED("tryMoveMonster(" +monster +", " +dir +")");
FUNCTION_PRINT("call " +functionName);

	int col = monsterList[monster][MLIST_COL] +((dir-1) % 3) -1;
	int row = monsterList[monster][MLIST_ROW] +((dir-1) / 3) -1;
	ret = (monsterCanGo(monster, col, row));
	if (ret) {
		monsterMoveTo(monster, col, row, false);
	}

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

private boolean confuseAttack(int monster) {
	boolean ret = false;
FUNCTION_CALLED("confuseAttack(" +monster +")");
FUNCTION_PRINT("call " +functionName);

	int mflag = monsterList[monster][MLIST_FLAG];
	int col = monsterList[monster][MLIST_COL];
	int row = monsterList[monster][MLIST_ROW];
	if (pcCanSee(col, row)) {
		if (randPercent(45)) {
			mflag &= (~(MFLAG_CONFUSES));
		} else if (randPercent(55)) {
			mflag &= (~(MFLAG_CONFUSES));
#ifdef JP
			message(GET_MONSTER_NAME(monster) +"ɂɂ܂AĂ܂I");
#else
			message("The gaze of the " +GET_MONSTER_NAME(monster) +" has confused you!");
#endif
			pcConfuse();
			ret = true;
		}
		monsterList[monster][MLIST_FLAG] = mflag;
	}

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

private boolean flameBroil(int monster) {
	boolean ret = false;
FUNCTION_CALLED("flameBroil(" +monster +")");
FUNCTION_PRINT("call " +functionName);

	int col = monsterList[monster][MLIST_COL];
	int row = monsterList[monster][MLIST_ROW];
	if (monsterCanSeePC(col, row) && randBool()) {
		int dcol = pcCol - monsterList[monster][MLIST_COL];
		int drow = pcRow - monsterList[monster][MLIST_ROW];
		dcol = ABSINT(dcol);
		drow = ABSINT(drow);
		if ( (dcol == 0) || (drow == 0) || (dcol == drow) ) {
			pcKilledBy = 26;
			monstersAttack(monster, true);
			ret = true;
		}
	}

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

private boolean seekGold(int monster) {
	boolean ret = false;
FUNCTION_CALLED("seekGold(" +monster +")");
FUNCTION_PRINT("call " +functionName);

	int mcol = monsterList[monster][MLIST_COL];
	int mrow = monsterList[monster][MLIST_ROW];
	int no = getRoomNum(mcol, mrow, true);
	if (no != MAX_ROOM_COUNT) {
		int xstart	= GET_RECT_LEFT_COL(no) +1;
		int xend	= GET_RECT_RIGHT_COL(no) -1;
		int ystart	= GET_RECT_TOP_ROW(no) +1;
		int yend	= GET_RECT_BOTTOM_ROW(no) -1;
		int gx = DUNGEON_COLS;
		int gy = DUNGEON_ROWS;
		int gd = gx +gy;
		for (int y=ystart; y<=yend; y++) {
			for (int x=xstart; x<=xend; x++) {
				int dd = dungeon[y][x] & MAP_ITEM_FLAG;
				if (IS_FALSE(dd)) continue;
				dd = itemList[dd >> 8];
				if ((dd & ITEM_TYPE_FLAG) == ITEM_GOLD) {
					int dx = ABSINT(x - mcol);
					int dy = ABSINT(y - mrow);
					int dr = dx + dy;
					if (dr > gd) continue;
					if (dr == gd) {
						if ( ((dx > dy)? dx:dy) > ((gx-mcol > gy-mrow)? gx-mcol:gy-mrow)) {
							continue;
						}
					}
					gx = x;
					gy = y;
					gd = dr;
				}
			}
		}
		if (gx != DUNGEON_COLS) {
			ret = true;
			if ( (gx == mcol) && (gy == mrow) ) {
				int mflag = monsterList[monster][MLIST_FLAG];
				mflag |= MFLAG_ASLEEP;
				mflag &= (~(MFLAG_WAKENS | MFLAG_SEEKS_GOLD));
				monsterList[monster][MLIST_FLAG] = mflag;
			} else {
				monsterMoveTo(monster, gx, gy, true);
			}
		}
	}

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

private static boolean monsterCanSeePC(int col, int row) {
	boolean ret = false;
FUNCTION_CALLED("monsterCanSee(" +col +", " +row +")");
FUNCTION_PRINT("call " +functionName);

	if (pcIsAround(col, row)) {
		ret = true;
	} else if (getRingPower(RING_STEALTH) == 0) {
		int no = getRoomNum(col, row, true);
		if (no != MAX_ROOM_COUNT) {
			if (IS_FALSE(room[no][ROOM_FLAG] & ROOM_MAZE)) {
				if (no == pcRoomNum) ret = true;
			}
		}
	}

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}
