/*
 * This source herein may be modified and/or distributed by anybody who
 * so desires, with the following restrictions:
 *    1.)  No portion of this notice shall be removed.
 *    2.)  Credit shall not be taken for the creation of this source.
 *    3.)  This code is not to be traded, sold, or used for personal
 *         gain or profit.
 */

//(5+36+2+6)*4=196
#define SCOREDATA_OFFSET (MAX_SCORE_COUNT + MAX_DEATH_COUNT)
#define SCOREDATA_VER		(SCOREDATA_OFFSET +0)
#define SCOREDATA_CURFLOOR	(SCOREDATA_OFFSET +1)
#define SCOREDATA_NAME		(SCOREDATA_OFFSET +2)
#define SCOREDATA_SIZE (SCOREDATA_NAME +MAX_NAME_LENGTH)

#ifdef DOJA
#define SAVEDATA_OFFSET SCOREDATA_SIZE
#endif
//((11+10+14+12)*(1+6)+1+20+13)*4=1452
#define SAVEDATA_RINGCATALOG	0
#define SAVEDATA_WANDCATALOG	RING_OBJECT_COUNT
#define SAVEDATA_POTIONCATALOG	(SAVEDATA_WANDCATALOG + WAND_OBJECT_COUNT)
#define SAVEDATA_SCROLLCATALOG	(SAVEDATA_POTIONCATALOG +POTION_OBJECT_COUNT)
#define SAVEDATA_STRRING		(SAVEDATA_SCROLLCATALOG +SCROLL_OBJECT_COUNT)
#define SAVEDATA_STRWAND		(SAVEDATA_STRRING +RING_OBJECT_COUNT*MAX_NAME_LENGTH)
#define SAVEDATA_STRPOTION		(SAVEDATA_STRWAND +WAND_OBJECT_COUNT*MAX_NAME_LENGTH)
#define SAVEDATA_STRSCROLL		(SAVEDATA_STRPOTION +POTION_OBJECT_COUNT*MAX_NAME_LENGTH)
#define SAVEDATA_MAXFLOOR		(SAVEDATA_STRSCROLL +SCROLL_OBJECT_COUNT*MAX_NAME_LENGTH)
#define SAVEDATA_PACK				(SAVEDATA_MAXFLOOR +1)
#define SAVEDATA_MAXHP				(SAVEDATA_PACK +MAX_PACK_COUNT)
#define SAVEDATA_CURHP				(SAVEDATA_MAXHP +1)
#define SAVEDATA_MAXSTR				(SAVEDATA_MAXHP +2)
#define SAVEDATA_CURSTR				(SAVEDATA_MAXHP +3)
#define SAVEDATA_GOLD				(SAVEDATA_MAXHP +4)
#define SAVEDATA_LEVEL				(SAVEDATA_MAXHP +5)
#define SAVEDATA_EXP				(SAVEDATA_MAXHP +6)
#define SAVEDATA_STATE_BLINDNESS		(SAVEDATA_MAXHP +7)
#define SAVEDATA_STATE_HALLUCINATION	(SAVEDATA_MAXHP +8)
#define SAVEDATA_STATE_CONFUSED			(SAVEDATA_MAXHP +9)
#define SAVEDATA_STATE_HASTE			(SAVEDATA_MAXHP +10)
#define SAVEDATA_STATE_SEE_INVISIBLE	(SAVEDATA_MAXHP +11)
#define SAVEDATA_ENERGY					(SAVEDATA_MAXHP +12)
#define SAVEDATA_SIZE (SAVEDATA_ENERGY+1)

private static void loadScore() {
FUNCTION_CALLED("loadScore()");
FUNCTION_PRINT("call " +functionName);

	int[] dataInt = loadScoreData();

	int i;
	if (dataInt[SCOREDATA_VER] != VERSION) {
#ifdef MIDP
		deleteRS();
#endif
		for (i=0; i<MAX_SCORE_COUNT; i++) {
			score[i] = 0;
		}
		for (i=0; i<MAX_DEATH_COUNT; i++) {
			death[i] = 0;
		}
		pcName = "";
	} else {
		for (i=0; i<MAX_SCORE_COUNT; i++) {
			score[i] = dataInt[i];
		}
		for (i=0; i<MAX_DEATH_COUNT; i++) {
			death[i] = dataInt[MAX_SCORE_COUNT +i];
		}
		curFloor = dataInt[SCOREDATA_CURFLOOR];
#ifdef JP
		char name[] = new char[MAX_NAME_LENGTH];
		for (i=0; i<MAX_NAME_LENGTH; i++) {
			char c = (char)dataInt[SCOREDATA_NAME +i];
			if (c == 0) break;
			name[i] = c;
		}
#else
		char name[] = new char[MAX_NAME_LENGTH*2];
		for (i=0; i<MAX_NAME_LENGTH*2; i++) {
			int c = dataInt[SCOREDATA_NAME +i/2];
			if ((c & 0xffff) == 0) break;
			name[i] = (char)(c & 0xffff);
			i++;
			c >>>= 16;
			if (c == 0) break;
			name[i] = (char)c;
		}
#endif
		pcName = new String(name, 0, i);
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private static void loadSave() {
FUNCTION_CALLED("loadSave()");
FUNCTION_PRINT("call " +functionName);

	int[] dataInt = loadSaveData();
	int i,j;
#ifdef JP
	char name[] = new char[MAX_NAME_LENGTH];
	char c;
#else
	char name[] = new char[MAX_NAME_LENGTH*2];
	int c;
#endif

	for (i=0; i<RING_OBJECT_COUNT; i++) {
		ringCatalog[i] = dataInt[SAVEDATA_RINGCATALOG +i];
		if (IS_FALSE(ringCatalog[i] & ITEM_KNOWN)) {
#ifdef JP
			for (j=0; j<MAX_NAME_LENGTH; j++) {
				c = (char)dataInt[SAVEDATA_STRRING +MAX_NAME_LENGTH*i +j];
				if (c == 0) break;
				name[j] = c;
#else
			for (j=0; j<MAX_NAME_LENGTH*2; j++) {
				c = dataInt[SAVEDATA_STRRING +MAX_NAME_LENGTH*i +j/2];
				if ((c & 0xffff) == 0) break;
				name[j] = (char)(c & 0xffff);
				j++;
				c >>>= 16;
				if (c == 0) break;
				name[j] = (char)c;
#endif
			}
			strRing[i] = new String(name, 0, j);
			if (IS_TRUE(ringCatalog[i] & ITEM_CALLED)) {
				strRing[i] = NAME_OF_RING +"\"" +strRing[i] +"\"";
			} else {
				strRing[i] = MAKE_OF_NAME(strRing[i], NAME_OF_RING);
			}
		} else {
			strRing[i] = strRingTrue[i];
		}
	}
	for (i=0; i<WAND_OBJECT_COUNT; i++) {
		wandCatalog[i] = dataInt[SAVEDATA_WANDCATALOG +i];
		if (IS_FALSE(wandCatalog[i] & ITEM_KNOWN)) {
#ifdef JP
			for (j=0; j<MAX_NAME_LENGTH; j++) {
				c = (char)dataInt[SAVEDATA_STRWAND +MAX_NAME_LENGTH*i +j];
				if (c == 0) break;
				name[j] = c;
			}
#else
			for (j=0; j<MAX_NAME_LENGTH*2; j++) {
				c = dataInt[SAVEDATA_STRWAND +MAX_NAME_LENGTH*i +j/2];
				if ((c & 0xffff) == 0) break;
				name[j] = (char)(c & 0xffff);
				j++;
				c >>>= 16;
				if (c == 0) break;
				name[j] = (char)c;
			}
#endif
			strWand[i] = new String(name, 0, j);
			if (IS_TRUE(wandCatalog[i] & ITEM_CALLED)) {
				strWand[i] = NAME_OF_WAND +"\"" +strWand[i] +"\"";
			} else {
				strWand[i] = MAKE_OF_NAME(strWand[i], NAME_OF_WAND);
			}
		} else {
			strWand[i] = strWandTrue[i];
		}
	}
	for (i=0; i<POTION_OBJECT_COUNT; i++) {
		potionCatalog[i] = dataInt[SAVEDATA_POTIONCATALOG +i];
		if (IS_FALSE(potionCatalog[i] & ITEM_KNOWN)) {
#ifdef JP
			for (j=0; j<MAX_NAME_LENGTH; j++) {
				c = (char)dataInt[SAVEDATA_STRPOTION +MAX_NAME_LENGTH*i +j];
				if (c == 0) break;
				name[j] = c;
			}
#else
			for (j=0; j<MAX_NAME_LENGTH*2; j++) {
				c = dataInt[SAVEDATA_STRPOTION +MAX_NAME_LENGTH*i +j/2];
				if ((c & 0xffff) == 0) break;
				name[j] = (char)(c & 0xffff);
				j++;
				c >>>= 16;
				if (c == 0) break;
				name[j] = (char)c;
			}
#endif
			strPotion[i] = new String(name, 0, j);
			if (IS_TRUE(potionCatalog[i] & ITEM_CALLED)) {
				strPotion[i] = NAME_OF_POTION +"\"" +strPotion[i] +"\"";
			} else {
				strPotion[i] = MAKE_OF_NAME(strPotion[i], NAME_OF_POTION);
			}
		} else {
			strPotion[i] = strPotionTrue[i];
		}
	}
	for (i=0; i<SCROLL_OBJECT_COUNT; i++) {
		scrollCatalog[i] = dataInt[SAVEDATA_SCROLLCATALOG +i];
		if (IS_FALSE(scrollCatalog[i] & ITEM_KNOWN)) {
#ifdef JP
			for (j=0; j<MAX_NAME_LENGTH; j++) {
				c = (char)dataInt[SAVEDATA_STRSCROLL +MAX_NAME_LENGTH*i +j];
				if (c == 0) break;
				name[j] = c;
			}
#else
			for (j=0; j<MAX_NAME_LENGTH*2; j++) {
				c = dataInt[SAVEDATA_STRSCROLL +MAX_NAME_LENGTH*i +j/2];
				if ((c & 0xffff) == 0) break;
				name[j] = (char)(c & 0xffff);
				j++;
				c >>>= 16;
				if (c == 0) break;
				name[j] = (char)c;
			}
#endif
			strScroll[i] = new String(name, 0, j);
			if (IS_TRUE(scrollCatalog[i] & ITEM_CALLED)) {
				strScroll[i] = NAME_OF_SCROLL +"\"" +strScroll[i] +"\"";
			} else {
				strScroll[i] = NAME_OF_SCROLL +"\'" +strScroll[i] +"\'";
			}
		} else {
			strScroll[i] = strScrollTrue[i];
		}
	}
	maxFloor = dataInt[SAVEDATA_MAXFLOOR];
	for (i=0; i<MAX_PACK_COUNT; i++) {
		j = dataInt[SAVEDATA_PACK +i];
		pcPack[i] = j;
		if (j == 0) break;
	}
	pcPackCount = i;
	pcMaxHP		= dataInt[SAVEDATA_MAXHP];
	pcCurHP		= dataInt[SAVEDATA_CURHP];
	pcMaxSTR	= dataInt[SAVEDATA_MAXSTR];
	pcCurSTR	= dataInt[SAVEDATA_CURSTR];
	pcGold		= dataInt[SAVEDATA_GOLD];
	pcLevel		= dataInt[SAVEDATA_LEVEL];
	pcExp		= dataInt[SAVEDATA_EXP];
	pcState[STATE_BLINDNESS]		= dataInt[SAVEDATA_STATE_BLINDNESS];
	pcState[STATE_HALLUCINATION]	= dataInt[SAVEDATA_STATE_HALLUCINATION];
	pcState[STATE_CONFUSED]			= dataInt[SAVEDATA_STATE_CONFUSED];
	pcState[STATE_HASTE]			= dataInt[SAVEDATA_STATE_HASTE];
	pcState[STATE_SEE_INVISIBLE]	= dataInt[SAVEDATA_STATE_SEE_INVISIBLE];
	pcEnergy	= dataInt[SAVEDATA_ENERGY];

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

#ifdef MIDP
#define SET_DATA_BYTE(index, data) \
	{\
		d = data;\
		dataByte[(index)*4+3] = (byte)(d & 0xff);\
		d >>>= 8;\
		dataByte[(index)*4+2] = (byte)(d & 0xff);\
		d >>>= 8;\
		dataByte[(index)*4+1] = (byte)(d & 0xff);\
		d >>>= 8;\
		dataByte[(index)*4+0] = (byte)d;\
	}
#ifdef JP
#define SET_NAME_BYTE(index, n) \
	{\
		d = name[n];\
		dataByte[(index)*4+3] = (byte)(d & 0xff);\
		d >>>= 8;\
		dataByte[(index)*4+2] = (byte)(d & 0xff);\
		dataByte[(index)*4+1] = 0;\
		dataByte[(index)*4+0] = 0;\
	}
#else
#define SET_NAME_BYTE(index, n) \
	{\
		d = name[n*2];\
		dataByte[(index)*4+3] = (byte)(d & 0xff);\
		dataByte[(index)*4+2] = 0;\
		d = name[n*2+1];\
		dataByte[(index)*4+1] = (byte)(d & 0xff);\
		dataByte[(index)*4+0] = 0;\
	}
#endif
private static void deleteRS() {
	try {
		RecordStore.deleteRecordStore("score");
	} catch(Exception e){DEBUG_PRINT(e.toString());}
	try {
		RecordStore.deleteRecordStore("save");
	} catch(Exception e){DEBUG_PRINT(e.toString());}
}

private static void saveScore() {
FUNCTION_CALLED("saveScore()");
FUNCTION_PRINT("call " +functionName);

	byte[] dataByte = new byte[SCOREDATA_SIZE*4];

	int d;
	int i;
	for (i=0; i<MAX_SCORE_COUNT; i++) {
		SET_DATA_BYTE(i, score[i]);
	}
	for (i=0; i<MAX_DEATH_COUNT; i++) {
		SET_DATA_BYTE(MAX_SCORE_COUNT +i, death[i]);
	}
	SET_DATA_BYTE(SCOREDATA_VER, VERSION);
	SET_DATA_BYTE(SCOREDATA_CURFLOOR, curFloor);

#ifdef JP
	char name[] = new char[MAX_NAME_LENGTH+1];
#else
	char name[] = new char[MAX_NAME_LENGTH*2+1];
#endif
	pcName.getChars(0, pcName.length(), name, 0);
	name[pcName.length()] = 0;
	for (i=0; i<MAX_NAME_LENGTH; i++) {
		SET_NAME_BYTE(SCOREDATA_NAME +i, i);
	}

	try {
		RecordStore rs =  RecordStore.openRecordStore("score", true);
		if (rs.getNumRecords() == 0) {
			rs.addRecord(dataByte, 0, dataByte.length);
		} else {
			rs.setRecord(1, dataByte, 0, dataByte.length);
		}
		rs.closeRecordStore();
	} catch(Exception e){DEBUG_PRINT(e.toString());}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private static void saveGame() {
FUNCTION_CALLED("saveGame()");
FUNCTION_PRINT("call " +functionName);

	byte[] dataByte = new byte[SAVEDATA_SIZE*4];

	int i,j;
#ifdef JP
	char name[] = new char[MAX_NAME_LENGTH+1];
#else
	char name[] = new char[MAX_NAME_LENGTH*2+1];
#endif
	int k,d;
	String str;

	for (i=0; i<RING_OBJECT_COUNT; i++) {
		SET_DATA_BYTE(SAVEDATA_RINGCATALOG +i, ringCatalog[i]);
		if (IS_FALSE(ringCatalog[i] & ITEM_KNOWN)) {
			k = (NAME_OF_RING).length();
			if (IS_TRUE(ringCatalog[i] & ITEM_CALLED)) {
				str = strRing[i].substring(k+1, strRing[i].length() -1);
			} else {
#ifdef JP
				str = strRing[i].substring(0, strRing[i].length() -k);
#else
				str = strRing[i].substring(k+4, strRing[i].length());
#endif
			}
			str.getChars(0, str.length(), name, 0);
			name[str.length()] = 0;
			for (j=0; j<MAX_NAME_LENGTH; j++) {
				SET_NAME_BYTE(SAVEDATA_STRRING +MAX_NAME_LENGTH*i +j, j);
			}
		}
	}
	for (i=0; i<WAND_OBJECT_COUNT; i++) {
		SET_DATA_BYTE(SAVEDATA_WANDCATALOG +i, wandCatalog[i]);
		if (IS_FALSE(wandCatalog[i] & ITEM_KNOWN)) {
			k = (NAME_OF_WAND).length();
			if (IS_TRUE(wandCatalog[i] & ITEM_CALLED)) {
				str = strWand[i].substring(k+1, strWand[i].length() -1);
			} else {
#ifdef JP
				str = strWand[i].substring(0, strWand[i].length() -k);
#else
				str = strWand[i].substring(k+4, strWand[i].length());
#endif
			}
			str.getChars(0, str.length(), name, 0);
			name[str.length()] = 0;
			for (j=0; j<MAX_NAME_LENGTH; j++) {
				SET_NAME_BYTE(SAVEDATA_STRWAND +MAX_NAME_LENGTH*i +j, j);
			}
		}
	}
	for (i=0; i<POTION_OBJECT_COUNT; i++) {
		SET_DATA_BYTE(SAVEDATA_POTIONCATALOG +i, potionCatalog[i]);
		if (IS_FALSE(potionCatalog[i] & ITEM_KNOWN)) {
			k = (NAME_OF_POTION).length();
			if (IS_TRUE(potionCatalog[i] & ITEM_CALLED)) {
				str = strPotion[i].substring(k+1, strPotion[i].length() -1);
			} else {
#ifdef JP
				str = strPotion[i].substring(0, strPotion[i].length() -k);
#else
				str = strPotion[i].substring(k+4, strPotion[i].length());
#endif
			}
			str.getChars(0, str.length(), name, 0);
			name[str.length()] = 0;
			for (j=0; j<MAX_NAME_LENGTH; j++) {
				SET_NAME_BYTE(SAVEDATA_STRPOTION +MAX_NAME_LENGTH*i +j, j);
			}
		}
	}
	for (i=0; i<SCROLL_OBJECT_COUNT; i++) {
		SET_DATA_BYTE(SAVEDATA_SCROLLCATALOG +i, scrollCatalog[i]);
		if (IS_FALSE(scrollCatalog[i] & ITEM_KNOWN)) {
			k = (NAME_OF_SCROLL).length();
			str = strScroll[i].substring(k+1, strScroll[i].length() -1);
			str.getChars(0, str.length(), name, 0);
			name[str.length()] = 0;
			for (j=0; j<MAX_NAME_LENGTH; j++) {
				SET_NAME_BYTE(SAVEDATA_STRSCROLL +MAX_NAME_LENGTH*i +j, j);
			}
		}
	}
	SET_DATA_BYTE(SAVEDATA_MAXFLOOR, maxFloor);
	if (pcPackCount < MAX_PACK_COUNT) {
		pcPack[pcPackCount] = 0;
	}
	for (i=0; i<MAX_PACK_COUNT; i++) {
		j = pcPack[i];
		SET_DATA_BYTE(SAVEDATA_PACK +i, j);
		if (j == 0) break;
	}
	SET_DATA_BYTE(SAVEDATA_MAXHP, pcMaxHP);
	SET_DATA_BYTE(SAVEDATA_CURHP, pcCurHP);
	SET_DATA_BYTE(SAVEDATA_MAXSTR, pcMaxSTR);
	SET_DATA_BYTE(SAVEDATA_CURSTR, pcCurSTR);
	SET_DATA_BYTE(SAVEDATA_GOLD, pcGold);
	SET_DATA_BYTE(SAVEDATA_LEVEL, pcLevel);
	SET_DATA_BYTE(SAVEDATA_EXP, pcExp);
	SET_DATA_BYTE(SAVEDATA_STATE_BLINDNESS, pcState[STATE_BLINDNESS]);
	SET_DATA_BYTE(SAVEDATA_STATE_HALLUCINATION, pcState[STATE_HALLUCINATION]);
	SET_DATA_BYTE(SAVEDATA_STATE_CONFUSED, pcState[STATE_CONFUSED]);
	SET_DATA_BYTE(SAVEDATA_STATE_HASTE, pcState[STATE_HASTE]);
	SET_DATA_BYTE(SAVEDATA_STATE_SEE_INVISIBLE, pcState[STATE_SEE_INVISIBLE]);
	SET_DATA_BYTE(SAVEDATA_ENERGY, pcEnergy);

	try {
		RecordStore rs =  RecordStore.openRecordStore("save", true);
		if (rs.getNumRecords() == 0) {
			rs.addRecord(dataByte, 0, dataByte.length);
		} else {
			rs.setRecord(1, dataByte, 0, dataByte.length);
		}
		rs.closeRecordStore();
	} catch(Exception e){DEBUG_PRINT(e.toString());}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private static int[] loadScoreData() {
	int[] dataInt = new int[SCOREDATA_SIZE];
FUNCTION_CALLED("loadScoreData()");
FUNCTION_PRINT("call " +functionName);

	try {
		RecordStore rs = RecordStore.openRecordStore("score", false);
		byte[] data = rs.getRecord(1);
		rs.closeRecordStore();
		int d;
		for (int i=0; i<SCOREDATA_SIZE; i++) {
			d = (data[i*4+0] & 0xff);
			d <<= 8;
			d += (data[i*4+1] & 0xff);
			d <<= 8;
			d += (data[i*4+2] & 0xff);
			d <<= 8;
			d += (data[i*4+3] & 0xff);
			dataInt[i] = d;
		}
	} catch(Exception e){DEBUG_PRINT(e.toString());}
FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
	return dataInt;
}

private static int[] loadSaveData() {
	int[] dataInt = new int[SAVEDATA_SIZE];
FUNCTION_CALLED("loadSaveData()");
FUNCTION_PRINT("call " +functionName);

	try {
		RecordStore rs = RecordStore.openRecordStore("save", false);
		byte[] data = rs.getRecord(1);
		rs.closeRecordStore();
		int d;
		for (int i=0; i<SAVEDATA_SIZE; i++) {
			d = (data[i*4+0] & 0xff);
			d <<= 8;
			d += (data[i*4+1] & 0xff);
			d <<= 8;
			d += (data[i*4+2] & 0xff);
			d <<= 8;
			d += (data[i*4+3] & 0xff);
			dataInt[i] = d;
		}
	} catch(Exception e){DEBUG_PRINT(e.toString());}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
	return dataInt;
}
#endif
#ifdef DOJA
private static void saveScore() {
FUNCTION_CALLED("saveScore()");
FUNCTION_PRINT("call " +functionName);

	int[] dataInt = new int[SCOREDATA_SIZE];
	int i;
	for (i=0; i<MAX_SCORE_COUNT; i++) {
		dataInt[i] = score[i];
	}
	for (i=0; i<MAX_DEATH_COUNT; i++) {
		dataInt[MAX_SCORE_COUNT +i] = death[i];
	}
	dataInt[SCOREDATA_VER] = VERSION;
	dataInt[SCOREDATA_CURFLOOR] = curFloor;
#ifdef JP
	char name[] = new char[MAX_NAME_LENGTH+1];
#else
	char name[] = new char[MAX_NAME_LENGTH*2+1];
#endif
	pcName.getChars(0, pcName.length(), name, 0);
	name[pcName.length()] = 0;
	for (i=0; i<MAX_NAME_LENGTH; i++) {
#ifdef JP
		dataInt[SCOREDATA_NAME +i] = name[i];
#else
		dataInt[SCOREDATA_NAME +i] = (name[i*2+1] << 16) +name[i*2];
#endif
	}

	try {
		DataOutputStream out = Connector.openDataOutputStream("scratchpad:///0");
		for (i=0; i<SCOREDATA_SIZE; i++) {
			out.writeInt(dataInt[i]);
		}
		out.close();
	} catch(Exception e){DEBUG_PRINT(e.toString());}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private static void saveGame() {
FUNCTION_CALLED("saveGame()");
FUNCTION_PRINT("call " +functionName);

	int[] dataInt = new int[SAVEDATA_SIZE];

	int i,j;
#ifdef JP
	char name[] = new char[MAX_NAME_LENGTH+1];
#else
	char name[] = new char[MAX_NAME_LENGTH*2+1];
#endif
	int k;
	String str;

	for (i=0; i<RING_OBJECT_COUNT; i++) {
		dataInt[SAVEDATA_RINGCATALOG +i] = ringCatalog[i];
		if (IS_FALSE(ringCatalog[i] & ITEM_KNOWN)) {
			k = (NAME_OF_RING).length();
			if (IS_TRUE(ringCatalog[i] & ITEM_CALLED)) {
				str = strRing[i].substring(k+1, strRing[i].length() -1);
			} else {
#ifdef JP
				str = strRing[i].substring(0, strRing[i].length() -k);
#else
				str = strRing[i].substring(k+4, strRing[i].length());
#endif
			}
			str.getChars(0, str.length(), name, 0);
			name[str.length()] = 0;
			for (j=0; j<MAX_NAME_LENGTH; j++) {
#ifdef JP
				dataInt[SAVEDATA_STRRING +MAX_NAME_LENGTH*i +j] = name[j];
#else
				dataInt[SAVEDATA_STRRING +MAX_NAME_LENGTH*i +j] = (name[j*2+1] << 16) +name[j*2];
#endif
			}
		}
	}
	for (i=0; i<WAND_OBJECT_COUNT; i++) {
		dataInt[SAVEDATA_WANDCATALOG +i] = wandCatalog[i];
		if (IS_FALSE(wandCatalog[i] & ITEM_KNOWN)) {
			k = (NAME_OF_WAND).length();
			if (IS_TRUE(wandCatalog[i] & ITEM_CALLED)) {
				str = strWand[i].substring(k+1, strWand[i].length() -1);
			} else {
#ifdef JP
				str = strWand[i].substring(0, strWand[i].length() -k);
#else
				str = strWand[i].substring(k+4, strWand[i].length());
#endif
			}
			str.getChars(0, str.length(), name, 0);
			name[str.length()] = 0;
			for (j=0; j<MAX_NAME_LENGTH; j++) {
#ifdef JP
				dataInt[SAVEDATA_STRWAND +MAX_NAME_LENGTH*i +j] = name[j];
#else
				dataInt[SAVEDATA_STRWAND +MAX_NAME_LENGTH*i +j] = (name[j*2+1] << 16) +name[j*2];
#endif
			}
		}
	}
	for (i=0; i<POTION_OBJECT_COUNT; i++) {
		dataInt[SAVEDATA_POTIONCATALOG +i] = potionCatalog[i];
		if (IS_FALSE(potionCatalog[i] & ITEM_KNOWN)) {
			k = (NAME_OF_POTION).length();
			if (IS_TRUE(potionCatalog[i] & ITEM_CALLED)) {
				str = strPotion[i].substring(k+1, strPotion[i].length() -1);
			} else {
#ifdef JP
				str = strPotion[i].substring(0, strPotion[i].length() -k);
#else
				str = strPotion[i].substring(k+4, strPotion[i].length());
#endif
			}
			str.getChars(0, str.length(), name, 0);
			name[str.length()] = 0;
			for (j=0; j<MAX_NAME_LENGTH; j++) {
#ifdef JP
				dataInt[SAVEDATA_STRPOTION +MAX_NAME_LENGTH*i +j] = name[j];
#else
				dataInt[SAVEDATA_STRPOTION +MAX_NAME_LENGTH*i +j] = (name[j*2+1] << 16) +name[j*2];
#endif
			}
		}
	}
	for (i=0; i<SCROLL_OBJECT_COUNT; i++) {
		dataInt[SAVEDATA_SCROLLCATALOG +i] = scrollCatalog[i];
		if (IS_FALSE(scrollCatalog[i] & ITEM_KNOWN)) {
			k = (NAME_OF_SCROLL).length();
			str = strScroll[i].substring(k+1, strScroll[i].length() -1);
			str.getChars(0, str.length(), name, 0);
			name[str.length()] = 0;
			for (j=0; j<MAX_NAME_LENGTH; j++) {
#ifdef JP
				dataInt[SAVEDATA_STRSCROLL +MAX_NAME_LENGTH*i +j] = name[j];
#else
				dataInt[SAVEDATA_STRSCROLL +MAX_NAME_LENGTH*i +j] = (name[j*2+1] << 16) +name[j*2];
#endif
			}
		}
	}
	dataInt[SAVEDATA_MAXFLOOR] = maxFloor;
	if (pcPackCount < MAX_PACK_COUNT) {
		pcPack[pcPackCount] = 0;
	}
	for (i=0; i<MAX_PACK_COUNT; i++) {
		j = pcPack[i];
		dataInt[SAVEDATA_PACK +i] = j;
		if (j == 0) break;
	}
	dataInt[SAVEDATA_MAXHP]		= pcMaxHP;
	dataInt[SAVEDATA_CURHP]		= pcCurHP;
	dataInt[SAVEDATA_MAXSTR]	= pcMaxSTR;
	dataInt[SAVEDATA_CURSTR]	= pcCurSTR;
	dataInt[SAVEDATA_GOLD]		= pcGold;
	dataInt[SAVEDATA_LEVEL]		= pcLevel;
	dataInt[SAVEDATA_EXP]		= pcExp;
	dataInt[SAVEDATA_STATE_BLINDNESS]		= pcState[STATE_BLINDNESS];
	dataInt[SAVEDATA_STATE_HALLUCINATION]	= pcState[STATE_HALLUCINATION];
	dataInt[SAVEDATA_STATE_CONFUSED]		= pcState[STATE_CONFUSED];
	dataInt[SAVEDATA_STATE_HASTE]			= pcState[STATE_HASTE];
	dataInt[SAVEDATA_STATE_SEE_INVISIBLE]	= pcState[STATE_SEE_INVISIBLE];
	dataInt[SAVEDATA_ENERGY]	= pcEnergy;

	try {
		DataOutputStream out = Connector.openDataOutputStream("scratchpad:///0;pos=" +SAVEDATA_OFFSET*4);
		for (i=0; i<SAVEDATA_SIZE; i++) {
			out.writeInt(dataInt[i]);
		}
		out.close();
	} catch(Exception e){DEBUG_PRINT(e.toString());}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private static int[] loadScoreData() {
	int[] dataInt = new int[SCOREDATA_SIZE];
FUNCTION_CALLED("loadScoreData()");
FUNCTION_PRINT("call " +functionName);

	int i;
	try {
		DataInputStream in = Connector.openDataInputStream("scratchpad:///0");
		try {
			for (i=0; i<SCOREDATA_SIZE; i++) {
				dataInt[i] = in.readInt();
			}
		} catch (EOFException e) {DEBUG_PRINT(e.toString());}
		in.close();
	} catch (Exception e) {DEBUG_PRINT(e.toString());}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
	return dataInt;
}

private static int[] loadSaveData() {
	int[] dataInt = new int[SAVEDATA_SIZE];
FUNCTION_CALLED("loadSaveData()");
FUNCTION_PRINT("call " +functionName);

	int i;
	try {
		DataInputStream in = Connector.openDataInputStream("scratchpad:///0;pos=" +SAVEDATA_OFFSET*4);
		try {
			for (i=0; i<SAVEDATA_SIZE; i++) {
				dataInt[i] = in.readInt();
			}
		} catch (EOFException e) {DEBUG_PRINT(e.toString());}
		in.close();
	} catch (Exception e) {DEBUG_PRINT(e.toString());}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
	return dataInt;
}
#endif
