/*
 * This source herein may be modified and/or distributed by anybody who
 * so desires, with the following restrictions:
 *    1.)  No portion of this notice shall be removed.
 *    2.)  Credit shall not be taken for the creation of this source.
 *    3.)  This code is not to be traded, sold, or used for personal
 *         gain or profit.
 */

#define COMMAND_NUMBER			0x01000000
#define COMMAND_KEY_0			0x0100000a
#define COMMAND_KEY_1			0x01000001
#define COMMAND_KEY_2			0x01000002
#define COMMAND_KEY_3			0x01000003
#define COMMAND_KEY_4			0x01000004
#define COMMAND_KEY_5			0x01000005
#define COMMAND_KEY_6			0x01000006
#define COMMAND_KEY_7			0x01000007
#define COMMAND_KEY_8			0x01000008
#define COMMAND_KEY_9			0x01000009

#define COMMAND_KEY_ASTERISK	0x0200000b
#define COMMAND_KEY_POUND		0x0200000c
#define COMMAND_KEY_CLEAR		0x0200000d

#define COMMAND_ARROW			0x04000000
#define COMMAND_KEY_LEFT		0x04000004
#define COMMAND_KEY_RIGHT		0x04000006
#define COMMAND_KEY_DOWN		0x04000008
#define COMMAND_KEY_UP			0x04000002
#define COMMAND_KEY_SELECT		0x04000005

#define COMMAND_SOFT			0x08000000
#define COMMAND_KEY_SOFT1		0x08000001
#define COMMAND_KEY_SOFT2		0x08000002

#define COMMAND_MASK			0xffff0000
#define COMMAND_NONE			0x00000000
#define COMMAND_MORE_NEXT		0x00010000
#define COMMAND_MAP_SWITCH		0x00020000
#define COMMAND_AUTOGET_SWITCH	0x00030000
#define COMMAND_SHOW_STATUS		0x00040000


public void run() {
try{
	if (curFloor == 0) {
	//if (true) {
		gameInit();
#ifdef JP
		pcName = inputName("A̒NȂ́H", pcName);
		if (pcName.length() == 0) {
			pcName = "m";
		}
		message("₠A" +pcName +"B^̓Aւ悤...");
#else
		pcName = inputName("Who are you?", pcName);
		if (pcName.length() == 0) {
			pcName = "Rodney";
		}
		message("hello " +pcName +", welcome to the Dungeon of Doom...");
#endif
	} else {
		loadGame();
	}
	newFloor();
#ifdef DEBUG
	gainExp(1);
#endif

	while (true) {
		int key = command;
		if (key == 0) {
			;
		} else {
//DEBUG_PRINT("mode=" +mode);
//DEBUG_PRINT("command=0x" +Integer.toHexString(command));
			if (mode == MODE_GAME) {
				if (IS_TRUE(key & COMMAND_NUMBER)) {
					MESSAGE_REMOVE();
					if (key == COMMAND_KEY_0) {
						showStatus();
					} else if (key == COMMAND_KEY_5) {
						search();
					} else {
						pcMove(key & 0xff);
					}
				} else if (IS_TRUE(key & COMMAND_ARROW)) {
					MESSAGE_REMOVE();
					if (key == COMMAND_KEY_SELECT) {
						pickUp();
					} else {
						pcMoveShift(key & 0xff);
					}
				} else if (key == COMMAND_KEY_ASTERISK) {
					fire();
				} else if (key == COMMAND_KEY_POUND) {
					inventory();
				} else if (key == COMMAND_KEY_CLEAR) {
					;
				} else if (key == COMMAND_KEY_SOFT1) {
					mapSwitch();
				} else if (key == COMMAND_KEY_SOFT2) {
					MESSAGE_REMOVE();
					message(strMessage[3]);
				}
			} else if (mode == MODE_MAP) {
				mapSwitch();
			}
			REPAINT();
		}

		command = 0;
		Sleep();
	}
} catch (Exception e) {
#ifdef DEBUG
	DEBUG_PRINT(e.toString());
#else
	more();
#ifdef JP
	message("G[܂I");
	more();
	message("sł܂BIĉB");
#else
	message("error!");
	more();
	message("cannot continue. Please force to terminate.");
#endif
	more();
	showErr(functionName, e.toString());
#endif
}
}

private static void keyWait() {
	moreWait = true;
	command = 0;
	while (true) {
		if (command != 0) break;
		Sleep();
	}
	moreWait = false;
	command = 0;
}

private void mapSwitch() {
FUNCTION_CALLED("mapSwitch()");
	MESSAGE_REMOVE();
	if (mode == MODE_MAP) {
		mode = MODE_GAME;
		REDRAW();
	} else {
		mode = MODE_MAP;
		mapDraw();
		REPAINT();
	}
FUNCTION_RETURN();
}

private void showStatus() {
FUNCTION_CALLED("showStatus()");

	showMessage = SHOW_MESSAGE_STATE;
	strMessage[0] = "STR:" +pcCurSTR +"/" +pcMaxSTR +" G:" +pcGold;//4+5+3+8
	strMessage[1] = "AC:" +getPlayerAC() +" Exp:" +pcExp;//3+2+5+7
	strMessage[2] = "v:"+VER_MAJOR+"."+VER_MINOR+"."+VER_PATCH;
	if (pcEnergy > ENERGY_FULL - ENERGY_HUNGRY) {
#ifdef JP
		strMessage[2] += " ";
#else
		strMessage[2] += " FULL";
#endif
	} else if (pcEnergy < ENERGY_ENOUGH) {
#ifdef JP
		strMessage[2] += " ";
#else
		strMessage[2] += " HUNGRY";
#endif
	} else if (pcEnergy < ENERGY_HUNGRY) {
#ifdef JP
		strMessage[2] += " Q";
#else
		strMessage[2] += " WEAK";
#endif
	}
	if (pcState[STATE_BEING_HELD] > 0) {
#ifdef JP
		strMessage[2] += " ";
#else
		strMessage[2] += " HELD";
#endif
	}
#if 0 //not display
	if (pcState[STATE_FREEZING] > 0) {
		strMessage[2] += " ?";
	}
#endif
	if (pcState[STATE_BLINDNESS] > 0) {
#ifdef JP
		strMessage[2] += " ";
#else
		strMessage[2] += " BLIND";
#endif
	}
	if (pcState[STATE_HALLUCINATION] > 0) {
#ifdef JP
		strMessage[2] += " ";
#else
		strMessage[2] += " HALLUCINATION";
#endif
	}
	if (pcState[STATE_CONFUSED] > 0) {
#ifdef JP
		strMessage[2] += " ";
#else
		strMessage[2] += " CONFUSED";
#endif
	}
	if (pcState[STATE_LEVITATE] > 0) {
#ifdef JP
		strMessage[2] += " ";
#else
		strMessage[2] += " LEVITATE";
#endif
	}
	if (pcState[STATE_HASTE] > 0) {
#ifdef JP
		strMessage[2] += " ";
#else
		strMessage[2] += " HASTE";
#endif
	}
	if (pcState[STATE_SEE_INVISIBLE] > 0) {
#ifdef JP
		strMessage[2] += " ";
#else
		strMessage[2] += " INVISIBLE";
#endif
	}
	if (pcState[STATE_BEAR_TRAP] > 0) {
#ifdef JP
		strMessage[2] += " F";
#else
		strMessage[2] += " BEAR";
#endif
	}
	messageLine = 3;
	REDRAW();
	MESSAGE_REMOVE();

FUNCTION_RETURN();
}


/* key event */
#ifdef MIDP
public synchronized void commandAction(Command c, Displayable d) {
FUNCTION_CALLED("commandAction(" +c +", " +d +")");

	String label = c.getLabel();
	if (label == "MAP") {
		command = COMMAND_KEY_SOFT1;
	} else if (label == "MESSAGE") {
		command = COMMAND_KEY_SOFT2;
	}

FUNCTION_RETURN();
}

protected synchronized void keyPressed(int keyCode) {

	int act=0;
	if (keyCode == 0) {
		;//for ezappli clear key
	} else {
		act = getGameAction(keyCode);
		if (act == UP) {
			command = COMMAND_KEY_UP;
		} else if (act == LEFT) {
			command = COMMAND_KEY_LEFT;
		} else if (act == RIGHT) {
			command = COMMAND_KEY_RIGHT;
		} else if (act == DOWN) {
			command = COMMAND_KEY_DOWN;
		} else if (act == FIRE) {
			command = COMMAND_KEY_SELECT;
		}
	}

	if (keyCode == 0) {
		command = COMMAND_KEY_CLEAR;
	} else if (keyCode == KEY_POUND) {
		command = COMMAND_KEY_POUND;
	} else if (keyCode == KEY_STAR) {
		command = COMMAND_KEY_ASTERISK;
	} else if (keyCode == KEY_NUM0) {
		command = COMMAND_KEY_0;
	} else if ((keyCode >= KEY_NUM1) && (keyCode <= KEY_NUM9)) {
		command = COMMAND_NUMBER | (keyCode - KEY_NUM0);
	}

}
#endif

#ifdef DOJA
public synchronized void processEvent(int type, int param) {
	if (type != Display.KEY_PRESSED_EVENT) {
		return;
	}
	if (   type == Display.RESUME_VM_EVENT
		|| type == Display.UPDATE_VM_EVENT	// for D503i OnHock stop
	) {
		REPAINT();
		return;
	}

	if (param == Display.KEY_0) {
		command = COMMAND_KEY_0;
	} else if ((param >= Display.KEY_1) && (param <= Display.KEY_9)) {
		command = COMMAND_NUMBER | param;
	} else if (param == Display.KEY_ASTERISK) {
		command = COMMAND_KEY_ASTERISK;
	} else if (param == Display.KEY_LEFT) {
		command = COMMAND_KEY_LEFT;
	} else if (param == Display.KEY_RIGHT) {
		command = COMMAND_KEY_RIGHT;
	} else if (param == Display.KEY_DOWN) {
		command = COMMAND_KEY_DOWN;
	} else if (param == Display.KEY_UP) {
		command = COMMAND_KEY_UP;
	} else if (param == Display.KEY_POUND) {
		command = COMMAND_KEY_POUND;
	} else if (param == Display.KEY_SELECT) {
		command = COMMAND_KEY_SELECT;
	} else if (param == Display.KEY_SOFT1) {
		command = COMMAND_KEY_SOFT1;
	} else if (param == Display.KEY_SOFT2) {
		command = COMMAND_KEY_SOFT2;
	}
}
#endif
