/*
 * This source herein may be modified and/or distributed by anybody who
 * so desires, with the following restrictions:
 *    1.)  No portion of this notice shall be removed.
 *    2.)  Credit shall not be taken for the creation of this source.
 *    3.)  This code is not to be traded, sold, or used for personal
 *         gain or profit.
 */

private static void messageInit() {
FUNCTION_CALLED("messageInit()");
FUNCTION_PRINT("call " +functionName);

	CHARMAP(MAP_NOTHING)	= CHAR_NOTHING;
	CHARMAP(MAP_HORWALL)	= CHAR_HORWALL;
	CHARMAP(MAP_VERTWALL)	= CHAR_VERTWALL;
	CHARMAP(MAP_FLOOR)		= CHAR_FLOOR;
	CHARMAP(MAP_TUNNEL)		= CHAR_TUNNEL;
	CHARMAP(MAP_DOOR)		= CHAR_DOOR;
	CHARMAP(MAP_STAIRS)		= CHAR_STAIRS;

	CHARMAPHIDE(MAP_TRAP_NON)		= CHAR_NOTHING;
	CHARMAPHIDE(MAP_TRAP_DOOR)		= CHAR_FLOOR;
	CHARMAPHIDE(MAP_TRAP_BEAR)		= CHAR_FLOOR;
	CHARMAPHIDE(MAP_TRAP_TELEPORT)	= CHAR_FLOOR;
	CHARMAPHIDE(MAP_TRAP_DART)		= CHAR_FLOOR;
	CHARMAPHIDE(MAP_TRAP_SLEEPGAS)	= CHAR_FLOOR;
	CHARMAPHIDE(MAP_TRAP_RUST)		= CHAR_FLOOR;
	CHARMAPHIDE(MAP_HIDE_DOOR_H)	= CHAR_HORWALL;
	CHARMAPHIDE(MAP_HIDE_DOOR_V)	= CHAR_VERTWALL;
	CHARMAPHIDE(MAP_HIDE_TUNNEL)	= CHAR_NOTHING;

	CHARMAPFOUND(MAP_TRAP_NON)		= CHAR_NOTHING;
	CHARMAPFOUND(MAP_TRAP_DOOR)		= CHAR_TRAP_DOOR;
	CHARMAPFOUND(MAP_TRAP_BEAR)		= CHAR_TRAP_BEAR;
	CHARMAPFOUND(MAP_TRAP_TELEPORT)	= CHAR_TRAP_TELEPORT;
	CHARMAPFOUND(MAP_TRAP_DART)		= CHAR_TRAP_DART;
	CHARMAPFOUND(MAP_TRAP_SLEEPGAS)	= CHAR_TRAP_SLEEPGAS;
	CHARMAPFOUND(MAP_TRAP_RUST)		= CHAR_TRAP_RUST;
	CHARMAPFOUND(MAP_HIDE_DOOR_H)	= CHAR_DOOR;
	CHARMAPFOUND(MAP_HIDE_DOOR_V)	= CHAR_DOOR;
	CHARMAPFOUND(MAP_HIDE_TUNNEL)	= CHAR_TUNNEL;

	CHARITEM_F(ITEM_NONE)			= CHAR_NOTHING;
	CHARITEM_F(ITEM_GOLD)			= CHAR_GOLD;
	CHARITEM_F(ITEM_FOOD)			= CHAR_FOOD;
	CHARITEM_F(ITEM_ARMOR)			= CHAR_ARMOR;
	CHARITEM_F(ITEM_WEAPON)			= CHAR_WEAPON;
	CHARITEM_F(ITEM_SUBWEAPON)		= CHAR_SUBWEAPON;
	CHARITEM_F(ITEM_SCROLL)			= CHAR_SCROLL;
	CHARITEM_F(ITEM_POTION)			= CHAR_POTION;
	CHARITEM_F(ITEM_WAND)			= CHAR_WAND;
	CHARITEM_F(ITEM_RING)			= CHAR_RING;
	CHARITEM_F(ITEM_AMULET)			= CHAR_AMULET;

	STRMAPHIDE(MAP_TRAP_NON)		= NAME_TRAP_NONE;
	STRMAPHIDE(MAP_TRAP_DOOR)		= NAME_TRAP_DOOR;
	STRMAPHIDE(MAP_TRAP_BEAR)		= NAME_TRAP_BEAR;
	STRMAPHIDE(MAP_TRAP_TELEPORT)	= NAME_TRAP_TELEPORT;
	STRMAPHIDE(MAP_TRAP_DART)		= NAME_TRAP_DART;
	STRMAPHIDE(MAP_TRAP_SLEEPGAS)	= NAME_TRAP_SLEEPGAS;
	STRMAPHIDE(MAP_TRAP_RUST)		= NAME_TRAP_RUST;
	STRMAPHIDE(MAP_HIDE_DOOR_H)		= NAME_HIDE_DOOR_H;
	STRMAPHIDE(MAP_HIDE_DOOR_V)		= NAME_HIDE_DOOR_V;
	STRMAPHIDE(MAP_HIDE_TUNNEL)		= NAME_HIDE_TUNNEL;

#ifdef JP
	strStateEnd[STATE_BEING_HELD]		= "܂߂ӂقǂB";
	strStateEnd[STATE_FREEZING]			= "悤₭̂RɂȂB";
	strStateEnd[STATE_BLINDNESS]		= "Èł̂Ƃ΂肪オĂ䂭B";
	strStateEnd[STATE_HALLUCINATION]	= "ƁǍiFǂɂȂB";
	strStateEnd[STATE_CONFUSED]			= "悤₭A͂肵ĂB";
	strStateEnd[STATE_LEVITATE]			= "悤₭nʂɑB";
	strStateEnd[STATE_HASTE]			= "fȂ̌ڂȂȂB";
	strStateEnd[STATE_SEE_INVISIBLE]	= "";
	strStateEnd[STATE_BEAR_TRAP]		= "F̂ȂʂB";
#else
	strStateEnd[STATE_BEING_HELD]		= "escaped binding.";
	strStateEnd[STATE_FREEZING]			= "you can move again.";
	strStateEnd[STATE_BLINDNESS]		= "the veil of darkness lifts.";
	strStateEnd[STATE_HALLUCINATION]	= "everything looks SO boring now.";
	strStateEnd[STATE_CONFUSED]			= "you feel less confused now.";
	strStateEnd[STATE_LEVITATE]			= "you float gently to the ground.";
	strStateEnd[STATE_HASTE]			= "you feel yourself slowing down.";
	strStateEnd[STATE_SEE_INVISIBLE]	= "";
	strStateEnd[STATE_BEAR_TRAP]		= "escaped from the bear trap.";
#endif

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private static void monserInit() {
FUNCTION_CALLED("monserInit()");
FUNCTION_PRINT("call " +functionName);
//this data is from Rogue Clone II

	//'A':Aquator
	//{(MFLAG_ASLEEP|MFLAG_WAKENS|MFLAG_WANDERS|MFLAG_RUSTS),"0d0",25,'A',20,9,18,100,0,0,0,0,0},
	strMonster['A'-'A'] = NAME_MONSTER_A;
	monsterCatalog['A'-'A'][MCATALOG_FLAG]			= (MFLAG_ASLEEP|MFLAG_WAKENS|MFLAG_WANDERS|MFLAG_RUSTS);
	monsterCatalog['A'-'A'][MCATALOG_DAMAGE]		= 0;
	monsterCatalog['A'-'A'][MCATALOG_HP]			= 25;
	monsterCatalog['A'-'A'][MCATALOG_EXP]			= 20;
	monsterCatalog['A'-'A'][MCATALOG_START_FLOOR]	= 9;
	monsterCatalog['A'-'A'][MCATALOG_END_FLOOR]		= 18;
	monsterCatalog['A'-'A'][MCATALOG_CHANCE]		= 100;
	monsterCatalog['A'-'A'][MCATALOG_DROP]			= 0;
	monsterCatalog['A'-'A'][MCATALOG_QUIVER]		= 0;
#if !defined(HANKAKU) && defined(JP)
	monsterCatalog['A'-'A'][MCATALOG_CHAR]			= '`';
#else
	monsterCatalog['A'-'A'][MCATALOG_CHAR]			= 'A';
#endif
	//'B':Bat
	//{(MFLAG_ASLEEP|MFLAG_WANDERS|MFLAG_FLITS),"1d3",10,'B',2,1,8,60,0,0,0,0,0},
	strMonster['B'-'A'] = NAME_MONSTER_B;
	monsterCatalog['B'-'A'][MCATALOG_FLAG]			= (MFLAG_ASLEEP|MFLAG_WANDERS|MFLAG_FLITS);
	monsterCatalog['B'-'A'][MCATALOG_DAMAGE]		= 0x0103;
	monsterCatalog['B'-'A'][MCATALOG_HP]			= 10;
	monsterCatalog['B'-'A'][MCATALOG_EXP]			= 2;
	monsterCatalog['B'-'A'][MCATALOG_START_FLOOR]	= 1;
	monsterCatalog['B'-'A'][MCATALOG_END_FLOOR]		= 8;
	monsterCatalog['B'-'A'][MCATALOG_CHANCE]		= 60;
	monsterCatalog['B'-'A'][MCATALOG_DROP]			= 0;
	monsterCatalog['B'-'A'][MCATALOG_QUIVER]		= 0;
#if !defined(HANKAKU) && defined(JP)
	monsterCatalog['B'-'A'][MCATALOG_CHAR]			= 'a';
#else
	monsterCatalog['B'-'A'][MCATALOG_CHAR]			= 'B';
#endif
	//'C':Centaur
	//{(MFLAG_ASLEEP|MFLAG_WANDERS),"3d3/2d5",32,'C',15,7,16,85,0,10,0,0,0},
	strMonster['C'-'A'] = NAME_MONSTER_C;
	monsterCatalog['C'-'A'][MCATALOG_FLAG]			= (MFLAG_ASLEEP|MFLAG_WANDERS);
	monsterCatalog['C'-'A'][MCATALOG_DAMAGE]		= 0x03030205;
	monsterCatalog['C'-'A'][MCATALOG_HP]			= 32;
	monsterCatalog['C'-'A'][MCATALOG_EXP]			= 15;
	monsterCatalog['C'-'A'][MCATALOG_START_FLOOR]	= 7;
	monsterCatalog['C'-'A'][MCATALOG_END_FLOOR]		= 16;
	monsterCatalog['C'-'A'][MCATALOG_CHANCE]		= 85;
	monsterCatalog['C'-'A'][MCATALOG_DROP]			= 10;
	monsterCatalog['C'-'A'][MCATALOG_QUIVER]		= 0;
#if !defined(HANKAKU) && defined(JP)
	monsterCatalog['C'-'A'][MCATALOG_CHAR]			= 'b';
#else
	monsterCatalog['C'-'A'][MCATALOG_CHAR]			= 'C';
#endif
	//'D':Dragon
	//{(MFLAG_ASLEEP|MFLAG_WAKENS|MFLAG_FLAMES),"4d6/4d9",145,'D',5000,21,126,100,0,90,0,0,0},
	strMonster['D'-'A'] = NAME_MONSTER_D;
	monsterCatalog['D'-'A'][MCATALOG_FLAG]			= (MFLAG_ASLEEP|MFLAG_WAKENS|MFLAG_FLAMES);
	monsterCatalog['D'-'A'][MCATALOG_DAMAGE]		= 0x04060409;
	monsterCatalog['D'-'A'][MCATALOG_HP]			= 145;
	monsterCatalog['D'-'A'][MCATALOG_EXP]			= 5000;
	monsterCatalog['D'-'A'][MCATALOG_START_FLOOR]	= 21;
	monsterCatalog['D'-'A'][MCATALOG_END_FLOOR]		= 126;
	monsterCatalog['D'-'A'][MCATALOG_CHANCE]		= 100;
	monsterCatalog['D'-'A'][MCATALOG_DROP]			= 90;
	monsterCatalog['D'-'A'][MCATALOG_QUIVER]		= 0;
#if !defined(HANKAKU) && defined(JP)
	monsterCatalog['D'-'A'][MCATALOG_CHAR]			= 'c';
#else
	monsterCatalog['D'-'A'][MCATALOG_CHAR]			= 'D';
#endif
	//'E':Emu
	//{(MFLAG_ASLEEP|MFLAG_WAKENS),"1d3",11,'E',2,1,7,65,0,0,0,0,0},
	strMonster['E'-'A'] = NAME_MONSTER_E;
	monsterCatalog['E'-'A'][MCATALOG_FLAG]			= (MFLAG_ASLEEP|MFLAG_WAKENS);
	monsterCatalog['E'-'A'][MCATALOG_DAMAGE]		= 0x0103;
	monsterCatalog['E'-'A'][MCATALOG_HP]			= 11;
	monsterCatalog['E'-'A'][MCATALOG_EXP]			= 2;
	monsterCatalog['E'-'A'][MCATALOG_START_FLOOR]	= 1;
	monsterCatalog['E'-'A'][MCATALOG_END_FLOOR]		= 7;
	monsterCatalog['E'-'A'][MCATALOG_CHANCE]		= 65;
	monsterCatalog['E'-'A'][MCATALOG_DROP]			= 0;
	monsterCatalog['E'-'A'][MCATALOG_QUIVER]		= 0;
#if !defined(HANKAKU) && defined(JP)
	monsterCatalog['E'-'A'][MCATALOG_CHAR]			= 'd';
#else
	monsterCatalog['E'-'A'][MCATALOG_CHAR]			= 'E';
#endif
	//'F':venus Fly-trap
	//{(MFLAG_HOLDS|MFLAG_STATIONARY),"5d5",73,'F',91,12,126,80,0,0,0,0,0},
	strMonster['F'-'A'] = NAME_MONSTER_F;
	monsterCatalog['F'-'A'][MCATALOG_FLAG]			= (MFLAG_HOLDS|MFLAG_STATIONARY);
	monsterCatalog['F'-'A'][MCATALOG_DAMAGE]		= 0x0505;
	monsterCatalog['F'-'A'][MCATALOG_HP]			= 73;
	monsterCatalog['F'-'A'][MCATALOG_EXP]			= 90;
	monsterCatalog['F'-'A'][MCATALOG_START_FLOOR]	= 12;
	monsterCatalog['F'-'A'][MCATALOG_END_FLOOR]		= 126;
	monsterCatalog['F'-'A'][MCATALOG_CHANCE]		= 80;
	monsterCatalog['F'-'A'][MCATALOG_DROP]			= 0;
	monsterCatalog['F'-'A'][MCATALOG_QUIVER]		= 0;
#if !defined(HANKAKU) && defined(JP)
	monsterCatalog['F'-'A'][MCATALOG_CHAR]			= 'e';
#else
	monsterCatalog['F'-'A'][MCATALOG_CHAR]			= 'F';
#endif
	//'G':Griffin
	//{(MFLAG_ASLEEP|MFLAG_WAKENS|MFLAG_WANDERS|MFLAG_FLIES),"5d5/5d5",115,'G',2000,20,126,85,0,10,0,0,0},
	strMonster['G'-'A'] = NAME_MONSTER_G;
	monsterCatalog['G'-'A'][MCATALOG_FLAG]			= (MFLAG_ASLEEP|MFLAG_WAKENS|MFLAG_WANDERS|MFLAG_FLIES);
	monsterCatalog['G'-'A'][MCATALOG_DAMAGE]		= 0x05050505;
	monsterCatalog['G'-'A'][MCATALOG_HP]			= 115;
	monsterCatalog['G'-'A'][MCATALOG_EXP]			= 2000;
	monsterCatalog['G'-'A'][MCATALOG_START_FLOOR]	= 20;
	monsterCatalog['G'-'A'][MCATALOG_END_FLOOR]		= 126;
	monsterCatalog['G'-'A'][MCATALOG_CHANCE]		= 85;
	monsterCatalog['G'-'A'][MCATALOG_DROP]			= 10;
	monsterCatalog['G'-'A'][MCATALOG_QUIVER]		= 0;
#if !defined(HANKAKU) && defined(JP)
	monsterCatalog['G'-'A'][MCATALOG_CHAR]			= 'f';
#else
	monsterCatalog['G'-'A'][MCATALOG_CHAR]			= 'G';
#endif
	//'H':Hobgoblin
	//{(MFLAG_ASLEEP|MFLAG_WAKENS|MFLAG_WANDERS),"1d3/1d2",15,'H',3,1,10,67,0,0,0,0,0},
	strMonster['H'-'A'] = NAME_MONSTER_H;
	monsterCatalog['H'-'A'][MCATALOG_FLAG]			= (MFLAG_ASLEEP|MFLAG_WAKENS|MFLAG_WANDERS);
	monsterCatalog['H'-'A'][MCATALOG_DAMAGE]		= 0x01030102;
	monsterCatalog['H'-'A'][MCATALOG_HP]			= 15;
	monsterCatalog['H'-'A'][MCATALOG_EXP]			= 3;
	monsterCatalog['H'-'A'][MCATALOG_START_FLOOR]	= 1;
	monsterCatalog['H'-'A'][MCATALOG_END_FLOOR]		= 10;
	monsterCatalog['H'-'A'][MCATALOG_CHANCE]		= 67;
	monsterCatalog['H'-'A'][MCATALOG_DROP]			= 0;
	monsterCatalog['H'-'A'][MCATALOG_QUIVER]		= 0;
#if !defined(HANKAKU) && defined(JP)
	monsterCatalog['H'-'A'][MCATALOG_CHAR]			= 'g';
#else
	monsterCatalog['H'-'A'][MCATALOG_CHAR]			= 'H';
#endif
	//'I':Ice monster
	//{(MFLAG_ASLEEP|MFLAG_FREEZES),"0d0",15,'I',5,2,11,68,0,0,0,0,0},
	strMonster['I'-'A'] = NAME_MONSTER_I;
	monsterCatalog['I'-'A'][MCATALOG_FLAG]			= (MFLAG_ASLEEP|MFLAG_FREEZES);
	monsterCatalog['I'-'A'][MCATALOG_DAMAGE]		= 0;
	monsterCatalog['I'-'A'][MCATALOG_HP]			= 15;
	monsterCatalog['I'-'A'][MCATALOG_EXP]			= 5;
	monsterCatalog['I'-'A'][MCATALOG_START_FLOOR]	= 2;
	monsterCatalog['I'-'A'][MCATALOG_END_FLOOR]		= 11;
	monsterCatalog['I'-'A'][MCATALOG_CHANCE]		= 68;
	monsterCatalog['I'-'A'][MCATALOG_DROP]			= 0;
	monsterCatalog['I'-'A'][MCATALOG_QUIVER]		= 0;
#if !defined(HANKAKU) && defined(JP)
	monsterCatalog['I'-'A'][MCATALOG_CHAR]			= 'h';
#else
	monsterCatalog['I'-'A'][MCATALOG_CHAR]			= 'I';
#endif
	//'J':Jabberwock
	//{(MFLAG_ASLEEP|MFLAG_WANDERS),"3d10/4d5",132,'J',3000,21,126,100,0,0,0,0,0},
	strMonster['J'-'A'] = NAME_MONSTER_J;
	monsterCatalog['J'-'A'][MCATALOG_FLAG]			= (MFLAG_ASLEEP|MFLAG_WANDERS);
	monsterCatalog['J'-'A'][MCATALOG_DAMAGE]		= 0x030a0405;
	monsterCatalog['J'-'A'][MCATALOG_HP]			= 132;
	monsterCatalog['J'-'A'][MCATALOG_EXP]			= 3000;
	monsterCatalog['J'-'A'][MCATALOG_START_FLOOR]	= 21;
	monsterCatalog['J'-'A'][MCATALOG_END_FLOOR]		= 126;
	monsterCatalog['J'-'A'][MCATALOG_CHANCE]		= 100;
	monsterCatalog['J'-'A'][MCATALOG_DROP]			= 0;
	monsterCatalog['J'-'A'][MCATALOG_QUIVER]		= 0;
#if !defined(HANKAKU) && defined(JP)
	monsterCatalog['J'-'A'][MCATALOG_CHAR]			= 'i';
#else
	monsterCatalog['J'-'A'][MCATALOG_CHAR]			= 'J';
#endif
	//'K':Kestrel
	//{(MFLAG_ASLEEP|MFLAG_WAKENS|MFLAG_WANDERS|MFLAG_FLIES),"1d4",10,'K',2,1,6,60,0,0,0,0,0},
	strMonster['K'-'A'] = NAME_MONSTER_K;
	monsterCatalog['K'-'A'][MCATALOG_FLAG]			= (MFLAG_ASLEEP|MFLAG_WAKENS|MFLAG_WANDERS|MFLAG_FLIES);
	monsterCatalog['K'-'A'][MCATALOG_DAMAGE]		= 0x0104;
	monsterCatalog['K'-'A'][MCATALOG_HP]			= 10;
	monsterCatalog['K'-'A'][MCATALOG_EXP]			= 2;
	monsterCatalog['K'-'A'][MCATALOG_START_FLOOR]	= 1;
	monsterCatalog['K'-'A'][MCATALOG_END_FLOOR]		= 6;
	monsterCatalog['K'-'A'][MCATALOG_CHANCE]		= 60;
	monsterCatalog['K'-'A'][MCATALOG_DROP]			= 0;
	monsterCatalog['K'-'A'][MCATALOG_QUIVER]		= 0;
#if !defined(HANKAKU) && defined(JP)
	monsterCatalog['K'-'A'][MCATALOG_CHAR]			= 'j';
#else
	monsterCatalog['K'-'A'][MCATALOG_CHAR]			= 'K';
#endif
	//'L':Leprechaun
	//{(MFLAG_ASLEEP|MFLAG_STEALS_GOLD),"0d0",25,'L',21,6,16,75,0,0,0,0,0},
	strMonster['L'-'A'] = NAME_MONSTER_L;
	monsterCatalog['L'-'A'][MCATALOG_FLAG]			= (MFLAG_ASLEEP|MFLAG_STEALS_GOLD);
	monsterCatalog['L'-'A'][MCATALOG_DAMAGE]		= 0;
	monsterCatalog['L'-'A'][MCATALOG_HP]			= 25;
	monsterCatalog['L'-'A'][MCATALOG_EXP]			= 21;
	monsterCatalog['L'-'A'][MCATALOG_START_FLOOR]	= 6;
	monsterCatalog['L'-'A'][MCATALOG_END_FLOOR]		= 16;
	monsterCatalog['L'-'A'][MCATALOG_CHANCE]		= 75;
	monsterCatalog['L'-'A'][MCATALOG_DROP]			= 0;
	monsterCatalog['L'-'A'][MCATALOG_QUIVER]		= 0;
#if !defined(HANKAKU) && defined(JP)
	monsterCatalog['L'-'A'][MCATALOG_CHAR]			= 'k';
#else
	monsterCatalog['L'-'A'][MCATALOG_CHAR]			= 'L';
#endif
	//'M':Medusa
	//{(MFLAG_ASLEEP|MFLAG_WAKENS|MFLAG_WANDERS|MFLAG_CONFUSES),"4d4/3d7",97,'M',250,18,126,85,0,25,0,0,0},
	strMonster['M'-'A'] = NAME_MONSTER_M;
	monsterCatalog['M'-'A'][MCATALOG_FLAG]			= (MFLAG_ASLEEP|MFLAG_WAKENS|MFLAG_WANDERS|MFLAG_CONFUSES);
	monsterCatalog['M'-'A'][MCATALOG_DAMAGE]		= 0x04040307;
	monsterCatalog['M'-'A'][MCATALOG_HP]			= 97;
	monsterCatalog['M'-'A'][MCATALOG_EXP]			= 250;
	monsterCatalog['M'-'A'][MCATALOG_START_FLOOR]	= 18;
	monsterCatalog['M'-'A'][MCATALOG_END_FLOOR]	= 126;
	monsterCatalog['M'-'A'][MCATALOG_CHANCE]		= 85;
	monsterCatalog['M'-'A'][MCATALOG_DROP]			= 25;
	monsterCatalog['M'-'A'][MCATALOG_QUIVER]		= 0;
#if !defined(HANKAKU) && defined(JP)
	monsterCatalog['M'-'A'][MCATALOG_CHAR]			= 'l';
#else
	monsterCatalog['M'-'A'][MCATALOG_CHAR]			= 'M';
#endif
	//'N':Nymph
	//{(MFLAG_ASLEEP|MFLAG_STEALS_ITEM),"0d0",25,'N',39,10,19,75,0,100,0,0,0},
	strMonster['N'-'A'] = NAME_MONSTER_N;
	monsterCatalog['N'-'A'][MCATALOG_FLAG]			= (MFLAG_ASLEEP|MFLAG_STEALS_ITEM);
	monsterCatalog['N'-'A'][MCATALOG_DAMAGE]		= 0;
	monsterCatalog['N'-'A'][MCATALOG_HP]			= 25;
	monsterCatalog['N'-'A'][MCATALOG_EXP]			= 39;
	monsterCatalog['N'-'A'][MCATALOG_START_FLOOR]	= 10;
	monsterCatalog['N'-'A'][MCATALOG_END_FLOOR]		= 19;
	monsterCatalog['N'-'A'][MCATALOG_CHANCE]		= 75;
	monsterCatalog['N'-'A'][MCATALOG_DROP]			= 100;
	monsterCatalog['N'-'A'][MCATALOG_QUIVER]		= 0;
#if !defined(HANKAKU) && defined(JP)
	monsterCatalog['N'-'A'][MCATALOG_CHAR]			= 'm';
#else
	monsterCatalog['N'-'A'][MCATALOG_CHAR]			= 'N';
#endif
	//'O':Orc
	//{(MFLAG_ASLEEP|MFLAG_WANDERS|MFLAG_WAKENS|MFLAG_SEEKS_GOLD),"1d6",25,'O',5,4,13,70,0,10,0,0,0},
	strMonster['O'-'A'] = NAME_MONSTER_O;
	monsterCatalog['O'-'A'][MCATALOG_FLAG]			= (MFLAG_ASLEEP|MFLAG_WANDERS|MFLAG_WAKENS|MFLAG_SEEKS_GOLD);
	monsterCatalog['O'-'A'][MCATALOG_DAMAGE]		= 0x0106;
	monsterCatalog['O'-'A'][MCATALOG_HP]			= 25;
	monsterCatalog['O'-'A'][MCATALOG_EXP]			= 5;
	monsterCatalog['O'-'A'][MCATALOG_START_FLOOR]	= 4;
	monsterCatalog['O'-'A'][MCATALOG_END_FLOOR]		= 13;
	monsterCatalog['O'-'A'][MCATALOG_CHANCE]		= 70;
	monsterCatalog['O'-'A'][MCATALOG_DROP]			= 10;
	monsterCatalog['O'-'A'][MCATALOG_QUIVER]		= 0;
#if !defined(HANKAKU) && defined(JP)
	monsterCatalog['O'-'A'][MCATALOG_CHAR]			= 'n';
#else
	monsterCatalog['O'-'A'][MCATALOG_CHAR]			= 'O';
#endif
	//'P':Phantom
	//{(MFLAG_ASLEEP|MFLAG_INVISIBLE|MFLAG_WANDERS|MFLAG_FLITS),"5d4",76,'P',120,15,24,80,0,50,0,0,0},
	strMonster['P'-'A'] = NAME_MONSTER_P;
	monsterCatalog['P'-'A'][MCATALOG_FLAG]			= (MFLAG_ASLEEP|MFLAG_INVISIBLE|MFLAG_WANDERS|MFLAG_FLITS);
	monsterCatalog['P'-'A'][MCATALOG_DAMAGE]		= 0x0504;
	monsterCatalog['P'-'A'][MCATALOG_HP]			= 76;
	monsterCatalog['P'-'A'][MCATALOG_EXP]			= 120;
	monsterCatalog['P'-'A'][MCATALOG_START_FLOOR]	= 15;
	monsterCatalog['P'-'A'][MCATALOG_END_FLOOR]		= 24;
	monsterCatalog['P'-'A'][MCATALOG_CHANCE]		= 80;
	monsterCatalog['P'-'A'][MCATALOG_DROP]			= 50;
	monsterCatalog['P'-'A'][MCATALOG_QUIVER]		= 0;
#if !defined(HANKAKU) && defined(JP)
	monsterCatalog['P'-'A'][MCATALOG_CHAR]			= 'o';
#else
	monsterCatalog['P'-'A'][MCATALOG_CHAR]			= 'P';
#endif
	//'Q':Quagga
	//{(MFLAG_ASLEEP|MFLAG_WAKENS|MFLAG_WANDERS),"3d5",30,'Q',20,8,17,78,0,20,0,0,0},
	strMonster['Q'-'A'] = NAME_MONSTER_Q;
	monsterCatalog['Q'-'A'][MCATALOG_FLAG]			= (MFLAG_ASLEEP|MFLAG_WAKENS|MFLAG_WANDERS);
	monsterCatalog['Q'-'A'][MCATALOG_DAMAGE]		= 0x0305;
	monsterCatalog['Q'-'A'][MCATALOG_HP]			= 30;
	monsterCatalog['Q'-'A'][MCATALOG_EXP]			= 20;
	monsterCatalog['Q'-'A'][MCATALOG_START_FLOOR]	= 8;
	monsterCatalog['Q'-'A'][MCATALOG_END_FLOOR]		= 17;
	monsterCatalog['Q'-'A'][MCATALOG_CHANCE]		= 78;
	monsterCatalog['Q'-'A'][MCATALOG_DROP]			= 20;
	monsterCatalog['Q'-'A'][MCATALOG_QUIVER]		= 0;
#if !defined(HANKAKU) && defined(JP)
	monsterCatalog['Q'-'A'][MCATALOG_CHAR]			= 'p';
#else
	monsterCatalog['Q'-'A'][MCATALOG_CHAR]			= 'Q';
#endif
	//'R':Rattlesnake
	//{(MFLAG_ASLEEP|MFLAG_WAKENS|MFLAG_WANDERS|MFLAG_STINGS),"2d5",19,'R',10,3,12,70,0,0,0,0,0},
	strMonster['R'-'A'] = NAME_MONSTER_R;
	monsterCatalog['R'-'A'][MCATALOG_FLAG]			= (MFLAG_ASLEEP|MFLAG_WAKENS|MFLAG_WANDERS|MFLAG_STINGS);
	monsterCatalog['R'-'A'][MCATALOG_DAMAGE]		= 0x0205;
	monsterCatalog['R'-'A'][MCATALOG_HP]			= 19;
	monsterCatalog['R'-'A'][MCATALOG_EXP]			= 10;
	monsterCatalog['R'-'A'][MCATALOG_START_FLOOR]	= 3;
	monsterCatalog['R'-'A'][MCATALOG_END_FLOOR]		= 12;
	monsterCatalog['R'-'A'][MCATALOG_CHANCE]		= 70;
	monsterCatalog['R'-'A'][MCATALOG_DROP]			= 0;
	monsterCatalog['R'-'A'][MCATALOG_QUIVER]		= 0;
#if !defined(HANKAKU) && defined(JP)
	monsterCatalog['R'-'A'][MCATALOG_CHAR]			= 'q';
#else
	monsterCatalog['R'-'A'][MCATALOG_CHAR]			= 'R';
#endif
	//'S':Snake
	//{(MFLAG_ASLEEP|MFLAG_WAKENS|MFLAG_WANDERS),"1d3",8,'S',2,1,9,50,0,0,0,0,0},
	strMonster['S'-'A'] = NAME_MONSTER_S;
	monsterCatalog['S'-'A'][MCATALOG_FLAG]			= (MFLAG_ASLEEP|MFLAG_WAKENS|MFLAG_WANDERS);
	monsterCatalog['S'-'A'][MCATALOG_DAMAGE]		= 0x0103;
	monsterCatalog['S'-'A'][MCATALOG_HP]			= 8;
	monsterCatalog['S'-'A'][MCATALOG_EXP]			= 2;
	monsterCatalog['S'-'A'][MCATALOG_START_FLOOR]	= 1;
	monsterCatalog['S'-'A'][MCATALOG_END_FLOOR]		= 9;
	monsterCatalog['S'-'A'][MCATALOG_CHANCE]		= 50;
	monsterCatalog['S'-'A'][MCATALOG_DROP]			= 0;
	monsterCatalog['S'-'A'][MCATALOG_QUIVER]		= 0;
#if !defined(HANKAKU) && defined(JP)
	monsterCatalog['S'-'A'][MCATALOG_CHAR]			= 'r';
#else
	monsterCatalog['S'-'A'][MCATALOG_CHAR]			= 'S';
#endif
	//'T':Troll
	//{(MFLAG_ASLEEP|MFLAG_WAKENS|MFLAG_WANDERS),"4d6/1d4",75,'T',125,13,22,75,0,33,0,0,0},
	strMonster['T'-'A'] = NAME_MONSTER_T;
	monsterCatalog['T'-'A'][MCATALOG_FLAG]			= (MFLAG_ASLEEP|MFLAG_WAKENS|MFLAG_WANDERS);
	monsterCatalog['T'-'A'][MCATALOG_DAMAGE]		= 0x04060104;
	monsterCatalog['T'-'A'][MCATALOG_HP]			= 75;
	monsterCatalog['T'-'A'][MCATALOG_EXP]			= 125;
	monsterCatalog['T'-'A'][MCATALOG_START_FLOOR]	= 13;
	monsterCatalog['T'-'A'][MCATALOG_END_FLOOR]		= 22;
	monsterCatalog['T'-'A'][MCATALOG_CHANCE]		= 75;
	monsterCatalog['T'-'A'][MCATALOG_DROP]			= 33;
	monsterCatalog['T'-'A'][MCATALOG_QUIVER]		= 0;
#if !defined(HANKAKU) && defined(JP)
	monsterCatalog['T'-'A'][MCATALOG_CHAR]			= 's';
#else
	monsterCatalog['T'-'A'][MCATALOG_CHAR]			= 'T';
#endif
	//'U':black Unicorn
	//{(MFLAG_ASLEEP|MFLAG_WAKENS|MFLAG_WANDERS),"4d10",90,'U',200,17,26,85,0,33,0,0,0},
	strMonster['U'-'A'] = NAME_MONSTER_U;
	monsterCatalog['U'-'A'][MCATALOG_FLAG]			= (MFLAG_ASLEEP|MFLAG_WAKENS|MFLAG_WANDERS);
	monsterCatalog['U'-'A'][MCATALOG_DAMAGE]		= 0x040a;
	monsterCatalog['U'-'A'][MCATALOG_HP]			= 90;
	monsterCatalog['U'-'A'][MCATALOG_EXP]			= 200;
	monsterCatalog['U'-'A'][MCATALOG_START_FLOOR]	= 17;
	monsterCatalog['U'-'A'][MCATALOG_END_FLOOR]		= 26;
	monsterCatalog['U'-'A'][MCATALOG_CHANCE]		= 85;
	monsterCatalog['U'-'A'][MCATALOG_DROP]			= 33;
	monsterCatalog['U'-'A'][MCATALOG_QUIVER]		= 0;
#if !defined(HANKAKU) && defined(JP)
	monsterCatalog['U'-'A'][MCATALOG_CHAR]			= 't';
#else
	monsterCatalog['U'-'A'][MCATALOG_CHAR]			= 'U';
#endif
	//'V':Vampire
	//{(MFLAG_ASLEEP|MFLAG_WAKENS|MFLAG_WANDERS|MFLAG_DRAINS_LIFE),"1d14/1d4",55,'V',350,19,126,85,0,18,0,0,0},
	strMonster['V'-'A'] = NAME_MONSTER_V;
	monsterCatalog['V'-'A'][MCATALOG_FLAG]			= (MFLAG_ASLEEP|MFLAG_WAKENS|MFLAG_WANDERS|MFLAG_DRAINS_LIFE);
	monsterCatalog['V'-'A'][MCATALOG_DAMAGE]		= 0x01e0104;
	monsterCatalog['V'-'A'][MCATALOG_HP]			= 55;
	monsterCatalog['V'-'A'][MCATALOG_EXP]			= 350;
	monsterCatalog['V'-'A'][MCATALOG_START_FLOOR]	= 19;
	monsterCatalog['V'-'A'][MCATALOG_END_FLOOR]		= 126;
	monsterCatalog['V'-'A'][MCATALOG_CHANCE]		= 85;
	monsterCatalog['V'-'A'][MCATALOG_DROP]			= 18;
	monsterCatalog['V'-'A'][MCATALOG_QUIVER]		= 0;
#if !defined(HANKAKU) && defined(JP)
	monsterCatalog['V'-'A'][MCATALOG_CHAR]			= 'u';
#else
	monsterCatalog['V'-'A'][MCATALOG_CHAR]			= 'V';
#endif
	//'W':Wraith
	//{(MFLAG_ASLEEP|MFLAG_WANDERS|MFLAG_DROPS_FLOOR),"2d8",45,'W',55,14,23,75,0,0,0,0,0},
	strMonster['W'-'A'] = NAME_MONSTER_W;
	monsterCatalog['W'-'A'][MCATALOG_FLAG]			= (MFLAG_ASLEEP|MFLAG_WANDERS|MFLAG_DROPS_LEVEL);
	monsterCatalog['W'-'A'][MCATALOG_DAMAGE]		= 0x0208;
	monsterCatalog['W'-'A'][MCATALOG_HP]			= 45;
	monsterCatalog['W'-'A'][MCATALOG_EXP]			= 55;
	monsterCatalog['W'-'A'][MCATALOG_START_FLOOR]	= 14;
	monsterCatalog['W'-'A'][MCATALOG_END_FLOOR]		= 23;
	monsterCatalog['W'-'A'][MCATALOG_CHANCE]		= 75;
	monsterCatalog['W'-'A'][MCATALOG_DROP]			= 0;
	monsterCatalog['W'-'A'][MCATALOG_QUIVER]		= 0;
#if !defined(HANKAKU) && defined(JP)
	monsterCatalog['W'-'A'][MCATALOG_CHAR]			= 'v';
#else
	monsterCatalog['W'-'A'][MCATALOG_CHAR]			= 'W';
#endif
	//'X':Xeroc
	//{(MFLAG_ASLEEP|MFLAG_MIMIC),"4d6",42,'X',110,16,25,75,0,0,0,0,0},
	strMonster['X'-'A'] = NAME_MONSTER_X;
	monsterCatalog['X'-'A'][MCATALOG_FLAG]			= (MFLAG_ASLEEP|MFLAG_MIMIC);
	monsterCatalog['X'-'A'][MCATALOG_DAMAGE]		= 0x0406;
	monsterCatalog['X'-'A'][MCATALOG_HP]			= 42;
	monsterCatalog['X'-'A'][MCATALOG_EXP]			= 110;
	monsterCatalog['X'-'A'][MCATALOG_START_FLOOR]	= 16;
	monsterCatalog['X'-'A'][MCATALOG_END_FLOOR]		= 25;
	monsterCatalog['X'-'A'][MCATALOG_CHANCE]		= 75;
	monsterCatalog['X'-'A'][MCATALOG_DROP]			= 0;
	monsterCatalog['X'-'A'][MCATALOG_QUIVER]		= 0;
#if !defined(HANKAKU) && defined(JP)
	monsterCatalog['X'-'A'][MCATALOG_CHAR]			= 'w';
#else
	monsterCatalog['X'-'A'][MCATALOG_CHAR]			= 'X';
#endif
	//'Y':Yeti
	//{(MFLAG_ASLEEP|MFLAG_WANDERS),"3d6",35,'Y',50,11,20,80,0,20,0,0,0},
	strMonster['Y'-'A'] = NAME_MONSTER_Y;
	monsterCatalog['Y'-'A'][MCATALOG_FLAG]			= (MFLAG_ASLEEP|MFLAG_WANDERS);
	monsterCatalog['Y'-'A'][MCATALOG_DAMAGE]		= 0x0306;
	monsterCatalog['Y'-'A'][MCATALOG_HP]			= 35;
	monsterCatalog['Y'-'A'][MCATALOG_EXP]			= 50;
	monsterCatalog['Y'-'A'][MCATALOG_START_FLOOR]	= 11;
	monsterCatalog['Y'-'A'][MCATALOG_END_FLOOR]		= 20;
	monsterCatalog['Y'-'A'][MCATALOG_CHANCE]		= 80;
	monsterCatalog['Y'-'A'][MCATALOG_DROP]			= 20;
	monsterCatalog['Y'-'A'][MCATALOG_QUIVER]		= 0;
#if !defined(HANKAKU) && defined(JP)
	monsterCatalog['Y'-'A'][MCATALOG_CHAR]			= 'x';
#else
	monsterCatalog['Y'-'A'][MCATALOG_CHAR]			= 'Y';
#endif
	//'Z':Zombie
	//{(MFLAG_ASLEEP|MFLAG_WAKENS|MFLAG_WANDERS),"1d7",21,'Z',8,5,14,69,0,0,0,0,0}
	strMonster['Z'-'A'] = NAME_MONSTER_Z;
	monsterCatalog['Z'-'A'][MCATALOG_FLAG]			= (MFLAG_ASLEEP|MFLAG_WAKENS|MFLAG_WANDERS);
	monsterCatalog['Z'-'A'][MCATALOG_DAMAGE]		= 0x0107;
	monsterCatalog['Z'-'A'][MCATALOG_HP]			= 21;
	monsterCatalog['Z'-'A'][MCATALOG_EXP]			= 8;
	monsterCatalog['Z'-'A'][MCATALOG_START_FLOOR]	= 5;
	monsterCatalog['Z'-'A'][MCATALOG_END_FLOOR]		= 14;
	monsterCatalog['Z'-'A'][MCATALOG_CHANCE]		= 69;
	monsterCatalog['Z'-'A'][MCATALOG_DROP]			= 0;
	monsterCatalog['Z'-'A'][MCATALOG_QUIVER]		= 0;
#if !defined(HANKAKU) && defined(JP)
	monsterCatalog['Z'-'A'][MCATALOG_CHAR]			= 'y';
#else
	monsterCatalog['Z'-'A'][MCATALOG_CHAR]			= 'Z';
#endif

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private static String[] ringMaterial = {
#ifdef JP
//ۑ̊֌WłU܂ŁI
	"_C",
	"",
	"r[",
	"Gh",
	"Tt@CA",
	"",
	"",
	"Ֆڐ΂",
	"Ip[",
	"߂̂",
	"gR΂",
	"^",
	"΂",
#else
//max string length is 12
	"diamond",
	"lapi-lazuli",
	"ruby",
	"emerald",
	"sapphire",
	"amethyst",
	"quartz",
	"tiger-eye",
	"opal",
	"agate",
	"turquoise",
	"pearl",
	"garnet",
#endif
};

private static void ringInit() {
FUNCTION_CALLED("ringInit()");
FUNCTION_PRINT("call " +functionName);

	//shuffle
	int i;
	int count = ringMaterial.length;
	for (i=0; i<count; i++) {
		mazeTemp[0][i] = i;
	}
	int r;
	int t;
	for (i=0; i<count; i++) {
		r = randRandom(count);
		t = mazeTemp[0][i];
		mazeTemp[0][i] = mazeTemp[0][r];
		mazeTemp[0][r] = t;
	}

	for (i=0; i<RING_OBJECT_COUNT; i++) {
		strRing[i] = MAKE_OF_NAME(ringMaterial[mazeTemp[0][i]], NAME_OF_RING);
		ringCatalog[i] = ITEM_RING | (i<<8);
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private static String[] wandMaterial = {
#ifdef JP
//ۑ̊֌WłU܂ŁI
	"|S",
	"",
	"",
	"",
	"",
	"jbP",
	"Rog",
	"N",
	"v`i",
	"`^",
	"`[N",
	"~",
	"",
	"",
	"",
	"",
	"oT",
	"ۉ",
	"ӓ",
	"",
	"",
	"₵",
	"`",
#else
//max string length is 12
	"steel",
	"bronze",
	"gold",
	"silver",
	"copper",
	"nickel",
	"cobalt",
	"tin",
	"iron",
	"magnesium",
	"chrome",
	"carbon",
	"platinum",
	"silicon",
	"titanium",
	"teak",
	"oak",
	"cherry",
	"birch",
	"pine",
	"cedar",
	"redwood",
	"balsa",
	"ivory",
	"walnut",
	"maple",
	"mahogany",
	"elm",
	"palm",
	"wooden",
#endif
};

private static void wandInit() {
FUNCTION_CALLED("wandInit()");
FUNCTION_PRINT("call " +functionName);

	//shuffle
	int i;
	int count = wandMaterial.length;
	for (i=0; i<count; i++) {
		mazeTemp[0][i] = i;
	}
	int r;
	int t;
	for (i=0; i<count; i++) {
		r = randRandom(count);
		t = mazeTemp[0][i];
		mazeTemp[0][i] = mazeTemp[0][r];
		mazeTemp[0][r] = t;
	}

	for (i=0; i<WAND_OBJECT_COUNT; i++) {
		strWand[i] = MAKE_OF_NAME(wandMaterial[mazeTemp[0][i]], NAME_OF_WAND);
		wandCatalog[i] = ITEM_WAND | (i<<8);
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private static String[] potionMaterial = {
#ifdef JP
//ۑ̊֌WłU܂ŁI
	"",
	"Ԃ",
	"΂",
	"DF",
	"F",
	"",
	"sN",
	"",
	"",
	"",
	"F",
	"F",
	"ԂǂF",
	"IWF",
#else
//max string length is 12
	"blue",
	"red",
	"green",
	"grey",
	"brown",
	"clear",
	"pink",
	"white",
	"purple",
	"black",
	"yellow",
	"plaid",
	"burgundy",
	"beige",
#endif
};

private static void potionInit() {
FUNCTION_CALLED("potionInit()");
FUNCTION_PRINT("call " +functionName);

	//shuffle
	int i;
	int count = potionMaterial.length;
	for (i=0; i<count; i++) {
		mazeTemp[0][i] = i;
	}
	int r;
	int t;
	for (i=0; i<count; i++) {
		r = randRandom(count);
		t = mazeTemp[0][i];
		mazeTemp[0][i] = mazeTemp[0][r];
		mazeTemp[0][r] = t;
	}

	for (i=0; i<POTION_OBJECT_COUNT; i++) {
		strPotion[i] = MAKE_OF_NAME(potionMaterial[mazeTemp[0][i]], NAME_OF_POTION);
		potionCatalog[i] = ITEM_POTION | (i<<8);
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private static String[] scrollMaterial = {
#ifdef JP
//ۑ̊֌WłU܂ŁI̔܂ŁI
	"Ԃ",
	"",
	"Ƃ",
	"",
	"ۂ",
	"",
	"ǂ",
	"",
	"",
	"",
	"",
	"",
	"남",
	"",
	"",
	"",
	"",
	"҂",
	"ۂ",
	"ǂǂ",
	"Ђ",
	"",
	"ۂ",
	"",
	"΂",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"ɂႠ",
	"[",
	"ӂ",
	"",
	"[",
	"ۂ",
	"݁[",
	"ۂ",
#else
//max string length is 6
	"blech",
	"foo",
	"barf",
	"rech",
	"bar",
	"blech",
	"quo",
	"bloto",
	"oh",
	"caca",
	"blorp",
	"erp",
	"festr",
	"rot",
	"slie",
	"snorf",
	"iky",
	"yuky",
	"ooze",
	"ah",
	"bahl",
	"zep",
	"druhl",
	"flem",
	"behil",
	"arek",
	"mep",
	"zihr",
	"grit",
	"kona",
	"kini",
	"ichi",
	"tims",
	"ogr",
	"oo",
	"ighr",
	"coph",
	"swerr",
	"mihln",
	"poxi",
#endif
};

private static void scrollInit() {
FUNCTION_CALLED("scrollInit()");
FUNCTION_PRINT("call " +functionName);

	//shuffle
	int i;
	int count = scrollMaterial.length;
	for (i=0; i<count; i++) {
		mazeTemp[0][i] = i;
	}
	int r;
	int t;
	for (i=0; i<count; i++) {
		r = randRandom(count);
		t = mazeTemp[0][i];
		mazeTemp[0][i] = mazeTemp[0][r];
		mazeTemp[0][r] = t;
	}

	for (i=0; i<SCROLL_OBJECT_COUNT; i++) {
		strScroll[i] = NAME_OF_SCROLL +"'" +scrollMaterial[mazeTemp[0][i*2+0]];
		strScroll[i] += scrollMaterial[mazeTemp[0][i*2+1]] +"'";
		scrollCatalog[i] = ITEM_SCROLL | (i<<8);
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private static void trueNameInit() {
FUNCTION_CALLED("trueName()");
FUNCTION_PRINT("call " +functionName);

	strRingTrue[RING_STEALTH]			= MAKE_OF_NAME(NAME_RING_STEALTH, NAME_OF_RING);
	strRingTrue[RING_TELEPORT]			= MAKE_OF_NAME(NAME_RING_TELEPORT, NAME_OF_RING);
	strRingTrue[RING_REGENERATION]		= MAKE_OF_NAME(NAME_RING_REGENERATION, NAME_OF_RING);
	strRingTrue[RING_SLOW_DIGEST]		= MAKE_OF_NAME(NAME_RING_SLOW_DIGEST, NAME_OF_RING);
	strRingTrue[RING_STRENGTH]			= MAKE_OF_NAME(NAME_RING_STRENGTH, NAME_OF_RING);
	strRingTrue[RING_SUSTAIN_STRENGTH]	= MAKE_OF_NAME(NAME_RING_SUSTAIN_STRENGTH, NAME_OF_RING);
	strRingTrue[RING_DEXTERITY]			= MAKE_OF_NAME(NAME_RING_DEXTERITY, NAME_OF_RING);
	strRingTrue[RING_ADORNMENT]			= MAKE_OF_NAME(NAME_RING_ADORNMENT, NAME_OF_RING);
	strRingTrue[RING_SEE_INVISIBLE]		= MAKE_OF_NAME(NAME_RING_SEE_INVISIBLE, NAME_OF_RING);
	strRingTrue[RING_MAINTAIN_ITEM]		= MAKE_OF_NAME(NAME_RING_MAINTAIN_ITEM, NAME_OF_RING);
	strRingTrue[RING_SEARCHING]			= MAKE_OF_NAME(NAME_RING_SEARCHING, NAME_OF_RING);

	strWandTrue[WAND_TELE_AWAY]			= MAKE_OF_NAME(NAME_WAND_TELE_AWAY, NAME_OF_WAND);
	strWandTrue[WAND_SLOW_MONSTER]		= MAKE_OF_NAME(NAME_WAND_SLOW_MONSTER, NAME_OF_WAND);
	strWandTrue[WAND_CONFUSE_MONSTER]	= MAKE_OF_NAME(NAME_WAND_CONFUSE_MONSTER, NAME_OF_WAND);
	strWandTrue[WAND_INVISIBILITY]		= MAKE_OF_NAME(NAME_WAND_INVISIBILITY, NAME_OF_WAND);
	strWandTrue[WAND_POLYMORPH]			= MAKE_OF_NAME(NAME_WAND_POLYMORPH, NAME_OF_WAND);
	strWandTrue[WAND_HASTE_MONSTER]		= MAKE_OF_NAME(NAME_WAND_HASTE_MONSTER, NAME_OF_WAND);
	strWandTrue[WAND_PUT_TO_SLEEP]		= MAKE_OF_NAME(NAME_WAND_PUT_TO_SLEEP, NAME_OF_WAND);
	strWandTrue[WAND_MAGIC_MISSILE]		= MAKE_OF_NAME(NAME_WAND_MAGIC_MISSILE, NAME_OF_WAND);
	strWandTrue[WAND_CANCELLATION]		= MAKE_OF_NAME(NAME_WAND_CANCELLATION, NAME_OF_WAND);
	strWandTrue[WAND_DO_NOTHING]		= MAKE_OF_NAME(NAME_WAND_DO_NOTHING, NAME_OF_WAND);

	strPotionTrue[POTION_INCREASE_STRENGTH]	= MAKE_OF_NAME(NAME_POTION_INCREASE_STRENGTH, NAME_OF_POTION);
	strPotionTrue[POTION_RESTORE_STRENGTH]	= MAKE_OF_NAME(NAME_POTION_RESTORE_STRENGTH, NAME_OF_POTION);
	strPotionTrue[POTION_HEALING]			= MAKE_OF_NAME(NAME_POTION_HEALING, NAME_OF_POTION);
	strPotionTrue[POTION_EXTRA_HEALING]		= MAKE_OF_NAME(NAME_POTION_EXTRA_HEALING, NAME_OF_POTION);
	strPotionTrue[POTION_POISON]			= MAKE_OF_NAME(NAME_POTION_POISON, NAME_OF_POTION);
	strPotionTrue[POTION_RAISE_LEVEL]		= MAKE_OF_NAME(NAME_POTION_RAISE_LEVEL, NAME_OF_POTION);
	strPotionTrue[POTION_BLINDNESS]			= MAKE_OF_NAME(NAME_POTION_BLINDNESS, NAME_OF_POTION);
	strPotionTrue[POTION_HALLUCINATION]		= MAKE_OF_NAME(NAME_POTION_HALLUCINATION, NAME_OF_POTION);
	strPotionTrue[POTION_DETECT_MONSTER]	= MAKE_OF_NAME(NAME_POTION_DETECT_MONSTER, NAME_OF_POTION);
	strPotionTrue[POTION_DETECT_OBJECTS]	= MAKE_OF_NAME(NAME_POTION_DETECT_OBJECTS, NAME_OF_POTION);
	strPotionTrue[POTION_CONFUSION]			= MAKE_OF_NAME(NAME_POTION_CONFUSION, NAME_OF_POTION);
	strPotionTrue[POTION_LEVITATION]		= MAKE_OF_NAME(NAME_POTION_LEVITATION, NAME_OF_POTION);
	strPotionTrue[POTION_HASTE_SELF]		= MAKE_OF_NAME(NAME_POTION_HASTE_SELF, NAME_OF_POTION);
	strPotionTrue[POTION_SEE_INVISIBLE]		= MAKE_OF_NAME(NAME_POTION_SEE_INVISIBLE, NAME_OF_POTION);

	strScrollTrue[SCROLL_PROTECT_ARMOR]		= MAKE_OF_NAME(NAME_SCROLL_PROTECT_ARMOR, NAME_OF_SCROLL);
	strScrollTrue[SCROLL_HOLD_MONSTER]		= MAKE_OF_NAME(NAME_SCROLL_HOLD_MONSTER, NAME_OF_SCROLL);
	strScrollTrue[SCROLL_ENCH_WEAPON]		= MAKE_OF_NAME(NAME_SCROLL_ENCH_WEAPON, NAME_OF_SCROLL);
	strScrollTrue[SCROLL_ENCH_ARMOR]		= MAKE_OF_NAME(NAME_SCROLL_ENCH_ARMOR, NAME_OF_SCROLL);
	strScrollTrue[SCROLL_IDENTIFY]			= MAKE_OF_NAME(NAME_SCROLL_IDENTIFY, NAME_OF_SCROLL);
	strScrollTrue[SCROLL_TELEPORT]			= MAKE_OF_NAME(NAME_SCROLL_TELEPORT, NAME_OF_SCROLL);
	strScrollTrue[SCROLL_SLEEP]				= MAKE_OF_NAME(NAME_SCROLL_SLEEP, NAME_OF_SCROLL);
	strScrollTrue[SCROLL_SCARE_MONSTER]		= MAKE_OF_NAME(NAME_SCROLL_SCARE_MONSTER, NAME_OF_SCROLL);
	strScrollTrue[SCROLL_REMOVE_CURSE]		= MAKE_OF_NAME(NAME_SCROLL_REMOVE_CURSE, NAME_OF_SCROLL);
	strScrollTrue[SCROLL_CREATE_MONSTER]	= MAKE_OF_NAME(NAME_SCROLL_CREATE_MONSTER, NAME_OF_SCROLL);
	strScrollTrue[SCROLL_AGGRAVATE_MONSTER]	= MAKE_OF_NAME(NAME_SCROLL_AGGRAVATE_MONSTER, NAME_OF_SCROLL);
	strScrollTrue[SCROLL_MAGIC_MAPPING]		= MAKE_OF_NAME(NAME_SCROLL_MAGIC_MAPPING, NAME_OF_SCROLL);

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private static void gameInit() {
FUNCTION_CALLED("gameInit()");
FUNCTION_PRINT("call " +functionName);

	//dungeon
	curFloor = 0;
	maxFloor = 0;
	trapDoor = false;

	//item init
	trueNameInit();
	ringInit();
	wandInit();
	potionInit();
	scrollInit();

	//player
	int i;
	for (i=0; i<MAX_PACK_COUNT; i++) {
		pcPack[i] = ITEM_NONE;
	}
	pcMaxHP		= INIT_HP;
	pcCurHP		= pcMaxHP;
	pcMaxSTR	= INIT_STR;
	pcCurSTR	= pcMaxSTR;
	pcGold		= 0;
	pcLevel		= 1;
	pcExp		= 0;

	for (i=0; i<STATE_COUNT; i++) {
		pcState[i] = 0;
	}

	//initial items
	pcWeapon	= (ITEM_EQUIP|ITEM_IDENTIFY|ITEM_WEAPON|(WEAPON_MACE<<8)|4);
	pcArmor		= (ITEM_EQUIP|ITEM_IDENTIFY|ITEM_ARMOR|(ARMOR_RINGMAIL<<8)|3);
	pcSubweapon	= (ITEM_EQUIP|ITEM_SUBWEAPON|(SUBWEAPON_DART<<8)|(randRandom(16)+20));

	pcPack[0]	= pcWeapon;
	pcPack[1]	= pcArmor;
	pcPack[2]	= pcSubweapon;
	pcPack[3]	= (ITEM_FOOD | FOOD_RATION);
	pcPackCount = 4;
	pcRing[0]	= ITEM_NONE;
	pcRing[1]	= ITEM_NONE;
#ifdef DEBUG
	curFloor = 15;
	pcExp		= levelExp[10];
	pcWeapon	= (ITEM_EQUIP|ITEM_CURSED|ITEM_IDENTIFY|ITEM_WEAPON|(WEAPON_TWO_HANDED_SWORD<<8)|6);
	pcPack[0]	= pcWeapon;
	pcArmor		= (ITEM_EQUIP|ITEM_CURSED|ITEM_IDENTIFY|ITEM_ARMOR|(ARMOR_PLATE<<8)|6);
	pcPack[1]	= pcArmor;
	pcSubweapon	= (ITEM_EQUIP|ITEM_SUBWEAPON|(SUBWEAPON_SHURIKEN<<8)|255);
	pcPack[2]	= pcSubweapon;
	pcPack[3]	= (ITEM_CURSED|ITEM_IDENTIFY|ITEM_WEAPON|(WEAPON_TWO_HANDED_SWORD<<8)|6);

	pcPack[4]	= (ITEM_SCROLL | (SCROLL_REMOVE_CURSE << 8));
	pcPackCount = 5;
	pcPack[5]	= (ITEM_SCROLL | (SCROLL_IDENTIFY << 8));
	pcPackCount = 6;
	pcPack[6]	= (ITEM_POTION | (POTION_DETECT_MONSTER << 8));
	pcPackCount = 7;
	pcPack[7]	= (ITEM_POTION | (POTION_RAISE_LEVEL << 8));
	pcPackCount = 8;
	pcPack[8]	= (ITEM_WAND | (0 << 8) | 3);
	pcPackCount = 9;
	pcPack[9]	= (ITEM_WAND | (1 << 8) | 3);
	pcPackCount = 10;
	pcPack[10]	= (ITEM_CURSED | ITEM_RING | (RING_REGENERATION << 8) | 2);
	pcPackCount = 11;
	pcPack[11]	= (ITEM_RING | (RING_SEARCHING << 8) | 4);
	pcPackCount = 12;
#endif
	healInterval = 0;
	pcEnergy = ENERGY_FULL;
	//pcEnergy = ENERGY_FULL - ENERGY_HUNGRY;

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private static void loadGame() {
FUNCTION_CALLED("loadGame()");
FUNCTION_PRINT("call " +functionName);

	trapDoor = false;
	trueNameInit();

	loadSave();

	//equip slot check
	int d,type;
	int i;
	for (i=0; i<pcPackCount; i++) {
		d = pcPack[i];
		if (IS_TRUE(d & ITEM_EQUIP)) {
			type = d & ITEM_TYPE_FLAG;
			if (type == ITEM_ARMOR) {
				pcArmor = d;
			} else if (type == ITEM_WEAPON) {
				pcWeapon = d;
			} else if (type == ITEM_SUBWEAPON) {
				pcSubweapon = d;
			} else if (type == ITEM_RING) {
				if (IS_TRUE(d & ITEM_EQUIP_LEFT)) {
					pcRing[PC_RING_LEFT] = d;
				} else {
					pcRing[PC_RING_RIGHT] = d;
				}
			}
		}
	}

	healInterval = 0;

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private static char randChar() {
	char ret = CHAR_NOTHING;
FUNCTION_CALLED("randChar()");
FUNCTION_PRINT("call " +functionName);

	if (randRandom(3) == 0) {
		ret = charItem[randRandom(ITEM_OBJECT_COUNT)];
	} else {
		ret = (char)monsterCatalog[randRandom(MONSTER_KIND_COUNT)][MCATALOG_CHAR];
	}

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}
