/*
 * This source herein may be modified and/or distributed by anybody who
 * so desires, with the following restrictions:
 *    1.)  No portion of this notice shall be removed.
 *    2.)  Credit shall not be taken for the creation of this source.
 *    3.)  This code is not to be traded, sold, or used for personal
 *         gain or profit.
 */

private void newFloor() {
FUNCTION_CALLED("newFloor()");
FUNCTION_PRINT("call " +functionName);

	boolean amulet = hasObjectType(ITEM_AMULET);
	if (!trapDoor && amulet) {
		curFloor--;
		if (curFloor <= 0) {
			//win
			pcKilledBy = MAX_DEATH_COUNT;
			gameover(false);
		}
	} else {
		curFloor++;
		if (curFloor > FLOOR_LAST) {
			curFloor = FLOOR_LAST;
		}
	}
	if (trapDoor) {
#ifdef JP
		message("̊KɗĂ܂B");
#else
		message("fallen to the next floor.");
#endif
		trapDoor = false;
	}
	stateDraw();
	if (curFloor > maxFloor) {
		maxFloor = curFloor;
	}
	makeFloor();
	setObjects(amulet);
	setTraps();
	if (curFloor >= FLOOR_AMULET && !amulet) {
		putObject(ITEM_AMULET);
	}
	setPlayerAndMonsters();
	setStair();
	pcMoved(pcCol, pcRow, false, false);
	movedPlayer = true;
	mode = MODE_GAME;
	turnCount = TURN_END;
	nextTurn();

DEBUG_FLOOR_PRINT();
FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void makeFloor() {
FUNCTION_CALLED("makeFloor()");
FUNCTION_PRINT("call " +functionName);

//floor init
	detectMonsters = false;
	movedPlayer = false;

	int x,y;
	for (y=0; y < DUNGEON_ROWS; y++) {
		for (x=0; x < DUNGEON_COLS; x++) {
			dungeon[y][x] = MAP_NOTHING;
			screenBuf[y][x] = CHAR_NOTHING;
		}
	}
	for (y=0; y < MAX_ROOM_COUNT; y++) {
		room[y][ROOM_FLAG] = ROOM_NOTHING;
		room[y][ROOM_RECT] = 0;
		for (x=ROOM_DOOR1; x <= ROOM_DOOR4; x++) {
			room[y][x] = ROOM_NODOOR;
		}
	}

	//0 is a missing number. uses for management of count
	monsterList[0][0] = 0;
	itemList[0] = 0;
	for (x=1; x < MAX_MONSTER_COUNT; x++) {
		monsterList[x][MLIST_IS_MONSTER] = MONSTER_KIND_COUNT;
	}
	for (x=1; x < MAX_ITEM_COUNT; x++) {
		itemList[x] = ITEM_NONE;
	}


//make room
if (randPermil(3)) {
	//big room
	room[0][ROOM_FLAG] = ROOM_ROOM | ROOM_MONSTER;
	makeRoom(0, randRandom(8), randRandom(6), DUNGEON_COLS -randRandom(8) -1, DUNGEON_ROWS -randRandom(6) -1);
	int leftCol = GET_RECT_LEFT_COL(0);
	int topRow = GET_RECT_TOP_ROW(0);
	int width = GET_RECT_RIGHT_COL(0) - leftCol -1;
	int height = GET_RECT_BOTTOM_ROW(0) - topRow -1;
	leftCol++;
	topRow++;
	//add trap and item
	int n = width * height / 50;
	int col,row;
	for (int i=0; i<n; i++) {
		do {
			col = randRandom(width) +leftCol;
			row = randRandom(height) +topRow;
		} while ((dungeon[row][col] & (MAP_OBJECT | MAP_ITEM_FLAG)) != MAP_FLOOR);
		if (randBool()) {
			int type = randRandom(MAP_TRAP_OBJECT_COUNT)+1;
			dungeon[row][col] |= (MAP_FLAG_TRAP | (type<<20));
		} else {
			dropObject(col, row, randObject());
		}
	}
} else {
	//room No.
	//012
	//345
	//678
	int room1, room2, room3;//must be exist

	room1 = randRandom(3);
	if (randBool()) {
		//vertical
		room2 = room1 + 3;
		room3 = room2 + 3;
	} else {
		//horizon
		room1 = room1 * 3;
		room2 = room1 + 1;
		room3 = room2 + 1;
	}

	//reservation
	int no;
	for (no = 0; no < MAX_ROOM_COUNT; no++) {
		if (randPercent(40)) room[no][ROOM_FLAG] = ROOM_ROOM;
	}
	room[room1][ROOM_FLAG] = ROOM_ROOM;
	room[room2][ROOM_FLAG] = ROOM_ROOM;
	room[room3][ROOM_FLAG] = ROOM_ROOM;

	//make
	int dp3x=DUNGEON_COLS/3;
	int dp3y=DUNGEON_ROWS/3;
	int col, row;
	int height, width;
	no=0;
	for (y=0; y<3; y++) {
		for (x=0; x<3; x++) {
			if (room[no][ROOM_FLAG] == ROOM_ROOM) {
				width	= randRandom(dp3x/4*3-6)+6;
				height	= randRandom(dp3y/3*2-4)+4;
				col = dp3x*x +randRandom(dp3x-width) +x;
				row = dp3y*y +randRandom(dp3y-height) +y;
				makeRoom(no, col, row, col +width, row +height);
			}
			no++;
		}
	}

//DEBUG_FLOOR_PRINT();
	//connect
	makeMaze();

}

//DEBUG_FLOOR_PRINT();
FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

#ifdef DEBUG
private static void debugPrintFloor() {
FUNCTION_CALLED("debugPrintFloor()");
	System.out.println("call debugPrintFloor()");
	String d;
	int x,y;
#if defined(HANKAKU) || !defined(JP)
	System.out.println("01234567890123456789012345678901234567890123456789");
#else
	System.out.println("OPQRSTUVWXOPQRSTUVWXOPQRSTUVWXOPQRSTUVWXOPQRSTUVWX");
#endif
	for (y=0; y < DUNGEON_ROWS; y++) {
		d = "";
		for (x=0; x < DUNGEON_COLS; x++) {
			if (IS_TRUE(dungeon[y][x] & MAP_MONSTER_FLAG)) {
				d += CHARMOB_DD(dungeon[y][x]);
			} else 
			if (IS_TRUE(dungeon[y][x] & MAP_ITEM_FLAG)) {
				d += CHARITEM_DD(dungeon[y][x]);
			} else 
			if (IS_TRUE(dungeon[y][x] & MAP_HIDE_FLAG)) {
				d += CHARMAPFOUND(dungeon[y][x]);
			} else {
				d += CHARMAP(dungeon[y][x]);
			}
		}
		System.out.println(d+":"+y);
	}
#if defined(HANKAKU) || !defined(JP)
	System.out.println("01234567890123456789012345678901234567890123456789");
#else
	System.out.println("OPQRSTUVWXOPQRSTUVWXOPQRSTUVWXOPQRSTUVWXOPQRSTUVWX");
#endif
	System.out.println("return debugPrintFloor()");
FUNCTION_RETURN();
}
#endif

private static void setStair() {
FUNCTION_CALLED("setStair()");
FUNCTION_PRINT("call " +functionName);

	randRoomPlace(MAP_HIDE_FLAG | MAP_ITEM_FLAG);
	stairsCol = tempCol;
	stairsRow = tempRow;
	dungeon[stairsRow][stairsCol] &= (~(MAP_OBJECT));
	dungeon[stairsRow][stairsCol] |= MAP_STAIRS;

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private char mapFlag2char(int dd) {
	char ret;
	if (IS_TRUE(dd & MAP_HIDE_FLAG)) {
		if (IS_TRUE(dd & MAP_FLAG_FOUND)) {
			ret = CHARMAPFOUND(dd);
		} else {
			ret = CHARMAPHIDE(dd);
		}
	} else {
		ret = CHARMAP(dd);
	}
	return ret;
}
