/*
 * This source herein may be modified and/or distributed by anybody who
 * so desires, with the following restrictions:
 *    1.)  No portion of this notice shall be removed.
 *    2.)  Credit shall not be taken for the creation of this source.
 *    3.)  This code is not to be traded, sold, or used for personal
 *         gain or profit.
 */

private void playersAttack(int monster, boolean forceHit) {
FUNCTION_CALLED("playersAttack(" +monster +", " +forceHit +")");
FUNCTION_PRINT("call " +functionName);

	WARLIKEMONSTER(monster);

	if (forceHit) {
#ifdef JP
		message("@̖B");
#else
		message("the magic missile hit.");
#endif
		monsterList[monster][MLIST_TARGET_COL] = pcCol;
		monsterList[monster][MLIST_TARGET_ROW] = pcRow;
		monsterDamage(monster, damagePlayersAttack(pcWeapon));
	} else {
		int chance = (forceHit)? 100: getHitChance(pcWeapon);
		if (randPercent(chance)) {
#ifdef JP
			message(pcName +"̍UB");
#else
			message(pcName +" hit.");
#endif
			monsterDamage(monster, damagePlayersAttack(pcWeapon));
		} else {
#ifdef JP
			message(pcName +"̍U͂ꂽB");
#else
			message(pcName +" miss.");
#endif
		}
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void fireAttack(int monster, int object) {
FUNCTION_CALLED("fireAttack(" +monster +", " +object +")");
FUNCTION_PRINT("call " +functionName);

	WARLIKEMONSTER(monster);
	monsterList[monster][MLIST_TARGET_COL] = pcCol;
	monsterList[monster][MLIST_TARGET_ROW] = pcRow;

	int mflag = monsterList[monster][MLIST_FLAG];
	int chance = getHitChance(object);
	if (randPercent(chance)) {
#ifdef JP
		message(getObjectName(object, false) +"͖B");
#else
		message(getObjectName(object, false) +" hit.");
#endif
		int type = object & ITEM_TYPE_FLAG;
		int subtype = (object & ITEM_SUBTYPE_FLAG) >> 8;
		if (type == ITEM_RING) {
			if (subtype == RING_STEALTH) {
				mflag |= MFLAG_INVISIBLE;
			} else if (subtype == RING_TELEPORT) {
				teleportAway(monster);
			} else if (subtype == RING_REGENERATION) {
				monsterList[monster][MLIST_HP] = monsterCatalog[monsterList[monster][MLIST_IS_MONSTER]][MCATALOG_HP];
			} else if (subtype == RING_SLOW_DIGEST) {
				mflag |= MFLAG_SLOWED;
			} else if (subtype == RING_STRENGTH) {
				mflag |= MFLAG_HASTED;
			} else if (subtype == RING_SUSTAIN_STRENGTH) {
				mflag |= MFLAG_STATIONARY;
			} else if (subtype == RING_DEXTERITY) {
				mflag |= MFLAG_FLIES;
			} else if (subtype == RING_ADORNMENT) {
				mflag &= (~(MFLAG_INVISIBLE | MFLAG_STEALS_GOLD | MFLAG_STEALS_ITEM | MFLAG_SEEKS_GOLD));
			} else if (subtype == RING_SEE_INVISIBLE) {
				mflag &= (~(MFLAG_INVISIBLE));
				mflag |= MFLAG_CONFUSED;
			} else if (subtype == RING_MAINTAIN_ITEM) {
				mflag &= (~(MFLAG_RUSTS));
			} else if (subtype == RING_SEARCHING) {
				mflag &= (~(MFLAG_INVISIBLE | MFLAG_FLITS));
			}
		} else if (type == ITEM_SCROLL) {
			if (subtype == SCROLL_PROTECT_ARMOR) {
				mflag &= (~(MFLAG_RUSTS));
			} else if (subtype == SCROLL_HOLD_MONSTER) {
				monsterList[monster][MLIST_FLAG] = 0;
				sleepMonster(monster);
				mflag = monsterList[monster][MLIST_FLAG];
			} else if (subtype == SCROLL_ENCH_WEAPON) {
				mflag |= MFLAG_HASTED;
			} else if (subtype == SCROLL_ENCH_ARMOR) {
				mflag &= (~(MFLAG_RUSTS));
			} else if (subtype == SCROLL_IDENTIFY) {
				;
			} else if (subtype == SCROLL_TELEPORT) {
				teleportAway(monster);
			} else if (subtype == SCROLL_SLEEP) {
				sleepMonster(monster);
				mflag = monsterList[monster][MLIST_FLAG];
			} else if (subtype == SCROLL_SCARE_MONSTER) {
				mflag |= (MFLAG_FLITS | MFLAG_CONFUSED);
				mflag &= (~(MFLAG_STATIONARY));
			} else if (subtype == SCROLL_REMOVE_CURSE) {
				mflag = 0;
			} else if (subtype == SCROLL_CREATE_MONSTER) {
				changeMonster(monster);
			} else if (subtype == SCROLL_AGGRAVATE_MONSTER) {
				mflag &= (~(MFLAG_ASLEEP | MFLAG_FLITS | MFLAG_SPECIAL_HIT | MFLAG_SEEKS_GOLD | MFLAG_CONFUSES | MFLAG_FLAMES | MFLAG_STATIONARY));
			} else if (subtype == SCROLL_MAGIC_MAPPING) {
				mflag &= (~(MFLAG_FLITS));
			}
		} else if (type == ITEM_POTION) {
			if (subtype == POTION_INCREASE_STRENGTH) {
			} else if (subtype == POTION_RESTORE_STRENGTH) {
				monsterList[monster][MLIST_FLAG] = monsterCatalog[monsterList[monster][MLIST_IS_MONSTER]][MCATALOG_FLAG];
			} else if (subtype == POTION_HEALING) {
				int maxhp = monsterCatalog[monsterList[monster][MLIST_IS_MONSTER]][MCATALOG_HP];
				monsterList[monster][MLIST_HP] += maxhp *33 /100;
				if (monsterList[monster][MLIST_HP] > maxhp) {
					monsterList[monster][MLIST_HP] = maxhp;
				}
			} else if (subtype == POTION_EXTRA_HEALING) {
				monsterList[monster][MLIST_HP] = monsterCatalog[monsterList[monster][MLIST_IS_MONSTER]][MCATALOG_HP];
			} else if (subtype == POTION_POISON) {
				mflag |= MFLAG_SLOWED;
				monsterList[monster][MLIST_HP] -= 5;
			} else if (subtype == POTION_RAISE_LEVEL) {
				monsterList[monster][MLIST_FLAG] = monsterCatalog[monsterList[monster][MLIST_IS_MONSTER]][MCATALOG_FLAG];
				monsterList[monster][MLIST_HP] += 10;
			} else if (subtype == POTION_BLINDNESS) {
				mflag &= (~(MFLAG_INVISIBLE | MFLAG_CONFUSES | MFLAG_FLAMES));
				mflag |= (MFLAG_FLITS | MFLAG_CONFUSED);
			} else if (subtype == POTION_HALLUCINATION) {
				mflag &= (~(MFLAG_INVISIBLE | MFLAG_CONFUSES | MFLAG_FLAMES));
				mflag |= (MFLAG_FLITS | MFLAG_CONFUSED);
			} else if (subtype == POTION_DETECT_MONSTER) {
				;
			} else if (subtype == POTION_DETECT_OBJECTS) {
				;
			} else if (subtype == POTION_CONFUSION) {
				mflag &= (~(MFLAG_INVISIBLE | MFLAG_CONFUSES | MFLAG_FLAMES));
				mflag |= (MFLAG_FLITS | MFLAG_CONFUSED);
			} else if (subtype == POTION_LEVITATION) {
				mflag &= (~(MFLAG_STATIONARY));
				mflag |= MFLAG_FLIES;
			} else if (subtype == POTION_HASTE_SELF) {
				mflag |= MFLAG_HASTED;
			} else if (subtype == POTION_SEE_INVISIBLE) {
				;
			}
		} else if (type == ITEM_WAND) {
			zappedMonster(monster, subtype);
			mflag = monsterList[monster][MLIST_FLAG];
		} else {
			monsterDamage(monster, damagePlayersAttack(object));
		}
		monsterList[monster][MLIST_FLAG] = mflag;
	} else {
		int col = monsterList[monster][MLIST_COL];
		int row = monsterList[monster][MLIST_ROW];
		dropObject(col, row, object);
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void monstersAttack(int monster, boolean flame) {
FUNCTION_CALLED("monstersAttack(" +monster +", " +flame +")");
FUNCTION_PRINT("call " +functionName);

	int mkind = monsterList[monster][MLIST_IS_MONSTER];
	int mflag = monsterList[monster][MLIST_FLAG];
	int damage, hitChance;
	int minus;

	if (IS_TRUE(mflag & MFLAG_GETAWAY)) {
		teleportAway(monster);
#ifdef JP
		message("ǂڂ͂I");
#else
		message("the thief disappeared!");
#endif
		return;
	}

	if (curFloor >= (FLOOR_AMULET * 2)) {
		hitChance = 100;
	} else {
		hitChance = monsterCatalog[mkind][MCATALOG_CHANCE];
		hitChance -= 2 * (pcLevel + getRingPower(RING_DEXTERITY)*2);
	}

	String mname = strMonster[mkind];
	if (randPercent(hitChance)) {
		if (IS_FALSE(mflag & MFLAG_STATIONARY)) {
			int dice = monsterCatalog[mkind][MCATALOG_DAMAGE];
			damage = randDice(dice & 0xffff);
			damage += randDice(dice>>>16);
			if (flame) {
				damage -= getPlayerAC();
				if (damage < 0) {
					damage = 1;
				}
#ifdef JP
				message(DEATH26_DRAGONBREATH +"󂯂B");
#else
				message(DEATH26_DRAGONBREATH +" hit you.");
#endif
			} else {
				if ( (detectMonsters && IS_TRUE(pcState[STATE_BLINDNESS])) || IS_TRUE(pcState[STATE_HALLUCINATION]) ) {
#ifdef JP
					message(NAME_MONSTER_UK+"̍UB");
#else
					message(NAME_MONSTER_UK+" hit.");
#endif
				} else {
#ifdef JP
					message(mname +"̍UB");
#else
					message("the " +mname +" hit.");
#endif
				}
				pcKilledBy = mkind;
			}
			if (curFloor >= (FLOOR_AMULET * 2)) {
				minus = (FLOOR_AMULET * 2) - curFloor;
			} else {
				minus = getPlayerAC() * 3;
				minus = minus * damage / 100;
			}
			damage -= minus;
		} else {
			pcKilledBy = mkind;
			damage = randRandom(pcCurHP/4)+1;
		}
		if (damage > 0) {
			pcDamage(damage);
		}
		if (IS_TRUE(mflag & MFLAG_SPECIAL_HIT)) {
			specialHit(monster);
		}
	} else {
		if (IS_TRUE(pcState[STATE_BLINDNESS]) || IS_TRUE(pcState[STATE_HALLUCINATION])) {
#ifdef JP
			message(NAME_MONSTER_UK +"̍U͂ꂽB");
#else
			message(NAME_MONSTER_UK +" misses.");
#endif
		} else {
#ifdef JP
			message(mname +"̍U͂ꂽB");
#else
			message("the " +mname +" misses.");
#endif
		}
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private static int getHitChance(int object) {
	int ret = 0;
FUNCTION_CALLED("getHitChance(" +object +")");
FUNCTION_PRINT("call " +functionName);

	ret = 40 +pcLevel * 2;
	ret += getRingPower(RING_DEXTERITY) * 3;
	int type = object & ITEM_TYPE_FLAG;
	if (type == ITEM_WEAPON) {
		ret += ((object & 0xff)-3) * 3;
	} else if (type == ITEM_SUBWEAPON) {
		ret += 18;
	}

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

private void monsterDamage(int monster, int damage) {
FUNCTION_CALLED("monsterDamage(" +monster +", " +damage +")");
FUNCTION_PRINT("call " +functionName);

	monsterList[monster][MLIST_HP] -= damage;

	if (monsterList[monster][MLIST_HP] <= 0) {
		monsterList[0][0]--;
		int kind = monsterList[monster][MLIST_IS_MONSTER];
		if (IS_TRUE(monsterList[monster][MLIST_FLAG] & MFLAG_HOLDS)) {
			pcState[STATE_BEING_HELD] = 0;
		}
		int row = monsterList[monster][MLIST_ROW];
		int col = monsterList[monster][MLIST_COL];

		int object = monsterList[monster][MLIST_CARRY];
		if (object == 0) {
			if (randPercent(monsterCatalog[kind][MCATALOG_DROP])) {
				object = randObject();
			}
		}
		if (object != 0) {
			dropObject(col, row, object);
		}

		dungeon[row][col] &= (~MAP_MONSTER_FLAG);
		monsterList[monster][MLIST_IS_MONSTER] = MONSTER_KIND_COUNT;
		viewDraw();
		if (IS_TRUE(pcState[STATE_BLINDNESS]) || IS_TRUE(pcState[STATE_HALLUCINATION])) {
#ifdef JP
			message(NAME_MONSTER_UK +"B");
#else
			message("defeated " +NAME_MONSTER_UK +".");
#endif
		} else {
#ifdef JP
			message(strMonster[kind] +"B");
#else
			message("defeated the " +strMonster[kind] +".");
#endif
		}
		gainExp(monsterCatalog[kind][MCATALOG_EXP]);
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void specialHit(int monster) {
FUNCTION_CALLED("specialHit(" +monster +")");
FUNCTION_PRINT("call " +functionName);

	int mflag = monsterList[monster][MLIST_FLAG];
	if (IS_TRUE(mflag & MFLAG_CONFUSED) && randPercent(66)) {
		return;
	}
	int kind = monsterList[monster][MLIST_IS_MONSTER];
	if (IS_TRUE(mflag & MFLAG_RUSTS)) {
		pcRust();
	}
	if (IS_TRUE(mflag & MFLAG_HOLDS) && (pcState[STATE_LEVITATE] <= 0)) {
		pcState[STATE_BEING_HELD] += randRandom(4)+4;
#ifdef JP
		message(strMonster[kind] +"ɂ݂ꂽB");
#else
		message("bound by the" +strMonster[kind] +".");
#endif
		more();
	}
	if (IS_TRUE(mflag & MFLAG_FREEZES)) {
		pcFreeze(true);
		if (pcState[STATE_FREEZING] > 0) {
#ifdef JP
			message("Ă܂B");
#else
			message("you are frozen.");
#endif
			more();
		}
	}
	if (IS_TRUE(mflag & MFLAG_STINGS)) {
		int chance = 35;
		chance += (6 * (6 - getPlayerAC()));
		chance -= (6 * ((pcLevel + getRingPower(RING_DEXTERITY)*2) - 8));
		if (chance < 1) chance = 1;
		if (randPercent(chance)) {
			pcPoison(true);
		}
	}
	if (IS_TRUE(mflag & MFLAG_DRAINS_LIFE)) {
		drainLife();
	}
	if (IS_TRUE(mflag & MFLAG_DROPS_LEVEL)) {
		dropLevel();
	}
	if (IS_TRUE(mflag & MFLAG_STEALS_GOLD)) {
		stealGold(monster);
	} else if (IS_TRUE(mflag & MFLAG_STEALS_ITEM)) {
		stealItem(monster);
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void pcDamage(int damage) {
FUNCTION_CALLED("pcDamage(" +damage +")");
FUNCTION_PRINT("call " +functionName);

	pcCurHP -= damage;
	stateDraw();
	if (pcCurHP < 0) {
		gameover(true);
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private static String epitaph[] = {
#ifdef JP
	//12345678901234567890
/*1*/"      ______________",
/*2*/"     /",
/*3*/"    /     R.I.P",
/*4*/"   /",
/*5*/"  |",
//      |   悯",
/*6*/"  |",//nHK
/*7*/"  |",//X^[
/*8*/"  |       ɓ|",
/*9*/" *|     *  *  *",
/*0*/"_)/\\\\_//(\\/(/\\)/\\//_",
#else
	//12345678901234567890
/*1*/"      ______________",
/*2*/"     /",
/*3*/"    /     R.I.P",
//   "   /       with",
//      |     the amuret.",
/*4*/"   /",
/*5*/"  |",
/*6*/"  |     killed by",
/*7*/"  |",// monster
/*8*/"  |",  //on the ??F
/*9*/" *|     *  *  *",
/*0*/"_)/\\\\_//(\\/(/\\)/\\//_",
#endif
};
private static String strwin[] = {
#ifdef JP
    //12345678901234567890
/*1*/"       I",
/*2*/"N͑ž̂Ƃ",
/*3*/"ǂ^̓A",
/*4*/"琶Ė߂E",
/*5*/"̈lƂȂB",
/*6*/"N͌̋֋AA",
/*7*/"A󕨂𔄂",
/*8*/"ɓAꂩ",
/*9*/"͕ɗVѕ炵",
/*0*/"ƂƂłcB",
#else
    //12345678901234567890
/*1*/"Congratulations!",
/*2*/"",
/*3*/" You have been",
/*4*/"admitted to the",
/*5*/"Fighters' Guild.",
/*6*/" You return home,",
/*7*/"sell all your",
/*8*/"treasures at great",
/*9*/"profit and retire",
/*0*/"into comfort.",
#endif
};

private void drawEpitaph(boolean dead) {
FUNCTION_CALLED("drawEpitaph(" +dead +")");
FUNCTION_PRINT("call " +functionName);

	offGraphics.setColor(COLOR_BLACK);
	offGraphics.fillRect(0, 0, offImage.getWidth(), offImage.getHeight());
	offGraphics.setColor(COLOR_WHITE);

	if (dead) {
		int length = epitaph.length;
		int i;
		for (i=0; i<length; i++) {
			offGraphics.DRAWSTRING(epitaph[i], 0, fontHeight*(i+1));
		}
		if (hasObjectType(ITEM_AMULET)) {
#ifdef JP
#ifdef HANKAKU
			offGraphics.DRAWSTRING(NAME_OF_AMULET +"", fontWidth*7, fontHeight*5);
#else
			offGraphics.DRAWSTRING(NAME_OF_AMULET +"", fontWidth*3, fontHeight*5);
#endif
#else
			offGraphics.DRAWSTRING("with", fontWidth*11, fontHeight*4);
			offGraphics.DRAWSTRING("the amuret.", fontWidth*8, fontHeight*5);
#endif
		}
#ifdef JP
#ifdef HANKAKU
		offGraphics.DRAWSTRING("n"+curFloor+"K", fontWidth*9, fontHeight*6);
#else
		offGraphics.DRAWSTRING("n"+curFloor+"K", fontWidth*5, fontHeight*6);
#endif
#else
		offGraphics.DRAWSTRING("on the "+curFloor+"F", fontWidth*9, fontHeight*8);
#endif
#ifdef JP
#ifdef HANKAKU
		offGraphics.DRAWSTRING(getKilledBy(pcKilledBy), fontWidth*8, fontHeight*7);
#else
		offGraphics.DRAWSTRING(getKilledBy(pcKilledBy), fontWidth*4, fontHeight*7);
#endif
#else
		offGraphics.DRAWSTRING(getKilledBy(pcKilledBy), fontWidth*8, fontHeight*7);
#endif
	} else {
		int length = strwin.length;
		int i;
		for (i=0; i<length; i++) {
			offGraphics.DRAWSTRING(strwin[i], 0, fontHeight*(i+1));
		}
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private String getKilledBy(int killedNum) {
	String ret = "bug";
FUNCTION_CALLED("getKilledBy(" +killedNum +")");
FUNCTION_PRINT("call " +functionName);

	if (killedNum < MONSTER_KIND_COUNT) {
		ret = strMonster[killedNum];
	} else if (killedNum == 26) {
		ret = DEATH26_DRAGONBREATH;
	} else if (killedNum == 27) {
		ret = DEATH27_TRAPDOOR;
	} else if (killedNum == 28) {
		ret = DEATH28_TRAPDART;
	} else if (killedNum == 29) {
		ret = DEATH29_HUNGER;
	} else if (killedNum == 30) {
		ret = DEATH30_BEINGHELD;
	} else if (killedNum == 31) {
		ret = DEATH31_FREEZING;
	} else if (killedNum == 32) {
		ret = DEATH32_BLINDNESS;
	} else if (killedNum == 33) {
		ret = DEATH33_HALLUCINATION;
	} else if (killedNum == 34) {
		ret = DEATH34_CONFUSED;
	} else if (killedNum == 35) {
		ret = DEATH35_BEARTRAP;
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
	return ret;
}

#define SCORE_PLAY_COUNT_INDEX	0
#define SCORE_WIN_COUNT_INDEX	1
#define SCORE_WIN_FLOOR_INDEX	2
#define SCORE_MAX_FLOOR_INDEX	3
#define SCORE_MAX_GOLD_INDEX	4

private void drawScore() {
FUNCTION_CALLED("drawScore()");
FUNCTION_PRINT("call " +functionName);

	offGraphics.setColor(COLOR_BLACK);
	offGraphics.fillRect(0, 0, offImage.getWidth(), offImage.getHeight());
	offGraphics.setColor(COLOR_WHITE);

#ifdef JP
	offGraphics.DRAWSTRING("`: " +score[SCORE_PLAY_COUNT_INDEX], 0, fontHeight);
	offGraphics.DRAWSTRING("҉: " +score[SCORE_WIN_COUNT_INDEX], 0, fontHeight*2);
	offGraphics.DRAWSTRING("ŐҊK: " +score[SCORE_WIN_FLOOR_INDEX], 0, fontHeight*3);
	offGraphics.DRAWSTRING("œBK: " +score[SCORE_MAX_FLOOR_INDEX], 0, fontHeight*4);
	offGraphics.DRAWSTRING("ŏ: " +score[SCORE_MAX_GOLD_INDEX], 0, fontHeight*5);
	offGraphics.DRAWSTRING("G", 0, fontHeight*7);
#else
	offGraphics.DRAWSTRING("play: " +score[SCORE_PLAY_COUNT_INDEX], 0, fontHeight);
	offGraphics.DRAWSTRING("win: " +score[SCORE_WIN_COUNT_INDEX], 0, fontHeight*2);
	offGraphics.DRAWSTRING("windeapth: " +score[SCORE_WIN_FLOOR_INDEX], 0, fontHeight*3);
	offGraphics.DRAWSTRING("maxdeapth: " +score[SCORE_MAX_FLOOR_INDEX], 0, fontHeight*4);
	offGraphics.DRAWSTRING("maxgold: " +score[SCORE_MAX_GOLD_INDEX], 0, fontHeight*5);
	offGraphics.DRAWSTRING("the foe", 0, fontHeight*7);
#endif

	int[] rank = new int[MAX_DEATH_COUNT];
	int i,j;
	for (i=0; i<MAX_DEATH_COUNT; i++) {
		rank[i] = i;
	}
	for (i=0; i<3; i++) {
		int index = i;
		int count = death[rank[index]];
		for (j=i+1; j<MAX_DEATH_COUNT; j++) {
			if (death[rank[j]] > count) {
				index = j;
				count = death[rank[index]];
			}
		}
		count = rank[index];
		rank[index] = rank[i];
		rank[i] = count;
		offGraphics.DRAWSTRING(getKilledBy(count) +": "+death[count], 0, fontHeight*(8+i));
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void gameover(boolean dead) {
FUNCTION_CALLED("gameover(" +dead +")");
FUNCTION_PRINT("call " +functionName);

//#ifdef WIZARD
#if 0
	if (true) return;
#endif

	mode = MODE_GAMEOVER;
	score[SCORE_PLAY_COUNT_INDEX]++;
	if (dead) {
		death[pcKilledBy]++;
		if (pcState[STATE_BEING_HELD] > 0) {
			death[30]++;
		} else if (pcState[STATE_FREEZING] > 0) {
			death[31]++;
		} else if (pcState[STATE_BLINDNESS] > 0) {
			death[32]++;
		} else if (pcState[STATE_HALLUCINATION] > 0) {
			death[33]++;
		} else if (pcState[STATE_CONFUSED] > 0) {
			death[34]++;
		} else if (pcState[STATE_BEAR_TRAP] > 0) {
			death[35]++;
		}
	} else {
		score[SCORE_WIN_COUNT_INDEX]++;
		if (score[SCORE_WIN_FLOOR_INDEX] < maxFloor) {
			score[SCORE_WIN_FLOOR_INDEX] = maxFloor;
		}
	}
	if (score[SCORE_MAX_FLOOR_INDEX] < maxFloor) {
		score[SCORE_MAX_FLOOR_INDEX] = maxFloor;
	}
	if (score[SCORE_MAX_GOLD_INDEX] < pcGold) {
		score[SCORE_MAX_GOLD_INDEX] = pcGold;
	}

	int tmp = curFloor;
	curFloor = 0;
	saveScore();
	curFloor = tmp;

	if (dead) {
#ifdef JP
		message(pcName+"͂ꂽB");
		message("悤ȂA"+pcName+"I");
#else
		message("goodbye, "+pcName+"!");
#endif
		more();
	}
	drawEpitaph(dead);
	REPAINT();
	keyWait();

	drawScore();
	REPAINT();
	keyWait();

	QUIT();

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private static int getPlayerAC() {
	int ac = 0;
FUNCTION_CALLED("getPlayerAC()");
FUNCTION_PRINT("call " +functionName);

	if (pcArmor != ITEM_NONE) {
		ac += GET_AC(pcArmor);
	}

FUNCTION_PRINT(functionName +" return " +ac);
FUNCTION_RETURN();
	return ac;
}

private static int diceWepon[] = {
	0x0104,//1d4
	0x0105,//1d5
	0x0106,//1d6

	0x0203,//2d3
	0x0304,//3d4
	0x0405,//4d5
};

private static int getDamageDice(int object) {
	int dd=0;
FUNCTION_CALLED("getDamageDice(" +object +")");
FUNCTION_PRINT("call " +functionName);

	//1d1
	int hit = 1;
	int dice = 1;
	int type = object & ITEM_TYPE_FLAG;
	int enc;
	if ((type == ITEM_WEAPON) || (type == ITEM_SUBWEAPON)) {
		dd = diceWepon[(object & ITEM_SUBTYPE_FLAG) >> 8];
		enc = (object & 0xff) -3;
		hit = ((dd & 0xff00) >> 8) +enc;
		dice = (dd & 0xff) +enc;
		if (hit < 1) hit = 1;
		if (dice < 1) dice = 1;
	} else if (type == ITEM_ARMOR) {
		dice = (object & 0xff) / 2;
		dice++;
	}
	dd = (hit << 8) | dice;

FUNCTION_PRINT(functionName +" return " +dd);
FUNCTION_RETURN();
	return dd;
}

private static int damagePlayersAttack(int object) {
	int damage = 0;
FUNCTION_CALLED("damagePlayersAttack(" +object +")");
FUNCTION_PRINT("call " +functionName);

	damage = pcLevel+1;
	damage += getRingPower(RING_DEXTERITY) * 2;
	damage /= 2;
	damage += randDice(getDamageDice(object));
	damage += damageStrength();

FUNCTION_PRINT(functionName +" return " +damage);
FUNCTION_RETURN();
	return damage;
}

private static int damageStrength() {
	int damage=0;
FUNCTION_CALLED("damageStrength()");
FUNCTION_PRINT("call " +functionName);

	int strength = pcCurSTR +getRingPower(RING_STRENGTH);
	if (strength <= 6) {
		damage = strength -5;
	} else if (strength <= 14) {
		damage = 1;
	} else if (strength <= 17) {
		damage = 3;
	} else if (strength <= 18) {
		damage = 4;
	} else if (strength <= 20) {
		damage = 5;
	} else if (strength <= 21) {
		damage = 6;
	} else if (strength <= 30) {
		damage = 7;
	} else {
		damage = 8;
	}

FUNCTION_PRINT(functionName +" return " +damage);
FUNCTION_RETURN();
	return damage;
}
