/*
 * This source herein may be modified and/or distributed by anybody who
 * so desires, with the following restrictions:
 *    1.)  No portion of this notice shall be removed.
 *    2.)  Credit shall not be taken for the creation of this source.
 *    3.)  This code is not to be traded, sold, or used for personal
 *         gain or profit.
 */

private static void pcConfuse() {
FUNCTION_CALLED("confuse()");
FUNCTION_PRINT("call " +functionName);

	pcState[STATE_CONFUSED] = randRandom(11)+12;

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void pcTeleport() {
FUNCTION_CALLED("pcTeleport()");
FUNCTION_PRINT("call " +functionName);

	pcRoomNum = randRoomPlace(MAP_MONSTER_FLAG);
	int col = tempCol;
	int row = tempRow;
	pcMoved(col, row, false, false);
	pcState[STATE_BEING_HELD] = 0;
	pcState[STATE_BEAR_TRAP] = 0;
	viewDraw();
#ifdef JP
	message("e|[gĂ܂I");
#else
	message("teleport!");
#endif

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void teleportAway(int monster) {
FUNCTION_CALLED("teleportAway(" +monster +")");
FUNCTION_PRINT("call " +functionName);

	randRoomPlace(MAP_MONSTER_FLAG);
	int col = monsterList[monster][MLIST_COL];
	int row = monsterList[monster][MLIST_ROW];
	dungeon[row][col] &= (~MAP_MONSTER_FLAG);
	col = tempCol;
	row = tempRow;
	monsterList[monster][MLIST_COL] = col;
	monsterList[monster][MLIST_ROW] = row;
	monsterList[monster][MLIST_TARGET_COL] = col;
	monsterList[monster][MLIST_TARGET_ROW] = row;
	monsterList[monster][MLIST_PRE_COL] = col;
	monsterList[monster][MLIST_PRE_ROW] = row;
	monsterList[monster][MLIST_PRE_DIR] = 5;
	monsterList[monster][MLIST_STUCK] = 0;
	dungeon[row][col] |= monster;
	if (monsterCanSeePC(col, row) && IS_FALSE(monsterList[monster][MLIST_FLAG] & MFLAG_GETAWAY)) {
		monsterList[monster][MLIST_TARGET_COL] = pcCol;
		monsterList[monster][MLIST_TARGET_ROW] = pcRow;
	}
	viewDraw();
	REDRAW();

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void pcPoison(boolean addDamage) {
FUNCTION_CALLED("pcPoison(" +addDamage +")");
FUNCTION_PRINT("call " +functionName);

	if (getRingPower(RING_SUSTAIN_STRENGTH) != 0) return;
	if (addDamage) {
		pcDamage(randRandom(6)+1);
		pcCurSTR--;
	} else {
		pcCurSTR -= randRandom(3)+1;
	}
	more();
#ifdef JP
	message("炪Ă܂I");
#else
	message("weakened your strength.");
#endif
	if (pcCurSTR < 1) {
		pcCurSTR = 1;
	}
	unhallucinate();

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void pcFreeze(boolean addDamage) {
FUNCTION_CALLED("pcFreeze(" +addDamage +")");
FUNCTION_PRINT("call " +functionName);

	int t=0;
	if (addDamage) {
		if (pcState[STATE_FREEZING] == 0) {
			t = randRandom(3)+1;
			if (t==1) t=0;//remove recover message next turn
			pcDamage(6-t);
		} else if (pcState[STATE_FREEZING] > 0) {
			if (randBool()) t = 1;
			pcDamage(randRandom(4)+1-t);
		}
	} else {
		t = randRandom(6)+3;
	}
	pcState[STATE_FREEZING] += t;

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void pcRust() {
FUNCTION_CALLED("pcRust()");
FUNCTION_PRINT("call " +functionName);

	if (IS_FALSE(getRingPower(RING_MAINTAIN_ITEM))) {
		if (pcArmor != 0) {
			if (IS_FALSE(pcArmor & ITEM_PROTECT)) {
				int subtype = (pcArmor & ITEM_SUBTYPE_FLAG) >> 8;
				if (subtype != ARMOR_LEATHER) {
					int index = object2index(pcArmor);
					if ( (pcArmor & 0xff) != 0 ) {
						more();
#ifdef JP
						message(getObjectName(pcArmor,false) +"͂тĂ܂I");
#else
						message("your armor weakens.");
#endif
						pcArmor--;
						pcPack[index] = pcArmor;
					}
				}
			}
		}
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private int enchantObject(int object) {
	int ret = object;
FUNCTION_CALLED("enchantObject(" +object +")");
FUNCTION_PRINT("call " +functionName);

	more();
#ifdef JP
	message(getObjectName(ret,false) +"͐Pɕ܂ꂽB");
#else
	message("your " +getObjectName(ret,false) +" glows blue for a moment.");
#endif
	ret &= (~(ITEM_CURSED));
	if ((ret & 0xff) != (99+3)) {
		ret++;
	}

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

private void magicMap() {
FUNCTION_CALLED("magicMap()");
FUNCTION_PRINT("call " +functionName);

	int x,y;
	for (y=0; y < DUNGEON_ROWS; y++) {
		for (x=0; x < DUNGEON_COLS; x++) {
			dungeon[y][x] |= (MAP_FLAG_KNOWN | MAP_FLAG_FOUND);
			screenBuf[y][x] = mapFlag2char(dungeon[y][x]);
		}
	}
	viewDraw();

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void detectObjects() {
FUNCTION_CALLED("detectObjects()");
FUNCTION_PRINT("call " +functionName);

	int x,y;
	for (y=0; y < DUNGEON_ROWS; y++) {
		for (x=0; x < DUNGEON_COLS; x++) {
			if (IS_TRUE(dungeon[y][x] & MAP_ITEM_FLAG)) {
				dungeon[y][x] |= MAP_FLAG_KNOWN;
				screenBuf[y][x] = mapFlag2char(dungeon[y][x]);
			}
		}
	}
	viewDraw();

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private int identifyObject(int object) {
	int ret = object;
FUNCTION_CALLED("identifyObject(" +object +")");
FUNCTION_PRINT("call " +functionName);

	ret |= (ITEM_KNOWN | ITEM_IDENTIFY);
	int type = (ret & ITEM_TYPE_FLAG);
	int subtype = (ret & ITEM_SUBTYPE_FLAG) >> 8;
	if (type == ITEM_RING) {
		ringCatalog[subtype] |= ITEM_KNOWN;
		strRing[subtype] = strRingTrue[subtype];
	} else if (type == ITEM_SCROLL) {
		scrollCatalog[subtype] |= ITEM_KNOWN;
		strScroll[subtype] = strScrollTrue[subtype];
	} else if (type == ITEM_POTION) {
		potionCatalog[subtype] |= ITEM_KNOWN;
		strPotion[subtype] = strPotionTrue[subtype];
	} else if (type == ITEM_WAND) {
		wandCatalog[subtype] |= ITEM_KNOWN;
		strWand[subtype] = strWandTrue[subtype];
	}

FUNCTION_PRINT(functionName +" return " +ret);
FUNCTION_RETURN();
	return ret;
}

private void removeCurse() {
FUNCTION_CALLED("removeCurse()");
FUNCTION_PRINT("call " +functionName);

	int index,object;

	pcWeapon = removeCurseSub(pcWeapon);
	pcArmor = removeCurseSub(pcArmor);

	pcRing[PC_RING_RIGHT] = removeCurseSub(pcRing[PC_RING_RIGHT]);
	pcRing[PC_RING_LEFT] = removeCurseSub(pcRing[PC_RING_LEFT]);

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private int removeCurseSub(int object) {
	int ret = object;
FUNCTION_CALLED("removeCurseSub()");
FUNCTION_PRINT("call " +functionName);

	int index;
	int enc;
	if (ret != 0) {
		enc = (ret & 0xff)-3;
		enc = ABSINT(enc) +3;
		index = object2index(ret);
		ret &= (~(ITEM_CURSED | 0xff));
		ret += enc;
		pcPack[index] = ret;
	}

FUNCTION_PRINT(functionName +" return" +ret);
FUNCTION_RETURN();
	return ret;
}

private void aggravate(boolean power) {
FUNCTION_CALLED("aggravate(" +power +")");
FUNCTION_PRINT("call " +functionName);

	int flag = (~(MFLAG_ASLEEP | MFLAG_FLITS | MFLAG_SPECIAL_HIT | MFLAG_SEEKS_GOLD | MFLAG_CONFUSES | MFLAG_FLAMES | MFLAG_STATIONARY));
	if (power) {
		flag = (~(MFLAG_ASLEEP | MFLAG_SEEKS_GOLD | MFLAG_STATIONARY));
	}
	int i;
	for (i=1; i<MAX_MONSTER_COUNT; i++) {
		monsterList[i][MLIST_FLAG] &= flag;
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void holdMonster() {
FUNCTION_CALLED("holdMonster()");
FUNCTION_PRINT("call " +functionName);

	int x, y;
	int mcount = 0;
	int row, col;
	int index;
	int mflag;

	int no = getRoomNum(pcCol, pcRow, false);
	if (no != MAX_ROOM_COUNT) {
		int leftCol, topRow, rightCol, bottomRow;
		leftCol		= GET_RECT_LEFT_COL(no);
		topRow		= GET_RECT_TOP_ROW(no);
		rightCol	= GET_RECT_RIGHT_COL(no);
		bottomRow	= GET_RECT_BOTTOM_ROW(no);
		for (y=topRow; y <= bottomRow; y++) {
			for (x=leftCol; x <= rightCol; x++) {
				index = dungeon[y][x] & MAP_MONSTER_FLAG;
				if (index != 0) {
					mflag = monsterList[index][MLIST_FLAG];
					mflag |= MFLAG_ASLEEP;
					mflag &= (~(MFLAG_WAKENS));
					monsterList[index][MLIST_FLAG] = mflag;
					mcount++;
				}
			}
		}
	}

	for (y = -1; y <= 1; y++) {
		for (x = -1; x <= 1; x++) {
			index = dungeon[pcRow +y][pcCol +x] & MAP_MONSTER_FLAG;
			if (index != 0) {
				mflag = monsterList[index][MLIST_FLAG];
				mflag |= MFLAG_ASLEEP;
				mflag &= (~(MFLAG_WAKENS));
				monsterList[index][MLIST_FLAG] = mflag;
				mcount++;
			}
		}
	}

	if (mcount > 0) {
		more();
#ifdef JP
		message("܂͓̉ȂȂI");
#else
		message("the monsters around you freeze!");
#endif
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void potionHeal(boolean extra) {
FUNCTION_CALLED("potionHeal(" +extra +")");
FUNCTION_PRINT("call " +functionName);

	int ratio;
	int ex = (extra)? 2:1;

	ratio = pcCurHP * 100 / pcMaxHP;

	if (ratio >= 100) {
		pcMaxHP += ex;
		pcCurHP = pcMaxHP;
	} else if (ratio >= 90) {
		pcMaxHP += ex -1;
		pcCurHP = pcMaxHP;
	} else if (extra && (ratio <= 10)) {
		pcMaxHP += ex * 2;
		pcCurHP = pcMaxHP;
	} else {
		pcCurHP += pcLevel;
		if (ratio < 33) {
			ratio = 33;
		}
		if (extra) {
			ratio += ratio;
		}
		pcCurHP += (ratio * (pcMaxHP - pcCurHP) / 100);
		if (pcCurHP > pcMaxHP) {
			pcCurHP = pcMaxHP;
		}
	}
	unblind();
	if (extra) {
		pcCurSTR = pcMaxSTR;
		unconfuse();
		unhallucinate();
	} else {
		if (pcState[STATE_CONFUSED] > 0) {
			pcState[STATE_CONFUSED] /= 2;
			pcState[STATE_CONFUSED]++;
		}
		if (pcState[STATE_HALLUCINATION] > 0) {
			pcState[STATE_HALLUCINATION] /= 2;
			pcState[STATE_HALLUCINATION]++;
		}
	}
	stateDraw();

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void unblind() {
FUNCTION_CALLED("unblind()");
FUNCTION_PRINT("call " +functionName);

	if (pcState[STATE_BLINDNESS] > 0) {
		pcState[STATE_BLINDNESS] = 0;
		viewDraw();
		message(strStateEnd[STATE_BLINDNESS]);
	}

FUNCTION_PRINT("return unblind()");
FUNCTION_RETURN();
}

private void unconfuse() {
FUNCTION_CALLED("unconfuse()");
FUNCTION_PRINT("call " +functionName);

	if (pcState[STATE_CONFUSED] > 0) {
		pcState[STATE_CONFUSED] = 0;
		message(strStateEnd[STATE_CONFUSED]);
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void unhallucinate() {
FUNCTION_CALLED("unhallucinate()");
FUNCTION_PRINT("call " +functionName);

	if (pcState[STATE_HALLUCINATION] > 0) {
		pcState[STATE_HALLUCINATION] = 0;
		if (pcState[STATE_BLINDNESS] <= 0) {
			message(strStateEnd[STATE_HALLUCINATION]);
		}
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void changeMonster(int monster) {
FUNCTION_CALLED("changeMonster(" +monster +")");
FUNCTION_PRINT("call " +functionName);

	int kind = randRandom(MONSTER_KIND_COUNT);
	monsterList[monster][MLIST_IS_MONSTER] = kind;
	monsterList[monster][MLIST_FLAG] = monsterCatalog[kind][MCATALOG_FLAG];
	//HP does not change
	monsterList[monster][MLIST_CHAR] = monsterCatalog[kind][MCATALOG_CHAR];
	monsterList[monster][MLIST_QUIVER] = monsterCatalog[kind][MCATALOG_QUIVER];

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void sleepMonster(int monster) {
FUNCTION_CALLED("sleepMonster(" +monster +")");
FUNCTION_PRINT("call " +functionName);

	monsterList[monster][MLIST_FLAG] |= (MFLAG_NAPPING | MFLAG_ASLEEP);
	monsterList[monster][MLIST_PICKED_UP] += randRandom(8)+6;

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void drainLife() {
FUNCTION_CALLED("drainLife()");
FUNCTION_PRINT("call " +functionName);

	if (randPercent(60) || (pcMaxHP <= 30) || (pcCurHP < 10)) {
		return;
	}

	int n = randRandom(3); /* 0:Hp, 1:Str, 2:both */
	if (n != 1) {
		pcMaxHP--;
		pcCurHP--;
		stateDraw();
#ifdef JP
		message("͂ƂꂽB");
#else
		message("you feel weaker.");
#endif
	}
	if (n != 0) {
		if (getRingPower(RING_SUSTAIN_STRENGTH) == 0) {
			pcCurSTR--;
			if (randBool()) {
				pcMaxSTR--;
			}
#ifdef JP
			message("ƂꂽB");
#else
			message("you feel weaker.");
#endif
		}
	}

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void dropLevel() {
FUNCTION_CALLED("dropLevel()");
FUNCTION_PRINT("call " +functionName);

	if (randPercent(80) || (pcLevel <= 5)) {
		return;
	}
	if (getRingPower(RING_SUSTAIN_STRENGTH) != 0) {
		if (randBool()) {
			return;
		}
	}
	pcExp = levelExp[pcLevel-1] -1;
	pcLevel--;
	int hp = hpRaise();
	pcCurHP -= hp;
	if (pcCurHP <= 0) {
		pcCurHP = 1;
	}
	pcMaxHP -= hp;
	if (pcMaxHP <= 0) {
		pcMaxHP = 1;
	}
	stateDraw();
#ifdef JP
	message("x" +pcLevel +"ɂB");
#else
	message("your level was dropped.");
#endif

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void stealGold(int monster) {
FUNCTION_CALLED("stealGold(" +monster +")");
FUNCTION_PRINT("call " +functionName);

	if ((pcGold <= 0) || randPercent(10)) {
		return;
	}
	if (monsterList[monster][MLIST_CARRY] != 0) {
		return;
	}

	int amount = ( randRandom(21) +10 ) * curFloor;
	pcGold -= amount;
	if (pcGold < 0) {
		pcGold = 0;
	}
	monsterList[monster][MLIST_FLAG] &= (~(MFLAG_STEALS_GOLD));
	monsterList[monster][MLIST_FLAG] |= MFLAG_GETAWAY;
	monsterList[monster][MLIST_CARRY] = (ITEM_GOLD | amount);
#ifdef JP
	message("𓐂܂ꂽI");
#else
	message("your purse feels lighter!");
#endif
	more();
	teleportAway(monster);
#ifdef JP
	message("ǂڂ͂I");
#else
	message("the thief disappeared!");
#endif

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}

private void stealItem(int monster) {
FUNCTION_CALLED("stealItem(" +monster +")");
FUNCTION_PRINT("call " +functionName);

	if (randPercent(15) || (pcPackCount == 0)) {
		return;
	}

	int index = randRandom(pcPackCount);
	int object = pcPack[index];
	boolean e = IS_TRUE(object & ITEM_EQUIP);
	if ( getRingPower(RING_MAINTAIN_ITEM) != 0) {
		//RING_MAINTAIN_ITEM itself is stolen.
		if ( IS_FALSE(object & ITEM_EQUIP) || ((object & ITEM_TYPE_FLAG) != ITEM_RING) || ((object & ITEM_SUBTYPE_FLAG) != (RING_MAINTAIN_ITEM << 8)) ) {
			return;
		}
	}
	packOut(index, true);
	object &= (~(ITEM_EQUIP | ITEM_EQUIP_LEFT));
	monsterList[monster][MLIST_FLAG] &= (~(MFLAG_STEALS_ITEM));
	monsterList[monster][MLIST_FLAG] |= MFLAG_GETAWAY;
	monsterList[monster][MLIST_CARRY] = object;
#ifdef JP
	if (e) {
		message("Ă" +getObjectName(object, true) +"𓐂܂ꂽI");
	} else {
		message(getObjectName(object, true) +"𓐂܂ꂽI");
	}
#else
	if (e) {
		message("she stole equipped" +getObjectName(object, true) +"!");
	} else {
		message("she stole " +getObjectName(object, true) +"!");
	}
#endif
	more();
	teleportAway(monster);
#ifdef JP
	message("ǂڂ͂I");
#else
	message("the thief disappeared!");
#endif

FUNCTION_PRINT(functionName +" return");
FUNCTION_RETURN();
}
