//---------------------------------------------------------------------------
/** uEU^u}l[W
 */
/*
 * Copyright (c) 2002-2005 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#ifndef mytabmanage_h
#define mytabmanage_h

#include <vcl.h>
#include <ComCtrls.hpp>
#include <SHDocVw_OCX.h>
#include <list>

#include "ievent2.h"
#include "logdat.h"

/** X̃^u */
class ATabIE
{
public:
	ATabIE(TTabSheet* Parent) ;
    /** fXgN^ */
	~ATabIE()
    {
		delete m_ie ;
        delete m_tab ;
        delete m_HistoryFileName ;
        delete m_HistoryTitleName ;
        ievent->Release() ;
	}
	void __fastcall setParent(void) ;
	void __fastcall write(const AnsiString &htmlStr) ;
	void __fastcall writeHTML(const AnsiString &htmlStr) ;
	void __fastcall open(const AnsiString &local, const AnsiString &datname, const AnsiString &title, int midoku, const AnsiString &anc) ;
    void __fastcall ieNavigate(const AnsiString &URL) ;
    void __fastcall ieBeforeNavigate2(TObject *Sender,
      LPDISPATCH pDisp, VARIANT *URL, VARIANT *Flags,
      VARIANT *TargetFrameName, VARIANT *PostData, VARIANT *Headers,
      VARIANT_BOOL *Cancel) ;
	void __fastcall setFocusIE() ;
    void __fastcall ieStatusTextChange(TObject *Sender, BSTR URL) ;
    void __fastcall resPopup(const AnsiString &str) ;
    AnsiString __fastcall getUrl(void) ;
    /** ̃^Cg𓾂
     * @return ^Cg񃊃Xg
     */
    TStringList* __fastcall getHistory(void)
    {
        return m_HistoryTitleName ;
    }
    void __fastcall openHistoryThread(int index) ;
    void __fastcall bookmark(void) ;
    bool __fastcall isSame(const AnsiString &local, const AnsiString &datname) ;
    /** ̃^uTTabSheet𓾂
     * @return TTabSheet
     */
    TTabSheet* __fastcall getTab(void)
    {
        return m_tab;
    }
    void __fastcall deleteLog(void) ;
private:
	TCppWebBrowser *m_ie ;
	TTabSheet *m_tab ;
    TStringList *m_HistoryFileName ;
    TStringList *m_HistoryTitleName ;
	AnsiString m_local ;
    AnsiString m_datname ;
    int m_menuNum ;
    int m_midoku ;
    ShowResMode m_mode ;
    MyDocHandler *ievent ;
    ALogDat m_log ;
	HRESULT __fastcall ieContextMenu(void) ;
    void __fastcall jumpToAncName(const AnsiString &anc) ;
    int __fastcall jumpToAncNameSub(const AnsiString &anc) ;
    void __fastcall addHistory(const AnsiString &filename, const AnsiString &title) ;
    void __fastcall jumpToRebuildHTML(const AnsiString &anc) ;
} ;

/** Xbhǂ̂悤ɊJ
 */
typedef enum
{
    inActiveTab, // ݂̃^uŊJ
    inNewTab, // V^uŊJ
} OpenThreads ;

class ATabManager
{
public:
    /** RXgN^ */
	ATabManager()
    {
        ;
	}
    /** fXgN^ */
	~ATabManager()
    {
		clear() ;
	}
    /** 
     * @param pc TPageControl
     */
	void __fastcall init(TPageControl *pc)
	{
		m_pc = pc ;
	}
	void __fastcall open(const AnsiString &local, const AnsiString &datname, const AnsiString &title, OpenThreads flag, int midoku, const AnsiString &anc);
	void __fastcall close(TTabSheet *tab) ;
	void __fastcall closeOther(TTabSheet *tab) ;
	void __fastcall clear(void) ;
	void __fastcall setParent(void) ;
	void __fastcall writeHTML(const AnsiString &htmlstr, const AnsiString caption, bool newTab = false) ;
	void __fastcall setFocusIE(void) ;
    AnsiString __fastcall getUrl(TTabSheet *tab) ;
    TStringList* __fastcall getHistory(TTabSheet *tab) ;
    void __fastcall openHistory(TTabSheet *tab, int index) ;
    void __fastcall bookmark(void) ;
    void __fastcall deleteLog(void) ;
private:
	std::list <ATabIE *> m_ie_array ;
	TTabSheet* __fastcall CreateTab(void) ;
	ATabIE* __fastcall getExistTab(const AnsiString &local, const AnsiString &datname, const AnsiString &title);
	TPageControl *m_pc ;
} ;

extern ATabManager g_tabMan ; /* O[o */

#endif /* tabman.h */
