//---------------------------------------------------------------------------
/** uEU^u}l[W
 */
/*
 * Copyright (c) 2002-2005, 2006 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#include <vcl.h> /* include  ATabIE::write()  doc2->write(sa); ŃG[ */
#include <ComCtrls.hpp>
#include <list>
#include <mshtml.h>
#pragma hdrstop

#include "tabman.h"
#include "config.h"
#include "misc.h"
#include "subject.h"
#include "MainUnit.h"

/* O[o */
ATabManager g_tabMan ;
//---------------------------------------------------------------------------
/** RXgN^
 */
ATabIE::ATabIE(TTabSheet* Parent)
{
    m_ie = new TCppWebBrowser( Parent ) ;
    ievent = new MyDocHandler ;
    ievent->OnBeforeNavigate = ieNavigate ;
    ievent->OnContextMenu = ieContextMenu ;
    m_ie->OnBeforeNavigate2 = ieBeforeNavigate2 ;
    m_ie->OnStatusTextChange = ieStatusTextChange ;
    m_tab = Parent ;
    m_tab->Tag = (int)this ;
    m_ie->ParentWindow = Parent->Handle ;
    m_ie->TOleControl::Parent = Parent ;
    m_ie->Align = alClient ;
    m_ie->Visible = true ;
    m_ie->Navigate( WideString("about:blank").c_bstr() ) ;

    m_HistoryFileName = new TStringList() ;
    m_HistoryTitleName = new TStringList() ;

    /* IȄ҂ */
    while ( m_ie->Busy )
    {
        Sleep( 50 ) ;
    }
    
    // IER|̃CxgtbN
    ICustomDoc *custdoc ;
    m_ie->Document->QueryInterface( &custdoc ) ;
    if (custdoc) custdoc->SetUIHandler( ievent ) ;
}
//---------------------------------------------------------------------------
/** IER|TTabɓ
 */
void __fastcall ATabIE::setParent(void)
{
    m_ie->ParentWindow = m_tab->Handle ;
    m_ie->TOleControl::Parent = m_tab ;
}
//---------------------------------------------------------------------------
/** IẼReNXgj[tbN
 * IĂāA̕XԍȂ炻̃X|bvAbv
 * YȂIẼReNXgj[o
 */
HRESULT __fastcall ATabIE::ieContextMenu(void)
{
    /* S_FALSE ԂIẼReNXgj[o */
	HRESULT ret = S_FALSE ;
	if ( m_ie->Document == NULL ) return ret ;

	HRESULT hr ;
    TComInterface<IHTMLDocument2> doc2 ;
	doc2 = m_ie->Document ;
	if ( ! doc2 ) return ret ;
	TComInterface<IHTMLSelectionObject> so ;
	doc2->get_selection( &so ) ;
	if ( ! so ) return ret ;
	BSTR b ;
	hr = so->get_type( &b ) ;
	if ( FAILED(hr) || (AnsiString(b) == "None") ) return ret ;
	TComInterface<IDispatch> d ;
	so->createRange( &d ) ;
	if ( ! d ) return ret ;
	TComInterface<IHTMLTxtRange> tr ;
	tr = d ;
	if ( ! tr ) return ret ;
	hr = tr->get_text( &b ) ;
	if ( FAILED(hr) ) return ret ;
	AnsiString s = AnsiString(b).Trim() ;
	if ( ! s.IsEmpty() )
    {
		s = m_log.selectPopup( s.c_str(), g_hintMaxRow ) ;
		if ( ! s.IsEmpty() )
        {
			resPopup( s ) ;
			ret = S_OK ;
		}
	}
	return ret ;
}
//---------------------------------------------------------------------------
/** IER|HTML
 */
void __fastcall ATabIE::write(const AnsiString &htmlStr)
{
    TComInterface<IHTMLDocument2> doc2 ;
    doc2 = m_ie->Document ;
    if ( ! doc2 ) return ;

#if 0
    SAFEARRAY* sa = SafeArrayCreateVector( VT_VARIANT, 0, 1 ) ;
#else
    SAFEARRAYBOUND  sab[1] ;
    sab[0].cElements = 1 ;
    sab[0].lLbound = 0 ;
    SAFEARRAY* sa = SafeArrayCreate( VT_VARIANT, 1, sab ) ;
#endif
	if ( sa )
    {
		VARIANT* sadata ;
		if ( SUCCEEDED( SafeArrayAccessData( sa, (void**)(&sadata)) ) )
        {
#if 0
            CComBSTR bstr( htmlstr.c_str() ) ;
            VARIANT var ;
            V_VT(&var) = VT_BSTR;
            V_BSTR(&var) = (BSTR)bstr;
            sadata[0] = var;
            bstr.Detach();
#else
            OleVariant v( htmlStr ) ;
            //v.ChangeType( VT_BSTR ) ;//BDS
            sadata[0] = v ;
#endif
            IDispatch *d ;
            doc2->open( WideString("text/html").c_bstr(), TVariant("replace"), TVariant(), TVariant(), &d ) ;
			doc2->put_charset( WideString("Shift_JIS").c_bstr() ) ;
			doc2->write( sa ) ;
            SafeArrayUnaccessData( sa ) ;
            doc2->close() ;
		}
		SafeArrayDestroy( sa ) ;
	}
}
//---------------------------------------------------------------------------
/** IER|HTML
 */
void __fastcall ATabIE::writeHTML(const AnsiString &htmlStr)
{
    // 
    //m_menuNum = 0;
    m_local = "";
    m_datname = "";
    //m_midoku = 1;
    //m_mode = LOG_FLAG_L50;

    write( htmlStr ) ;
    setFocusIE() ;
}
//---------------------------------------------------------------------------
/** wXbh\
 */
void __fastcall ATabIE::open(const AnsiString &local, const AnsiString &datname, const AnsiString &title, int midoku, const AnsiString &anc)
{
    // 
    m_local = local ;
    m_datname = datname ;
    m_midoku = midoku ;
    m_mode = showLatest50Res ;

    AnsiString fname = local + datname ;
    m_log.dat2log( fname ) ;
    AnsiString htmlStr = m_log.log2html( title, midoku, m_mode ) ;

    addHistory( fname, title ) ;

    write( htmlStr ) ;
    jumpToAncName( anc ) ;
    setFocusIE() ;
}
//---------------------------------------------------------------------------
/** ɉ
 */
void __fastcall ATabIE::addHistory(const AnsiString &filename, const AnsiString &title)
{
    int index = m_HistoryFileName->IndexOf( filename ) ;
    if ( index != -1 )
    {
        m_HistoryFileName->Delete( index ) ;
        m_HistoryTitleName->Delete( index ) ;
    }

    m_HistoryFileName->Insert( 0, filename ) ;
    m_HistoryTitleName->Insert( 0, title ) ;

    if (m_HistoryFileName->Count > 5)
    {
        m_HistoryFileName->Delete( 5 ) ;
        m_HistoryTitleName->Delete( 5 ) ;
    }
}
//---------------------------------------------------------------------------
/** J
 */
void __fastcall ATabIE::openHistoryThread(int index)
{
    AnsiString title = m_HistoryTitleName->Strings[index] ;
    m_tab->Caption = title ;
    AnsiString path = m_HistoryFileName->Strings[index] ;
    AnsiString local = ExtractFilePath( path ) ;
    AnsiString datname = ExtractFileName( path ) ;

    TMemIniFile *ini = new TMemIniFile( local + FILENAME_SUBJECT_INI ) ;
    int unread = ini->ReadInteger( datname, THREAD_INI_UNREAD, 1 ) ;
    delete ini ;

    open( local, datname, title, unread, "midoku" ) ;
}
//---------------------------------------------------------------------------
/** IER|̃NNbNꂽ
 */
void __fastcall ATabIE::ieBeforeNavigate2(TObject *Sender,
      LPDISPATCH pDisp, VARIANT *URL, VARIANT *Flags,
      VARIANT *TargetFrameName, VARIANT *PostData, VARIANT *Headers,
      VARIANT_BOOL *Cancel)
{
///BDS
	AnsiString u = AnsiString( TVariant( *URL ) ) ;
	///AnsiString u = TVariant( *URL ) ;
	if ( u == "about:blank" ) return ;
	*Cancel = true ;
}
void __fastcall ATabIE::ieNavigate(const AnsiString &URL)
{
    AnsiString u = URL ;
    if ( u == "about:blank" ) return ;
    if ( u.AnsiPos( "menu:" ) == 1 )
    {
        m_menuNum = u.SubString( 6, u.Length() -5 ).ToIntDef( 0 ) ;
        POINT p ;
        GetCursorPos( &p ) ;
        MainForm->iePM->Popup( p.x, p.y ) ;
    }
    else if ( u.AnsiPos( "about:blank#" ) == 1 )
    {
        // Xԍ̃AJ[ɔ
        // "1-?"1A"-2"Ȃ2֔
        // "1,3"͍ŏ̔ԍ(AJ[ϊ","؂ɑΉĂȂ)
        AnsiString nostr = u.SubString( 13, u.Length() -12 ) ;
        if ( nostr == "midoku" )
        {
            jumpToAncName( nostr ) ;
        }
        else if ( nostr == "all" )
        {
            m_mode = showAllRes ;
            jumpToRebuildHTML( "1" ) ;
        }
        else
        {
            int no = atoi( nostr.c_str() +1 ) ;
            no = abs( no ) ;
            // <A NAME="a?">֔
            AnsiString anc = AnsiString( "a" ) + AnsiString( no ) ;
            jumpToAncName( anc ) ;
        }
    }
    else
    {
        // ÔXbhȂV^uŊJ
        if ( u.AnsiPos( "/read.cgi/" ) != 0 )
        {
            AnsiString logname, opt ;
            readcgi2LocalPath( u.c_str(), logname, opt ) ;
            logname = g_global.getLogDir() + logname ;
            if ( FileExists( logname ) )
            {
                AnsiString logdir = ExtractFilePath( logname ) ;
                AnsiString datname = ExtractFileName( logname ) ;
                TMemIniFile *ini = new TMemIniFile( logdir + FILENAME_SUBJECT_INI ) ;
                AnsiString title = ini->ReadString( datname, THREAD_INI_TITLE, "" ) ;
                int midoku = ini->ReadInteger( datname, THREAD_INI_UNREAD, 1 ) ;
                delete ini ;
                if ( opt.IsEmpty() || opt.AnsiPos( "l" ) == 1 )
                {
                    opt = "midoku" ;
                }
                else
                {
                    int no ;
                    if ( opt.AnsiPos( "n" ) == 1 )
                    {
                        no = atoi( opt.c_str() +1 ) ;
                    }
                    else
                    {
                        no = atoi( opt.c_str() ) ;
                    }
                    no = abs( no ) ;
                    opt = "a" + AnsiString( no ) ;
                }
                MainForm->openThreadInNewTab( logdir, datname, title, midoku, opt ) ;
                return ;
            }
        }
        // ̓uEUŊJ
    	ShellExecute( NULL, NULL, u.c_str(), g_wwwBrowserPath.c_str(), NULL, SW_SHOW ) ;
    }
}
//---------------------------------------------------------------------------
/** wAJ[ɔԉ֐
 * @param anc AJ[
 * @return 0: 1:ѐ悪Ȃ -1:G[
 */
int __fastcall ATabIE::jumpToAncNameSub(const AnsiString &anc)
{
    // <A NAME=anc>֔
    HRESULT hr ;
    TComInterface<IHTMLDocument2> doc2 ;
    doc2 = m_ie->Document ;
    if ( ! doc2 ) return -1 ;
    TComInterface<IHTMLElementCollection> ec ;
    hr = doc2->get_anchors( &ec ) ;
    if ( FAILED( hr ) ) return -1 ;
    TComInterface<IHTMLElement> be ;
    hr = doc2->get_body( &be ) ;
    if ( FAILED( hr ) ) return -1 ;
    TComInterface<IHTMLTextContainer> body ;
    body = be ;
    if ( ! body ) return -1 ;
    OleVariant a = anc ;
    OleVariant b = 0 ;
    TComInterface<IDispatch> p ;
    ec->item( a, b, &p ) ;
    if ( ! p ) return 1 ;
    TComInterface<IHTMLElement> e ;
    e = p ;
    if ( e )
    {
        long sctop ;
        e->get_offsetTop( &sctop ) ;
        body->put_scrollTop( sctop ) ;
    }
    return 0 ;
}
//---------------------------------------------------------------------------
/** wAJ[ɔ
 * @param anc AJ[
 */
void __fastcall ATabIE::jumpToAncName(const AnsiString &anc)
{
    // ɓ
    int re = jumpToAncNameSub( anc ) ;
    if ( re == 1 )
    {
        // ѐ悪̂HTMLč\zĉ߂ăWv
        m_mode = showAllRes ;
        jumpToRebuildHTML( anc ) ;
    }
}
//---------------------------------------------------------------------------
/** }EXN̏ʂ
 */
void __fastcall ATabIE::ieStatusTextChange(TObject *Sender, BSTR URL)
{
    AnsiString str = URL ;
    //MainForm->StatusBar->SimpleText = str;
    if ( str == "" )
    {
        MainForm->delPop( NULL ) ;
        return ;
    }

    AnsiString hstr ;
    if ( str.AnsiPos( "mailto:" ) == 1 )
    {
        hstr = str.SubString( 8, str.Length() -7 ) ;
    }
    else if ( str.AnsiPos( "about:blank#a" ) == 1 )
    {
        AnsiString nostr = str.SubString( 14, str.Length() -13 ) ;
        if ( nostr == "ll" ) return ; // "#all"
        hstr = m_log.popupLog( nostr.c_str(), g_hintMaxRow ) ;
    }
    else if ( str.AnsiPos( "/test/read.cgi/" ) != 0 )
    {
        AnsiString logname, opt ;
        readcgi2LocalPath( str.c_str(), logname, opt ) ;
        logname = g_global.getLogDir() + logname ;
        if ( FileExists( logname ) )
        {
            hstr = m_log.popupOtherLog( logname, opt.c_str(), g_hintMaxRow ) ;
        }
        else
        {
            TMemIniFile *ini = new TMemIniFile( ExtractFilePath( logname ) + FILENAME_SUBJECT_INI ) ;
            hstr = ini->ReadString( ExtractFileName( logname ), THREAD_INI_TITLE, "" ) ;
            delete ini ;
        }
    }
    if ( hstr.IsEmpty() )
    {
        MainForm->delPop( NULL ) ;
        return;
    }
    resPopup( hstr ) ;
}
//---------------------------------------------------------------------------
/** w背X|bvAbv\
 */
void __fastcall ATabIE::resPopup(const AnsiString &str)
{
    POINT p ;
    GetCursorPos( &p ) ;
    p.x = p.x +8 ;
    p.y = p.y -20 ;
    TRect r ;
    r = g_popHint->CalcHintRect( Screen->Width, str, NULL ) ;

    int rwidth  = r.Right  - r.Left ;
    int rheight = r.Bottom - r.Top ;
    int zwidth = 0 ;
    int zheight = 0 ;
    r.Top = p.y - rheight ;
    if ( r.Top < 0 )
    {
        zheight = r.Top ;
        r.Top = 0 ;
    }
    r.Right = p.x + rwidth ;
    if ( r.Right > Screen->Width )
    {
        zwidth = r.Right - Screen->Width ;
        r.Right = Screen->Width ;
    }
    r.Left   = p.x - zwidth ;
    r.Bottom = p.y - zheight ;

    g_popHint->ActivateHint( r, str ) ;
}
//---------------------------------------------------------------------------
/** TCppWebBrowserActiveXhLgɃtH[JX𓖂Ă
 */
void __fastcall ATabIE::setFocusIE(void)
{
    if ( m_ie->Document == NULL ) return ;
    //if (m_ie->LocationName == (WideString)"about:blank") return;

    TComInterface<IHTMLDocument2> doc2 ;
    doc2 = m_ie->Document ;
    if ( ! doc2 ) return ;
    TComInterface<IHTMLWindow2> win ;
    doc2->get_parentWindow( &win ) ;
    //m_tab->Caption;
    //HRESULT re =
    win->focus();
}
//---------------------------------------------------------------------------
/** Xbh
 */
bool __fastcall ATabIE::isSame(const AnsiString &local, const AnsiString &datname)
{
    bool ret = false ;
    if ( (local == m_local) && (datname == m_datname) )
    {
        ret = true ;
    }
    return ret;
}
//---------------------------------------------------------------------------
/* XbhURL𓾂
 * @return URL
 */
AnsiString __fastcall ATabIE::getUrl(void)
{
    // url:"http://pc.2ch.net/test/read.cgi/hp/1009190196/50l"
    // local:"pc.2ch.net\\hp\\1009190196.dat"
    AnsiString ita = ExtractFileDir( m_local ) ;
    AnsiString host = ExtractFileDir( ita ) ;
    AnsiString url = (AnsiString)"http://" + ExtractFileName( host ) + "/test/read.cgi/" + ExtractFileName( ita ) + "/" + ChangeFileExt( m_datname, "" ) ;
    return url ;
}
//---------------------------------------------------------------------------
/** O폜
 */
void __fastcall ATabIE::deleteLog(void)
{
    if ( MainForm->subject.isSame(m_local) )
    {
        // ݃ANeBuȔ
        int index = MainForm->subject.getDatIndex( m_datname ) ;
        if ( index >= 0 )
        {
            // ꗗɂ
            MainForm->subject.deleteLogList( index, m_datname ) ;
            MainForm->SubjectListView->UpdateItems(index, index);
        }
        else
        {
            // ꗗɂȂ
            MainForm->subject.deleteLog( m_datname ) ;
        }
    }
    else
    {
        // ݒXV
    	TMemIniFile *ini = new TMemIniFile( m_local + FILENAME_SUBJECT_INI ) ;
        AnsiString filename = m_local +m_datname ;
        DeleteFile( filename ) ;
        ini->WriteInteger( m_datname, THREAD_INI_GOTCOUNT, 0 ) ;
        ini->WriteInteger( m_datname, THREAD_INI_UNREAD, 1 ) ;
        ini->UpdateFile() ;
        delete ini ;
    }
}
//---------------------------------------------------------------------------
/** ܂œǂ
 */
void __fastcall ATabIE::bookmark(void)
{
    m_midoku = m_menuNum ;
    if ( MainForm->subject.isSame( m_local ) )
    {
        // ݃ANeBuȔ
        int index = MainForm->subject.getDatIndex( m_datname ) ;
        if ( index >= 0 )
        {
            // ꗗɂ
            MainForm->subject.setUnreadPointList( index, m_datname, m_midoku ) ;
            MainForm->SubjectListView->UpdateItems( index, index ) ;
        }
        else
        {
            // ꗗɂȂ
            MainForm->subject.setUnreadPoint( m_datname, m_midoku ) ;
        }
    }
    else
    {
        // ݒXV
    	TMemIniFile *ini = new TMemIniFile( m_local + FILENAME_SUBJECT_INI ) ;
        ini->WriteInteger( m_datname, THREAD_INI_UNREAD, m_midoku ) ;
        ini->UpdateFile() ;
        delete ini ;
    }
    jumpToRebuildHTML( "midoku" ) ;
}
//---------------------------------------------------------------------------
/** Xbh̑SXHTMLɍč\zĕ\
 * @param Wv郌Xԍ
 */
void __fastcall ATabIE::jumpToRebuildHTML(const AnsiString &anc)
{
    AnsiString htmlStr = m_log.log2html( m_tab->Caption, m_midoku, m_mode ) ;
    write( htmlStr ) ;
    jumpToAncNameSub( anc ) ;
}
//---------------------------------------------------------------------------

/* ^u}l[W */
//---------------------------------------------------------------------------
/** łɊJĂXbh`FbN
 * @param local
 * @param datname
 * @param title
 * @return łɊJĂ^uBꍇNULL
 */
ATabIE* __fastcall ATabManager::getExistTab(const AnsiString &local, const AnsiString &datname, const AnsiString &title)
{
    ATabIE *result = NULL ;
    if ( m_pc->PageCount == 0 ) return result ;

    int count = m_pc->PageCount ;
    for ( int i=0; i < count; i++)
    {
        if ( title == m_pc->Pages[i]->Caption )
        {
            ATabIE *tabie = (ATabIE *)(m_pc->Pages[i]->Tag) ;
            if ( tabie->isSame( local, datname ) )
            {
                result = tabie ;
                break ;
            }
        }
    }
    return result ;
}
//---------------------------------------------------------------------------
/** ̃^u
 */
void __fastcall ATabManager::close(TTabSheet *tab)
{
    ATabIE *tabie = (ATabIE *)(tab->Tag) ;
    m_ie_array.remove( tabie ) ;
    delete tabie ;
}
//---------------------------------------------------------------------------
/** ȊÕ^u
 */
void __fastcall ATabManager::closeOther(TTabSheet *tab)
{
    int index = tab->TabIndex ;
    int count = m_pc->PageCount ;
    int i = count -1 ;
    for ( ; i > index; i--)
    {
        ATabIE *tabie = (ATabIE *)(m_pc->Pages[i]->Tag) ;
        delete tabie ;
    }
    i = index -1 ;
    for ( ; i >= 0; i--)
    {
        ATabIE *tabie = (ATabIE *)(m_pc->Pages[i]->Tag) ;
        delete tabie ;
    }
    m_ie_array.clear() ;
    ATabIE *tabie = (ATabIE *)(m_pc->Pages[0]->Tag) ;
    m_ie_array.push_back( tabie ) ;
}
//---------------------------------------------------------------------------
/** ^uׂĕ
 */
void __fastcall ATabManager::clear(void)
{
    if ( m_ie_array.empty() ) return ;
    std::list<ATabIE *>::iterator ite ;

    for (ite = m_ie_array.begin(); ite != m_ie_array.end(); ite++)
    {
        if ( *ite != NULL )
        {
            delete *ite ;
        }
    }
    m_ie_array.clear() ;
}
//---------------------------------------------------------------------------
/** ^uParentZbg
 */
void __fastcall ATabManager::setParent(void)
{
    int count = m_pc->PageCount ;
    for (int i=0; i < count; i++)
    {
        ATabIE *tabie = (ATabIE *)(m_pc->Pages[i]->Tag) ;
        tabie->setParent() ;
    }
}
//---------------------------------------------------------------------------
/** TCppWebBrowserActiveXhLgɃtH[JX𓖂Ă
 */
void __fastcall ATabManager::setFocusIE(void)
{
    if ( m_pc->PageCount == 0 ) return ;
    ATabIE *tabie = (ATabIE *)(m_pc->ActivePage->Tag) ;
    tabie->setFocusIE() ;
}
//---------------------------------------------------------------------------
/** ^uURL𓾂
 */
AnsiString __fastcall ATabManager::getUrl(TTabSheet *tab)
{
    ATabIE *tabie = (ATabIE *)(tab->Tag) ;
    return tabie->getUrl() ;
}
//---------------------------------------------------------------------------
/** ^ũ^Cg𓾂
 */
TStringList* __fastcall ATabManager::getHistory(TTabSheet *tab)
{
    ATabIE *tabie = (ATabIE *)(tab->Tag) ;
    return tabie->getHistory() ;
}
//---------------------------------------------------------------------------
/** ^u̗J
 */
void __fastcall ATabManager::openHistory(TTabSheet *tab, int index)
{
    ATabIE *tabie = (ATabIE *)(tab->Tag) ;
    tabie->openHistoryThread( index) ;
}
//---------------------------------------------------------------------------
/** ܂œǂ
 */
void __fastcall ATabManager::bookmark(void)
{
    //if ( m_pc->PageCount == 0 ) return ;
    ATabIE *tabie = (ATabIE *)(m_pc->ActivePage->Tag) ;
    tabie->bookmark() ;
}
//---------------------------------------------------------------------------
/** O폜
 */
void __fastcall ATabManager::deleteLog(void)
{
    if ( m_pc->PageCount == 0 ) return ;
    ATabIE *tabie = (ATabIE *)(m_pc->ActivePage->Tag) ;
    tabie->deleteLog() ;
}
//---------------------------------------------------------------------------
/** XbhJ
 */
void __fastcall ATabManager::open(const AnsiString &local, const AnsiString &datname, const AnsiString &title, OpenThreads flag, int midoku, const AnsiString &anc)
{
	ATemporarilyCursor hourGlass ;

    TTabSheet *actab ;
    ATabIE *tabie ;

    tabie = getExistTab( local, datname, title ) ;
    if ( tabie != NULL )
    {
        // łɊJĂ̂łANeBu
        m_pc->ActivePage = tabie->getTab() ;
        Screen->Cursor = crDefault ;
        return ;
    }
    
    if ( (m_pc->PageCount == 0) || (flag == inNewTab) )
    {
        // V^u
        actab = new TTabSheet( m_pc ) ;
        actab->PageIndex = 0 ;
        actab->PageControl = m_pc ;
        actab->TabVisible = true ;
        m_pc->ActivePage = actab ;
        tabie = new ATabIE( actab ) ;
        m_ie_array.push_back( tabie ) ;
    }
    else if ( flag == inActiveTab )
    {
        // ANeBu^u
        actab = m_pc->ActivePage ;
        tabie = (ATabIE *)(actab->Tag) ;
        // łɂ΂I[v
    }
    actab->Caption = title ;
    tabie->open( local, datname, title, midoku, anc ) ;
}
//---------------------------------------------------------------------------
/** HTML
 */
void __fastcall ATabManager::writeHTML(const AnsiString &htmlstr, const AnsiString caption, bool newTab)
{
    TTabSheet *actab ;
    ATabIE *tabie ;
    if ( m_pc->PageCount == 0 || g_openNewTab || newTab )
    {
        // V^u
        actab = new TTabSheet( m_pc ) ;
        actab->PageIndex = 0 ;
        actab->PageControl = m_pc ;
        actab->TabVisible = true ;
        m_pc->ActivePage = actab ;
        tabie = new ATabIE( actab ) ;
        m_ie_array.push_back( tabie ) ;
    }
    else
    {
        // ANeBu^u
        actab = m_pc->ActivePage ;
        tabie = (ATabIE *)(actab->Tag) ;
    }
    actab->Caption = caption ;
    tabie->writeHTML( htmlstr ) ;
}
//---------------------------------------------------------------------------

