//---------------------------------------------------------------------------
/** XbhꗗǗ
 */
/*
 * Copyright (c) 2002-2005 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#ifndef mysubject_h
#define mysubject_h

#include <vcl.h>
#include <ComCtrls.hpp>
#include <inifiles.hpp>

#include "httpsock.h"
#include "logdat.h"
#include "regexp.h"

/* t@C */
#define FILENAME_BBS_INI "bbs.ini"
#define FILENAME_SUBJECT_INI "subject.ini"
#define FILENAME_SUBJECT_TXT "subject.txt"

#define THREAD_INI_NOWNO        "NowNo"
#define THREAD_INI_PRENO        "PreNo"
#define THREAD_INI_TITLE        "Title"
#define THREAD_INI_RESCOUNT     "ResCount"
#define THREAD_INI_GOTCOUNT     "GotCount"
#define THREAD_INI_UNREAD       "Unread" /* ǈʒu */
#define THREAD_INI_LASTMODIFIED "LastModified"
#define THREAD_INI_DATSIZE      "DatSize"

/** Xbh̏ */
typedef enum
{
    threadNull      = 0,
    threadGetErr    = 0x01, // 擾s
    threadNoLog     = 0x02, // OȂ
    threadLogExist  = 0x04, // O
    threadUnread    = 0x08, // ǂ
    threadNew       = 0x10, // VX
    threadStop      = 0x20, // X1000𒴂ďIX
    threadPast      = 0x40, // DAT
    threadSmart     = (threadUnread | threadNew | threadPast),
    threadAll       = 0xff,
} ThreadState;

/** ListView̃JCfbNX */
typedef enum
{
    indexState = -1,    // ThreadState
    indexNowList = 0,   // 
    indexPreList,       // O񏇈
    indexTitle,         // ^Cg
    indexResCount,      // X
    indexGotCount,      // X
    indexUnread,        // ǐ
    indexTimestamp,     // dat̃^CX^v
    indexDatSize,       // dat̃t@CTCY
    indexDatname,       // dat̃t@C
} ThreadListViewIndex ;

/** \[gp */
typedef struct THREAD_SORT
{
    bool state[12] ;
} THREAD_SORT ;

/** Xbh̃f[^ */
typedef struct ThreadItem
{
    ThreadState state ;
    int nowNo, preNo ;
    AnsiString title ;
    int countRes, countGot, unread ;
    AnsiString datname, timestamp ;
    int datSize ;
} ThreadItem ;

/* \[gpt@NV */
int __fastcall ListSortFunc(void * Item1, void * Item2) ;

/** XbhꗗǗ */
class ASubject
{
public:
    /** RXgN^
     */
	ASubject()
    {
        m_ini = NULL ;
        m_pItem = NULL ;
        m_list = new TList() ;
        m_call = NULL ;
	}
    /** fXgN^ */
	~ASubject()
    {
		if ( m_ini ) delete m_ini ;
        if ( m_pItem ) delete[] m_pItem ;
        delete m_list ;
	}
	void __fastcall target(const AnsiString &iniFilePath) ;
	void __fastcall close(void) ;
	void __fastcall merge(TStringList *subject) ;
	bool __fastcall isExistLog(const AnsiString &datname) ;
	void __fastcall deleteLog(const AnsiString &datname, bool flush = true) ;
	void __fastcall deleteLogList(int index, const AnsiString &datname, bool flush = true) ;
	int __fastcall getUnreadPoint(const AnsiString &datname);
	int __fastcall setUnreadPoint(const AnsiString &datname, int num, bool flush = true) ;
	int __fastcall setUnreadPointList(int index, const AnsiString &datname, int num, bool flush = true) ;
	void __fastcall updateThreadInfo(TMemoryStream *ms, const AnsiString &datname, const AnsiString &dattime, bool flush = true) ;
    /** Xbhꗗo
     */
	void __fastcall flushIni(void)
    {
        if ( ! m_ini ) return ;
        m_ini->UpdateFile() ;
    }
    /** ̃OfBNg𓾂
     * @return fBNgpX
     */
	AnsiString __fastcall getLogDir(void)
    {
        return m_logDir ;
    }
	AnsiString __fastcall getBBSurl(void) ;
	void __fastcall viewThreadList(TListView *view, unsigned int showtype) ;
    void __fastcall getThreadListViewData(TListItem *item) ;
    void __fastcall updateThreadListViewData(TListItem *item) ;
    bool __fastcall reload() ;
    bool __fastcall reloadDat(const AnsiString &datname) ;
    bool __fastcall ifUnreadDoReload(const AnsiString &datname) ;
    void __fastcall threadListsort(int index) ;
    int __fastcall getDatIndex(const AnsiString &datname) ;
    /** ̔`FbN
     * @param dir r̃fBNgpX
     * @return Ȃtrue
     */
    bool __fastcall isSame(const AnsiString &dir)
    {
        return ( dir == m_logDir ) ;
    }
    /** Xbh̏Ԃ𓾂
     * @param index ListViewłindexl
     * @return Xbh̏
     */
    ThreadState __fastcall getThreadState(int index)
    {
        return getThreadItem( index )->state ;
    }
	void __fastcall search(ARegExp *regexp, TListView *view) ;
	AnsiString __fastcall searchLog(ARegExp *regexp, const AnsiString &itaurl, const AnsiString &itaname, PROGRESS_CALLBACK lpCallBack, long lData) ;
private:
	bool __fastcall parseSubjectLine(char *line, AnsiString &datname, AnsiString &title, AnsiString &rescount) ;
	AnsiString __fastcall fixTitle(const AnsiString &title) ;
    /** Xbh̓f[^|C^𓾂
     * |C^f[^邱Ƃ\
     * @param index ListViewłindexl
     * @return ThreadItemf[^ւ̃|C^
     */
    ThreadItem* __fastcall getThreadItem(int index)
    {
        return (ThreadItem*)m_list->Items[index] ;
    }
    void __fastcall insertItem(TList *list, ThreadItem *pItem) ;
    void __fastcall calcState(ThreadItem &item) ;
    AnsiString __fastcall getSubjectTimestamp() ;
    void __fastcall setSubjectTimestamp(const AnsiString &time) ;
	TMemIniFile *m_ini ;
	AnsiString m_logDir ;
    THREAD_SORT m_threadSort ;
    CALL_PACK *m_call ;
    // Xbhf[^
    ThreadItem *m_pItem ;
    TList * m_list ; // ListView ɕ\f[^
} ;

class ACacheServer
{
public:
	ACacheServer()
    {
        m_cacheBoardList = NULL ;
	}
	~ACacheServer()
    {
		if ( m_cacheBoardList ) delete m_cacheBoardList ;
	}
	AnsiString __fastcall getUrl(const AnsiString &url) ;
private:
    THashedStringList *m_cacheBoardList ;
	int __fastcall IsCachedEnabled(const AnsiString &url) ;
    void __fastcall perseServerDir(char *html) ;
};

/* O[o */
extern ACacheServer g_cache ;

#endif /* subject.h */
