//---------------------------------------------------------------------------
/** XbhꗗǗ
 */
/*
 * Copyright (c) 2002-2005, 2006 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#include <vcl.h>
#include <ComCtrls.hpp>
#include <inifiles.hpp>
#include <FileCtrl.hpp>
#pragma hdrstop

#include "subject.h"
#include "config.h"
#include "misc.h"
#include "MainUnit.h"

/* O[o */
ACacheServer g_cache ;
//---------------------------------------------------------------------------
/** R[obN
 * @param nNum ݂̐i󋵁B
 *             bZ[WꍇA̒l̂Ƃ͒ʐM󋵃bZ[WB
 *             ̂Ƃ͎Mf[^̂́B
 * @param nDenom iBnNum==nDenomŏIB
 * @param str bZ[WB܂͒ʐMf[^B
 * @param lData CALL_PACK
 * @return 0Ԃ璆f
 */
static int __stdcall subjectCallback(const char *str, long lData, int nNum, int nDenom)
{
    ACriticalSection cs ;

    CALL_PACK *call = (CALL_PACK *)lData ;
    if ( call == NULL ) return 0 ;

    if ( str != NULL )
    {
        MainForm->StatusBar->SimpleText = str ;
    }
    else
    {
#if 0
        Progress->Max = nDenom ;
        progress->Position = nNum ;
#endif
    }

    Application->ProcessMessages() ;
    if ( call->abort ) return 1 ;

    return 0 ;
}
//---------------------------------------------------------------------------
/** ǐJEg
 * @param gotCount 擾
 * @param unreadPoint ǈʒu
 * @return ǐ
 */
int __fastcall calcUnread(int gotCount, int unreadPoint)
{
    int result = 0 ;
    if ( gotCount >= 0 )
    {
        if ( gotCount >= unreadPoint )
        {
            result = gotCount - unreadPoint +1 ;
        }
    }
    return result ;
}
//---------------------------------------------------------------------------
/** Xbhꗗƌт
 * @param iniFilePath ݒt@C̃pX
 */
void __fastcall ASubject::target(const AnsiString &iniFilePath)
{
    if ( m_ini ) delete m_ini ;
    m_ini = new TMemIniFile( iniFilePath ) ;

    m_logDir = ExtractFileDir( iniFilePath ) ;
    ForceDirectories( m_logDir );
    m_logDir += "\\" ;
}
//---------------------------------------------------------------------------
/** XbhꗗƐ؂藣
 */
void __fastcall ASubject::close(void)
{
    if ( m_ini )
    {
        delete m_ini ;
        m_ini = NULL ;
    }

    if ( m_pItem )
    {
        delete[] m_pItem ;
        m_pItem = NULL ;
    }

    m_list->Clear() ;
}
//---------------------------------------------------------------------------
/** Ȏ݂mF
 * @param datname dat
 * @return ݂Ȃ true
 */
bool __fastcall ASubject::isExistLog(const AnsiString &datname)
{
    return FileExists( getLogDir() + datname ) ;
}
//---------------------------------------------------------------------------
/** O폜
 * @param datname dat
 * @param flush ύXinit@Cɂɔf邩
 */
void __fastcall ASubject::deleteLog(const AnsiString &datname, bool flush)
{
    if ( ! m_ini ) return ;

    AnsiString filepath = getLogDir() + datname ;
    DeleteFile( filepath ) ;

    m_ini->WriteInteger( datname, THREAD_INI_GOTCOUNT, 0 ) ;
    m_ini->WriteInteger( datname, THREAD_INI_UNREAD, 1 ) ;
    m_ini->WriteString( datname, THREAD_INI_LASTMODIFIED, "" ) ;
    m_ini->WriteInteger( datname, THREAD_INI_DATSIZE, 0 ) ;

    if ( flush ) m_ini->UpdateFile() ;
}
//---------------------------------------------------------------------------
/** O폜
 */
void __fastcall ASubject::deleteLogList(int index, const AnsiString &datname, bool flush)
{
    if ( ! m_ini ) return ;

    deleteLog( datname, flush ) ;
    ThreadItem *item = getThreadItem( index ) ;
    item->state = threadNoLog ;
    item->countGot = 0 ;
    item->unread = 1 ;
    item->timestamp = "" ;
}
//---------------------------------------------------------------------------
/** ǈʒu擾
 */
int __fastcall ASubject::getUnreadPoint(const AnsiString &datname)
{
    if ( ! m_ini ) return 0 ;

    return m_ini->ReadInteger( datname, THREAD_INI_UNREAD, 1 ) ;
}
//---------------------------------------------------------------------------
/** ǈʒuύX
 */
int __fastcall ASubject::setUnreadPoint(const AnsiString &datname, int num, bool flush)
{
    if ( ! m_ini ) return 0 ;

    if ( num <= 0 ) // ׂēǂ񂾂Ƃɂ
    {
        int kitoku = m_ini->ReadInteger( datname, THREAD_INI_GOTCOUNT, 0 ) ;
        num = kitoku +1 ;
    }

    m_ini->WriteInteger( datname, THREAD_INI_UNREAD, num ) ;

    if ( flush ) m_ini->UpdateFile() ;

    return num ;
}
//---------------------------------------------------------------------------
/** ǈʒuύX
 */
int __fastcall ASubject::setUnreadPointList(int index, const AnsiString &datname, int num, bool flush)
{
    if ( ! m_ini ) return 0 ;

    int unread = setUnreadPoint( datname, num, flush ) ;
    ThreadItem *item = getThreadItem( index ) ;
    item->unread = unread ;
    calcState( *item ) ;
    return unread ;
}
//---------------------------------------------------------------------------
/** Xbh̏XV
 */
void __fastcall ASubject::updateThreadInfo(TMemoryStream *ms, const AnsiString &datname, const AnsiString &timestamp, bool flush)
{
    if ( ! m_ini ) return ;

    TStringList *dat = new TStringList() ;
    dat->LoadFromStream( ms ) ;
    int countRes = dat->Count ;
    delete dat ;

    m_ini->WriteInteger( datname, THREAD_INI_GOTCOUNT, countRes ) ;
    m_ini->WriteString( datname, THREAD_INI_LASTMODIFIED, timestamp ) ;
    m_ini->WriteInteger( datname, THREAD_INI_DATSIZE, ms->Size ) ;
    if ( flush ) m_ini->UpdateFile() ;
}
//---------------------------------------------------------------------------
/** Xf[^
 * "*.dat<>X (X)LF"Ɖ
 */
bool __fastcall ASubject::parseSubjectLine(char *line, AnsiString &datname, AnsiString &title, AnsiString &rescount)
{
    char *pdatname, *ptitle, *prescount ;

    pdatname = line ;
    ptitle = strchr( pdatname, '>' ) ;
    if ( ptitle == NULL ) return false ;
    *(ptitle-1) = '\0' ;
    ptitle ++ ;

    prescount = strrchr(ptitle, '(') ;
    if (prescount == NULL) return false ;
    *prescount = '\0' ;
    prescount ++ ;

    char *prescountlast = strrchr(prescount, ')') ;
    if ( prescountlast == NULL ) return false ;
    *prescountlast = '\0' ;

    datname  = pdatname ;
    title    = fixTitle( ptitle ) ;
    rescount = prescount ;

    return true ;
}
//---------------------------------------------------------------------------
/** Xbhꗗ}[W
 * @param subject subject.txtǂݍStringList
 */
void __fastcall ASubject::merge(TStringList *subject)
{
    if ( ! m_ini ) return ;

    // m̃Xbhꗗ
    TStringList *datlist = new TStringList();
    m_ini->ReadSections( datlist );

    AnsiString datname, title, countResStr, timestampStr ;
    int preNo, countGot ;
    int nowNo, countRes ;
    int c = subject->Count ;

#if 1
    //Xbh^Cg'\r'ĂTStringList͉sႤ
    for (int i=c-1; i > 1; i--)
    {
        int z = atoi( subject->Strings[i].c_str() ) ;
        if ( z == 0 )
        {
            subject->Strings[i-1] = subject->Strings[i-1].TrimRight() + subject->Strings[i] ;
            subject->Delete( i ) ;
        }
    }
    c = subject->Count;
#endif

    // }[W
    for (int i=0; i < c; i++)
    {
        if ( !parseSubjectLine( subject->Strings[i].c_str(), datname, title, countResStr ) ) continue ;
        preNo = m_ini->ReadInteger( datname, THREAD_INI_NOWNO, 0 ) ;
        nowNo = i +1 ;
        countRes = countResStr.ToIntDef( 0 ) ;
        m_ini->WriteInteger( datname, THREAD_INI_PRENO, preNo ) ;
        m_ini->WriteString( datname, THREAD_INI_NOWNO, nowNo ) ;
        m_ini->WriteString( datname, THREAD_INI_RESCOUNT, countRes ) ;

        int index = datlist->IndexOf( datname ) ;
        if ( index >= 0 )
        {
            // m̃Xbh
            datlist->Delete( index ) ; // datm邽߂ɏ
        } else {
            // VKXbh
            m_ini->WriteString( datname, THREAD_INI_TITLE, title.TrimRight() ) ;
        }
    }

    // DATXbh̏
    int dc = datlist->Count ;
    for (int i=0; i < dc; i++)
    {
        datname = datlist->Strings[i] ;
        countGot = m_ini->ReadInteger( datname, THREAD_INI_GOTCOUNT, 0 ) ;
        int unread = m_ini->ReadInteger( datname, THREAD_INI_UNREAD, 1 ) ;

        // OȂ͈ꗗ폜
        if ( countGot == 0 )
        {
            m_ini->EraseSection( datname ) ;
            continue ;
        }

        //DATĂĖǂȂ폜
        preNo = m_ini->ReadInteger( datname, THREAD_INI_PRENO, 0 ) ;
        if ( (preNo < 0) && (countGot < unread) )
        {
            // OƑݏ
            m_ini->EraseSection( datname ) ;
            DeleteFile( getLogDir() + datname ) ;
        }
        else
        {
            // DATɐݒ
            preNo = m_ini->ReadInteger( datname, THREAD_INI_NOWNO, 0 ) ;
            m_ini->WriteInteger( datname, THREAD_INI_PRENO, preNo ) ;
            m_ini->WriteString( datname, THREAD_INI_NOWNO, -1 ) ;
        }
    }

    m_ini->UpdateFile() ;
    delete datlist ;
}
//---------------------------------------------------------------------------
/** datname ̃CfbNXԂ
 */
int __fastcall ASubject::getDatIndex(const AnsiString &datname)
{
    int result = -1 ; // Ȃ
    if ( ! m_ini ) return result ;

    int c = m_list->Count ;
    for (int i=0; i < c; i++)
    {
        ThreadItem *item = getThreadItem( i ) ;
        if ( item->datname == datname )
        {
            result = i ;
            break ;
        }
    }

    return result ;
}
//---------------------------------------------------------------------------
/** Xe[^X𔻒肵Đݒ
 */
void __fastcall ASubject::calcState(ThreadItem &item)
{
    int state = threadNull ;

    if ( (item.countGot > 0) && (item.countGot >= item.unread) )
    {
		state |= threadUnread ;
	}
	else if ( (item.countGot > 0) && (item.countRes > item.countGot) )
	{
		state |= threadUnread ;
	}

	if ( item.preNo == 0 )
	{
		state |= threadNew ;
	}
	if ( item.countGot > 0 )
	{
		state |= threadLogExist ;
	}
	if ( item.countGot <= 0 )
	{
		state |= threadNoLog ;
	}
	if ( item.nowNo < 0 )
	{
		state |= threadPast ;
	}
	item.state = (ThreadState)state ;
}
//---------------------------------------------------------------------------
/** ListView ɃXbhꗗZbg
 */
void __fastcall ASubject::viewThreadList(TListView *view, unsigned int showType)
{
    if ( ! m_ini ) return ;
    if ( m_pItem ) delete[] m_pItem ;

    TStringList *datlist = new TStringList() ;
    m_ini->ReadSections( datlist ) ;
    m_pItem = new ThreadItem[ datlist->Count ] ;

    memset( &m_threadSort, 0, sizeof(m_threadSort) ) ;
    //true͏~\[g(偨)
    m_threadSort.state[0] = true ; // state
    m_threadSort.state[1] = true ; // 
    m_threadSort.state[4] = true ; // X
    m_threadSort.state[5] = true ; // 
    m_threadSort.state[6] = true ; // 

    m_list->Clear() ;
    view->Selected = NULL ;
    view->ItemFocused = NULL ;
    int uc = 0 ;
    int preuc = -1 ;
    int c = datlist->Count ;

    ThreadItem item ;
    AnsiString datname ;
    for (int i=0; i < c; i++)
    {
        // ĕ`Ԋu
        if ( ((i & 0x3f) == 0x1f) && (uc != preuc) )
        {
            view->Items->Count = m_list->Count ;
            view->Repaint() ;
            preuc = uc ;
        }

        datname = datlist->Strings[i] ;
        item.nowNo = m_ini->ReadInteger( datname, THREAD_INI_NOWNO, 0 ) ;
        item.preNo = m_ini->ReadInteger( datname, THREAD_INI_PRENO, 0 ) ;
        item.countRes = m_ini->ReadInteger(datname, THREAD_INI_RESCOUNT, 0) ;
        item.countGot = m_ini->ReadInteger( datname, THREAD_INI_GOTCOUNT, 0 ) ;
        item.unread = m_ini->ReadInteger( datname, THREAD_INI_UNREAD, 1 ) ;

        // \̑I
        calcState( item ) ;
        if ( item.state & showType )
        {
            ; // \
        }
        else
        {
            continue ;
        }

        //Xe[^X//O/^Cg/X///DAT/DAT^CX^v/DATTCY
        m_pItem[uc].state  = item.state ;
        m_pItem[uc].nowNo  = item.nowNo ;
        m_pItem[uc].preNo  = item.preNo ;
        m_pItem[uc].title  = m_ini->ReadString( datname, THREAD_INI_TITLE, "" ) ;
        m_pItem[uc].countRes = item.countRes ;
        m_pItem[uc].countGot = item.countGot ;
        m_pItem[uc].unread = item.unread ;
        m_pItem[uc].datname = datname ;
        m_pItem[uc].timestamp = m_ini->ReadString( datname, THREAD_INI_LASTMODIFIED, "" ) ;
        m_pItem[uc].datSize = m_ini->ReadInteger( datname, THREAD_INI_DATSIZE, 0 ) ;
        insertItem( m_list, &m_pItem[uc] ) ;
        uc ++;
    }

    view->Items->Count = m_list->Count ;
    delete datlist ;
    view->Repaint() ;
}
//---------------------------------------------------------------------------
/** ʂɑ}
 */
void __fastcall ASubject::insertItem(TList *list, ThreadItem *pItem)
{
    int count = list->Count ;
    if ( count == 0 )
    {
        list->Add( pItem ) ;
        return ;
    }
    
    int low = 0 ;
    int high = count -1 ;
    int no = pItem->nowNo ;
    int index ;
    
    for (;;)
    {
        if ( low == high )
        {
            index = low ;
            ThreadItem *p = (ThreadItem *)(list->Items[index]) ;
            if ( p->nowNo <= no )
            {
                index ++ ;
            }
            break ;
        }
        index = low + (high - low) / 2 ;
        ThreadItem *p = (ThreadItem *)(list->Items[index]) ;
        if ( p->nowNo <= no )
        {
            low = index +1 ;
        }
        else
        {
            high = index ;
        }
    }
    
    list->Insert( index, pItem ) ;
}
//---------------------------------------------------------------------------
/** title̓̕u
 * "&lt;" -> "<"
 * "&gt;" -> ">"
 * "&quot;" -> "\""
 */
AnsiString __fastcall ASubject::fixTitle(const AnsiString &title)
{
    TReplaceFlags f ;
    f << rfReplaceAll ; // ׂĂ̕
    AnsiString ret = title ;
    ret = StringReplace( ret, "&lt;", "<", f ) ;
    ret = StringReplace( ret, "&gt;", ">", f ) ;
    ret = StringReplace( ret, "&quot;", "\"", f ) ;
    ret = StringReplace( ret, "&amp;", "&", f ) ;
    return ret ;
}
//---------------------------------------------------------------------------
/** Xbhꗗ̃Xgڂݒ
 */
void __fastcall ASubject::getThreadListViewData(TListItem *item)
{
    if ( ! m_ini ) return ;

    if ( item->Index < m_list->Count )
    {
        ThreadItem *threadItem = getThreadItem( item->Index ) ;
        //item->Data = threadItem ;

        while ( item->SubItems->Count < 9 )
        {
            item->SubItems->Add( "" ) ;
        }

        // 
        if ( threadItem->nowNo == 0 )
        {
            item->SubItems->Strings[0] = "-"  ;
        }
        else if ( threadItem->state & threadPast )
        {
            item->SubItems->Strings[0] = "dat" ;
        }
        else
        {
            item->SubItems->Strings[0] = AnsiString( threadItem->nowNo ) ;
        }

        // O񏇈
        if ( threadItem->preNo == 0 )
        {
            item->SubItems->Strings[1] = "-" ;
        }
        else if ( threadItem->preNo < 0 )
        {
            item->SubItems->Strings[1] = "dat" ;
        }
        else
        {
            item->SubItems->Strings[1] = AnsiString( threadItem->preNo ) ;
        }

        // ^Cg
        item->SubItems->Strings[2] = threadItem->title ;

        // X
        item->SubItems->Strings[3] = AnsiString( threadItem->countRes ) ;

        // 
        item->SubItems->Strings[4] = AnsiString( threadItem->countGot ) ;

        // 
        item->SubItems->Strings[5] = AnsiString( calcUnread( threadItem->countGot, threadItem->unread ) ) ;

        // DAT^CX^v
        item->SubItems->Strings[6] = threadItem->timestamp ;

        // DATTCY
        item->SubItems->Strings[7] = FormatFloat( "0,", threadItem->datSize ) ;

        // DAT
        item->SubItems->Strings[8] = threadItem->datname ;
   }
}
//---------------------------------------------------------------------------
/** Xbhꗗ̃XgڂXV
 */
void __fastcall ASubject::updateThreadListViewData(TListItem *item)
{
    if ( ! m_ini ) return ;

    if ( item->Index < m_list->Count )
    {
        ThreadItem *threadItem = getThreadItem( item->Index ) ;
        AnsiString datname = threadItem->datname ;

        //Xe[^X//O/^Cg/X///DAT/DAT^CX^v/DATTCY
        //threadItem->state  = ;
        //threadItem->nowNo  = m_ini->ReadInteger( datname, THREAD_INI_NOWNO, 0 ) ;
        //threadItem->preNo = m_ini->ReadInteger( datname, THREAD_INI_PRENO, 0 ) ;
        //threadItem->title  = m_ini->ReadString( datname, THREAD_INI_TITLE, "" ) ;
        threadItem->countRes    = m_ini->ReadInteger(datname, THREAD_INI_RESCOUNT, 0) ;
        threadItem->countGot = m_ini->ReadInteger( datname, THREAD_INI_GOTCOUNT, 0 ) ;
        threadItem->unread = m_ini->ReadInteger( datname, THREAD_INI_UNREAD, 1 ) ;
        //threadItem->datname = datname ;
        threadItem->timestamp = m_ini->ReadString( datname, THREAD_INI_LASTMODIFIED, "" ) ;
        threadItem->datSize = m_ini->ReadInteger( datname, THREAD_INI_DATSIZE, 0 ) ;
        calcState( *threadItem ) ;

        getThreadListViewData( item ) ;
   }
}
//---------------------------------------------------------------------------
/** Xbhꗗ̃^Cg
 */
void __fastcall ASubject::search(ARegExp *regexp, TListView *view)
{
    if ( ! m_ini ) return ;

    int c = m_list->Count ;

    for (int i = c -1; i >= 0; i--)
    {
        ThreadItem* item = getThreadItem( i ) ;
        if ( regexp->match( item->title.c_str() ) == false )
        {
            m_list->Delete( i ) ;
        }
    }

    view->Items->Count = m_list->Count ;

    view->Repaint() ;
}
//---------------------------------------------------------------------------
/** ̃O猟
 * ʂHTMLԂ
 */
AnsiString __fastcall ASubject::searchLog(ARegExp *regexp, const AnsiString &itaurl, const AnsiString &itaname, PROGRESS_CALLBACK lpCallBack, long lData)
{
    AnsiString ret = "" ;
    if ( ! m_ini ) return ret ;

    TStringList *log = new TStringList() ;
    TStringList *datlist = new TStringList() ;
    m_ini->ReadSections( datlist ) ;
    AnsiString datname, title, fname ;
    int c = datlist->Count ;
    for (int i = 0; i < c; i++)
    {
        if ( lpCallBack( NULL, lData, i, c ) != 0 ) break ;
        datname = datlist->Strings[i] ;
        fname = getLogDir() + datname ;
        if ( ! FileExists( fname ) ) continue ;

        try
        {
            log->LoadFromFile( fname ) ;
            int cc = log->Count ;
            for (int j = 0; j < cc; j++)
            {
                if ( regexp->match( log->Strings[j].c_str() ) )
                {
                    title  = m_ini->ReadString( datname, THREAD_INI_TITLE, "" ) ;
                    ret += "<dd><a href=\"" ;
                    ret += itaurl ;
                    ret += ChangeFileExt( datname, "" ) ;
                    ret += "/" ;
                    ret += AnsiString( j +1 ) ;
                    ret += "\">" ;
                    ret += title ;
                    ret += "</a><br>" ;
                    break ;
                }
            }
        } catch (...) {}
    }

    /*
        <DL>
        <DT>
        <STRONG></STRONG>
        <DD>
        <a href="url">Xbh^Cg</a><br>
        </DL>
    */
    if ( ! ret.IsEmpty() )
    {
        ret = "<dl><dt><strong>" + itaname + "</strong>" + ret + "</dl>" ;
    }
    
    delete datlist ;
    delete log ;
    return ret ;
}
//---------------------------------------------------------------------------
int g_subIndex;
bool g_descend;
/** Xbhꗗ\[g
 */
void __fastcall ASubject::threadListsort(int index)
{
    bool b = m_threadSort.state[index] ;
    m_threadSort.state[index] = ! (m_threadSort.state[index]) ;
    g_subIndex = index ;
    g_descend = b ;
    m_list->Sort( ListSortFunc ) ;
}
//---------------------------------------------------------------------------

//r֐
//Item1  Item2 菬ꍇ < 0
//Item1  Item2  0
//Item1  Item2 傫ꍇ > 0
//Ԃ
//---------------------------------------------------------------------------
//֐ʎYقȂ
int __fastcall ListSortFunc(void * Item1, void * Item2)
{
    int result = 0 ;
    ThreadItem *item1 = (ThreadItem *)Item1 ;
    ThreadItem *item2 = (ThreadItem *)Item2 ;

    switch ( g_subIndex )
    {
        case indexState +1 : //ĂƂ
            result = item1->state - item2->state ;
            break ;
        case indexNowList +1 :
            result = item1->nowNo - item2->nowNo ;
            break ;
        case indexPreList +1 :
            result = item1->preNo - item2->preNo ;
            break ;
        case indexTitle +1 :
            result = item1->title.AnsiCompare( item2->title ) ;
            break ;
        case indexResCount +1 :
            result = item1->countRes - item2->countRes ;
            break ;
        case indexGotCount +1 :
            result = item1->countGot - item2->countGot ;
            break ;
        case indexUnread +1 :
        {
            int m1 = calcUnread( item1->unread, item1->unread ) ;
            int m2 = calcUnread( item2->unread, item2->unread ) ;
            result = m1 - m2 ;
            break ;
        }
        case indexTimestamp +1 : //R
            result = item1->timestamp.AnsiCompare( item2->timestamp ) ;
            break ;
        case indexDatSize +1 :
            result = item1->datSize - item2->datSize ;
            break ;
        case indexDatname +1 :
            result = item1->datname.AnsiCompare( item2->datname ) ;
            break ;
    }

    if ( g_descend ) result = 0 - result ;

    return result ;
}
//---------------------------------------------------------------------------
/** URL𓾂
 */
AnsiString __fastcall ASubject::getBBSurl(void)
{
    AnsiString host, path;
    parseLocalUrl( getLogDir(), host, path ) ;

    // host: "pc.2ch.net"
    // path: "/win/"
    // url: http://pc.2ch.net/win/
    return (AnsiString)"http://" + host + path ;
}
//---------------------------------------------------------------------------
/** subject.txt ̃^CX^v擾
 */
AnsiString __fastcall ASubject::getSubjectTimestamp()
{
    TMemIniFile *ini = new TMemIniFile( getLogDir() + FILENAME_BBS_INI ) ;
    AnsiString result = ini->ReadString( FILENAME_SUBJECT_TXT, THREAD_INI_LASTMODIFIED, "" ) ;
    delete ini ;
    return result ;
}
//---------------------------------------------------------------------------
/** subject.txt ̃^CX^vۑ
 */
void __fastcall ASubject::setSubjectTimestamp(const AnsiString &time)
{
    TMemIniFile *ini = new TMemIniFile( getLogDir() + FILENAME_BBS_INI ) ;
    ini->WriteString( FILENAME_SUBJECT_TXT, THREAD_INI_LASTMODIFIED, time.Trim() ) ;
    ini->UpdateFile() ;
    delete ini ;
}
//---------------------------------------------------------------------------
/** XbhꗗXV
 */
bool __fastcall ASubject::reload()
{
    if ( ! m_ini ) return false ;
    if ( m_call != NULL )
    {
        m_call->abort = true ;
        return false;
    }

    AnsiString url = getBBSurl() ;
    AnsiString lastModifiedTime = getSubjectTimestamp() ;

    TMemoryStream *ms = new TMemoryStream() ;
    int ret ;
{ /* AHttpSock̎ */
    AHttpSock http ;
    m_call = new CALL_PACK() ;
    http.setCallback( (long)m_call, subjectCallback ) ;
    ret = http.download( g_cache.getUrl(url) + FILENAME_SUBJECT_TXT, ms, lastModifiedTime, g_subjectGzip ) ;
}
    bool result = false ;
    //TODO i⎸sȂǂ̕\
    if ( ret >= 0 )
    {
        ms->Position = 0 ;
        if ( ret == 0 && ms->Size != 0 )
        {
            // 擾
            ms->SaveToFile( getLogDir() + FILENAME_SUBJECT_TXT ) ; // mFp
            char dg = *((char*)ms->Memory) ;
            if ( isdigit(dg) == 0 )
            {
                // wȃXbhꗗł...
            }
            else
            {
                // ꗗXV
                TStringList *list = new TStringList() ;
                list->LoadFromStream( ms ) ;
                merge( list ) ;
                delete list ;
                setSubjectTimestamp( lastModifiedTime ) ;
                result = true ;
            }
        }
    }

    delete ms ;
    delete m_call ;
    m_call = NULL ;

    return result ;
}
//---------------------------------------------------------------------------
/** 擾XȂ dat 擾
 */
bool __fastcall ASubject::ifUnreadDoReload(const AnsiString &datname)
{
    int countRes = m_ini->ReadInteger( datname, THREAD_INI_RESCOUNT, 0 ) ;
    int countGot = m_ini->ReadInteger( datname, THREAD_INI_GOTCOUNT, 0 ) ;
    if ( (countRes == 0) || (countRes > countGot) )
    {
        return reloadDat( datname ) ;
    }
    return false ;
}
//---------------------------------------------------------------------------
/** Xbh dat XV
 */
bool __fastcall ASubject::reloadDat(const AnsiString &datname)
{
    AnsiString url = g_cache.getUrl( getBBSurl() ) + "dat/" + datname ;
    AnsiString logfilename = getLogDir() + datname ;
    AnsiString lastModifiedTime = m_ini->ReadString( datname, THREAD_INI_LASTMODIFIED, "" ) ;

    TMemoryStream *ms = new TMemoryStream();
    int dret;
{ /* AHttpSock̎ */
    AHttpSock http ;
    m_call = new CALL_PACK();
    http.setCallback( (long)m_call, subjectCallback ) ;

    if ( FileExists( logfilename ) )
    {
        ms->LoadFromFile( logfilename ) ;
        ms->Seek( 0, soFromEnd ) ;
        dret = http.rangeDownload( url, ms, lastModifiedTime, true ) ;
    }
    else
    {
        dret = http.download( url, ms, lastModifiedTime) ;
    }
    //http.release() ;
}
    //TODO i⎸s̕\
    bool result = false ;
    if ( dret == 0 && ms->Size != 0 )
    {
        // 擾܂
        ms->Position = 0 ;
        ms->SaveToFile( logfilename ) ;
        updateThreadInfo( ms, datname, lastModifiedTime ) ;
        result = true ;
    }
    else
    {
        if ( dret == 1 )
        {
            // XVĂ܂
        }
        else if ( dret == 2 )
        {
            //Status-Code = 302
            // dat
        }
        else
        {
            // 擾Ɏs
        }
    }

    delete ms ;
    delete m_call ;
    m_call = NULL ;

    return result ;
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
/** LbVT[õ`FbNΏۂ̃T[oǂ
 * @param url 擾URL
 * @return 0:Ώ 1:server1 2:server2
 */
int __fastcall ACacheServer::IsCachedEnabled(const AnsiString &url)
{
    if ( g_CacheServerEnable )
    {
        int index = url.AnsiPos( g_CacheServerMatch ) ;
        if ( index != 0 ) return 1 ;
    }

    return 0 ;
}
//---------------------------------------------------------------------------
/** HTML̃N
 * LbVĂ̃Xg쐬
 * @param html T[o[̃fBNgHTML(NULLI[)
 */
void __fastcall ACacheServer::perseServerDir(char *html)
{
    char *p = html ;
    for (;;)
    {
        char *tag = strchr( p, '<' ) ;
        if ( tag == NULL ) break ;
        tag ++ ;
        if (   (*(WORD*)tag == 0x2061 /*"a "*/)
            || (*(WORD*)tag == 0x2041 /*"A "*/)
        )
        {
            char *path = strchr( tag +1, '>' ) ;
            if ( path == NULL ) break ;
            path ++ ;
            char *nul = strchr( path, '<' ) ;
            if ( nul == NULL ) break ;
            /* N̍Ōオ"/"Ȃǉ */
            if ( *(nul -1) == '/' )
            {
                *nul = '\0' ;
                m_cacheBoardList->Add( path ) ;
            }
            p = nul ;
        }
        p ++ ;
    }
}
//---------------------------------------------------------------------------
/** ̃LbVURL𓾂
 * @param url 擾URL
 * @return LbVT[oɖ̏ꍇ͈ƓURLԂ
 */
AnsiString __fastcall ACacheServer::getUrl(const AnsiString &url)
{
    AnsiString result = url ;
    int server = IsCachedEnabled( url ) ;

    if ( server > 0 )
    {
        AnsiString host ;
        AnsiString path ;
        ::parseUrl( url.c_str(), host, path ) ;
        path.Delete( 1, 1 ) ;
        int index = path.AnsiPos( "/" ) ;
        if ( index != 0 )
        {
            path = path.SubString( 1, index ) ;
            if ( server == 1 )
            {
                AnsiString cachedurl = "http://" + g_CacheServerHost + "/" ;
                if ( m_cacheBoardList == NULL )
                {
                    CALL_PACK call ;
                    ::subjectCallback( "LbVT[oꗗ擾...", (long)&call, 0, 0 ) ;
                    TMemoryStream *ms = new TMemoryStream() ;

                    AHttpSock http ;
                    http.setCallback( (long)&call, subjectCallback ) ;
                    AnsiString dattime = "" ;
                    int ret = http.download( cachedurl, ms, dattime ) ;
                    if ( ret != 0 )
                    {
                        ::MessageBox( NULL, "LbVT[o̈ꗗ_E[hł܂łB\n̂܂܉{𑱂ꍇAǂݏK\܂B", "x", MB_OK | MB_ICONEXCLAMATION ) ;
                        return result ;
                    }
                    else
                    {
                        ::subjectCallback( "LbVꗗ擾܂.", (long)&call, 0, 0 ) ;
                        //ms->SaveToFile( g_global.getExeDir() + "log\\cache.html" ) ;
                        ms->Write( "\0", 1 ) ;
                        m_cacheBoardList = new THashedStringList() ;
                        perseServerDir( (char*)ms->Memory ) ;
                        //m_cacheBoardList->SaveToFile( g_global.getExeDir() + "log\\cache.txt" ) ;
                    }
                    delete ms ;
                }
                if ( m_cacheBoardList->IndexOf( path ) >= 0 )
                {
                    result = cachedurl + path ;
                }
            }
        }
    }

    return result ;
}
//---------------------------------------------------------------------------

