//---------------------------------------------------------------------------
/** K\}l[Wv2
 * for HmJre.dll only
 *
 * 1.open() Ōݒ肷B
 * 2.match() Ń}b`OB
 * 3.Iclose()B
 */
/*
 * Copyright (c) 2004, 2005 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#ifndef myregexp_h
#define myregexp_h

#include <vcl.h>
#include "misc.h"

/* for HmJre */
#include "jre/JREUSR.h"
#include "jre/JreFuzzy.h"

/* DLL functions */
typedef WORD (__stdcall *FJreGetVersion)(void) ;
typedef BOOL (__stdcall *FFuzzy_Open)(JREFUZZYDATA* pData, BOOL fDummy) ;
typedef BOOL (__stdcall *FFuzzy_Close)(JREFUZZYDATA* pData) ;
typedef BOOL (__stdcall *FFuzzy_ConvertTarget)(JREFUZZYDATA* pData, const char* pszSrc) ;
typedef BOOL (__stdcall *FFuzzy_ConvertFindString)(JREFUZZYDATA* pData, const char* pszSrc, BOOL fRegular) ;
typedef BOOL (_cdecl *FFuzzy_OptionDialog)(HWND hwndParent, UINT flagsDisable) ;
typedef BOOL (__stdcall *FJre2Open)(LPJRE2 lpjreJre) ;
typedef BOOL (__stdcall *FJre2Compile)(LPJRE2 lpjreJre, LPSTR lpszRe) ;
typedef BOOL (__stdcall *FJre2GetMatchInfo)(LPJRE2 lpjreJre, LPSTR lpszStr) ;
typedef BOOL (__stdcall *FJre2Close)(LPJRE2 lpjreJre) ;

class ARegExp
{
public:
	ARegExp() ;
	~ARegExp() ;
    AnsiString getVerString(void) ;
    bool open(const char *keyStr, bool nocase) ;
    void close(void)
    {
        if ( Fuzzy_Close ) Fuzzy_Close( &m_fuz ) ;
        if ( Jre2Close ) Jre2Close( &m_jre2 ) ;
    }
    bool match(const char *srcStr) ;
    void showOptionDialog(HWND hwnd)
    {
        if ( Fuzzy_OptionDialog ) Fuzzy_OptionDialog( hwnd, 0 ) ;
    }
    const AnsiString& getKeyString()
    {
        return m_keyStr ;
    }
private:
    AnsiString m_keyStr ; // L[ێ
	HANDLE m_hdll ;
    JREFUZZYDATA m_fuz ;
    JRE2 m_jre2 ;

    /* DLL functions */
    FJreGetVersion JreGetVersion ;
    FFuzzy_Open Fuzzy_Open ;
    FFuzzy_Close Fuzzy_Close ;
    FFuzzy_ConvertTarget Fuzzy_ConvertTarget ;
    FFuzzy_ConvertFindString Fuzzy_ConvertFindString ;
    FFuzzy_OptionDialog Fuzzy_OptionDialog ;
    FJre2Open Jre2Open ;
    FJre2Compile Jre2Compile ;
    FJre2GetMatchInfo Jre2GetMatchInfo ;
    FJre2Close Jre2Close ;

	bool getFuncAdress(const HANDLE hdll) ;
} ;

#endif /* regexp.h */

